
/*
 * $Id$
 * 
 * Copyright (C) PI 2007-2008. All rights reserved.
 * 
 * Version: 1.0.3
 * 
 */

/**
 * \mainpage
 * Documentation of the PI EDD-Library
 * 
 * \section Introduction Introduction
 * This EDD-Library can be used to write an EDD for PROFIBUS devices which used the PA-Profile Version 3.01.
 * The EDD-Library is a set of ASCII files that can be used by any IEC 61804-3 profile PROFIBUS compatible EDD 
 * interpreter.
 * \section use_of_library How the library can be used
 * The library is designed to be used in conjunction with the IMPORT statement of the EDD language. The files are 
 * organised in a hierachical manner sorted by their block type (PHYSICAL, TRANSDUCER and FUNCTION BLOCK) and 
 * their instance number of the block type. For each type 15 instances are predefined. The only exception is the 
 * physical block. This block exists only once in every device for each type and thus needs only 1 instance inside the library.
 * For each block (type and instance) the library contains a fixed import file and therefore a specific 
 * import reference mechanism. 
 * The import takes place with IMPORT directive and the corresponding values for the following attributes: 
 * - MANUFACTURER    : is set to __STANDARD to indicate a reference to the PI EDD-Library
 * - DEVICE_TYPE     : reference to the specific block type and instance 
 * - DEVICE_REVISION : specify the profile version (use 0x0301 for this version of PI EDD-Library)
 * - DD_REVISION     : specify the version of the EDD-Library (0x0001 is the first version of the library)
 * .
 * Example for an import of Physical Block:
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __PHYSICAL_TRANSMITTER, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0001
 * {
 *   ...;
 * }
 * \endcode 
 * 
 * \section device_type Available DEVICE_TYPE
 * A different DEVICE_TYPE for each type and instance of blocks must be used. The DEVICE_TYPE consists of two parts.
 * The first part (byte) of DEVICE_TYPE defines the type of block, for example PB-Analyser, TB-Temperature, FB-Analog Input and so on.
 * The second part (byte) defines the instance number for this type of block, 1 is the reference to the first instance.
 * The file 'pa_import.h' contains a list of all available DEVICE_TYPEs.
 * 
 * \subsection phys_device_types Physical Block
 * The following DEVICE_TYPEs for Physical Blocks are defined:
 * - __PHYSICAL_TRANSMITTER
 * - __PHYSICAL_ACTUATOR
 * - __PHYSICAL_DISCRETE_IO
 * - __PHYSICAL_CONTROLLER
 * - __PHYSICAL_ANALYZER
 * - __PHYSICAL_LAB_DEVICE
 * .
 * \subsection trans_device_types Transducer Block
 * The following DEVICE_TYPEs for Transducer Blocks are defined:
 * - __TRANS1_TEMP
 * - __TRANS2_TEMP
 * - __TRANS3_TEMP
 * - __TRANS4_TEMP
 * - __TRANS5_TEMP
 * - __TRANS6_TEMP
 * - __TRANS7_TEMP
 * - __TRANS8_TEMP
 * - __TRANS9_TEMP
 * - __TRANS10_TEMP
 * - __TRANS11_TEMP
 * - __TRANS12_TEMP
 * - __TRANS13_TEMP
 * - __TRANS14_TEMP
 * - __TRANS15_TEMP
 * - __TRANS1_PRESS
 * - __TRANS2_PRESS
 * - __TRANS3_PRESS
 * - __TRANS4_PRESS
 * - __TRANS5_PRESS
 * - __TRANS6_PRESS
 * - __TRANS7_PRESS
 * - __TRANS8_PRESS
 * - __TRANS9_PRESS
 * - __TRANS10_PRESS
 * - __TRANS11_PRESS
 * - __TRANS12_PRESS
 * - __TRANS13_PRESS
 * - __TRANS14_PRESS
 * - __TRANS15_PRESS
 * - __TRANS1_FLOWCM
 * - __TRANS2_FLOWCM
 * - __TRANS3_FLOWCM
 * - __TRANS4_FLOWCM
 * - __TRANS5_FLOWCM
 * - __TRANS6_FLOWCM
 * - __TRANS7_FLOWCM
 * - __TRANS8_FLOWCM
 * - __TRANS9_FLOWCM
 * - __TRANS10_FLOWCM
 * - __TRANS11_FLOWCM
 * - __TRANS12_FLOWCM
 * - __TRANS13_FLOWCM
 * - __TRANS14_FLOWCM
 * - __TRANS15_FLOWCM
 * - __TRANS1_FLOWE
 * - __TRANS2_FLOWE
 * - __TRANS3_FLOWE
 * - __TRANS4_FLOWE
 * - __TRANS5_FLOWE
 * - __TRANS6_FLOWE
 * - __TRANS7_FLOWE
 * - __TRANS8_FLOWE
 * - __TRANS9_FLOWE
 * - __TRANS10_FLOWE
 * - __TRANS11_FLOWE
 * - __TRANS12_FLOWE
 * - __TRANS13_FLOWE
 * - __TRANS14_FLOWE
 * - __TRANS15_FLOWE
 * - __TRANS1_FLOWTM
 * - __TRANS2_FLOWTM
 * - __TRANS3_FLOWTM
 * - __TRANS4_FLOWTM
 * - __TRANS5_FLOWTM
 * - __TRANS6_FLOWTM
 * - __TRANS7_FLOWTM
 * - __TRANS8_FLOWTM
 * - __TRANS9_FLOWTM
 * - __TRANS10_FLOWTM
 * - __TRANS11_FLOWTM
 * - __TRANS12_FLOWTM
 * - __TRANS13_FLOWTM
 * - __TRANS14_FLOWTM
 * - __TRANS15_FLOWTM
 * - __TRANS1_FLOWU
 * - __TRANS2_FLOWU
 * - __TRANS3_FLOWU
 * - __TRANS4_FLOWU
 * - __TRANS5_FLOWU
 * - __TRANS6_FLOWU
 * - __TRANS7_FLOWU
 * - __TRANS8_FLOWU
 * - __TRANS9_FLOWU
 * - __TRANS10_FLOWU
 * - __TRANS11_FLOWU
 * - __TRANS12_FLOWU
 * - __TRANS13_FLOWU
 * - __TRANS14_FLOWU
 * - __TRANS15_FLOWU
 * - __TRANS1_FLOWVA
 * - __TRANS2_FLOWVA
 * - __TRANS3_FLOWVA
 * - __TRANS4_FLOWVA
 * - __TRANS5_FLOWVA
 * - __TRANS6_FLOWVA
 * - __TRANS7_FLOWVA
 * - __TRANS8_FLOWVA
 * - __TRANS9_FLOWVA
 * - __TRANS10_FLOWVA
 * - __TRANS11_FLOWVA
 * - __TRANS12_FLOWVA
 * - __TRANS13_FLOWVA
 * - __TRANS14_FLOWVA
 * - __TRANS15_FLOWVA
 * - __TRANS1_FLOWV
 * - __TRANS2_FLOWV
 * - __TRANS3_FLOWV
 * - __TRANS4_FLOWV
 * - __TRANS5_FLOWV
 * - __TRANS6_FLOWV
 * - __TRANS7_FLOWV
 * - __TRANS8_FLOWV
 * - __TRANS9_FLOWV
 * - __TRANS10_FLOWV
 * - __TRANS11_FLOWV
 * - __TRANS12_FLOWV
 * - __TRANS13_FLOWV
 * - __TRANS14_FLOWV
 * - __TRANS15_FLOWV
 * - __TRANS1_LEVEL
 * - __TRANS2_LEVEL
 * - __TRANS3_LEVEL
 * - __TRANS4_LEVEL
 * - __TRANS5_LEVEL
 * - __TRANS6_LEVEL
 * - __TRANS7_LEVEL
 * - __TRANS8_LEVEL
 * - __TRANS9_LEVEL
 * - __TRANS10_LEVEL
 * - __TRANS11_LEVEL
 * - __TRANS12_LEVEL
 * - __TRANS13_LEVEL
 * - __TRANS14_LEVEL
 * - __TRANS15_LEVEL
 * - __TRANS1_ACTUATOR
 * - __TRANS2_ACTUATOR
 * - __TRANS3_ACTUATOR
 * - __TRANS4_ACTUATOR
 * - __TRANS5_ACTUATOR
 * - __TRANS6_ACTUATOR
 * - __TRANS7_ACTUATOR
 * - __TRANS8_ACTUATOR
 * - __TRANS9_ACTUATOR
 * - __TRANS10_ACTUATOR
 * - __TRANS11_ACTUATOR
 * - __TRANS12_ACTUATOR
 * - __TRANS13_ACTUATOR
 * - __TRANS14_ACTUATOR
 * - __TRANS15_ACTUATOR
 * - __TRANS1_PNEUMATICACTUATOR
 * - __TRANS2_PNEUMATICACTUATOR
 * - __TRANS3_PNEUMATICACTUATOR
 * - __TRANS4_PNEUMATICACTUATOR
 * - __TRANS5_PNEUMATICACTUATOR
 * - __TRANS6_PNEUMATICACTUATOR
 * - __TRANS7_PNEUMATICACTUATOR
 * - __TRANS8_PNEUMATICACTUATOR
 * - __TRANS9_PNEUMATICACTUATOR
 * - __TRANS10_PNEUMATICACTUATOR
 * - __TRANS11_PNEUMATICACTUATOR
 * - __TRANS12_PNEUMATICACTUATOR
 * - __TRANS13_PNEUMATICACTUATOR
 * - __TRANS14_PNEUMATICACTUATOR
 * - __TRANS15_PNEUMATICACTUATOR
 * - __TRANS1_DI
 * - __TRANS2_DI
 * - __TRANS3_DI
 * - __TRANS4_DI
 * - __TRANS5_DI
 * - __TRANS6_DI
 * - __TRANS7_DI
 * - __TRANS8_DI
 * - __TRANS9_DI
 * - __TRANS10_DI
 * - __TRANS11_DI
 * - __TRANS12_DI
 * - __TRANS13_DI
 * - __TRANS14_DI
 * - __TRANS15_DI
 * - __TRANS1_DO
 * - __TRANS2_DO
 * - __TRANS3_DO
 * - __TRANS4_DO
 * - __TRANS5_DO
 * - __TRANS6_DO
 * - __TRANS7_DO
 * - __TRANS8_DO
 * - __TRANS9_DO
 * - __TRANS10_DO
 * - __TRANS11_DO
 * - __TRANS12_DO
 * - __TRANS13_DO
 * - __TRANS14_DO
 * - __TRANS15_DO
 * - __TRANS1_ANALYSIS
 * - __TRANS2_ANALYSIS
 * - __TRANS3_ANALYSIS
 * - __TRANS4_ANALYSIS
 * - __TRANS5_ANALYSIS
 * - __TRANS6_ANALYSIS
 * - __TRANS7_ANALYSIS
 * - __TRANS8_ANALYSIS
 * - __TRANS9_ANALYSIS
 * - __TRANS10_ANALYSIS
 * - __TRANS11_ANALYSIS
 * - __TRANS12_ANALYSIS
 * - __TRANS13_ANALYSIS
 * - __TRANS14_ANALYSIS
 * - __TRANS15_ANALYSIS
 * - __TRANS1_TRANSFER
 * - __TRANS2_TRANSFER
 * - __TRANS3_TRANSFER
 * - __TRANS4_TRANSFER
 * - __TRANS5_TRANSFER
 * - __TRANS6_TRANSFER
 * - __TRANS7_TRANSFER
 * - __TRANS8_TRANSFER
 * - __TRANS9_TRANSFER
 * - __TRANS10_TRANSFER
 * - __TRANS11_TRANSFER
 * - __TRANS12_TRANSFER
 * - __TRANS13_TRANSFER
 * - __TRANS14_TRANSFER
 * - __TRANS15_TRANSFER
 * - __TRANS1_CONTROL_PH
 * - __TRANS2_CONTROL_PH
 * - __TRANS3_CONTROL_PH
 * - __TRANS4_CONTROL_PH
 * - __TRANS5_CONTROL_PH
 * - __TRANS6_CONTROL_PH
 * - __TRANS7_CONTROL_PH
 * - __TRANS8_CONTROL_PH
 * - __TRANS9_CONTROL_PH
 * - __TRANS10_CONTROL_PH
 * - __TRANS11_CONTROL_PH
 * - __TRANS12_CONTROL_PH
 * - __TRANS13_CONTROL_PH
 * - __TRANS14_CONTROL_PH
 * - __TRANS15_CONTROL_PH
 * - __TRANS1_CONTROL_COND
 * - __TRANS2_CONTROL_COND
 * - __TRANS3_CONTROL_COND
 * - __TRANS4_CONTROL_COND
 * - __TRANS5_CONTROL_COND
 * - __TRANS6_CONTROL_COND
 * - __TRANS7_CONTROL_COND
 * - __TRANS8_CONTROL_COND
 * - __TRANS9_CONTROL_COND
 * - __TRANS10_CONTROL_COND
 * - __TRANS11_CONTROL_COND
 * - __TRANS12_CONTROL_COND
 * - __TRANS13_CONTROL_COND
 * - __TRANS14_CONTROL_COND
 * - __TRANS15_CONTROL_COND
 * - __TRANS1_CONTROL_OXYG
 * - __TRANS2_CONTROL_OXYG
 * - __TRANS3_CONTROL_OXYG
 * - __TRANS4_CONTROL_OXYG
 * - __TRANS5_CONTROL_OXYG
 * - __TRANS6_CONTROL_OXYG
 * - __TRANS7_CONTROL_OXYG
 * - __TRANS8_CONTROL_OXYG
 * - __TRANS9_CONTROL_OXYG
 * - __TRANS10_CONTROL_OXYG
 * - __TRANS11_CONTROL_OXYG
 * - __TRANS12_CONTROL_OXYG
 * - __TRANS13_CONTROL_OXYG
 * - __TRANS14_CONTROL_OXYG
 * - __TRANS15_CONTROL_OXYG
 * - __TRANS1_LIMIT
 * - __TRANS2_LIMIT
 * - __TRANS3_LIMIT
 * - __TRANS4_LIMIT
 * - __TRANS5_LIMIT
 * - __TRANS6_LIMIT
 * - __TRANS7_LIMIT
 * - __TRANS8_LIMIT
 * - __TRANS9_LIMIT
 * - __TRANS10_LIMIT
 * - __TRANS11_LIMIT
 * - __TRANS12_LIMIT
 * - __TRANS13_LIMIT
 * - __TRANS14_LIMIT
 * - __TRANS15_LIMIT
 * - __TRANS1_ALARM
 * - __TRANS2_ALARM
 * - __TRANS3_ALARM
 * - __TRANS4_ALARM
 * - __TRANS5_ALARM
 * - __TRANS6_ALARM
 * - __TRANS7_ALARM
 * - __TRANS8_ALARM
 * - __TRANS9_ALARM
 * - __TRANS10_ALARM
 * - __TRANS11_ALARM
 * - __TRANS12_ALARM
 * - __TRANS13_ALARM
 * - __TRANS14_ALARM
 * - __TRANS15_ALARM
 * .
 * \subsection func_device_types Function Block
 * The following DEVICE_TYPEs for Function Blocks are defined:
 * - __FUNC1_AI
 * - __FUNC2_AI
 * - __FUNC3_AI
 * - __FUNC4_AI
 * - __FUNC5_AI
 * - __FUNC6_AI
 * - __FUNC7_AI
 * - __FUNC8_AI
 * - __FUNC9_AI
 * - __FUNC10_AI
 * - __FUNC11_AI
 * - __FUNC12_AI
 * - __FUNC13_AI
 * - __FUNC14_AI
 * - __FUNC15_AI
 * - __FUNC1_TOT
 * - __FUNC2_TOT
 * - __FUNC3_TOT
 * - __FUNC4_TOT
 * - __FUNC5_TOT
 * - __FUNC6_TOT
 * - __FUNC7_TOT
 * - __FUNC8_TOT
 * - __FUNC9_TOT
 * - __FUNC10_TOT
 * - __FUNC11_TOT
 * - __FUNC12_TOT
 * - __FUNC13_TOT
 * - __FUNC14_TOT
 * - __FUNC15_TOT
 * - __FUNC1_AO
 * - __FUNC2_AO
 * - __FUNC3_AO
 * - __FUNC4_AO
 * - __FUNC5_AO
 * - __FUNC6_AO
 * - __FUNC7_AO
 * - __FUNC8_AO
 * - __FUNC9_AO
 * - __FUNC10_AO
 * - __FUNC11_AO
 * - __FUNC12_AO
 * - __FUNC13_AO
 * - __FUNC14_AO
 * - __FUNC15_AO
 * - __FUNC1_DI
 * - __FUNC2_DI
 * - __FUNC3_DI
 * - __FUNC4_DI
 * - __FUNC5_DI
 * - __FUNC6_DI
 * - __FUNC7_DI
 * - __FUNC8_DI
 * - __FUNC9_DI
 * - __FUNC10_DI
 * - __FUNC11_DI
 * - __FUNC12_DI
 * - __FUNC13_DI
 * - __FUNC14_DI
 * - __FUNC15_DI
 * - __FUNC1_DO
 * - __FUNC2_DO
 * - __FUNC3_DO
 * - __FUNC4_DO
 * - __FUNC5_DO
 * - __FUNC6_DO
 * - __FUNC7_DO
 * - __FUNC8_DO
 * - __FUNC9_DO
 * - __FUNC10_DO
 * - __FUNC11_DO
 * - __FUNC12_DO
 * - __FUNC13_DO
 * - __FUNC14_DO
 * - __FUNC15_DO
 * - __FUNC1_LOGBOOK
 * - __FUNC2_LOGBOOK
 * - __FUNC3_LOGBOOK
 * - __FUNC4_LOGBOOK
 * - __FUNC5_LOGBOOK
 * - __FUNC6_LOGBOOK
 * - __FUNC7_LOGBOOK
 * - __FUNC8_LOGBOOK
 * - __FUNC9_LOGBOOK
 * - __FUNC10_LOGBOOK
 * - __FUNC11_LOGBOOK
 * - __FUNC12_LOGBOOK
 * - __FUNC13_LOGBOOK
 * - __FUNC14_LOGBOOK
 * - __FUNC15_LOGBOOK
 * .
 * 
 * \subsection adapt_block_number As the block numbers to be adapted
 * The block number of the imported block is predefined to this specific instance number.
 * This number must be redefined for an import to the device specific EDD (order of the blocks).
 * This depends on the device, how many blocks are used inside the device and how the 
 * EDD-Developer wants to use the EDD-Library.
 * 
 * \section import_m_o_para_cmd Import of mandatory and optional parameter and commands
 * For many blocks it is possible to use predefined macros for import of mandatory and/or optional parameter and commands.
 * The following example is an import of a Physical Block Transmitter with all mandatory parameters and commands defined in the profile definition.
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __PHYSICAL_TRANSMITTER, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0001
 * {
 *   USE_PHYS_MANDATORY_B;
 * }
 * \endcode 
 * Further macro definitions can be found in file 'pa_import.h'.
 *
 * \note Please check and edit the predefined ranges, default values, edit formats, display formats and units of imported variables!
 *
 * \section upload_download Upload and Download
 * The upload and download menu of the device must be compiled from parts of all used blocks.
 * Each import file for a block type and instance contains a documentation of the necessary parameter and 
 * the order of this for upload and download. 
 * \subsection upload_download_change_mode Change the Mode for upload
 * For same parameters it is necessary to switch the mode of the block to MAN. The following example contains this for two
 * analog input function blocks before writing parameter to the device and restore the old mode of this blocks behind the upload.
 * \code
 * MENU upload_variables
 * {
 *   LABEL  [menu_load_to_device];
 *   ITEMS
 *   {
 *     ......
 *   }
 *   PRE_WRITE_ACTIONS
 *   {
 *     prewrite2device
 *   }
 *   POST_WRITE_ACTIONS
 *   {
 *     postwrite2device
 *   }
 * }
 *
 * VARIABLE var_local_func1_AI_MODE_BLK_Actual
 * {
 *   LABEL "";
 *   CLASS LOCAL;
 *   TYPE UNSIGNED_INTEGER (1);
 * }
 * var_local_func2_AI_MODE_BLK_Actual LIKE var_local_func1_AI_MODE_BLK_Actual
 * { REDEFINE LABEL "";}
 *
 * VARIABLE switch_to_MAN_mode
 * {
 *   LABEL  "switch_to_MAN_mode";
 *   CLASS  CONTAINED;
 *   TYPE   ENUMERATED
 *   {
 *     {0,"inactive"},
 *     {1,"active"}
 *   }
 * }
 *
 * METHOD prewrite2device
 * {
 *   LABEL  "";
 *   DEFINITION
 *   {
 *     int choice;
 *
 *     switch_to_MAN_mode=0;
 *     ReadCommand(func1_AI_MODE_BLK_read);
 *     ReadCommand(func2_AI_MODE_BLK_read);
 *     if(func1_AI_MODE_BLK_Actual != 0x10 || func1_AI_MODE_BLK_Actual != 0x10)
 *     {
 *       choice = SELECT_FROM_LIST ("Switch Function Blocks to MAN-Mode?","Cancel;Continue");
 *       if(choice == 1)
 *       {
 *         var_local_func1_AI_MODE_BLK_Actual = func1_AI_MODE_BLK_Actual;
 *         var_local_func2_AI_MODE_BLK_Actual = func2_AI_MODE_BLK_Actual;
 *         func1_AI_TARGET_MODE = 0x10;
 *         func2_AI_TARGET_MODE = 0x10;
 *         WriteCommand(func1_AI_TARGET_MODE_write);
 *         WriteCommand(func2_AI_TARGET_MODE_write);
 *         switch_to_MAN_mode=1;
 *       }
 *     }
 *   }
 * }
 *
 *
 * METHOD postwrite2device
 * {
 *   LABEL  "";
 *   DEFINITION
 *   {
 *     if (switch_to_MAN_mode==1)
 *     {
 *       DELAY(1,"Restoring FB-mode"); 
 *       func1_AI_TARGET_MODE=var_local_func1_AI_MODE_BLK_Actual;
 *       func2_AI_TARGET_MODE=var_local_func2_AI_MODE_BLK_Actual;
 *       WriteCommand(func1_AI_TARGET_MODE_write);
 *       WriteCommand(func2_AI_TARGET_MODE_write);
 *       switch_to_MAN_mode=0;
 *     }
 *   }
 * }
 * \endcode
 *
 * \section Example Simple Example
 * The following simple example shows the use of 1 Physical Block, 
 * 1 Temperature Transducer Block of type thermocouple, 1 Pressure Transducer Block, 2 Function Blocks 
 * and 1 Totalizer Block from the Library.
 * \subsection Include Necessary Include
 * To use the library it is necessary to include the following file. 
 * \code
 * #include "pa_import.h"
 * \endcode
 *
 * \subsection Device_Information Device Information
 * The following definitions are necessary for all EDDs.
 * \code
 * MANUFACTURER     your manufacturer code, 
 * DEVICE_TYPE      your device type, 
 * DEVICE_REVISION  your device revision,
 * DD_REVISION      your DD revision
 * \endcode
 *
 * \subsection Example_Import_PB Import a specific type of Physical Block
 * First import a type of physical block. The following types are possible.
 * - __PHYSICAL_TRANSMITTER
 * - __PHYSICAL_ACTUATOR
 * - __PHYSICAL_DISCRETE_IO
 * - __PHYSICAL_CONTROLLER
 * - __PHYSICAL_ANALYZER
 * - __PHYSICAL_LAB_DEVICE
 * .
 * 
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __PHYSICAL_TRANSMITTER, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0001
 * {
 *   USE_PHYS_MANDATORY_B;
 *   USE_PHYS_OPTIONAL_B;
 * }
 * \endcode
 * Over the defined macros (pa_import.h) you can add the VARIABLE definitions, the COMMAND definitions and predefinied MENU definitions.
 * 
 * \note Please check and edit the predefined ranges, default values, edit formats and display formats of imported variables!
 *
 * \subsection Example_Import_TB Import of Transducer Block
 * 
 * \subsubsection Example_Import_TB_Temp Temperature Transducer Block
 * The following example imports the Temperature Transducer Block with all mandatory and optional parameter 
 * for type thermocouple. This block must be the first transducer block in the device directory, 
 * otherwise the BLOCK number must be redefined (see the following block)
 * \code
 * STANDARD, DEVICE_TYPE __TRANS1_TEMP, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0001
 * {
 *   USE_TRANS1_TEMP_MANDATORY_B;
 *   USE_TRANS1_TEMP_OPTIONAL_B;
 *   USE_TRANS1_TEMP_THERMOCOUPLE_MANDATORY_B;
 *   USE_TRANS1_TEMP_THERMOCOUPLE_OPTIONAL_B;
 * }
 * \endcode
 * 
 * \subsubsection Example_Import_TB_Press Pressure Transducer Block
 * The following example imports the Pressure Transducer Block with all elements and redefine the BLOCK 
 * number for the second transducer block in the device directory.
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __TRANS1_PRESS, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0001
 * {
 *   EVERYTHING;
 *   REDEFINITIONS
 *   {
 *     BLOCK trans1_Press_block
 *     {
 *       REDEFINE NUMBER 2;
 *     }
 *   }
 * }
 * \endcode
 *
 * \subsection Example_Import_FB Import of Function Blocks
 * 
 * \subsubsection Example_Import_FB_AI_1 Analog Input Function Block 1
 * The following example shows the import of a first Analog Input Function Block with all mandatory and optional elements.
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_AI, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0001
 * {
 *   USE_FUNC1_AI_MANDATORY_B;
 *   USE_FUNC1_AI_OPTIONAL_B;
 * }
 * \endcode
 * 
 * \subsubsection Example_Import_FB_AO_1 Analog Output Function Block 1
 * The following example shows the import of a second Analog Output Function Block with all mandatory and optional elements.
 * For the second Function Block and all additional blocks in the device it is necessary to check the the BLOCK number and if it is necessary to redefine the number.
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_AO, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0001
 * {
 *   USE_FUNC1_AO_MANDATORY_B;
 *   USE_FUNC1_AO_OPTIONAL_B;
 *   REDEFINITIONS
 *   {
 *     BLOCK func1_AO_block
 *     {
 *       REDEFINE NUMBER 2;
 *     }
 *   }
 * }
 * \endcode
 * 
 * \subsubsection Example_Import_FB_TOT_1 Totalizer Function Block 1
 * The following example shows the import of a Totalizer Function Block with all mandatory and optional elements.
 * For this third block in the device directory it is necessary to redefine the BLOCK number.
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_TOT, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0001
 * {
 *   USE_FUNC1_TOT_MANDATORY_B;
 *   USE_FUNC1_TOT_OPTIONAL_B;
 *   REDEFINITIONS
 *   {
 *     BLOCK func1_TOT_block
 *     {
 *       REDEFINE NUMBER 3;
 *     }
 *   }
 * }
 * \endcode
 */

#ifndef __PA_IMPORT_H
#define __PA_IMPORT_H

#ifdef _PDM_
#define CPP_CANT_CONCAT
#endif /* _PDM_ */

/* definitions */
#define FLT_MAX 3.40282346E+38

#define PROFILE_301                             0x0301

#define __STANDARD                              0x0000

#define __PHYSICAL_TRANSMITTER                  0x0101
#define __PHYSICAL_ACTUATOR                     0x0201
#define __PHYSICAL_DISCRETE_IO                  0x0301
#define __PHYSICAL_CONTROLLER                   0x0401
#define __PHYSICAL_ANALYZER                     0x0501
#define __PHYSICAL_LAB_DEVICE                   0x0601

#define __TRANS1_TEMP                           0x1001
#define __TRANS2_TEMP                           0x1002
#define __TRANS3_TEMP                           0x1003
#define __TRANS4_TEMP                           0x1004
#define __TRANS5_TEMP                           0x1005
#define __TRANS6_TEMP                           0x1006
#define __TRANS7_TEMP                           0x1007
#define __TRANS8_TEMP                           0x1008
#define __TRANS9_TEMP                           0x1009
#define __TRANS10_TEMP                          0x100a
#define __TRANS11_TEMP                          0x100b
#define __TRANS12_TEMP                          0x100c
#define __TRANS13_TEMP                          0x100d
#define __TRANS14_TEMP                          0x100e
#define __TRANS15_TEMP                          0x100f

#define __TRANS1_PRESS                          0x1101
#define __TRANS2_PRESS                          0x1102
#define __TRANS3_PRESS                          0x1103
#define __TRANS4_PRESS                          0x1104
#define __TRANS5_PRESS                          0x1105
#define __TRANS6_PRESS                          0x1106
#define __TRANS7_PRESS                          0x1107
#define __TRANS8_PRESS                          0x1108
#define __TRANS9_PRESS                          0x1109
#define __TRANS10_PRESS                         0x110a
#define __TRANS11_PRESS                         0x110b
#define __TRANS12_PRESS                         0x110c
#define __TRANS13_PRESS                         0x110d
#define __TRANS14_PRESS                         0x110e
#define __TRANS15_PRESS                         0x110f

#define __FUNC1_AI                              0x4001
#define __FUNC2_AI                              0x4002
#define __FUNC3_AI                              0x4003
#define __FUNC4_AI                              0x4004
#define __FUNC5_AI                              0x4005
#define __FUNC6_AI                              0x4006
#define __FUNC7_AI                              0x4007
#define __FUNC8_AI                              0x4008
#define __FUNC9_AI                              0x4009
#define __FUNC10_AI                             0x400a
#define __FUNC11_AI                             0x400b
#define __FUNC12_AI                             0x400c
#define __FUNC13_AI                             0x400d
#define __FUNC14_AI                             0x400e
#define __FUNC15_AI                             0x400f

#define __FUNC1_TOT                             0x4101
#define __FUNC2_TOT                             0x4102
#define __FUNC3_TOT                             0x4103
#define __FUNC4_TOT                             0x4104
#define __FUNC5_TOT                             0x4105
#define __FUNC6_TOT                             0x4106
#define __FUNC7_TOT                             0x4107
#define __FUNC8_TOT                             0x4108
#define __FUNC9_TOT                             0x4109
#define __FUNC10_TOT                            0x410a
#define __FUNC11_TOT                            0x410b
#define __FUNC12_TOT                            0x410c
#define __FUNC13_TOT                            0x410d
#define __FUNC14_TOT                            0x410e
#define __FUNC15_TOT                            0x410f

#define __TRANS1_FLOWCM                         0x1201
#define __TRANS2_FLOWCM                         0x1202
#define __TRANS3_FLOWCM                         0x1203
#define __TRANS4_FLOWCM                         0x1204
#define __TRANS5_FLOWCM                         0x1205
#define __TRANS6_FLOWCM                         0x1206
#define __TRANS7_FLOWCM                         0x1207
#define __TRANS8_FLOWCM                         0x1208
#define __TRANS9_FLOWCM                         0x1209
#define __TRANS10_FLOWCM                        0x120a
#define __TRANS11_FLOWCM                        0x120b
#define __TRANS12_FLOWCM                        0x120c
#define __TRANS13_FLOWCM                        0x120d
#define __TRANS14_FLOWCM                        0x120e
#define __TRANS15_FLOWCM                        0x120f

#define __TRANS1_FLOWE                          0x1301
#define __TRANS2_FLOWE                          0x1302
#define __TRANS3_FLOWE                          0x1303
#define __TRANS4_FLOWE                          0x1304
#define __TRANS5_FLOWE                          0x1305
#define __TRANS6_FLOWE                          0x1306
#define __TRANS7_FLOWE                          0x1307
#define __TRANS8_FLOWE                          0x1308
#define __TRANS9_FLOWE                          0x1309
#define __TRANS10_FLOWE                         0x130a
#define __TRANS11_FLOWE                         0x130b
#define __TRANS12_FLOWE                         0x130c
#define __TRANS13_FLOWE                         0x130d
#define __TRANS14_FLOWE                         0x130e
#define __TRANS15_FLOWE                         0x130f

#define __TRANS1_FLOWTM                         0x1401
#define __TRANS2_FLOWTM                         0x1402
#define __TRANS3_FLOWTM                         0x1403
#define __TRANS4_FLOWTM                         0x1404
#define __TRANS5_FLOWTM                         0x1405
#define __TRANS6_FLOWTM                         0x1406
#define __TRANS7_FLOWTM                         0x1407
#define __TRANS8_FLOWTM                         0x1408
#define __TRANS9_FLOWTM                         0x1409
#define __TRANS10_FLOWTM                        0x140a
#define __TRANS11_FLOWTM                        0x140b
#define __TRANS12_FLOWTM                        0x140c
#define __TRANS13_FLOWTM                        0x140d
#define __TRANS14_FLOWTM                        0x140e
#define __TRANS15_FLOWTM                        0x140f

#define __TRANS1_FLOWU                          0x1501
#define __TRANS2_FLOWU                          0x1502
#define __TRANS3_FLOWU                          0x1503
#define __TRANS4_FLOWU                          0x1504
#define __TRANS5_FLOWU                          0x1505
#define __TRANS6_FLOWU                          0x1506
#define __TRANS7_FLOWU                          0x1507
#define __TRANS8_FLOWU                          0x1508
#define __TRANS9_FLOWU                          0x1509
#define __TRANS10_FLOWU                         0x150a
#define __TRANS11_FLOWU                         0x150b
#define __TRANS12_FLOWU                         0x150c
#define __TRANS13_FLOWU                         0x150d
#define __TRANS14_FLOWU                         0x150e
#define __TRANS15_FLOWU                         0x150f

#define __TRANS1_FLOWVA                         0x1601
#define __TRANS2_FLOWVA                         0x1602
#define __TRANS3_FLOWVA                         0x1603
#define __TRANS4_FLOWVA                         0x1604
#define __TRANS5_FLOWVA                         0x1605
#define __TRANS6_FLOWVA                         0x1606
#define __TRANS7_FLOWVA                         0x1607
#define __TRANS8_FLOWVA                         0x1608
#define __TRANS9_FLOWVA                         0x1609
#define __TRANS10_FLOWVA                        0x160a
#define __TRANS11_FLOWVA                        0x160b
#define __TRANS12_FLOWVA                        0x160c
#define __TRANS13_FLOWVA                        0x160d
#define __TRANS14_FLOWVA                        0x160e
#define __TRANS15_FLOWVA                        0x160f

#define __TRANS1_FLOWV                          0x1701
#define __TRANS2_FLOWV                          0x1702
#define __TRANS3_FLOWV                          0x1703
#define __TRANS4_FLOWV                          0x1704
#define __TRANS5_FLOWV                          0x1705
#define __TRANS6_FLOWV                          0x1706
#define __TRANS7_FLOWV                          0x1707
#define __TRANS8_FLOWV                          0x1708
#define __TRANS9_FLOWV                          0x1709
#define __TRANS10_FLOWV                         0x170a
#define __TRANS11_FLOWV                         0x170b
#define __TRANS12_FLOWV                         0x170c
#define __TRANS13_FLOWV                         0x170d
#define __TRANS14_FLOWV                         0x170e
#define __TRANS15_FLOWV                         0x170f

#define __TRANS1_LEVEL                          0x1801
#define __TRANS2_LEVEL                          0x1802
#define __TRANS3_LEVEL                          0x1803
#define __TRANS4_LEVEL                          0x1804
#define __TRANS5_LEVEL                          0x1805
#define __TRANS6_LEVEL                          0x1806
#define __TRANS7_LEVEL                          0x1807
#define __TRANS8_LEVEL                          0x1808
#define __TRANS9_LEVEL                          0x1809
#define __TRANS10_LEVEL                         0x180a
#define __TRANS11_LEVEL                         0x180b
#define __TRANS12_LEVEL                         0x180c
#define __TRANS13_LEVEL                         0x180d
#define __TRANS14_LEVEL                         0x180e
#define __TRANS15_LEVEL                         0x180f

#define __TRANS1_ACTUATOR                       0x1901
#define __TRANS2_ACTUATOR                       0x1902
#define __TRANS3_ACTUATOR                       0x1903
#define __TRANS4_ACTUATOR                       0x1904
#define __TRANS5_ACTUATOR                       0x1905
#define __TRANS6_ACTUATOR                       0x1906
#define __TRANS7_ACTUATOR                       0x1907
#define __TRANS8_ACTUATOR                       0x1908
#define __TRANS9_ACTUATOR                       0x1909
#define __TRANS10_ACTUATOR                      0x190a
#define __TRANS11_ACTUATOR                      0x190b
#define __TRANS12_ACTUATOR                      0x190c
#define __TRANS13_ACTUATOR                      0x190d
#define __TRANS14_ACTUATOR                      0x190e
#define __TRANS15_ACTUATOR                      0x190f

#define __TRANS1_PNEUMATICACTUATOR              0x1a01
#define __TRANS2_PNEUMATICACTUATOR              0x1a02
#define __TRANS3_PNEUMATICACTUATOR              0x1a03
#define __TRANS4_PNEUMATICACTUATOR              0x1a04
#define __TRANS5_PNEUMATICACTUATOR              0x1a05
#define __TRANS6_PNEUMATICACTUATOR              0x1a06
#define __TRANS7_PNEUMATICACTUATOR              0x1a07
#define __TRANS8_PNEUMATICACTUATOR              0x1a08
#define __TRANS9_PNEUMATICACTUATOR              0x1a09
#define __TRANS10_PNEUMATICACTUATOR             0x1a0a
#define __TRANS11_PNEUMATICACTUATOR             0x1a0b
#define __TRANS12_PNEUMATICACTUATOR             0x1a0c
#define __TRANS13_PNEUMATICACTUATOR             0x1a0d
#define __TRANS14_PNEUMATICACTUATOR             0x1a0e
#define __TRANS15_PNEUMATICACTUATOR             0x1a0f

#define __FUNC1_AO                              0x4201
#define __FUNC2_AO                              0x4202
#define __FUNC3_AO                              0x4203
#define __FUNC4_AO                              0x4204
#define __FUNC5_AO                              0x4205
#define __FUNC6_AO                              0x4206
#define __FUNC7_AO                              0x4207
#define __FUNC8_AO                              0x4208
#define __FUNC9_AO                              0x4209
#define __FUNC10_AO                             0x420a
#define __FUNC11_AO                             0x420b
#define __FUNC12_AO                             0x420c
#define __FUNC13_AO                             0x420d
#define __FUNC14_AO                             0x420e
#define __FUNC15_AO                             0x420f

#define __TRANS1_DI                             0x1b01
#define __TRANS2_DI                             0x1b02
#define __TRANS3_DI                             0x1b03
#define __TRANS4_DI                             0x1b04
#define __TRANS5_DI                             0x1b05
#define __TRANS6_DI                             0x1b06
#define __TRANS7_DI                             0x1b07
#define __TRANS8_DI                             0x1b08
#define __TRANS9_DI                             0x1b09
#define __TRANS10_DI                            0x1b0a
#define __TRANS11_DI                            0x1b0b
#define __TRANS12_DI                            0x1b0c
#define __TRANS13_DI                            0x1b0d
#define __TRANS14_DI                            0x1b0e
#define __TRANS15_DI                            0x1b0f

#define __TRANS1_DO                             0x1c01
#define __TRANS2_DO                             0x1c02
#define __TRANS3_DO                             0x1c03
#define __TRANS4_DO                             0x1c04
#define __TRANS5_DO                             0x1c05
#define __TRANS6_DO                             0x1c06
#define __TRANS7_DO                             0x1c07
#define __TRANS8_DO                             0x1c08
#define __TRANS9_DO                             0x1c09
#define __TRANS10_DO                            0x1c0a
#define __TRANS11_DO                            0x1c0b
#define __TRANS12_DO                            0x1c0c
#define __TRANS13_DO                            0x1c0d
#define __TRANS14_DO                            0x1c0e
#define __TRANS15_DO                            0x1c0f

#define __TRANS1_ANALYSIS                       0x1d01
#define __TRANS2_ANALYSIS                       0x1d02
#define __TRANS3_ANALYSIS                       0x1d03
#define __TRANS4_ANALYSIS                       0x1d04
#define __TRANS5_ANALYSIS                       0x1d05
#define __TRANS6_ANALYSIS                       0x1d06
#define __TRANS7_ANALYSIS                       0x1d07
#define __TRANS8_ANALYSIS                       0x1d08
#define __TRANS9_ANALYSIS                       0x1d09
#define __TRANS10_ANALYSIS                      0x1d0a
#define __TRANS11_ANALYSIS                      0x1d0b
#define __TRANS12_ANALYSIS                      0x1d0c
#define __TRANS13_ANALYSIS                      0x1d0d
#define __TRANS14_ANALYSIS                      0x1d0e
#define __TRANS15_ANALYSIS                      0x1d0f

#define __TRANS1_TRANSFER                       0x1e01
#define __TRANS2_TRANSFER                       0x1e02
#define __TRANS3_TRANSFER                       0x1e03
#define __TRANS4_TRANSFER                       0x1e04
#define __TRANS5_TRANSFER                       0x1e05
#define __TRANS6_TRANSFER                       0x1e06
#define __TRANS7_TRANSFER                       0x1e07
#define __TRANS8_TRANSFER                       0x1e08
#define __TRANS9_TRANSFER                       0x1e09
#define __TRANS10_TRANSFER                      0x1e0a
#define __TRANS11_TRANSFER                      0x1e0b
#define __TRANS12_TRANSFER                      0x1e0c
#define __TRANS13_TRANSFER                      0x1e0d
#define __TRANS14_TRANSFER                      0x1e0e
#define __TRANS15_TRANSFER                      0x1e0f

#define __TRANS1_CONTROL_PH                     0x1f01
#define __TRANS2_CONTROL_PH                     0x1f02
#define __TRANS3_CONTROL_PH                     0x1f03
#define __TRANS4_CONTROL_PH                     0x1f04
#define __TRANS5_CONTROL_PH                     0x1f05
#define __TRANS6_CONTROL_PH                     0x1f06
#define __TRANS7_CONTROL_PH                     0x1f07
#define __TRANS8_CONTROL_PH                     0x1f08
#define __TRANS9_CONTROL_PH                     0x1f09
#define __TRANS10_CONTROL_PH                    0x1f0a
#define __TRANS11_CONTROL_PH                    0x1f0b
#define __TRANS12_CONTROL_PH                    0x1f0c
#define __TRANS13_CONTROL_PH                    0x1f0d
#define __TRANS14_CONTROL_PH                    0x1f0e
#define __TRANS15_CONTROL_PH                    0x1f0f

#define __TRANS1_CONTROL_COND                   0x2001
#define __TRANS2_CONTROL_COND                   0x2002
#define __TRANS3_CONTROL_COND                   0x2003
#define __TRANS4_CONTROL_COND                   0x2004
#define __TRANS5_CONTROL_COND                   0x2005
#define __TRANS6_CONTROL_COND                   0x2006
#define __TRANS7_CONTROL_COND                   0x2007
#define __TRANS8_CONTROL_COND                   0x2008
#define __TRANS9_CONTROL_COND                   0x2009
#define __TRANS10_CONTROL_COND                  0x200a
#define __TRANS11_CONTROL_COND                  0x200b
#define __TRANS12_CONTROL_COND                  0x200c
#define __TRANS13_CONTROL_COND                  0x200d
#define __TRANS14_CONTROL_COND                  0x200e
#define __TRANS15_CONTROL_COND                  0x200f

#define __TRANS1_CONTROL_OXYG                   0x2101
#define __TRANS2_CONTROL_OXYG                   0x2102
#define __TRANS3_CONTROL_OXYG                   0x2103
#define __TRANS4_CONTROL_OXYG                   0x2104
#define __TRANS5_CONTROL_OXYG                   0x2105
#define __TRANS6_CONTROL_OXYG                   0x2106
#define __TRANS7_CONTROL_OXYG                   0x2107
#define __TRANS8_CONTROL_OXYG                   0x2108
#define __TRANS9_CONTROL_OXYG                   0x2109
#define __TRANS10_CONTROL_OXYG                  0x210a
#define __TRANS11_CONTROL_OXYG                  0x210b
#define __TRANS12_CONTROL_OXYG                  0x210c
#define __TRANS13_CONTROL_OXYG                  0x210d
#define __TRANS14_CONTROL_OXYG                  0x210e
#define __TRANS15_CONTROL_OXYG                  0x210f

#define __TRANS1_LIMIT                          0x2201
#define __TRANS2_LIMIT                          0x2202
#define __TRANS3_LIMIT                          0x2203
#define __TRANS4_LIMIT                          0x2204
#define __TRANS5_LIMIT                          0x2205
#define __TRANS6_LIMIT                          0x2206
#define __TRANS7_LIMIT                          0x2207
#define __TRANS8_LIMIT                          0x2208
#define __TRANS9_LIMIT                          0x2209
#define __TRANS10_LIMIT                         0x220a
#define __TRANS11_LIMIT                         0x220b
#define __TRANS12_LIMIT                         0x220c
#define __TRANS13_LIMIT                         0x220d
#define __TRANS14_LIMIT                         0x220e
#define __TRANS15_LIMIT                         0x220f

#define __TRANS1_ALARM                          0x2301
#define __TRANS2_ALARM                          0x2302
#define __TRANS3_ALARM                          0x2303
#define __TRANS4_ALARM                          0x2304
#define __TRANS5_ALARM                          0x2305
#define __TRANS6_ALARM                          0x2306
#define __TRANS7_ALARM                          0x2307
#define __TRANS8_ALARM                          0x2308
#define __TRANS9_ALARM                          0x2309
#define __TRANS10_ALARM                         0x230a
#define __TRANS11_ALARM                         0x230b
#define __TRANS12_ALARM                         0x230c
#define __TRANS13_ALARM                         0x230d
#define __TRANS14_ALARM                         0x230e
#define __TRANS15_ALARM                         0x230f

#define __FUNC1_DI                              0x4301
#define __FUNC2_DI                              0x4302
#define __FUNC3_DI                              0x4303
#define __FUNC4_DI                              0x4304
#define __FUNC5_DI                              0x4305
#define __FUNC6_DI                              0x4306
#define __FUNC7_DI                              0x4307
#define __FUNC8_DI                              0x4308
#define __FUNC9_DI                              0x4309
#define __FUNC10_DI                             0x430a
#define __FUNC11_DI                             0x430b
#define __FUNC12_DI                             0x430c
#define __FUNC13_DI                             0x430d
#define __FUNC14_DI                             0x430e
#define __FUNC15_DI                             0x430f

#define __FUNC1_DO                              0x4401
#define __FUNC2_DO                              0x4402
#define __FUNC3_DO                              0x4403
#define __FUNC4_DO                              0x4404
#define __FUNC5_DO                              0x4405
#define __FUNC6_DO                              0x4406
#define __FUNC7_DO                              0x4407
#define __FUNC8_DO                              0x4408
#define __FUNC9_DO                              0x4409
#define __FUNC10_DO                             0x440a
#define __FUNC11_DO                             0x440b
#define __FUNC12_DO                             0x440c
#define __FUNC13_DO                             0x440d
#define __FUNC14_DO                             0x440e
#define __FUNC15_DO                             0x440f

#define __FUNC1_LOGBOOK                         0x4501
#define __FUNC2_LOGBOOK                         0x4502
#define __FUNC3_LOGBOOK                         0x4503
#define __FUNC4_LOGBOOK                         0x4504
#define __FUNC5_LOGBOOK                         0x4505
#define __FUNC6_LOGBOOK                         0x4506
#define __FUNC7_LOGBOOK                         0x4507
#define __FUNC8_LOGBOOK                         0x4508
#define __FUNC9_LOGBOOK                         0x4509
#define __FUNC10_LOGBOOK                        0x450a
#define __FUNC11_LOGBOOK                        0x450b
#define __FUNC12_LOGBOOK                        0x450c
#define __FUNC13_LOGBOOK                        0x450d
#define __FUNC14_LOGBOOK                        0x450e
#define __FUNC15_LOGBOOK                        0x450f

#define USE_PHYS_MANDATORY_BOTH \
	BLOCK phys_block; \
	COLLECTION phys_BLOCK_OBJECT; \
	VARIABLE phys_BLOCK_OBJECT_Reserved; \
	VARIABLE phys_BLOCK_OBJECT_Block_Object; \
	VARIABLE phys_BLOCK_OBJECT_Parent_Class; \
	VARIABLE phys_BLOCK_OBJECT_Class; \
	VARIABLE phys_BLOCK_OBJECT_DD_Reference; \
	VARIABLE phys_BLOCK_OBJECT_DD_Revision; \
	VARIABLE phys_BLOCK_OBJECT_Profile; \
	VARIABLE phys_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE phys_BLOCK_OBJECT_Execution_Time; \
	VARIABLE phys_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE phys_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE phys_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE phys_BLOCK_OBJECT_Number_of_Views; \
	MENU phys_BLOCK_OBJECT_page; \
	COMMAND phys_BLOCK_OBJECT_read; \
	VARIABLE phys_ST_REV; \
	MENU phys_ST_REV_page; \
	COMMAND phys_ST_REV_read; \
	VARIABLE phys_TAG_DESC; \
	MENU phys_TAG_DESC_page; \
	COMMAND phys_TAG_DESC_read; \
	COMMAND phys_TAG_DESC_write; \
	VARIABLE phys_STRATEGY; \
	MENU phys_STRATEGY_page; \
	COMMAND phys_STRATEGY_read; \
	COMMAND phys_STRATEGY_write; \
	VARIABLE phys_ALERT_KEY; \
	MENU phys_ALERT_KEY_page; \
	COMMAND phys_ALERT_KEY_read; \
	COMMAND phys_ALERT_KEY_write; \
	VARIABLE phys_TARGET_MODE; \
	MENU phys_TARGET_MODE_page; \
	COMMAND phys_TARGET_MODE_read; \
	COMMAND phys_TARGET_MODE_write; \
	COLLECTION phys_MODE_BLK; \
	VARIABLE phys_MODE_BLK_Actual; \
	VARIABLE phys_MODE_BLK_Permitted; \
	VARIABLE phys_MODE_BLK_Normal; \
	MENU phys_MODE_BLK_page; \
	COMMAND phys_MODE_BLK_read; \
	COLLECTION phys_ALARM_SUM; \
	VARIABLE phys_ALARM_SUM_Current; \
	VARIABLE phys_ALARM_SUM_Unacknowledged; \
	VARIABLE phys_ALARM_SUM_Unreported; \
	VARIABLE phys_ALARM_SUM_Disabled; \
	MENU phys_ALARM_SUM_page; \
	COMMAND phys_ALARM_SUM_read; \
	VARIABLE phys_SOFTWARE_REVISION; \
	MENU phys_SOFTWARE_REVISION_page; \
	COMMAND phys_SOFTWARE_REVISION_read; \
	VARIABLE phys_HARDWARE_REVISION; \
	MENU phys_HARDWARE_REVISION_page; \
	COMMAND phys_HARDWARE_REVISION_read; \
	VARIABLE phys_DEVICE_MAN_ID; \
	MENU phys_DEVICE_MAN_ID_page; \
	COMMAND phys_DEVICE_MAN_ID_read; \
	VARIABLE phys_DEVICE_ID; \
	MENU phys_DEVICE_ID_page; \
	COMMAND phys_DEVICE_ID_read; \
	VARIABLE phys_DEVICE_SER_NUM; \
	MENU phys_DEVICE_SER_NUM_page; \
	COMMAND phys_DEVICE_SER_NUM_read; \
	VARIABLE phys_DIAGNOSIS; \
	MENU phys_DIAGNOSIS_page; \
	COMMAND phys_DIAGNOSIS_read; \
	VARIABLE phys_DIAGNOSIS_MASK; \
	MENU phys_DIAGNOSIS_MASK_page; \
	COMMAND phys_DIAGNOSIS_MASK_read; \
	COLLECTION phys_FEATURE; \
	VARIABLE phys_FEATURE_Supported; \
	VARIABLE phys_FEATURE_Enabled; \
	MENU phys_FEATURE_page; \
	COMMAND phys_FEATURE_read; \
	VARIABLE phys_COND_STATUS_DIAG; \
	MENU phys_COND_STATUS_DIAG_page; \
	COMMAND phys_COND_STATUS_DIAG_read; \
	COMMAND phys_COND_STATUS_DIAG_write; \
	MENU phys_Diagnosis_page

#define USE_PHYS_MANDATORY_A \
	USE_PHYS_MANDATORY_BOTH; \
	MENU phys_Simple_Dialog_Mandatory_A

#define USE_PHYS_MANDATORY_B \
	USE_PHYS_MANDATORY_BOTH; \
	VARIABLE phys_IDENT_NUMBER_SELECTOR; \
	MENU phys_IDENT_NUMBER_SELECTOR_page; \
	COMMAND phys_IDENT_NUMBER_SELECTOR_read; \
	COMMAND phys_IDENT_NUMBER_SELECTOR_write; \
	COLLECTION phys_VIEW_1; \
	MENU phys_VIEW_1_page; \
	MENU phys_Simple_Dialog_Mandatory_B

#define USE_PHYS_OPTIONAL_BOTH \
	VARIABLE phys_DIAGNOSIS_EXTENSION; \
	MENU phys_DIAGNOSIS_EXTENSION_page; \
	COMMAND phys_DIAGNOSIS_EXTENSION_read; \
	VARIABLE phys_DIAGNOSIS_MASK_EXTENSION; \
	MENU phys_DIAGNOSIS_MASK_EXTENSION_page; \
	COMMAND phys_DIAGNOSIS_MASK_EXTENSION_read; \
	VARIABLE phys_DEVICE_CERTIFICATION; \
	MENU phys_DEVICE_CERTIFICATION_page; \
	COMMAND phys_DEVICE_CERTIFICATION_read; \
	VARIABLE phys_WRITE_LOCKING; \
	MENU phys_WRITE_LOCKING_page; \
	COMMAND phys_WRITE_LOCKING_read; \
	COMMAND phys_WRITE_LOCKING_write; \
	VARIABLE phys_FACTORY_RESET; \
	MENU phys_FACTORY_RESET_page; \
	COMMAND phys_FACTORY_RESET_read; \
	COMMAND phys_FACTORY_RESET_write; \
	VARIABLE phys_DESCRIPTOR; \
	MENU phys_DESCRIPTOR_page; \
	COMMAND phys_DESCRIPTOR_read; \
	COMMAND phys_DESCRIPTOR_write; \
	VARIABLE phys_DEVICE_MESSAGE; \
	MENU phys_DEVICE_MESSAGE_page; \
	COMMAND phys_DEVICE_MESSAGE_read; \
	COMMAND phys_DEVICE_MESSAGE_write; \
	VARIABLE phys_DEVICE_INSTAL_DATE; \
	MENU phys_DEVICE_INSTAL_DATE_page; \
	COMMAND phys_DEVICE_INSTAL_DATE_read; \
	COMMAND phys_DEVICE_INSTAL_DATE_write; \
	VARIABLE phys_LOCAL_OP_ENA; \
	MENU phys_LOCAL_OP_ENA_page; \
	COMMAND phys_LOCAL_OP_ENA_read; \
	COMMAND phys_LOCAL_OP_ENA_write; \
	VARIABLE phys_HW_WRITE_PROTECTION; \
	MENU phys_HW_WRITE_PROTECTION_page; \
	COMMAND phys_HW_WRITE_PROTECTION_read; \
	COLLECTION phys_DIAG_EVENT_SWITCH; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_2_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_2_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_3_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_3_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_4_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_4_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_5_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_5_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_6_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_6_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_7_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_7_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_8_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_8_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_9_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_9_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_10_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_10_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_11_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_11_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_12_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_12_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_13_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_13_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_14_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_14_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_15_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_15_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_16_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_16_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_17_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_17_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_18_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_18_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_19_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_19_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_20_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_20_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_21_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_21_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_22_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_22_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_23_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_23_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_24_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_24_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_25_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_25_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_26_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_26_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_27_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_27_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_28_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_28_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_29_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_29_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_30_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_30_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_31_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_31_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_32_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_32_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_33_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_34_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_35_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_36_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_37_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_38_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_39_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_40_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_41_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_42_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_43_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_44_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_45_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_46_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_47_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_48_Status; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Slot; \
	VARIABLE phys_DIAG_EVENT_SWITCH_Index; \
	MENU phys_DIAG_EVENT_SWITCH_page; \
	COMMAND phys_DIAG_EVENT_SWITCH_read; \
	COMMAND phys_DIAG_EVENT_SWITCH_write; \
	MENU phys_Reset; \
	MENU phys_Reset_page; \
	METHOD phys_method_factory_reset_params; \
	METHOD phys_method_factory_reset_warm; \
	METHOD phys_method_factory_reset_address; \
	METHOD phys_method_factory_reset_device_specific; \
	MENU phys_Dialog_Write_Locking; \
	MENU phys_Dialog_Ident_Number_Selector

#define USE_PHYS_OPTIONAL_A \
	USE_PHYS_OPTIONAL_BOTH; \
	VARIABLE phys_IDENT_NUMBER_SELECTOR; \
	MENU phys_IDENT_NUMBER_SELECTOR_page; \
	COMMAND phys_IDENT_NUMBER_SELECTOR_read; \
	COMMAND phys_IDENT_NUMBER_SELECTOR_write; \
	COLLECTION phys_VIEW_1; \
	MENU phys_VIEW_1_page; \
	MENU phys_Simple_Dialog_Optional_A

#define USE_PHYS_OPTIONAL_B \
	USE_PHYS_OPTIONAL_BOTH; \
	MENU phys_Simple_Dialog_Optional_B

#define USE_PHYS_ANALYZER_MANDATORY_BOTH \
	VARIABLE phys_DEVICE_CONFIGURATION; \
	MENU phys_DEVICE_CONFIGURATION_page; \
	COMMAND phys_DEVICE_CONFIGURATION_read; \
	VARIABLE phys_INIT_STATE; \
	MENU phys_INIT_STATE_page; \
	COMMAND phys_INIT_STATE_read; \
	COMMAND phys_INIT_STATE_write; \
	VARIABLE phys_DEVICE_STATE; \
	MENU phys_DEVICE_STATE_page; \
	COMMAND phys_DEVICE_STATE_read; \
	COMMAND phys_DEVICE_STATE_write; \
	VARIABLE phys_GLOBAL_STATUS; \
	MENU phys_GLOBAL_STATUS_page; \
	COMMAND phys_GLOBAL_STATUS_read

#define USE_PHYS_ANALYZER_MANDATORY_A \
	USE_PHYS_ANALYZER_MANDATORY_BOTH; \
	USE_PHYS_MANDATORY_A; \
	MENU phys_Analyzer_Simple_Dialog_Mandatory_A

#define USE_PHYS_ANALYZER_MANDATORY_B \
	USE_PHYS_ANALYZER_MANDATORY_BOTH; \
	USE_PHYS_MANDATORY_B; \
	MENU phys_Analyzer_Simple_Dialog_Mandatory_B

#define USE_PHYS_ANALYZER_OPTIONAL_A \
	USE_PHYS_OPTIONAL_A; \
	MENU phys_Analyzer_Simple_Dialog_Optional_A

#define USE_PHYS_ANALYZER_OPTIONAL_B \
	USE_PHYS_OPTIONAL_B; \
	MENU phys_Analyzer_Simple_Dialog_Optional_B

#ifdef CPP_CANT_CONCAT

#define USE_TRANS1_TEMP_MANDATORY_BOTH \
	BLOCK trans1_Temp_block; \
	COLLECTION trans1_Temp_BLOCK_OBJECT; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans1_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans1_Temp_BLOCK_OBJECT_page; \
	COMMAND trans1_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans1_Temp_ST_REV; \
	MENU trans1_Temp_ST_REV_page; \
	COMMAND trans1_Temp_ST_REV_read; \
	VARIABLE trans1_Temp_TAG_DESC; \
	MENU trans1_Temp_TAG_DESC_page; \
	COMMAND trans1_Temp_TAG_DESC_read; \
	COMMAND trans1_Temp_TAG_DESC_write; \
	VARIABLE trans1_Temp_STRATEGY; \
	MENU trans1_Temp_STRATEGY_page; \
	COMMAND trans1_Temp_STRATEGY_read; \
	COMMAND trans1_Temp_STRATEGY_write; \
	VARIABLE trans1_Temp_ALERT_KEY; \
	MENU trans1_Temp_ALERT_KEY_page; \
	COMMAND trans1_Temp_ALERT_KEY_read; \
	COMMAND trans1_Temp_ALERT_KEY_write; \
	VARIABLE trans1_Temp_TARGET_MODE; \
	MENU trans1_Temp_TARGET_MODE_page; \
	COMMAND trans1_Temp_TARGET_MODE_read; \
	COMMAND trans1_Temp_TARGET_MODE_write; \
	COLLECTION trans1_Temp_MODE_BLK; \
	VARIABLE trans1_Temp_MODE_BLK_Actual; \
	VARIABLE trans1_Temp_MODE_BLK_Permitted; \
	VARIABLE trans1_Temp_MODE_BLK_Normal; \
	MENU trans1_Temp_MODE_BLK_page; \
	COMMAND trans1_Temp_MODE_BLK_read; \
	COLLECTION trans1_Temp_ALARM_SUM; \
	VARIABLE trans1_Temp_ALARM_SUM_Current; \
	VARIABLE trans1_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans1_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans1_Temp_ALARM_SUM_Disabled; \
	MENU trans1_Temp_ALARM_SUM_page; \
	COMMAND trans1_Temp_ALARM_SUM_read; \
	COLLECTION trans1_Temp_PRIMARY_VALUE; \
	VARIABLE trans1_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans1_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans1_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans1_Temp_PRIMARY_VALUE_page; \
	COMMAND trans1_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans1_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans1_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans1_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans1_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans1_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans1_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans1_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans1_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans1_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans1_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans1_Temp_SENSOR_MEAS_TYPE; \
	MENU trans1_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans1_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans1_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans1_Temp_INPUT_RANGE; \
	MENU trans1_Temp_INPUT_RANGE_page; \
	COMMAND trans1_Temp_INPUT_RANGE_read; \
	COMMAND trans1_Temp_INPUT_RANGE_write; \
	VARIABLE trans1_Temp_LIN_TYPE; \
	MENU trans1_Temp_LIN_TYPE_page; \
	COMMAND trans1_Temp_LIN_TYPE_read; \
	COMMAND trans1_Temp_LIN_TYPE_write; \
	VARIABLE trans1_Temp_BIAS_1; \
	MENU trans1_Temp_BIAS_1_page; \
	COMMAND trans1_Temp_BIAS_1_read; \
	COMMAND trans1_Temp_BIAS_1_write; \
	VARIABLE trans1_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans1_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans1_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans1_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans1_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans1_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans1_Temp_INPUT_FAULT_GEN; \
	MENU trans1_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans1_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans1_Temp_INPUT_FAULT_1; \
	MENU trans1_Temp_INPUT_FAULT_1_page; \
	COMMAND trans1_Temp_INPUT_FAULT_1_read; \
	UNIT trans1_Temp_Unit_1; \
	VARIABLE trans1_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans1_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans1_Temp_Display; \
	CHART trans1_Temp_Display_BarVal_pv; \
	SOURCE trans1_Temp_Display_BarVal_pv_source; \
	MENU trans1_Temp_Display_primary; \
	MENU trans1_Temp_Display_secondary; \
	MENU trans1_Temp_Tab_s; \
	MENU trans1_Temp_Tab_s_measrange; \
	MENU trans1_Temp_Tab_m

#define USE_TRANS1_TEMP_MANDATORY_A \
	USE_TRANS1_TEMP_MANDATORY_BOTH; \
	MENU trans1_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS1_TEMP_MANDATORY_B \
	USE_TRANS1_TEMP_MANDATORY_BOTH; \
	COLLECTION trans1_Temp_VIEW_1; \
	MENU trans1_Temp_VIEW_1_page; \
	MENU trans1_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS1_TEMP_OPTIONAL_BOTH \
	COLLECTION trans1_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans1_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans1_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans1_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans1_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans1_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans1_Temp_BIAS_2; \
	MENU trans1_Temp_BIAS_2_page; \
	COMMAND trans1_Temp_BIAS_2_read; \
	COMMAND trans1_Temp_BIAS_2_write; \
	VARIABLE trans1_Temp_INPUT_FAULT_2; \
	MENU trans1_Temp_INPUT_FAULT_2_page; \
	COMMAND trans1_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans1_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans1_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans1_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans1_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans1_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans1_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans1_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans1_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans1_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans1_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans1_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans1_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans1_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans1_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans1_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans1_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans1_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans1_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans1_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans1_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans1_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans1_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans1_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans1_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans1_Temp_TAB_ENTRY; \
	MENU trans1_Temp_TAB_ENTRY_page; \
	COMMAND trans1_Temp_TAB_ENTRY_read; \
	COMMAND trans1_Temp_TAB_ENTRY_write; \
	COLLECTION trans1_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans1_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans1_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans1_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans1_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans1_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans1_Temp_TAB_MIN_NUMBER; \
	MENU trans1_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans1_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans1_Temp_TAB_MAX_NUMBER; \
	MENU trans1_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans1_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans1_Temp_TAB_OP_CODE; \
	MENU trans1_Temp_TAB_OP_CODE_page; \
	COMMAND trans1_Temp_TAB_OP_CODE_read; \
	COMMAND trans1_Temp_TAB_OP_CODE_write; \
	VARIABLE trans1_Temp_TAB_STATUS; \
	MENU trans1_Temp_TAB_STATUS_page; \
	COMMAND trans1_Temp_TAB_STATUS_read; \
	VARIABLE trans1_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans1_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans1_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans1_Temp_Unit_2

#define USE_TRANS1_TEMP_OPTIONAL_A \
	USE_TRANS1_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans1_Temp_VIEW_1; \
	MENU trans1_Temp_VIEW_1_page; \
	MENU trans1_Temp_Simple_Dialog_Optional_A

#define USE_TRANS1_TEMP_OPTIONAL_B \
	USE_TRANS1_TEMP_OPTIONAL_BOTH; \
	MENU trans1_Temp_Simple_Dialog_Optional_B

#define USE_TRANS1_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans1_Temp_RJ_TYPE; \
	MENU trans1_Temp_RJ_TYPE_page; \
	COMMAND trans1_Temp_RJ_TYPE_read; \
	COMMAND trans1_Temp_RJ_TYPE_write; \
	MENU trans1_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS1_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans1_Temp_SENSOR_CONNECTION; \
	MENU trans1_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans1_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans1_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans1_Temp_COMP_WIRE1; \
	MENU trans1_Temp_COMP_WIRE1_page; \
	COMMAND trans1_Temp_COMP_WIRE1_read; \
	COMMAND trans1_Temp_COMP_WIRE1_write; \
	MENU trans1_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS1_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans1_Temp_EMISSIVITY; \
	MENU trans1_Temp_EMISSIVITY_page; \
	COMMAND trans1_Temp_EMISSIVITY_read; \
	COMMAND trans1_Temp_EMISSIVITY_write; \
	VARIABLE trans1_Temp_PEAK_TRACK; \
	MENU trans1_Temp_PEAK_TRACK_page; \
	COMMAND trans1_Temp_PEAK_TRACK_read; \
	COMMAND trans1_Temp_PEAK_TRACK_write; \
	VARIABLE trans1_Temp_DECAY_RATE; \
	MENU trans1_Temp_DECAY_RATE_page; \
	COMMAND trans1_Temp_DECAY_RATE_read; \
	COMMAND trans1_Temp_DECAY_RATE_write; \
	VARIABLE trans1_Temp_PEAK_TIME; \
	MENU trans1_Temp_PEAK_TIME_page; \
	COMMAND trans1_Temp_PEAK_TIME_read; \
	COMMAND trans1_Temp_PEAK_TIME_write; \
	VARIABLE trans1_Temp_TRACK_HOLD; \
	MENU trans1_Temp_TRACK_HOLD_page; \
	COMMAND trans1_Temp_TRACK_HOLD_read; \
	COMMAND trans1_Temp_TRACK_HOLD_write; \
	VARIABLE trans1_Temp_SPECT_FILT_SET; \
	MENU trans1_Temp_SPECT_FILT_SET_page; \
	COMMAND trans1_Temp_SPECT_FILT_SET_read; \
	COMMAND trans1_Temp_SPECT_FILT_SET_write; \
	MENU trans1_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS1_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans1_Temp_RJ_TYPE; \
	MENU trans1_Temp_RJ_TYPE_page; \
	COMMAND trans1_Temp_RJ_TYPE_read; \
	COMMAND trans1_Temp_RJ_TYPE_write; \
	MENU trans1_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS1_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans1_Temp_SENSOR_CONNECTION; \
	MENU trans1_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans1_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans1_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans1_Temp_COMP_WIRE1; \
	MENU trans1_Temp_COMP_WIRE1_page; \
	COMMAND trans1_Temp_COMP_WIRE1_read; \
	COMMAND trans1_Temp_COMP_WIRE1_write; \
	MENU trans1_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS1_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans1_Temp_EMISSIVITY; \
	MENU trans1_Temp_EMISSIVITY_page; \
	COMMAND trans1_Temp_EMISSIVITY_read; \
	COMMAND trans1_Temp_EMISSIVITY_write; \
	VARIABLE trans1_Temp_PEAK_TRACK; \
	MENU trans1_Temp_PEAK_TRACK_page; \
	COMMAND trans1_Temp_PEAK_TRACK_read; \
	COMMAND trans1_Temp_PEAK_TRACK_write; \
	VARIABLE trans1_Temp_DECAY_RATE; \
	MENU trans1_Temp_DECAY_RATE_page; \
	COMMAND trans1_Temp_DECAY_RATE_read; \
	COMMAND trans1_Temp_DECAY_RATE_write; \
	VARIABLE trans1_Temp_PEAK_TIME; \
	MENU trans1_Temp_PEAK_TIME_page; \
	COMMAND trans1_Temp_PEAK_TIME_read; \
	COMMAND trans1_Temp_PEAK_TIME_write; \
	VARIABLE trans1_Temp_TRACK_HOLD; \
	MENU trans1_Temp_TRACK_HOLD_page; \
	COMMAND trans1_Temp_TRACK_HOLD_read; \
	COMMAND trans1_Temp_TRACK_HOLD_write; \
	VARIABLE trans1_Temp_SPECT_FILT_SET; \
	MENU trans1_Temp_SPECT_FILT_SET_page; \
	COMMAND trans1_Temp_SPECT_FILT_SET_read; \
	COMMAND trans1_Temp_SPECT_FILT_SET_write; \
	MENU trans1_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS1_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans1_Temp_RJ_TEMP; \
	MENU trans1_Temp_RJ_TEMP_page; \
	COMMAND trans1_Temp_RJ_TEMP_read; \
	VARIABLE trans1_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans1_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans1_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans1_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans1_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans1_Temp_Unit_3

#define USE_TRANS1_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans1_Temp_COMP_WIRE2; \
	MENU trans1_Temp_COMP_WIRE2_page; \
	COMMAND trans1_Temp_COMP_WIRE2_read; \
	COMMAND trans1_Temp_COMP_WIRE2_write; \
	MENU trans1_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS1_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans1_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS1_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans1_Temp_RJ_TEMP; \
	MENU trans1_Temp_RJ_TEMP_page; \
	COMMAND trans1_Temp_RJ_TEMP_read; \
	VARIABLE trans1_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans1_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans1_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans1_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans1_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans1_Temp_Unit_3

#define USE_TRANS1_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans1_Temp_COMP_WIRE2; \
	MENU trans1_Temp_COMP_WIRE2_page; \
	COMMAND trans1_Temp_COMP_WIRE2_read; \
	COMMAND trans1_Temp_COMP_WIRE2_write; \
	MENU trans1_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS1_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans1_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS_TEMP_MANDATORY_BOTH(prefix) \
	BLOCK prefix ## block; \
	COLLECTION prefix ## BLOCK_OBJECT; \
	VARIABLE prefix ## BLOCK_OBJECT_Reserved; \
	VARIABLE prefix ## BLOCK_OBJECT_Block_Object; \
	VARIABLE prefix ## BLOCK_OBJECT_Parent_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Reference; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Execution_Time; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Views; \
	MENU prefix ## BLOCK_OBJECT_page; \
	COMMAND prefix ## BLOCK_OBJECT_read; \
	VARIABLE prefix ## ST_REV; \
	MENU prefix ## ST_REV_page; \
	COMMAND prefix ## ST_REV_read; \
	VARIABLE prefix ## TAG_DESC; \
	MENU prefix ## TAG_DESC_page; \
	COMMAND prefix ## TAG_DESC_read; \
	COMMAND prefix ## TAG_DESC_write; \
	VARIABLE prefix ## STRATEGY; \
	MENU prefix ## STRATEGY_page; \
	COMMAND prefix ## STRATEGY_read; \
	COMMAND prefix ## STRATEGY_write; \
	VARIABLE prefix ## ALERT_KEY; \
	MENU prefix ## ALERT_KEY_page; \
	COMMAND prefix ## ALERT_KEY_read; \
	COMMAND prefix ## ALERT_KEY_write; \
	VARIABLE prefix ## TARGET_MODE; \
	MENU prefix ## TARGET_MODE_page; \
	COMMAND prefix ## TARGET_MODE_read; \
	COMMAND prefix ## TARGET_MODE_write; \
	COLLECTION prefix ## MODE_BLK; \
	VARIABLE prefix ## MODE_BLK_Actual; \
	VARIABLE prefix ## MODE_BLK_Permitted; \
	VARIABLE prefix ## MODE_BLK_Normal; \
	MENU prefix ## MODE_BLK_page; \
	COMMAND prefix ## MODE_BLK_read; \
	COLLECTION prefix ## ALARM_SUM; \
	VARIABLE prefix ## ALARM_SUM_Current; \
	VARIABLE prefix ## ALARM_SUM_Unacknowledged; \
	VARIABLE prefix ## ALARM_SUM_Unreported; \
	VARIABLE prefix ## ALARM_SUM_Disabled; \
	MENU prefix ## ALARM_SUM_page; \
	COMMAND prefix ## ALARM_SUM_read; \
	COLLECTION prefix ## PRIMARY_VALUE; \
	VARIABLE prefix ## PRIMARY_VALUE_Value; \
	VARIABLE prefix ## PRIMARY_VALUE_Status_Quality; \
	VARIABLE prefix ## PRIMARY_VALUE_Status_Limit; \
	MENU prefix ## PRIMARY_VALUE_page; \
	COMMAND prefix ## PRIMARY_VALUE_read; \
	VARIABLE prefix ## PRIMARY_VALUE_UNIT; \
	MENU prefix ## PRIMARY_VALUE_UNIT_page; \
	COMMAND prefix ## PRIMARY_VALUE_UNIT_read; \
	COMMAND prefix ## PRIMARY_VALUE_UNIT_write; \
	COLLECTION prefix ## SECONDARY_VALUE_1; \
	VARIABLE prefix ## SECONDARY_VALUE_1_Value; \
	VARIABLE prefix ## SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE prefix ## SECONDARY_VALUE_1_Status_Limit; \
	MENU prefix ## SECONDARY_VALUE_1_page; \
	COMMAND prefix ## SECONDARY_VALUE_1_read; \
	VARIABLE prefix ## SENSOR_MEAS_TYPE; \
	MENU prefix ## SENSOR_MEAS_TYPE_page; \
	COMMAND prefix ## SENSOR_MEAS_TYPE_read; \
	COMMAND prefix ## SENSOR_MEAS_TYPE_write; \
	VARIABLE prefix ## INPUT_RANGE; \
	MENU prefix ## INPUT_RANGE_page; \
	COMMAND prefix ## INPUT_RANGE_read; \
	COMMAND prefix ## INPUT_RANGE_write; \
	VARIABLE prefix ## LIN_TYPE; \
	MENU prefix ## LIN_TYPE_page; \
	COMMAND prefix ## LIN_TYPE_read; \
	COMMAND prefix ## LIN_TYPE_write; \
	VARIABLE prefix ## BIAS_1; \
	MENU prefix ## BIAS_1_page; \
	COMMAND prefix ## BIAS_1_read; \
	COMMAND prefix ## BIAS_1_write; \
	VARIABLE prefix ## UPPER_SENSOR_LIMIT; \
	MENU prefix ## UPPER_SENSOR_LIMIT_page; \
	COMMAND prefix ## UPPER_SENSOR_LIMIT_read; \
	VARIABLE prefix ## LOWER_SENSOR_LIMIT; \
	MENU prefix ## LOWER_SENSOR_LIMIT_page; \
	COMMAND prefix ## LOWER_SENSOR_LIMIT_read; \
	VARIABLE prefix ## INPUT_FAULT_GEN; \
	MENU prefix ## INPUT_FAULT_GEN_page; \
	COMMAND prefix ## INPUT_FAULT_GEN_read; \
	VARIABLE prefix ## INPUT_FAULT_1; \
	MENU prefix ## INPUT_FAULT_1_page; \
	COMMAND prefix ## INPUT_FAULT_1_read; \
	UNIT prefix ## Unit_1; \
	VARIABLE prefix ## PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD prefix ## PRIMARY_VALUE_UNIT_post; \
	MENU prefix ## Display; \
	CHART prefix ## Display_BarVal_pv; \
	SOURCE prefix ## Display_BarVal_pv_source; \
	MENU prefix ## Display_primary; \
	MENU prefix ## Display_secondary; \
	MENU prefix ## Tab_s; \
	MENU prefix ## Tab_s_measrange; \
	MENU prefix ## Tab_m

#define USE_TRANS_TEMP_MANDATORY_A(prefix) \
	USE_TRANS_TEMP_MANDATORY_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Mandatory_A

#define USE_TRANS_TEMP_MANDATORY_B(prefix) \
	USE_TRANS_TEMP_MANDATORY_BOTH(prefix); \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Mandatory_B

#define USE_TRANS_TEMP_OPTIONAL_BOTH(prefix) \
	COLLECTION prefix ## SECONDARY_VALUE_2; \
	VARIABLE prefix ## SECONDARY_VALUE_2_Value; \
	VARIABLE prefix ## SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE prefix ## SECONDARY_VALUE_2_Status_Limit; \
	MENU prefix ## SECONDARY_VALUE_2_page; \
	COMMAND prefix ## SECONDARY_VALUE_2_read; \
	VARIABLE prefix ## BIAS_2; \
	MENU prefix ## BIAS_2_page; \
	COMMAND prefix ## BIAS_2_read; \
	COMMAND prefix ## BIAS_2_write; \
	VARIABLE prefix ## INPUT_FAULT_2; \
	MENU prefix ## INPUT_FAULT_2_page; \
	COMMAND prefix ## INPUT_FAULT_2_read; \
	VARIABLE prefix ## SENSOR_WIRE_CHECK_1; \
	MENU prefix ## SENSOR_WIRE_CHECK_1_page; \
	COMMAND prefix ## SENSOR_WIRE_CHECK_1_read; \
	COMMAND prefix ## SENSOR_WIRE_CHECK_1_write; \
	VARIABLE prefix ## SENSOR_WIRE_CHECK_2; \
	MENU prefix ## SENSOR_WIRE_CHECK_2_page; \
	COMMAND prefix ## SENSOR_WIRE_CHECK_2_read; \
	COMMAND prefix ## SENSOR_WIRE_CHECK_2_write; \
	VARIABLE prefix ## MAX_SENSOR_VALUE_1; \
	MENU prefix ## MAX_SENSOR_VALUE_1_page; \
	COMMAND prefix ## MAX_SENSOR_VALUE_1_read; \
	COMMAND prefix ## MAX_SENSOR_VALUE_1_write; \
	VARIABLE prefix ## MIN_SENSOR_VALUE_1; \
	MENU prefix ## MIN_SENSOR_VALUE_1_page; \
	COMMAND prefix ## MIN_SENSOR_VALUE_1_read; \
	COMMAND prefix ## MIN_SENSOR_VALUE_1_write; \
	VARIABLE prefix ## MAX_SENSOR_VALUE_2; \
	MENU prefix ## MAX_SENSOR_VALUE_2_page; \
	COMMAND prefix ## MAX_SENSOR_VALUE_2_read; \
	COMMAND prefix ## MAX_SENSOR_VALUE_2_write; \
	VARIABLE prefix ## MIN_SENSOR_VALUE_2; \
	MENU prefix ## MIN_SENSOR_VALUE_2_page; \
	COMMAND prefix ## MIN_SENSOR_VALUE_2_read; \
	COMMAND prefix ## MIN_SENSOR_VALUE_2_write; \
	VARIABLE prefix ## TAB_ENTRY; \
	MENU prefix ## TAB_ENTRY_page; \
	COMMAND prefix ## TAB_ENTRY_read; \
	COMMAND prefix ## TAB_ENTRY_write; \
	COLLECTION prefix ## TAB_X_Y_VALUE; \
	VARIABLE prefix ## TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE prefix ## TAB_X_Y_VALUE_Lower_Value; \
	MENU prefix ## TAB_X_Y_VALUE_page; \
	COMMAND prefix ## TAB_X_Y_VALUE_read; \
	COMMAND prefix ## TAB_X_Y_VALUE_write; \
	VARIABLE prefix ## TAB_MIN_NUMBER; \
	MENU prefix ## TAB_MIN_NUMBER_page; \
	COMMAND prefix ## TAB_MIN_NUMBER_read; \
	VARIABLE prefix ## TAB_MAX_NUMBER; \
	MENU prefix ## TAB_MAX_NUMBER_page; \
	COMMAND prefix ## TAB_MAX_NUMBER_read; \
	VARIABLE prefix ## TAB_OP_CODE; \
	MENU prefix ## TAB_OP_CODE_page; \
	COMMAND prefix ## TAB_OP_CODE_read; \
	COMMAND prefix ## TAB_OP_CODE_write; \
	VARIABLE prefix ## TAB_STATUS; \
	MENU prefix ## TAB_STATUS_page; \
	COMMAND prefix ## TAB_STATUS_read; \
	VARIABLE prefix ## TAB_ACTUAL_NUMBER; \
	MENU prefix ## TAB_ACTUAL_NUMBER_page; \
	COMMAND prefix ## TAB_ACTUAL_NUMBER_read; \
	UNIT prefix ## Unit_2

#define USE_TRANS_TEMP_OPTIONAL_A(prefix) \
	USE_TRANS_TEMP_OPTIONAL_BOTH(prefix); \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Optional_A

#define USE_TRANS_TEMP_OPTIONAL_B(prefix) \
	USE_TRANS_TEMP_OPTIONAL_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Optional_B

#define USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(prefix) \
	VARIABLE prefix ## RJ_TYPE; \
	MENU prefix ## RJ_TYPE_page; \
	COMMAND prefix ## RJ_TYPE_read; \
	COMMAND prefix ## RJ_TYPE_write; \
	MENU prefix ## Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(prefix) \
	VARIABLE prefix ## SENSOR_CONNECTION; \
	MENU prefix ## SENSOR_CONNECTION_page; \
	COMMAND prefix ## SENSOR_CONNECTION_read; \
	COMMAND prefix ## SENSOR_CONNECTION_write; \
	VARIABLE prefix ## COMP_WIRE1; \
	MENU prefix ## COMP_WIRE1_page; \
	COMMAND prefix ## COMP_WIRE1_read; \
	COMMAND prefix ## COMP_WIRE1_write; \
	MENU prefix ## Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS_TEMP_PYROMETER_MANDATORY_A(prefix) \
	VARIABLE prefix ## EMISSIVITY; \
	MENU prefix ## EMISSIVITY_page; \
	COMMAND prefix ## EMISSIVITY_read; \
	COMMAND prefix ## EMISSIVITY_write; \
	VARIABLE prefix ## PEAK_TRACK; \
	MENU prefix ## PEAK_TRACK_page; \
	COMMAND prefix ## PEAK_TRACK_read; \
	COMMAND prefix ## PEAK_TRACK_write; \
	VARIABLE prefix ## DECAY_RATE; \
	MENU prefix ## DECAY_RATE_page; \
	COMMAND prefix ## DECAY_RATE_read; \
	COMMAND prefix ## DECAY_RATE_write; \
	VARIABLE prefix ## PEAK_TIME; \
	MENU prefix ## PEAK_TIME_page; \
	COMMAND prefix ## PEAK_TIME_read; \
	COMMAND prefix ## PEAK_TIME_write; \
	VARIABLE prefix ## TRACK_HOLD; \
	MENU prefix ## TRACK_HOLD_page; \
	COMMAND prefix ## TRACK_HOLD_read; \
	COMMAND prefix ## TRACK_HOLD_write; \
	VARIABLE prefix ## SPECT_FILT_SET; \
	MENU prefix ## SPECT_FILT_SET_page; \
	COMMAND prefix ## SPECT_FILT_SET_read; \
	COMMAND prefix ## SPECT_FILT_SET_write; \
	MENU prefix ## Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(prefix) \
	VARIABLE prefix ## RJ_TYPE; \
	MENU prefix ## RJ_TYPE_page; \
	COMMAND prefix ## RJ_TYPE_read; \
	COMMAND prefix ## RJ_TYPE_write; \
	MENU prefix ## Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(prefix) \
	VARIABLE prefix ## SENSOR_CONNECTION; \
	MENU prefix ## SENSOR_CONNECTION_page; \
	COMMAND prefix ## SENSOR_CONNECTION_read; \
	COMMAND prefix ## SENSOR_CONNECTION_write; \
	VARIABLE prefix ## COMP_WIRE1; \
	MENU prefix ## COMP_WIRE1_page; \
	COMMAND prefix ## COMP_WIRE1_read; \
	COMMAND prefix ## COMP_WIRE1_write; \
	MENU prefix ## Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS_TEMP_PYROMETER_MANDATORY_B(prefix) \
	VARIABLE prefix ## EMISSIVITY; \
	MENU prefix ## EMISSIVITY_page; \
	COMMAND prefix ## EMISSIVITY_read; \
	COMMAND prefix ## EMISSIVITY_write; \
	VARIABLE prefix ## PEAK_TRACK; \
	MENU prefix ## PEAK_TRACK_page; \
	COMMAND prefix ## PEAK_TRACK_read; \
	COMMAND prefix ## PEAK_TRACK_write; \
	VARIABLE prefix ## DECAY_RATE; \
	MENU prefix ## DECAY_RATE_page; \
	COMMAND prefix ## DECAY_RATE_read; \
	COMMAND prefix ## DECAY_RATE_write; \
	VARIABLE prefix ## PEAK_TIME; \
	MENU prefix ## PEAK_TIME_page; \
	COMMAND prefix ## PEAK_TIME_read; \
	COMMAND prefix ## PEAK_TIME_write; \
	VARIABLE prefix ## TRACK_HOLD; \
	MENU prefix ## TRACK_HOLD_page; \
	COMMAND prefix ## TRACK_HOLD_read; \
	COMMAND prefix ## TRACK_HOLD_write; \
	VARIABLE prefix ## SPECT_FILT_SET; \
	MENU prefix ## SPECT_FILT_SET_page; \
	COMMAND prefix ## SPECT_FILT_SET_read; \
	COMMAND prefix ## SPECT_FILT_SET_write; \
	MENU prefix ## Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(prefix) \
	VARIABLE prefix ## RJ_TEMP; \
	MENU prefix ## RJ_TEMP_page; \
	COMMAND prefix ## RJ_TEMP_read; \
	VARIABLE prefix ## EXTERNAL_RJ_VALUE; \
	MENU prefix ## EXTERNAL_RJ_VALUE_page; \
	COMMAND prefix ## EXTERNAL_RJ_VALUE_read; \
	COMMAND prefix ## EXTERNAL_RJ_VALUE_write; \
	MENU prefix ## Thermocouple_Simple_Dialog_Optional_A; \
	UNIT prefix ## Unit_3

#define USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(prefix) \
	VARIABLE prefix ## COMP_WIRE2; \
	MENU prefix ## COMP_WIRE2_page; \
	COMMAND prefix ## COMP_WIRE2_read; \
	COMMAND prefix ## COMP_WIRE2_write; \
	MENU prefix ## Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(prefix) \
	MENU prefix ## Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(prefix) \
	VARIABLE prefix ## RJ_TEMP; \
	MENU prefix ## RJ_TEMP_page; \
	COMMAND prefix ## RJ_TEMP_read; \
	VARIABLE prefix ## EXTERNAL_RJ_VALUE; \
	MENU prefix ## EXTERNAL_RJ_VALUE_page; \
	COMMAND prefix ## EXTERNAL_RJ_VALUE_read; \
	COMMAND prefix ## EXTERNAL_RJ_VALUE_write; \
	MENU prefix ## Thermocouple_Simple_Dialog_Optional_B; \
	UNIT prefix ## Unit_3

#define USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(prefix) \
	VARIABLE prefix ## COMP_WIRE2; \
	MENU prefix ## COMP_WIRE2_page; \
	COMMAND prefix ## COMP_WIRE2_read; \
	COMMAND prefix ## COMP_WIRE2_write; \
	MENU prefix ## Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(prefix) \
	MENU prefix ## Pyrometer_Simple_Dialog_Optional_B

#define USE_TRANS1_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans1_Temp_)
#define USE_TRANS1_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans1_Temp_)
#define USE_TRANS1_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans1_Temp_)
#define USE_TRANS1_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans1_Temp_)
#define USE_TRANS1_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans1_Temp_)
#define USE_TRANS1_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans1_Temp_)
#define USE_TRANS1_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans1_Temp_)
#define USE_TRANS1_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans1_Temp_)
#define USE_TRANS1_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans1_Temp_)
#define USE_TRANS1_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans1_Temp_)
#define USE_TRANS1_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans1_Temp_)
#define USE_TRANS1_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans1_Temp_)
#define USE_TRANS1_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans1_Temp_)
#define USE_TRANS1_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans1_Temp_)
#define USE_TRANS1_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans1_Temp_)
#define USE_TRANS1_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans1_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS2_TEMP_MANDATORY_BOTH \
	BLOCK trans2_Temp_block; \
	COLLECTION trans2_Temp_BLOCK_OBJECT; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans2_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans2_Temp_BLOCK_OBJECT_page; \
	COMMAND trans2_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans2_Temp_ST_REV; \
	MENU trans2_Temp_ST_REV_page; \
	COMMAND trans2_Temp_ST_REV_read; \
	VARIABLE trans2_Temp_TAG_DESC; \
	MENU trans2_Temp_TAG_DESC_page; \
	COMMAND trans2_Temp_TAG_DESC_read; \
	COMMAND trans2_Temp_TAG_DESC_write; \
	VARIABLE trans2_Temp_STRATEGY; \
	MENU trans2_Temp_STRATEGY_page; \
	COMMAND trans2_Temp_STRATEGY_read; \
	COMMAND trans2_Temp_STRATEGY_write; \
	VARIABLE trans2_Temp_ALERT_KEY; \
	MENU trans2_Temp_ALERT_KEY_page; \
	COMMAND trans2_Temp_ALERT_KEY_read; \
	COMMAND trans2_Temp_ALERT_KEY_write; \
	VARIABLE trans2_Temp_TARGET_MODE; \
	MENU trans2_Temp_TARGET_MODE_page; \
	COMMAND trans2_Temp_TARGET_MODE_read; \
	COMMAND trans2_Temp_TARGET_MODE_write; \
	COLLECTION trans2_Temp_MODE_BLK; \
	VARIABLE trans2_Temp_MODE_BLK_Actual; \
	VARIABLE trans2_Temp_MODE_BLK_Permitted; \
	VARIABLE trans2_Temp_MODE_BLK_Normal; \
	MENU trans2_Temp_MODE_BLK_page; \
	COMMAND trans2_Temp_MODE_BLK_read; \
	COLLECTION trans2_Temp_ALARM_SUM; \
	VARIABLE trans2_Temp_ALARM_SUM_Current; \
	VARIABLE trans2_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans2_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans2_Temp_ALARM_SUM_Disabled; \
	MENU trans2_Temp_ALARM_SUM_page; \
	COMMAND trans2_Temp_ALARM_SUM_read; \
	COLLECTION trans2_Temp_PRIMARY_VALUE; \
	VARIABLE trans2_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans2_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans2_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans2_Temp_PRIMARY_VALUE_page; \
	COMMAND trans2_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans2_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans2_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans2_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans2_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans2_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans2_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans2_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans2_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans2_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans2_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans2_Temp_SENSOR_MEAS_TYPE; \
	MENU trans2_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans2_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans2_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans2_Temp_INPUT_RANGE; \
	MENU trans2_Temp_INPUT_RANGE_page; \
	COMMAND trans2_Temp_INPUT_RANGE_read; \
	COMMAND trans2_Temp_INPUT_RANGE_write; \
	VARIABLE trans2_Temp_LIN_TYPE; \
	MENU trans2_Temp_LIN_TYPE_page; \
	COMMAND trans2_Temp_LIN_TYPE_read; \
	COMMAND trans2_Temp_LIN_TYPE_write; \
	VARIABLE trans2_Temp_BIAS_1; \
	MENU trans2_Temp_BIAS_1_page; \
	COMMAND trans2_Temp_BIAS_1_read; \
	COMMAND trans2_Temp_BIAS_1_write; \
	VARIABLE trans2_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans2_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans2_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans2_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans2_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans2_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans2_Temp_INPUT_FAULT_GEN; \
	MENU trans2_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans2_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans2_Temp_INPUT_FAULT_1; \
	MENU trans2_Temp_INPUT_FAULT_1_page; \
	COMMAND trans2_Temp_INPUT_FAULT_1_read; \
	UNIT trans2_Temp_Unit_1; \
	VARIABLE trans2_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans2_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans2_Temp_Display; \
	CHART trans2_Temp_Display_BarVal_pv; \
	SOURCE trans2_Temp_Display_BarVal_pv_source; \
	MENU trans2_Temp_Display_primary; \
	MENU trans2_Temp_Display_secondary; \
	MENU trans2_Temp_Tab_s; \
	MENU trans2_Temp_Tab_s_measrange; \
	MENU trans2_Temp_Tab_m

#define USE_TRANS2_TEMP_MANDATORY_A \
	USE_TRANS2_TEMP_MANDATORY_BOTH; \
	MENU trans2_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS2_TEMP_MANDATORY_B \
	USE_TRANS2_TEMP_MANDATORY_BOTH; \
	COLLECTION trans2_Temp_VIEW_1; \
	MENU trans2_Temp_VIEW_1_page; \
	MENU trans2_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS2_TEMP_OPTIONAL_BOTH \
	COLLECTION trans2_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans2_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans2_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans2_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans2_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans2_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans2_Temp_BIAS_2; \
	MENU trans2_Temp_BIAS_2_page; \
	COMMAND trans2_Temp_BIAS_2_read; \
	COMMAND trans2_Temp_BIAS_2_write; \
	VARIABLE trans2_Temp_INPUT_FAULT_2; \
	MENU trans2_Temp_INPUT_FAULT_2_page; \
	COMMAND trans2_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans2_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans2_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans2_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans2_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans2_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans2_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans2_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans2_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans2_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans2_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans2_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans2_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans2_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans2_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans2_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans2_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans2_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans2_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans2_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans2_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans2_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans2_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans2_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans2_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans2_Temp_TAB_ENTRY; \
	MENU trans2_Temp_TAB_ENTRY_page; \
	COMMAND trans2_Temp_TAB_ENTRY_read; \
	COMMAND trans2_Temp_TAB_ENTRY_write; \
	COLLECTION trans2_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans2_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans2_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans2_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans2_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans2_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans2_Temp_TAB_MIN_NUMBER; \
	MENU trans2_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans2_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans2_Temp_TAB_MAX_NUMBER; \
	MENU trans2_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans2_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans2_Temp_TAB_OP_CODE; \
	MENU trans2_Temp_TAB_OP_CODE_page; \
	COMMAND trans2_Temp_TAB_OP_CODE_read; \
	COMMAND trans2_Temp_TAB_OP_CODE_write; \
	VARIABLE trans2_Temp_TAB_STATUS; \
	MENU trans2_Temp_TAB_STATUS_page; \
	COMMAND trans2_Temp_TAB_STATUS_read; \
	VARIABLE trans2_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans2_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans2_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans2_Temp_Unit_2

#define USE_TRANS2_TEMP_OPTIONAL_A \
	USE_TRANS2_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans2_Temp_VIEW_1; \
	MENU trans2_Temp_VIEW_1_page; \
	MENU trans2_Temp_Simple_Dialog_Optional_A

#define USE_TRANS2_TEMP_OPTIONAL_B \
	USE_TRANS2_TEMP_OPTIONAL_BOTH; \
	MENU trans2_Temp_Simple_Dialog_Optional_B

#define USE_TRANS2_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans2_Temp_RJ_TYPE; \
	MENU trans2_Temp_RJ_TYPE_page; \
	COMMAND trans2_Temp_RJ_TYPE_read; \
	COMMAND trans2_Temp_RJ_TYPE_write; \
	MENU trans2_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS2_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans2_Temp_SENSOR_CONNECTION; \
	MENU trans2_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans2_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans2_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans2_Temp_COMP_WIRE1; \
	MENU trans2_Temp_COMP_WIRE1_page; \
	COMMAND trans2_Temp_COMP_WIRE1_read; \
	COMMAND trans2_Temp_COMP_WIRE1_write; \
	MENU trans2_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS2_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans2_Temp_EMISSIVITY; \
	MENU trans2_Temp_EMISSIVITY_page; \
	COMMAND trans2_Temp_EMISSIVITY_read; \
	COMMAND trans2_Temp_EMISSIVITY_write; \
	VARIABLE trans2_Temp_PEAK_TRACK; \
	MENU trans2_Temp_PEAK_TRACK_page; \
	COMMAND trans2_Temp_PEAK_TRACK_read; \
	COMMAND trans2_Temp_PEAK_TRACK_write; \
	VARIABLE trans2_Temp_DECAY_RATE; \
	MENU trans2_Temp_DECAY_RATE_page; \
	COMMAND trans2_Temp_DECAY_RATE_read; \
	COMMAND trans2_Temp_DECAY_RATE_write; \
	VARIABLE trans2_Temp_PEAK_TIME; \
	MENU trans2_Temp_PEAK_TIME_page; \
	COMMAND trans2_Temp_PEAK_TIME_read; \
	COMMAND trans2_Temp_PEAK_TIME_write; \
	VARIABLE trans2_Temp_TRACK_HOLD; \
	MENU trans2_Temp_TRACK_HOLD_page; \
	COMMAND trans2_Temp_TRACK_HOLD_read; \
	COMMAND trans2_Temp_TRACK_HOLD_write; \
	VARIABLE trans2_Temp_SPECT_FILT_SET; \
	MENU trans2_Temp_SPECT_FILT_SET_page; \
	COMMAND trans2_Temp_SPECT_FILT_SET_read; \
	COMMAND trans2_Temp_SPECT_FILT_SET_write; \
	MENU trans2_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS2_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans2_Temp_RJ_TYPE; \
	MENU trans2_Temp_RJ_TYPE_page; \
	COMMAND trans2_Temp_RJ_TYPE_read; \
	COMMAND trans2_Temp_RJ_TYPE_write; \
	MENU trans2_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS2_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans2_Temp_SENSOR_CONNECTION; \
	MENU trans2_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans2_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans2_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans2_Temp_COMP_WIRE1; \
	MENU trans2_Temp_COMP_WIRE1_page; \
	COMMAND trans2_Temp_COMP_WIRE1_read; \
	COMMAND trans2_Temp_COMP_WIRE1_write; \
	MENU trans2_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS2_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans2_Temp_EMISSIVITY; \
	MENU trans2_Temp_EMISSIVITY_page; \
	COMMAND trans2_Temp_EMISSIVITY_read; \
	COMMAND trans2_Temp_EMISSIVITY_write; \
	VARIABLE trans2_Temp_PEAK_TRACK; \
	MENU trans2_Temp_PEAK_TRACK_page; \
	COMMAND trans2_Temp_PEAK_TRACK_read; \
	COMMAND trans2_Temp_PEAK_TRACK_write; \
	VARIABLE trans2_Temp_DECAY_RATE; \
	MENU trans2_Temp_DECAY_RATE_page; \
	COMMAND trans2_Temp_DECAY_RATE_read; \
	COMMAND trans2_Temp_DECAY_RATE_write; \
	VARIABLE trans2_Temp_PEAK_TIME; \
	MENU trans2_Temp_PEAK_TIME_page; \
	COMMAND trans2_Temp_PEAK_TIME_read; \
	COMMAND trans2_Temp_PEAK_TIME_write; \
	VARIABLE trans2_Temp_TRACK_HOLD; \
	MENU trans2_Temp_TRACK_HOLD_page; \
	COMMAND trans2_Temp_TRACK_HOLD_read; \
	COMMAND trans2_Temp_TRACK_HOLD_write; \
	VARIABLE trans2_Temp_SPECT_FILT_SET; \
	MENU trans2_Temp_SPECT_FILT_SET_page; \
	COMMAND trans2_Temp_SPECT_FILT_SET_read; \
	COMMAND trans2_Temp_SPECT_FILT_SET_write; \
	MENU trans2_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS2_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans2_Temp_RJ_TEMP; \
	MENU trans2_Temp_RJ_TEMP_page; \
	COMMAND trans2_Temp_RJ_TEMP_read; \
	VARIABLE trans2_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans2_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans2_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans2_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans2_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans2_Temp_Unit_3

#define USE_TRANS2_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans2_Temp_COMP_WIRE2; \
	MENU trans2_Temp_COMP_WIRE2_page; \
	COMMAND trans2_Temp_COMP_WIRE2_read; \
	COMMAND trans2_Temp_COMP_WIRE2_write; \
	MENU trans2_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS2_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans2_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS2_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans2_Temp_RJ_TEMP; \
	MENU trans2_Temp_RJ_TEMP_page; \
	COMMAND trans2_Temp_RJ_TEMP_read; \
	VARIABLE trans2_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans2_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans2_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans2_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans2_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans2_Temp_Unit_3

#define USE_TRANS2_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans2_Temp_COMP_WIRE2; \
	MENU trans2_Temp_COMP_WIRE2_page; \
	COMMAND trans2_Temp_COMP_WIRE2_read; \
	COMMAND trans2_Temp_COMP_WIRE2_write; \
	MENU trans2_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS2_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans2_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS2_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans2_Temp_)
#define USE_TRANS2_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans2_Temp_)
#define USE_TRANS2_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans2_Temp_)
#define USE_TRANS2_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans2_Temp_)
#define USE_TRANS2_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans2_Temp_)
#define USE_TRANS2_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans2_Temp_)
#define USE_TRANS2_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans2_Temp_)
#define USE_TRANS2_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans2_Temp_)
#define USE_TRANS2_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans2_Temp_)
#define USE_TRANS2_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans2_Temp_)
#define USE_TRANS2_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans2_Temp_)
#define USE_TRANS2_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans2_Temp_)
#define USE_TRANS2_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans2_Temp_)
#define USE_TRANS2_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans2_Temp_)
#define USE_TRANS2_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans2_Temp_)
#define USE_TRANS2_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans2_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS3_TEMP_MANDATORY_BOTH \
	BLOCK trans3_Temp_block; \
	COLLECTION trans3_Temp_BLOCK_OBJECT; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans3_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans3_Temp_BLOCK_OBJECT_page; \
	COMMAND trans3_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans3_Temp_ST_REV; \
	MENU trans3_Temp_ST_REV_page; \
	COMMAND trans3_Temp_ST_REV_read; \
	VARIABLE trans3_Temp_TAG_DESC; \
	MENU trans3_Temp_TAG_DESC_page; \
	COMMAND trans3_Temp_TAG_DESC_read; \
	COMMAND trans3_Temp_TAG_DESC_write; \
	VARIABLE trans3_Temp_STRATEGY; \
	MENU trans3_Temp_STRATEGY_page; \
	COMMAND trans3_Temp_STRATEGY_read; \
	COMMAND trans3_Temp_STRATEGY_write; \
	VARIABLE trans3_Temp_ALERT_KEY; \
	MENU trans3_Temp_ALERT_KEY_page; \
	COMMAND trans3_Temp_ALERT_KEY_read; \
	COMMAND trans3_Temp_ALERT_KEY_write; \
	VARIABLE trans3_Temp_TARGET_MODE; \
	MENU trans3_Temp_TARGET_MODE_page; \
	COMMAND trans3_Temp_TARGET_MODE_read; \
	COMMAND trans3_Temp_TARGET_MODE_write; \
	COLLECTION trans3_Temp_MODE_BLK; \
	VARIABLE trans3_Temp_MODE_BLK_Actual; \
	VARIABLE trans3_Temp_MODE_BLK_Permitted; \
	VARIABLE trans3_Temp_MODE_BLK_Normal; \
	MENU trans3_Temp_MODE_BLK_page; \
	COMMAND trans3_Temp_MODE_BLK_read; \
	COLLECTION trans3_Temp_ALARM_SUM; \
	VARIABLE trans3_Temp_ALARM_SUM_Current; \
	VARIABLE trans3_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans3_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans3_Temp_ALARM_SUM_Disabled; \
	MENU trans3_Temp_ALARM_SUM_page; \
	COMMAND trans3_Temp_ALARM_SUM_read; \
	COLLECTION trans3_Temp_PRIMARY_VALUE; \
	VARIABLE trans3_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans3_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans3_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans3_Temp_PRIMARY_VALUE_page; \
	COMMAND trans3_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans3_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans3_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans3_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans3_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans3_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans3_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans3_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans3_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans3_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans3_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans3_Temp_SENSOR_MEAS_TYPE; \
	MENU trans3_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans3_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans3_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans3_Temp_INPUT_RANGE; \
	MENU trans3_Temp_INPUT_RANGE_page; \
	COMMAND trans3_Temp_INPUT_RANGE_read; \
	COMMAND trans3_Temp_INPUT_RANGE_write; \
	VARIABLE trans3_Temp_LIN_TYPE; \
	MENU trans3_Temp_LIN_TYPE_page; \
	COMMAND trans3_Temp_LIN_TYPE_read; \
	COMMAND trans3_Temp_LIN_TYPE_write; \
	VARIABLE trans3_Temp_BIAS_1; \
	MENU trans3_Temp_BIAS_1_page; \
	COMMAND trans3_Temp_BIAS_1_read; \
	COMMAND trans3_Temp_BIAS_1_write; \
	VARIABLE trans3_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans3_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans3_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans3_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans3_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans3_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans3_Temp_INPUT_FAULT_GEN; \
	MENU trans3_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans3_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans3_Temp_INPUT_FAULT_1; \
	MENU trans3_Temp_INPUT_FAULT_1_page; \
	COMMAND trans3_Temp_INPUT_FAULT_1_read; \
	UNIT trans3_Temp_Unit_1; \
	VARIABLE trans3_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans3_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans3_Temp_Display; \
	CHART trans3_Temp_Display_BarVal_pv; \
	SOURCE trans3_Temp_Display_BarVal_pv_source; \
	MENU trans3_Temp_Display_primary; \
	MENU trans3_Temp_Display_secondary; \
	MENU trans3_Temp_Tab_s; \
	MENU trans3_Temp_Tab_s_measrange; \
	MENU trans3_Temp_Tab_m

#define USE_TRANS3_TEMP_MANDATORY_A \
	USE_TRANS3_TEMP_MANDATORY_BOTH; \
	MENU trans3_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS3_TEMP_MANDATORY_B \
	USE_TRANS3_TEMP_MANDATORY_BOTH; \
	COLLECTION trans3_Temp_VIEW_1; \
	MENU trans3_Temp_VIEW_1_page; \
	MENU trans3_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS3_TEMP_OPTIONAL_BOTH \
	COLLECTION trans3_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans3_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans3_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans3_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans3_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans3_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans3_Temp_BIAS_2; \
	MENU trans3_Temp_BIAS_2_page; \
	COMMAND trans3_Temp_BIAS_2_read; \
	COMMAND trans3_Temp_BIAS_2_write; \
	VARIABLE trans3_Temp_INPUT_FAULT_2; \
	MENU trans3_Temp_INPUT_FAULT_2_page; \
	COMMAND trans3_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans3_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans3_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans3_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans3_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans3_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans3_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans3_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans3_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans3_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans3_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans3_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans3_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans3_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans3_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans3_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans3_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans3_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans3_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans3_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans3_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans3_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans3_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans3_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans3_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans3_Temp_TAB_ENTRY; \
	MENU trans3_Temp_TAB_ENTRY_page; \
	COMMAND trans3_Temp_TAB_ENTRY_read; \
	COMMAND trans3_Temp_TAB_ENTRY_write; \
	COLLECTION trans3_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans3_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans3_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans3_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans3_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans3_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans3_Temp_TAB_MIN_NUMBER; \
	MENU trans3_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans3_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans3_Temp_TAB_MAX_NUMBER; \
	MENU trans3_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans3_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans3_Temp_TAB_OP_CODE; \
	MENU trans3_Temp_TAB_OP_CODE_page; \
	COMMAND trans3_Temp_TAB_OP_CODE_read; \
	COMMAND trans3_Temp_TAB_OP_CODE_write; \
	VARIABLE trans3_Temp_TAB_STATUS; \
	MENU trans3_Temp_TAB_STATUS_page; \
	COMMAND trans3_Temp_TAB_STATUS_read; \
	VARIABLE trans3_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans3_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans3_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans3_Temp_Unit_2

#define USE_TRANS3_TEMP_OPTIONAL_A \
	USE_TRANS3_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans3_Temp_VIEW_1; \
	MENU trans3_Temp_VIEW_1_page; \
	MENU trans3_Temp_Simple_Dialog_Optional_A

#define USE_TRANS3_TEMP_OPTIONAL_B \
	USE_TRANS3_TEMP_OPTIONAL_BOTH; \
	MENU trans3_Temp_Simple_Dialog_Optional_B

#define USE_TRANS3_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans3_Temp_RJ_TYPE; \
	MENU trans3_Temp_RJ_TYPE_page; \
	COMMAND trans3_Temp_RJ_TYPE_read; \
	COMMAND trans3_Temp_RJ_TYPE_write; \
	MENU trans3_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS3_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans3_Temp_SENSOR_CONNECTION; \
	MENU trans3_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans3_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans3_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans3_Temp_COMP_WIRE1; \
	MENU trans3_Temp_COMP_WIRE1_page; \
	COMMAND trans3_Temp_COMP_WIRE1_read; \
	COMMAND trans3_Temp_COMP_WIRE1_write; \
	MENU trans3_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS3_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans3_Temp_EMISSIVITY; \
	MENU trans3_Temp_EMISSIVITY_page; \
	COMMAND trans3_Temp_EMISSIVITY_read; \
	COMMAND trans3_Temp_EMISSIVITY_write; \
	VARIABLE trans3_Temp_PEAK_TRACK; \
	MENU trans3_Temp_PEAK_TRACK_page; \
	COMMAND trans3_Temp_PEAK_TRACK_read; \
	COMMAND trans3_Temp_PEAK_TRACK_write; \
	VARIABLE trans3_Temp_DECAY_RATE; \
	MENU trans3_Temp_DECAY_RATE_page; \
	COMMAND trans3_Temp_DECAY_RATE_read; \
	COMMAND trans3_Temp_DECAY_RATE_write; \
	VARIABLE trans3_Temp_PEAK_TIME; \
	MENU trans3_Temp_PEAK_TIME_page; \
	COMMAND trans3_Temp_PEAK_TIME_read; \
	COMMAND trans3_Temp_PEAK_TIME_write; \
	VARIABLE trans3_Temp_TRACK_HOLD; \
	MENU trans3_Temp_TRACK_HOLD_page; \
	COMMAND trans3_Temp_TRACK_HOLD_read; \
	COMMAND trans3_Temp_TRACK_HOLD_write; \
	VARIABLE trans3_Temp_SPECT_FILT_SET; \
	MENU trans3_Temp_SPECT_FILT_SET_page; \
	COMMAND trans3_Temp_SPECT_FILT_SET_read; \
	COMMAND trans3_Temp_SPECT_FILT_SET_write; \
	MENU trans3_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS3_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans3_Temp_RJ_TYPE; \
	MENU trans3_Temp_RJ_TYPE_page; \
	COMMAND trans3_Temp_RJ_TYPE_read; \
	COMMAND trans3_Temp_RJ_TYPE_write; \
	MENU trans3_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS3_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans3_Temp_SENSOR_CONNECTION; \
	MENU trans3_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans3_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans3_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans3_Temp_COMP_WIRE1; \
	MENU trans3_Temp_COMP_WIRE1_page; \
	COMMAND trans3_Temp_COMP_WIRE1_read; \
	COMMAND trans3_Temp_COMP_WIRE1_write; \
	MENU trans3_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS3_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans3_Temp_EMISSIVITY; \
	MENU trans3_Temp_EMISSIVITY_page; \
	COMMAND trans3_Temp_EMISSIVITY_read; \
	COMMAND trans3_Temp_EMISSIVITY_write; \
	VARIABLE trans3_Temp_PEAK_TRACK; \
	MENU trans3_Temp_PEAK_TRACK_page; \
	COMMAND trans3_Temp_PEAK_TRACK_read; \
	COMMAND trans3_Temp_PEAK_TRACK_write; \
	VARIABLE trans3_Temp_DECAY_RATE; \
	MENU trans3_Temp_DECAY_RATE_page; \
	COMMAND trans3_Temp_DECAY_RATE_read; \
	COMMAND trans3_Temp_DECAY_RATE_write; \
	VARIABLE trans3_Temp_PEAK_TIME; \
	MENU trans3_Temp_PEAK_TIME_page; \
	COMMAND trans3_Temp_PEAK_TIME_read; \
	COMMAND trans3_Temp_PEAK_TIME_write; \
	VARIABLE trans3_Temp_TRACK_HOLD; \
	MENU trans3_Temp_TRACK_HOLD_page; \
	COMMAND trans3_Temp_TRACK_HOLD_read; \
	COMMAND trans3_Temp_TRACK_HOLD_write; \
	VARIABLE trans3_Temp_SPECT_FILT_SET; \
	MENU trans3_Temp_SPECT_FILT_SET_page; \
	COMMAND trans3_Temp_SPECT_FILT_SET_read; \
	COMMAND trans3_Temp_SPECT_FILT_SET_write; \
	MENU trans3_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS3_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans3_Temp_RJ_TEMP; \
	MENU trans3_Temp_RJ_TEMP_page; \
	COMMAND trans3_Temp_RJ_TEMP_read; \
	VARIABLE trans3_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans3_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans3_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans3_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans3_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans3_Temp_Unit_3

#define USE_TRANS3_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans3_Temp_COMP_WIRE2; \
	MENU trans3_Temp_COMP_WIRE2_page; \
	COMMAND trans3_Temp_COMP_WIRE2_read; \
	COMMAND trans3_Temp_COMP_WIRE2_write; \
	MENU trans3_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS3_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans3_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS3_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans3_Temp_RJ_TEMP; \
	MENU trans3_Temp_RJ_TEMP_page; \
	COMMAND trans3_Temp_RJ_TEMP_read; \
	VARIABLE trans3_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans3_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans3_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans3_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans3_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans3_Temp_Unit_3

#define USE_TRANS3_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans3_Temp_COMP_WIRE2; \
	MENU trans3_Temp_COMP_WIRE2_page; \
	COMMAND trans3_Temp_COMP_WIRE2_read; \
	COMMAND trans3_Temp_COMP_WIRE2_write; \
	MENU trans3_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS3_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans3_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS3_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans3_Temp_)
#define USE_TRANS3_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans3_Temp_)
#define USE_TRANS3_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans3_Temp_)
#define USE_TRANS3_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans3_Temp_)
#define USE_TRANS3_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans3_Temp_)
#define USE_TRANS3_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans3_Temp_)
#define USE_TRANS3_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans3_Temp_)
#define USE_TRANS3_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans3_Temp_)
#define USE_TRANS3_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans3_Temp_)
#define USE_TRANS3_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans3_Temp_)
#define USE_TRANS3_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans3_Temp_)
#define USE_TRANS3_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans3_Temp_)
#define USE_TRANS3_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans3_Temp_)
#define USE_TRANS3_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans3_Temp_)
#define USE_TRANS3_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans3_Temp_)
#define USE_TRANS3_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans3_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS4_TEMP_MANDATORY_BOTH \
	BLOCK trans4_Temp_block; \
	COLLECTION trans4_Temp_BLOCK_OBJECT; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans4_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans4_Temp_BLOCK_OBJECT_page; \
	COMMAND trans4_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans4_Temp_ST_REV; \
	MENU trans4_Temp_ST_REV_page; \
	COMMAND trans4_Temp_ST_REV_read; \
	VARIABLE trans4_Temp_TAG_DESC; \
	MENU trans4_Temp_TAG_DESC_page; \
	COMMAND trans4_Temp_TAG_DESC_read; \
	COMMAND trans4_Temp_TAG_DESC_write; \
	VARIABLE trans4_Temp_STRATEGY; \
	MENU trans4_Temp_STRATEGY_page; \
	COMMAND trans4_Temp_STRATEGY_read; \
	COMMAND trans4_Temp_STRATEGY_write; \
	VARIABLE trans4_Temp_ALERT_KEY; \
	MENU trans4_Temp_ALERT_KEY_page; \
	COMMAND trans4_Temp_ALERT_KEY_read; \
	COMMAND trans4_Temp_ALERT_KEY_write; \
	VARIABLE trans4_Temp_TARGET_MODE; \
	MENU trans4_Temp_TARGET_MODE_page; \
	COMMAND trans4_Temp_TARGET_MODE_read; \
	COMMAND trans4_Temp_TARGET_MODE_write; \
	COLLECTION trans4_Temp_MODE_BLK; \
	VARIABLE trans4_Temp_MODE_BLK_Actual; \
	VARIABLE trans4_Temp_MODE_BLK_Permitted; \
	VARIABLE trans4_Temp_MODE_BLK_Normal; \
	MENU trans4_Temp_MODE_BLK_page; \
	COMMAND trans4_Temp_MODE_BLK_read; \
	COLLECTION trans4_Temp_ALARM_SUM; \
	VARIABLE trans4_Temp_ALARM_SUM_Current; \
	VARIABLE trans4_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans4_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans4_Temp_ALARM_SUM_Disabled; \
	MENU trans4_Temp_ALARM_SUM_page; \
	COMMAND trans4_Temp_ALARM_SUM_read; \
	COLLECTION trans4_Temp_PRIMARY_VALUE; \
	VARIABLE trans4_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans4_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans4_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans4_Temp_PRIMARY_VALUE_page; \
	COMMAND trans4_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans4_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans4_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans4_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans4_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans4_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans4_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans4_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans4_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans4_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans4_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans4_Temp_SENSOR_MEAS_TYPE; \
	MENU trans4_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans4_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans4_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans4_Temp_INPUT_RANGE; \
	MENU trans4_Temp_INPUT_RANGE_page; \
	COMMAND trans4_Temp_INPUT_RANGE_read; \
	COMMAND trans4_Temp_INPUT_RANGE_write; \
	VARIABLE trans4_Temp_LIN_TYPE; \
	MENU trans4_Temp_LIN_TYPE_page; \
	COMMAND trans4_Temp_LIN_TYPE_read; \
	COMMAND trans4_Temp_LIN_TYPE_write; \
	VARIABLE trans4_Temp_BIAS_1; \
	MENU trans4_Temp_BIAS_1_page; \
	COMMAND trans4_Temp_BIAS_1_read; \
	COMMAND trans4_Temp_BIAS_1_write; \
	VARIABLE trans4_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans4_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans4_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans4_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans4_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans4_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans4_Temp_INPUT_FAULT_GEN; \
	MENU trans4_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans4_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans4_Temp_INPUT_FAULT_1; \
	MENU trans4_Temp_INPUT_FAULT_1_page; \
	COMMAND trans4_Temp_INPUT_FAULT_1_read; \
	UNIT trans4_Temp_Unit_1; \
	VARIABLE trans4_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans4_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans4_Temp_Display; \
	CHART trans4_Temp_Display_BarVal_pv; \
	SOURCE trans4_Temp_Display_BarVal_pv_source; \
	MENU trans4_Temp_Display_primary; \
	MENU trans4_Temp_Display_secondary; \
	MENU trans4_Temp_Tab_s; \
	MENU trans4_Temp_Tab_s_measrange; \
	MENU trans4_Temp_Tab_m

#define USE_TRANS4_TEMP_MANDATORY_A \
	USE_TRANS4_TEMP_MANDATORY_BOTH; \
	MENU trans4_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS4_TEMP_MANDATORY_B \
	USE_TRANS4_TEMP_MANDATORY_BOTH; \
	COLLECTION trans4_Temp_VIEW_1; \
	MENU trans4_Temp_VIEW_1_page; \
	MENU trans4_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS4_TEMP_OPTIONAL_BOTH \
	COLLECTION trans4_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans4_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans4_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans4_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans4_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans4_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans4_Temp_BIAS_2; \
	MENU trans4_Temp_BIAS_2_page; \
	COMMAND trans4_Temp_BIAS_2_read; \
	COMMAND trans4_Temp_BIAS_2_write; \
	VARIABLE trans4_Temp_INPUT_FAULT_2; \
	MENU trans4_Temp_INPUT_FAULT_2_page; \
	COMMAND trans4_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans4_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans4_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans4_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans4_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans4_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans4_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans4_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans4_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans4_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans4_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans4_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans4_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans4_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans4_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans4_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans4_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans4_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans4_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans4_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans4_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans4_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans4_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans4_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans4_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans4_Temp_TAB_ENTRY; \
	MENU trans4_Temp_TAB_ENTRY_page; \
	COMMAND trans4_Temp_TAB_ENTRY_read; \
	COMMAND trans4_Temp_TAB_ENTRY_write; \
	COLLECTION trans4_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans4_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans4_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans4_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans4_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans4_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans4_Temp_TAB_MIN_NUMBER; \
	MENU trans4_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans4_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans4_Temp_TAB_MAX_NUMBER; \
	MENU trans4_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans4_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans4_Temp_TAB_OP_CODE; \
	MENU trans4_Temp_TAB_OP_CODE_page; \
	COMMAND trans4_Temp_TAB_OP_CODE_read; \
	COMMAND trans4_Temp_TAB_OP_CODE_write; \
	VARIABLE trans4_Temp_TAB_STATUS; \
	MENU trans4_Temp_TAB_STATUS_page; \
	COMMAND trans4_Temp_TAB_STATUS_read; \
	VARIABLE trans4_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans4_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans4_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans4_Temp_Unit_2

#define USE_TRANS4_TEMP_OPTIONAL_A \
	USE_TRANS4_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans4_Temp_VIEW_1; \
	MENU trans4_Temp_VIEW_1_page; \
	MENU trans4_Temp_Simple_Dialog_Optional_A

#define USE_TRANS4_TEMP_OPTIONAL_B \
	USE_TRANS4_TEMP_OPTIONAL_BOTH; \
	MENU trans4_Temp_Simple_Dialog_Optional_B

#define USE_TRANS4_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans4_Temp_RJ_TYPE; \
	MENU trans4_Temp_RJ_TYPE_page; \
	COMMAND trans4_Temp_RJ_TYPE_read; \
	COMMAND trans4_Temp_RJ_TYPE_write; \
	MENU trans4_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS4_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans4_Temp_SENSOR_CONNECTION; \
	MENU trans4_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans4_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans4_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans4_Temp_COMP_WIRE1; \
	MENU trans4_Temp_COMP_WIRE1_page; \
	COMMAND trans4_Temp_COMP_WIRE1_read; \
	COMMAND trans4_Temp_COMP_WIRE1_write; \
	MENU trans4_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS4_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans4_Temp_EMISSIVITY; \
	MENU trans4_Temp_EMISSIVITY_page; \
	COMMAND trans4_Temp_EMISSIVITY_read; \
	COMMAND trans4_Temp_EMISSIVITY_write; \
	VARIABLE trans4_Temp_PEAK_TRACK; \
	MENU trans4_Temp_PEAK_TRACK_page; \
	COMMAND trans4_Temp_PEAK_TRACK_read; \
	COMMAND trans4_Temp_PEAK_TRACK_write; \
	VARIABLE trans4_Temp_DECAY_RATE; \
	MENU trans4_Temp_DECAY_RATE_page; \
	COMMAND trans4_Temp_DECAY_RATE_read; \
	COMMAND trans4_Temp_DECAY_RATE_write; \
	VARIABLE trans4_Temp_PEAK_TIME; \
	MENU trans4_Temp_PEAK_TIME_page; \
	COMMAND trans4_Temp_PEAK_TIME_read; \
	COMMAND trans4_Temp_PEAK_TIME_write; \
	VARIABLE trans4_Temp_TRACK_HOLD; \
	MENU trans4_Temp_TRACK_HOLD_page; \
	COMMAND trans4_Temp_TRACK_HOLD_read; \
	COMMAND trans4_Temp_TRACK_HOLD_write; \
	VARIABLE trans4_Temp_SPECT_FILT_SET; \
	MENU trans4_Temp_SPECT_FILT_SET_page; \
	COMMAND trans4_Temp_SPECT_FILT_SET_read; \
	COMMAND trans4_Temp_SPECT_FILT_SET_write; \
	MENU trans4_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS4_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans4_Temp_RJ_TYPE; \
	MENU trans4_Temp_RJ_TYPE_page; \
	COMMAND trans4_Temp_RJ_TYPE_read; \
	COMMAND trans4_Temp_RJ_TYPE_write; \
	MENU trans4_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS4_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans4_Temp_SENSOR_CONNECTION; \
	MENU trans4_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans4_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans4_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans4_Temp_COMP_WIRE1; \
	MENU trans4_Temp_COMP_WIRE1_page; \
	COMMAND trans4_Temp_COMP_WIRE1_read; \
	COMMAND trans4_Temp_COMP_WIRE1_write; \
	MENU trans4_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS4_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans4_Temp_EMISSIVITY; \
	MENU trans4_Temp_EMISSIVITY_page; \
	COMMAND trans4_Temp_EMISSIVITY_read; \
	COMMAND trans4_Temp_EMISSIVITY_write; \
	VARIABLE trans4_Temp_PEAK_TRACK; \
	MENU trans4_Temp_PEAK_TRACK_page; \
	COMMAND trans4_Temp_PEAK_TRACK_read; \
	COMMAND trans4_Temp_PEAK_TRACK_write; \
	VARIABLE trans4_Temp_DECAY_RATE; \
	MENU trans4_Temp_DECAY_RATE_page; \
	COMMAND trans4_Temp_DECAY_RATE_read; \
	COMMAND trans4_Temp_DECAY_RATE_write; \
	VARIABLE trans4_Temp_PEAK_TIME; \
	MENU trans4_Temp_PEAK_TIME_page; \
	COMMAND trans4_Temp_PEAK_TIME_read; \
	COMMAND trans4_Temp_PEAK_TIME_write; \
	VARIABLE trans4_Temp_TRACK_HOLD; \
	MENU trans4_Temp_TRACK_HOLD_page; \
	COMMAND trans4_Temp_TRACK_HOLD_read; \
	COMMAND trans4_Temp_TRACK_HOLD_write; \
	VARIABLE trans4_Temp_SPECT_FILT_SET; \
	MENU trans4_Temp_SPECT_FILT_SET_page; \
	COMMAND trans4_Temp_SPECT_FILT_SET_read; \
	COMMAND trans4_Temp_SPECT_FILT_SET_write; \
	MENU trans4_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS4_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans4_Temp_RJ_TEMP; \
	MENU trans4_Temp_RJ_TEMP_page; \
	COMMAND trans4_Temp_RJ_TEMP_read; \
	VARIABLE trans4_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans4_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans4_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans4_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans4_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans4_Temp_Unit_3

#define USE_TRANS4_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans4_Temp_COMP_WIRE2; \
	MENU trans4_Temp_COMP_WIRE2_page; \
	COMMAND trans4_Temp_COMP_WIRE2_read; \
	COMMAND trans4_Temp_COMP_WIRE2_write; \
	MENU trans4_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS4_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans4_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS4_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans4_Temp_RJ_TEMP; \
	MENU trans4_Temp_RJ_TEMP_page; \
	COMMAND trans4_Temp_RJ_TEMP_read; \
	VARIABLE trans4_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans4_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans4_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans4_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans4_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans4_Temp_Unit_3

#define USE_TRANS4_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans4_Temp_COMP_WIRE2; \
	MENU trans4_Temp_COMP_WIRE2_page; \
	COMMAND trans4_Temp_COMP_WIRE2_read; \
	COMMAND trans4_Temp_COMP_WIRE2_write; \
	MENU trans4_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS4_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans4_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS4_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans4_Temp_)
#define USE_TRANS4_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans4_Temp_)
#define USE_TRANS4_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans4_Temp_)
#define USE_TRANS4_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans4_Temp_)
#define USE_TRANS4_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans4_Temp_)
#define USE_TRANS4_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans4_Temp_)
#define USE_TRANS4_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans4_Temp_)
#define USE_TRANS4_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans4_Temp_)
#define USE_TRANS4_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans4_Temp_)
#define USE_TRANS4_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans4_Temp_)
#define USE_TRANS4_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans4_Temp_)
#define USE_TRANS4_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans4_Temp_)
#define USE_TRANS4_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans4_Temp_)
#define USE_TRANS4_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans4_Temp_)
#define USE_TRANS4_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans4_Temp_)
#define USE_TRANS4_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans4_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS5_TEMP_MANDATORY_BOTH \
	BLOCK trans5_Temp_block; \
	COLLECTION trans5_Temp_BLOCK_OBJECT; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans5_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans5_Temp_BLOCK_OBJECT_page; \
	COMMAND trans5_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans5_Temp_ST_REV; \
	MENU trans5_Temp_ST_REV_page; \
	COMMAND trans5_Temp_ST_REV_read; \
	VARIABLE trans5_Temp_TAG_DESC; \
	MENU trans5_Temp_TAG_DESC_page; \
	COMMAND trans5_Temp_TAG_DESC_read; \
	COMMAND trans5_Temp_TAG_DESC_write; \
	VARIABLE trans5_Temp_STRATEGY; \
	MENU trans5_Temp_STRATEGY_page; \
	COMMAND trans5_Temp_STRATEGY_read; \
	COMMAND trans5_Temp_STRATEGY_write; \
	VARIABLE trans5_Temp_ALERT_KEY; \
	MENU trans5_Temp_ALERT_KEY_page; \
	COMMAND trans5_Temp_ALERT_KEY_read; \
	COMMAND trans5_Temp_ALERT_KEY_write; \
	VARIABLE trans5_Temp_TARGET_MODE; \
	MENU trans5_Temp_TARGET_MODE_page; \
	COMMAND trans5_Temp_TARGET_MODE_read; \
	COMMAND trans5_Temp_TARGET_MODE_write; \
	COLLECTION trans5_Temp_MODE_BLK; \
	VARIABLE trans5_Temp_MODE_BLK_Actual; \
	VARIABLE trans5_Temp_MODE_BLK_Permitted; \
	VARIABLE trans5_Temp_MODE_BLK_Normal; \
	MENU trans5_Temp_MODE_BLK_page; \
	COMMAND trans5_Temp_MODE_BLK_read; \
	COLLECTION trans5_Temp_ALARM_SUM; \
	VARIABLE trans5_Temp_ALARM_SUM_Current; \
	VARIABLE trans5_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans5_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans5_Temp_ALARM_SUM_Disabled; \
	MENU trans5_Temp_ALARM_SUM_page; \
	COMMAND trans5_Temp_ALARM_SUM_read; \
	COLLECTION trans5_Temp_PRIMARY_VALUE; \
	VARIABLE trans5_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans5_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans5_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans5_Temp_PRIMARY_VALUE_page; \
	COMMAND trans5_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans5_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans5_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans5_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans5_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans5_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans5_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans5_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans5_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans5_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans5_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans5_Temp_SENSOR_MEAS_TYPE; \
	MENU trans5_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans5_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans5_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans5_Temp_INPUT_RANGE; \
	MENU trans5_Temp_INPUT_RANGE_page; \
	COMMAND trans5_Temp_INPUT_RANGE_read; \
	COMMAND trans5_Temp_INPUT_RANGE_write; \
	VARIABLE trans5_Temp_LIN_TYPE; \
	MENU trans5_Temp_LIN_TYPE_page; \
	COMMAND trans5_Temp_LIN_TYPE_read; \
	COMMAND trans5_Temp_LIN_TYPE_write; \
	VARIABLE trans5_Temp_BIAS_1; \
	MENU trans5_Temp_BIAS_1_page; \
	COMMAND trans5_Temp_BIAS_1_read; \
	COMMAND trans5_Temp_BIAS_1_write; \
	VARIABLE trans5_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans5_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans5_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans5_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans5_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans5_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans5_Temp_INPUT_FAULT_GEN; \
	MENU trans5_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans5_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans5_Temp_INPUT_FAULT_1; \
	MENU trans5_Temp_INPUT_FAULT_1_page; \
	COMMAND trans5_Temp_INPUT_FAULT_1_read; \
	UNIT trans5_Temp_Unit_1; \
	VARIABLE trans5_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans5_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans5_Temp_Display; \
	CHART trans5_Temp_Display_BarVal_pv; \
	SOURCE trans5_Temp_Display_BarVal_pv_source; \
	MENU trans5_Temp_Display_primary; \
	MENU trans5_Temp_Display_secondary; \
	MENU trans5_Temp_Tab_s; \
	MENU trans5_Temp_Tab_s_measrange; \
	MENU trans5_Temp_Tab_m

#define USE_TRANS5_TEMP_MANDATORY_A \
	USE_TRANS5_TEMP_MANDATORY_BOTH; \
	MENU trans5_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS5_TEMP_MANDATORY_B \
	USE_TRANS5_TEMP_MANDATORY_BOTH; \
	COLLECTION trans5_Temp_VIEW_1; \
	MENU trans5_Temp_VIEW_1_page; \
	MENU trans5_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS5_TEMP_OPTIONAL_BOTH \
	COLLECTION trans5_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans5_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans5_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans5_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans5_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans5_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans5_Temp_BIAS_2; \
	MENU trans5_Temp_BIAS_2_page; \
	COMMAND trans5_Temp_BIAS_2_read; \
	COMMAND trans5_Temp_BIAS_2_write; \
	VARIABLE trans5_Temp_INPUT_FAULT_2; \
	MENU trans5_Temp_INPUT_FAULT_2_page; \
	COMMAND trans5_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans5_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans5_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans5_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans5_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans5_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans5_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans5_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans5_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans5_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans5_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans5_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans5_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans5_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans5_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans5_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans5_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans5_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans5_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans5_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans5_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans5_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans5_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans5_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans5_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans5_Temp_TAB_ENTRY; \
	MENU trans5_Temp_TAB_ENTRY_page; \
	COMMAND trans5_Temp_TAB_ENTRY_read; \
	COMMAND trans5_Temp_TAB_ENTRY_write; \
	COLLECTION trans5_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans5_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans5_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans5_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans5_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans5_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans5_Temp_TAB_MIN_NUMBER; \
	MENU trans5_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans5_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans5_Temp_TAB_MAX_NUMBER; \
	MENU trans5_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans5_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans5_Temp_TAB_OP_CODE; \
	MENU trans5_Temp_TAB_OP_CODE_page; \
	COMMAND trans5_Temp_TAB_OP_CODE_read; \
	COMMAND trans5_Temp_TAB_OP_CODE_write; \
	VARIABLE trans5_Temp_TAB_STATUS; \
	MENU trans5_Temp_TAB_STATUS_page; \
	COMMAND trans5_Temp_TAB_STATUS_read; \
	VARIABLE trans5_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans5_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans5_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans5_Temp_Unit_2

#define USE_TRANS5_TEMP_OPTIONAL_A \
	USE_TRANS5_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans5_Temp_VIEW_1; \
	MENU trans5_Temp_VIEW_1_page; \
	MENU trans5_Temp_Simple_Dialog_Optional_A

#define USE_TRANS5_TEMP_OPTIONAL_B \
	USE_TRANS5_TEMP_OPTIONAL_BOTH; \
	MENU trans5_Temp_Simple_Dialog_Optional_B

#define USE_TRANS5_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans5_Temp_RJ_TYPE; \
	MENU trans5_Temp_RJ_TYPE_page; \
	COMMAND trans5_Temp_RJ_TYPE_read; \
	COMMAND trans5_Temp_RJ_TYPE_write; \
	MENU trans5_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS5_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans5_Temp_SENSOR_CONNECTION; \
	MENU trans5_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans5_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans5_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans5_Temp_COMP_WIRE1; \
	MENU trans5_Temp_COMP_WIRE1_page; \
	COMMAND trans5_Temp_COMP_WIRE1_read; \
	COMMAND trans5_Temp_COMP_WIRE1_write; \
	MENU trans5_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS5_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans5_Temp_EMISSIVITY; \
	MENU trans5_Temp_EMISSIVITY_page; \
	COMMAND trans5_Temp_EMISSIVITY_read; \
	COMMAND trans5_Temp_EMISSIVITY_write; \
	VARIABLE trans5_Temp_PEAK_TRACK; \
	MENU trans5_Temp_PEAK_TRACK_page; \
	COMMAND trans5_Temp_PEAK_TRACK_read; \
	COMMAND trans5_Temp_PEAK_TRACK_write; \
	VARIABLE trans5_Temp_DECAY_RATE; \
	MENU trans5_Temp_DECAY_RATE_page; \
	COMMAND trans5_Temp_DECAY_RATE_read; \
	COMMAND trans5_Temp_DECAY_RATE_write; \
	VARIABLE trans5_Temp_PEAK_TIME; \
	MENU trans5_Temp_PEAK_TIME_page; \
	COMMAND trans5_Temp_PEAK_TIME_read; \
	COMMAND trans5_Temp_PEAK_TIME_write; \
	VARIABLE trans5_Temp_TRACK_HOLD; \
	MENU trans5_Temp_TRACK_HOLD_page; \
	COMMAND trans5_Temp_TRACK_HOLD_read; \
	COMMAND trans5_Temp_TRACK_HOLD_write; \
	VARIABLE trans5_Temp_SPECT_FILT_SET; \
	MENU trans5_Temp_SPECT_FILT_SET_page; \
	COMMAND trans5_Temp_SPECT_FILT_SET_read; \
	COMMAND trans5_Temp_SPECT_FILT_SET_write; \
	MENU trans5_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS5_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans5_Temp_RJ_TYPE; \
	MENU trans5_Temp_RJ_TYPE_page; \
	COMMAND trans5_Temp_RJ_TYPE_read; \
	COMMAND trans5_Temp_RJ_TYPE_write; \
	MENU trans5_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS5_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans5_Temp_SENSOR_CONNECTION; \
	MENU trans5_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans5_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans5_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans5_Temp_COMP_WIRE1; \
	MENU trans5_Temp_COMP_WIRE1_page; \
	COMMAND trans5_Temp_COMP_WIRE1_read; \
	COMMAND trans5_Temp_COMP_WIRE1_write; \
	MENU trans5_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS5_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans5_Temp_EMISSIVITY; \
	MENU trans5_Temp_EMISSIVITY_page; \
	COMMAND trans5_Temp_EMISSIVITY_read; \
	COMMAND trans5_Temp_EMISSIVITY_write; \
	VARIABLE trans5_Temp_PEAK_TRACK; \
	MENU trans5_Temp_PEAK_TRACK_page; \
	COMMAND trans5_Temp_PEAK_TRACK_read; \
	COMMAND trans5_Temp_PEAK_TRACK_write; \
	VARIABLE trans5_Temp_DECAY_RATE; \
	MENU trans5_Temp_DECAY_RATE_page; \
	COMMAND trans5_Temp_DECAY_RATE_read; \
	COMMAND trans5_Temp_DECAY_RATE_write; \
	VARIABLE trans5_Temp_PEAK_TIME; \
	MENU trans5_Temp_PEAK_TIME_page; \
	COMMAND trans5_Temp_PEAK_TIME_read; \
	COMMAND trans5_Temp_PEAK_TIME_write; \
	VARIABLE trans5_Temp_TRACK_HOLD; \
	MENU trans5_Temp_TRACK_HOLD_page; \
	COMMAND trans5_Temp_TRACK_HOLD_read; \
	COMMAND trans5_Temp_TRACK_HOLD_write; \
	VARIABLE trans5_Temp_SPECT_FILT_SET; \
	MENU trans5_Temp_SPECT_FILT_SET_page; \
	COMMAND trans5_Temp_SPECT_FILT_SET_read; \
	COMMAND trans5_Temp_SPECT_FILT_SET_write; \
	MENU trans5_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS5_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans5_Temp_RJ_TEMP; \
	MENU trans5_Temp_RJ_TEMP_page; \
	COMMAND trans5_Temp_RJ_TEMP_read; \
	VARIABLE trans5_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans5_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans5_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans5_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans5_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans5_Temp_Unit_3

#define USE_TRANS5_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans5_Temp_COMP_WIRE2; \
	MENU trans5_Temp_COMP_WIRE2_page; \
	COMMAND trans5_Temp_COMP_WIRE2_read; \
	COMMAND trans5_Temp_COMP_WIRE2_write; \
	MENU trans5_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS5_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans5_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS5_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans5_Temp_RJ_TEMP; \
	MENU trans5_Temp_RJ_TEMP_page; \
	COMMAND trans5_Temp_RJ_TEMP_read; \
	VARIABLE trans5_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans5_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans5_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans5_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans5_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans5_Temp_Unit_3

#define USE_TRANS5_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans5_Temp_COMP_WIRE2; \
	MENU trans5_Temp_COMP_WIRE2_page; \
	COMMAND trans5_Temp_COMP_WIRE2_read; \
	COMMAND trans5_Temp_COMP_WIRE2_write; \
	MENU trans5_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS5_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans5_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS5_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans5_Temp_)
#define USE_TRANS5_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans5_Temp_)
#define USE_TRANS5_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans5_Temp_)
#define USE_TRANS5_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans5_Temp_)
#define USE_TRANS5_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans5_Temp_)
#define USE_TRANS5_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans5_Temp_)
#define USE_TRANS5_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans5_Temp_)
#define USE_TRANS5_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans5_Temp_)
#define USE_TRANS5_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans5_Temp_)
#define USE_TRANS5_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans5_Temp_)
#define USE_TRANS5_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans5_Temp_)
#define USE_TRANS5_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans5_Temp_)
#define USE_TRANS5_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans5_Temp_)
#define USE_TRANS5_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans5_Temp_)
#define USE_TRANS5_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans5_Temp_)
#define USE_TRANS5_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans5_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS6_TEMP_MANDATORY_BOTH \
	BLOCK trans6_Temp_block; \
	COLLECTION trans6_Temp_BLOCK_OBJECT; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans6_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans6_Temp_BLOCK_OBJECT_page; \
	COMMAND trans6_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans6_Temp_ST_REV; \
	MENU trans6_Temp_ST_REV_page; \
	COMMAND trans6_Temp_ST_REV_read; \
	VARIABLE trans6_Temp_TAG_DESC; \
	MENU trans6_Temp_TAG_DESC_page; \
	COMMAND trans6_Temp_TAG_DESC_read; \
	COMMAND trans6_Temp_TAG_DESC_write; \
	VARIABLE trans6_Temp_STRATEGY; \
	MENU trans6_Temp_STRATEGY_page; \
	COMMAND trans6_Temp_STRATEGY_read; \
	COMMAND trans6_Temp_STRATEGY_write; \
	VARIABLE trans6_Temp_ALERT_KEY; \
	MENU trans6_Temp_ALERT_KEY_page; \
	COMMAND trans6_Temp_ALERT_KEY_read; \
	COMMAND trans6_Temp_ALERT_KEY_write; \
	VARIABLE trans6_Temp_TARGET_MODE; \
	MENU trans6_Temp_TARGET_MODE_page; \
	COMMAND trans6_Temp_TARGET_MODE_read; \
	COMMAND trans6_Temp_TARGET_MODE_write; \
	COLLECTION trans6_Temp_MODE_BLK; \
	VARIABLE trans6_Temp_MODE_BLK_Actual; \
	VARIABLE trans6_Temp_MODE_BLK_Permitted; \
	VARIABLE trans6_Temp_MODE_BLK_Normal; \
	MENU trans6_Temp_MODE_BLK_page; \
	COMMAND trans6_Temp_MODE_BLK_read; \
	COLLECTION trans6_Temp_ALARM_SUM; \
	VARIABLE trans6_Temp_ALARM_SUM_Current; \
	VARIABLE trans6_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans6_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans6_Temp_ALARM_SUM_Disabled; \
	MENU trans6_Temp_ALARM_SUM_page; \
	COMMAND trans6_Temp_ALARM_SUM_read; \
	COLLECTION trans6_Temp_PRIMARY_VALUE; \
	VARIABLE trans6_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans6_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans6_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans6_Temp_PRIMARY_VALUE_page; \
	COMMAND trans6_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans6_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans6_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans6_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans6_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans6_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans6_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans6_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans6_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans6_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans6_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans6_Temp_SENSOR_MEAS_TYPE; \
	MENU trans6_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans6_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans6_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans6_Temp_INPUT_RANGE; \
	MENU trans6_Temp_INPUT_RANGE_page; \
	COMMAND trans6_Temp_INPUT_RANGE_read; \
	COMMAND trans6_Temp_INPUT_RANGE_write; \
	VARIABLE trans6_Temp_LIN_TYPE; \
	MENU trans6_Temp_LIN_TYPE_page; \
	COMMAND trans6_Temp_LIN_TYPE_read; \
	COMMAND trans6_Temp_LIN_TYPE_write; \
	VARIABLE trans6_Temp_BIAS_1; \
	MENU trans6_Temp_BIAS_1_page; \
	COMMAND trans6_Temp_BIAS_1_read; \
	COMMAND trans6_Temp_BIAS_1_write; \
	VARIABLE trans6_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans6_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans6_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans6_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans6_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans6_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans6_Temp_INPUT_FAULT_GEN; \
	MENU trans6_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans6_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans6_Temp_INPUT_FAULT_1; \
	MENU trans6_Temp_INPUT_FAULT_1_page; \
	COMMAND trans6_Temp_INPUT_FAULT_1_read; \
	UNIT trans6_Temp_Unit_1; \
	VARIABLE trans6_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans6_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans6_Temp_Display; \
	CHART trans6_Temp_Display_BarVal_pv; \
	SOURCE trans6_Temp_Display_BarVal_pv_source; \
	MENU trans6_Temp_Display_primary; \
	MENU trans6_Temp_Display_secondary; \
	MENU trans6_Temp_Tab_s; \
	MENU trans6_Temp_Tab_s_measrange; \
	MENU trans6_Temp_Tab_m

#define USE_TRANS6_TEMP_MANDATORY_A \
	USE_TRANS6_TEMP_MANDATORY_BOTH; \
	MENU trans6_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS6_TEMP_MANDATORY_B \
	USE_TRANS6_TEMP_MANDATORY_BOTH; \
	COLLECTION trans6_Temp_VIEW_1; \
	MENU trans6_Temp_VIEW_1_page; \
	MENU trans6_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS6_TEMP_OPTIONAL_BOTH \
	COLLECTION trans6_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans6_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans6_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans6_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans6_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans6_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans6_Temp_BIAS_2; \
	MENU trans6_Temp_BIAS_2_page; \
	COMMAND trans6_Temp_BIAS_2_read; \
	COMMAND trans6_Temp_BIAS_2_write; \
	VARIABLE trans6_Temp_INPUT_FAULT_2; \
	MENU trans6_Temp_INPUT_FAULT_2_page; \
	COMMAND trans6_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans6_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans6_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans6_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans6_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans6_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans6_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans6_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans6_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans6_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans6_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans6_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans6_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans6_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans6_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans6_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans6_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans6_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans6_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans6_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans6_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans6_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans6_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans6_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans6_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans6_Temp_TAB_ENTRY; \
	MENU trans6_Temp_TAB_ENTRY_page; \
	COMMAND trans6_Temp_TAB_ENTRY_read; \
	COMMAND trans6_Temp_TAB_ENTRY_write; \
	COLLECTION trans6_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans6_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans6_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans6_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans6_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans6_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans6_Temp_TAB_MIN_NUMBER; \
	MENU trans6_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans6_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans6_Temp_TAB_MAX_NUMBER; \
	MENU trans6_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans6_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans6_Temp_TAB_OP_CODE; \
	MENU trans6_Temp_TAB_OP_CODE_page; \
	COMMAND trans6_Temp_TAB_OP_CODE_read; \
	COMMAND trans6_Temp_TAB_OP_CODE_write; \
	VARIABLE trans6_Temp_TAB_STATUS; \
	MENU trans6_Temp_TAB_STATUS_page; \
	COMMAND trans6_Temp_TAB_STATUS_read; \
	VARIABLE trans6_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans6_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans6_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans6_Temp_Unit_2

#define USE_TRANS6_TEMP_OPTIONAL_A \
	USE_TRANS6_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans6_Temp_VIEW_1; \
	MENU trans6_Temp_VIEW_1_page; \
	MENU trans6_Temp_Simple_Dialog_Optional_A

#define USE_TRANS6_TEMP_OPTIONAL_B \
	USE_TRANS6_TEMP_OPTIONAL_BOTH; \
	MENU trans6_Temp_Simple_Dialog_Optional_B

#define USE_TRANS6_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans6_Temp_RJ_TYPE; \
	MENU trans6_Temp_RJ_TYPE_page; \
	COMMAND trans6_Temp_RJ_TYPE_read; \
	COMMAND trans6_Temp_RJ_TYPE_write; \
	MENU trans6_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS6_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans6_Temp_SENSOR_CONNECTION; \
	MENU trans6_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans6_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans6_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans6_Temp_COMP_WIRE1; \
	MENU trans6_Temp_COMP_WIRE1_page; \
	COMMAND trans6_Temp_COMP_WIRE1_read; \
	COMMAND trans6_Temp_COMP_WIRE1_write; \
	MENU trans6_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS6_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans6_Temp_EMISSIVITY; \
	MENU trans6_Temp_EMISSIVITY_page; \
	COMMAND trans6_Temp_EMISSIVITY_read; \
	COMMAND trans6_Temp_EMISSIVITY_write; \
	VARIABLE trans6_Temp_PEAK_TRACK; \
	MENU trans6_Temp_PEAK_TRACK_page; \
	COMMAND trans6_Temp_PEAK_TRACK_read; \
	COMMAND trans6_Temp_PEAK_TRACK_write; \
	VARIABLE trans6_Temp_DECAY_RATE; \
	MENU trans6_Temp_DECAY_RATE_page; \
	COMMAND trans6_Temp_DECAY_RATE_read; \
	COMMAND trans6_Temp_DECAY_RATE_write; \
	VARIABLE trans6_Temp_PEAK_TIME; \
	MENU trans6_Temp_PEAK_TIME_page; \
	COMMAND trans6_Temp_PEAK_TIME_read; \
	COMMAND trans6_Temp_PEAK_TIME_write; \
	VARIABLE trans6_Temp_TRACK_HOLD; \
	MENU trans6_Temp_TRACK_HOLD_page; \
	COMMAND trans6_Temp_TRACK_HOLD_read; \
	COMMAND trans6_Temp_TRACK_HOLD_write; \
	VARIABLE trans6_Temp_SPECT_FILT_SET; \
	MENU trans6_Temp_SPECT_FILT_SET_page; \
	COMMAND trans6_Temp_SPECT_FILT_SET_read; \
	COMMAND trans6_Temp_SPECT_FILT_SET_write; \
	MENU trans6_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS6_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans6_Temp_RJ_TYPE; \
	MENU trans6_Temp_RJ_TYPE_page; \
	COMMAND trans6_Temp_RJ_TYPE_read; \
	COMMAND trans6_Temp_RJ_TYPE_write; \
	MENU trans6_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS6_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans6_Temp_SENSOR_CONNECTION; \
	MENU trans6_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans6_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans6_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans6_Temp_COMP_WIRE1; \
	MENU trans6_Temp_COMP_WIRE1_page; \
	COMMAND trans6_Temp_COMP_WIRE1_read; \
	COMMAND trans6_Temp_COMP_WIRE1_write; \
	MENU trans6_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS6_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans6_Temp_EMISSIVITY; \
	MENU trans6_Temp_EMISSIVITY_page; \
	COMMAND trans6_Temp_EMISSIVITY_read; \
	COMMAND trans6_Temp_EMISSIVITY_write; \
	VARIABLE trans6_Temp_PEAK_TRACK; \
	MENU trans6_Temp_PEAK_TRACK_page; \
	COMMAND trans6_Temp_PEAK_TRACK_read; \
	COMMAND trans6_Temp_PEAK_TRACK_write; \
	VARIABLE trans6_Temp_DECAY_RATE; \
	MENU trans6_Temp_DECAY_RATE_page; \
	COMMAND trans6_Temp_DECAY_RATE_read; \
	COMMAND trans6_Temp_DECAY_RATE_write; \
	VARIABLE trans6_Temp_PEAK_TIME; \
	MENU trans6_Temp_PEAK_TIME_page; \
	COMMAND trans6_Temp_PEAK_TIME_read; \
	COMMAND trans6_Temp_PEAK_TIME_write; \
	VARIABLE trans6_Temp_TRACK_HOLD; \
	MENU trans6_Temp_TRACK_HOLD_page; \
	COMMAND trans6_Temp_TRACK_HOLD_read; \
	COMMAND trans6_Temp_TRACK_HOLD_write; \
	VARIABLE trans6_Temp_SPECT_FILT_SET; \
	MENU trans6_Temp_SPECT_FILT_SET_page; \
	COMMAND trans6_Temp_SPECT_FILT_SET_read; \
	COMMAND trans6_Temp_SPECT_FILT_SET_write; \
	MENU trans6_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS6_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans6_Temp_RJ_TEMP; \
	MENU trans6_Temp_RJ_TEMP_page; \
	COMMAND trans6_Temp_RJ_TEMP_read; \
	VARIABLE trans6_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans6_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans6_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans6_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans6_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans6_Temp_Unit_3

#define USE_TRANS6_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans6_Temp_COMP_WIRE2; \
	MENU trans6_Temp_COMP_WIRE2_page; \
	COMMAND trans6_Temp_COMP_WIRE2_read; \
	COMMAND trans6_Temp_COMP_WIRE2_write; \
	MENU trans6_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS6_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans6_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS6_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans6_Temp_RJ_TEMP; \
	MENU trans6_Temp_RJ_TEMP_page; \
	COMMAND trans6_Temp_RJ_TEMP_read; \
	VARIABLE trans6_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans6_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans6_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans6_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans6_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans6_Temp_Unit_3

#define USE_TRANS6_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans6_Temp_COMP_WIRE2; \
	MENU trans6_Temp_COMP_WIRE2_page; \
	COMMAND trans6_Temp_COMP_WIRE2_read; \
	COMMAND trans6_Temp_COMP_WIRE2_write; \
	MENU trans6_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS6_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans6_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS6_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans6_Temp_)
#define USE_TRANS6_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans6_Temp_)
#define USE_TRANS6_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans6_Temp_)
#define USE_TRANS6_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans6_Temp_)
#define USE_TRANS6_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans6_Temp_)
#define USE_TRANS6_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans6_Temp_)
#define USE_TRANS6_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans6_Temp_)
#define USE_TRANS6_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans6_Temp_)
#define USE_TRANS6_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans6_Temp_)
#define USE_TRANS6_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans6_Temp_)
#define USE_TRANS6_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans6_Temp_)
#define USE_TRANS6_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans6_Temp_)
#define USE_TRANS6_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans6_Temp_)
#define USE_TRANS6_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans6_Temp_)
#define USE_TRANS6_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans6_Temp_)
#define USE_TRANS6_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans6_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS7_TEMP_MANDATORY_BOTH \
	BLOCK trans7_Temp_block; \
	COLLECTION trans7_Temp_BLOCK_OBJECT; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans7_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans7_Temp_BLOCK_OBJECT_page; \
	COMMAND trans7_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans7_Temp_ST_REV; \
	MENU trans7_Temp_ST_REV_page; \
	COMMAND trans7_Temp_ST_REV_read; \
	VARIABLE trans7_Temp_TAG_DESC; \
	MENU trans7_Temp_TAG_DESC_page; \
	COMMAND trans7_Temp_TAG_DESC_read; \
	COMMAND trans7_Temp_TAG_DESC_write; \
	VARIABLE trans7_Temp_STRATEGY; \
	MENU trans7_Temp_STRATEGY_page; \
	COMMAND trans7_Temp_STRATEGY_read; \
	COMMAND trans7_Temp_STRATEGY_write; \
	VARIABLE trans7_Temp_ALERT_KEY; \
	MENU trans7_Temp_ALERT_KEY_page; \
	COMMAND trans7_Temp_ALERT_KEY_read; \
	COMMAND trans7_Temp_ALERT_KEY_write; \
	VARIABLE trans7_Temp_TARGET_MODE; \
	MENU trans7_Temp_TARGET_MODE_page; \
	COMMAND trans7_Temp_TARGET_MODE_read; \
	COMMAND trans7_Temp_TARGET_MODE_write; \
	COLLECTION trans7_Temp_MODE_BLK; \
	VARIABLE trans7_Temp_MODE_BLK_Actual; \
	VARIABLE trans7_Temp_MODE_BLK_Permitted; \
	VARIABLE trans7_Temp_MODE_BLK_Normal; \
	MENU trans7_Temp_MODE_BLK_page; \
	COMMAND trans7_Temp_MODE_BLK_read; \
	COLLECTION trans7_Temp_ALARM_SUM; \
	VARIABLE trans7_Temp_ALARM_SUM_Current; \
	VARIABLE trans7_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans7_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans7_Temp_ALARM_SUM_Disabled; \
	MENU trans7_Temp_ALARM_SUM_page; \
	COMMAND trans7_Temp_ALARM_SUM_read; \
	COLLECTION trans7_Temp_PRIMARY_VALUE; \
	VARIABLE trans7_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans7_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans7_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans7_Temp_PRIMARY_VALUE_page; \
	COMMAND trans7_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans7_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans7_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans7_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans7_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans7_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans7_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans7_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans7_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans7_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans7_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans7_Temp_SENSOR_MEAS_TYPE; \
	MENU trans7_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans7_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans7_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans7_Temp_INPUT_RANGE; \
	MENU trans7_Temp_INPUT_RANGE_page; \
	COMMAND trans7_Temp_INPUT_RANGE_read; \
	COMMAND trans7_Temp_INPUT_RANGE_write; \
	VARIABLE trans7_Temp_LIN_TYPE; \
	MENU trans7_Temp_LIN_TYPE_page; \
	COMMAND trans7_Temp_LIN_TYPE_read; \
	COMMAND trans7_Temp_LIN_TYPE_write; \
	VARIABLE trans7_Temp_BIAS_1; \
	MENU trans7_Temp_BIAS_1_page; \
	COMMAND trans7_Temp_BIAS_1_read; \
	COMMAND trans7_Temp_BIAS_1_write; \
	VARIABLE trans7_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans7_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans7_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans7_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans7_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans7_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans7_Temp_INPUT_FAULT_GEN; \
	MENU trans7_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans7_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans7_Temp_INPUT_FAULT_1; \
	MENU trans7_Temp_INPUT_FAULT_1_page; \
	COMMAND trans7_Temp_INPUT_FAULT_1_read; \
	UNIT trans7_Temp_Unit_1; \
	VARIABLE trans7_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans7_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans7_Temp_Display; \
	CHART trans7_Temp_Display_BarVal_pv; \
	SOURCE trans7_Temp_Display_BarVal_pv_source; \
	MENU trans7_Temp_Display_primary; \
	MENU trans7_Temp_Display_secondary; \
	MENU trans7_Temp_Tab_s; \
	MENU trans7_Temp_Tab_s_measrange; \
	MENU trans7_Temp_Tab_m

#define USE_TRANS7_TEMP_MANDATORY_A \
	USE_TRANS7_TEMP_MANDATORY_BOTH; \
	MENU trans7_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS7_TEMP_MANDATORY_B \
	USE_TRANS7_TEMP_MANDATORY_BOTH; \
	COLLECTION trans7_Temp_VIEW_1; \
	MENU trans7_Temp_VIEW_1_page; \
	MENU trans7_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS7_TEMP_OPTIONAL_BOTH \
	COLLECTION trans7_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans7_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans7_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans7_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans7_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans7_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans7_Temp_BIAS_2; \
	MENU trans7_Temp_BIAS_2_page; \
	COMMAND trans7_Temp_BIAS_2_read; \
	COMMAND trans7_Temp_BIAS_2_write; \
	VARIABLE trans7_Temp_INPUT_FAULT_2; \
	MENU trans7_Temp_INPUT_FAULT_2_page; \
	COMMAND trans7_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans7_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans7_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans7_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans7_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans7_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans7_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans7_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans7_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans7_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans7_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans7_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans7_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans7_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans7_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans7_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans7_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans7_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans7_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans7_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans7_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans7_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans7_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans7_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans7_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans7_Temp_TAB_ENTRY; \
	MENU trans7_Temp_TAB_ENTRY_page; \
	COMMAND trans7_Temp_TAB_ENTRY_read; \
	COMMAND trans7_Temp_TAB_ENTRY_write; \
	COLLECTION trans7_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans7_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans7_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans7_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans7_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans7_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans7_Temp_TAB_MIN_NUMBER; \
	MENU trans7_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans7_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans7_Temp_TAB_MAX_NUMBER; \
	MENU trans7_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans7_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans7_Temp_TAB_OP_CODE; \
	MENU trans7_Temp_TAB_OP_CODE_page; \
	COMMAND trans7_Temp_TAB_OP_CODE_read; \
	COMMAND trans7_Temp_TAB_OP_CODE_write; \
	VARIABLE trans7_Temp_TAB_STATUS; \
	MENU trans7_Temp_TAB_STATUS_page; \
	COMMAND trans7_Temp_TAB_STATUS_read; \
	VARIABLE trans7_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans7_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans7_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans7_Temp_Unit_2

#define USE_TRANS7_TEMP_OPTIONAL_A \
	USE_TRANS7_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans7_Temp_VIEW_1; \
	MENU trans7_Temp_VIEW_1_page; \
	MENU trans7_Temp_Simple_Dialog_Optional_A

#define USE_TRANS7_TEMP_OPTIONAL_B \
	USE_TRANS7_TEMP_OPTIONAL_BOTH; \
	MENU trans7_Temp_Simple_Dialog_Optional_B

#define USE_TRANS7_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans7_Temp_RJ_TYPE; \
	MENU trans7_Temp_RJ_TYPE_page; \
	COMMAND trans7_Temp_RJ_TYPE_read; \
	COMMAND trans7_Temp_RJ_TYPE_write; \
	MENU trans7_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS7_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans7_Temp_SENSOR_CONNECTION; \
	MENU trans7_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans7_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans7_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans7_Temp_COMP_WIRE1; \
	MENU trans7_Temp_COMP_WIRE1_page; \
	COMMAND trans7_Temp_COMP_WIRE1_read; \
	COMMAND trans7_Temp_COMP_WIRE1_write; \
	MENU trans7_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS7_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans7_Temp_EMISSIVITY; \
	MENU trans7_Temp_EMISSIVITY_page; \
	COMMAND trans7_Temp_EMISSIVITY_read; \
	COMMAND trans7_Temp_EMISSIVITY_write; \
	VARIABLE trans7_Temp_PEAK_TRACK; \
	MENU trans7_Temp_PEAK_TRACK_page; \
	COMMAND trans7_Temp_PEAK_TRACK_read; \
	COMMAND trans7_Temp_PEAK_TRACK_write; \
	VARIABLE trans7_Temp_DECAY_RATE; \
	MENU trans7_Temp_DECAY_RATE_page; \
	COMMAND trans7_Temp_DECAY_RATE_read; \
	COMMAND trans7_Temp_DECAY_RATE_write; \
	VARIABLE trans7_Temp_PEAK_TIME; \
	MENU trans7_Temp_PEAK_TIME_page; \
	COMMAND trans7_Temp_PEAK_TIME_read; \
	COMMAND trans7_Temp_PEAK_TIME_write; \
	VARIABLE trans7_Temp_TRACK_HOLD; \
	MENU trans7_Temp_TRACK_HOLD_page; \
	COMMAND trans7_Temp_TRACK_HOLD_read; \
	COMMAND trans7_Temp_TRACK_HOLD_write; \
	VARIABLE trans7_Temp_SPECT_FILT_SET; \
	MENU trans7_Temp_SPECT_FILT_SET_page; \
	COMMAND trans7_Temp_SPECT_FILT_SET_read; \
	COMMAND trans7_Temp_SPECT_FILT_SET_write; \
	MENU trans7_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS7_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans7_Temp_RJ_TYPE; \
	MENU trans7_Temp_RJ_TYPE_page; \
	COMMAND trans7_Temp_RJ_TYPE_read; \
	COMMAND trans7_Temp_RJ_TYPE_write; \
	MENU trans7_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS7_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans7_Temp_SENSOR_CONNECTION; \
	MENU trans7_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans7_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans7_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans7_Temp_COMP_WIRE1; \
	MENU trans7_Temp_COMP_WIRE1_page; \
	COMMAND trans7_Temp_COMP_WIRE1_read; \
	COMMAND trans7_Temp_COMP_WIRE1_write; \
	MENU trans7_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS7_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans7_Temp_EMISSIVITY; \
	MENU trans7_Temp_EMISSIVITY_page; \
	COMMAND trans7_Temp_EMISSIVITY_read; \
	COMMAND trans7_Temp_EMISSIVITY_write; \
	VARIABLE trans7_Temp_PEAK_TRACK; \
	MENU trans7_Temp_PEAK_TRACK_page; \
	COMMAND trans7_Temp_PEAK_TRACK_read; \
	COMMAND trans7_Temp_PEAK_TRACK_write; \
	VARIABLE trans7_Temp_DECAY_RATE; \
	MENU trans7_Temp_DECAY_RATE_page; \
	COMMAND trans7_Temp_DECAY_RATE_read; \
	COMMAND trans7_Temp_DECAY_RATE_write; \
	VARIABLE trans7_Temp_PEAK_TIME; \
	MENU trans7_Temp_PEAK_TIME_page; \
	COMMAND trans7_Temp_PEAK_TIME_read; \
	COMMAND trans7_Temp_PEAK_TIME_write; \
	VARIABLE trans7_Temp_TRACK_HOLD; \
	MENU trans7_Temp_TRACK_HOLD_page; \
	COMMAND trans7_Temp_TRACK_HOLD_read; \
	COMMAND trans7_Temp_TRACK_HOLD_write; \
	VARIABLE trans7_Temp_SPECT_FILT_SET; \
	MENU trans7_Temp_SPECT_FILT_SET_page; \
	COMMAND trans7_Temp_SPECT_FILT_SET_read; \
	COMMAND trans7_Temp_SPECT_FILT_SET_write; \
	MENU trans7_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS7_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans7_Temp_RJ_TEMP; \
	MENU trans7_Temp_RJ_TEMP_page; \
	COMMAND trans7_Temp_RJ_TEMP_read; \
	VARIABLE trans7_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans7_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans7_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans7_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans7_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans7_Temp_Unit_3

#define USE_TRANS7_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans7_Temp_COMP_WIRE2; \
	MENU trans7_Temp_COMP_WIRE2_page; \
	COMMAND trans7_Temp_COMP_WIRE2_read; \
	COMMAND trans7_Temp_COMP_WIRE2_write; \
	MENU trans7_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS7_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans7_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS7_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans7_Temp_RJ_TEMP; \
	MENU trans7_Temp_RJ_TEMP_page; \
	COMMAND trans7_Temp_RJ_TEMP_read; \
	VARIABLE trans7_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans7_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans7_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans7_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans7_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans7_Temp_Unit_3

#define USE_TRANS7_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans7_Temp_COMP_WIRE2; \
	MENU trans7_Temp_COMP_WIRE2_page; \
	COMMAND trans7_Temp_COMP_WIRE2_read; \
	COMMAND trans7_Temp_COMP_WIRE2_write; \
	MENU trans7_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS7_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans7_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS7_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans7_Temp_)
#define USE_TRANS7_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans7_Temp_)
#define USE_TRANS7_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans7_Temp_)
#define USE_TRANS7_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans7_Temp_)
#define USE_TRANS7_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans7_Temp_)
#define USE_TRANS7_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans7_Temp_)
#define USE_TRANS7_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans7_Temp_)
#define USE_TRANS7_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans7_Temp_)
#define USE_TRANS7_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans7_Temp_)
#define USE_TRANS7_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans7_Temp_)
#define USE_TRANS7_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans7_Temp_)
#define USE_TRANS7_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans7_Temp_)
#define USE_TRANS7_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans7_Temp_)
#define USE_TRANS7_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans7_Temp_)
#define USE_TRANS7_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans7_Temp_)
#define USE_TRANS7_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans7_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS8_TEMP_MANDATORY_BOTH \
	BLOCK trans8_Temp_block; \
	COLLECTION trans8_Temp_BLOCK_OBJECT; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans8_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans8_Temp_BLOCK_OBJECT_page; \
	COMMAND trans8_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans8_Temp_ST_REV; \
	MENU trans8_Temp_ST_REV_page; \
	COMMAND trans8_Temp_ST_REV_read; \
	VARIABLE trans8_Temp_TAG_DESC; \
	MENU trans8_Temp_TAG_DESC_page; \
	COMMAND trans8_Temp_TAG_DESC_read; \
	COMMAND trans8_Temp_TAG_DESC_write; \
	VARIABLE trans8_Temp_STRATEGY; \
	MENU trans8_Temp_STRATEGY_page; \
	COMMAND trans8_Temp_STRATEGY_read; \
	COMMAND trans8_Temp_STRATEGY_write; \
	VARIABLE trans8_Temp_ALERT_KEY; \
	MENU trans8_Temp_ALERT_KEY_page; \
	COMMAND trans8_Temp_ALERT_KEY_read; \
	COMMAND trans8_Temp_ALERT_KEY_write; \
	VARIABLE trans8_Temp_TARGET_MODE; \
	MENU trans8_Temp_TARGET_MODE_page; \
	COMMAND trans8_Temp_TARGET_MODE_read; \
	COMMAND trans8_Temp_TARGET_MODE_write; \
	COLLECTION trans8_Temp_MODE_BLK; \
	VARIABLE trans8_Temp_MODE_BLK_Actual; \
	VARIABLE trans8_Temp_MODE_BLK_Permitted; \
	VARIABLE trans8_Temp_MODE_BLK_Normal; \
	MENU trans8_Temp_MODE_BLK_page; \
	COMMAND trans8_Temp_MODE_BLK_read; \
	COLLECTION trans8_Temp_ALARM_SUM; \
	VARIABLE trans8_Temp_ALARM_SUM_Current; \
	VARIABLE trans8_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans8_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans8_Temp_ALARM_SUM_Disabled; \
	MENU trans8_Temp_ALARM_SUM_page; \
	COMMAND trans8_Temp_ALARM_SUM_read; \
	COLLECTION trans8_Temp_PRIMARY_VALUE; \
	VARIABLE trans8_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans8_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans8_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans8_Temp_PRIMARY_VALUE_page; \
	COMMAND trans8_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans8_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans8_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans8_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans8_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans8_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans8_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans8_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans8_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans8_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans8_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans8_Temp_SENSOR_MEAS_TYPE; \
	MENU trans8_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans8_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans8_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans8_Temp_INPUT_RANGE; \
	MENU trans8_Temp_INPUT_RANGE_page; \
	COMMAND trans8_Temp_INPUT_RANGE_read; \
	COMMAND trans8_Temp_INPUT_RANGE_write; \
	VARIABLE trans8_Temp_LIN_TYPE; \
	MENU trans8_Temp_LIN_TYPE_page; \
	COMMAND trans8_Temp_LIN_TYPE_read; \
	COMMAND trans8_Temp_LIN_TYPE_write; \
	VARIABLE trans8_Temp_BIAS_1; \
	MENU trans8_Temp_BIAS_1_page; \
	COMMAND trans8_Temp_BIAS_1_read; \
	COMMAND trans8_Temp_BIAS_1_write; \
	VARIABLE trans8_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans8_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans8_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans8_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans8_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans8_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans8_Temp_INPUT_FAULT_GEN; \
	MENU trans8_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans8_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans8_Temp_INPUT_FAULT_1; \
	MENU trans8_Temp_INPUT_FAULT_1_page; \
	COMMAND trans8_Temp_INPUT_FAULT_1_read; \
	UNIT trans8_Temp_Unit_1; \
	VARIABLE trans8_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans8_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans8_Temp_Display; \
	CHART trans8_Temp_Display_BarVal_pv; \
	SOURCE trans8_Temp_Display_BarVal_pv_source; \
	MENU trans8_Temp_Display_primary; \
	MENU trans8_Temp_Display_secondary; \
	MENU trans8_Temp_Tab_s; \
	MENU trans8_Temp_Tab_s_measrange; \
	MENU trans8_Temp_Tab_m

#define USE_TRANS8_TEMP_MANDATORY_A \
	USE_TRANS8_TEMP_MANDATORY_BOTH; \
	MENU trans8_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS8_TEMP_MANDATORY_B \
	USE_TRANS8_TEMP_MANDATORY_BOTH; \
	COLLECTION trans8_Temp_VIEW_1; \
	MENU trans8_Temp_VIEW_1_page; \
	MENU trans8_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS8_TEMP_OPTIONAL_BOTH \
	COLLECTION trans8_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans8_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans8_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans8_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans8_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans8_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans8_Temp_BIAS_2; \
	MENU trans8_Temp_BIAS_2_page; \
	COMMAND trans8_Temp_BIAS_2_read; \
	COMMAND trans8_Temp_BIAS_2_write; \
	VARIABLE trans8_Temp_INPUT_FAULT_2; \
	MENU trans8_Temp_INPUT_FAULT_2_page; \
	COMMAND trans8_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans8_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans8_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans8_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans8_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans8_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans8_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans8_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans8_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans8_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans8_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans8_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans8_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans8_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans8_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans8_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans8_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans8_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans8_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans8_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans8_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans8_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans8_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans8_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans8_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans8_Temp_TAB_ENTRY; \
	MENU trans8_Temp_TAB_ENTRY_page; \
	COMMAND trans8_Temp_TAB_ENTRY_read; \
	COMMAND trans8_Temp_TAB_ENTRY_write; \
	COLLECTION trans8_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans8_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans8_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans8_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans8_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans8_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans8_Temp_TAB_MIN_NUMBER; \
	MENU trans8_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans8_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans8_Temp_TAB_MAX_NUMBER; \
	MENU trans8_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans8_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans8_Temp_TAB_OP_CODE; \
	MENU trans8_Temp_TAB_OP_CODE_page; \
	COMMAND trans8_Temp_TAB_OP_CODE_read; \
	COMMAND trans8_Temp_TAB_OP_CODE_write; \
	VARIABLE trans8_Temp_TAB_STATUS; \
	MENU trans8_Temp_TAB_STATUS_page; \
	COMMAND trans8_Temp_TAB_STATUS_read; \
	VARIABLE trans8_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans8_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans8_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans8_Temp_Unit_2

#define USE_TRANS8_TEMP_OPTIONAL_A \
	USE_TRANS8_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans8_Temp_VIEW_1; \
	MENU trans8_Temp_VIEW_1_page; \
	MENU trans8_Temp_Simple_Dialog_Optional_A

#define USE_TRANS8_TEMP_OPTIONAL_B \
	USE_TRANS8_TEMP_OPTIONAL_BOTH; \
	MENU trans8_Temp_Simple_Dialog_Optional_B

#define USE_TRANS8_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans8_Temp_RJ_TYPE; \
	MENU trans8_Temp_RJ_TYPE_page; \
	COMMAND trans8_Temp_RJ_TYPE_read; \
	COMMAND trans8_Temp_RJ_TYPE_write; \
	MENU trans8_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS8_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans8_Temp_SENSOR_CONNECTION; \
	MENU trans8_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans8_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans8_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans8_Temp_COMP_WIRE1; \
	MENU trans8_Temp_COMP_WIRE1_page; \
	COMMAND trans8_Temp_COMP_WIRE1_read; \
	COMMAND trans8_Temp_COMP_WIRE1_write; \
	MENU trans8_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS8_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans8_Temp_EMISSIVITY; \
	MENU trans8_Temp_EMISSIVITY_page; \
	COMMAND trans8_Temp_EMISSIVITY_read; \
	COMMAND trans8_Temp_EMISSIVITY_write; \
	VARIABLE trans8_Temp_PEAK_TRACK; \
	MENU trans8_Temp_PEAK_TRACK_page; \
	COMMAND trans8_Temp_PEAK_TRACK_read; \
	COMMAND trans8_Temp_PEAK_TRACK_write; \
	VARIABLE trans8_Temp_DECAY_RATE; \
	MENU trans8_Temp_DECAY_RATE_page; \
	COMMAND trans8_Temp_DECAY_RATE_read; \
	COMMAND trans8_Temp_DECAY_RATE_write; \
	VARIABLE trans8_Temp_PEAK_TIME; \
	MENU trans8_Temp_PEAK_TIME_page; \
	COMMAND trans8_Temp_PEAK_TIME_read; \
	COMMAND trans8_Temp_PEAK_TIME_write; \
	VARIABLE trans8_Temp_TRACK_HOLD; \
	MENU trans8_Temp_TRACK_HOLD_page; \
	COMMAND trans8_Temp_TRACK_HOLD_read; \
	COMMAND trans8_Temp_TRACK_HOLD_write; \
	VARIABLE trans8_Temp_SPECT_FILT_SET; \
	MENU trans8_Temp_SPECT_FILT_SET_page; \
	COMMAND trans8_Temp_SPECT_FILT_SET_read; \
	COMMAND trans8_Temp_SPECT_FILT_SET_write; \
	MENU trans8_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS8_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans8_Temp_RJ_TYPE; \
	MENU trans8_Temp_RJ_TYPE_page; \
	COMMAND trans8_Temp_RJ_TYPE_read; \
	COMMAND trans8_Temp_RJ_TYPE_write; \
	MENU trans8_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS8_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans8_Temp_SENSOR_CONNECTION; \
	MENU trans8_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans8_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans8_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans8_Temp_COMP_WIRE1; \
	MENU trans8_Temp_COMP_WIRE1_page; \
	COMMAND trans8_Temp_COMP_WIRE1_read; \
	COMMAND trans8_Temp_COMP_WIRE1_write; \
	MENU trans8_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS8_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans8_Temp_EMISSIVITY; \
	MENU trans8_Temp_EMISSIVITY_page; \
	COMMAND trans8_Temp_EMISSIVITY_read; \
	COMMAND trans8_Temp_EMISSIVITY_write; \
	VARIABLE trans8_Temp_PEAK_TRACK; \
	MENU trans8_Temp_PEAK_TRACK_page; \
	COMMAND trans8_Temp_PEAK_TRACK_read; \
	COMMAND trans8_Temp_PEAK_TRACK_write; \
	VARIABLE trans8_Temp_DECAY_RATE; \
	MENU trans8_Temp_DECAY_RATE_page; \
	COMMAND trans8_Temp_DECAY_RATE_read; \
	COMMAND trans8_Temp_DECAY_RATE_write; \
	VARIABLE trans8_Temp_PEAK_TIME; \
	MENU trans8_Temp_PEAK_TIME_page; \
	COMMAND trans8_Temp_PEAK_TIME_read; \
	COMMAND trans8_Temp_PEAK_TIME_write; \
	VARIABLE trans8_Temp_TRACK_HOLD; \
	MENU trans8_Temp_TRACK_HOLD_page; \
	COMMAND trans8_Temp_TRACK_HOLD_read; \
	COMMAND trans8_Temp_TRACK_HOLD_write; \
	VARIABLE trans8_Temp_SPECT_FILT_SET; \
	MENU trans8_Temp_SPECT_FILT_SET_page; \
	COMMAND trans8_Temp_SPECT_FILT_SET_read; \
	COMMAND trans8_Temp_SPECT_FILT_SET_write; \
	MENU trans8_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS8_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans8_Temp_RJ_TEMP; \
	MENU trans8_Temp_RJ_TEMP_page; \
	COMMAND trans8_Temp_RJ_TEMP_read; \
	VARIABLE trans8_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans8_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans8_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans8_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans8_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans8_Temp_Unit_3

#define USE_TRANS8_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans8_Temp_COMP_WIRE2; \
	MENU trans8_Temp_COMP_WIRE2_page; \
	COMMAND trans8_Temp_COMP_WIRE2_read; \
	COMMAND trans8_Temp_COMP_WIRE2_write; \
	MENU trans8_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS8_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans8_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS8_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans8_Temp_RJ_TEMP; \
	MENU trans8_Temp_RJ_TEMP_page; \
	COMMAND trans8_Temp_RJ_TEMP_read; \
	VARIABLE trans8_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans8_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans8_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans8_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans8_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans8_Temp_Unit_3

#define USE_TRANS8_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans8_Temp_COMP_WIRE2; \
	MENU trans8_Temp_COMP_WIRE2_page; \
	COMMAND trans8_Temp_COMP_WIRE2_read; \
	COMMAND trans8_Temp_COMP_WIRE2_write; \
	MENU trans8_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS8_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans8_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS8_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans8_Temp_)
#define USE_TRANS8_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans8_Temp_)
#define USE_TRANS8_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans8_Temp_)
#define USE_TRANS8_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans8_Temp_)
#define USE_TRANS8_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans8_Temp_)
#define USE_TRANS8_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans8_Temp_)
#define USE_TRANS8_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans8_Temp_)
#define USE_TRANS8_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans8_Temp_)
#define USE_TRANS8_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans8_Temp_)
#define USE_TRANS8_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans8_Temp_)
#define USE_TRANS8_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans8_Temp_)
#define USE_TRANS8_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans8_Temp_)
#define USE_TRANS8_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans8_Temp_)
#define USE_TRANS8_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans8_Temp_)
#define USE_TRANS8_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans8_Temp_)
#define USE_TRANS8_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans8_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS9_TEMP_MANDATORY_BOTH \
	BLOCK trans9_Temp_block; \
	COLLECTION trans9_Temp_BLOCK_OBJECT; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans9_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans9_Temp_BLOCK_OBJECT_page; \
	COMMAND trans9_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans9_Temp_ST_REV; \
	MENU trans9_Temp_ST_REV_page; \
	COMMAND trans9_Temp_ST_REV_read; \
	VARIABLE trans9_Temp_TAG_DESC; \
	MENU trans9_Temp_TAG_DESC_page; \
	COMMAND trans9_Temp_TAG_DESC_read; \
	COMMAND trans9_Temp_TAG_DESC_write; \
	VARIABLE trans9_Temp_STRATEGY; \
	MENU trans9_Temp_STRATEGY_page; \
	COMMAND trans9_Temp_STRATEGY_read; \
	COMMAND trans9_Temp_STRATEGY_write; \
	VARIABLE trans9_Temp_ALERT_KEY; \
	MENU trans9_Temp_ALERT_KEY_page; \
	COMMAND trans9_Temp_ALERT_KEY_read; \
	COMMAND trans9_Temp_ALERT_KEY_write; \
	VARIABLE trans9_Temp_TARGET_MODE; \
	MENU trans9_Temp_TARGET_MODE_page; \
	COMMAND trans9_Temp_TARGET_MODE_read; \
	COMMAND trans9_Temp_TARGET_MODE_write; \
	COLLECTION trans9_Temp_MODE_BLK; \
	VARIABLE trans9_Temp_MODE_BLK_Actual; \
	VARIABLE trans9_Temp_MODE_BLK_Permitted; \
	VARIABLE trans9_Temp_MODE_BLK_Normal; \
	MENU trans9_Temp_MODE_BLK_page; \
	COMMAND trans9_Temp_MODE_BLK_read; \
	COLLECTION trans9_Temp_ALARM_SUM; \
	VARIABLE trans9_Temp_ALARM_SUM_Current; \
	VARIABLE trans9_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans9_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans9_Temp_ALARM_SUM_Disabled; \
	MENU trans9_Temp_ALARM_SUM_page; \
	COMMAND trans9_Temp_ALARM_SUM_read; \
	COLLECTION trans9_Temp_PRIMARY_VALUE; \
	VARIABLE trans9_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans9_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans9_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans9_Temp_PRIMARY_VALUE_page; \
	COMMAND trans9_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans9_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans9_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans9_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans9_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans9_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans9_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans9_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans9_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans9_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans9_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans9_Temp_SENSOR_MEAS_TYPE; \
	MENU trans9_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans9_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans9_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans9_Temp_INPUT_RANGE; \
	MENU trans9_Temp_INPUT_RANGE_page; \
	COMMAND trans9_Temp_INPUT_RANGE_read; \
	COMMAND trans9_Temp_INPUT_RANGE_write; \
	VARIABLE trans9_Temp_LIN_TYPE; \
	MENU trans9_Temp_LIN_TYPE_page; \
	COMMAND trans9_Temp_LIN_TYPE_read; \
	COMMAND trans9_Temp_LIN_TYPE_write; \
	VARIABLE trans9_Temp_BIAS_1; \
	MENU trans9_Temp_BIAS_1_page; \
	COMMAND trans9_Temp_BIAS_1_read; \
	COMMAND trans9_Temp_BIAS_1_write; \
	VARIABLE trans9_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans9_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans9_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans9_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans9_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans9_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans9_Temp_INPUT_FAULT_GEN; \
	MENU trans9_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans9_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans9_Temp_INPUT_FAULT_1; \
	MENU trans9_Temp_INPUT_FAULT_1_page; \
	COMMAND trans9_Temp_INPUT_FAULT_1_read; \
	UNIT trans9_Temp_Unit_1; \
	VARIABLE trans9_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans9_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans9_Temp_Display; \
	CHART trans9_Temp_Display_BarVal_pv; \
	SOURCE trans9_Temp_Display_BarVal_pv_source; \
	MENU trans9_Temp_Display_primary; \
	MENU trans9_Temp_Display_secondary; \
	MENU trans9_Temp_Tab_s; \
	MENU trans9_Temp_Tab_s_measrange; \
	MENU trans9_Temp_Tab_m

#define USE_TRANS9_TEMP_MANDATORY_A \
	USE_TRANS9_TEMP_MANDATORY_BOTH; \
	MENU trans9_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS9_TEMP_MANDATORY_B \
	USE_TRANS9_TEMP_MANDATORY_BOTH; \
	COLLECTION trans9_Temp_VIEW_1; \
	MENU trans9_Temp_VIEW_1_page; \
	MENU trans9_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS9_TEMP_OPTIONAL_BOTH \
	COLLECTION trans9_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans9_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans9_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans9_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans9_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans9_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans9_Temp_BIAS_2; \
	MENU trans9_Temp_BIAS_2_page; \
	COMMAND trans9_Temp_BIAS_2_read; \
	COMMAND trans9_Temp_BIAS_2_write; \
	VARIABLE trans9_Temp_INPUT_FAULT_2; \
	MENU trans9_Temp_INPUT_FAULT_2_page; \
	COMMAND trans9_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans9_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans9_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans9_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans9_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans9_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans9_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans9_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans9_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans9_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans9_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans9_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans9_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans9_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans9_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans9_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans9_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans9_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans9_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans9_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans9_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans9_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans9_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans9_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans9_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans9_Temp_TAB_ENTRY; \
	MENU trans9_Temp_TAB_ENTRY_page; \
	COMMAND trans9_Temp_TAB_ENTRY_read; \
	COMMAND trans9_Temp_TAB_ENTRY_write; \
	COLLECTION trans9_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans9_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans9_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans9_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans9_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans9_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans9_Temp_TAB_MIN_NUMBER; \
	MENU trans9_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans9_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans9_Temp_TAB_MAX_NUMBER; \
	MENU trans9_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans9_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans9_Temp_TAB_OP_CODE; \
	MENU trans9_Temp_TAB_OP_CODE_page; \
	COMMAND trans9_Temp_TAB_OP_CODE_read; \
	COMMAND trans9_Temp_TAB_OP_CODE_write; \
	VARIABLE trans9_Temp_TAB_STATUS; \
	MENU trans9_Temp_TAB_STATUS_page; \
	COMMAND trans9_Temp_TAB_STATUS_read; \
	VARIABLE trans9_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans9_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans9_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans9_Temp_Unit_2

#define USE_TRANS9_TEMP_OPTIONAL_A \
	USE_TRANS9_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans9_Temp_VIEW_1; \
	MENU trans9_Temp_VIEW_1_page; \
	MENU trans9_Temp_Simple_Dialog_Optional_A

#define USE_TRANS9_TEMP_OPTIONAL_B \
	USE_TRANS9_TEMP_OPTIONAL_BOTH; \
	MENU trans9_Temp_Simple_Dialog_Optional_B

#define USE_TRANS9_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans9_Temp_RJ_TYPE; \
	MENU trans9_Temp_RJ_TYPE_page; \
	COMMAND trans9_Temp_RJ_TYPE_read; \
	COMMAND trans9_Temp_RJ_TYPE_write; \
	MENU trans9_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS9_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans9_Temp_SENSOR_CONNECTION; \
	MENU trans9_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans9_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans9_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans9_Temp_COMP_WIRE1; \
	MENU trans9_Temp_COMP_WIRE1_page; \
	COMMAND trans9_Temp_COMP_WIRE1_read; \
	COMMAND trans9_Temp_COMP_WIRE1_write; \
	MENU trans9_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS9_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans9_Temp_EMISSIVITY; \
	MENU trans9_Temp_EMISSIVITY_page; \
	COMMAND trans9_Temp_EMISSIVITY_read; \
	COMMAND trans9_Temp_EMISSIVITY_write; \
	VARIABLE trans9_Temp_PEAK_TRACK; \
	MENU trans9_Temp_PEAK_TRACK_page; \
	COMMAND trans9_Temp_PEAK_TRACK_read; \
	COMMAND trans9_Temp_PEAK_TRACK_write; \
	VARIABLE trans9_Temp_DECAY_RATE; \
	MENU trans9_Temp_DECAY_RATE_page; \
	COMMAND trans9_Temp_DECAY_RATE_read; \
	COMMAND trans9_Temp_DECAY_RATE_write; \
	VARIABLE trans9_Temp_PEAK_TIME; \
	MENU trans9_Temp_PEAK_TIME_page; \
	COMMAND trans9_Temp_PEAK_TIME_read; \
	COMMAND trans9_Temp_PEAK_TIME_write; \
	VARIABLE trans9_Temp_TRACK_HOLD; \
	MENU trans9_Temp_TRACK_HOLD_page; \
	COMMAND trans9_Temp_TRACK_HOLD_read; \
	COMMAND trans9_Temp_TRACK_HOLD_write; \
	VARIABLE trans9_Temp_SPECT_FILT_SET; \
	MENU trans9_Temp_SPECT_FILT_SET_page; \
	COMMAND trans9_Temp_SPECT_FILT_SET_read; \
	COMMAND trans9_Temp_SPECT_FILT_SET_write; \
	MENU trans9_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS9_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans9_Temp_RJ_TYPE; \
	MENU trans9_Temp_RJ_TYPE_page; \
	COMMAND trans9_Temp_RJ_TYPE_read; \
	COMMAND trans9_Temp_RJ_TYPE_write; \
	MENU trans9_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS9_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans9_Temp_SENSOR_CONNECTION; \
	MENU trans9_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans9_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans9_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans9_Temp_COMP_WIRE1; \
	MENU trans9_Temp_COMP_WIRE1_page; \
	COMMAND trans9_Temp_COMP_WIRE1_read; \
	COMMAND trans9_Temp_COMP_WIRE1_write; \
	MENU trans9_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS9_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans9_Temp_EMISSIVITY; \
	MENU trans9_Temp_EMISSIVITY_page; \
	COMMAND trans9_Temp_EMISSIVITY_read; \
	COMMAND trans9_Temp_EMISSIVITY_write; \
	VARIABLE trans9_Temp_PEAK_TRACK; \
	MENU trans9_Temp_PEAK_TRACK_page; \
	COMMAND trans9_Temp_PEAK_TRACK_read; \
	COMMAND trans9_Temp_PEAK_TRACK_write; \
	VARIABLE trans9_Temp_DECAY_RATE; \
	MENU trans9_Temp_DECAY_RATE_page; \
	COMMAND trans9_Temp_DECAY_RATE_read; \
	COMMAND trans9_Temp_DECAY_RATE_write; \
	VARIABLE trans9_Temp_PEAK_TIME; \
	MENU trans9_Temp_PEAK_TIME_page; \
	COMMAND trans9_Temp_PEAK_TIME_read; \
	COMMAND trans9_Temp_PEAK_TIME_write; \
	VARIABLE trans9_Temp_TRACK_HOLD; \
	MENU trans9_Temp_TRACK_HOLD_page; \
	COMMAND trans9_Temp_TRACK_HOLD_read; \
	COMMAND trans9_Temp_TRACK_HOLD_write; \
	VARIABLE trans9_Temp_SPECT_FILT_SET; \
	MENU trans9_Temp_SPECT_FILT_SET_page; \
	COMMAND trans9_Temp_SPECT_FILT_SET_read; \
	COMMAND trans9_Temp_SPECT_FILT_SET_write; \
	MENU trans9_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS9_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans9_Temp_RJ_TEMP; \
	MENU trans9_Temp_RJ_TEMP_page; \
	COMMAND trans9_Temp_RJ_TEMP_read; \
	VARIABLE trans9_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans9_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans9_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans9_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans9_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans9_Temp_Unit_3

#define USE_TRANS9_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans9_Temp_COMP_WIRE2; \
	MENU trans9_Temp_COMP_WIRE2_page; \
	COMMAND trans9_Temp_COMP_WIRE2_read; \
	COMMAND trans9_Temp_COMP_WIRE2_write; \
	MENU trans9_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS9_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans9_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS9_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans9_Temp_RJ_TEMP; \
	MENU trans9_Temp_RJ_TEMP_page; \
	COMMAND trans9_Temp_RJ_TEMP_read; \
	VARIABLE trans9_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans9_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans9_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans9_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans9_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans9_Temp_Unit_3

#define USE_TRANS9_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans9_Temp_COMP_WIRE2; \
	MENU trans9_Temp_COMP_WIRE2_page; \
	COMMAND trans9_Temp_COMP_WIRE2_read; \
	COMMAND trans9_Temp_COMP_WIRE2_write; \
	MENU trans9_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS9_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans9_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS9_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans9_Temp_)
#define USE_TRANS9_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans9_Temp_)
#define USE_TRANS9_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans9_Temp_)
#define USE_TRANS9_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans9_Temp_)
#define USE_TRANS9_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans9_Temp_)
#define USE_TRANS9_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans9_Temp_)
#define USE_TRANS9_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans9_Temp_)
#define USE_TRANS9_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans9_Temp_)
#define USE_TRANS9_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans9_Temp_)
#define USE_TRANS9_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans9_Temp_)
#define USE_TRANS9_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans9_Temp_)
#define USE_TRANS9_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans9_Temp_)
#define USE_TRANS9_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans9_Temp_)
#define USE_TRANS9_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans9_Temp_)
#define USE_TRANS9_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans9_Temp_)
#define USE_TRANS9_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans9_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS10_TEMP_MANDATORY_BOTH \
	BLOCK trans10_Temp_block; \
	COLLECTION trans10_Temp_BLOCK_OBJECT; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans10_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans10_Temp_BLOCK_OBJECT_page; \
	COMMAND trans10_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans10_Temp_ST_REV; \
	MENU trans10_Temp_ST_REV_page; \
	COMMAND trans10_Temp_ST_REV_read; \
	VARIABLE trans10_Temp_TAG_DESC; \
	MENU trans10_Temp_TAG_DESC_page; \
	COMMAND trans10_Temp_TAG_DESC_read; \
	COMMAND trans10_Temp_TAG_DESC_write; \
	VARIABLE trans10_Temp_STRATEGY; \
	MENU trans10_Temp_STRATEGY_page; \
	COMMAND trans10_Temp_STRATEGY_read; \
	COMMAND trans10_Temp_STRATEGY_write; \
	VARIABLE trans10_Temp_ALERT_KEY; \
	MENU trans10_Temp_ALERT_KEY_page; \
	COMMAND trans10_Temp_ALERT_KEY_read; \
	COMMAND trans10_Temp_ALERT_KEY_write; \
	VARIABLE trans10_Temp_TARGET_MODE; \
	MENU trans10_Temp_TARGET_MODE_page; \
	COMMAND trans10_Temp_TARGET_MODE_read; \
	COMMAND trans10_Temp_TARGET_MODE_write; \
	COLLECTION trans10_Temp_MODE_BLK; \
	VARIABLE trans10_Temp_MODE_BLK_Actual; \
	VARIABLE trans10_Temp_MODE_BLK_Permitted; \
	VARIABLE trans10_Temp_MODE_BLK_Normal; \
	MENU trans10_Temp_MODE_BLK_page; \
	COMMAND trans10_Temp_MODE_BLK_read; \
	COLLECTION trans10_Temp_ALARM_SUM; \
	VARIABLE trans10_Temp_ALARM_SUM_Current; \
	VARIABLE trans10_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans10_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans10_Temp_ALARM_SUM_Disabled; \
	MENU trans10_Temp_ALARM_SUM_page; \
	COMMAND trans10_Temp_ALARM_SUM_read; \
	COLLECTION trans10_Temp_PRIMARY_VALUE; \
	VARIABLE trans10_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans10_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans10_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans10_Temp_PRIMARY_VALUE_page; \
	COMMAND trans10_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans10_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans10_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans10_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans10_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans10_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans10_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans10_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans10_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans10_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans10_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans10_Temp_SENSOR_MEAS_TYPE; \
	MENU trans10_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans10_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans10_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans10_Temp_INPUT_RANGE; \
	MENU trans10_Temp_INPUT_RANGE_page; \
	COMMAND trans10_Temp_INPUT_RANGE_read; \
	COMMAND trans10_Temp_INPUT_RANGE_write; \
	VARIABLE trans10_Temp_LIN_TYPE; \
	MENU trans10_Temp_LIN_TYPE_page; \
	COMMAND trans10_Temp_LIN_TYPE_read; \
	COMMAND trans10_Temp_LIN_TYPE_write; \
	VARIABLE trans10_Temp_BIAS_1; \
	MENU trans10_Temp_BIAS_1_page; \
	COMMAND trans10_Temp_BIAS_1_read; \
	COMMAND trans10_Temp_BIAS_1_write; \
	VARIABLE trans10_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans10_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans10_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans10_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans10_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans10_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans10_Temp_INPUT_FAULT_GEN; \
	MENU trans10_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans10_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans10_Temp_INPUT_FAULT_1; \
	MENU trans10_Temp_INPUT_FAULT_1_page; \
	COMMAND trans10_Temp_INPUT_FAULT_1_read; \
	UNIT trans10_Temp_Unit_1; \
	VARIABLE trans10_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans10_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans10_Temp_Display; \
	CHART trans10_Temp_Display_BarVal_pv; \
	SOURCE trans10_Temp_Display_BarVal_pv_source; \
	MENU trans10_Temp_Display_primary; \
	MENU trans10_Temp_Display_secondary; \
	MENU trans10_Temp_Tab_s; \
	MENU trans10_Temp_Tab_s_measrange; \
	MENU trans10_Temp_Tab_m

#define USE_TRANS10_TEMP_MANDATORY_A \
	USE_TRANS10_TEMP_MANDATORY_BOTH; \
	MENU trans10_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS10_TEMP_MANDATORY_B \
	USE_TRANS10_TEMP_MANDATORY_BOTH; \
	COLLECTION trans10_Temp_VIEW_1; \
	MENU trans10_Temp_VIEW_1_page; \
	MENU trans10_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS10_TEMP_OPTIONAL_BOTH \
	COLLECTION trans10_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans10_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans10_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans10_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans10_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans10_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans10_Temp_BIAS_2; \
	MENU trans10_Temp_BIAS_2_page; \
	COMMAND trans10_Temp_BIAS_2_read; \
	COMMAND trans10_Temp_BIAS_2_write; \
	VARIABLE trans10_Temp_INPUT_FAULT_2; \
	MENU trans10_Temp_INPUT_FAULT_2_page; \
	COMMAND trans10_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans10_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans10_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans10_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans10_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans10_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans10_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans10_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans10_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans10_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans10_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans10_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans10_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans10_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans10_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans10_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans10_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans10_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans10_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans10_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans10_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans10_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans10_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans10_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans10_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans10_Temp_TAB_ENTRY; \
	MENU trans10_Temp_TAB_ENTRY_page; \
	COMMAND trans10_Temp_TAB_ENTRY_read; \
	COMMAND trans10_Temp_TAB_ENTRY_write; \
	COLLECTION trans10_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans10_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans10_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans10_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans10_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans10_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans10_Temp_TAB_MIN_NUMBER; \
	MENU trans10_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans10_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans10_Temp_TAB_MAX_NUMBER; \
	MENU trans10_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans10_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans10_Temp_TAB_OP_CODE; \
	MENU trans10_Temp_TAB_OP_CODE_page; \
	COMMAND trans10_Temp_TAB_OP_CODE_read; \
	COMMAND trans10_Temp_TAB_OP_CODE_write; \
	VARIABLE trans10_Temp_TAB_STATUS; \
	MENU trans10_Temp_TAB_STATUS_page; \
	COMMAND trans10_Temp_TAB_STATUS_read; \
	VARIABLE trans10_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans10_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans10_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans10_Temp_Unit_2

#define USE_TRANS10_TEMP_OPTIONAL_A \
	USE_TRANS10_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans10_Temp_VIEW_1; \
	MENU trans10_Temp_VIEW_1_page; \
	MENU trans10_Temp_Simple_Dialog_Optional_A

#define USE_TRANS10_TEMP_OPTIONAL_B \
	USE_TRANS10_TEMP_OPTIONAL_BOTH; \
	MENU trans10_Temp_Simple_Dialog_Optional_B

#define USE_TRANS10_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans10_Temp_RJ_TYPE; \
	MENU trans10_Temp_RJ_TYPE_page; \
	COMMAND trans10_Temp_RJ_TYPE_read; \
	COMMAND trans10_Temp_RJ_TYPE_write; \
	MENU trans10_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS10_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans10_Temp_SENSOR_CONNECTION; \
	MENU trans10_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans10_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans10_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans10_Temp_COMP_WIRE1; \
	MENU trans10_Temp_COMP_WIRE1_page; \
	COMMAND trans10_Temp_COMP_WIRE1_read; \
	COMMAND trans10_Temp_COMP_WIRE1_write; \
	MENU trans10_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS10_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans10_Temp_EMISSIVITY; \
	MENU trans10_Temp_EMISSIVITY_page; \
	COMMAND trans10_Temp_EMISSIVITY_read; \
	COMMAND trans10_Temp_EMISSIVITY_write; \
	VARIABLE trans10_Temp_PEAK_TRACK; \
	MENU trans10_Temp_PEAK_TRACK_page; \
	COMMAND trans10_Temp_PEAK_TRACK_read; \
	COMMAND trans10_Temp_PEAK_TRACK_write; \
	VARIABLE trans10_Temp_DECAY_RATE; \
	MENU trans10_Temp_DECAY_RATE_page; \
	COMMAND trans10_Temp_DECAY_RATE_read; \
	COMMAND trans10_Temp_DECAY_RATE_write; \
	VARIABLE trans10_Temp_PEAK_TIME; \
	MENU trans10_Temp_PEAK_TIME_page; \
	COMMAND trans10_Temp_PEAK_TIME_read; \
	COMMAND trans10_Temp_PEAK_TIME_write; \
	VARIABLE trans10_Temp_TRACK_HOLD; \
	MENU trans10_Temp_TRACK_HOLD_page; \
	COMMAND trans10_Temp_TRACK_HOLD_read; \
	COMMAND trans10_Temp_TRACK_HOLD_write; \
	VARIABLE trans10_Temp_SPECT_FILT_SET; \
	MENU trans10_Temp_SPECT_FILT_SET_page; \
	COMMAND trans10_Temp_SPECT_FILT_SET_read; \
	COMMAND trans10_Temp_SPECT_FILT_SET_write; \
	MENU trans10_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS10_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans10_Temp_RJ_TYPE; \
	MENU trans10_Temp_RJ_TYPE_page; \
	COMMAND trans10_Temp_RJ_TYPE_read; \
	COMMAND trans10_Temp_RJ_TYPE_write; \
	MENU trans10_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS10_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans10_Temp_SENSOR_CONNECTION; \
	MENU trans10_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans10_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans10_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans10_Temp_COMP_WIRE1; \
	MENU trans10_Temp_COMP_WIRE1_page; \
	COMMAND trans10_Temp_COMP_WIRE1_read; \
	COMMAND trans10_Temp_COMP_WIRE1_write; \
	MENU trans10_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS10_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans10_Temp_EMISSIVITY; \
	MENU trans10_Temp_EMISSIVITY_page; \
	COMMAND trans10_Temp_EMISSIVITY_read; \
	COMMAND trans10_Temp_EMISSIVITY_write; \
	VARIABLE trans10_Temp_PEAK_TRACK; \
	MENU trans10_Temp_PEAK_TRACK_page; \
	COMMAND trans10_Temp_PEAK_TRACK_read; \
	COMMAND trans10_Temp_PEAK_TRACK_write; \
	VARIABLE trans10_Temp_DECAY_RATE; \
	MENU trans10_Temp_DECAY_RATE_page; \
	COMMAND trans10_Temp_DECAY_RATE_read; \
	COMMAND trans10_Temp_DECAY_RATE_write; \
	VARIABLE trans10_Temp_PEAK_TIME; \
	MENU trans10_Temp_PEAK_TIME_page; \
	COMMAND trans10_Temp_PEAK_TIME_read; \
	COMMAND trans10_Temp_PEAK_TIME_write; \
	VARIABLE trans10_Temp_TRACK_HOLD; \
	MENU trans10_Temp_TRACK_HOLD_page; \
	COMMAND trans10_Temp_TRACK_HOLD_read; \
	COMMAND trans10_Temp_TRACK_HOLD_write; \
	VARIABLE trans10_Temp_SPECT_FILT_SET; \
	MENU trans10_Temp_SPECT_FILT_SET_page; \
	COMMAND trans10_Temp_SPECT_FILT_SET_read; \
	COMMAND trans10_Temp_SPECT_FILT_SET_write; \
	MENU trans10_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS10_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans10_Temp_RJ_TEMP; \
	MENU trans10_Temp_RJ_TEMP_page; \
	COMMAND trans10_Temp_RJ_TEMP_read; \
	VARIABLE trans10_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans10_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans10_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans10_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans10_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans10_Temp_Unit_3

#define USE_TRANS10_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans10_Temp_COMP_WIRE2; \
	MENU trans10_Temp_COMP_WIRE2_page; \
	COMMAND trans10_Temp_COMP_WIRE2_read; \
	COMMAND trans10_Temp_COMP_WIRE2_write; \
	MENU trans10_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS10_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans10_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS10_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans10_Temp_RJ_TEMP; \
	MENU trans10_Temp_RJ_TEMP_page; \
	COMMAND trans10_Temp_RJ_TEMP_read; \
	VARIABLE trans10_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans10_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans10_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans10_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans10_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans10_Temp_Unit_3

#define USE_TRANS10_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans10_Temp_COMP_WIRE2; \
	MENU trans10_Temp_COMP_WIRE2_page; \
	COMMAND trans10_Temp_COMP_WIRE2_read; \
	COMMAND trans10_Temp_COMP_WIRE2_write; \
	MENU trans10_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS10_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans10_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS10_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans10_Temp_)
#define USE_TRANS10_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans10_Temp_)
#define USE_TRANS10_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans10_Temp_)
#define USE_TRANS10_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans10_Temp_)
#define USE_TRANS10_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans10_Temp_)
#define USE_TRANS10_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans10_Temp_)
#define USE_TRANS10_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans10_Temp_)
#define USE_TRANS10_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans10_Temp_)
#define USE_TRANS10_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans10_Temp_)
#define USE_TRANS10_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans10_Temp_)
#define USE_TRANS10_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans10_Temp_)
#define USE_TRANS10_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans10_Temp_)
#define USE_TRANS10_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans10_Temp_)
#define USE_TRANS10_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans10_Temp_)
#define USE_TRANS10_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans10_Temp_)
#define USE_TRANS10_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans10_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS11_TEMP_MANDATORY_BOTH \
	BLOCK trans11_Temp_block; \
	COLLECTION trans11_Temp_BLOCK_OBJECT; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans11_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans11_Temp_BLOCK_OBJECT_page; \
	COMMAND trans11_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans11_Temp_ST_REV; \
	MENU trans11_Temp_ST_REV_page; \
	COMMAND trans11_Temp_ST_REV_read; \
	VARIABLE trans11_Temp_TAG_DESC; \
	MENU trans11_Temp_TAG_DESC_page; \
	COMMAND trans11_Temp_TAG_DESC_read; \
	COMMAND trans11_Temp_TAG_DESC_write; \
	VARIABLE trans11_Temp_STRATEGY; \
	MENU trans11_Temp_STRATEGY_page; \
	COMMAND trans11_Temp_STRATEGY_read; \
	COMMAND trans11_Temp_STRATEGY_write; \
	VARIABLE trans11_Temp_ALERT_KEY; \
	MENU trans11_Temp_ALERT_KEY_page; \
	COMMAND trans11_Temp_ALERT_KEY_read; \
	COMMAND trans11_Temp_ALERT_KEY_write; \
	VARIABLE trans11_Temp_TARGET_MODE; \
	MENU trans11_Temp_TARGET_MODE_page; \
	COMMAND trans11_Temp_TARGET_MODE_read; \
	COMMAND trans11_Temp_TARGET_MODE_write; \
	COLLECTION trans11_Temp_MODE_BLK; \
	VARIABLE trans11_Temp_MODE_BLK_Actual; \
	VARIABLE trans11_Temp_MODE_BLK_Permitted; \
	VARIABLE trans11_Temp_MODE_BLK_Normal; \
	MENU trans11_Temp_MODE_BLK_page; \
	COMMAND trans11_Temp_MODE_BLK_read; \
	COLLECTION trans11_Temp_ALARM_SUM; \
	VARIABLE trans11_Temp_ALARM_SUM_Current; \
	VARIABLE trans11_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans11_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans11_Temp_ALARM_SUM_Disabled; \
	MENU trans11_Temp_ALARM_SUM_page; \
	COMMAND trans11_Temp_ALARM_SUM_read; \
	COLLECTION trans11_Temp_PRIMARY_VALUE; \
	VARIABLE trans11_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans11_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans11_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans11_Temp_PRIMARY_VALUE_page; \
	COMMAND trans11_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans11_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans11_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans11_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans11_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans11_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans11_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans11_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans11_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans11_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans11_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans11_Temp_SENSOR_MEAS_TYPE; \
	MENU trans11_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans11_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans11_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans11_Temp_INPUT_RANGE; \
	MENU trans11_Temp_INPUT_RANGE_page; \
	COMMAND trans11_Temp_INPUT_RANGE_read; \
	COMMAND trans11_Temp_INPUT_RANGE_write; \
	VARIABLE trans11_Temp_LIN_TYPE; \
	MENU trans11_Temp_LIN_TYPE_page; \
	COMMAND trans11_Temp_LIN_TYPE_read; \
	COMMAND trans11_Temp_LIN_TYPE_write; \
	VARIABLE trans11_Temp_BIAS_1; \
	MENU trans11_Temp_BIAS_1_page; \
	COMMAND trans11_Temp_BIAS_1_read; \
	COMMAND trans11_Temp_BIAS_1_write; \
	VARIABLE trans11_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans11_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans11_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans11_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans11_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans11_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans11_Temp_INPUT_FAULT_GEN; \
	MENU trans11_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans11_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans11_Temp_INPUT_FAULT_1; \
	MENU trans11_Temp_INPUT_FAULT_1_page; \
	COMMAND trans11_Temp_INPUT_FAULT_1_read; \
	UNIT trans11_Temp_Unit_1; \
	VARIABLE trans11_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans11_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans11_Temp_Display; \
	CHART trans11_Temp_Display_BarVal_pv; \
	SOURCE trans11_Temp_Display_BarVal_pv_source; \
	MENU trans11_Temp_Display_primary; \
	MENU trans11_Temp_Display_secondary; \
	MENU trans11_Temp_Tab_s; \
	MENU trans11_Temp_Tab_s_measrange; \
	MENU trans11_Temp_Tab_m

#define USE_TRANS11_TEMP_MANDATORY_A \
	USE_TRANS11_TEMP_MANDATORY_BOTH; \
	MENU trans11_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS11_TEMP_MANDATORY_B \
	USE_TRANS11_TEMP_MANDATORY_BOTH; \
	COLLECTION trans11_Temp_VIEW_1; \
	MENU trans11_Temp_VIEW_1_page; \
	MENU trans11_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS11_TEMP_OPTIONAL_BOTH \
	COLLECTION trans11_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans11_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans11_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans11_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans11_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans11_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans11_Temp_BIAS_2; \
	MENU trans11_Temp_BIAS_2_page; \
	COMMAND trans11_Temp_BIAS_2_read; \
	COMMAND trans11_Temp_BIAS_2_write; \
	VARIABLE trans11_Temp_INPUT_FAULT_2; \
	MENU trans11_Temp_INPUT_FAULT_2_page; \
	COMMAND trans11_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans11_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans11_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans11_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans11_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans11_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans11_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans11_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans11_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans11_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans11_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans11_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans11_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans11_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans11_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans11_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans11_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans11_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans11_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans11_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans11_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans11_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans11_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans11_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans11_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans11_Temp_TAB_ENTRY; \
	MENU trans11_Temp_TAB_ENTRY_page; \
	COMMAND trans11_Temp_TAB_ENTRY_read; \
	COMMAND trans11_Temp_TAB_ENTRY_write; \
	COLLECTION trans11_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans11_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans11_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans11_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans11_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans11_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans11_Temp_TAB_MIN_NUMBER; \
	MENU trans11_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans11_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans11_Temp_TAB_MAX_NUMBER; \
	MENU trans11_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans11_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans11_Temp_TAB_OP_CODE; \
	MENU trans11_Temp_TAB_OP_CODE_page; \
	COMMAND trans11_Temp_TAB_OP_CODE_read; \
	COMMAND trans11_Temp_TAB_OP_CODE_write; \
	VARIABLE trans11_Temp_TAB_STATUS; \
	MENU trans11_Temp_TAB_STATUS_page; \
	COMMAND trans11_Temp_TAB_STATUS_read; \
	VARIABLE trans11_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans11_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans11_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans11_Temp_Unit_2

#define USE_TRANS11_TEMP_OPTIONAL_A \
	USE_TRANS11_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans11_Temp_VIEW_1; \
	MENU trans11_Temp_VIEW_1_page; \
	MENU trans11_Temp_Simple_Dialog_Optional_A

#define USE_TRANS11_TEMP_OPTIONAL_B \
	USE_TRANS11_TEMP_OPTIONAL_BOTH; \
	MENU trans11_Temp_Simple_Dialog_Optional_B

#define USE_TRANS11_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans11_Temp_RJ_TYPE; \
	MENU trans11_Temp_RJ_TYPE_page; \
	COMMAND trans11_Temp_RJ_TYPE_read; \
	COMMAND trans11_Temp_RJ_TYPE_write; \
	MENU trans11_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS11_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans11_Temp_SENSOR_CONNECTION; \
	MENU trans11_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans11_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans11_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans11_Temp_COMP_WIRE1; \
	MENU trans11_Temp_COMP_WIRE1_page; \
	COMMAND trans11_Temp_COMP_WIRE1_read; \
	COMMAND trans11_Temp_COMP_WIRE1_write; \
	MENU trans11_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS11_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans11_Temp_EMISSIVITY; \
	MENU trans11_Temp_EMISSIVITY_page; \
	COMMAND trans11_Temp_EMISSIVITY_read; \
	COMMAND trans11_Temp_EMISSIVITY_write; \
	VARIABLE trans11_Temp_PEAK_TRACK; \
	MENU trans11_Temp_PEAK_TRACK_page; \
	COMMAND trans11_Temp_PEAK_TRACK_read; \
	COMMAND trans11_Temp_PEAK_TRACK_write; \
	VARIABLE trans11_Temp_DECAY_RATE; \
	MENU trans11_Temp_DECAY_RATE_page; \
	COMMAND trans11_Temp_DECAY_RATE_read; \
	COMMAND trans11_Temp_DECAY_RATE_write; \
	VARIABLE trans11_Temp_PEAK_TIME; \
	MENU trans11_Temp_PEAK_TIME_page; \
	COMMAND trans11_Temp_PEAK_TIME_read; \
	COMMAND trans11_Temp_PEAK_TIME_write; \
	VARIABLE trans11_Temp_TRACK_HOLD; \
	MENU trans11_Temp_TRACK_HOLD_page; \
	COMMAND trans11_Temp_TRACK_HOLD_read; \
	COMMAND trans11_Temp_TRACK_HOLD_write; \
	VARIABLE trans11_Temp_SPECT_FILT_SET; \
	MENU trans11_Temp_SPECT_FILT_SET_page; \
	COMMAND trans11_Temp_SPECT_FILT_SET_read; \
	COMMAND trans11_Temp_SPECT_FILT_SET_write; \
	MENU trans11_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS11_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans11_Temp_RJ_TYPE; \
	MENU trans11_Temp_RJ_TYPE_page; \
	COMMAND trans11_Temp_RJ_TYPE_read; \
	COMMAND trans11_Temp_RJ_TYPE_write; \
	MENU trans11_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS11_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans11_Temp_SENSOR_CONNECTION; \
	MENU trans11_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans11_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans11_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans11_Temp_COMP_WIRE1; \
	MENU trans11_Temp_COMP_WIRE1_page; \
	COMMAND trans11_Temp_COMP_WIRE1_read; \
	COMMAND trans11_Temp_COMP_WIRE1_write; \
	MENU trans11_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS11_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans11_Temp_EMISSIVITY; \
	MENU trans11_Temp_EMISSIVITY_page; \
	COMMAND trans11_Temp_EMISSIVITY_read; \
	COMMAND trans11_Temp_EMISSIVITY_write; \
	VARIABLE trans11_Temp_PEAK_TRACK; \
	MENU trans11_Temp_PEAK_TRACK_page; \
	COMMAND trans11_Temp_PEAK_TRACK_read; \
	COMMAND trans11_Temp_PEAK_TRACK_write; \
	VARIABLE trans11_Temp_DECAY_RATE; \
	MENU trans11_Temp_DECAY_RATE_page; \
	COMMAND trans11_Temp_DECAY_RATE_read; \
	COMMAND trans11_Temp_DECAY_RATE_write; \
	VARIABLE trans11_Temp_PEAK_TIME; \
	MENU trans11_Temp_PEAK_TIME_page; \
	COMMAND trans11_Temp_PEAK_TIME_read; \
	COMMAND trans11_Temp_PEAK_TIME_write; \
	VARIABLE trans11_Temp_TRACK_HOLD; \
	MENU trans11_Temp_TRACK_HOLD_page; \
	COMMAND trans11_Temp_TRACK_HOLD_read; \
	COMMAND trans11_Temp_TRACK_HOLD_write; \
	VARIABLE trans11_Temp_SPECT_FILT_SET; \
	MENU trans11_Temp_SPECT_FILT_SET_page; \
	COMMAND trans11_Temp_SPECT_FILT_SET_read; \
	COMMAND trans11_Temp_SPECT_FILT_SET_write; \
	MENU trans11_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS11_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans11_Temp_RJ_TEMP; \
	MENU trans11_Temp_RJ_TEMP_page; \
	COMMAND trans11_Temp_RJ_TEMP_read; \
	VARIABLE trans11_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans11_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans11_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans11_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans11_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans11_Temp_Unit_3

#define USE_TRANS11_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans11_Temp_COMP_WIRE2; \
	MENU trans11_Temp_COMP_WIRE2_page; \
	COMMAND trans11_Temp_COMP_WIRE2_read; \
	COMMAND trans11_Temp_COMP_WIRE2_write; \
	MENU trans11_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS11_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans11_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS11_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans11_Temp_RJ_TEMP; \
	MENU trans11_Temp_RJ_TEMP_page; \
	COMMAND trans11_Temp_RJ_TEMP_read; \
	VARIABLE trans11_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans11_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans11_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans11_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans11_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans11_Temp_Unit_3

#define USE_TRANS11_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans11_Temp_COMP_WIRE2; \
	MENU trans11_Temp_COMP_WIRE2_page; \
	COMMAND trans11_Temp_COMP_WIRE2_read; \
	COMMAND trans11_Temp_COMP_WIRE2_write; \
	MENU trans11_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS11_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans11_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS11_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans11_Temp_)
#define USE_TRANS11_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans11_Temp_)
#define USE_TRANS11_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans11_Temp_)
#define USE_TRANS11_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans11_Temp_)
#define USE_TRANS11_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans11_Temp_)
#define USE_TRANS11_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans11_Temp_)
#define USE_TRANS11_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans11_Temp_)
#define USE_TRANS11_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans11_Temp_)
#define USE_TRANS11_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans11_Temp_)
#define USE_TRANS11_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans11_Temp_)
#define USE_TRANS11_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans11_Temp_)
#define USE_TRANS11_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans11_Temp_)
#define USE_TRANS11_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans11_Temp_)
#define USE_TRANS11_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans11_Temp_)
#define USE_TRANS11_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans11_Temp_)
#define USE_TRANS11_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans11_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS12_TEMP_MANDATORY_BOTH \
	BLOCK trans12_Temp_block; \
	COLLECTION trans12_Temp_BLOCK_OBJECT; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans12_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans12_Temp_BLOCK_OBJECT_page; \
	COMMAND trans12_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans12_Temp_ST_REV; \
	MENU trans12_Temp_ST_REV_page; \
	COMMAND trans12_Temp_ST_REV_read; \
	VARIABLE trans12_Temp_TAG_DESC; \
	MENU trans12_Temp_TAG_DESC_page; \
	COMMAND trans12_Temp_TAG_DESC_read; \
	COMMAND trans12_Temp_TAG_DESC_write; \
	VARIABLE trans12_Temp_STRATEGY; \
	MENU trans12_Temp_STRATEGY_page; \
	COMMAND trans12_Temp_STRATEGY_read; \
	COMMAND trans12_Temp_STRATEGY_write; \
	VARIABLE trans12_Temp_ALERT_KEY; \
	MENU trans12_Temp_ALERT_KEY_page; \
	COMMAND trans12_Temp_ALERT_KEY_read; \
	COMMAND trans12_Temp_ALERT_KEY_write; \
	VARIABLE trans12_Temp_TARGET_MODE; \
	MENU trans12_Temp_TARGET_MODE_page; \
	COMMAND trans12_Temp_TARGET_MODE_read; \
	COMMAND trans12_Temp_TARGET_MODE_write; \
	COLLECTION trans12_Temp_MODE_BLK; \
	VARIABLE trans12_Temp_MODE_BLK_Actual; \
	VARIABLE trans12_Temp_MODE_BLK_Permitted; \
	VARIABLE trans12_Temp_MODE_BLK_Normal; \
	MENU trans12_Temp_MODE_BLK_page; \
	COMMAND trans12_Temp_MODE_BLK_read; \
	COLLECTION trans12_Temp_ALARM_SUM; \
	VARIABLE trans12_Temp_ALARM_SUM_Current; \
	VARIABLE trans12_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans12_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans12_Temp_ALARM_SUM_Disabled; \
	MENU trans12_Temp_ALARM_SUM_page; \
	COMMAND trans12_Temp_ALARM_SUM_read; \
	COLLECTION trans12_Temp_PRIMARY_VALUE; \
	VARIABLE trans12_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans12_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans12_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans12_Temp_PRIMARY_VALUE_page; \
	COMMAND trans12_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans12_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans12_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans12_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans12_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans12_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans12_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans12_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans12_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans12_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans12_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans12_Temp_SENSOR_MEAS_TYPE; \
	MENU trans12_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans12_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans12_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans12_Temp_INPUT_RANGE; \
	MENU trans12_Temp_INPUT_RANGE_page; \
	COMMAND trans12_Temp_INPUT_RANGE_read; \
	COMMAND trans12_Temp_INPUT_RANGE_write; \
	VARIABLE trans12_Temp_LIN_TYPE; \
	MENU trans12_Temp_LIN_TYPE_page; \
	COMMAND trans12_Temp_LIN_TYPE_read; \
	COMMAND trans12_Temp_LIN_TYPE_write; \
	VARIABLE trans12_Temp_BIAS_1; \
	MENU trans12_Temp_BIAS_1_page; \
	COMMAND trans12_Temp_BIAS_1_read; \
	COMMAND trans12_Temp_BIAS_1_write; \
	VARIABLE trans12_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans12_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans12_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans12_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans12_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans12_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans12_Temp_INPUT_FAULT_GEN; \
	MENU trans12_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans12_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans12_Temp_INPUT_FAULT_1; \
	MENU trans12_Temp_INPUT_FAULT_1_page; \
	COMMAND trans12_Temp_INPUT_FAULT_1_read; \
	UNIT trans12_Temp_Unit_1; \
	VARIABLE trans12_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans12_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans12_Temp_Display; \
	CHART trans12_Temp_Display_BarVal_pv; \
	SOURCE trans12_Temp_Display_BarVal_pv_source; \
	MENU trans12_Temp_Display_primary; \
	MENU trans12_Temp_Display_secondary; \
	MENU trans12_Temp_Tab_s; \
	MENU trans12_Temp_Tab_s_measrange; \
	MENU trans12_Temp_Tab_m

#define USE_TRANS12_TEMP_MANDATORY_A \
	USE_TRANS12_TEMP_MANDATORY_BOTH; \
	MENU trans12_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS12_TEMP_MANDATORY_B \
	USE_TRANS12_TEMP_MANDATORY_BOTH; \
	COLLECTION trans12_Temp_VIEW_1; \
	MENU trans12_Temp_VIEW_1_page; \
	MENU trans12_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS12_TEMP_OPTIONAL_BOTH \
	COLLECTION trans12_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans12_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans12_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans12_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans12_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans12_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans12_Temp_BIAS_2; \
	MENU trans12_Temp_BIAS_2_page; \
	COMMAND trans12_Temp_BIAS_2_read; \
	COMMAND trans12_Temp_BIAS_2_write; \
	VARIABLE trans12_Temp_INPUT_FAULT_2; \
	MENU trans12_Temp_INPUT_FAULT_2_page; \
	COMMAND trans12_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans12_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans12_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans12_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans12_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans12_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans12_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans12_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans12_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans12_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans12_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans12_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans12_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans12_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans12_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans12_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans12_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans12_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans12_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans12_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans12_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans12_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans12_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans12_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans12_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans12_Temp_TAB_ENTRY; \
	MENU trans12_Temp_TAB_ENTRY_page; \
	COMMAND trans12_Temp_TAB_ENTRY_read; \
	COMMAND trans12_Temp_TAB_ENTRY_write; \
	COLLECTION trans12_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans12_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans12_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans12_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans12_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans12_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans12_Temp_TAB_MIN_NUMBER; \
	MENU trans12_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans12_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans12_Temp_TAB_MAX_NUMBER; \
	MENU trans12_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans12_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans12_Temp_TAB_OP_CODE; \
	MENU trans12_Temp_TAB_OP_CODE_page; \
	COMMAND trans12_Temp_TAB_OP_CODE_read; \
	COMMAND trans12_Temp_TAB_OP_CODE_write; \
	VARIABLE trans12_Temp_TAB_STATUS; \
	MENU trans12_Temp_TAB_STATUS_page; \
	COMMAND trans12_Temp_TAB_STATUS_read; \
	VARIABLE trans12_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans12_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans12_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans12_Temp_Unit_2

#define USE_TRANS12_TEMP_OPTIONAL_A \
	USE_TRANS12_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans12_Temp_VIEW_1; \
	MENU trans12_Temp_VIEW_1_page; \
	MENU trans12_Temp_Simple_Dialog_Optional_A

#define USE_TRANS12_TEMP_OPTIONAL_B \
	USE_TRANS12_TEMP_OPTIONAL_BOTH; \
	MENU trans12_Temp_Simple_Dialog_Optional_B

#define USE_TRANS12_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans12_Temp_RJ_TYPE; \
	MENU trans12_Temp_RJ_TYPE_page; \
	COMMAND trans12_Temp_RJ_TYPE_read; \
	COMMAND trans12_Temp_RJ_TYPE_write; \
	MENU trans12_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS12_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans12_Temp_SENSOR_CONNECTION; \
	MENU trans12_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans12_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans12_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans12_Temp_COMP_WIRE1; \
	MENU trans12_Temp_COMP_WIRE1_page; \
	COMMAND trans12_Temp_COMP_WIRE1_read; \
	COMMAND trans12_Temp_COMP_WIRE1_write; \
	MENU trans12_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS12_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans12_Temp_EMISSIVITY; \
	MENU trans12_Temp_EMISSIVITY_page; \
	COMMAND trans12_Temp_EMISSIVITY_read; \
	COMMAND trans12_Temp_EMISSIVITY_write; \
	VARIABLE trans12_Temp_PEAK_TRACK; \
	MENU trans12_Temp_PEAK_TRACK_page; \
	COMMAND trans12_Temp_PEAK_TRACK_read; \
	COMMAND trans12_Temp_PEAK_TRACK_write; \
	VARIABLE trans12_Temp_DECAY_RATE; \
	MENU trans12_Temp_DECAY_RATE_page; \
	COMMAND trans12_Temp_DECAY_RATE_read; \
	COMMAND trans12_Temp_DECAY_RATE_write; \
	VARIABLE trans12_Temp_PEAK_TIME; \
	MENU trans12_Temp_PEAK_TIME_page; \
	COMMAND trans12_Temp_PEAK_TIME_read; \
	COMMAND trans12_Temp_PEAK_TIME_write; \
	VARIABLE trans12_Temp_TRACK_HOLD; \
	MENU trans12_Temp_TRACK_HOLD_page; \
	COMMAND trans12_Temp_TRACK_HOLD_read; \
	COMMAND trans12_Temp_TRACK_HOLD_write; \
	VARIABLE trans12_Temp_SPECT_FILT_SET; \
	MENU trans12_Temp_SPECT_FILT_SET_page; \
	COMMAND trans12_Temp_SPECT_FILT_SET_read; \
	COMMAND trans12_Temp_SPECT_FILT_SET_write; \
	MENU trans12_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS12_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans12_Temp_RJ_TYPE; \
	MENU trans12_Temp_RJ_TYPE_page; \
	COMMAND trans12_Temp_RJ_TYPE_read; \
	COMMAND trans12_Temp_RJ_TYPE_write; \
	MENU trans12_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS12_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans12_Temp_SENSOR_CONNECTION; \
	MENU trans12_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans12_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans12_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans12_Temp_COMP_WIRE1; \
	MENU trans12_Temp_COMP_WIRE1_page; \
	COMMAND trans12_Temp_COMP_WIRE1_read; \
	COMMAND trans12_Temp_COMP_WIRE1_write; \
	MENU trans12_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS12_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans12_Temp_EMISSIVITY; \
	MENU trans12_Temp_EMISSIVITY_page; \
	COMMAND trans12_Temp_EMISSIVITY_read; \
	COMMAND trans12_Temp_EMISSIVITY_write; \
	VARIABLE trans12_Temp_PEAK_TRACK; \
	MENU trans12_Temp_PEAK_TRACK_page; \
	COMMAND trans12_Temp_PEAK_TRACK_read; \
	COMMAND trans12_Temp_PEAK_TRACK_write; \
	VARIABLE trans12_Temp_DECAY_RATE; \
	MENU trans12_Temp_DECAY_RATE_page; \
	COMMAND trans12_Temp_DECAY_RATE_read; \
	COMMAND trans12_Temp_DECAY_RATE_write; \
	VARIABLE trans12_Temp_PEAK_TIME; \
	MENU trans12_Temp_PEAK_TIME_page; \
	COMMAND trans12_Temp_PEAK_TIME_read; \
	COMMAND trans12_Temp_PEAK_TIME_write; \
	VARIABLE trans12_Temp_TRACK_HOLD; \
	MENU trans12_Temp_TRACK_HOLD_page; \
	COMMAND trans12_Temp_TRACK_HOLD_read; \
	COMMAND trans12_Temp_TRACK_HOLD_write; \
	VARIABLE trans12_Temp_SPECT_FILT_SET; \
	MENU trans12_Temp_SPECT_FILT_SET_page; \
	COMMAND trans12_Temp_SPECT_FILT_SET_read; \
	COMMAND trans12_Temp_SPECT_FILT_SET_write; \
	MENU trans12_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS12_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans12_Temp_RJ_TEMP; \
	MENU trans12_Temp_RJ_TEMP_page; \
	COMMAND trans12_Temp_RJ_TEMP_read; \
	VARIABLE trans12_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans12_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans12_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans12_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans12_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans12_Temp_Unit_3

#define USE_TRANS12_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans12_Temp_COMP_WIRE2; \
	MENU trans12_Temp_COMP_WIRE2_page; \
	COMMAND trans12_Temp_COMP_WIRE2_read; \
	COMMAND trans12_Temp_COMP_WIRE2_write; \
	MENU trans12_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS12_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans12_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS12_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans12_Temp_RJ_TEMP; \
	MENU trans12_Temp_RJ_TEMP_page; \
	COMMAND trans12_Temp_RJ_TEMP_read; \
	VARIABLE trans12_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans12_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans12_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans12_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans12_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans12_Temp_Unit_3

#define USE_TRANS12_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans12_Temp_COMP_WIRE2; \
	MENU trans12_Temp_COMP_WIRE2_page; \
	COMMAND trans12_Temp_COMP_WIRE2_read; \
	COMMAND trans12_Temp_COMP_WIRE2_write; \
	MENU trans12_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS12_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans12_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS12_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans12_Temp_)
#define USE_TRANS12_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans12_Temp_)
#define USE_TRANS12_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans12_Temp_)
#define USE_TRANS12_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans12_Temp_)
#define USE_TRANS12_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans12_Temp_)
#define USE_TRANS12_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans12_Temp_)
#define USE_TRANS12_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans12_Temp_)
#define USE_TRANS12_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans12_Temp_)
#define USE_TRANS12_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans12_Temp_)
#define USE_TRANS12_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans12_Temp_)
#define USE_TRANS12_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans12_Temp_)
#define USE_TRANS12_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans12_Temp_)
#define USE_TRANS12_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans12_Temp_)
#define USE_TRANS12_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans12_Temp_)
#define USE_TRANS12_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans12_Temp_)
#define USE_TRANS12_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans12_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS13_TEMP_MANDATORY_BOTH \
	BLOCK trans13_Temp_block; \
	COLLECTION trans13_Temp_BLOCK_OBJECT; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans13_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans13_Temp_BLOCK_OBJECT_page; \
	COMMAND trans13_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans13_Temp_ST_REV; \
	MENU trans13_Temp_ST_REV_page; \
	COMMAND trans13_Temp_ST_REV_read; \
	VARIABLE trans13_Temp_TAG_DESC; \
	MENU trans13_Temp_TAG_DESC_page; \
	COMMAND trans13_Temp_TAG_DESC_read; \
	COMMAND trans13_Temp_TAG_DESC_write; \
	VARIABLE trans13_Temp_STRATEGY; \
	MENU trans13_Temp_STRATEGY_page; \
	COMMAND trans13_Temp_STRATEGY_read; \
	COMMAND trans13_Temp_STRATEGY_write; \
	VARIABLE trans13_Temp_ALERT_KEY; \
	MENU trans13_Temp_ALERT_KEY_page; \
	COMMAND trans13_Temp_ALERT_KEY_read; \
	COMMAND trans13_Temp_ALERT_KEY_write; \
	VARIABLE trans13_Temp_TARGET_MODE; \
	MENU trans13_Temp_TARGET_MODE_page; \
	COMMAND trans13_Temp_TARGET_MODE_read; \
	COMMAND trans13_Temp_TARGET_MODE_write; \
	COLLECTION trans13_Temp_MODE_BLK; \
	VARIABLE trans13_Temp_MODE_BLK_Actual; \
	VARIABLE trans13_Temp_MODE_BLK_Permitted; \
	VARIABLE trans13_Temp_MODE_BLK_Normal; \
	MENU trans13_Temp_MODE_BLK_page; \
	COMMAND trans13_Temp_MODE_BLK_read; \
	COLLECTION trans13_Temp_ALARM_SUM; \
	VARIABLE trans13_Temp_ALARM_SUM_Current; \
	VARIABLE trans13_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans13_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans13_Temp_ALARM_SUM_Disabled; \
	MENU trans13_Temp_ALARM_SUM_page; \
	COMMAND trans13_Temp_ALARM_SUM_read; \
	COLLECTION trans13_Temp_PRIMARY_VALUE; \
	VARIABLE trans13_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans13_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans13_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans13_Temp_PRIMARY_VALUE_page; \
	COMMAND trans13_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans13_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans13_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans13_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans13_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans13_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans13_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans13_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans13_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans13_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans13_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans13_Temp_SENSOR_MEAS_TYPE; \
	MENU trans13_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans13_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans13_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans13_Temp_INPUT_RANGE; \
	MENU trans13_Temp_INPUT_RANGE_page; \
	COMMAND trans13_Temp_INPUT_RANGE_read; \
	COMMAND trans13_Temp_INPUT_RANGE_write; \
	VARIABLE trans13_Temp_LIN_TYPE; \
	MENU trans13_Temp_LIN_TYPE_page; \
	COMMAND trans13_Temp_LIN_TYPE_read; \
	COMMAND trans13_Temp_LIN_TYPE_write; \
	VARIABLE trans13_Temp_BIAS_1; \
	MENU trans13_Temp_BIAS_1_page; \
	COMMAND trans13_Temp_BIAS_1_read; \
	COMMAND trans13_Temp_BIAS_1_write; \
	VARIABLE trans13_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans13_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans13_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans13_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans13_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans13_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans13_Temp_INPUT_FAULT_GEN; \
	MENU trans13_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans13_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans13_Temp_INPUT_FAULT_1; \
	MENU trans13_Temp_INPUT_FAULT_1_page; \
	COMMAND trans13_Temp_INPUT_FAULT_1_read; \
	UNIT trans13_Temp_Unit_1; \
	VARIABLE trans13_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans13_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans13_Temp_Display; \
	CHART trans13_Temp_Display_BarVal_pv; \
	SOURCE trans13_Temp_Display_BarVal_pv_source; \
	MENU trans13_Temp_Display_primary; \
	MENU trans13_Temp_Display_secondary; \
	MENU trans13_Temp_Tab_s; \
	MENU trans13_Temp_Tab_s_measrange; \
	MENU trans13_Temp_Tab_m

#define USE_TRANS13_TEMP_MANDATORY_A \
	USE_TRANS13_TEMP_MANDATORY_BOTH; \
	MENU trans13_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS13_TEMP_MANDATORY_B \
	USE_TRANS13_TEMP_MANDATORY_BOTH; \
	COLLECTION trans13_Temp_VIEW_1; \
	MENU trans13_Temp_VIEW_1_page; \
	MENU trans13_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS13_TEMP_OPTIONAL_BOTH \
	COLLECTION trans13_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans13_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans13_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans13_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans13_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans13_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans13_Temp_BIAS_2; \
	MENU trans13_Temp_BIAS_2_page; \
	COMMAND trans13_Temp_BIAS_2_read; \
	COMMAND trans13_Temp_BIAS_2_write; \
	VARIABLE trans13_Temp_INPUT_FAULT_2; \
	MENU trans13_Temp_INPUT_FAULT_2_page; \
	COMMAND trans13_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans13_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans13_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans13_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans13_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans13_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans13_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans13_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans13_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans13_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans13_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans13_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans13_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans13_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans13_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans13_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans13_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans13_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans13_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans13_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans13_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans13_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans13_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans13_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans13_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans13_Temp_TAB_ENTRY; \
	MENU trans13_Temp_TAB_ENTRY_page; \
	COMMAND trans13_Temp_TAB_ENTRY_read; \
	COMMAND trans13_Temp_TAB_ENTRY_write; \
	COLLECTION trans13_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans13_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans13_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans13_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans13_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans13_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans13_Temp_TAB_MIN_NUMBER; \
	MENU trans13_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans13_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans13_Temp_TAB_MAX_NUMBER; \
	MENU trans13_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans13_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans13_Temp_TAB_OP_CODE; \
	MENU trans13_Temp_TAB_OP_CODE_page; \
	COMMAND trans13_Temp_TAB_OP_CODE_read; \
	COMMAND trans13_Temp_TAB_OP_CODE_write; \
	VARIABLE trans13_Temp_TAB_STATUS; \
	MENU trans13_Temp_TAB_STATUS_page; \
	COMMAND trans13_Temp_TAB_STATUS_read; \
	VARIABLE trans13_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans13_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans13_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans13_Temp_Unit_2

#define USE_TRANS13_TEMP_OPTIONAL_A \
	USE_TRANS13_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans13_Temp_VIEW_1; \
	MENU trans13_Temp_VIEW_1_page; \
	MENU trans13_Temp_Simple_Dialog_Optional_A

#define USE_TRANS13_TEMP_OPTIONAL_B \
	USE_TRANS13_TEMP_OPTIONAL_BOTH; \
	MENU trans13_Temp_Simple_Dialog_Optional_B

#define USE_TRANS13_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans13_Temp_RJ_TYPE; \
	MENU trans13_Temp_RJ_TYPE_page; \
	COMMAND trans13_Temp_RJ_TYPE_read; \
	COMMAND trans13_Temp_RJ_TYPE_write; \
	MENU trans13_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS13_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans13_Temp_SENSOR_CONNECTION; \
	MENU trans13_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans13_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans13_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans13_Temp_COMP_WIRE1; \
	MENU trans13_Temp_COMP_WIRE1_page; \
	COMMAND trans13_Temp_COMP_WIRE1_read; \
	COMMAND trans13_Temp_COMP_WIRE1_write; \
	MENU trans13_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS13_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans13_Temp_EMISSIVITY; \
	MENU trans13_Temp_EMISSIVITY_page; \
	COMMAND trans13_Temp_EMISSIVITY_read; \
	COMMAND trans13_Temp_EMISSIVITY_write; \
	VARIABLE trans13_Temp_PEAK_TRACK; \
	MENU trans13_Temp_PEAK_TRACK_page; \
	COMMAND trans13_Temp_PEAK_TRACK_read; \
	COMMAND trans13_Temp_PEAK_TRACK_write; \
	VARIABLE trans13_Temp_DECAY_RATE; \
	MENU trans13_Temp_DECAY_RATE_page; \
	COMMAND trans13_Temp_DECAY_RATE_read; \
	COMMAND trans13_Temp_DECAY_RATE_write; \
	VARIABLE trans13_Temp_PEAK_TIME; \
	MENU trans13_Temp_PEAK_TIME_page; \
	COMMAND trans13_Temp_PEAK_TIME_read; \
	COMMAND trans13_Temp_PEAK_TIME_write; \
	VARIABLE trans13_Temp_TRACK_HOLD; \
	MENU trans13_Temp_TRACK_HOLD_page; \
	COMMAND trans13_Temp_TRACK_HOLD_read; \
	COMMAND trans13_Temp_TRACK_HOLD_write; \
	VARIABLE trans13_Temp_SPECT_FILT_SET; \
	MENU trans13_Temp_SPECT_FILT_SET_page; \
	COMMAND trans13_Temp_SPECT_FILT_SET_read; \
	COMMAND trans13_Temp_SPECT_FILT_SET_write; \
	MENU trans13_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS13_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans13_Temp_RJ_TYPE; \
	MENU trans13_Temp_RJ_TYPE_page; \
	COMMAND trans13_Temp_RJ_TYPE_read; \
	COMMAND trans13_Temp_RJ_TYPE_write; \
	MENU trans13_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS13_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans13_Temp_SENSOR_CONNECTION; \
	MENU trans13_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans13_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans13_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans13_Temp_COMP_WIRE1; \
	MENU trans13_Temp_COMP_WIRE1_page; \
	COMMAND trans13_Temp_COMP_WIRE1_read; \
	COMMAND trans13_Temp_COMP_WIRE1_write; \
	MENU trans13_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS13_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans13_Temp_EMISSIVITY; \
	MENU trans13_Temp_EMISSIVITY_page; \
	COMMAND trans13_Temp_EMISSIVITY_read; \
	COMMAND trans13_Temp_EMISSIVITY_write; \
	VARIABLE trans13_Temp_PEAK_TRACK; \
	MENU trans13_Temp_PEAK_TRACK_page; \
	COMMAND trans13_Temp_PEAK_TRACK_read; \
	COMMAND trans13_Temp_PEAK_TRACK_write; \
	VARIABLE trans13_Temp_DECAY_RATE; \
	MENU trans13_Temp_DECAY_RATE_page; \
	COMMAND trans13_Temp_DECAY_RATE_read; \
	COMMAND trans13_Temp_DECAY_RATE_write; \
	VARIABLE trans13_Temp_PEAK_TIME; \
	MENU trans13_Temp_PEAK_TIME_page; \
	COMMAND trans13_Temp_PEAK_TIME_read; \
	COMMAND trans13_Temp_PEAK_TIME_write; \
	VARIABLE trans13_Temp_TRACK_HOLD; \
	MENU trans13_Temp_TRACK_HOLD_page; \
	COMMAND trans13_Temp_TRACK_HOLD_read; \
	COMMAND trans13_Temp_TRACK_HOLD_write; \
	VARIABLE trans13_Temp_SPECT_FILT_SET; \
	MENU trans13_Temp_SPECT_FILT_SET_page; \
	COMMAND trans13_Temp_SPECT_FILT_SET_read; \
	COMMAND trans13_Temp_SPECT_FILT_SET_write; \
	MENU trans13_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS13_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans13_Temp_RJ_TEMP; \
	MENU trans13_Temp_RJ_TEMP_page; \
	COMMAND trans13_Temp_RJ_TEMP_read; \
	VARIABLE trans13_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans13_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans13_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans13_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans13_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans13_Temp_Unit_3

#define USE_TRANS13_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans13_Temp_COMP_WIRE2; \
	MENU trans13_Temp_COMP_WIRE2_page; \
	COMMAND trans13_Temp_COMP_WIRE2_read; \
	COMMAND trans13_Temp_COMP_WIRE2_write; \
	MENU trans13_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS13_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans13_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS13_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans13_Temp_RJ_TEMP; \
	MENU trans13_Temp_RJ_TEMP_page; \
	COMMAND trans13_Temp_RJ_TEMP_read; \
	VARIABLE trans13_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans13_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans13_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans13_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans13_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans13_Temp_Unit_3

#define USE_TRANS13_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans13_Temp_COMP_WIRE2; \
	MENU trans13_Temp_COMP_WIRE2_page; \
	COMMAND trans13_Temp_COMP_WIRE2_read; \
	COMMAND trans13_Temp_COMP_WIRE2_write; \
	MENU trans13_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS13_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans13_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS13_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans13_Temp_)
#define USE_TRANS13_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans13_Temp_)
#define USE_TRANS13_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans13_Temp_)
#define USE_TRANS13_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans13_Temp_)
#define USE_TRANS13_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans13_Temp_)
#define USE_TRANS13_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans13_Temp_)
#define USE_TRANS13_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans13_Temp_)
#define USE_TRANS13_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans13_Temp_)
#define USE_TRANS13_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans13_Temp_)
#define USE_TRANS13_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans13_Temp_)
#define USE_TRANS13_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans13_Temp_)
#define USE_TRANS13_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans13_Temp_)
#define USE_TRANS13_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans13_Temp_)
#define USE_TRANS13_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans13_Temp_)
#define USE_TRANS13_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans13_Temp_)
#define USE_TRANS13_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans13_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS14_TEMP_MANDATORY_BOTH \
	BLOCK trans14_Temp_block; \
	COLLECTION trans14_Temp_BLOCK_OBJECT; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans14_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans14_Temp_BLOCK_OBJECT_page; \
	COMMAND trans14_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans14_Temp_ST_REV; \
	MENU trans14_Temp_ST_REV_page; \
	COMMAND trans14_Temp_ST_REV_read; \
	VARIABLE trans14_Temp_TAG_DESC; \
	MENU trans14_Temp_TAG_DESC_page; \
	COMMAND trans14_Temp_TAG_DESC_read; \
	COMMAND trans14_Temp_TAG_DESC_write; \
	VARIABLE trans14_Temp_STRATEGY; \
	MENU trans14_Temp_STRATEGY_page; \
	COMMAND trans14_Temp_STRATEGY_read; \
	COMMAND trans14_Temp_STRATEGY_write; \
	VARIABLE trans14_Temp_ALERT_KEY; \
	MENU trans14_Temp_ALERT_KEY_page; \
	COMMAND trans14_Temp_ALERT_KEY_read; \
	COMMAND trans14_Temp_ALERT_KEY_write; \
	VARIABLE trans14_Temp_TARGET_MODE; \
	MENU trans14_Temp_TARGET_MODE_page; \
	COMMAND trans14_Temp_TARGET_MODE_read; \
	COMMAND trans14_Temp_TARGET_MODE_write; \
	COLLECTION trans14_Temp_MODE_BLK; \
	VARIABLE trans14_Temp_MODE_BLK_Actual; \
	VARIABLE trans14_Temp_MODE_BLK_Permitted; \
	VARIABLE trans14_Temp_MODE_BLK_Normal; \
	MENU trans14_Temp_MODE_BLK_page; \
	COMMAND trans14_Temp_MODE_BLK_read; \
	COLLECTION trans14_Temp_ALARM_SUM; \
	VARIABLE trans14_Temp_ALARM_SUM_Current; \
	VARIABLE trans14_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans14_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans14_Temp_ALARM_SUM_Disabled; \
	MENU trans14_Temp_ALARM_SUM_page; \
	COMMAND trans14_Temp_ALARM_SUM_read; \
	COLLECTION trans14_Temp_PRIMARY_VALUE; \
	VARIABLE trans14_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans14_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans14_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans14_Temp_PRIMARY_VALUE_page; \
	COMMAND trans14_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans14_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans14_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans14_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans14_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans14_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans14_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans14_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans14_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans14_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans14_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans14_Temp_SENSOR_MEAS_TYPE; \
	MENU trans14_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans14_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans14_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans14_Temp_INPUT_RANGE; \
	MENU trans14_Temp_INPUT_RANGE_page; \
	COMMAND trans14_Temp_INPUT_RANGE_read; \
	COMMAND trans14_Temp_INPUT_RANGE_write; \
	VARIABLE trans14_Temp_LIN_TYPE; \
	MENU trans14_Temp_LIN_TYPE_page; \
	COMMAND trans14_Temp_LIN_TYPE_read; \
	COMMAND trans14_Temp_LIN_TYPE_write; \
	VARIABLE trans14_Temp_BIAS_1; \
	MENU trans14_Temp_BIAS_1_page; \
	COMMAND trans14_Temp_BIAS_1_read; \
	COMMAND trans14_Temp_BIAS_1_write; \
	VARIABLE trans14_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans14_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans14_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans14_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans14_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans14_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans14_Temp_INPUT_FAULT_GEN; \
	MENU trans14_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans14_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans14_Temp_INPUT_FAULT_1; \
	MENU trans14_Temp_INPUT_FAULT_1_page; \
	COMMAND trans14_Temp_INPUT_FAULT_1_read; \
	UNIT trans14_Temp_Unit_1; \
	VARIABLE trans14_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans14_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans14_Temp_Display; \
	CHART trans14_Temp_Display_BarVal_pv; \
	SOURCE trans14_Temp_Display_BarVal_pv_source; \
	MENU trans14_Temp_Display_primary; \
	MENU trans14_Temp_Display_secondary; \
	MENU trans14_Temp_Tab_s; \
	MENU trans14_Temp_Tab_s_measrange; \
	MENU trans14_Temp_Tab_m

#define USE_TRANS14_TEMP_MANDATORY_A \
	USE_TRANS14_TEMP_MANDATORY_BOTH; \
	MENU trans14_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS14_TEMP_MANDATORY_B \
	USE_TRANS14_TEMP_MANDATORY_BOTH; \
	COLLECTION trans14_Temp_VIEW_1; \
	MENU trans14_Temp_VIEW_1_page; \
	MENU trans14_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS14_TEMP_OPTIONAL_BOTH \
	COLLECTION trans14_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans14_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans14_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans14_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans14_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans14_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans14_Temp_BIAS_2; \
	MENU trans14_Temp_BIAS_2_page; \
	COMMAND trans14_Temp_BIAS_2_read; \
	COMMAND trans14_Temp_BIAS_2_write; \
	VARIABLE trans14_Temp_INPUT_FAULT_2; \
	MENU trans14_Temp_INPUT_FAULT_2_page; \
	COMMAND trans14_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans14_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans14_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans14_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans14_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans14_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans14_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans14_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans14_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans14_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans14_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans14_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans14_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans14_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans14_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans14_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans14_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans14_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans14_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans14_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans14_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans14_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans14_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans14_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans14_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans14_Temp_TAB_ENTRY; \
	MENU trans14_Temp_TAB_ENTRY_page; \
	COMMAND trans14_Temp_TAB_ENTRY_read; \
	COMMAND trans14_Temp_TAB_ENTRY_write; \
	COLLECTION trans14_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans14_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans14_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans14_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans14_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans14_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans14_Temp_TAB_MIN_NUMBER; \
	MENU trans14_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans14_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans14_Temp_TAB_MAX_NUMBER; \
	MENU trans14_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans14_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans14_Temp_TAB_OP_CODE; \
	MENU trans14_Temp_TAB_OP_CODE_page; \
	COMMAND trans14_Temp_TAB_OP_CODE_read; \
	COMMAND trans14_Temp_TAB_OP_CODE_write; \
	VARIABLE trans14_Temp_TAB_STATUS; \
	MENU trans14_Temp_TAB_STATUS_page; \
	COMMAND trans14_Temp_TAB_STATUS_read; \
	VARIABLE trans14_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans14_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans14_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans14_Temp_Unit_2

#define USE_TRANS14_TEMP_OPTIONAL_A \
	USE_TRANS14_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans14_Temp_VIEW_1; \
	MENU trans14_Temp_VIEW_1_page; \
	MENU trans14_Temp_Simple_Dialog_Optional_A

#define USE_TRANS14_TEMP_OPTIONAL_B \
	USE_TRANS14_TEMP_OPTIONAL_BOTH; \
	MENU trans14_Temp_Simple_Dialog_Optional_B

#define USE_TRANS14_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans14_Temp_RJ_TYPE; \
	MENU trans14_Temp_RJ_TYPE_page; \
	COMMAND trans14_Temp_RJ_TYPE_read; \
	COMMAND trans14_Temp_RJ_TYPE_write; \
	MENU trans14_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS14_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans14_Temp_SENSOR_CONNECTION; \
	MENU trans14_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans14_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans14_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans14_Temp_COMP_WIRE1; \
	MENU trans14_Temp_COMP_WIRE1_page; \
	COMMAND trans14_Temp_COMP_WIRE1_read; \
	COMMAND trans14_Temp_COMP_WIRE1_write; \
	MENU trans14_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS14_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans14_Temp_EMISSIVITY; \
	MENU trans14_Temp_EMISSIVITY_page; \
	COMMAND trans14_Temp_EMISSIVITY_read; \
	COMMAND trans14_Temp_EMISSIVITY_write; \
	VARIABLE trans14_Temp_PEAK_TRACK; \
	MENU trans14_Temp_PEAK_TRACK_page; \
	COMMAND trans14_Temp_PEAK_TRACK_read; \
	COMMAND trans14_Temp_PEAK_TRACK_write; \
	VARIABLE trans14_Temp_DECAY_RATE; \
	MENU trans14_Temp_DECAY_RATE_page; \
	COMMAND trans14_Temp_DECAY_RATE_read; \
	COMMAND trans14_Temp_DECAY_RATE_write; \
	VARIABLE trans14_Temp_PEAK_TIME; \
	MENU trans14_Temp_PEAK_TIME_page; \
	COMMAND trans14_Temp_PEAK_TIME_read; \
	COMMAND trans14_Temp_PEAK_TIME_write; \
	VARIABLE trans14_Temp_TRACK_HOLD; \
	MENU trans14_Temp_TRACK_HOLD_page; \
	COMMAND trans14_Temp_TRACK_HOLD_read; \
	COMMAND trans14_Temp_TRACK_HOLD_write; \
	VARIABLE trans14_Temp_SPECT_FILT_SET; \
	MENU trans14_Temp_SPECT_FILT_SET_page; \
	COMMAND trans14_Temp_SPECT_FILT_SET_read; \
	COMMAND trans14_Temp_SPECT_FILT_SET_write; \
	MENU trans14_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS14_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans14_Temp_RJ_TYPE; \
	MENU trans14_Temp_RJ_TYPE_page; \
	COMMAND trans14_Temp_RJ_TYPE_read; \
	COMMAND trans14_Temp_RJ_TYPE_write; \
	MENU trans14_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS14_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans14_Temp_SENSOR_CONNECTION; \
	MENU trans14_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans14_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans14_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans14_Temp_COMP_WIRE1; \
	MENU trans14_Temp_COMP_WIRE1_page; \
	COMMAND trans14_Temp_COMP_WIRE1_read; \
	COMMAND trans14_Temp_COMP_WIRE1_write; \
	MENU trans14_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS14_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans14_Temp_EMISSIVITY; \
	MENU trans14_Temp_EMISSIVITY_page; \
	COMMAND trans14_Temp_EMISSIVITY_read; \
	COMMAND trans14_Temp_EMISSIVITY_write; \
	VARIABLE trans14_Temp_PEAK_TRACK; \
	MENU trans14_Temp_PEAK_TRACK_page; \
	COMMAND trans14_Temp_PEAK_TRACK_read; \
	COMMAND trans14_Temp_PEAK_TRACK_write; \
	VARIABLE trans14_Temp_DECAY_RATE; \
	MENU trans14_Temp_DECAY_RATE_page; \
	COMMAND trans14_Temp_DECAY_RATE_read; \
	COMMAND trans14_Temp_DECAY_RATE_write; \
	VARIABLE trans14_Temp_PEAK_TIME; \
	MENU trans14_Temp_PEAK_TIME_page; \
	COMMAND trans14_Temp_PEAK_TIME_read; \
	COMMAND trans14_Temp_PEAK_TIME_write; \
	VARIABLE trans14_Temp_TRACK_HOLD; \
	MENU trans14_Temp_TRACK_HOLD_page; \
	COMMAND trans14_Temp_TRACK_HOLD_read; \
	COMMAND trans14_Temp_TRACK_HOLD_write; \
	VARIABLE trans14_Temp_SPECT_FILT_SET; \
	MENU trans14_Temp_SPECT_FILT_SET_page; \
	COMMAND trans14_Temp_SPECT_FILT_SET_read; \
	COMMAND trans14_Temp_SPECT_FILT_SET_write; \
	MENU trans14_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS14_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans14_Temp_RJ_TEMP; \
	MENU trans14_Temp_RJ_TEMP_page; \
	COMMAND trans14_Temp_RJ_TEMP_read; \
	VARIABLE trans14_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans14_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans14_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans14_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans14_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans14_Temp_Unit_3

#define USE_TRANS14_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans14_Temp_COMP_WIRE2; \
	MENU trans14_Temp_COMP_WIRE2_page; \
	COMMAND trans14_Temp_COMP_WIRE2_read; \
	COMMAND trans14_Temp_COMP_WIRE2_write; \
	MENU trans14_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS14_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans14_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS14_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans14_Temp_RJ_TEMP; \
	MENU trans14_Temp_RJ_TEMP_page; \
	COMMAND trans14_Temp_RJ_TEMP_read; \
	VARIABLE trans14_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans14_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans14_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans14_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans14_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans14_Temp_Unit_3

#define USE_TRANS14_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans14_Temp_COMP_WIRE2; \
	MENU trans14_Temp_COMP_WIRE2_page; \
	COMMAND trans14_Temp_COMP_WIRE2_read; \
	COMMAND trans14_Temp_COMP_WIRE2_write; \
	MENU trans14_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS14_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans14_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS14_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans14_Temp_)
#define USE_TRANS14_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans14_Temp_)
#define USE_TRANS14_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans14_Temp_)
#define USE_TRANS14_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans14_Temp_)
#define USE_TRANS14_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans14_Temp_)
#define USE_TRANS14_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans14_Temp_)
#define USE_TRANS14_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans14_Temp_)
#define USE_TRANS14_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans14_Temp_)
#define USE_TRANS14_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans14_Temp_)
#define USE_TRANS14_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans14_Temp_)
#define USE_TRANS14_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans14_Temp_)
#define USE_TRANS14_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans14_Temp_)
#define USE_TRANS14_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans14_Temp_)
#define USE_TRANS14_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans14_Temp_)
#define USE_TRANS14_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans14_Temp_)
#define USE_TRANS14_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans14_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS15_TEMP_MANDATORY_BOTH \
	BLOCK trans15_Temp_block; \
	COLLECTION trans15_Temp_BLOCK_OBJECT; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Reserved; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Class; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Profile; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans15_Temp_BLOCK_OBJECT_Number_of_Views; \
	MENU trans15_Temp_BLOCK_OBJECT_page; \
	COMMAND trans15_Temp_BLOCK_OBJECT_read; \
	VARIABLE trans15_Temp_ST_REV; \
	MENU trans15_Temp_ST_REV_page; \
	COMMAND trans15_Temp_ST_REV_read; \
	VARIABLE trans15_Temp_TAG_DESC; \
	MENU trans15_Temp_TAG_DESC_page; \
	COMMAND trans15_Temp_TAG_DESC_read; \
	COMMAND trans15_Temp_TAG_DESC_write; \
	VARIABLE trans15_Temp_STRATEGY; \
	MENU trans15_Temp_STRATEGY_page; \
	COMMAND trans15_Temp_STRATEGY_read; \
	COMMAND trans15_Temp_STRATEGY_write; \
	VARIABLE trans15_Temp_ALERT_KEY; \
	MENU trans15_Temp_ALERT_KEY_page; \
	COMMAND trans15_Temp_ALERT_KEY_read; \
	COMMAND trans15_Temp_ALERT_KEY_write; \
	VARIABLE trans15_Temp_TARGET_MODE; \
	MENU trans15_Temp_TARGET_MODE_page; \
	COMMAND trans15_Temp_TARGET_MODE_read; \
	COMMAND trans15_Temp_TARGET_MODE_write; \
	COLLECTION trans15_Temp_MODE_BLK; \
	VARIABLE trans15_Temp_MODE_BLK_Actual; \
	VARIABLE trans15_Temp_MODE_BLK_Permitted; \
	VARIABLE trans15_Temp_MODE_BLK_Normal; \
	MENU trans15_Temp_MODE_BLK_page; \
	COMMAND trans15_Temp_MODE_BLK_read; \
	COLLECTION trans15_Temp_ALARM_SUM; \
	VARIABLE trans15_Temp_ALARM_SUM_Current; \
	VARIABLE trans15_Temp_ALARM_SUM_Unacknowledged; \
	VARIABLE trans15_Temp_ALARM_SUM_Unreported; \
	VARIABLE trans15_Temp_ALARM_SUM_Disabled; \
	MENU trans15_Temp_ALARM_SUM_page; \
	COMMAND trans15_Temp_ALARM_SUM_read; \
	COLLECTION trans15_Temp_PRIMARY_VALUE; \
	VARIABLE trans15_Temp_PRIMARY_VALUE_Value; \
	VARIABLE trans15_Temp_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans15_Temp_PRIMARY_VALUE_Status_Limit; \
	MENU trans15_Temp_PRIMARY_VALUE_page; \
	COMMAND trans15_Temp_PRIMARY_VALUE_read; \
	VARIABLE trans15_Temp_PRIMARY_VALUE_UNIT; \
	MENU trans15_Temp_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans15_Temp_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans15_Temp_PRIMARY_VALUE_UNIT_write; \
	COLLECTION trans15_Temp_SECONDARY_VALUE_1; \
	VARIABLE trans15_Temp_SECONDARY_VALUE_1_Value; \
	VARIABLE trans15_Temp_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans15_Temp_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans15_Temp_SECONDARY_VALUE_1_page; \
	COMMAND trans15_Temp_SECONDARY_VALUE_1_read; \
	VARIABLE trans15_Temp_SENSOR_MEAS_TYPE; \
	MENU trans15_Temp_SENSOR_MEAS_TYPE_page; \
	COMMAND trans15_Temp_SENSOR_MEAS_TYPE_read; \
	COMMAND trans15_Temp_SENSOR_MEAS_TYPE_write; \
	VARIABLE trans15_Temp_INPUT_RANGE; \
	MENU trans15_Temp_INPUT_RANGE_page; \
	COMMAND trans15_Temp_INPUT_RANGE_read; \
	COMMAND trans15_Temp_INPUT_RANGE_write; \
	VARIABLE trans15_Temp_LIN_TYPE; \
	MENU trans15_Temp_LIN_TYPE_page; \
	COMMAND trans15_Temp_LIN_TYPE_read; \
	COMMAND trans15_Temp_LIN_TYPE_write; \
	VARIABLE trans15_Temp_BIAS_1; \
	MENU trans15_Temp_BIAS_1_page; \
	COMMAND trans15_Temp_BIAS_1_read; \
	COMMAND trans15_Temp_BIAS_1_write; \
	VARIABLE trans15_Temp_UPPER_SENSOR_LIMIT; \
	MENU trans15_Temp_UPPER_SENSOR_LIMIT_page; \
	COMMAND trans15_Temp_UPPER_SENSOR_LIMIT_read; \
	VARIABLE trans15_Temp_LOWER_SENSOR_LIMIT; \
	MENU trans15_Temp_LOWER_SENSOR_LIMIT_page; \
	COMMAND trans15_Temp_LOWER_SENSOR_LIMIT_read; \
	VARIABLE trans15_Temp_INPUT_FAULT_GEN; \
	MENU trans15_Temp_INPUT_FAULT_GEN_page; \
	COMMAND trans15_Temp_INPUT_FAULT_GEN_read; \
	VARIABLE trans15_Temp_INPUT_FAULT_1; \
	MENU trans15_Temp_INPUT_FAULT_1_page; \
	COMMAND trans15_Temp_INPUT_FAULT_1_read; \
	UNIT trans15_Temp_Unit_1; \
	VARIABLE trans15_Temp_PRIMARY_VALUE_UNIT_for_RJ_TEMP; \
	METHOD trans15_Temp_PRIMARY_VALUE_UNIT_post; \
	MENU trans15_Temp_Display; \
	CHART trans15_Temp_Display_BarVal_pv; \
	SOURCE trans15_Temp_Display_BarVal_pv_source; \
	MENU trans15_Temp_Display_primary; \
	MENU trans15_Temp_Display_secondary; \
	MENU trans15_Temp_Tab_s; \
	MENU trans15_Temp_Tab_s_measrange; \
	MENU trans15_Temp_Tab_m

#define USE_TRANS15_TEMP_MANDATORY_A \
	USE_TRANS15_TEMP_MANDATORY_BOTH; \
	MENU trans15_Temp_Simple_Dialog_Mandatory_A

#define USE_TRANS15_TEMP_MANDATORY_B \
	USE_TRANS15_TEMP_MANDATORY_BOTH; \
	COLLECTION trans15_Temp_VIEW_1; \
	MENU trans15_Temp_VIEW_1_page; \
	MENU trans15_Temp_Simple_Dialog_Mandatory_B

#define USE_TRANS15_TEMP_OPTIONAL_BOTH \
	COLLECTION trans15_Temp_SECONDARY_VALUE_2; \
	VARIABLE trans15_Temp_SECONDARY_VALUE_2_Value; \
	VARIABLE trans15_Temp_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans15_Temp_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans15_Temp_SECONDARY_VALUE_2_page; \
	COMMAND trans15_Temp_SECONDARY_VALUE_2_read; \
	VARIABLE trans15_Temp_BIAS_2; \
	MENU trans15_Temp_BIAS_2_page; \
	COMMAND trans15_Temp_BIAS_2_read; \
	COMMAND trans15_Temp_BIAS_2_write; \
	VARIABLE trans15_Temp_INPUT_FAULT_2; \
	MENU trans15_Temp_INPUT_FAULT_2_page; \
	COMMAND trans15_Temp_INPUT_FAULT_2_read; \
	VARIABLE trans15_Temp_SENSOR_WIRE_CHECK_1; \
	MENU trans15_Temp_SENSOR_WIRE_CHECK_1_page; \
	COMMAND trans15_Temp_SENSOR_WIRE_CHECK_1_read; \
	COMMAND trans15_Temp_SENSOR_WIRE_CHECK_1_write; \
	VARIABLE trans15_Temp_SENSOR_WIRE_CHECK_2; \
	MENU trans15_Temp_SENSOR_WIRE_CHECK_2_page; \
	COMMAND trans15_Temp_SENSOR_WIRE_CHECK_2_read; \
	COMMAND trans15_Temp_SENSOR_WIRE_CHECK_2_write; \
	VARIABLE trans15_Temp_MAX_SENSOR_VALUE_1; \
	MENU trans15_Temp_MAX_SENSOR_VALUE_1_page; \
	COMMAND trans15_Temp_MAX_SENSOR_VALUE_1_read; \
	COMMAND trans15_Temp_MAX_SENSOR_VALUE_1_write; \
	VARIABLE trans15_Temp_MIN_SENSOR_VALUE_1; \
	MENU trans15_Temp_MIN_SENSOR_VALUE_1_page; \
	COMMAND trans15_Temp_MIN_SENSOR_VALUE_1_read; \
	COMMAND trans15_Temp_MIN_SENSOR_VALUE_1_write; \
	VARIABLE trans15_Temp_MAX_SENSOR_VALUE_2; \
	MENU trans15_Temp_MAX_SENSOR_VALUE_2_page; \
	COMMAND trans15_Temp_MAX_SENSOR_VALUE_2_read; \
	COMMAND trans15_Temp_MAX_SENSOR_VALUE_2_write; \
	VARIABLE trans15_Temp_MIN_SENSOR_VALUE_2; \
	MENU trans15_Temp_MIN_SENSOR_VALUE_2_page; \
	COMMAND trans15_Temp_MIN_SENSOR_VALUE_2_read; \
	COMMAND trans15_Temp_MIN_SENSOR_VALUE_2_write; \
	VARIABLE trans15_Temp_TAB_ENTRY; \
	MENU trans15_Temp_TAB_ENTRY_page; \
	COMMAND trans15_Temp_TAB_ENTRY_read; \
	COMMAND trans15_Temp_TAB_ENTRY_write; \
	COLLECTION trans15_Temp_TAB_X_Y_VALUE; \
	VARIABLE trans15_Temp_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans15_Temp_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans15_Temp_TAB_X_Y_VALUE_page; \
	COMMAND trans15_Temp_TAB_X_Y_VALUE_read; \
	COMMAND trans15_Temp_TAB_X_Y_VALUE_write; \
	VARIABLE trans15_Temp_TAB_MIN_NUMBER; \
	MENU trans15_Temp_TAB_MIN_NUMBER_page; \
	COMMAND trans15_Temp_TAB_MIN_NUMBER_read; \
	VARIABLE trans15_Temp_TAB_MAX_NUMBER; \
	MENU trans15_Temp_TAB_MAX_NUMBER_page; \
	COMMAND trans15_Temp_TAB_MAX_NUMBER_read; \
	VARIABLE trans15_Temp_TAB_OP_CODE; \
	MENU trans15_Temp_TAB_OP_CODE_page; \
	COMMAND trans15_Temp_TAB_OP_CODE_read; \
	COMMAND trans15_Temp_TAB_OP_CODE_write; \
	VARIABLE trans15_Temp_TAB_STATUS; \
	MENU trans15_Temp_TAB_STATUS_page; \
	COMMAND trans15_Temp_TAB_STATUS_read; \
	VARIABLE trans15_Temp_TAB_ACTUAL_NUMBER; \
	MENU trans15_Temp_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans15_Temp_TAB_ACTUAL_NUMBER_read; \
	UNIT trans15_Temp_Unit_2

#define USE_TRANS15_TEMP_OPTIONAL_A \
	USE_TRANS15_TEMP_OPTIONAL_BOTH; \
	COLLECTION trans15_Temp_VIEW_1; \
	MENU trans15_Temp_VIEW_1_page; \
	MENU trans15_Temp_Simple_Dialog_Optional_A

#define USE_TRANS15_TEMP_OPTIONAL_B \
	USE_TRANS15_TEMP_OPTIONAL_BOTH; \
	MENU trans15_Temp_Simple_Dialog_Optional_B

#define USE_TRANS15_TEMP_THERMOCOUPLE_MANDATORY_A \
	VARIABLE trans15_Temp_RJ_TYPE; \
	MENU trans15_Temp_RJ_TYPE_page; \
	COMMAND trans15_Temp_RJ_TYPE_read; \
	COMMAND trans15_Temp_RJ_TYPE_write; \
	MENU trans15_Temp_Thermocouple_Simple_Dialog_Mandatory_A

#define USE_TRANS15_TEMP_THERMORESISTANCE_MANDATORY_A \
	VARIABLE trans15_Temp_SENSOR_CONNECTION; \
	MENU trans15_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans15_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans15_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans15_Temp_COMP_WIRE1; \
	MENU trans15_Temp_COMP_WIRE1_page; \
	COMMAND trans15_Temp_COMP_WIRE1_read; \
	COMMAND trans15_Temp_COMP_WIRE1_write; \
	MENU trans15_Temp_Thermoresistance_Simple_Dialog_Mandatory_A

#define USE_TRANS15_TEMP_PYROMETER_MANDATORY_A \
	VARIABLE trans15_Temp_EMISSIVITY; \
	MENU trans15_Temp_EMISSIVITY_page; \
	COMMAND trans15_Temp_EMISSIVITY_read; \
	COMMAND trans15_Temp_EMISSIVITY_write; \
	VARIABLE trans15_Temp_PEAK_TRACK; \
	MENU trans15_Temp_PEAK_TRACK_page; \
	COMMAND trans15_Temp_PEAK_TRACK_read; \
	COMMAND trans15_Temp_PEAK_TRACK_write; \
	VARIABLE trans15_Temp_DECAY_RATE; \
	MENU trans15_Temp_DECAY_RATE_page; \
	COMMAND trans15_Temp_DECAY_RATE_read; \
	COMMAND trans15_Temp_DECAY_RATE_write; \
	VARIABLE trans15_Temp_PEAK_TIME; \
	MENU trans15_Temp_PEAK_TIME_page; \
	COMMAND trans15_Temp_PEAK_TIME_read; \
	COMMAND trans15_Temp_PEAK_TIME_write; \
	VARIABLE trans15_Temp_TRACK_HOLD; \
	MENU trans15_Temp_TRACK_HOLD_page; \
	COMMAND trans15_Temp_TRACK_HOLD_read; \
	COMMAND trans15_Temp_TRACK_HOLD_write; \
	VARIABLE trans15_Temp_SPECT_FILT_SET; \
	MENU trans15_Temp_SPECT_FILT_SET_page; \
	COMMAND trans15_Temp_SPECT_FILT_SET_read; \
	COMMAND trans15_Temp_SPECT_FILT_SET_write; \
	MENU trans15_Temp_Pyrometer_Simple_Dialog_Mandatory_A

#define USE_TRANS15_TEMP_THERMOCOUPLE_MANDATORY_B \
	VARIABLE trans15_Temp_RJ_TYPE; \
	MENU trans15_Temp_RJ_TYPE_page; \
	COMMAND trans15_Temp_RJ_TYPE_read; \
	COMMAND trans15_Temp_RJ_TYPE_write; \
	MENU trans15_Temp_Thermocouple_Simple_Dialog_Mandatory_B

#define USE_TRANS15_TEMP_THERMORESISTANCE_MANDATORY_B \
	VARIABLE trans15_Temp_SENSOR_CONNECTION; \
	MENU trans15_Temp_SENSOR_CONNECTION_page; \
	COMMAND trans15_Temp_SENSOR_CONNECTION_read; \
	COMMAND trans15_Temp_SENSOR_CONNECTION_write; \
	VARIABLE trans15_Temp_COMP_WIRE1; \
	MENU trans15_Temp_COMP_WIRE1_page; \
	COMMAND trans15_Temp_COMP_WIRE1_read; \
	COMMAND trans15_Temp_COMP_WIRE1_write; \
	MENU trans15_Temp_Thermoresistance_Simple_Dialog_Mandatory_B

#define USE_TRANS15_TEMP_PYROMETER_MANDATORY_B \
	VARIABLE trans15_Temp_EMISSIVITY; \
	MENU trans15_Temp_EMISSIVITY_page; \
	COMMAND trans15_Temp_EMISSIVITY_read; \
	COMMAND trans15_Temp_EMISSIVITY_write; \
	VARIABLE trans15_Temp_PEAK_TRACK; \
	MENU trans15_Temp_PEAK_TRACK_page; \
	COMMAND trans15_Temp_PEAK_TRACK_read; \
	COMMAND trans15_Temp_PEAK_TRACK_write; \
	VARIABLE trans15_Temp_DECAY_RATE; \
	MENU trans15_Temp_DECAY_RATE_page; \
	COMMAND trans15_Temp_DECAY_RATE_read; \
	COMMAND trans15_Temp_DECAY_RATE_write; \
	VARIABLE trans15_Temp_PEAK_TIME; \
	MENU trans15_Temp_PEAK_TIME_page; \
	COMMAND trans15_Temp_PEAK_TIME_read; \
	COMMAND trans15_Temp_PEAK_TIME_write; \
	VARIABLE trans15_Temp_TRACK_HOLD; \
	MENU trans15_Temp_TRACK_HOLD_page; \
	COMMAND trans15_Temp_TRACK_HOLD_read; \
	COMMAND trans15_Temp_TRACK_HOLD_write; \
	VARIABLE trans15_Temp_SPECT_FILT_SET; \
	MENU trans15_Temp_SPECT_FILT_SET_page; \
	COMMAND trans15_Temp_SPECT_FILT_SET_read; \
	COMMAND trans15_Temp_SPECT_FILT_SET_write; \
	MENU trans15_Temp_Pyrometer_Simple_Dialog_Mandatory_B

#define USE_TRANS15_TEMP_THERMOCOUPLE_OPTIONAL_A \
	VARIABLE trans15_Temp_RJ_TEMP; \
	MENU trans15_Temp_RJ_TEMP_page; \
	COMMAND trans15_Temp_RJ_TEMP_read; \
	VARIABLE trans15_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans15_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans15_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans15_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans15_Temp_Thermocouple_Simple_Dialog_Optional_A; \
	UNIT trans15_Temp_Unit_3

#define USE_TRANS15_TEMP_THERMORESISTANCE_OPTIONAL_A \
	VARIABLE trans15_Temp_COMP_WIRE2; \
	MENU trans15_Temp_COMP_WIRE2_page; \
	COMMAND trans15_Temp_COMP_WIRE2_read; \
	COMMAND trans15_Temp_COMP_WIRE2_write; \
	MENU trans15_Temp_Thermoresistance_Simple_Dialog_Optional_A

#define USE_TRANS15_TEMP_PYROMETER_OPTIONAL_A \
	MENU trans15_Temp_Pyrometer_Simple_Dialog_Optional_A

#define USE_TRANS15_TEMP_THERMOCOUPLE_OPTIONAL_B \
	VARIABLE trans15_Temp_RJ_TEMP; \
	MENU trans15_Temp_RJ_TEMP_page; \
	COMMAND trans15_Temp_RJ_TEMP_read; \
	VARIABLE trans15_Temp_EXTERNAL_RJ_VALUE; \
	MENU trans15_Temp_EXTERNAL_RJ_VALUE_page; \
	COMMAND trans15_Temp_EXTERNAL_RJ_VALUE_read; \
	COMMAND trans15_Temp_EXTERNAL_RJ_VALUE_write; \
	MENU trans15_Temp_Thermocouple_Simple_Dialog_Optional_B; \
	UNIT trans15_Temp_Unit_3

#define USE_TRANS15_TEMP_THERMORESISTANCE_OPTIONAL_B \
	VARIABLE trans15_Temp_COMP_WIRE2; \
	MENU trans15_Temp_COMP_WIRE2_page; \
	COMMAND trans15_Temp_COMP_WIRE2_read; \
	COMMAND trans15_Temp_COMP_WIRE2_write; \
	MENU trans15_Temp_Thermoresistance_Simple_Dialog_Optional_B

#define USE_TRANS15_TEMP_PYROMETER_OPTIONAL_B \
	MENU trans15_Temp_Pyrometer_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS15_TEMP_MANDATORY_A USE_TRANS_TEMP_MANDATORY_A(trans15_Temp_)
#define USE_TRANS15_TEMP_MANDATORY_B USE_TRANS_TEMP_MANDATORY_B(trans15_Temp_)
#define USE_TRANS15_TEMP_OPTIONAL_A  USE_TRANS_TEMP_OPTIONAL_A(trans15_Temp_)
#define USE_TRANS15_TEMP_OPTIONAL_B  USE_TRANS_TEMP_OPTIONAL_B(trans15_Temp_)
#define USE_TRANS15_TEMP_THERMOCOUPLE_MANDATORY_A \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_A(trans15_Temp_)
#define USE_TRANS15_TEMP_THERMORESISTANCE_MANDATORY_A \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_A(trans15_Temp_)
#define USE_TRANS15_TEMP_PYROMETER_MANDATORY_A \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_A(trans15_Temp_)
#define USE_TRANS15_TEMP_THERMOCOUPLE_MANDATORY_B \
		USE_TRANS_TEMP_THERMOCOUPLE_MANDATORY_B(trans15_Temp_)
#define USE_TRANS15_TEMP_THERMORESISTANCE_MANDATORY_B \
		USE_TRANS_TEMP_THERMORESISTANCE_MANDATORY_B(trans15_Temp_)
#define USE_TRANS15_TEMP_PYROMETER_MANDATORY_B \
		USE_TRANS_TEMP_PYROMETER_MANDATORY_B(trans15_Temp_)
#define USE_TRANS15_TEMP_THERMOCOUPLE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_A(trans15_Temp_)
#define USE_TRANS15_TEMP_THERMORESISTANCE_OPTIONAL_A \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_A(trans15_Temp_)
#define USE_TRANS15_TEMP_PYROMETER_OPTIONAL_A \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_A(trans15_Temp_)
#define USE_TRANS15_TEMP_THERMOCOUPLE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMOCOUPLE_OPTIONAL_B(trans15_Temp_)
#define USE_TRANS15_TEMP_THERMORESISTANCE_OPTIONAL_B \
		USE_TRANS_TEMP_THERMORESISTANCE_OPTIONAL_B(trans15_Temp_)
#define USE_TRANS15_TEMP_PYROMETER_OPTIONAL_B \
		USE_TRANS_TEMP_PYROMETER_OPTIONAL_B(trans15_Temp_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS1_PRESS_MANDATORY_BOTH \
	BLOCK trans1_Press_block; \
	COLLECTION trans1_Press_BLOCK_OBJECT; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans1_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans1_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans1_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans1_Press_BLOCK_OBJECT_page; \
	COMMAND trans1_Press_BLOCK_OBJECT_read; \
	VARIABLE trans1_Press_ST_REV; \
	MENU trans1_Press_ST_REV_page; \
	COMMAND trans1_Press_ST_REV_read; \
	VARIABLE trans1_Press_TAG_DESC; \
	MENU trans1_Press_TAG_DESC_page; \
	COMMAND trans1_Press_TAG_DESC_read; \
	COMMAND trans1_Press_TAG_DESC_write; \
	VARIABLE trans1_Press_STRATEGY; \
	MENU trans1_Press_STRATEGY_page; \
	COMMAND trans1_Press_STRATEGY_read; \
	COMMAND trans1_Press_STRATEGY_write; \
	VARIABLE trans1_Press_ALERT_KEY; \
	MENU trans1_Press_ALERT_KEY_page; \
	COMMAND trans1_Press_ALERT_KEY_read; \
	COMMAND trans1_Press_ALERT_KEY_write; \
	VARIABLE trans1_Press_TARGET_MODE; \
	MENU trans1_Press_TARGET_MODE_page; \
	COMMAND trans1_Press_TARGET_MODE_read; \
	COMMAND trans1_Press_TARGET_MODE_write; \
	COLLECTION trans1_Press_MODE_BLK; \
	VARIABLE trans1_Press_MODE_BLK_Actual; \
	VARIABLE trans1_Press_MODE_BLK_Permitted; \
	VARIABLE trans1_Press_MODE_BLK_Normal; \
	MENU trans1_Press_MODE_BLK_page; \
	COMMAND trans1_Press_MODE_BLK_read; \
	COLLECTION trans1_Press_ALARM_SUM; \
	VARIABLE trans1_Press_ALARM_SUM_Current; \
	VARIABLE trans1_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans1_Press_ALARM_SUM_Unreported; \
	VARIABLE trans1_Press_ALARM_SUM_Disabled; \
	MENU trans1_Press_ALARM_SUM_page; \
	COMMAND trans1_Press_ALARM_SUM_read

#define USE_TRANS1_PRESS_MANDATORY_A \
	USE_TRANS1_PRESS_MANDATORY_BOTH; \
	MENU trans1_Press_Simple_Dialog_Mandatory_A; \
	MENU trans1_Press_Tab_s_mandatory_A; \
	MENU trans1_Press_Tab_m_mandatory_A

#define USE_TRANS1_PRESS_MANDATORY_B \
	USE_TRANS1_PRESS_MANDATORY_BOTH; \
	VARIABLE trans1_Press_SENSOR_VALUE; \
	MENU trans1_Press_SENSOR_VALUE_page; \
	COMMAND trans1_Press_SENSOR_VALUE_read; \
	VARIABLE trans1_Press_SENSOR_HI_LIM; \
	MENU trans1_Press_SENSOR_HI_LIM_page; \
	COMMAND trans1_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans1_Press_SENSOR_LO_LIM; \
	MENU trans1_Press_SENSOR_LO_LIM_page; \
	COMMAND trans1_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans1_Press_CAL_POINT_HI; \
	MENU trans1_Press_CAL_POINT_HI_page; \
	COMMAND trans1_Press_CAL_POINT_HI_read; \
	COMMAND trans1_Press_CAL_POINT_HI_write; \
	VARIABLE trans1_Press_CAL_POINT_LO; \
	MENU trans1_Press_CAL_POINT_LO_page; \
	COMMAND trans1_Press_CAL_POINT_LO_read; \
	COMMAND trans1_Press_CAL_POINT_LO_write; \
	VARIABLE trans1_Press_CAL_MIN_SPAN; \
	MENU trans1_Press_CAL_MIN_SPAN_page; \
	COMMAND trans1_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans1_Press_SENSOR_UNIT; \
	MENU trans1_Press_SENSOR_UNIT_page; \
	COMMAND trans1_Press_SENSOR_UNIT_read; \
	COMMAND trans1_Press_SENSOR_UNIT_write; \
	COLLECTION trans1_Press_TRIMMED_VALUE; \
	VARIABLE trans1_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans1_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans1_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans1_Press_TRIMMED_VALUE_page; \
	COMMAND trans1_Press_TRIMMED_VALUE_read; \
	VARIABLE trans1_Press_SENSOR_TYPE; \
	MENU trans1_Press_SENSOR_TYPE_page; \
	COMMAND trans1_Press_SENSOR_TYPE_read; \
	VARIABLE trans1_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans1_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans1_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans1_Press_PRIMARY_VALUE; \
	VARIABLE trans1_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans1_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans1_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans1_Press_PRIMARY_VALUE_page; \
	COMMAND trans1_Press_PRIMARY_VALUE_read; \
	VARIABLE trans1_Press_PRIMARY_VALUE_UNIT; \
	MENU trans1_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans1_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans1_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans1_Press_PRIMARY_VALUE_TYPE; \
	MENU trans1_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans1_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans1_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans1_Press_LIN_TYPE; \
	MENU trans1_Press_LIN_TYPE_page; \
	COMMAND trans1_Press_LIN_TYPE_read; \
	COMMAND trans1_Press_LIN_TYPE_write; \
	COLLECTION trans1_Press_VIEW_1; \
	MENU trans1_Press_VIEW_1_page; \
	MENU trans1_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans1_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans1_Press_Sensor_unit_1; \
	MENU trans1_Press_Tab_s_mandatory_B; \
	MENU trans1_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans1_Press_Tab_s_input_table_mandatory_B; \
	MENU trans1_Press_Tab_m_mandatory_B; \
	MENU trans1_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans1_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS1_PRESS_OPTIONAL_BOTH \
	VARIABLE trans1_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans1_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans1_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans1_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans1_Press_SENSOR_FILL_FLUID; \
	MENU trans1_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans1_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans1_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans1_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans1_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans1_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans1_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans1_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans1_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans1_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans1_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans1_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans1_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans1_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans1_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans1_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans1_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans1_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans1_Press_TEMPERATURE; \
	VARIABLE trans1_Press_TEMPERATURE_Value; \
	VARIABLE trans1_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans1_Press_TEMPERATURE_Status_Limit; \
	MENU trans1_Press_TEMPERATURE_page; \
	COMMAND trans1_Press_TEMPERATURE_read; \
	VARIABLE trans1_Press_TEMPERATURE_UNIT; \
	MENU trans1_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans1_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans1_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans1_Press_SECONDARY_VALUE_1; \
	VARIABLE trans1_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans1_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans1_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans1_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans1_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans1_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans1_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans1_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans1_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans1_Press_SECONDARY_VALUE_2; \
	VARIABLE trans1_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans1_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans1_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans1_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans1_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans1_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans1_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans1_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans1_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans1_Press_SCALE_IN; \
	VARIABLE trans1_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans1_Press_SCALE_IN_Lower_Value; \
	MENU trans1_Press_SCALE_IN_page; \
	COMMAND trans1_Press_SCALE_IN_read; \
	COMMAND trans1_Press_SCALE_IN_write; \
	COLLECTION trans1_Press_SCALE_OUT; \
	VARIABLE trans1_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans1_Press_SCALE_OUT_Lower_Value; \
	MENU trans1_Press_SCALE_OUT_page; \
	COMMAND trans1_Press_SCALE_OUT_read; \
	COMMAND trans1_Press_SCALE_OUT_write; \
	VARIABLE trans1_Press_LOW_FLOW_CUT_OFF; \
	MENU trans1_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans1_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans1_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans1_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans1_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans1_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans1_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans1_Press_TAB_ACTUAL_NUMBER; \
	MENU trans1_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans1_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans1_Press_TAB_ENTRY; \
	MENU trans1_Press_TAB_ENTRY_page; \
	COMMAND trans1_Press_TAB_ENTRY_read; \
	COMMAND trans1_Press_TAB_ENTRY_write; \
	VARIABLE trans1_Press_TAB_MAX_NUMBER; \
	MENU trans1_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans1_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans1_Press_TAB_MIN_NUMBER; \
	MENU trans1_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans1_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans1_Press_TAB_OP_CODE; \
	MENU trans1_Press_TAB_OP_CODE_page; \
	COMMAND trans1_Press_TAB_OP_CODE_read; \
	COMMAND trans1_Press_TAB_OP_CODE_write; \
	VARIABLE trans1_Press_TAB_STATUS; \
	MENU trans1_Press_TAB_STATUS_page; \
	COMMAND trans1_Press_TAB_STATUS_read; \
	COLLECTION trans1_Press_TAB_X_Y_VALUE; \
	VARIABLE trans1_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans1_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans1_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans1_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans1_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans1_Press_MAX_SENSOR_VALUE; \
	MENU trans1_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans1_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans1_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans1_Press_MIN_SENSOR_VALUE; \
	MENU trans1_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans1_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans1_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans1_Press_MAX_TEMPERATURE; \
	MENU trans1_Press_MAX_TEMPERATURE_page; \
	COMMAND trans1_Press_MAX_TEMPERATURE_read; \
	COMMAND trans1_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans1_Press_MIN_TEMPERATURE; \
	MENU trans1_Press_MIN_TEMPERATURE_page; \
	COMMAND trans1_Press_MIN_TEMPERATURE_read; \
	COMMAND trans1_Press_MIN_TEMPERATURE_write; \
	UNIT trans1_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans1_Press_Sensor_unit_2; \
	UNIT trans1_Press_Temperature_unit; \
	UNIT trans1_Press_Secondary_Value_1_unit; \
	UNIT trans1_Press_Secondary_Value_2_unit

#define USE_TRANS1_PRESS_OPTIONAL_A \
	USE_TRANS1_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans1_Press_SENSOR_VALUE; \
	MENU trans1_Press_SENSOR_VALUE_page; \
	COMMAND trans1_Press_SENSOR_VALUE_read; \
	VARIABLE trans1_Press_SENSOR_HI_LIM; \
	MENU trans1_Press_SENSOR_HI_LIM_page; \
	COMMAND trans1_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans1_Press_SENSOR_LO_LIM; \
	MENU trans1_Press_SENSOR_LO_LIM_page; \
	COMMAND trans1_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans1_Press_CAL_POINT_HI; \
	MENU trans1_Press_CAL_POINT_HI_page; \
	COMMAND trans1_Press_CAL_POINT_HI_read; \
	COMMAND trans1_Press_CAL_POINT_HI_write; \
	VARIABLE trans1_Press_CAL_POINT_LO; \
	MENU trans1_Press_CAL_POINT_LO_page; \
	COMMAND trans1_Press_CAL_POINT_LO_read; \
	COMMAND trans1_Press_CAL_POINT_LO_write; \
	VARIABLE trans1_Press_CAL_MIN_SPAN; \
	MENU trans1_Press_CAL_MIN_SPAN_page; \
	COMMAND trans1_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans1_Press_SENSOR_UNIT; \
	MENU trans1_Press_SENSOR_UNIT_page; \
	COMMAND trans1_Press_SENSOR_UNIT_read; \
	COMMAND trans1_Press_SENSOR_UNIT_write; \
	COLLECTION trans1_Press_TRIMMED_VALUE; \
	VARIABLE trans1_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans1_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans1_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans1_Press_TRIMMED_VALUE_page; \
	COMMAND trans1_Press_TRIMMED_VALUE_read; \
	VARIABLE trans1_Press_SENSOR_TYPE; \
	MENU trans1_Press_SENSOR_TYPE_page; \
	COMMAND trans1_Press_SENSOR_TYPE_read; \
	VARIABLE trans1_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans1_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans1_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans1_Press_PRIMARY_VALUE; \
	VARIABLE trans1_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans1_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans1_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans1_Press_PRIMARY_VALUE_page; \
	COMMAND trans1_Press_PRIMARY_VALUE_read; \
	VARIABLE trans1_Press_PRIMARY_VALUE_UNIT; \
	MENU trans1_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans1_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans1_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans1_Press_PRIMARY_VALUE_TYPE; \
	MENU trans1_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans1_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans1_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans1_Press_LIN_TYPE; \
	MENU trans1_Press_LIN_TYPE_page; \
	COMMAND trans1_Press_LIN_TYPE_read; \
	COMMAND trans1_Press_LIN_TYPE_write; \
	COLLECTION trans1_Press_VIEW_1; \
	MENU trans1_Press_VIEW_1_page; \
	MENU trans1_Press_Simple_Dialog_Optional_A; \
	UNIT trans1_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans1_Press_Sensor_unit_1

#define USE_TRANS1_PRESS_OPTIONAL_B \
	USE_TRANS1_PRESS_OPTIONAL_BOTH; \
	MENU trans1_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS_PRESS_MANDATORY_BOTH(prefix) \
	BLOCK prefix ## block; \
	COLLECTION prefix ## BLOCK_OBJECT; \
	VARIABLE prefix ## BLOCK_OBJECT_Reserved; \
	VARIABLE prefix ## BLOCK_OBJECT_Block_Object; \
	VARIABLE prefix ## BLOCK_OBJECT_Parent_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Reference; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Execution_Time; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Views; \
	MENU prefix ## BLOCK_OBJECT_page; \
	COMMAND prefix ## BLOCK_OBJECT_read; \
	VARIABLE prefix ## ST_REV; \
	MENU prefix ## ST_REV_page; \
	COMMAND prefix ## ST_REV_read; \
	VARIABLE prefix ## TAG_DESC; \
	MENU prefix ## TAG_DESC_page; \
	COMMAND prefix ## TAG_DESC_read; \
	COMMAND prefix ## TAG_DESC_write; \
	VARIABLE prefix ## STRATEGY; \
	MENU prefix ## STRATEGY_page; \
	COMMAND prefix ## STRATEGY_read; \
	COMMAND prefix ## STRATEGY_write; \
	VARIABLE prefix ## ALERT_KEY; \
	MENU prefix ## ALERT_KEY_page; \
	COMMAND prefix ## ALERT_KEY_read; \
	COMMAND prefix ## ALERT_KEY_write; \
	VARIABLE prefix ## TARGET_MODE; \
	MENU prefix ## TARGET_MODE_page; \
	COMMAND prefix ## TARGET_MODE_read; \
	COMMAND prefix ## TARGET_MODE_write; \
	COLLECTION prefix ## MODE_BLK; \
	VARIABLE prefix ## MODE_BLK_Actual; \
	VARIABLE prefix ## MODE_BLK_Permitted; \
	VARIABLE prefix ## MODE_BLK_Normal; \
	MENU prefix ## MODE_BLK_page; \
	COMMAND prefix ## MODE_BLK_read; \
	COLLECTION prefix ## ALARM_SUM; \
	VARIABLE prefix ## ALARM_SUM_Current; \
	VARIABLE prefix ## ALARM_SUM_Unacknowledged; \
	VARIABLE prefix ## ALARM_SUM_Unreported; \
	VARIABLE prefix ## ALARM_SUM_Disabled; \
	MENU prefix ## ALARM_SUM_page; \
	COMMAND prefix ## ALARM_SUM_read

#define USE_TRANS_PRESS_MANDATORY_A(prefix) \
	USE_TRANS_PRESS_MANDATORY_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Mandatory_A; \
	MENU prefix ## Tab_s_mandatory_A; \
	MENU prefix ## Tab_m_mandatory_A

#define USE_TRANS_PRESS_MANDATORY_B(prefix) \
	USE_TRANS_PRESS_MANDATORY_BOTH(prefix); \
	VARIABLE prefix ## SENSOR_VALUE; \
	MENU prefix ## SENSOR_VALUE_page; \
	COMMAND prefix ## SENSOR_VALUE_read; \
	VARIABLE prefix ## SENSOR_HI_LIM; \
	MENU prefix ## SENSOR_HI_LIM_page; \
	COMMAND prefix ## SENSOR_HI_LIM_read; \
	VARIABLE prefix ## SENSOR_LO_LIM; \
	MENU prefix ## SENSOR_LO_LIM_page; \
	COMMAND prefix ## SENSOR_LO_LIM_read; \
	VARIABLE prefix ## CAL_POINT_HI; \
	MENU prefix ## CAL_POINT_HI_page; \
	COMMAND prefix ## CAL_POINT_HI_read; \
	COMMAND prefix ## CAL_POINT_HI_write; \
	VARIABLE prefix ## CAL_POINT_LO; \
	MENU prefix ## CAL_POINT_LO_page; \
	COMMAND prefix ## CAL_POINT_LO_read; \
	COMMAND prefix ## CAL_POINT_LO_write; \
	VARIABLE prefix ## CAL_MIN_SPAN; \
	MENU prefix ## CAL_MIN_SPAN_page; \
	COMMAND prefix ## CAL_MIN_SPAN_read; \
	VARIABLE prefix ## SENSOR_UNIT; \
	MENU prefix ## SENSOR_UNIT_page; \
	COMMAND prefix ## SENSOR_UNIT_read; \
	COMMAND prefix ## SENSOR_UNIT_write; \
	COLLECTION prefix ## TRIMMED_VALUE; \
	VARIABLE prefix ## TRIMMED_VALUE_Value; \
	VARIABLE prefix ## TRIMMED_VALUE_Status_Quality; \
	VARIABLE prefix ## TRIMMED_VALUE_Status_Limit; \
	MENU prefix ## TRIMMED_VALUE_page; \
	COMMAND prefix ## TRIMMED_VALUE_read; \
	VARIABLE prefix ## SENSOR_TYPE; \
	MENU prefix ## SENSOR_TYPE_page; \
	COMMAND prefix ## SENSOR_TYPE_read; \
	VARIABLE prefix ## SENSOR_SERIAL_NUMBER; \
	MENU prefix ## SENSOR_SERIAL_NUMBER_page; \
	COMMAND prefix ## SENSOR_SERIAL_NUMBER_read; \
	COLLECTION prefix ## PRIMARY_VALUE; \
	VARIABLE prefix ## PRIMARY_VALUE_Value; \
	VARIABLE prefix ## PRIMARY_VALUE_Status_Quality; \
	VARIABLE prefix ## PRIMARY_VALUE_Status_Limit; \
	MENU prefix ## PRIMARY_VALUE_page; \
	COMMAND prefix ## PRIMARY_VALUE_read; \
	VARIABLE prefix ## PRIMARY_VALUE_UNIT; \
	MENU prefix ## PRIMARY_VALUE_UNIT_page; \
	COMMAND prefix ## PRIMARY_VALUE_UNIT_read; \
	COMMAND prefix ## PRIMARY_VALUE_UNIT_write; \
	VARIABLE prefix ## PRIMARY_VALUE_TYPE; \
	MENU prefix ## PRIMARY_VALUE_TYPE_page; \
	COMMAND prefix ## PRIMARY_VALUE_TYPE_read; \
	COMMAND prefix ## PRIMARY_VALUE_TYPE_write; \
	VARIABLE prefix ## LIN_TYPE; \
	MENU prefix ## LIN_TYPE_page; \
	COMMAND prefix ## LIN_TYPE_read; \
	COMMAND prefix ## LIN_TYPE_write; \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Mandatory_B; \
	UNIT prefix ## PRIMARY_VALUE_UNIT_unit_1; \
	UNIT prefix ## Sensor_unit_1; \
	MENU prefix ## Tab_s_mandatory_B; \
	MENU prefix ## Tab_s_input_meassurelimit_mandatory_B; \
	MENU prefix ## Tab_s_input_table_mandatory_B; \
	MENU prefix ## Tab_m_mandatory_B; \
	MENU prefix ## Tab_m_input_meassurelimit_mandatory_B; \
	MENU prefix ## Tab_m_input_table_mandatory_B

#define USE_TRANS_PRESS_OPTIONAL_BOTH(prefix) \
	VARIABLE prefix ## SENSOR_DIAPHRAGM_MATERIAL; \
	MENU prefix ## SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND prefix ## SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND prefix ## SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE prefix ## SENSOR_FILL_FLUID; \
	MENU prefix ## SENSOR_FILL_FLUID_page; \
	COMMAND prefix ## SENSOR_FILL_FLUID_read; \
	COMMAND prefix ## SENSOR_FILL_FLUID_write; \
	VARIABLE prefix ## SENSOR_MAX_STATIC_PRESSURE; \
	MENU prefix ## SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND prefix ## SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE prefix ## SENSOR_O_RING_MATERIAL; \
	MENU prefix ## SENSOR_O_RING_MATERIAL_page; \
	COMMAND prefix ## SENSOR_O_RING_MATERIAL_read; \
	COMMAND prefix ## SENSOR_O_RING_MATERIAL_write; \
	VARIABLE prefix ## PROCESS_CONNECTION_TYPE; \
	MENU prefix ## PROCESS_CONNECTION_TYPE_page; \
	COMMAND prefix ## PROCESS_CONNECTION_TYPE_read; \
	COMMAND prefix ## PROCESS_CONNECTION_TYPE_write; \
	VARIABLE prefix ## PROCESS_CONNECTION_MATERIAL; \
	MENU prefix ## PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND prefix ## PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND prefix ## PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION prefix ## TEMPERATURE; \
	VARIABLE prefix ## TEMPERATURE_Value; \
	VARIABLE prefix ## TEMPERATURE_Status_Quality; \
	VARIABLE prefix ## TEMPERATURE_Status_Limit; \
	MENU prefix ## TEMPERATURE_page; \
	COMMAND prefix ## TEMPERATURE_read; \
	VARIABLE prefix ## TEMPERATURE_UNIT; \
	MENU prefix ## TEMPERATURE_UNIT_page; \
	COMMAND prefix ## TEMPERATURE_UNIT_read; \
	COMMAND prefix ## TEMPERATURE_UNIT_write; \
	COLLECTION prefix ## SECONDARY_VALUE_1; \
	VARIABLE prefix ## SECONDARY_VALUE_1_Value; \
	VARIABLE prefix ## SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE prefix ## SECONDARY_VALUE_1_Status_Limit; \
	MENU prefix ## SECONDARY_VALUE_1_page; \
	COMMAND prefix ## SECONDARY_VALUE_1_read; \
	VARIABLE prefix ## SECONDARY_VALUE_1_UNIT; \
	MENU prefix ## SECONDARY_VALUE_1_UNIT_page; \
	COMMAND prefix ## SECONDARY_VALUE_1_UNIT_read; \
	COMMAND prefix ## SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION prefix ## SECONDARY_VALUE_2; \
	VARIABLE prefix ## SECONDARY_VALUE_2_Value; \
	VARIABLE prefix ## SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE prefix ## SECONDARY_VALUE_2_Status_Limit; \
	MENU prefix ## SECONDARY_VALUE_2_page; \
	COMMAND prefix ## SECONDARY_VALUE_2_read; \
	VARIABLE prefix ## SECONDARY_VALUE_2_UNIT; \
	MENU prefix ## SECONDARY_VALUE_2_UNIT_page; \
	COMMAND prefix ## SECONDARY_VALUE_2_UNIT_read; \
	COMMAND prefix ## SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION prefix ## SCALE_IN; \
	VARIABLE prefix ## SCALE_IN_Upper_Value; \
	VARIABLE prefix ## SCALE_IN_Lower_Value; \
	MENU prefix ## SCALE_IN_page; \
	COMMAND prefix ## SCALE_IN_read; \
	COMMAND prefix ## SCALE_IN_write; \
	COLLECTION prefix ## SCALE_OUT; \
	VARIABLE prefix ## SCALE_OUT_Upper_Value; \
	VARIABLE prefix ## SCALE_OUT_Lower_Value; \
	MENU prefix ## SCALE_OUT_page; \
	COMMAND prefix ## SCALE_OUT_read; \
	COMMAND prefix ## SCALE_OUT_write; \
	VARIABLE prefix ## LOW_FLOW_CUT_OFF; \
	MENU prefix ## LOW_FLOW_CUT_OFF_page; \
	COMMAND prefix ## LOW_FLOW_CUT_OFF_read; \
	COMMAND prefix ## LOW_FLOW_CUT_OFF_write; \
	VARIABLE prefix ## FLOW_LIN_SQRT_POINT; \
	MENU prefix ## FLOW_LIN_SQRT_POINT_page; \
	COMMAND prefix ## FLOW_LIN_SQRT_POINT_read; \
	COMMAND prefix ## FLOW_LIN_SQRT_POINT_write; \
	VARIABLE prefix ## TAB_ACTUAL_NUMBER; \
	MENU prefix ## TAB_ACTUAL_NUMBER_page; \
	COMMAND prefix ## TAB_ACTUAL_NUMBER_read; \
	VARIABLE prefix ## TAB_ENTRY; \
	MENU prefix ## TAB_ENTRY_page; \
	COMMAND prefix ## TAB_ENTRY_read; \
	COMMAND prefix ## TAB_ENTRY_write; \
	VARIABLE prefix ## TAB_MAX_NUMBER; \
	MENU prefix ## TAB_MAX_NUMBER_page; \
	COMMAND prefix ## TAB_MAX_NUMBER_read; \
	VARIABLE prefix ## TAB_MIN_NUMBER; \
	MENU prefix ## TAB_MIN_NUMBER_page; \
	COMMAND prefix ## TAB_MIN_NUMBER_read; \
	VARIABLE prefix ## TAB_OP_CODE; \
	MENU prefix ## TAB_OP_CODE_page; \
	COMMAND prefix ## TAB_OP_CODE_read; \
	COMMAND prefix ## TAB_OP_CODE_write; \
	VARIABLE prefix ## TAB_STATUS; \
	MENU prefix ## TAB_STATUS_page; \
	COMMAND prefix ## TAB_STATUS_read; \
	COLLECTION prefix ## TAB_X_Y_VALUE; \
	VARIABLE prefix ## TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE prefix ## TAB_X_Y_VALUE_Lower_Value; \
	MENU prefix ## TAB_X_Y_VALUE_page; \
	COMMAND prefix ## TAB_X_Y_VALUE_read; \
	COMMAND prefix ## TAB_X_Y_VALUE_write; \
	VARIABLE prefix ## MAX_SENSOR_VALUE; \
	MENU prefix ## MAX_SENSOR_VALUE_page; \
	COMMAND prefix ## MAX_SENSOR_VALUE_read; \
	COMMAND prefix ## MAX_SENSOR_VALUE_write; \
	VARIABLE prefix ## MIN_SENSOR_VALUE; \
	MENU prefix ## MIN_SENSOR_VALUE_page; \
	COMMAND prefix ## MIN_SENSOR_VALUE_read; \
	COMMAND prefix ## MIN_SENSOR_VALUE_write; \
	VARIABLE prefix ## MAX_TEMPERATURE; \
	MENU prefix ## MAX_TEMPERATURE_page; \
	COMMAND prefix ## MAX_TEMPERATURE_read; \
	COMMAND prefix ## MAX_TEMPERATURE_write; \
	VARIABLE prefix ## MIN_TEMPERATURE; \
	MENU prefix ## MIN_TEMPERATURE_page; \
	COMMAND prefix ## MIN_TEMPERATURE_read; \
	COMMAND prefix ## MIN_TEMPERATURE_write; \
	UNIT prefix ## PRIMARY_VALUE_UNIT_unit_2; \
	UNIT prefix ## Sensor_unit_2; \
	UNIT prefix ## Temperature_unit; \
	UNIT prefix ## Secondary_Value_1_unit; \
	UNIT prefix ## Secondary_Value_2_unit

#define USE_TRANS_PRESS_OPTIONAL_A(prefix) \
	USE_TRANS_PRESS_OPTIONAL_BOTH(prefix); \
	VARIABLE prefix ## SENSOR_VALUE; \
	MENU prefix ## SENSOR_VALUE_page; \
	COMMAND prefix ## SENSOR_VALUE_read; \
	VARIABLE prefix ## SENSOR_HI_LIM; \
	MENU prefix ## SENSOR_HI_LIM_page; \
	COMMAND prefix ## SENSOR_HI_LIM_read; \
	VARIABLE prefix ## SENSOR_LO_LIM; \
	MENU prefix ## SENSOR_LO_LIM_page; \
	COMMAND prefix ## SENSOR_LO_LIM_read; \
	VARIABLE prefix ## CAL_POINT_HI; \
	MENU prefix ## CAL_POINT_HI_page; \
	COMMAND prefix ## CAL_POINT_HI_read; \
	COMMAND prefix ## CAL_POINT_HI_write; \
	VARIABLE prefix ## CAL_POINT_LO; \
	MENU prefix ## CAL_POINT_LO_page; \
	COMMAND prefix ## CAL_POINT_LO_read; \
	COMMAND prefix ## CAL_POINT_LO_write; \
	VARIABLE prefix ## CAL_MIN_SPAN; \
	MENU prefix ## CAL_MIN_SPAN_page; \
	COMMAND prefix ## CAL_MIN_SPAN_read; \
	VARIABLE prefix ## SENSOR_UNIT; \
	MENU prefix ## SENSOR_UNIT_page; \
	COMMAND prefix ## SENSOR_UNIT_read; \
	COMMAND prefix ## SENSOR_UNIT_write; \
	COLLECTION prefix ## TRIMMED_VALUE; \
	VARIABLE prefix ## TRIMMED_VALUE_Value; \
	VARIABLE prefix ## TRIMMED_VALUE_Status_Quality; \
	VARIABLE prefix ## TRIMMED_VALUE_Status_Limit; \
	MENU prefix ## TRIMMED_VALUE_page; \
	COMMAND prefix ## TRIMMED_VALUE_read; \
	VARIABLE prefix ## SENSOR_TYPE; \
	MENU prefix ## SENSOR_TYPE_page; \
	COMMAND prefix ## SENSOR_TYPE_read; \
	VARIABLE prefix ## SENSOR_SERIAL_NUMBER; \
	MENU prefix ## SENSOR_SERIAL_NUMBER_page; \
	COMMAND prefix ## SENSOR_SERIAL_NUMBER_read; \
	COLLECTION prefix ## PRIMARY_VALUE; \
	VARIABLE prefix ## PRIMARY_VALUE_Value; \
	VARIABLE prefix ## PRIMARY_VALUE_Status_Quality; \
	VARIABLE prefix ## PRIMARY_VALUE_Status_Limit; \
	MENU prefix ## PRIMARY_VALUE_page; \
	COMMAND prefix ## PRIMARY_VALUE_read; \
	VARIABLE prefix ## PRIMARY_VALUE_UNIT; \
	MENU prefix ## PRIMARY_VALUE_UNIT_page; \
	COMMAND prefix ## PRIMARY_VALUE_UNIT_read; \
	COMMAND prefix ## PRIMARY_VALUE_UNIT_write; \
	VARIABLE prefix ## PRIMARY_VALUE_TYPE; \
	MENU prefix ## PRIMARY_VALUE_TYPE_page; \
	COMMAND prefix ## PRIMARY_VALUE_TYPE_read; \
	COMMAND prefix ## PRIMARY_VALUE_TYPE_write; \
	VARIABLE prefix ## LIN_TYPE; \
	MENU prefix ## LIN_TYPE_page; \
	COMMAND prefix ## LIN_TYPE_read; \
	COMMAND prefix ## LIN_TYPE_write; \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Optional_A; \
	UNIT prefix ## PRIMARY_VALUE_UNIT_unit_1; \
	UNIT prefix ## Sensor_unit_1

#define USE_TRANS_PRESS_OPTIONAL_B(prefix) \
	USE_TRANS_PRESS_OPTIONAL_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Optional_B

#define USE_TRANS1_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans1_Press_)
#define USE_TRANS1_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans1_Press_)
#define USE_TRANS1_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans1_Press_)
#define USE_TRANS1_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans1_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS2_PRESS_MANDATORY_BOTH \
	BLOCK trans2_Press_block; \
	COLLECTION trans2_Press_BLOCK_OBJECT; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans2_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans2_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans2_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans2_Press_BLOCK_OBJECT_page; \
	COMMAND trans2_Press_BLOCK_OBJECT_read; \
	VARIABLE trans2_Press_ST_REV; \
	MENU trans2_Press_ST_REV_page; \
	COMMAND trans2_Press_ST_REV_read; \
	VARIABLE trans2_Press_TAG_DESC; \
	MENU trans2_Press_TAG_DESC_page; \
	COMMAND trans2_Press_TAG_DESC_read; \
	COMMAND trans2_Press_TAG_DESC_write; \
	VARIABLE trans2_Press_STRATEGY; \
	MENU trans2_Press_STRATEGY_page; \
	COMMAND trans2_Press_STRATEGY_read; \
	COMMAND trans2_Press_STRATEGY_write; \
	VARIABLE trans2_Press_ALERT_KEY; \
	MENU trans2_Press_ALERT_KEY_page; \
	COMMAND trans2_Press_ALERT_KEY_read; \
	COMMAND trans2_Press_ALERT_KEY_write; \
	VARIABLE trans2_Press_TARGET_MODE; \
	MENU trans2_Press_TARGET_MODE_page; \
	COMMAND trans2_Press_TARGET_MODE_read; \
	COMMAND trans2_Press_TARGET_MODE_write; \
	COLLECTION trans2_Press_MODE_BLK; \
	VARIABLE trans2_Press_MODE_BLK_Actual; \
	VARIABLE trans2_Press_MODE_BLK_Permitted; \
	VARIABLE trans2_Press_MODE_BLK_Normal; \
	MENU trans2_Press_MODE_BLK_page; \
	COMMAND trans2_Press_MODE_BLK_read; \
	COLLECTION trans2_Press_ALARM_SUM; \
	VARIABLE trans2_Press_ALARM_SUM_Current; \
	VARIABLE trans2_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans2_Press_ALARM_SUM_Unreported; \
	VARIABLE trans2_Press_ALARM_SUM_Disabled; \
	MENU trans2_Press_ALARM_SUM_page; \
	COMMAND trans2_Press_ALARM_SUM_read

#define USE_TRANS2_PRESS_MANDATORY_A \
	USE_TRANS2_PRESS_MANDATORY_BOTH; \
	MENU trans2_Press_Simple_Dialog_Mandatory_A; \
	MENU trans2_Press_Tab_s_mandatory_A; \
	MENU trans2_Press_Tab_m_mandatory_A

#define USE_TRANS2_PRESS_MANDATORY_B \
	USE_TRANS2_PRESS_MANDATORY_BOTH; \
	VARIABLE trans2_Press_SENSOR_VALUE; \
	MENU trans2_Press_SENSOR_VALUE_page; \
	COMMAND trans2_Press_SENSOR_VALUE_read; \
	VARIABLE trans2_Press_SENSOR_HI_LIM; \
	MENU trans2_Press_SENSOR_HI_LIM_page; \
	COMMAND trans2_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans2_Press_SENSOR_LO_LIM; \
	MENU trans2_Press_SENSOR_LO_LIM_page; \
	COMMAND trans2_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans2_Press_CAL_POINT_HI; \
	MENU trans2_Press_CAL_POINT_HI_page; \
	COMMAND trans2_Press_CAL_POINT_HI_read; \
	COMMAND trans2_Press_CAL_POINT_HI_write; \
	VARIABLE trans2_Press_CAL_POINT_LO; \
	MENU trans2_Press_CAL_POINT_LO_page; \
	COMMAND trans2_Press_CAL_POINT_LO_read; \
	COMMAND trans2_Press_CAL_POINT_LO_write; \
	VARIABLE trans2_Press_CAL_MIN_SPAN; \
	MENU trans2_Press_CAL_MIN_SPAN_page; \
	COMMAND trans2_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans2_Press_SENSOR_UNIT; \
	MENU trans2_Press_SENSOR_UNIT_page; \
	COMMAND trans2_Press_SENSOR_UNIT_read; \
	COMMAND trans2_Press_SENSOR_UNIT_write; \
	COLLECTION trans2_Press_TRIMMED_VALUE; \
	VARIABLE trans2_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans2_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans2_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans2_Press_TRIMMED_VALUE_page; \
	COMMAND trans2_Press_TRIMMED_VALUE_read; \
	VARIABLE trans2_Press_SENSOR_TYPE; \
	MENU trans2_Press_SENSOR_TYPE_page; \
	COMMAND trans2_Press_SENSOR_TYPE_read; \
	VARIABLE trans2_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans2_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans2_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans2_Press_PRIMARY_VALUE; \
	VARIABLE trans2_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans2_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans2_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans2_Press_PRIMARY_VALUE_page; \
	COMMAND trans2_Press_PRIMARY_VALUE_read; \
	VARIABLE trans2_Press_PRIMARY_VALUE_UNIT; \
	MENU trans2_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans2_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans2_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans2_Press_PRIMARY_VALUE_TYPE; \
	MENU trans2_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans2_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans2_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans2_Press_LIN_TYPE; \
	MENU trans2_Press_LIN_TYPE_page; \
	COMMAND trans2_Press_LIN_TYPE_read; \
	COMMAND trans2_Press_LIN_TYPE_write; \
	COLLECTION trans2_Press_VIEW_1; \
	MENU trans2_Press_VIEW_1_page; \
	MENU trans2_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans2_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans2_Press_Sensor_unit_1; \
	MENU trans2_Press_Tab_s_mandatory_B; \
	MENU trans2_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans2_Press_Tab_s_input_table_mandatory_B; \
	MENU trans2_Press_Tab_m_mandatory_B; \
	MENU trans2_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans2_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS2_PRESS_OPTIONAL_BOTH \
	VARIABLE trans2_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans2_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans2_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans2_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans2_Press_SENSOR_FILL_FLUID; \
	MENU trans2_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans2_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans2_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans2_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans2_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans2_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans2_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans2_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans2_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans2_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans2_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans2_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans2_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans2_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans2_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans2_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans2_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans2_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans2_Press_TEMPERATURE; \
	VARIABLE trans2_Press_TEMPERATURE_Value; \
	VARIABLE trans2_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans2_Press_TEMPERATURE_Status_Limit; \
	MENU trans2_Press_TEMPERATURE_page; \
	COMMAND trans2_Press_TEMPERATURE_read; \
	VARIABLE trans2_Press_TEMPERATURE_UNIT; \
	MENU trans2_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans2_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans2_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans2_Press_SECONDARY_VALUE_1; \
	VARIABLE trans2_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans2_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans2_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans2_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans2_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans2_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans2_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans2_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans2_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans2_Press_SECONDARY_VALUE_2; \
	VARIABLE trans2_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans2_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans2_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans2_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans2_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans2_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans2_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans2_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans2_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans2_Press_SCALE_IN; \
	VARIABLE trans2_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans2_Press_SCALE_IN_Lower_Value; \
	MENU trans2_Press_SCALE_IN_page; \
	COMMAND trans2_Press_SCALE_IN_read; \
	COMMAND trans2_Press_SCALE_IN_write; \
	COLLECTION trans2_Press_SCALE_OUT; \
	VARIABLE trans2_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans2_Press_SCALE_OUT_Lower_Value; \
	MENU trans2_Press_SCALE_OUT_page; \
	COMMAND trans2_Press_SCALE_OUT_read; \
	COMMAND trans2_Press_SCALE_OUT_write; \
	VARIABLE trans2_Press_LOW_FLOW_CUT_OFF; \
	MENU trans2_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans2_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans2_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans2_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans2_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans2_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans2_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans2_Press_TAB_ACTUAL_NUMBER; \
	MENU trans2_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans2_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans2_Press_TAB_ENTRY; \
	MENU trans2_Press_TAB_ENTRY_page; \
	COMMAND trans2_Press_TAB_ENTRY_read; \
	COMMAND trans2_Press_TAB_ENTRY_write; \
	VARIABLE trans2_Press_TAB_MAX_NUMBER; \
	MENU trans2_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans2_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans2_Press_TAB_MIN_NUMBER; \
	MENU trans2_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans2_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans2_Press_TAB_OP_CODE; \
	MENU trans2_Press_TAB_OP_CODE_page; \
	COMMAND trans2_Press_TAB_OP_CODE_read; \
	COMMAND trans2_Press_TAB_OP_CODE_write; \
	VARIABLE trans2_Press_TAB_STATUS; \
	MENU trans2_Press_TAB_STATUS_page; \
	COMMAND trans2_Press_TAB_STATUS_read; \
	COLLECTION trans2_Press_TAB_X_Y_VALUE; \
	VARIABLE trans2_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans2_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans2_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans2_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans2_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans2_Press_MAX_SENSOR_VALUE; \
	MENU trans2_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans2_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans2_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans2_Press_MIN_SENSOR_VALUE; \
	MENU trans2_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans2_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans2_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans2_Press_MAX_TEMPERATURE; \
	MENU trans2_Press_MAX_TEMPERATURE_page; \
	COMMAND trans2_Press_MAX_TEMPERATURE_read; \
	COMMAND trans2_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans2_Press_MIN_TEMPERATURE; \
	MENU trans2_Press_MIN_TEMPERATURE_page; \
	COMMAND trans2_Press_MIN_TEMPERATURE_read; \
	COMMAND trans2_Press_MIN_TEMPERATURE_write; \
	UNIT trans2_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans2_Press_Sensor_unit_2; \
	UNIT trans2_Press_Temperature_unit; \
	UNIT trans2_Press_Secondary_Value_1_unit; \
	UNIT trans2_Press_Secondary_Value_2_unit

#define USE_TRANS2_PRESS_OPTIONAL_A \
	USE_TRANS2_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans2_Press_SENSOR_VALUE; \
	MENU trans2_Press_SENSOR_VALUE_page; \
	COMMAND trans2_Press_SENSOR_VALUE_read; \
	VARIABLE trans2_Press_SENSOR_HI_LIM; \
	MENU trans2_Press_SENSOR_HI_LIM_page; \
	COMMAND trans2_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans2_Press_SENSOR_LO_LIM; \
	MENU trans2_Press_SENSOR_LO_LIM_page; \
	COMMAND trans2_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans2_Press_CAL_POINT_HI; \
	MENU trans2_Press_CAL_POINT_HI_page; \
	COMMAND trans2_Press_CAL_POINT_HI_read; \
	COMMAND trans2_Press_CAL_POINT_HI_write; \
	VARIABLE trans2_Press_CAL_POINT_LO; \
	MENU trans2_Press_CAL_POINT_LO_page; \
	COMMAND trans2_Press_CAL_POINT_LO_read; \
	COMMAND trans2_Press_CAL_POINT_LO_write; \
	VARIABLE trans2_Press_CAL_MIN_SPAN; \
	MENU trans2_Press_CAL_MIN_SPAN_page; \
	COMMAND trans2_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans2_Press_SENSOR_UNIT; \
	MENU trans2_Press_SENSOR_UNIT_page; \
	COMMAND trans2_Press_SENSOR_UNIT_read; \
	COMMAND trans2_Press_SENSOR_UNIT_write; \
	COLLECTION trans2_Press_TRIMMED_VALUE; \
	VARIABLE trans2_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans2_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans2_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans2_Press_TRIMMED_VALUE_page; \
	COMMAND trans2_Press_TRIMMED_VALUE_read; \
	VARIABLE trans2_Press_SENSOR_TYPE; \
	MENU trans2_Press_SENSOR_TYPE_page; \
	COMMAND trans2_Press_SENSOR_TYPE_read; \
	VARIABLE trans2_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans2_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans2_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans2_Press_PRIMARY_VALUE; \
	VARIABLE trans2_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans2_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans2_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans2_Press_PRIMARY_VALUE_page; \
	COMMAND trans2_Press_PRIMARY_VALUE_read; \
	VARIABLE trans2_Press_PRIMARY_VALUE_UNIT; \
	MENU trans2_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans2_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans2_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans2_Press_PRIMARY_VALUE_TYPE; \
	MENU trans2_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans2_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans2_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans2_Press_LIN_TYPE; \
	MENU trans2_Press_LIN_TYPE_page; \
	COMMAND trans2_Press_LIN_TYPE_read; \
	COMMAND trans2_Press_LIN_TYPE_write; \
	COLLECTION trans2_Press_VIEW_1; \
	MENU trans2_Press_VIEW_1_page; \
	MENU trans2_Press_Simple_Dialog_Optional_A; \
	UNIT trans2_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans2_Press_Sensor_unit_1

#define USE_TRANS2_PRESS_OPTIONAL_B \
	USE_TRANS2_PRESS_OPTIONAL_BOTH; \
	MENU trans2_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS2_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans2_Press_)
#define USE_TRANS2_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans2_Press_)
#define USE_TRANS2_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans2_Press_)
#define USE_TRANS2_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans2_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS3_PRESS_MANDATORY_BOTH \
	BLOCK trans3_Press_block; \
	COLLECTION trans3_Press_BLOCK_OBJECT; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans3_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans3_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans3_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans3_Press_BLOCK_OBJECT_page; \
	COMMAND trans3_Press_BLOCK_OBJECT_read; \
	VARIABLE trans3_Press_ST_REV; \
	MENU trans3_Press_ST_REV_page; \
	COMMAND trans3_Press_ST_REV_read; \
	VARIABLE trans3_Press_TAG_DESC; \
	MENU trans3_Press_TAG_DESC_page; \
	COMMAND trans3_Press_TAG_DESC_read; \
	COMMAND trans3_Press_TAG_DESC_write; \
	VARIABLE trans3_Press_STRATEGY; \
	MENU trans3_Press_STRATEGY_page; \
	COMMAND trans3_Press_STRATEGY_read; \
	COMMAND trans3_Press_STRATEGY_write; \
	VARIABLE trans3_Press_ALERT_KEY; \
	MENU trans3_Press_ALERT_KEY_page; \
	COMMAND trans3_Press_ALERT_KEY_read; \
	COMMAND trans3_Press_ALERT_KEY_write; \
	VARIABLE trans3_Press_TARGET_MODE; \
	MENU trans3_Press_TARGET_MODE_page; \
	COMMAND trans3_Press_TARGET_MODE_read; \
	COMMAND trans3_Press_TARGET_MODE_write; \
	COLLECTION trans3_Press_MODE_BLK; \
	VARIABLE trans3_Press_MODE_BLK_Actual; \
	VARIABLE trans3_Press_MODE_BLK_Permitted; \
	VARIABLE trans3_Press_MODE_BLK_Normal; \
	MENU trans3_Press_MODE_BLK_page; \
	COMMAND trans3_Press_MODE_BLK_read; \
	COLLECTION trans3_Press_ALARM_SUM; \
	VARIABLE trans3_Press_ALARM_SUM_Current; \
	VARIABLE trans3_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans3_Press_ALARM_SUM_Unreported; \
	VARIABLE trans3_Press_ALARM_SUM_Disabled; \
	MENU trans3_Press_ALARM_SUM_page; \
	COMMAND trans3_Press_ALARM_SUM_read

#define USE_TRANS3_PRESS_MANDATORY_A \
	USE_TRANS3_PRESS_MANDATORY_BOTH; \
	MENU trans3_Press_Simple_Dialog_Mandatory_A; \
	MENU trans3_Press_Tab_s_mandatory_A; \
	MENU trans3_Press_Tab_m_mandatory_A

#define USE_TRANS3_PRESS_MANDATORY_B \
	USE_TRANS3_PRESS_MANDATORY_BOTH; \
	VARIABLE trans3_Press_SENSOR_VALUE; \
	MENU trans3_Press_SENSOR_VALUE_page; \
	COMMAND trans3_Press_SENSOR_VALUE_read; \
	VARIABLE trans3_Press_SENSOR_HI_LIM; \
	MENU trans3_Press_SENSOR_HI_LIM_page; \
	COMMAND trans3_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans3_Press_SENSOR_LO_LIM; \
	MENU trans3_Press_SENSOR_LO_LIM_page; \
	COMMAND trans3_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans3_Press_CAL_POINT_HI; \
	MENU trans3_Press_CAL_POINT_HI_page; \
	COMMAND trans3_Press_CAL_POINT_HI_read; \
	COMMAND trans3_Press_CAL_POINT_HI_write; \
	VARIABLE trans3_Press_CAL_POINT_LO; \
	MENU trans3_Press_CAL_POINT_LO_page; \
	COMMAND trans3_Press_CAL_POINT_LO_read; \
	COMMAND trans3_Press_CAL_POINT_LO_write; \
	VARIABLE trans3_Press_CAL_MIN_SPAN; \
	MENU trans3_Press_CAL_MIN_SPAN_page; \
	COMMAND trans3_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans3_Press_SENSOR_UNIT; \
	MENU trans3_Press_SENSOR_UNIT_page; \
	COMMAND trans3_Press_SENSOR_UNIT_read; \
	COMMAND trans3_Press_SENSOR_UNIT_write; \
	COLLECTION trans3_Press_TRIMMED_VALUE; \
	VARIABLE trans3_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans3_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans3_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans3_Press_TRIMMED_VALUE_page; \
	COMMAND trans3_Press_TRIMMED_VALUE_read; \
	VARIABLE trans3_Press_SENSOR_TYPE; \
	MENU trans3_Press_SENSOR_TYPE_page; \
	COMMAND trans3_Press_SENSOR_TYPE_read; \
	VARIABLE trans3_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans3_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans3_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans3_Press_PRIMARY_VALUE; \
	VARIABLE trans3_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans3_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans3_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans3_Press_PRIMARY_VALUE_page; \
	COMMAND trans3_Press_PRIMARY_VALUE_read; \
	VARIABLE trans3_Press_PRIMARY_VALUE_UNIT; \
	MENU trans3_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans3_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans3_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans3_Press_PRIMARY_VALUE_TYPE; \
	MENU trans3_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans3_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans3_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans3_Press_LIN_TYPE; \
	MENU trans3_Press_LIN_TYPE_page; \
	COMMAND trans3_Press_LIN_TYPE_read; \
	COMMAND trans3_Press_LIN_TYPE_write; \
	COLLECTION trans3_Press_VIEW_1; \
	MENU trans3_Press_VIEW_1_page; \
	MENU trans3_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans3_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans3_Press_Sensor_unit_1; \
	MENU trans3_Press_Tab_s_mandatory_B; \
	MENU trans3_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans3_Press_Tab_s_input_table_mandatory_B; \
	MENU trans3_Press_Tab_m_mandatory_B; \
	MENU trans3_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans3_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS3_PRESS_OPTIONAL_BOTH \
	VARIABLE trans3_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans3_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans3_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans3_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans3_Press_SENSOR_FILL_FLUID; \
	MENU trans3_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans3_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans3_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans3_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans3_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans3_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans3_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans3_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans3_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans3_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans3_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans3_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans3_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans3_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans3_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans3_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans3_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans3_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans3_Press_TEMPERATURE; \
	VARIABLE trans3_Press_TEMPERATURE_Value; \
	VARIABLE trans3_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans3_Press_TEMPERATURE_Status_Limit; \
	MENU trans3_Press_TEMPERATURE_page; \
	COMMAND trans3_Press_TEMPERATURE_read; \
	VARIABLE trans3_Press_TEMPERATURE_UNIT; \
	MENU trans3_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans3_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans3_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans3_Press_SECONDARY_VALUE_1; \
	VARIABLE trans3_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans3_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans3_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans3_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans3_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans3_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans3_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans3_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans3_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans3_Press_SECONDARY_VALUE_2; \
	VARIABLE trans3_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans3_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans3_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans3_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans3_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans3_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans3_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans3_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans3_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans3_Press_SCALE_IN; \
	VARIABLE trans3_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans3_Press_SCALE_IN_Lower_Value; \
	MENU trans3_Press_SCALE_IN_page; \
	COMMAND trans3_Press_SCALE_IN_read; \
	COMMAND trans3_Press_SCALE_IN_write; \
	COLLECTION trans3_Press_SCALE_OUT; \
	VARIABLE trans3_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans3_Press_SCALE_OUT_Lower_Value; \
	MENU trans3_Press_SCALE_OUT_page; \
	COMMAND trans3_Press_SCALE_OUT_read; \
	COMMAND trans3_Press_SCALE_OUT_write; \
	VARIABLE trans3_Press_LOW_FLOW_CUT_OFF; \
	MENU trans3_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans3_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans3_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans3_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans3_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans3_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans3_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans3_Press_TAB_ACTUAL_NUMBER; \
	MENU trans3_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans3_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans3_Press_TAB_ENTRY; \
	MENU trans3_Press_TAB_ENTRY_page; \
	COMMAND trans3_Press_TAB_ENTRY_read; \
	COMMAND trans3_Press_TAB_ENTRY_write; \
	VARIABLE trans3_Press_TAB_MAX_NUMBER; \
	MENU trans3_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans3_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans3_Press_TAB_MIN_NUMBER; \
	MENU trans3_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans3_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans3_Press_TAB_OP_CODE; \
	MENU trans3_Press_TAB_OP_CODE_page; \
	COMMAND trans3_Press_TAB_OP_CODE_read; \
	COMMAND trans3_Press_TAB_OP_CODE_write; \
	VARIABLE trans3_Press_TAB_STATUS; \
	MENU trans3_Press_TAB_STATUS_page; \
	COMMAND trans3_Press_TAB_STATUS_read; \
	COLLECTION trans3_Press_TAB_X_Y_VALUE; \
	VARIABLE trans3_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans3_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans3_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans3_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans3_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans3_Press_MAX_SENSOR_VALUE; \
	MENU trans3_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans3_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans3_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans3_Press_MIN_SENSOR_VALUE; \
	MENU trans3_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans3_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans3_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans3_Press_MAX_TEMPERATURE; \
	MENU trans3_Press_MAX_TEMPERATURE_page; \
	COMMAND trans3_Press_MAX_TEMPERATURE_read; \
	COMMAND trans3_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans3_Press_MIN_TEMPERATURE; \
	MENU trans3_Press_MIN_TEMPERATURE_page; \
	COMMAND trans3_Press_MIN_TEMPERATURE_read; \
	COMMAND trans3_Press_MIN_TEMPERATURE_write; \
	UNIT trans3_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans3_Press_Sensor_unit_2; \
	UNIT trans3_Press_Temperature_unit; \
	UNIT trans3_Press_Secondary_Value_1_unit; \
	UNIT trans3_Press_Secondary_Value_2_unit

#define USE_TRANS3_PRESS_OPTIONAL_A \
	USE_TRANS3_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans3_Press_SENSOR_VALUE; \
	MENU trans3_Press_SENSOR_VALUE_page; \
	COMMAND trans3_Press_SENSOR_VALUE_read; \
	VARIABLE trans3_Press_SENSOR_HI_LIM; \
	MENU trans3_Press_SENSOR_HI_LIM_page; \
	COMMAND trans3_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans3_Press_SENSOR_LO_LIM; \
	MENU trans3_Press_SENSOR_LO_LIM_page; \
	COMMAND trans3_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans3_Press_CAL_POINT_HI; \
	MENU trans3_Press_CAL_POINT_HI_page; \
	COMMAND trans3_Press_CAL_POINT_HI_read; \
	COMMAND trans3_Press_CAL_POINT_HI_write; \
	VARIABLE trans3_Press_CAL_POINT_LO; \
	MENU trans3_Press_CAL_POINT_LO_page; \
	COMMAND trans3_Press_CAL_POINT_LO_read; \
	COMMAND trans3_Press_CAL_POINT_LO_write; \
	VARIABLE trans3_Press_CAL_MIN_SPAN; \
	MENU trans3_Press_CAL_MIN_SPAN_page; \
	COMMAND trans3_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans3_Press_SENSOR_UNIT; \
	MENU trans3_Press_SENSOR_UNIT_page; \
	COMMAND trans3_Press_SENSOR_UNIT_read; \
	COMMAND trans3_Press_SENSOR_UNIT_write; \
	COLLECTION trans3_Press_TRIMMED_VALUE; \
	VARIABLE trans3_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans3_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans3_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans3_Press_TRIMMED_VALUE_page; \
	COMMAND trans3_Press_TRIMMED_VALUE_read; \
	VARIABLE trans3_Press_SENSOR_TYPE; \
	MENU trans3_Press_SENSOR_TYPE_page; \
	COMMAND trans3_Press_SENSOR_TYPE_read; \
	VARIABLE trans3_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans3_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans3_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans3_Press_PRIMARY_VALUE; \
	VARIABLE trans3_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans3_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans3_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans3_Press_PRIMARY_VALUE_page; \
	COMMAND trans3_Press_PRIMARY_VALUE_read; \
	VARIABLE trans3_Press_PRIMARY_VALUE_UNIT; \
	MENU trans3_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans3_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans3_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans3_Press_PRIMARY_VALUE_TYPE; \
	MENU trans3_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans3_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans3_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans3_Press_LIN_TYPE; \
	MENU trans3_Press_LIN_TYPE_page; \
	COMMAND trans3_Press_LIN_TYPE_read; \
	COMMAND trans3_Press_LIN_TYPE_write; \
	COLLECTION trans3_Press_VIEW_1; \
	MENU trans3_Press_VIEW_1_page; \
	MENU trans3_Press_Simple_Dialog_Optional_A; \
	UNIT trans3_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans3_Press_Sensor_unit_1

#define USE_TRANS3_PRESS_OPTIONAL_B \
	USE_TRANS3_PRESS_OPTIONAL_BOTH; \
	MENU trans3_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS3_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans3_Press_)
#define USE_TRANS3_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans3_Press_)
#define USE_TRANS3_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans3_Press_)
#define USE_TRANS3_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans3_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS4_PRESS_MANDATORY_BOTH \
	BLOCK trans4_Press_block; \
	COLLECTION trans4_Press_BLOCK_OBJECT; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans4_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans4_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans4_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans4_Press_BLOCK_OBJECT_page; \
	COMMAND trans4_Press_BLOCK_OBJECT_read; \
	VARIABLE trans4_Press_ST_REV; \
	MENU trans4_Press_ST_REV_page; \
	COMMAND trans4_Press_ST_REV_read; \
	VARIABLE trans4_Press_TAG_DESC; \
	MENU trans4_Press_TAG_DESC_page; \
	COMMAND trans4_Press_TAG_DESC_read; \
	COMMAND trans4_Press_TAG_DESC_write; \
	VARIABLE trans4_Press_STRATEGY; \
	MENU trans4_Press_STRATEGY_page; \
	COMMAND trans4_Press_STRATEGY_read; \
	COMMAND trans4_Press_STRATEGY_write; \
	VARIABLE trans4_Press_ALERT_KEY; \
	MENU trans4_Press_ALERT_KEY_page; \
	COMMAND trans4_Press_ALERT_KEY_read; \
	COMMAND trans4_Press_ALERT_KEY_write; \
	VARIABLE trans4_Press_TARGET_MODE; \
	MENU trans4_Press_TARGET_MODE_page; \
	COMMAND trans4_Press_TARGET_MODE_read; \
	COMMAND trans4_Press_TARGET_MODE_write; \
	COLLECTION trans4_Press_MODE_BLK; \
	VARIABLE trans4_Press_MODE_BLK_Actual; \
	VARIABLE trans4_Press_MODE_BLK_Permitted; \
	VARIABLE trans4_Press_MODE_BLK_Normal; \
	MENU trans4_Press_MODE_BLK_page; \
	COMMAND trans4_Press_MODE_BLK_read; \
	COLLECTION trans4_Press_ALARM_SUM; \
	VARIABLE trans4_Press_ALARM_SUM_Current; \
	VARIABLE trans4_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans4_Press_ALARM_SUM_Unreported; \
	VARIABLE trans4_Press_ALARM_SUM_Disabled; \
	MENU trans4_Press_ALARM_SUM_page; \
	COMMAND trans4_Press_ALARM_SUM_read

#define USE_TRANS4_PRESS_MANDATORY_A \
	USE_TRANS4_PRESS_MANDATORY_BOTH; \
	MENU trans4_Press_Simple_Dialog_Mandatory_A; \
	MENU trans4_Press_Tab_s_mandatory_A; \
	MENU trans4_Press_Tab_m_mandatory_A

#define USE_TRANS4_PRESS_MANDATORY_B \
	USE_TRANS4_PRESS_MANDATORY_BOTH; \
	VARIABLE trans4_Press_SENSOR_VALUE; \
	MENU trans4_Press_SENSOR_VALUE_page; \
	COMMAND trans4_Press_SENSOR_VALUE_read; \
	VARIABLE trans4_Press_SENSOR_HI_LIM; \
	MENU trans4_Press_SENSOR_HI_LIM_page; \
	COMMAND trans4_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans4_Press_SENSOR_LO_LIM; \
	MENU trans4_Press_SENSOR_LO_LIM_page; \
	COMMAND trans4_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans4_Press_CAL_POINT_HI; \
	MENU trans4_Press_CAL_POINT_HI_page; \
	COMMAND trans4_Press_CAL_POINT_HI_read; \
	COMMAND trans4_Press_CAL_POINT_HI_write; \
	VARIABLE trans4_Press_CAL_POINT_LO; \
	MENU trans4_Press_CAL_POINT_LO_page; \
	COMMAND trans4_Press_CAL_POINT_LO_read; \
	COMMAND trans4_Press_CAL_POINT_LO_write; \
	VARIABLE trans4_Press_CAL_MIN_SPAN; \
	MENU trans4_Press_CAL_MIN_SPAN_page; \
	COMMAND trans4_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans4_Press_SENSOR_UNIT; \
	MENU trans4_Press_SENSOR_UNIT_page; \
	COMMAND trans4_Press_SENSOR_UNIT_read; \
	COMMAND trans4_Press_SENSOR_UNIT_write; \
	COLLECTION trans4_Press_TRIMMED_VALUE; \
	VARIABLE trans4_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans4_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans4_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans4_Press_TRIMMED_VALUE_page; \
	COMMAND trans4_Press_TRIMMED_VALUE_read; \
	VARIABLE trans4_Press_SENSOR_TYPE; \
	MENU trans4_Press_SENSOR_TYPE_page; \
	COMMAND trans4_Press_SENSOR_TYPE_read; \
	VARIABLE trans4_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans4_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans4_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans4_Press_PRIMARY_VALUE; \
	VARIABLE trans4_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans4_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans4_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans4_Press_PRIMARY_VALUE_page; \
	COMMAND trans4_Press_PRIMARY_VALUE_read; \
	VARIABLE trans4_Press_PRIMARY_VALUE_UNIT; \
	MENU trans4_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans4_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans4_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans4_Press_PRIMARY_VALUE_TYPE; \
	MENU trans4_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans4_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans4_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans4_Press_LIN_TYPE; \
	MENU trans4_Press_LIN_TYPE_page; \
	COMMAND trans4_Press_LIN_TYPE_read; \
	COMMAND trans4_Press_LIN_TYPE_write; \
	COLLECTION trans4_Press_VIEW_1; \
	MENU trans4_Press_VIEW_1_page; \
	MENU trans4_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans4_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans4_Press_Sensor_unit_1; \
	MENU trans4_Press_Tab_s_mandatory_B; \
	MENU trans4_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans4_Press_Tab_s_input_table_mandatory_B; \
	MENU trans4_Press_Tab_m_mandatory_B; \
	MENU trans4_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans4_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS4_PRESS_OPTIONAL_BOTH \
	VARIABLE trans4_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans4_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans4_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans4_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans4_Press_SENSOR_FILL_FLUID; \
	MENU trans4_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans4_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans4_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans4_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans4_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans4_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans4_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans4_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans4_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans4_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans4_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans4_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans4_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans4_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans4_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans4_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans4_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans4_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans4_Press_TEMPERATURE; \
	VARIABLE trans4_Press_TEMPERATURE_Value; \
	VARIABLE trans4_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans4_Press_TEMPERATURE_Status_Limit; \
	MENU trans4_Press_TEMPERATURE_page; \
	COMMAND trans4_Press_TEMPERATURE_read; \
	VARIABLE trans4_Press_TEMPERATURE_UNIT; \
	MENU trans4_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans4_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans4_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans4_Press_SECONDARY_VALUE_1; \
	VARIABLE trans4_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans4_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans4_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans4_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans4_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans4_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans4_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans4_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans4_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans4_Press_SECONDARY_VALUE_2; \
	VARIABLE trans4_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans4_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans4_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans4_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans4_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans4_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans4_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans4_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans4_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans4_Press_SCALE_IN; \
	VARIABLE trans4_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans4_Press_SCALE_IN_Lower_Value; \
	MENU trans4_Press_SCALE_IN_page; \
	COMMAND trans4_Press_SCALE_IN_read; \
	COMMAND trans4_Press_SCALE_IN_write; \
	COLLECTION trans4_Press_SCALE_OUT; \
	VARIABLE trans4_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans4_Press_SCALE_OUT_Lower_Value; \
	MENU trans4_Press_SCALE_OUT_page; \
	COMMAND trans4_Press_SCALE_OUT_read; \
	COMMAND trans4_Press_SCALE_OUT_write; \
	VARIABLE trans4_Press_LOW_FLOW_CUT_OFF; \
	MENU trans4_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans4_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans4_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans4_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans4_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans4_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans4_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans4_Press_TAB_ACTUAL_NUMBER; \
	MENU trans4_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans4_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans4_Press_TAB_ENTRY; \
	MENU trans4_Press_TAB_ENTRY_page; \
	COMMAND trans4_Press_TAB_ENTRY_read; \
	COMMAND trans4_Press_TAB_ENTRY_write; \
	VARIABLE trans4_Press_TAB_MAX_NUMBER; \
	MENU trans4_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans4_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans4_Press_TAB_MIN_NUMBER; \
	MENU trans4_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans4_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans4_Press_TAB_OP_CODE; \
	MENU trans4_Press_TAB_OP_CODE_page; \
	COMMAND trans4_Press_TAB_OP_CODE_read; \
	COMMAND trans4_Press_TAB_OP_CODE_write; \
	VARIABLE trans4_Press_TAB_STATUS; \
	MENU trans4_Press_TAB_STATUS_page; \
	COMMAND trans4_Press_TAB_STATUS_read; \
	COLLECTION trans4_Press_TAB_X_Y_VALUE; \
	VARIABLE trans4_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans4_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans4_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans4_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans4_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans4_Press_MAX_SENSOR_VALUE; \
	MENU trans4_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans4_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans4_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans4_Press_MIN_SENSOR_VALUE; \
	MENU trans4_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans4_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans4_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans4_Press_MAX_TEMPERATURE; \
	MENU trans4_Press_MAX_TEMPERATURE_page; \
	COMMAND trans4_Press_MAX_TEMPERATURE_read; \
	COMMAND trans4_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans4_Press_MIN_TEMPERATURE; \
	MENU trans4_Press_MIN_TEMPERATURE_page; \
	COMMAND trans4_Press_MIN_TEMPERATURE_read; \
	COMMAND trans4_Press_MIN_TEMPERATURE_write; \
	UNIT trans4_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans4_Press_Sensor_unit_2; \
	UNIT trans4_Press_Temperature_unit; \
	UNIT trans4_Press_Secondary_Value_1_unit; \
	UNIT trans4_Press_Secondary_Value_2_unit

#define USE_TRANS4_PRESS_OPTIONAL_A \
	USE_TRANS4_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans4_Press_SENSOR_VALUE; \
	MENU trans4_Press_SENSOR_VALUE_page; \
	COMMAND trans4_Press_SENSOR_VALUE_read; \
	VARIABLE trans4_Press_SENSOR_HI_LIM; \
	MENU trans4_Press_SENSOR_HI_LIM_page; \
	COMMAND trans4_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans4_Press_SENSOR_LO_LIM; \
	MENU trans4_Press_SENSOR_LO_LIM_page; \
	COMMAND trans4_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans4_Press_CAL_POINT_HI; \
	MENU trans4_Press_CAL_POINT_HI_page; \
	COMMAND trans4_Press_CAL_POINT_HI_read; \
	COMMAND trans4_Press_CAL_POINT_HI_write; \
	VARIABLE trans4_Press_CAL_POINT_LO; \
	MENU trans4_Press_CAL_POINT_LO_page; \
	COMMAND trans4_Press_CAL_POINT_LO_read; \
	COMMAND trans4_Press_CAL_POINT_LO_write; \
	VARIABLE trans4_Press_CAL_MIN_SPAN; \
	MENU trans4_Press_CAL_MIN_SPAN_page; \
	COMMAND trans4_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans4_Press_SENSOR_UNIT; \
	MENU trans4_Press_SENSOR_UNIT_page; \
	COMMAND trans4_Press_SENSOR_UNIT_read; \
	COMMAND trans4_Press_SENSOR_UNIT_write; \
	COLLECTION trans4_Press_TRIMMED_VALUE; \
	VARIABLE trans4_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans4_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans4_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans4_Press_TRIMMED_VALUE_page; \
	COMMAND trans4_Press_TRIMMED_VALUE_read; \
	VARIABLE trans4_Press_SENSOR_TYPE; \
	MENU trans4_Press_SENSOR_TYPE_page; \
	COMMAND trans4_Press_SENSOR_TYPE_read; \
	VARIABLE trans4_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans4_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans4_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans4_Press_PRIMARY_VALUE; \
	VARIABLE trans4_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans4_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans4_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans4_Press_PRIMARY_VALUE_page; \
	COMMAND trans4_Press_PRIMARY_VALUE_read; \
	VARIABLE trans4_Press_PRIMARY_VALUE_UNIT; \
	MENU trans4_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans4_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans4_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans4_Press_PRIMARY_VALUE_TYPE; \
	MENU trans4_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans4_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans4_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans4_Press_LIN_TYPE; \
	MENU trans4_Press_LIN_TYPE_page; \
	COMMAND trans4_Press_LIN_TYPE_read; \
	COMMAND trans4_Press_LIN_TYPE_write; \
	COLLECTION trans4_Press_VIEW_1; \
	MENU trans4_Press_VIEW_1_page; \
	MENU trans4_Press_Simple_Dialog_Optional_A; \
	UNIT trans4_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans4_Press_Sensor_unit_1

#define USE_TRANS4_PRESS_OPTIONAL_B \
	USE_TRANS4_PRESS_OPTIONAL_BOTH; \
	MENU trans4_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS4_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans4_Press_)
#define USE_TRANS4_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans4_Press_)
#define USE_TRANS4_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans4_Press_)
#define USE_TRANS4_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans4_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS5_PRESS_MANDATORY_BOTH \
	BLOCK trans5_Press_block; \
	COLLECTION trans5_Press_BLOCK_OBJECT; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans5_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans5_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans5_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans5_Press_BLOCK_OBJECT_page; \
	COMMAND trans5_Press_BLOCK_OBJECT_read; \
	VARIABLE trans5_Press_ST_REV; \
	MENU trans5_Press_ST_REV_page; \
	COMMAND trans5_Press_ST_REV_read; \
	VARIABLE trans5_Press_TAG_DESC; \
	MENU trans5_Press_TAG_DESC_page; \
	COMMAND trans5_Press_TAG_DESC_read; \
	COMMAND trans5_Press_TAG_DESC_write; \
	VARIABLE trans5_Press_STRATEGY; \
	MENU trans5_Press_STRATEGY_page; \
	COMMAND trans5_Press_STRATEGY_read; \
	COMMAND trans5_Press_STRATEGY_write; \
	VARIABLE trans5_Press_ALERT_KEY; \
	MENU trans5_Press_ALERT_KEY_page; \
	COMMAND trans5_Press_ALERT_KEY_read; \
	COMMAND trans5_Press_ALERT_KEY_write; \
	VARIABLE trans5_Press_TARGET_MODE; \
	MENU trans5_Press_TARGET_MODE_page; \
	COMMAND trans5_Press_TARGET_MODE_read; \
	COMMAND trans5_Press_TARGET_MODE_write; \
	COLLECTION trans5_Press_MODE_BLK; \
	VARIABLE trans5_Press_MODE_BLK_Actual; \
	VARIABLE trans5_Press_MODE_BLK_Permitted; \
	VARIABLE trans5_Press_MODE_BLK_Normal; \
	MENU trans5_Press_MODE_BLK_page; \
	COMMAND trans5_Press_MODE_BLK_read; \
	COLLECTION trans5_Press_ALARM_SUM; \
	VARIABLE trans5_Press_ALARM_SUM_Current; \
	VARIABLE trans5_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans5_Press_ALARM_SUM_Unreported; \
	VARIABLE trans5_Press_ALARM_SUM_Disabled; \
	MENU trans5_Press_ALARM_SUM_page; \
	COMMAND trans5_Press_ALARM_SUM_read

#define USE_TRANS5_PRESS_MANDATORY_A \
	USE_TRANS5_PRESS_MANDATORY_BOTH; \
	MENU trans5_Press_Simple_Dialog_Mandatory_A; \
	MENU trans5_Press_Tab_s_mandatory_A; \
	MENU trans5_Press_Tab_m_mandatory_A

#define USE_TRANS5_PRESS_MANDATORY_B \
	USE_TRANS5_PRESS_MANDATORY_BOTH; \
	VARIABLE trans5_Press_SENSOR_VALUE; \
	MENU trans5_Press_SENSOR_VALUE_page; \
	COMMAND trans5_Press_SENSOR_VALUE_read; \
	VARIABLE trans5_Press_SENSOR_HI_LIM; \
	MENU trans5_Press_SENSOR_HI_LIM_page; \
	COMMAND trans5_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans5_Press_SENSOR_LO_LIM; \
	MENU trans5_Press_SENSOR_LO_LIM_page; \
	COMMAND trans5_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans5_Press_CAL_POINT_HI; \
	MENU trans5_Press_CAL_POINT_HI_page; \
	COMMAND trans5_Press_CAL_POINT_HI_read; \
	COMMAND trans5_Press_CAL_POINT_HI_write; \
	VARIABLE trans5_Press_CAL_POINT_LO; \
	MENU trans5_Press_CAL_POINT_LO_page; \
	COMMAND trans5_Press_CAL_POINT_LO_read; \
	COMMAND trans5_Press_CAL_POINT_LO_write; \
	VARIABLE trans5_Press_CAL_MIN_SPAN; \
	MENU trans5_Press_CAL_MIN_SPAN_page; \
	COMMAND trans5_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans5_Press_SENSOR_UNIT; \
	MENU trans5_Press_SENSOR_UNIT_page; \
	COMMAND trans5_Press_SENSOR_UNIT_read; \
	COMMAND trans5_Press_SENSOR_UNIT_write; \
	COLLECTION trans5_Press_TRIMMED_VALUE; \
	VARIABLE trans5_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans5_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans5_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans5_Press_TRIMMED_VALUE_page; \
	COMMAND trans5_Press_TRIMMED_VALUE_read; \
	VARIABLE trans5_Press_SENSOR_TYPE; \
	MENU trans5_Press_SENSOR_TYPE_page; \
	COMMAND trans5_Press_SENSOR_TYPE_read; \
	VARIABLE trans5_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans5_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans5_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans5_Press_PRIMARY_VALUE; \
	VARIABLE trans5_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans5_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans5_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans5_Press_PRIMARY_VALUE_page; \
	COMMAND trans5_Press_PRIMARY_VALUE_read; \
	VARIABLE trans5_Press_PRIMARY_VALUE_UNIT; \
	MENU trans5_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans5_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans5_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans5_Press_PRIMARY_VALUE_TYPE; \
	MENU trans5_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans5_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans5_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans5_Press_LIN_TYPE; \
	MENU trans5_Press_LIN_TYPE_page; \
	COMMAND trans5_Press_LIN_TYPE_read; \
	COMMAND trans5_Press_LIN_TYPE_write; \
	COLLECTION trans5_Press_VIEW_1; \
	MENU trans5_Press_VIEW_1_page; \
	MENU trans5_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans5_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans5_Press_Sensor_unit_1; \
	MENU trans5_Press_Tab_s_mandatory_B; \
	MENU trans5_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans5_Press_Tab_s_input_table_mandatory_B; \
	MENU trans5_Press_Tab_m_mandatory_B; \
	MENU trans5_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans5_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS5_PRESS_OPTIONAL_BOTH \
	VARIABLE trans5_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans5_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans5_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans5_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans5_Press_SENSOR_FILL_FLUID; \
	MENU trans5_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans5_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans5_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans5_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans5_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans5_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans5_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans5_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans5_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans5_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans5_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans5_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans5_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans5_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans5_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans5_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans5_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans5_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans5_Press_TEMPERATURE; \
	VARIABLE trans5_Press_TEMPERATURE_Value; \
	VARIABLE trans5_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans5_Press_TEMPERATURE_Status_Limit; \
	MENU trans5_Press_TEMPERATURE_page; \
	COMMAND trans5_Press_TEMPERATURE_read; \
	VARIABLE trans5_Press_TEMPERATURE_UNIT; \
	MENU trans5_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans5_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans5_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans5_Press_SECONDARY_VALUE_1; \
	VARIABLE trans5_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans5_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans5_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans5_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans5_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans5_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans5_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans5_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans5_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans5_Press_SECONDARY_VALUE_2; \
	VARIABLE trans5_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans5_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans5_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans5_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans5_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans5_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans5_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans5_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans5_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans5_Press_SCALE_IN; \
	VARIABLE trans5_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans5_Press_SCALE_IN_Lower_Value; \
	MENU trans5_Press_SCALE_IN_page; \
	COMMAND trans5_Press_SCALE_IN_read; \
	COMMAND trans5_Press_SCALE_IN_write; \
	COLLECTION trans5_Press_SCALE_OUT; \
	VARIABLE trans5_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans5_Press_SCALE_OUT_Lower_Value; \
	MENU trans5_Press_SCALE_OUT_page; \
	COMMAND trans5_Press_SCALE_OUT_read; \
	COMMAND trans5_Press_SCALE_OUT_write; \
	VARIABLE trans5_Press_LOW_FLOW_CUT_OFF; \
	MENU trans5_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans5_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans5_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans5_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans5_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans5_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans5_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans5_Press_TAB_ACTUAL_NUMBER; \
	MENU trans5_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans5_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans5_Press_TAB_ENTRY; \
	MENU trans5_Press_TAB_ENTRY_page; \
	COMMAND trans5_Press_TAB_ENTRY_read; \
	COMMAND trans5_Press_TAB_ENTRY_write; \
	VARIABLE trans5_Press_TAB_MAX_NUMBER; \
	MENU trans5_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans5_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans5_Press_TAB_MIN_NUMBER; \
	MENU trans5_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans5_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans5_Press_TAB_OP_CODE; \
	MENU trans5_Press_TAB_OP_CODE_page; \
	COMMAND trans5_Press_TAB_OP_CODE_read; \
	COMMAND trans5_Press_TAB_OP_CODE_write; \
	VARIABLE trans5_Press_TAB_STATUS; \
	MENU trans5_Press_TAB_STATUS_page; \
	COMMAND trans5_Press_TAB_STATUS_read; \
	COLLECTION trans5_Press_TAB_X_Y_VALUE; \
	VARIABLE trans5_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans5_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans5_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans5_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans5_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans5_Press_MAX_SENSOR_VALUE; \
	MENU trans5_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans5_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans5_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans5_Press_MIN_SENSOR_VALUE; \
	MENU trans5_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans5_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans5_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans5_Press_MAX_TEMPERATURE; \
	MENU trans5_Press_MAX_TEMPERATURE_page; \
	COMMAND trans5_Press_MAX_TEMPERATURE_read; \
	COMMAND trans5_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans5_Press_MIN_TEMPERATURE; \
	MENU trans5_Press_MIN_TEMPERATURE_page; \
	COMMAND trans5_Press_MIN_TEMPERATURE_read; \
	COMMAND trans5_Press_MIN_TEMPERATURE_write; \
	UNIT trans5_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans5_Press_Sensor_unit_2; \
	UNIT trans5_Press_Temperature_unit; \
	UNIT trans5_Press_Secondary_Value_1_unit; \
	UNIT trans5_Press_Secondary_Value_2_unit

#define USE_TRANS5_PRESS_OPTIONAL_A \
	USE_TRANS5_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans5_Press_SENSOR_VALUE; \
	MENU trans5_Press_SENSOR_VALUE_page; \
	COMMAND trans5_Press_SENSOR_VALUE_read; \
	VARIABLE trans5_Press_SENSOR_HI_LIM; \
	MENU trans5_Press_SENSOR_HI_LIM_page; \
	COMMAND trans5_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans5_Press_SENSOR_LO_LIM; \
	MENU trans5_Press_SENSOR_LO_LIM_page; \
	COMMAND trans5_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans5_Press_CAL_POINT_HI; \
	MENU trans5_Press_CAL_POINT_HI_page; \
	COMMAND trans5_Press_CAL_POINT_HI_read; \
	COMMAND trans5_Press_CAL_POINT_HI_write; \
	VARIABLE trans5_Press_CAL_POINT_LO; \
	MENU trans5_Press_CAL_POINT_LO_page; \
	COMMAND trans5_Press_CAL_POINT_LO_read; \
	COMMAND trans5_Press_CAL_POINT_LO_write; \
	VARIABLE trans5_Press_CAL_MIN_SPAN; \
	MENU trans5_Press_CAL_MIN_SPAN_page; \
	COMMAND trans5_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans5_Press_SENSOR_UNIT; \
	MENU trans5_Press_SENSOR_UNIT_page; \
	COMMAND trans5_Press_SENSOR_UNIT_read; \
	COMMAND trans5_Press_SENSOR_UNIT_write; \
	COLLECTION trans5_Press_TRIMMED_VALUE; \
	VARIABLE trans5_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans5_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans5_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans5_Press_TRIMMED_VALUE_page; \
	COMMAND trans5_Press_TRIMMED_VALUE_read; \
	VARIABLE trans5_Press_SENSOR_TYPE; \
	MENU trans5_Press_SENSOR_TYPE_page; \
	COMMAND trans5_Press_SENSOR_TYPE_read; \
	VARIABLE trans5_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans5_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans5_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans5_Press_PRIMARY_VALUE; \
	VARIABLE trans5_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans5_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans5_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans5_Press_PRIMARY_VALUE_page; \
	COMMAND trans5_Press_PRIMARY_VALUE_read; \
	VARIABLE trans5_Press_PRIMARY_VALUE_UNIT; \
	MENU trans5_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans5_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans5_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans5_Press_PRIMARY_VALUE_TYPE; \
	MENU trans5_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans5_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans5_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans5_Press_LIN_TYPE; \
	MENU trans5_Press_LIN_TYPE_page; \
	COMMAND trans5_Press_LIN_TYPE_read; \
	COMMAND trans5_Press_LIN_TYPE_write; \
	COLLECTION trans5_Press_VIEW_1; \
	MENU trans5_Press_VIEW_1_page; \
	MENU trans5_Press_Simple_Dialog_Optional_A; \
	UNIT trans5_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans5_Press_Sensor_unit_1

#define USE_TRANS5_PRESS_OPTIONAL_B \
	USE_TRANS5_PRESS_OPTIONAL_BOTH; \
	MENU trans5_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS5_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans5_Press_)
#define USE_TRANS5_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans5_Press_)
#define USE_TRANS5_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans5_Press_)
#define USE_TRANS5_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans5_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS6_PRESS_MANDATORY_BOTH \
	BLOCK trans6_Press_block; \
	COLLECTION trans6_Press_BLOCK_OBJECT; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans6_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans6_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans6_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans6_Press_BLOCK_OBJECT_page; \
	COMMAND trans6_Press_BLOCK_OBJECT_read; \
	VARIABLE trans6_Press_ST_REV; \
	MENU trans6_Press_ST_REV_page; \
	COMMAND trans6_Press_ST_REV_read; \
	VARIABLE trans6_Press_TAG_DESC; \
	MENU trans6_Press_TAG_DESC_page; \
	COMMAND trans6_Press_TAG_DESC_read; \
	COMMAND trans6_Press_TAG_DESC_write; \
	VARIABLE trans6_Press_STRATEGY; \
	MENU trans6_Press_STRATEGY_page; \
	COMMAND trans6_Press_STRATEGY_read; \
	COMMAND trans6_Press_STRATEGY_write; \
	VARIABLE trans6_Press_ALERT_KEY; \
	MENU trans6_Press_ALERT_KEY_page; \
	COMMAND trans6_Press_ALERT_KEY_read; \
	COMMAND trans6_Press_ALERT_KEY_write; \
	VARIABLE trans6_Press_TARGET_MODE; \
	MENU trans6_Press_TARGET_MODE_page; \
	COMMAND trans6_Press_TARGET_MODE_read; \
	COMMAND trans6_Press_TARGET_MODE_write; \
	COLLECTION trans6_Press_MODE_BLK; \
	VARIABLE trans6_Press_MODE_BLK_Actual; \
	VARIABLE trans6_Press_MODE_BLK_Permitted; \
	VARIABLE trans6_Press_MODE_BLK_Normal; \
	MENU trans6_Press_MODE_BLK_page; \
	COMMAND trans6_Press_MODE_BLK_read; \
	COLLECTION trans6_Press_ALARM_SUM; \
	VARIABLE trans6_Press_ALARM_SUM_Current; \
	VARIABLE trans6_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans6_Press_ALARM_SUM_Unreported; \
	VARIABLE trans6_Press_ALARM_SUM_Disabled; \
	MENU trans6_Press_ALARM_SUM_page; \
	COMMAND trans6_Press_ALARM_SUM_read

#define USE_TRANS6_PRESS_MANDATORY_A \
	USE_TRANS6_PRESS_MANDATORY_BOTH; \
	MENU trans6_Press_Simple_Dialog_Mandatory_A; \
	MENU trans6_Press_Tab_s_mandatory_A; \
	MENU trans6_Press_Tab_m_mandatory_A

#define USE_TRANS6_PRESS_MANDATORY_B \
	USE_TRANS6_PRESS_MANDATORY_BOTH; \
	VARIABLE trans6_Press_SENSOR_VALUE; \
	MENU trans6_Press_SENSOR_VALUE_page; \
	COMMAND trans6_Press_SENSOR_VALUE_read; \
	VARIABLE trans6_Press_SENSOR_HI_LIM; \
	MENU trans6_Press_SENSOR_HI_LIM_page; \
	COMMAND trans6_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans6_Press_SENSOR_LO_LIM; \
	MENU trans6_Press_SENSOR_LO_LIM_page; \
	COMMAND trans6_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans6_Press_CAL_POINT_HI; \
	MENU trans6_Press_CAL_POINT_HI_page; \
	COMMAND trans6_Press_CAL_POINT_HI_read; \
	COMMAND trans6_Press_CAL_POINT_HI_write; \
	VARIABLE trans6_Press_CAL_POINT_LO; \
	MENU trans6_Press_CAL_POINT_LO_page; \
	COMMAND trans6_Press_CAL_POINT_LO_read; \
	COMMAND trans6_Press_CAL_POINT_LO_write; \
	VARIABLE trans6_Press_CAL_MIN_SPAN; \
	MENU trans6_Press_CAL_MIN_SPAN_page; \
	COMMAND trans6_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans6_Press_SENSOR_UNIT; \
	MENU trans6_Press_SENSOR_UNIT_page; \
	COMMAND trans6_Press_SENSOR_UNIT_read; \
	COMMAND trans6_Press_SENSOR_UNIT_write; \
	COLLECTION trans6_Press_TRIMMED_VALUE; \
	VARIABLE trans6_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans6_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans6_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans6_Press_TRIMMED_VALUE_page; \
	COMMAND trans6_Press_TRIMMED_VALUE_read; \
	VARIABLE trans6_Press_SENSOR_TYPE; \
	MENU trans6_Press_SENSOR_TYPE_page; \
	COMMAND trans6_Press_SENSOR_TYPE_read; \
	VARIABLE trans6_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans6_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans6_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans6_Press_PRIMARY_VALUE; \
	VARIABLE trans6_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans6_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans6_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans6_Press_PRIMARY_VALUE_page; \
	COMMAND trans6_Press_PRIMARY_VALUE_read; \
	VARIABLE trans6_Press_PRIMARY_VALUE_UNIT; \
	MENU trans6_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans6_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans6_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans6_Press_PRIMARY_VALUE_TYPE; \
	MENU trans6_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans6_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans6_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans6_Press_LIN_TYPE; \
	MENU trans6_Press_LIN_TYPE_page; \
	COMMAND trans6_Press_LIN_TYPE_read; \
	COMMAND trans6_Press_LIN_TYPE_write; \
	COLLECTION trans6_Press_VIEW_1; \
	MENU trans6_Press_VIEW_1_page; \
	MENU trans6_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans6_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans6_Press_Sensor_unit_1; \
	MENU trans6_Press_Tab_s_mandatory_B; \
	MENU trans6_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans6_Press_Tab_s_input_table_mandatory_B; \
	MENU trans6_Press_Tab_m_mandatory_B; \
	MENU trans6_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans6_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS6_PRESS_OPTIONAL_BOTH \
	VARIABLE trans6_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans6_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans6_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans6_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans6_Press_SENSOR_FILL_FLUID; \
	MENU trans6_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans6_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans6_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans6_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans6_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans6_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans6_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans6_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans6_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans6_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans6_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans6_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans6_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans6_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans6_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans6_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans6_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans6_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans6_Press_TEMPERATURE; \
	VARIABLE trans6_Press_TEMPERATURE_Value; \
	VARIABLE trans6_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans6_Press_TEMPERATURE_Status_Limit; \
	MENU trans6_Press_TEMPERATURE_page; \
	COMMAND trans6_Press_TEMPERATURE_read; \
	VARIABLE trans6_Press_TEMPERATURE_UNIT; \
	MENU trans6_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans6_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans6_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans6_Press_SECONDARY_VALUE_1; \
	VARIABLE trans6_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans6_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans6_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans6_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans6_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans6_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans6_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans6_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans6_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans6_Press_SECONDARY_VALUE_2; \
	VARIABLE trans6_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans6_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans6_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans6_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans6_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans6_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans6_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans6_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans6_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans6_Press_SCALE_IN; \
	VARIABLE trans6_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans6_Press_SCALE_IN_Lower_Value; \
	MENU trans6_Press_SCALE_IN_page; \
	COMMAND trans6_Press_SCALE_IN_read; \
	COMMAND trans6_Press_SCALE_IN_write; \
	COLLECTION trans6_Press_SCALE_OUT; \
	VARIABLE trans6_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans6_Press_SCALE_OUT_Lower_Value; \
	MENU trans6_Press_SCALE_OUT_page; \
	COMMAND trans6_Press_SCALE_OUT_read; \
	COMMAND trans6_Press_SCALE_OUT_write; \
	VARIABLE trans6_Press_LOW_FLOW_CUT_OFF; \
	MENU trans6_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans6_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans6_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans6_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans6_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans6_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans6_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans6_Press_TAB_ACTUAL_NUMBER; \
	MENU trans6_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans6_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans6_Press_TAB_ENTRY; \
	MENU trans6_Press_TAB_ENTRY_page; \
	COMMAND trans6_Press_TAB_ENTRY_read; \
	COMMAND trans6_Press_TAB_ENTRY_write; \
	VARIABLE trans6_Press_TAB_MAX_NUMBER; \
	MENU trans6_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans6_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans6_Press_TAB_MIN_NUMBER; \
	MENU trans6_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans6_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans6_Press_TAB_OP_CODE; \
	MENU trans6_Press_TAB_OP_CODE_page; \
	COMMAND trans6_Press_TAB_OP_CODE_read; \
	COMMAND trans6_Press_TAB_OP_CODE_write; \
	VARIABLE trans6_Press_TAB_STATUS; \
	MENU trans6_Press_TAB_STATUS_page; \
	COMMAND trans6_Press_TAB_STATUS_read; \
	COLLECTION trans6_Press_TAB_X_Y_VALUE; \
	VARIABLE trans6_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans6_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans6_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans6_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans6_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans6_Press_MAX_SENSOR_VALUE; \
	MENU trans6_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans6_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans6_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans6_Press_MIN_SENSOR_VALUE; \
	MENU trans6_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans6_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans6_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans6_Press_MAX_TEMPERATURE; \
	MENU trans6_Press_MAX_TEMPERATURE_page; \
	COMMAND trans6_Press_MAX_TEMPERATURE_read; \
	COMMAND trans6_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans6_Press_MIN_TEMPERATURE; \
	MENU trans6_Press_MIN_TEMPERATURE_page; \
	COMMAND trans6_Press_MIN_TEMPERATURE_read; \
	COMMAND trans6_Press_MIN_TEMPERATURE_write; \
	UNIT trans6_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans6_Press_Sensor_unit_2; \
	UNIT trans6_Press_Temperature_unit; \
	UNIT trans6_Press_Secondary_Value_1_unit; \
	UNIT trans6_Press_Secondary_Value_2_unit

#define USE_TRANS6_PRESS_OPTIONAL_A \
	USE_TRANS6_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans6_Press_SENSOR_VALUE; \
	MENU trans6_Press_SENSOR_VALUE_page; \
	COMMAND trans6_Press_SENSOR_VALUE_read; \
	VARIABLE trans6_Press_SENSOR_HI_LIM; \
	MENU trans6_Press_SENSOR_HI_LIM_page; \
	COMMAND trans6_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans6_Press_SENSOR_LO_LIM; \
	MENU trans6_Press_SENSOR_LO_LIM_page; \
	COMMAND trans6_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans6_Press_CAL_POINT_HI; \
	MENU trans6_Press_CAL_POINT_HI_page; \
	COMMAND trans6_Press_CAL_POINT_HI_read; \
	COMMAND trans6_Press_CAL_POINT_HI_write; \
	VARIABLE trans6_Press_CAL_POINT_LO; \
	MENU trans6_Press_CAL_POINT_LO_page; \
	COMMAND trans6_Press_CAL_POINT_LO_read; \
	COMMAND trans6_Press_CAL_POINT_LO_write; \
	VARIABLE trans6_Press_CAL_MIN_SPAN; \
	MENU trans6_Press_CAL_MIN_SPAN_page; \
	COMMAND trans6_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans6_Press_SENSOR_UNIT; \
	MENU trans6_Press_SENSOR_UNIT_page; \
	COMMAND trans6_Press_SENSOR_UNIT_read; \
	COMMAND trans6_Press_SENSOR_UNIT_write; \
	COLLECTION trans6_Press_TRIMMED_VALUE; \
	VARIABLE trans6_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans6_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans6_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans6_Press_TRIMMED_VALUE_page; \
	COMMAND trans6_Press_TRIMMED_VALUE_read; \
	VARIABLE trans6_Press_SENSOR_TYPE; \
	MENU trans6_Press_SENSOR_TYPE_page; \
	COMMAND trans6_Press_SENSOR_TYPE_read; \
	VARIABLE trans6_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans6_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans6_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans6_Press_PRIMARY_VALUE; \
	VARIABLE trans6_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans6_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans6_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans6_Press_PRIMARY_VALUE_page; \
	COMMAND trans6_Press_PRIMARY_VALUE_read; \
	VARIABLE trans6_Press_PRIMARY_VALUE_UNIT; \
	MENU trans6_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans6_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans6_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans6_Press_PRIMARY_VALUE_TYPE; \
	MENU trans6_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans6_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans6_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans6_Press_LIN_TYPE; \
	MENU trans6_Press_LIN_TYPE_page; \
	COMMAND trans6_Press_LIN_TYPE_read; \
	COMMAND trans6_Press_LIN_TYPE_write; \
	COLLECTION trans6_Press_VIEW_1; \
	MENU trans6_Press_VIEW_1_page; \
	MENU trans6_Press_Simple_Dialog_Optional_A; \
	UNIT trans6_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans6_Press_Sensor_unit_1

#define USE_TRANS6_PRESS_OPTIONAL_B \
	USE_TRANS6_PRESS_OPTIONAL_BOTH; \
	MENU trans6_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS6_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans6_Press_)
#define USE_TRANS6_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans6_Press_)
#define USE_TRANS6_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans6_Press_)
#define USE_TRANS6_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans6_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS7_PRESS_MANDATORY_BOTH \
	BLOCK trans7_Press_block; \
	COLLECTION trans7_Press_BLOCK_OBJECT; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans7_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans7_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans7_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans7_Press_BLOCK_OBJECT_page; \
	COMMAND trans7_Press_BLOCK_OBJECT_read; \
	VARIABLE trans7_Press_ST_REV; \
	MENU trans7_Press_ST_REV_page; \
	COMMAND trans7_Press_ST_REV_read; \
	VARIABLE trans7_Press_TAG_DESC; \
	MENU trans7_Press_TAG_DESC_page; \
	COMMAND trans7_Press_TAG_DESC_read; \
	COMMAND trans7_Press_TAG_DESC_write; \
	VARIABLE trans7_Press_STRATEGY; \
	MENU trans7_Press_STRATEGY_page; \
	COMMAND trans7_Press_STRATEGY_read; \
	COMMAND trans7_Press_STRATEGY_write; \
	VARIABLE trans7_Press_ALERT_KEY; \
	MENU trans7_Press_ALERT_KEY_page; \
	COMMAND trans7_Press_ALERT_KEY_read; \
	COMMAND trans7_Press_ALERT_KEY_write; \
	VARIABLE trans7_Press_TARGET_MODE; \
	MENU trans7_Press_TARGET_MODE_page; \
	COMMAND trans7_Press_TARGET_MODE_read; \
	COMMAND trans7_Press_TARGET_MODE_write; \
	COLLECTION trans7_Press_MODE_BLK; \
	VARIABLE trans7_Press_MODE_BLK_Actual; \
	VARIABLE trans7_Press_MODE_BLK_Permitted; \
	VARIABLE trans7_Press_MODE_BLK_Normal; \
	MENU trans7_Press_MODE_BLK_page; \
	COMMAND trans7_Press_MODE_BLK_read; \
	COLLECTION trans7_Press_ALARM_SUM; \
	VARIABLE trans7_Press_ALARM_SUM_Current; \
	VARIABLE trans7_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans7_Press_ALARM_SUM_Unreported; \
	VARIABLE trans7_Press_ALARM_SUM_Disabled; \
	MENU trans7_Press_ALARM_SUM_page; \
	COMMAND trans7_Press_ALARM_SUM_read

#define USE_TRANS7_PRESS_MANDATORY_A \
	USE_TRANS7_PRESS_MANDATORY_BOTH; \
	MENU trans7_Press_Simple_Dialog_Mandatory_A; \
	MENU trans7_Press_Tab_s_mandatory_A; \
	MENU trans7_Press_Tab_m_mandatory_A

#define USE_TRANS7_PRESS_MANDATORY_B \
	USE_TRANS7_PRESS_MANDATORY_BOTH; \
	VARIABLE trans7_Press_SENSOR_VALUE; \
	MENU trans7_Press_SENSOR_VALUE_page; \
	COMMAND trans7_Press_SENSOR_VALUE_read; \
	VARIABLE trans7_Press_SENSOR_HI_LIM; \
	MENU trans7_Press_SENSOR_HI_LIM_page; \
	COMMAND trans7_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans7_Press_SENSOR_LO_LIM; \
	MENU trans7_Press_SENSOR_LO_LIM_page; \
	COMMAND trans7_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans7_Press_CAL_POINT_HI; \
	MENU trans7_Press_CAL_POINT_HI_page; \
	COMMAND trans7_Press_CAL_POINT_HI_read; \
	COMMAND trans7_Press_CAL_POINT_HI_write; \
	VARIABLE trans7_Press_CAL_POINT_LO; \
	MENU trans7_Press_CAL_POINT_LO_page; \
	COMMAND trans7_Press_CAL_POINT_LO_read; \
	COMMAND trans7_Press_CAL_POINT_LO_write; \
	VARIABLE trans7_Press_CAL_MIN_SPAN; \
	MENU trans7_Press_CAL_MIN_SPAN_page; \
	COMMAND trans7_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans7_Press_SENSOR_UNIT; \
	MENU trans7_Press_SENSOR_UNIT_page; \
	COMMAND trans7_Press_SENSOR_UNIT_read; \
	COMMAND trans7_Press_SENSOR_UNIT_write; \
	COLLECTION trans7_Press_TRIMMED_VALUE; \
	VARIABLE trans7_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans7_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans7_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans7_Press_TRIMMED_VALUE_page; \
	COMMAND trans7_Press_TRIMMED_VALUE_read; \
	VARIABLE trans7_Press_SENSOR_TYPE; \
	MENU trans7_Press_SENSOR_TYPE_page; \
	COMMAND trans7_Press_SENSOR_TYPE_read; \
	VARIABLE trans7_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans7_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans7_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans7_Press_PRIMARY_VALUE; \
	VARIABLE trans7_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans7_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans7_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans7_Press_PRIMARY_VALUE_page; \
	COMMAND trans7_Press_PRIMARY_VALUE_read; \
	VARIABLE trans7_Press_PRIMARY_VALUE_UNIT; \
	MENU trans7_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans7_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans7_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans7_Press_PRIMARY_VALUE_TYPE; \
	MENU trans7_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans7_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans7_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans7_Press_LIN_TYPE; \
	MENU trans7_Press_LIN_TYPE_page; \
	COMMAND trans7_Press_LIN_TYPE_read; \
	COMMAND trans7_Press_LIN_TYPE_write; \
	COLLECTION trans7_Press_VIEW_1; \
	MENU trans7_Press_VIEW_1_page; \
	MENU trans7_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans7_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans7_Press_Sensor_unit_1; \
	MENU trans7_Press_Tab_s_mandatory_B; \
	MENU trans7_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans7_Press_Tab_s_input_table_mandatory_B; \
	MENU trans7_Press_Tab_m_mandatory_B; \
	MENU trans7_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans7_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS7_PRESS_OPTIONAL_BOTH \
	VARIABLE trans7_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans7_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans7_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans7_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans7_Press_SENSOR_FILL_FLUID; \
	MENU trans7_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans7_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans7_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans7_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans7_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans7_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans7_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans7_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans7_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans7_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans7_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans7_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans7_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans7_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans7_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans7_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans7_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans7_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans7_Press_TEMPERATURE; \
	VARIABLE trans7_Press_TEMPERATURE_Value; \
	VARIABLE trans7_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans7_Press_TEMPERATURE_Status_Limit; \
	MENU trans7_Press_TEMPERATURE_page; \
	COMMAND trans7_Press_TEMPERATURE_read; \
	VARIABLE trans7_Press_TEMPERATURE_UNIT; \
	MENU trans7_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans7_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans7_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans7_Press_SECONDARY_VALUE_1; \
	VARIABLE trans7_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans7_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans7_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans7_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans7_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans7_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans7_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans7_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans7_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans7_Press_SECONDARY_VALUE_2; \
	VARIABLE trans7_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans7_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans7_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans7_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans7_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans7_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans7_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans7_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans7_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans7_Press_SCALE_IN; \
	VARIABLE trans7_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans7_Press_SCALE_IN_Lower_Value; \
	MENU trans7_Press_SCALE_IN_page; \
	COMMAND trans7_Press_SCALE_IN_read; \
	COMMAND trans7_Press_SCALE_IN_write; \
	COLLECTION trans7_Press_SCALE_OUT; \
	VARIABLE trans7_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans7_Press_SCALE_OUT_Lower_Value; \
	MENU trans7_Press_SCALE_OUT_page; \
	COMMAND trans7_Press_SCALE_OUT_read; \
	COMMAND trans7_Press_SCALE_OUT_write; \
	VARIABLE trans7_Press_LOW_FLOW_CUT_OFF; \
	MENU trans7_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans7_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans7_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans7_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans7_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans7_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans7_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans7_Press_TAB_ACTUAL_NUMBER; \
	MENU trans7_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans7_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans7_Press_TAB_ENTRY; \
	MENU trans7_Press_TAB_ENTRY_page; \
	COMMAND trans7_Press_TAB_ENTRY_read; \
	COMMAND trans7_Press_TAB_ENTRY_write; \
	VARIABLE trans7_Press_TAB_MAX_NUMBER; \
	MENU trans7_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans7_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans7_Press_TAB_MIN_NUMBER; \
	MENU trans7_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans7_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans7_Press_TAB_OP_CODE; \
	MENU trans7_Press_TAB_OP_CODE_page; \
	COMMAND trans7_Press_TAB_OP_CODE_read; \
	COMMAND trans7_Press_TAB_OP_CODE_write; \
	VARIABLE trans7_Press_TAB_STATUS; \
	MENU trans7_Press_TAB_STATUS_page; \
	COMMAND trans7_Press_TAB_STATUS_read; \
	COLLECTION trans7_Press_TAB_X_Y_VALUE; \
	VARIABLE trans7_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans7_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans7_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans7_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans7_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans7_Press_MAX_SENSOR_VALUE; \
	MENU trans7_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans7_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans7_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans7_Press_MIN_SENSOR_VALUE; \
	MENU trans7_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans7_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans7_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans7_Press_MAX_TEMPERATURE; \
	MENU trans7_Press_MAX_TEMPERATURE_page; \
	COMMAND trans7_Press_MAX_TEMPERATURE_read; \
	COMMAND trans7_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans7_Press_MIN_TEMPERATURE; \
	MENU trans7_Press_MIN_TEMPERATURE_page; \
	COMMAND trans7_Press_MIN_TEMPERATURE_read; \
	COMMAND trans7_Press_MIN_TEMPERATURE_write; \
	UNIT trans7_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans7_Press_Sensor_unit_2; \
	UNIT trans7_Press_Temperature_unit; \
	UNIT trans7_Press_Secondary_Value_1_unit; \
	UNIT trans7_Press_Secondary_Value_2_unit

#define USE_TRANS7_PRESS_OPTIONAL_A \
	USE_TRANS7_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans7_Press_SENSOR_VALUE; \
	MENU trans7_Press_SENSOR_VALUE_page; \
	COMMAND trans7_Press_SENSOR_VALUE_read; \
	VARIABLE trans7_Press_SENSOR_HI_LIM; \
	MENU trans7_Press_SENSOR_HI_LIM_page; \
	COMMAND trans7_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans7_Press_SENSOR_LO_LIM; \
	MENU trans7_Press_SENSOR_LO_LIM_page; \
	COMMAND trans7_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans7_Press_CAL_POINT_HI; \
	MENU trans7_Press_CAL_POINT_HI_page; \
	COMMAND trans7_Press_CAL_POINT_HI_read; \
	COMMAND trans7_Press_CAL_POINT_HI_write; \
	VARIABLE trans7_Press_CAL_POINT_LO; \
	MENU trans7_Press_CAL_POINT_LO_page; \
	COMMAND trans7_Press_CAL_POINT_LO_read; \
	COMMAND trans7_Press_CAL_POINT_LO_write; \
	VARIABLE trans7_Press_CAL_MIN_SPAN; \
	MENU trans7_Press_CAL_MIN_SPAN_page; \
	COMMAND trans7_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans7_Press_SENSOR_UNIT; \
	MENU trans7_Press_SENSOR_UNIT_page; \
	COMMAND trans7_Press_SENSOR_UNIT_read; \
	COMMAND trans7_Press_SENSOR_UNIT_write; \
	COLLECTION trans7_Press_TRIMMED_VALUE; \
	VARIABLE trans7_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans7_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans7_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans7_Press_TRIMMED_VALUE_page; \
	COMMAND trans7_Press_TRIMMED_VALUE_read; \
	VARIABLE trans7_Press_SENSOR_TYPE; \
	MENU trans7_Press_SENSOR_TYPE_page; \
	COMMAND trans7_Press_SENSOR_TYPE_read; \
	VARIABLE trans7_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans7_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans7_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans7_Press_PRIMARY_VALUE; \
	VARIABLE trans7_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans7_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans7_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans7_Press_PRIMARY_VALUE_page; \
	COMMAND trans7_Press_PRIMARY_VALUE_read; \
	VARIABLE trans7_Press_PRIMARY_VALUE_UNIT; \
	MENU trans7_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans7_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans7_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans7_Press_PRIMARY_VALUE_TYPE; \
	MENU trans7_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans7_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans7_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans7_Press_LIN_TYPE; \
	MENU trans7_Press_LIN_TYPE_page; \
	COMMAND trans7_Press_LIN_TYPE_read; \
	COMMAND trans7_Press_LIN_TYPE_write; \
	COLLECTION trans7_Press_VIEW_1; \
	MENU trans7_Press_VIEW_1_page; \
	MENU trans7_Press_Simple_Dialog_Optional_A; \
	UNIT trans7_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans7_Press_Sensor_unit_1

#define USE_TRANS7_PRESS_OPTIONAL_B \
	USE_TRANS7_PRESS_OPTIONAL_BOTH; \
	MENU trans7_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS7_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans7_Press_)
#define USE_TRANS7_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans7_Press_)
#define USE_TRANS7_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans7_Press_)
#define USE_TRANS7_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans7_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS8_PRESS_MANDATORY_BOTH \
	BLOCK trans8_Press_block; \
	COLLECTION trans8_Press_BLOCK_OBJECT; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans8_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans8_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans8_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans8_Press_BLOCK_OBJECT_page; \
	COMMAND trans8_Press_BLOCK_OBJECT_read; \
	VARIABLE trans8_Press_ST_REV; \
	MENU trans8_Press_ST_REV_page; \
	COMMAND trans8_Press_ST_REV_read; \
	VARIABLE trans8_Press_TAG_DESC; \
	MENU trans8_Press_TAG_DESC_page; \
	COMMAND trans8_Press_TAG_DESC_read; \
	COMMAND trans8_Press_TAG_DESC_write; \
	VARIABLE trans8_Press_STRATEGY; \
	MENU trans8_Press_STRATEGY_page; \
	COMMAND trans8_Press_STRATEGY_read; \
	COMMAND trans8_Press_STRATEGY_write; \
	VARIABLE trans8_Press_ALERT_KEY; \
	MENU trans8_Press_ALERT_KEY_page; \
	COMMAND trans8_Press_ALERT_KEY_read; \
	COMMAND trans8_Press_ALERT_KEY_write; \
	VARIABLE trans8_Press_TARGET_MODE; \
	MENU trans8_Press_TARGET_MODE_page; \
	COMMAND trans8_Press_TARGET_MODE_read; \
	COMMAND trans8_Press_TARGET_MODE_write; \
	COLLECTION trans8_Press_MODE_BLK; \
	VARIABLE trans8_Press_MODE_BLK_Actual; \
	VARIABLE trans8_Press_MODE_BLK_Permitted; \
	VARIABLE trans8_Press_MODE_BLK_Normal; \
	MENU trans8_Press_MODE_BLK_page; \
	COMMAND trans8_Press_MODE_BLK_read; \
	COLLECTION trans8_Press_ALARM_SUM; \
	VARIABLE trans8_Press_ALARM_SUM_Current; \
	VARIABLE trans8_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans8_Press_ALARM_SUM_Unreported; \
	VARIABLE trans8_Press_ALARM_SUM_Disabled; \
	MENU trans8_Press_ALARM_SUM_page; \
	COMMAND trans8_Press_ALARM_SUM_read

#define USE_TRANS8_PRESS_MANDATORY_A \
	USE_TRANS8_PRESS_MANDATORY_BOTH; \
	MENU trans8_Press_Simple_Dialog_Mandatory_A; \
	MENU trans8_Press_Tab_s_mandatory_A; \
	MENU trans8_Press_Tab_m_mandatory_A

#define USE_TRANS8_PRESS_MANDATORY_B \
	USE_TRANS8_PRESS_MANDATORY_BOTH; \
	VARIABLE trans8_Press_SENSOR_VALUE; \
	MENU trans8_Press_SENSOR_VALUE_page; \
	COMMAND trans8_Press_SENSOR_VALUE_read; \
	VARIABLE trans8_Press_SENSOR_HI_LIM; \
	MENU trans8_Press_SENSOR_HI_LIM_page; \
	COMMAND trans8_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans8_Press_SENSOR_LO_LIM; \
	MENU trans8_Press_SENSOR_LO_LIM_page; \
	COMMAND trans8_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans8_Press_CAL_POINT_HI; \
	MENU trans8_Press_CAL_POINT_HI_page; \
	COMMAND trans8_Press_CAL_POINT_HI_read; \
	COMMAND trans8_Press_CAL_POINT_HI_write; \
	VARIABLE trans8_Press_CAL_POINT_LO; \
	MENU trans8_Press_CAL_POINT_LO_page; \
	COMMAND trans8_Press_CAL_POINT_LO_read; \
	COMMAND trans8_Press_CAL_POINT_LO_write; \
	VARIABLE trans8_Press_CAL_MIN_SPAN; \
	MENU trans8_Press_CAL_MIN_SPAN_page; \
	COMMAND trans8_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans8_Press_SENSOR_UNIT; \
	MENU trans8_Press_SENSOR_UNIT_page; \
	COMMAND trans8_Press_SENSOR_UNIT_read; \
	COMMAND trans8_Press_SENSOR_UNIT_write; \
	COLLECTION trans8_Press_TRIMMED_VALUE; \
	VARIABLE trans8_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans8_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans8_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans8_Press_TRIMMED_VALUE_page; \
	COMMAND trans8_Press_TRIMMED_VALUE_read; \
	VARIABLE trans8_Press_SENSOR_TYPE; \
	MENU trans8_Press_SENSOR_TYPE_page; \
	COMMAND trans8_Press_SENSOR_TYPE_read; \
	VARIABLE trans8_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans8_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans8_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans8_Press_PRIMARY_VALUE; \
	VARIABLE trans8_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans8_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans8_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans8_Press_PRIMARY_VALUE_page; \
	COMMAND trans8_Press_PRIMARY_VALUE_read; \
	VARIABLE trans8_Press_PRIMARY_VALUE_UNIT; \
	MENU trans8_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans8_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans8_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans8_Press_PRIMARY_VALUE_TYPE; \
	MENU trans8_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans8_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans8_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans8_Press_LIN_TYPE; \
	MENU trans8_Press_LIN_TYPE_page; \
	COMMAND trans8_Press_LIN_TYPE_read; \
	COMMAND trans8_Press_LIN_TYPE_write; \
	COLLECTION trans8_Press_VIEW_1; \
	MENU trans8_Press_VIEW_1_page; \
	MENU trans8_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans8_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans8_Press_Sensor_unit_1; \
	MENU trans8_Press_Tab_s_mandatory_B; \
	MENU trans8_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans8_Press_Tab_s_input_table_mandatory_B; \
	MENU trans8_Press_Tab_m_mandatory_B; \
	MENU trans8_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans8_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS8_PRESS_OPTIONAL_BOTH \
	VARIABLE trans8_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans8_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans8_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans8_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans8_Press_SENSOR_FILL_FLUID; \
	MENU trans8_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans8_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans8_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans8_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans8_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans8_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans8_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans8_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans8_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans8_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans8_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans8_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans8_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans8_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans8_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans8_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans8_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans8_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans8_Press_TEMPERATURE; \
	VARIABLE trans8_Press_TEMPERATURE_Value; \
	VARIABLE trans8_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans8_Press_TEMPERATURE_Status_Limit; \
	MENU trans8_Press_TEMPERATURE_page; \
	COMMAND trans8_Press_TEMPERATURE_read; \
	VARIABLE trans8_Press_TEMPERATURE_UNIT; \
	MENU trans8_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans8_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans8_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans8_Press_SECONDARY_VALUE_1; \
	VARIABLE trans8_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans8_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans8_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans8_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans8_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans8_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans8_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans8_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans8_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans8_Press_SECONDARY_VALUE_2; \
	VARIABLE trans8_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans8_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans8_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans8_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans8_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans8_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans8_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans8_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans8_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans8_Press_SCALE_IN; \
	VARIABLE trans8_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans8_Press_SCALE_IN_Lower_Value; \
	MENU trans8_Press_SCALE_IN_page; \
	COMMAND trans8_Press_SCALE_IN_read; \
	COMMAND trans8_Press_SCALE_IN_write; \
	COLLECTION trans8_Press_SCALE_OUT; \
	VARIABLE trans8_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans8_Press_SCALE_OUT_Lower_Value; \
	MENU trans8_Press_SCALE_OUT_page; \
	COMMAND trans8_Press_SCALE_OUT_read; \
	COMMAND trans8_Press_SCALE_OUT_write; \
	VARIABLE trans8_Press_LOW_FLOW_CUT_OFF; \
	MENU trans8_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans8_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans8_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans8_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans8_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans8_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans8_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans8_Press_TAB_ACTUAL_NUMBER; \
	MENU trans8_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans8_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans8_Press_TAB_ENTRY; \
	MENU trans8_Press_TAB_ENTRY_page; \
	COMMAND trans8_Press_TAB_ENTRY_read; \
	COMMAND trans8_Press_TAB_ENTRY_write; \
	VARIABLE trans8_Press_TAB_MAX_NUMBER; \
	MENU trans8_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans8_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans8_Press_TAB_MIN_NUMBER; \
	MENU trans8_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans8_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans8_Press_TAB_OP_CODE; \
	MENU trans8_Press_TAB_OP_CODE_page; \
	COMMAND trans8_Press_TAB_OP_CODE_read; \
	COMMAND trans8_Press_TAB_OP_CODE_write; \
	VARIABLE trans8_Press_TAB_STATUS; \
	MENU trans8_Press_TAB_STATUS_page; \
	COMMAND trans8_Press_TAB_STATUS_read; \
	COLLECTION trans8_Press_TAB_X_Y_VALUE; \
	VARIABLE trans8_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans8_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans8_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans8_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans8_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans8_Press_MAX_SENSOR_VALUE; \
	MENU trans8_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans8_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans8_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans8_Press_MIN_SENSOR_VALUE; \
	MENU trans8_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans8_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans8_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans8_Press_MAX_TEMPERATURE; \
	MENU trans8_Press_MAX_TEMPERATURE_page; \
	COMMAND trans8_Press_MAX_TEMPERATURE_read; \
	COMMAND trans8_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans8_Press_MIN_TEMPERATURE; \
	MENU trans8_Press_MIN_TEMPERATURE_page; \
	COMMAND trans8_Press_MIN_TEMPERATURE_read; \
	COMMAND trans8_Press_MIN_TEMPERATURE_write; \
	UNIT trans8_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans8_Press_Sensor_unit_2; \
	UNIT trans8_Press_Temperature_unit; \
	UNIT trans8_Press_Secondary_Value_1_unit; \
	UNIT trans8_Press_Secondary_Value_2_unit

#define USE_TRANS8_PRESS_OPTIONAL_A \
	USE_TRANS8_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans8_Press_SENSOR_VALUE; \
	MENU trans8_Press_SENSOR_VALUE_page; \
	COMMAND trans8_Press_SENSOR_VALUE_read; \
	VARIABLE trans8_Press_SENSOR_HI_LIM; \
	MENU trans8_Press_SENSOR_HI_LIM_page; \
	COMMAND trans8_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans8_Press_SENSOR_LO_LIM; \
	MENU trans8_Press_SENSOR_LO_LIM_page; \
	COMMAND trans8_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans8_Press_CAL_POINT_HI; \
	MENU trans8_Press_CAL_POINT_HI_page; \
	COMMAND trans8_Press_CAL_POINT_HI_read; \
	COMMAND trans8_Press_CAL_POINT_HI_write; \
	VARIABLE trans8_Press_CAL_POINT_LO; \
	MENU trans8_Press_CAL_POINT_LO_page; \
	COMMAND trans8_Press_CAL_POINT_LO_read; \
	COMMAND trans8_Press_CAL_POINT_LO_write; \
	VARIABLE trans8_Press_CAL_MIN_SPAN; \
	MENU trans8_Press_CAL_MIN_SPAN_page; \
	COMMAND trans8_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans8_Press_SENSOR_UNIT; \
	MENU trans8_Press_SENSOR_UNIT_page; \
	COMMAND trans8_Press_SENSOR_UNIT_read; \
	COMMAND trans8_Press_SENSOR_UNIT_write; \
	COLLECTION trans8_Press_TRIMMED_VALUE; \
	VARIABLE trans8_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans8_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans8_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans8_Press_TRIMMED_VALUE_page; \
	COMMAND trans8_Press_TRIMMED_VALUE_read; \
	VARIABLE trans8_Press_SENSOR_TYPE; \
	MENU trans8_Press_SENSOR_TYPE_page; \
	COMMAND trans8_Press_SENSOR_TYPE_read; \
	VARIABLE trans8_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans8_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans8_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans8_Press_PRIMARY_VALUE; \
	VARIABLE trans8_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans8_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans8_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans8_Press_PRIMARY_VALUE_page; \
	COMMAND trans8_Press_PRIMARY_VALUE_read; \
	VARIABLE trans8_Press_PRIMARY_VALUE_UNIT; \
	MENU trans8_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans8_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans8_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans8_Press_PRIMARY_VALUE_TYPE; \
	MENU trans8_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans8_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans8_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans8_Press_LIN_TYPE; \
	MENU trans8_Press_LIN_TYPE_page; \
	COMMAND trans8_Press_LIN_TYPE_read; \
	COMMAND trans8_Press_LIN_TYPE_write; \
	COLLECTION trans8_Press_VIEW_1; \
	MENU trans8_Press_VIEW_1_page; \
	MENU trans8_Press_Simple_Dialog_Optional_A; \
	UNIT trans8_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans8_Press_Sensor_unit_1

#define USE_TRANS8_PRESS_OPTIONAL_B \
	USE_TRANS8_PRESS_OPTIONAL_BOTH; \
	MENU trans8_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS8_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans8_Press_)
#define USE_TRANS8_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans8_Press_)
#define USE_TRANS8_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans8_Press_)
#define USE_TRANS8_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans8_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS9_PRESS_MANDATORY_BOTH \
	BLOCK trans9_Press_block; \
	COLLECTION trans9_Press_BLOCK_OBJECT; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans9_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans9_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans9_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans9_Press_BLOCK_OBJECT_page; \
	COMMAND trans9_Press_BLOCK_OBJECT_read; \
	VARIABLE trans9_Press_ST_REV; \
	MENU trans9_Press_ST_REV_page; \
	COMMAND trans9_Press_ST_REV_read; \
	VARIABLE trans9_Press_TAG_DESC; \
	MENU trans9_Press_TAG_DESC_page; \
	COMMAND trans9_Press_TAG_DESC_read; \
	COMMAND trans9_Press_TAG_DESC_write; \
	VARIABLE trans9_Press_STRATEGY; \
	MENU trans9_Press_STRATEGY_page; \
	COMMAND trans9_Press_STRATEGY_read; \
	COMMAND trans9_Press_STRATEGY_write; \
	VARIABLE trans9_Press_ALERT_KEY; \
	MENU trans9_Press_ALERT_KEY_page; \
	COMMAND trans9_Press_ALERT_KEY_read; \
	COMMAND trans9_Press_ALERT_KEY_write; \
	VARIABLE trans9_Press_TARGET_MODE; \
	MENU trans9_Press_TARGET_MODE_page; \
	COMMAND trans9_Press_TARGET_MODE_read; \
	COMMAND trans9_Press_TARGET_MODE_write; \
	COLLECTION trans9_Press_MODE_BLK; \
	VARIABLE trans9_Press_MODE_BLK_Actual; \
	VARIABLE trans9_Press_MODE_BLK_Permitted; \
	VARIABLE trans9_Press_MODE_BLK_Normal; \
	MENU trans9_Press_MODE_BLK_page; \
	COMMAND trans9_Press_MODE_BLK_read; \
	COLLECTION trans9_Press_ALARM_SUM; \
	VARIABLE trans9_Press_ALARM_SUM_Current; \
	VARIABLE trans9_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans9_Press_ALARM_SUM_Unreported; \
	VARIABLE trans9_Press_ALARM_SUM_Disabled; \
	MENU trans9_Press_ALARM_SUM_page; \
	COMMAND trans9_Press_ALARM_SUM_read

#define USE_TRANS9_PRESS_MANDATORY_A \
	USE_TRANS9_PRESS_MANDATORY_BOTH; \
	MENU trans9_Press_Simple_Dialog_Mandatory_A; \
	MENU trans9_Press_Tab_s_mandatory_A; \
	MENU trans9_Press_Tab_m_mandatory_A

#define USE_TRANS9_PRESS_MANDATORY_B \
	USE_TRANS9_PRESS_MANDATORY_BOTH; \
	VARIABLE trans9_Press_SENSOR_VALUE; \
	MENU trans9_Press_SENSOR_VALUE_page; \
	COMMAND trans9_Press_SENSOR_VALUE_read; \
	VARIABLE trans9_Press_SENSOR_HI_LIM; \
	MENU trans9_Press_SENSOR_HI_LIM_page; \
	COMMAND trans9_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans9_Press_SENSOR_LO_LIM; \
	MENU trans9_Press_SENSOR_LO_LIM_page; \
	COMMAND trans9_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans9_Press_CAL_POINT_HI; \
	MENU trans9_Press_CAL_POINT_HI_page; \
	COMMAND trans9_Press_CAL_POINT_HI_read; \
	COMMAND trans9_Press_CAL_POINT_HI_write; \
	VARIABLE trans9_Press_CAL_POINT_LO; \
	MENU trans9_Press_CAL_POINT_LO_page; \
	COMMAND trans9_Press_CAL_POINT_LO_read; \
	COMMAND trans9_Press_CAL_POINT_LO_write; \
	VARIABLE trans9_Press_CAL_MIN_SPAN; \
	MENU trans9_Press_CAL_MIN_SPAN_page; \
	COMMAND trans9_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans9_Press_SENSOR_UNIT; \
	MENU trans9_Press_SENSOR_UNIT_page; \
	COMMAND trans9_Press_SENSOR_UNIT_read; \
	COMMAND trans9_Press_SENSOR_UNIT_write; \
	COLLECTION trans9_Press_TRIMMED_VALUE; \
	VARIABLE trans9_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans9_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans9_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans9_Press_TRIMMED_VALUE_page; \
	COMMAND trans9_Press_TRIMMED_VALUE_read; \
	VARIABLE trans9_Press_SENSOR_TYPE; \
	MENU trans9_Press_SENSOR_TYPE_page; \
	COMMAND trans9_Press_SENSOR_TYPE_read; \
	VARIABLE trans9_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans9_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans9_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans9_Press_PRIMARY_VALUE; \
	VARIABLE trans9_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans9_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans9_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans9_Press_PRIMARY_VALUE_page; \
	COMMAND trans9_Press_PRIMARY_VALUE_read; \
	VARIABLE trans9_Press_PRIMARY_VALUE_UNIT; \
	MENU trans9_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans9_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans9_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans9_Press_PRIMARY_VALUE_TYPE; \
	MENU trans9_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans9_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans9_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans9_Press_LIN_TYPE; \
	MENU trans9_Press_LIN_TYPE_page; \
	COMMAND trans9_Press_LIN_TYPE_read; \
	COMMAND trans9_Press_LIN_TYPE_write; \
	COLLECTION trans9_Press_VIEW_1; \
	MENU trans9_Press_VIEW_1_page; \
	MENU trans9_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans9_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans9_Press_Sensor_unit_1; \
	MENU trans9_Press_Tab_s_mandatory_B; \
	MENU trans9_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans9_Press_Tab_s_input_table_mandatory_B; \
	MENU trans9_Press_Tab_m_mandatory_B; \
	MENU trans9_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans9_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS9_PRESS_OPTIONAL_BOTH \
	VARIABLE trans9_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans9_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans9_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans9_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans9_Press_SENSOR_FILL_FLUID; \
	MENU trans9_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans9_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans9_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans9_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans9_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans9_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans9_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans9_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans9_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans9_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans9_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans9_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans9_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans9_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans9_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans9_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans9_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans9_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans9_Press_TEMPERATURE; \
	VARIABLE trans9_Press_TEMPERATURE_Value; \
	VARIABLE trans9_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans9_Press_TEMPERATURE_Status_Limit; \
	MENU trans9_Press_TEMPERATURE_page; \
	COMMAND trans9_Press_TEMPERATURE_read; \
	VARIABLE trans9_Press_TEMPERATURE_UNIT; \
	MENU trans9_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans9_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans9_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans9_Press_SECONDARY_VALUE_1; \
	VARIABLE trans9_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans9_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans9_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans9_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans9_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans9_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans9_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans9_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans9_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans9_Press_SECONDARY_VALUE_2; \
	VARIABLE trans9_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans9_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans9_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans9_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans9_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans9_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans9_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans9_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans9_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans9_Press_SCALE_IN; \
	VARIABLE trans9_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans9_Press_SCALE_IN_Lower_Value; \
	MENU trans9_Press_SCALE_IN_page; \
	COMMAND trans9_Press_SCALE_IN_read; \
	COMMAND trans9_Press_SCALE_IN_write; \
	COLLECTION trans9_Press_SCALE_OUT; \
	VARIABLE trans9_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans9_Press_SCALE_OUT_Lower_Value; \
	MENU trans9_Press_SCALE_OUT_page; \
	COMMAND trans9_Press_SCALE_OUT_read; \
	COMMAND trans9_Press_SCALE_OUT_write; \
	VARIABLE trans9_Press_LOW_FLOW_CUT_OFF; \
	MENU trans9_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans9_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans9_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans9_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans9_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans9_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans9_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans9_Press_TAB_ACTUAL_NUMBER; \
	MENU trans9_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans9_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans9_Press_TAB_ENTRY; \
	MENU trans9_Press_TAB_ENTRY_page; \
	COMMAND trans9_Press_TAB_ENTRY_read; \
	COMMAND trans9_Press_TAB_ENTRY_write; \
	VARIABLE trans9_Press_TAB_MAX_NUMBER; \
	MENU trans9_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans9_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans9_Press_TAB_MIN_NUMBER; \
	MENU trans9_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans9_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans9_Press_TAB_OP_CODE; \
	MENU trans9_Press_TAB_OP_CODE_page; \
	COMMAND trans9_Press_TAB_OP_CODE_read; \
	COMMAND trans9_Press_TAB_OP_CODE_write; \
	VARIABLE trans9_Press_TAB_STATUS; \
	MENU trans9_Press_TAB_STATUS_page; \
	COMMAND trans9_Press_TAB_STATUS_read; \
	COLLECTION trans9_Press_TAB_X_Y_VALUE; \
	VARIABLE trans9_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans9_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans9_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans9_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans9_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans9_Press_MAX_SENSOR_VALUE; \
	MENU trans9_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans9_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans9_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans9_Press_MIN_SENSOR_VALUE; \
	MENU trans9_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans9_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans9_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans9_Press_MAX_TEMPERATURE; \
	MENU trans9_Press_MAX_TEMPERATURE_page; \
	COMMAND trans9_Press_MAX_TEMPERATURE_read; \
	COMMAND trans9_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans9_Press_MIN_TEMPERATURE; \
	MENU trans9_Press_MIN_TEMPERATURE_page; \
	COMMAND trans9_Press_MIN_TEMPERATURE_read; \
	COMMAND trans9_Press_MIN_TEMPERATURE_write; \
	UNIT trans9_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans9_Press_Sensor_unit_2; \
	UNIT trans9_Press_Temperature_unit; \
	UNIT trans9_Press_Secondary_Value_1_unit; \
	UNIT trans9_Press_Secondary_Value_2_unit

#define USE_TRANS9_PRESS_OPTIONAL_A \
	USE_TRANS9_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans9_Press_SENSOR_VALUE; \
	MENU trans9_Press_SENSOR_VALUE_page; \
	COMMAND trans9_Press_SENSOR_VALUE_read; \
	VARIABLE trans9_Press_SENSOR_HI_LIM; \
	MENU trans9_Press_SENSOR_HI_LIM_page; \
	COMMAND trans9_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans9_Press_SENSOR_LO_LIM; \
	MENU trans9_Press_SENSOR_LO_LIM_page; \
	COMMAND trans9_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans9_Press_CAL_POINT_HI; \
	MENU trans9_Press_CAL_POINT_HI_page; \
	COMMAND trans9_Press_CAL_POINT_HI_read; \
	COMMAND trans9_Press_CAL_POINT_HI_write; \
	VARIABLE trans9_Press_CAL_POINT_LO; \
	MENU trans9_Press_CAL_POINT_LO_page; \
	COMMAND trans9_Press_CAL_POINT_LO_read; \
	COMMAND trans9_Press_CAL_POINT_LO_write; \
	VARIABLE trans9_Press_CAL_MIN_SPAN; \
	MENU trans9_Press_CAL_MIN_SPAN_page; \
	COMMAND trans9_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans9_Press_SENSOR_UNIT; \
	MENU trans9_Press_SENSOR_UNIT_page; \
	COMMAND trans9_Press_SENSOR_UNIT_read; \
	COMMAND trans9_Press_SENSOR_UNIT_write; \
	COLLECTION trans9_Press_TRIMMED_VALUE; \
	VARIABLE trans9_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans9_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans9_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans9_Press_TRIMMED_VALUE_page; \
	COMMAND trans9_Press_TRIMMED_VALUE_read; \
	VARIABLE trans9_Press_SENSOR_TYPE; \
	MENU trans9_Press_SENSOR_TYPE_page; \
	COMMAND trans9_Press_SENSOR_TYPE_read; \
	VARIABLE trans9_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans9_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans9_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans9_Press_PRIMARY_VALUE; \
	VARIABLE trans9_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans9_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans9_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans9_Press_PRIMARY_VALUE_page; \
	COMMAND trans9_Press_PRIMARY_VALUE_read; \
	VARIABLE trans9_Press_PRIMARY_VALUE_UNIT; \
	MENU trans9_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans9_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans9_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans9_Press_PRIMARY_VALUE_TYPE; \
	MENU trans9_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans9_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans9_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans9_Press_LIN_TYPE; \
	MENU trans9_Press_LIN_TYPE_page; \
	COMMAND trans9_Press_LIN_TYPE_read; \
	COMMAND trans9_Press_LIN_TYPE_write; \
	COLLECTION trans9_Press_VIEW_1; \
	MENU trans9_Press_VIEW_1_page; \
	MENU trans9_Press_Simple_Dialog_Optional_A; \
	UNIT trans9_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans9_Press_Sensor_unit_1

#define USE_TRANS9_PRESS_OPTIONAL_B \
	USE_TRANS9_PRESS_OPTIONAL_BOTH; \
	MENU trans9_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS9_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans9_Press_)
#define USE_TRANS9_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans9_Press_)
#define USE_TRANS9_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans9_Press_)
#define USE_TRANS9_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans9_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS10_PRESS_MANDATORY_BOTH \
	BLOCK trans10_Press_block; \
	COLLECTION trans10_Press_BLOCK_OBJECT; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans10_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans10_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans10_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans10_Press_BLOCK_OBJECT_page; \
	COMMAND trans10_Press_BLOCK_OBJECT_read; \
	VARIABLE trans10_Press_ST_REV; \
	MENU trans10_Press_ST_REV_page; \
	COMMAND trans10_Press_ST_REV_read; \
	VARIABLE trans10_Press_TAG_DESC; \
	MENU trans10_Press_TAG_DESC_page; \
	COMMAND trans10_Press_TAG_DESC_read; \
	COMMAND trans10_Press_TAG_DESC_write; \
	VARIABLE trans10_Press_STRATEGY; \
	MENU trans10_Press_STRATEGY_page; \
	COMMAND trans10_Press_STRATEGY_read; \
	COMMAND trans10_Press_STRATEGY_write; \
	VARIABLE trans10_Press_ALERT_KEY; \
	MENU trans10_Press_ALERT_KEY_page; \
	COMMAND trans10_Press_ALERT_KEY_read; \
	COMMAND trans10_Press_ALERT_KEY_write; \
	VARIABLE trans10_Press_TARGET_MODE; \
	MENU trans10_Press_TARGET_MODE_page; \
	COMMAND trans10_Press_TARGET_MODE_read; \
	COMMAND trans10_Press_TARGET_MODE_write; \
	COLLECTION trans10_Press_MODE_BLK; \
	VARIABLE trans10_Press_MODE_BLK_Actual; \
	VARIABLE trans10_Press_MODE_BLK_Permitted; \
	VARIABLE trans10_Press_MODE_BLK_Normal; \
	MENU trans10_Press_MODE_BLK_page; \
	COMMAND trans10_Press_MODE_BLK_read; \
	COLLECTION trans10_Press_ALARM_SUM; \
	VARIABLE trans10_Press_ALARM_SUM_Current; \
	VARIABLE trans10_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans10_Press_ALARM_SUM_Unreported; \
	VARIABLE trans10_Press_ALARM_SUM_Disabled; \
	MENU trans10_Press_ALARM_SUM_page; \
	COMMAND trans10_Press_ALARM_SUM_read

#define USE_TRANS10_PRESS_MANDATORY_A \
	USE_TRANS10_PRESS_MANDATORY_BOTH; \
	MENU trans10_Press_Simple_Dialog_Mandatory_A; \
	MENU trans10_Press_Tab_s_mandatory_A; \
	MENU trans10_Press_Tab_m_mandatory_A

#define USE_TRANS10_PRESS_MANDATORY_B \
	USE_TRANS10_PRESS_MANDATORY_BOTH; \
	VARIABLE trans10_Press_SENSOR_VALUE; \
	MENU trans10_Press_SENSOR_VALUE_page; \
	COMMAND trans10_Press_SENSOR_VALUE_read; \
	VARIABLE trans10_Press_SENSOR_HI_LIM; \
	MENU trans10_Press_SENSOR_HI_LIM_page; \
	COMMAND trans10_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans10_Press_SENSOR_LO_LIM; \
	MENU trans10_Press_SENSOR_LO_LIM_page; \
	COMMAND trans10_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans10_Press_CAL_POINT_HI; \
	MENU trans10_Press_CAL_POINT_HI_page; \
	COMMAND trans10_Press_CAL_POINT_HI_read; \
	COMMAND trans10_Press_CAL_POINT_HI_write; \
	VARIABLE trans10_Press_CAL_POINT_LO; \
	MENU trans10_Press_CAL_POINT_LO_page; \
	COMMAND trans10_Press_CAL_POINT_LO_read; \
	COMMAND trans10_Press_CAL_POINT_LO_write; \
	VARIABLE trans10_Press_CAL_MIN_SPAN; \
	MENU trans10_Press_CAL_MIN_SPAN_page; \
	COMMAND trans10_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans10_Press_SENSOR_UNIT; \
	MENU trans10_Press_SENSOR_UNIT_page; \
	COMMAND trans10_Press_SENSOR_UNIT_read; \
	COMMAND trans10_Press_SENSOR_UNIT_write; \
	COLLECTION trans10_Press_TRIMMED_VALUE; \
	VARIABLE trans10_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans10_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans10_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans10_Press_TRIMMED_VALUE_page; \
	COMMAND trans10_Press_TRIMMED_VALUE_read; \
	VARIABLE trans10_Press_SENSOR_TYPE; \
	MENU trans10_Press_SENSOR_TYPE_page; \
	COMMAND trans10_Press_SENSOR_TYPE_read; \
	VARIABLE trans10_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans10_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans10_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans10_Press_PRIMARY_VALUE; \
	VARIABLE trans10_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans10_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans10_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans10_Press_PRIMARY_VALUE_page; \
	COMMAND trans10_Press_PRIMARY_VALUE_read; \
	VARIABLE trans10_Press_PRIMARY_VALUE_UNIT; \
	MENU trans10_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans10_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans10_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans10_Press_PRIMARY_VALUE_TYPE; \
	MENU trans10_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans10_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans10_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans10_Press_LIN_TYPE; \
	MENU trans10_Press_LIN_TYPE_page; \
	COMMAND trans10_Press_LIN_TYPE_read; \
	COMMAND trans10_Press_LIN_TYPE_write; \
	COLLECTION trans10_Press_VIEW_1; \
	MENU trans10_Press_VIEW_1_page; \
	MENU trans10_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans10_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans10_Press_Sensor_unit_1; \
	MENU trans10_Press_Tab_s_mandatory_B; \
	MENU trans10_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans10_Press_Tab_s_input_table_mandatory_B; \
	MENU trans10_Press_Tab_m_mandatory_B; \
	MENU trans10_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans10_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS10_PRESS_OPTIONAL_BOTH \
	VARIABLE trans10_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans10_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans10_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans10_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans10_Press_SENSOR_FILL_FLUID; \
	MENU trans10_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans10_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans10_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans10_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans10_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans10_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans10_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans10_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans10_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans10_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans10_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans10_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans10_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans10_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans10_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans10_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans10_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans10_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans10_Press_TEMPERATURE; \
	VARIABLE trans10_Press_TEMPERATURE_Value; \
	VARIABLE trans10_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans10_Press_TEMPERATURE_Status_Limit; \
	MENU trans10_Press_TEMPERATURE_page; \
	COMMAND trans10_Press_TEMPERATURE_read; \
	VARIABLE trans10_Press_TEMPERATURE_UNIT; \
	MENU trans10_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans10_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans10_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans10_Press_SECONDARY_VALUE_1; \
	VARIABLE trans10_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans10_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans10_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans10_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans10_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans10_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans10_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans10_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans10_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans10_Press_SECONDARY_VALUE_2; \
	VARIABLE trans10_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans10_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans10_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans10_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans10_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans10_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans10_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans10_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans10_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans10_Press_SCALE_IN; \
	VARIABLE trans10_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans10_Press_SCALE_IN_Lower_Value; \
	MENU trans10_Press_SCALE_IN_page; \
	COMMAND trans10_Press_SCALE_IN_read; \
	COMMAND trans10_Press_SCALE_IN_write; \
	COLLECTION trans10_Press_SCALE_OUT; \
	VARIABLE trans10_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans10_Press_SCALE_OUT_Lower_Value; \
	MENU trans10_Press_SCALE_OUT_page; \
	COMMAND trans10_Press_SCALE_OUT_read; \
	COMMAND trans10_Press_SCALE_OUT_write; \
	VARIABLE trans10_Press_LOW_FLOW_CUT_OFF; \
	MENU trans10_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans10_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans10_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans10_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans10_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans10_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans10_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans10_Press_TAB_ACTUAL_NUMBER; \
	MENU trans10_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans10_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans10_Press_TAB_ENTRY; \
	MENU trans10_Press_TAB_ENTRY_page; \
	COMMAND trans10_Press_TAB_ENTRY_read; \
	COMMAND trans10_Press_TAB_ENTRY_write; \
	VARIABLE trans10_Press_TAB_MAX_NUMBER; \
	MENU trans10_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans10_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans10_Press_TAB_MIN_NUMBER; \
	MENU trans10_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans10_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans10_Press_TAB_OP_CODE; \
	MENU trans10_Press_TAB_OP_CODE_page; \
	COMMAND trans10_Press_TAB_OP_CODE_read; \
	COMMAND trans10_Press_TAB_OP_CODE_write; \
	VARIABLE trans10_Press_TAB_STATUS; \
	MENU trans10_Press_TAB_STATUS_page; \
	COMMAND trans10_Press_TAB_STATUS_read; \
	COLLECTION trans10_Press_TAB_X_Y_VALUE; \
	VARIABLE trans10_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans10_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans10_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans10_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans10_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans10_Press_MAX_SENSOR_VALUE; \
	MENU trans10_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans10_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans10_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans10_Press_MIN_SENSOR_VALUE; \
	MENU trans10_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans10_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans10_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans10_Press_MAX_TEMPERATURE; \
	MENU trans10_Press_MAX_TEMPERATURE_page; \
	COMMAND trans10_Press_MAX_TEMPERATURE_read; \
	COMMAND trans10_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans10_Press_MIN_TEMPERATURE; \
	MENU trans10_Press_MIN_TEMPERATURE_page; \
	COMMAND trans10_Press_MIN_TEMPERATURE_read; \
	COMMAND trans10_Press_MIN_TEMPERATURE_write; \
	UNIT trans10_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans10_Press_Sensor_unit_2; \
	UNIT trans10_Press_Temperature_unit; \
	UNIT trans10_Press_Secondary_Value_1_unit; \
	UNIT trans10_Press_Secondary_Value_2_unit

#define USE_TRANS10_PRESS_OPTIONAL_A \
	USE_TRANS10_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans10_Press_SENSOR_VALUE; \
	MENU trans10_Press_SENSOR_VALUE_page; \
	COMMAND trans10_Press_SENSOR_VALUE_read; \
	VARIABLE trans10_Press_SENSOR_HI_LIM; \
	MENU trans10_Press_SENSOR_HI_LIM_page; \
	COMMAND trans10_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans10_Press_SENSOR_LO_LIM; \
	MENU trans10_Press_SENSOR_LO_LIM_page; \
	COMMAND trans10_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans10_Press_CAL_POINT_HI; \
	MENU trans10_Press_CAL_POINT_HI_page; \
	COMMAND trans10_Press_CAL_POINT_HI_read; \
	COMMAND trans10_Press_CAL_POINT_HI_write; \
	VARIABLE trans10_Press_CAL_POINT_LO; \
	MENU trans10_Press_CAL_POINT_LO_page; \
	COMMAND trans10_Press_CAL_POINT_LO_read; \
	COMMAND trans10_Press_CAL_POINT_LO_write; \
	VARIABLE trans10_Press_CAL_MIN_SPAN; \
	MENU trans10_Press_CAL_MIN_SPAN_page; \
	COMMAND trans10_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans10_Press_SENSOR_UNIT; \
	MENU trans10_Press_SENSOR_UNIT_page; \
	COMMAND trans10_Press_SENSOR_UNIT_read; \
	COMMAND trans10_Press_SENSOR_UNIT_write; \
	COLLECTION trans10_Press_TRIMMED_VALUE; \
	VARIABLE trans10_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans10_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans10_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans10_Press_TRIMMED_VALUE_page; \
	COMMAND trans10_Press_TRIMMED_VALUE_read; \
	VARIABLE trans10_Press_SENSOR_TYPE; \
	MENU trans10_Press_SENSOR_TYPE_page; \
	COMMAND trans10_Press_SENSOR_TYPE_read; \
	VARIABLE trans10_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans10_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans10_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans10_Press_PRIMARY_VALUE; \
	VARIABLE trans10_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans10_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans10_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans10_Press_PRIMARY_VALUE_page; \
	COMMAND trans10_Press_PRIMARY_VALUE_read; \
	VARIABLE trans10_Press_PRIMARY_VALUE_UNIT; \
	MENU trans10_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans10_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans10_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans10_Press_PRIMARY_VALUE_TYPE; \
	MENU trans10_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans10_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans10_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans10_Press_LIN_TYPE; \
	MENU trans10_Press_LIN_TYPE_page; \
	COMMAND trans10_Press_LIN_TYPE_read; \
	COMMAND trans10_Press_LIN_TYPE_write; \
	COLLECTION trans10_Press_VIEW_1; \
	MENU trans10_Press_VIEW_1_page; \
	MENU trans10_Press_Simple_Dialog_Optional_A; \
	UNIT trans10_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans10_Press_Sensor_unit_1

#define USE_TRANS10_PRESS_OPTIONAL_B \
	USE_TRANS10_PRESS_OPTIONAL_BOTH; \
	MENU trans10_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS10_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans10_Press_)
#define USE_TRANS10_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans10_Press_)
#define USE_TRANS10_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans10_Press_)
#define USE_TRANS10_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans10_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS11_PRESS_MANDATORY_BOTH \
	BLOCK trans11_Press_block; \
	COLLECTION trans11_Press_BLOCK_OBJECT; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans11_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans11_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans11_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans11_Press_BLOCK_OBJECT_page; \
	COMMAND trans11_Press_BLOCK_OBJECT_read; \
	VARIABLE trans11_Press_ST_REV; \
	MENU trans11_Press_ST_REV_page; \
	COMMAND trans11_Press_ST_REV_read; \
	VARIABLE trans11_Press_TAG_DESC; \
	MENU trans11_Press_TAG_DESC_page; \
	COMMAND trans11_Press_TAG_DESC_read; \
	COMMAND trans11_Press_TAG_DESC_write; \
	VARIABLE trans11_Press_STRATEGY; \
	MENU trans11_Press_STRATEGY_page; \
	COMMAND trans11_Press_STRATEGY_read; \
	COMMAND trans11_Press_STRATEGY_write; \
	VARIABLE trans11_Press_ALERT_KEY; \
	MENU trans11_Press_ALERT_KEY_page; \
	COMMAND trans11_Press_ALERT_KEY_read; \
	COMMAND trans11_Press_ALERT_KEY_write; \
	VARIABLE trans11_Press_TARGET_MODE; \
	MENU trans11_Press_TARGET_MODE_page; \
	COMMAND trans11_Press_TARGET_MODE_read; \
	COMMAND trans11_Press_TARGET_MODE_write; \
	COLLECTION trans11_Press_MODE_BLK; \
	VARIABLE trans11_Press_MODE_BLK_Actual; \
	VARIABLE trans11_Press_MODE_BLK_Permitted; \
	VARIABLE trans11_Press_MODE_BLK_Normal; \
	MENU trans11_Press_MODE_BLK_page; \
	COMMAND trans11_Press_MODE_BLK_read; \
	COLLECTION trans11_Press_ALARM_SUM; \
	VARIABLE trans11_Press_ALARM_SUM_Current; \
	VARIABLE trans11_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans11_Press_ALARM_SUM_Unreported; \
	VARIABLE trans11_Press_ALARM_SUM_Disabled; \
	MENU trans11_Press_ALARM_SUM_page; \
	COMMAND trans11_Press_ALARM_SUM_read

#define USE_TRANS11_PRESS_MANDATORY_A \
	USE_TRANS11_PRESS_MANDATORY_BOTH; \
	MENU trans11_Press_Simple_Dialog_Mandatory_A; \
	MENU trans11_Press_Tab_s_mandatory_A; \
	MENU trans11_Press_Tab_m_mandatory_A

#define USE_TRANS11_PRESS_MANDATORY_B \
	USE_TRANS11_PRESS_MANDATORY_BOTH; \
	VARIABLE trans11_Press_SENSOR_VALUE; \
	MENU trans11_Press_SENSOR_VALUE_page; \
	COMMAND trans11_Press_SENSOR_VALUE_read; \
	VARIABLE trans11_Press_SENSOR_HI_LIM; \
	MENU trans11_Press_SENSOR_HI_LIM_page; \
	COMMAND trans11_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans11_Press_SENSOR_LO_LIM; \
	MENU trans11_Press_SENSOR_LO_LIM_page; \
	COMMAND trans11_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans11_Press_CAL_POINT_HI; \
	MENU trans11_Press_CAL_POINT_HI_page; \
	COMMAND trans11_Press_CAL_POINT_HI_read; \
	COMMAND trans11_Press_CAL_POINT_HI_write; \
	VARIABLE trans11_Press_CAL_POINT_LO; \
	MENU trans11_Press_CAL_POINT_LO_page; \
	COMMAND trans11_Press_CAL_POINT_LO_read; \
	COMMAND trans11_Press_CAL_POINT_LO_write; \
	VARIABLE trans11_Press_CAL_MIN_SPAN; \
	MENU trans11_Press_CAL_MIN_SPAN_page; \
	COMMAND trans11_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans11_Press_SENSOR_UNIT; \
	MENU trans11_Press_SENSOR_UNIT_page; \
	COMMAND trans11_Press_SENSOR_UNIT_read; \
	COMMAND trans11_Press_SENSOR_UNIT_write; \
	COLLECTION trans11_Press_TRIMMED_VALUE; \
	VARIABLE trans11_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans11_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans11_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans11_Press_TRIMMED_VALUE_page; \
	COMMAND trans11_Press_TRIMMED_VALUE_read; \
	VARIABLE trans11_Press_SENSOR_TYPE; \
	MENU trans11_Press_SENSOR_TYPE_page; \
	COMMAND trans11_Press_SENSOR_TYPE_read; \
	VARIABLE trans11_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans11_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans11_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans11_Press_PRIMARY_VALUE; \
	VARIABLE trans11_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans11_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans11_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans11_Press_PRIMARY_VALUE_page; \
	COMMAND trans11_Press_PRIMARY_VALUE_read; \
	VARIABLE trans11_Press_PRIMARY_VALUE_UNIT; \
	MENU trans11_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans11_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans11_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans11_Press_PRIMARY_VALUE_TYPE; \
	MENU trans11_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans11_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans11_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans11_Press_LIN_TYPE; \
	MENU trans11_Press_LIN_TYPE_page; \
	COMMAND trans11_Press_LIN_TYPE_read; \
	COMMAND trans11_Press_LIN_TYPE_write; \
	COLLECTION trans11_Press_VIEW_1; \
	MENU trans11_Press_VIEW_1_page; \
	MENU trans11_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans11_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans11_Press_Sensor_unit_1; \
	MENU trans11_Press_Tab_s_mandatory_B; \
	MENU trans11_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans11_Press_Tab_s_input_table_mandatory_B; \
	MENU trans11_Press_Tab_m_mandatory_B; \
	MENU trans11_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans11_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS11_PRESS_OPTIONAL_BOTH \
	VARIABLE trans11_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans11_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans11_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans11_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans11_Press_SENSOR_FILL_FLUID; \
	MENU trans11_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans11_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans11_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans11_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans11_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans11_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans11_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans11_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans11_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans11_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans11_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans11_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans11_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans11_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans11_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans11_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans11_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans11_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans11_Press_TEMPERATURE; \
	VARIABLE trans11_Press_TEMPERATURE_Value; \
	VARIABLE trans11_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans11_Press_TEMPERATURE_Status_Limit; \
	MENU trans11_Press_TEMPERATURE_page; \
	COMMAND trans11_Press_TEMPERATURE_read; \
	VARIABLE trans11_Press_TEMPERATURE_UNIT; \
	MENU trans11_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans11_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans11_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans11_Press_SECONDARY_VALUE_1; \
	VARIABLE trans11_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans11_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans11_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans11_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans11_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans11_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans11_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans11_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans11_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans11_Press_SECONDARY_VALUE_2; \
	VARIABLE trans11_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans11_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans11_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans11_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans11_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans11_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans11_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans11_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans11_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans11_Press_SCALE_IN; \
	VARIABLE trans11_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans11_Press_SCALE_IN_Lower_Value; \
	MENU trans11_Press_SCALE_IN_page; \
	COMMAND trans11_Press_SCALE_IN_read; \
	COMMAND trans11_Press_SCALE_IN_write; \
	COLLECTION trans11_Press_SCALE_OUT; \
	VARIABLE trans11_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans11_Press_SCALE_OUT_Lower_Value; \
	MENU trans11_Press_SCALE_OUT_page; \
	COMMAND trans11_Press_SCALE_OUT_read; \
	COMMAND trans11_Press_SCALE_OUT_write; \
	VARIABLE trans11_Press_LOW_FLOW_CUT_OFF; \
	MENU trans11_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans11_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans11_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans11_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans11_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans11_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans11_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans11_Press_TAB_ACTUAL_NUMBER; \
	MENU trans11_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans11_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans11_Press_TAB_ENTRY; \
	MENU trans11_Press_TAB_ENTRY_page; \
	COMMAND trans11_Press_TAB_ENTRY_read; \
	COMMAND trans11_Press_TAB_ENTRY_write; \
	VARIABLE trans11_Press_TAB_MAX_NUMBER; \
	MENU trans11_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans11_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans11_Press_TAB_MIN_NUMBER; \
	MENU trans11_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans11_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans11_Press_TAB_OP_CODE; \
	MENU trans11_Press_TAB_OP_CODE_page; \
	COMMAND trans11_Press_TAB_OP_CODE_read; \
	COMMAND trans11_Press_TAB_OP_CODE_write; \
	VARIABLE trans11_Press_TAB_STATUS; \
	MENU trans11_Press_TAB_STATUS_page; \
	COMMAND trans11_Press_TAB_STATUS_read; \
	COLLECTION trans11_Press_TAB_X_Y_VALUE; \
	VARIABLE trans11_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans11_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans11_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans11_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans11_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans11_Press_MAX_SENSOR_VALUE; \
	MENU trans11_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans11_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans11_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans11_Press_MIN_SENSOR_VALUE; \
	MENU trans11_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans11_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans11_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans11_Press_MAX_TEMPERATURE; \
	MENU trans11_Press_MAX_TEMPERATURE_page; \
	COMMAND trans11_Press_MAX_TEMPERATURE_read; \
	COMMAND trans11_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans11_Press_MIN_TEMPERATURE; \
	MENU trans11_Press_MIN_TEMPERATURE_page; \
	COMMAND trans11_Press_MIN_TEMPERATURE_read; \
	COMMAND trans11_Press_MIN_TEMPERATURE_write; \
	UNIT trans11_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans11_Press_Sensor_unit_2; \
	UNIT trans11_Press_Temperature_unit; \
	UNIT trans11_Press_Secondary_Value_1_unit; \
	UNIT trans11_Press_Secondary_Value_2_unit

#define USE_TRANS11_PRESS_OPTIONAL_A \
	USE_TRANS11_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans11_Press_SENSOR_VALUE; \
	MENU trans11_Press_SENSOR_VALUE_page; \
	COMMAND trans11_Press_SENSOR_VALUE_read; \
	VARIABLE trans11_Press_SENSOR_HI_LIM; \
	MENU trans11_Press_SENSOR_HI_LIM_page; \
	COMMAND trans11_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans11_Press_SENSOR_LO_LIM; \
	MENU trans11_Press_SENSOR_LO_LIM_page; \
	COMMAND trans11_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans11_Press_CAL_POINT_HI; \
	MENU trans11_Press_CAL_POINT_HI_page; \
	COMMAND trans11_Press_CAL_POINT_HI_read; \
	COMMAND trans11_Press_CAL_POINT_HI_write; \
	VARIABLE trans11_Press_CAL_POINT_LO; \
	MENU trans11_Press_CAL_POINT_LO_page; \
	COMMAND trans11_Press_CAL_POINT_LO_read; \
	COMMAND trans11_Press_CAL_POINT_LO_write; \
	VARIABLE trans11_Press_CAL_MIN_SPAN; \
	MENU trans11_Press_CAL_MIN_SPAN_page; \
	COMMAND trans11_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans11_Press_SENSOR_UNIT; \
	MENU trans11_Press_SENSOR_UNIT_page; \
	COMMAND trans11_Press_SENSOR_UNIT_read; \
	COMMAND trans11_Press_SENSOR_UNIT_write; \
	COLLECTION trans11_Press_TRIMMED_VALUE; \
	VARIABLE trans11_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans11_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans11_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans11_Press_TRIMMED_VALUE_page; \
	COMMAND trans11_Press_TRIMMED_VALUE_read; \
	VARIABLE trans11_Press_SENSOR_TYPE; \
	MENU trans11_Press_SENSOR_TYPE_page; \
	COMMAND trans11_Press_SENSOR_TYPE_read; \
	VARIABLE trans11_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans11_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans11_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans11_Press_PRIMARY_VALUE; \
	VARIABLE trans11_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans11_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans11_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans11_Press_PRIMARY_VALUE_page; \
	COMMAND trans11_Press_PRIMARY_VALUE_read; \
	VARIABLE trans11_Press_PRIMARY_VALUE_UNIT; \
	MENU trans11_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans11_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans11_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans11_Press_PRIMARY_VALUE_TYPE; \
	MENU trans11_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans11_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans11_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans11_Press_LIN_TYPE; \
	MENU trans11_Press_LIN_TYPE_page; \
	COMMAND trans11_Press_LIN_TYPE_read; \
	COMMAND trans11_Press_LIN_TYPE_write; \
	COLLECTION trans11_Press_VIEW_1; \
	MENU trans11_Press_VIEW_1_page; \
	MENU trans11_Press_Simple_Dialog_Optional_A; \
	UNIT trans11_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans11_Press_Sensor_unit_1

#define USE_TRANS11_PRESS_OPTIONAL_B \
	USE_TRANS11_PRESS_OPTIONAL_BOTH; \
	MENU trans11_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS11_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans11_Press_)
#define USE_TRANS11_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans11_Press_)
#define USE_TRANS11_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans11_Press_)
#define USE_TRANS11_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans11_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS12_PRESS_MANDATORY_BOTH \
	BLOCK trans12_Press_block; \
	COLLECTION trans12_Press_BLOCK_OBJECT; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans12_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans12_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans12_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans12_Press_BLOCK_OBJECT_page; \
	COMMAND trans12_Press_BLOCK_OBJECT_read; \
	VARIABLE trans12_Press_ST_REV; \
	MENU trans12_Press_ST_REV_page; \
	COMMAND trans12_Press_ST_REV_read; \
	VARIABLE trans12_Press_TAG_DESC; \
	MENU trans12_Press_TAG_DESC_page; \
	COMMAND trans12_Press_TAG_DESC_read; \
	COMMAND trans12_Press_TAG_DESC_write; \
	VARIABLE trans12_Press_STRATEGY; \
	MENU trans12_Press_STRATEGY_page; \
	COMMAND trans12_Press_STRATEGY_read; \
	COMMAND trans12_Press_STRATEGY_write; \
	VARIABLE trans12_Press_ALERT_KEY; \
	MENU trans12_Press_ALERT_KEY_page; \
	COMMAND trans12_Press_ALERT_KEY_read; \
	COMMAND trans12_Press_ALERT_KEY_write; \
	VARIABLE trans12_Press_TARGET_MODE; \
	MENU trans12_Press_TARGET_MODE_page; \
	COMMAND trans12_Press_TARGET_MODE_read; \
	COMMAND trans12_Press_TARGET_MODE_write; \
	COLLECTION trans12_Press_MODE_BLK; \
	VARIABLE trans12_Press_MODE_BLK_Actual; \
	VARIABLE trans12_Press_MODE_BLK_Permitted; \
	VARIABLE trans12_Press_MODE_BLK_Normal; \
	MENU trans12_Press_MODE_BLK_page; \
	COMMAND trans12_Press_MODE_BLK_read; \
	COLLECTION trans12_Press_ALARM_SUM; \
	VARIABLE trans12_Press_ALARM_SUM_Current; \
	VARIABLE trans12_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans12_Press_ALARM_SUM_Unreported; \
	VARIABLE trans12_Press_ALARM_SUM_Disabled; \
	MENU trans12_Press_ALARM_SUM_page; \
	COMMAND trans12_Press_ALARM_SUM_read

#define USE_TRANS12_PRESS_MANDATORY_A \
	USE_TRANS12_PRESS_MANDATORY_BOTH; \
	MENU trans12_Press_Simple_Dialog_Mandatory_A; \
	MENU trans12_Press_Tab_s_mandatory_A; \
	MENU trans12_Press_Tab_m_mandatory_A

#define USE_TRANS12_PRESS_MANDATORY_B \
	USE_TRANS12_PRESS_MANDATORY_BOTH; \
	VARIABLE trans12_Press_SENSOR_VALUE; \
	MENU trans12_Press_SENSOR_VALUE_page; \
	COMMAND trans12_Press_SENSOR_VALUE_read; \
	VARIABLE trans12_Press_SENSOR_HI_LIM; \
	MENU trans12_Press_SENSOR_HI_LIM_page; \
	COMMAND trans12_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans12_Press_SENSOR_LO_LIM; \
	MENU trans12_Press_SENSOR_LO_LIM_page; \
	COMMAND trans12_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans12_Press_CAL_POINT_HI; \
	MENU trans12_Press_CAL_POINT_HI_page; \
	COMMAND trans12_Press_CAL_POINT_HI_read; \
	COMMAND trans12_Press_CAL_POINT_HI_write; \
	VARIABLE trans12_Press_CAL_POINT_LO; \
	MENU trans12_Press_CAL_POINT_LO_page; \
	COMMAND trans12_Press_CAL_POINT_LO_read; \
	COMMAND trans12_Press_CAL_POINT_LO_write; \
	VARIABLE trans12_Press_CAL_MIN_SPAN; \
	MENU trans12_Press_CAL_MIN_SPAN_page; \
	COMMAND trans12_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans12_Press_SENSOR_UNIT; \
	MENU trans12_Press_SENSOR_UNIT_page; \
	COMMAND trans12_Press_SENSOR_UNIT_read; \
	COMMAND trans12_Press_SENSOR_UNIT_write; \
	COLLECTION trans12_Press_TRIMMED_VALUE; \
	VARIABLE trans12_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans12_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans12_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans12_Press_TRIMMED_VALUE_page; \
	COMMAND trans12_Press_TRIMMED_VALUE_read; \
	VARIABLE trans12_Press_SENSOR_TYPE; \
	MENU trans12_Press_SENSOR_TYPE_page; \
	COMMAND trans12_Press_SENSOR_TYPE_read; \
	VARIABLE trans12_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans12_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans12_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans12_Press_PRIMARY_VALUE; \
	VARIABLE trans12_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans12_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans12_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans12_Press_PRIMARY_VALUE_page; \
	COMMAND trans12_Press_PRIMARY_VALUE_read; \
	VARIABLE trans12_Press_PRIMARY_VALUE_UNIT; \
	MENU trans12_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans12_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans12_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans12_Press_PRIMARY_VALUE_TYPE; \
	MENU trans12_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans12_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans12_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans12_Press_LIN_TYPE; \
	MENU trans12_Press_LIN_TYPE_page; \
	COMMAND trans12_Press_LIN_TYPE_read; \
	COMMAND trans12_Press_LIN_TYPE_write; \
	COLLECTION trans12_Press_VIEW_1; \
	MENU trans12_Press_VIEW_1_page; \
	MENU trans12_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans12_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans12_Press_Sensor_unit_1; \
	MENU trans12_Press_Tab_s_mandatory_B; \
	MENU trans12_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans12_Press_Tab_s_input_table_mandatory_B; \
	MENU trans12_Press_Tab_m_mandatory_B; \
	MENU trans12_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans12_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS12_PRESS_OPTIONAL_BOTH \
	VARIABLE trans12_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans12_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans12_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans12_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans12_Press_SENSOR_FILL_FLUID; \
	MENU trans12_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans12_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans12_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans12_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans12_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans12_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans12_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans12_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans12_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans12_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans12_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans12_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans12_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans12_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans12_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans12_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans12_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans12_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans12_Press_TEMPERATURE; \
	VARIABLE trans12_Press_TEMPERATURE_Value; \
	VARIABLE trans12_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans12_Press_TEMPERATURE_Status_Limit; \
	MENU trans12_Press_TEMPERATURE_page; \
	COMMAND trans12_Press_TEMPERATURE_read; \
	VARIABLE trans12_Press_TEMPERATURE_UNIT; \
	MENU trans12_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans12_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans12_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans12_Press_SECONDARY_VALUE_1; \
	VARIABLE trans12_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans12_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans12_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans12_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans12_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans12_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans12_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans12_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans12_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans12_Press_SECONDARY_VALUE_2; \
	VARIABLE trans12_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans12_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans12_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans12_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans12_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans12_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans12_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans12_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans12_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans12_Press_SCALE_IN; \
	VARIABLE trans12_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans12_Press_SCALE_IN_Lower_Value; \
	MENU trans12_Press_SCALE_IN_page; \
	COMMAND trans12_Press_SCALE_IN_read; \
	COMMAND trans12_Press_SCALE_IN_write; \
	COLLECTION trans12_Press_SCALE_OUT; \
	VARIABLE trans12_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans12_Press_SCALE_OUT_Lower_Value; \
	MENU trans12_Press_SCALE_OUT_page; \
	COMMAND trans12_Press_SCALE_OUT_read; \
	COMMAND trans12_Press_SCALE_OUT_write; \
	VARIABLE trans12_Press_LOW_FLOW_CUT_OFF; \
	MENU trans12_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans12_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans12_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans12_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans12_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans12_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans12_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans12_Press_TAB_ACTUAL_NUMBER; \
	MENU trans12_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans12_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans12_Press_TAB_ENTRY; \
	MENU trans12_Press_TAB_ENTRY_page; \
	COMMAND trans12_Press_TAB_ENTRY_read; \
	COMMAND trans12_Press_TAB_ENTRY_write; \
	VARIABLE trans12_Press_TAB_MAX_NUMBER; \
	MENU trans12_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans12_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans12_Press_TAB_MIN_NUMBER; \
	MENU trans12_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans12_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans12_Press_TAB_OP_CODE; \
	MENU trans12_Press_TAB_OP_CODE_page; \
	COMMAND trans12_Press_TAB_OP_CODE_read; \
	COMMAND trans12_Press_TAB_OP_CODE_write; \
	VARIABLE trans12_Press_TAB_STATUS; \
	MENU trans12_Press_TAB_STATUS_page; \
	COMMAND trans12_Press_TAB_STATUS_read; \
	COLLECTION trans12_Press_TAB_X_Y_VALUE; \
	VARIABLE trans12_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans12_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans12_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans12_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans12_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans12_Press_MAX_SENSOR_VALUE; \
	MENU trans12_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans12_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans12_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans12_Press_MIN_SENSOR_VALUE; \
	MENU trans12_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans12_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans12_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans12_Press_MAX_TEMPERATURE; \
	MENU trans12_Press_MAX_TEMPERATURE_page; \
	COMMAND trans12_Press_MAX_TEMPERATURE_read; \
	COMMAND trans12_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans12_Press_MIN_TEMPERATURE; \
	MENU trans12_Press_MIN_TEMPERATURE_page; \
	COMMAND trans12_Press_MIN_TEMPERATURE_read; \
	COMMAND trans12_Press_MIN_TEMPERATURE_write; \
	UNIT trans12_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans12_Press_Sensor_unit_2; \
	UNIT trans12_Press_Temperature_unit; \
	UNIT trans12_Press_Secondary_Value_1_unit; \
	UNIT trans12_Press_Secondary_Value_2_unit

#define USE_TRANS12_PRESS_OPTIONAL_A \
	USE_TRANS12_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans12_Press_SENSOR_VALUE; \
	MENU trans12_Press_SENSOR_VALUE_page; \
	COMMAND trans12_Press_SENSOR_VALUE_read; \
	VARIABLE trans12_Press_SENSOR_HI_LIM; \
	MENU trans12_Press_SENSOR_HI_LIM_page; \
	COMMAND trans12_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans12_Press_SENSOR_LO_LIM; \
	MENU trans12_Press_SENSOR_LO_LIM_page; \
	COMMAND trans12_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans12_Press_CAL_POINT_HI; \
	MENU trans12_Press_CAL_POINT_HI_page; \
	COMMAND trans12_Press_CAL_POINT_HI_read; \
	COMMAND trans12_Press_CAL_POINT_HI_write; \
	VARIABLE trans12_Press_CAL_POINT_LO; \
	MENU trans12_Press_CAL_POINT_LO_page; \
	COMMAND trans12_Press_CAL_POINT_LO_read; \
	COMMAND trans12_Press_CAL_POINT_LO_write; \
	VARIABLE trans12_Press_CAL_MIN_SPAN; \
	MENU trans12_Press_CAL_MIN_SPAN_page; \
	COMMAND trans12_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans12_Press_SENSOR_UNIT; \
	MENU trans12_Press_SENSOR_UNIT_page; \
	COMMAND trans12_Press_SENSOR_UNIT_read; \
	COMMAND trans12_Press_SENSOR_UNIT_write; \
	COLLECTION trans12_Press_TRIMMED_VALUE; \
	VARIABLE trans12_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans12_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans12_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans12_Press_TRIMMED_VALUE_page; \
	COMMAND trans12_Press_TRIMMED_VALUE_read; \
	VARIABLE trans12_Press_SENSOR_TYPE; \
	MENU trans12_Press_SENSOR_TYPE_page; \
	COMMAND trans12_Press_SENSOR_TYPE_read; \
	VARIABLE trans12_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans12_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans12_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans12_Press_PRIMARY_VALUE; \
	VARIABLE trans12_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans12_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans12_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans12_Press_PRIMARY_VALUE_page; \
	COMMAND trans12_Press_PRIMARY_VALUE_read; \
	VARIABLE trans12_Press_PRIMARY_VALUE_UNIT; \
	MENU trans12_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans12_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans12_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans12_Press_PRIMARY_VALUE_TYPE; \
	MENU trans12_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans12_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans12_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans12_Press_LIN_TYPE; \
	MENU trans12_Press_LIN_TYPE_page; \
	COMMAND trans12_Press_LIN_TYPE_read; \
	COMMAND trans12_Press_LIN_TYPE_write; \
	COLLECTION trans12_Press_VIEW_1; \
	MENU trans12_Press_VIEW_1_page; \
	MENU trans12_Press_Simple_Dialog_Optional_A; \
	UNIT trans12_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans12_Press_Sensor_unit_1

#define USE_TRANS12_PRESS_OPTIONAL_B \
	USE_TRANS12_PRESS_OPTIONAL_BOTH; \
	MENU trans12_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS12_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans12_Press_)
#define USE_TRANS12_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans12_Press_)
#define USE_TRANS12_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans12_Press_)
#define USE_TRANS12_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans12_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS13_PRESS_MANDATORY_BOTH \
	BLOCK trans13_Press_block; \
	COLLECTION trans13_Press_BLOCK_OBJECT; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans13_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans13_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans13_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans13_Press_BLOCK_OBJECT_page; \
	COMMAND trans13_Press_BLOCK_OBJECT_read; \
	VARIABLE trans13_Press_ST_REV; \
	MENU trans13_Press_ST_REV_page; \
	COMMAND trans13_Press_ST_REV_read; \
	VARIABLE trans13_Press_TAG_DESC; \
	MENU trans13_Press_TAG_DESC_page; \
	COMMAND trans13_Press_TAG_DESC_read; \
	COMMAND trans13_Press_TAG_DESC_write; \
	VARIABLE trans13_Press_STRATEGY; \
	MENU trans13_Press_STRATEGY_page; \
	COMMAND trans13_Press_STRATEGY_read; \
	COMMAND trans13_Press_STRATEGY_write; \
	VARIABLE trans13_Press_ALERT_KEY; \
	MENU trans13_Press_ALERT_KEY_page; \
	COMMAND trans13_Press_ALERT_KEY_read; \
	COMMAND trans13_Press_ALERT_KEY_write; \
	VARIABLE trans13_Press_TARGET_MODE; \
	MENU trans13_Press_TARGET_MODE_page; \
	COMMAND trans13_Press_TARGET_MODE_read; \
	COMMAND trans13_Press_TARGET_MODE_write; \
	COLLECTION trans13_Press_MODE_BLK; \
	VARIABLE trans13_Press_MODE_BLK_Actual; \
	VARIABLE trans13_Press_MODE_BLK_Permitted; \
	VARIABLE trans13_Press_MODE_BLK_Normal; \
	MENU trans13_Press_MODE_BLK_page; \
	COMMAND trans13_Press_MODE_BLK_read; \
	COLLECTION trans13_Press_ALARM_SUM; \
	VARIABLE trans13_Press_ALARM_SUM_Current; \
	VARIABLE trans13_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans13_Press_ALARM_SUM_Unreported; \
	VARIABLE trans13_Press_ALARM_SUM_Disabled; \
	MENU trans13_Press_ALARM_SUM_page; \
	COMMAND trans13_Press_ALARM_SUM_read

#define USE_TRANS13_PRESS_MANDATORY_A \
	USE_TRANS13_PRESS_MANDATORY_BOTH; \
	MENU trans13_Press_Simple_Dialog_Mandatory_A; \
	MENU trans13_Press_Tab_s_mandatory_A; \
	MENU trans13_Press_Tab_m_mandatory_A

#define USE_TRANS13_PRESS_MANDATORY_B \
	USE_TRANS13_PRESS_MANDATORY_BOTH; \
	VARIABLE trans13_Press_SENSOR_VALUE; \
	MENU trans13_Press_SENSOR_VALUE_page; \
	COMMAND trans13_Press_SENSOR_VALUE_read; \
	VARIABLE trans13_Press_SENSOR_HI_LIM; \
	MENU trans13_Press_SENSOR_HI_LIM_page; \
	COMMAND trans13_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans13_Press_SENSOR_LO_LIM; \
	MENU trans13_Press_SENSOR_LO_LIM_page; \
	COMMAND trans13_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans13_Press_CAL_POINT_HI; \
	MENU trans13_Press_CAL_POINT_HI_page; \
	COMMAND trans13_Press_CAL_POINT_HI_read; \
	COMMAND trans13_Press_CAL_POINT_HI_write; \
	VARIABLE trans13_Press_CAL_POINT_LO; \
	MENU trans13_Press_CAL_POINT_LO_page; \
	COMMAND trans13_Press_CAL_POINT_LO_read; \
	COMMAND trans13_Press_CAL_POINT_LO_write; \
	VARIABLE trans13_Press_CAL_MIN_SPAN; \
	MENU trans13_Press_CAL_MIN_SPAN_page; \
	COMMAND trans13_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans13_Press_SENSOR_UNIT; \
	MENU trans13_Press_SENSOR_UNIT_page; \
	COMMAND trans13_Press_SENSOR_UNIT_read; \
	COMMAND trans13_Press_SENSOR_UNIT_write; \
	COLLECTION trans13_Press_TRIMMED_VALUE; \
	VARIABLE trans13_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans13_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans13_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans13_Press_TRIMMED_VALUE_page; \
	COMMAND trans13_Press_TRIMMED_VALUE_read; \
	VARIABLE trans13_Press_SENSOR_TYPE; \
	MENU trans13_Press_SENSOR_TYPE_page; \
	COMMAND trans13_Press_SENSOR_TYPE_read; \
	VARIABLE trans13_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans13_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans13_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans13_Press_PRIMARY_VALUE; \
	VARIABLE trans13_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans13_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans13_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans13_Press_PRIMARY_VALUE_page; \
	COMMAND trans13_Press_PRIMARY_VALUE_read; \
	VARIABLE trans13_Press_PRIMARY_VALUE_UNIT; \
	MENU trans13_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans13_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans13_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans13_Press_PRIMARY_VALUE_TYPE; \
	MENU trans13_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans13_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans13_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans13_Press_LIN_TYPE; \
	MENU trans13_Press_LIN_TYPE_page; \
	COMMAND trans13_Press_LIN_TYPE_read; \
	COMMAND trans13_Press_LIN_TYPE_write; \
	COLLECTION trans13_Press_VIEW_1; \
	MENU trans13_Press_VIEW_1_page; \
	MENU trans13_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans13_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans13_Press_Sensor_unit_1; \
	MENU trans13_Press_Tab_s_mandatory_B; \
	MENU trans13_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans13_Press_Tab_s_input_table_mandatory_B; \
	MENU trans13_Press_Tab_m_mandatory_B; \
	MENU trans13_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans13_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS13_PRESS_OPTIONAL_BOTH \
	VARIABLE trans13_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans13_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans13_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans13_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans13_Press_SENSOR_FILL_FLUID; \
	MENU trans13_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans13_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans13_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans13_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans13_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans13_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans13_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans13_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans13_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans13_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans13_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans13_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans13_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans13_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans13_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans13_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans13_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans13_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans13_Press_TEMPERATURE; \
	VARIABLE trans13_Press_TEMPERATURE_Value; \
	VARIABLE trans13_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans13_Press_TEMPERATURE_Status_Limit; \
	MENU trans13_Press_TEMPERATURE_page; \
	COMMAND trans13_Press_TEMPERATURE_read; \
	VARIABLE trans13_Press_TEMPERATURE_UNIT; \
	MENU trans13_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans13_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans13_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans13_Press_SECONDARY_VALUE_1; \
	VARIABLE trans13_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans13_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans13_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans13_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans13_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans13_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans13_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans13_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans13_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans13_Press_SECONDARY_VALUE_2; \
	VARIABLE trans13_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans13_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans13_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans13_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans13_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans13_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans13_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans13_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans13_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans13_Press_SCALE_IN; \
	VARIABLE trans13_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans13_Press_SCALE_IN_Lower_Value; \
	MENU trans13_Press_SCALE_IN_page; \
	COMMAND trans13_Press_SCALE_IN_read; \
	COMMAND trans13_Press_SCALE_IN_write; \
	COLLECTION trans13_Press_SCALE_OUT; \
	VARIABLE trans13_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans13_Press_SCALE_OUT_Lower_Value; \
	MENU trans13_Press_SCALE_OUT_page; \
	COMMAND trans13_Press_SCALE_OUT_read; \
	COMMAND trans13_Press_SCALE_OUT_write; \
	VARIABLE trans13_Press_LOW_FLOW_CUT_OFF; \
	MENU trans13_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans13_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans13_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans13_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans13_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans13_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans13_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans13_Press_TAB_ACTUAL_NUMBER; \
	MENU trans13_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans13_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans13_Press_TAB_ENTRY; \
	MENU trans13_Press_TAB_ENTRY_page; \
	COMMAND trans13_Press_TAB_ENTRY_read; \
	COMMAND trans13_Press_TAB_ENTRY_write; \
	VARIABLE trans13_Press_TAB_MAX_NUMBER; \
	MENU trans13_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans13_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans13_Press_TAB_MIN_NUMBER; \
	MENU trans13_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans13_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans13_Press_TAB_OP_CODE; \
	MENU trans13_Press_TAB_OP_CODE_page; \
	COMMAND trans13_Press_TAB_OP_CODE_read; \
	COMMAND trans13_Press_TAB_OP_CODE_write; \
	VARIABLE trans13_Press_TAB_STATUS; \
	MENU trans13_Press_TAB_STATUS_page; \
	COMMAND trans13_Press_TAB_STATUS_read; \
	COLLECTION trans13_Press_TAB_X_Y_VALUE; \
	VARIABLE trans13_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans13_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans13_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans13_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans13_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans13_Press_MAX_SENSOR_VALUE; \
	MENU trans13_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans13_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans13_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans13_Press_MIN_SENSOR_VALUE; \
	MENU trans13_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans13_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans13_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans13_Press_MAX_TEMPERATURE; \
	MENU trans13_Press_MAX_TEMPERATURE_page; \
	COMMAND trans13_Press_MAX_TEMPERATURE_read; \
	COMMAND trans13_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans13_Press_MIN_TEMPERATURE; \
	MENU trans13_Press_MIN_TEMPERATURE_page; \
	COMMAND trans13_Press_MIN_TEMPERATURE_read; \
	COMMAND trans13_Press_MIN_TEMPERATURE_write; \
	UNIT trans13_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans13_Press_Sensor_unit_2; \
	UNIT trans13_Press_Temperature_unit; \
	UNIT trans13_Press_Secondary_Value_1_unit; \
	UNIT trans13_Press_Secondary_Value_2_unit

#define USE_TRANS13_PRESS_OPTIONAL_A \
	USE_TRANS13_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans13_Press_SENSOR_VALUE; \
	MENU trans13_Press_SENSOR_VALUE_page; \
	COMMAND trans13_Press_SENSOR_VALUE_read; \
	VARIABLE trans13_Press_SENSOR_HI_LIM; \
	MENU trans13_Press_SENSOR_HI_LIM_page; \
	COMMAND trans13_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans13_Press_SENSOR_LO_LIM; \
	MENU trans13_Press_SENSOR_LO_LIM_page; \
	COMMAND trans13_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans13_Press_CAL_POINT_HI; \
	MENU trans13_Press_CAL_POINT_HI_page; \
	COMMAND trans13_Press_CAL_POINT_HI_read; \
	COMMAND trans13_Press_CAL_POINT_HI_write; \
	VARIABLE trans13_Press_CAL_POINT_LO; \
	MENU trans13_Press_CAL_POINT_LO_page; \
	COMMAND trans13_Press_CAL_POINT_LO_read; \
	COMMAND trans13_Press_CAL_POINT_LO_write; \
	VARIABLE trans13_Press_CAL_MIN_SPAN; \
	MENU trans13_Press_CAL_MIN_SPAN_page; \
	COMMAND trans13_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans13_Press_SENSOR_UNIT; \
	MENU trans13_Press_SENSOR_UNIT_page; \
	COMMAND trans13_Press_SENSOR_UNIT_read; \
	COMMAND trans13_Press_SENSOR_UNIT_write; \
	COLLECTION trans13_Press_TRIMMED_VALUE; \
	VARIABLE trans13_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans13_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans13_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans13_Press_TRIMMED_VALUE_page; \
	COMMAND trans13_Press_TRIMMED_VALUE_read; \
	VARIABLE trans13_Press_SENSOR_TYPE; \
	MENU trans13_Press_SENSOR_TYPE_page; \
	COMMAND trans13_Press_SENSOR_TYPE_read; \
	VARIABLE trans13_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans13_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans13_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans13_Press_PRIMARY_VALUE; \
	VARIABLE trans13_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans13_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans13_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans13_Press_PRIMARY_VALUE_page; \
	COMMAND trans13_Press_PRIMARY_VALUE_read; \
	VARIABLE trans13_Press_PRIMARY_VALUE_UNIT; \
	MENU trans13_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans13_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans13_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans13_Press_PRIMARY_VALUE_TYPE; \
	MENU trans13_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans13_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans13_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans13_Press_LIN_TYPE; \
	MENU trans13_Press_LIN_TYPE_page; \
	COMMAND trans13_Press_LIN_TYPE_read; \
	COMMAND trans13_Press_LIN_TYPE_write; \
	COLLECTION trans13_Press_VIEW_1; \
	MENU trans13_Press_VIEW_1_page; \
	MENU trans13_Press_Simple_Dialog_Optional_A; \
	UNIT trans13_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans13_Press_Sensor_unit_1

#define USE_TRANS13_PRESS_OPTIONAL_B \
	USE_TRANS13_PRESS_OPTIONAL_BOTH; \
	MENU trans13_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS13_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans13_Press_)
#define USE_TRANS13_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans13_Press_)
#define USE_TRANS13_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans13_Press_)
#define USE_TRANS13_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans13_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS14_PRESS_MANDATORY_BOTH \
	BLOCK trans14_Press_block; \
	COLLECTION trans14_Press_BLOCK_OBJECT; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans14_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans14_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans14_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans14_Press_BLOCK_OBJECT_page; \
	COMMAND trans14_Press_BLOCK_OBJECT_read; \
	VARIABLE trans14_Press_ST_REV; \
	MENU trans14_Press_ST_REV_page; \
	COMMAND trans14_Press_ST_REV_read; \
	VARIABLE trans14_Press_TAG_DESC; \
	MENU trans14_Press_TAG_DESC_page; \
	COMMAND trans14_Press_TAG_DESC_read; \
	COMMAND trans14_Press_TAG_DESC_write; \
	VARIABLE trans14_Press_STRATEGY; \
	MENU trans14_Press_STRATEGY_page; \
	COMMAND trans14_Press_STRATEGY_read; \
	COMMAND trans14_Press_STRATEGY_write; \
	VARIABLE trans14_Press_ALERT_KEY; \
	MENU trans14_Press_ALERT_KEY_page; \
	COMMAND trans14_Press_ALERT_KEY_read; \
	COMMAND trans14_Press_ALERT_KEY_write; \
	VARIABLE trans14_Press_TARGET_MODE; \
	MENU trans14_Press_TARGET_MODE_page; \
	COMMAND trans14_Press_TARGET_MODE_read; \
	COMMAND trans14_Press_TARGET_MODE_write; \
	COLLECTION trans14_Press_MODE_BLK; \
	VARIABLE trans14_Press_MODE_BLK_Actual; \
	VARIABLE trans14_Press_MODE_BLK_Permitted; \
	VARIABLE trans14_Press_MODE_BLK_Normal; \
	MENU trans14_Press_MODE_BLK_page; \
	COMMAND trans14_Press_MODE_BLK_read; \
	COLLECTION trans14_Press_ALARM_SUM; \
	VARIABLE trans14_Press_ALARM_SUM_Current; \
	VARIABLE trans14_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans14_Press_ALARM_SUM_Unreported; \
	VARIABLE trans14_Press_ALARM_SUM_Disabled; \
	MENU trans14_Press_ALARM_SUM_page; \
	COMMAND trans14_Press_ALARM_SUM_read

#define USE_TRANS14_PRESS_MANDATORY_A \
	USE_TRANS14_PRESS_MANDATORY_BOTH; \
	MENU trans14_Press_Simple_Dialog_Mandatory_A; \
	MENU trans14_Press_Tab_s_mandatory_A; \
	MENU trans14_Press_Tab_m_mandatory_A

#define USE_TRANS14_PRESS_MANDATORY_B \
	USE_TRANS14_PRESS_MANDATORY_BOTH; \
	VARIABLE trans14_Press_SENSOR_VALUE; \
	MENU trans14_Press_SENSOR_VALUE_page; \
	COMMAND trans14_Press_SENSOR_VALUE_read; \
	VARIABLE trans14_Press_SENSOR_HI_LIM; \
	MENU trans14_Press_SENSOR_HI_LIM_page; \
	COMMAND trans14_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans14_Press_SENSOR_LO_LIM; \
	MENU trans14_Press_SENSOR_LO_LIM_page; \
	COMMAND trans14_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans14_Press_CAL_POINT_HI; \
	MENU trans14_Press_CAL_POINT_HI_page; \
	COMMAND trans14_Press_CAL_POINT_HI_read; \
	COMMAND trans14_Press_CAL_POINT_HI_write; \
	VARIABLE trans14_Press_CAL_POINT_LO; \
	MENU trans14_Press_CAL_POINT_LO_page; \
	COMMAND trans14_Press_CAL_POINT_LO_read; \
	COMMAND trans14_Press_CAL_POINT_LO_write; \
	VARIABLE trans14_Press_CAL_MIN_SPAN; \
	MENU trans14_Press_CAL_MIN_SPAN_page; \
	COMMAND trans14_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans14_Press_SENSOR_UNIT; \
	MENU trans14_Press_SENSOR_UNIT_page; \
	COMMAND trans14_Press_SENSOR_UNIT_read; \
	COMMAND trans14_Press_SENSOR_UNIT_write; \
	COLLECTION trans14_Press_TRIMMED_VALUE; \
	VARIABLE trans14_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans14_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans14_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans14_Press_TRIMMED_VALUE_page; \
	COMMAND trans14_Press_TRIMMED_VALUE_read; \
	VARIABLE trans14_Press_SENSOR_TYPE; \
	MENU trans14_Press_SENSOR_TYPE_page; \
	COMMAND trans14_Press_SENSOR_TYPE_read; \
	VARIABLE trans14_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans14_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans14_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans14_Press_PRIMARY_VALUE; \
	VARIABLE trans14_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans14_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans14_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans14_Press_PRIMARY_VALUE_page; \
	COMMAND trans14_Press_PRIMARY_VALUE_read; \
	VARIABLE trans14_Press_PRIMARY_VALUE_UNIT; \
	MENU trans14_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans14_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans14_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans14_Press_PRIMARY_VALUE_TYPE; \
	MENU trans14_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans14_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans14_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans14_Press_LIN_TYPE; \
	MENU trans14_Press_LIN_TYPE_page; \
	COMMAND trans14_Press_LIN_TYPE_read; \
	COMMAND trans14_Press_LIN_TYPE_write; \
	COLLECTION trans14_Press_VIEW_1; \
	MENU trans14_Press_VIEW_1_page; \
	MENU trans14_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans14_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans14_Press_Sensor_unit_1; \
	MENU trans14_Press_Tab_s_mandatory_B; \
	MENU trans14_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans14_Press_Tab_s_input_table_mandatory_B; \
	MENU trans14_Press_Tab_m_mandatory_B; \
	MENU trans14_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans14_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS14_PRESS_OPTIONAL_BOTH \
	VARIABLE trans14_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans14_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans14_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans14_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans14_Press_SENSOR_FILL_FLUID; \
	MENU trans14_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans14_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans14_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans14_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans14_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans14_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans14_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans14_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans14_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans14_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans14_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans14_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans14_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans14_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans14_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans14_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans14_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans14_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans14_Press_TEMPERATURE; \
	VARIABLE trans14_Press_TEMPERATURE_Value; \
	VARIABLE trans14_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans14_Press_TEMPERATURE_Status_Limit; \
	MENU trans14_Press_TEMPERATURE_page; \
	COMMAND trans14_Press_TEMPERATURE_read; \
	VARIABLE trans14_Press_TEMPERATURE_UNIT; \
	MENU trans14_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans14_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans14_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans14_Press_SECONDARY_VALUE_1; \
	VARIABLE trans14_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans14_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans14_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans14_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans14_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans14_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans14_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans14_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans14_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans14_Press_SECONDARY_VALUE_2; \
	VARIABLE trans14_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans14_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans14_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans14_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans14_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans14_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans14_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans14_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans14_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans14_Press_SCALE_IN; \
	VARIABLE trans14_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans14_Press_SCALE_IN_Lower_Value; \
	MENU trans14_Press_SCALE_IN_page; \
	COMMAND trans14_Press_SCALE_IN_read; \
	COMMAND trans14_Press_SCALE_IN_write; \
	COLLECTION trans14_Press_SCALE_OUT; \
	VARIABLE trans14_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans14_Press_SCALE_OUT_Lower_Value; \
	MENU trans14_Press_SCALE_OUT_page; \
	COMMAND trans14_Press_SCALE_OUT_read; \
	COMMAND trans14_Press_SCALE_OUT_write; \
	VARIABLE trans14_Press_LOW_FLOW_CUT_OFF; \
	MENU trans14_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans14_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans14_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans14_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans14_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans14_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans14_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans14_Press_TAB_ACTUAL_NUMBER; \
	MENU trans14_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans14_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans14_Press_TAB_ENTRY; \
	MENU trans14_Press_TAB_ENTRY_page; \
	COMMAND trans14_Press_TAB_ENTRY_read; \
	COMMAND trans14_Press_TAB_ENTRY_write; \
	VARIABLE trans14_Press_TAB_MAX_NUMBER; \
	MENU trans14_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans14_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans14_Press_TAB_MIN_NUMBER; \
	MENU trans14_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans14_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans14_Press_TAB_OP_CODE; \
	MENU trans14_Press_TAB_OP_CODE_page; \
	COMMAND trans14_Press_TAB_OP_CODE_read; \
	COMMAND trans14_Press_TAB_OP_CODE_write; \
	VARIABLE trans14_Press_TAB_STATUS; \
	MENU trans14_Press_TAB_STATUS_page; \
	COMMAND trans14_Press_TAB_STATUS_read; \
	COLLECTION trans14_Press_TAB_X_Y_VALUE; \
	VARIABLE trans14_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans14_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans14_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans14_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans14_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans14_Press_MAX_SENSOR_VALUE; \
	MENU trans14_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans14_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans14_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans14_Press_MIN_SENSOR_VALUE; \
	MENU trans14_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans14_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans14_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans14_Press_MAX_TEMPERATURE; \
	MENU trans14_Press_MAX_TEMPERATURE_page; \
	COMMAND trans14_Press_MAX_TEMPERATURE_read; \
	COMMAND trans14_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans14_Press_MIN_TEMPERATURE; \
	MENU trans14_Press_MIN_TEMPERATURE_page; \
	COMMAND trans14_Press_MIN_TEMPERATURE_read; \
	COMMAND trans14_Press_MIN_TEMPERATURE_write; \
	UNIT trans14_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans14_Press_Sensor_unit_2; \
	UNIT trans14_Press_Temperature_unit; \
	UNIT trans14_Press_Secondary_Value_1_unit; \
	UNIT trans14_Press_Secondary_Value_2_unit

#define USE_TRANS14_PRESS_OPTIONAL_A \
	USE_TRANS14_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans14_Press_SENSOR_VALUE; \
	MENU trans14_Press_SENSOR_VALUE_page; \
	COMMAND trans14_Press_SENSOR_VALUE_read; \
	VARIABLE trans14_Press_SENSOR_HI_LIM; \
	MENU trans14_Press_SENSOR_HI_LIM_page; \
	COMMAND trans14_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans14_Press_SENSOR_LO_LIM; \
	MENU trans14_Press_SENSOR_LO_LIM_page; \
	COMMAND trans14_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans14_Press_CAL_POINT_HI; \
	MENU trans14_Press_CAL_POINT_HI_page; \
	COMMAND trans14_Press_CAL_POINT_HI_read; \
	COMMAND trans14_Press_CAL_POINT_HI_write; \
	VARIABLE trans14_Press_CAL_POINT_LO; \
	MENU trans14_Press_CAL_POINT_LO_page; \
	COMMAND trans14_Press_CAL_POINT_LO_read; \
	COMMAND trans14_Press_CAL_POINT_LO_write; \
	VARIABLE trans14_Press_CAL_MIN_SPAN; \
	MENU trans14_Press_CAL_MIN_SPAN_page; \
	COMMAND trans14_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans14_Press_SENSOR_UNIT; \
	MENU trans14_Press_SENSOR_UNIT_page; \
	COMMAND trans14_Press_SENSOR_UNIT_read; \
	COMMAND trans14_Press_SENSOR_UNIT_write; \
	COLLECTION trans14_Press_TRIMMED_VALUE; \
	VARIABLE trans14_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans14_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans14_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans14_Press_TRIMMED_VALUE_page; \
	COMMAND trans14_Press_TRIMMED_VALUE_read; \
	VARIABLE trans14_Press_SENSOR_TYPE; \
	MENU trans14_Press_SENSOR_TYPE_page; \
	COMMAND trans14_Press_SENSOR_TYPE_read; \
	VARIABLE trans14_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans14_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans14_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans14_Press_PRIMARY_VALUE; \
	VARIABLE trans14_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans14_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans14_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans14_Press_PRIMARY_VALUE_page; \
	COMMAND trans14_Press_PRIMARY_VALUE_read; \
	VARIABLE trans14_Press_PRIMARY_VALUE_UNIT; \
	MENU trans14_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans14_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans14_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans14_Press_PRIMARY_VALUE_TYPE; \
	MENU trans14_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans14_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans14_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans14_Press_LIN_TYPE; \
	MENU trans14_Press_LIN_TYPE_page; \
	COMMAND trans14_Press_LIN_TYPE_read; \
	COMMAND trans14_Press_LIN_TYPE_write; \
	COLLECTION trans14_Press_VIEW_1; \
	MENU trans14_Press_VIEW_1_page; \
	MENU trans14_Press_Simple_Dialog_Optional_A; \
	UNIT trans14_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans14_Press_Sensor_unit_1

#define USE_TRANS14_PRESS_OPTIONAL_B \
	USE_TRANS14_PRESS_OPTIONAL_BOTH; \
	MENU trans14_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS14_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans14_Press_)
#define USE_TRANS14_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans14_Press_)
#define USE_TRANS14_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans14_Press_)
#define USE_TRANS14_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans14_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS15_PRESS_MANDATORY_BOTH \
	BLOCK trans15_Press_block; \
	COLLECTION trans15_Press_BLOCK_OBJECT; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Reserved; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Class; \
	VARIABLE trans15_Press_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans15_Press_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Profile; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans15_Press_BLOCK_OBJECT_Number_of_Views; \
	MENU trans15_Press_BLOCK_OBJECT_page; \
	COMMAND trans15_Press_BLOCK_OBJECT_read; \
	VARIABLE trans15_Press_ST_REV; \
	MENU trans15_Press_ST_REV_page; \
	COMMAND trans15_Press_ST_REV_read; \
	VARIABLE trans15_Press_TAG_DESC; \
	MENU trans15_Press_TAG_DESC_page; \
	COMMAND trans15_Press_TAG_DESC_read; \
	COMMAND trans15_Press_TAG_DESC_write; \
	VARIABLE trans15_Press_STRATEGY; \
	MENU trans15_Press_STRATEGY_page; \
	COMMAND trans15_Press_STRATEGY_read; \
	COMMAND trans15_Press_STRATEGY_write; \
	VARIABLE trans15_Press_ALERT_KEY; \
	MENU trans15_Press_ALERT_KEY_page; \
	COMMAND trans15_Press_ALERT_KEY_read; \
	COMMAND trans15_Press_ALERT_KEY_write; \
	VARIABLE trans15_Press_TARGET_MODE; \
	MENU trans15_Press_TARGET_MODE_page; \
	COMMAND trans15_Press_TARGET_MODE_read; \
	COMMAND trans15_Press_TARGET_MODE_write; \
	COLLECTION trans15_Press_MODE_BLK; \
	VARIABLE trans15_Press_MODE_BLK_Actual; \
	VARIABLE trans15_Press_MODE_BLK_Permitted; \
	VARIABLE trans15_Press_MODE_BLK_Normal; \
	MENU trans15_Press_MODE_BLK_page; \
	COMMAND trans15_Press_MODE_BLK_read; \
	COLLECTION trans15_Press_ALARM_SUM; \
	VARIABLE trans15_Press_ALARM_SUM_Current; \
	VARIABLE trans15_Press_ALARM_SUM_Unacknowledged; \
	VARIABLE trans15_Press_ALARM_SUM_Unreported; \
	VARIABLE trans15_Press_ALARM_SUM_Disabled; \
	MENU trans15_Press_ALARM_SUM_page; \
	COMMAND trans15_Press_ALARM_SUM_read

#define USE_TRANS15_PRESS_MANDATORY_A \
	USE_TRANS15_PRESS_MANDATORY_BOTH; \
	MENU trans15_Press_Simple_Dialog_Mandatory_A; \
	MENU trans15_Press_Tab_s_mandatory_A; \
	MENU trans15_Press_Tab_m_mandatory_A

#define USE_TRANS15_PRESS_MANDATORY_B \
	USE_TRANS15_PRESS_MANDATORY_BOTH; \
	VARIABLE trans15_Press_SENSOR_VALUE; \
	MENU trans15_Press_SENSOR_VALUE_page; \
	COMMAND trans15_Press_SENSOR_VALUE_read; \
	VARIABLE trans15_Press_SENSOR_HI_LIM; \
	MENU trans15_Press_SENSOR_HI_LIM_page; \
	COMMAND trans15_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans15_Press_SENSOR_LO_LIM; \
	MENU trans15_Press_SENSOR_LO_LIM_page; \
	COMMAND trans15_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans15_Press_CAL_POINT_HI; \
	MENU trans15_Press_CAL_POINT_HI_page; \
	COMMAND trans15_Press_CAL_POINT_HI_read; \
	COMMAND trans15_Press_CAL_POINT_HI_write; \
	VARIABLE trans15_Press_CAL_POINT_LO; \
	MENU trans15_Press_CAL_POINT_LO_page; \
	COMMAND trans15_Press_CAL_POINT_LO_read; \
	COMMAND trans15_Press_CAL_POINT_LO_write; \
	VARIABLE trans15_Press_CAL_MIN_SPAN; \
	MENU trans15_Press_CAL_MIN_SPAN_page; \
	COMMAND trans15_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans15_Press_SENSOR_UNIT; \
	MENU trans15_Press_SENSOR_UNIT_page; \
	COMMAND trans15_Press_SENSOR_UNIT_read; \
	COMMAND trans15_Press_SENSOR_UNIT_write; \
	COLLECTION trans15_Press_TRIMMED_VALUE; \
	VARIABLE trans15_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans15_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans15_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans15_Press_TRIMMED_VALUE_page; \
	COMMAND trans15_Press_TRIMMED_VALUE_read; \
	VARIABLE trans15_Press_SENSOR_TYPE; \
	MENU trans15_Press_SENSOR_TYPE_page; \
	COMMAND trans15_Press_SENSOR_TYPE_read; \
	VARIABLE trans15_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans15_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans15_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans15_Press_PRIMARY_VALUE; \
	VARIABLE trans15_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans15_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans15_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans15_Press_PRIMARY_VALUE_page; \
	COMMAND trans15_Press_PRIMARY_VALUE_read; \
	VARIABLE trans15_Press_PRIMARY_VALUE_UNIT; \
	MENU trans15_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans15_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans15_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans15_Press_PRIMARY_VALUE_TYPE; \
	MENU trans15_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans15_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans15_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans15_Press_LIN_TYPE; \
	MENU trans15_Press_LIN_TYPE_page; \
	COMMAND trans15_Press_LIN_TYPE_read; \
	COMMAND trans15_Press_LIN_TYPE_write; \
	COLLECTION trans15_Press_VIEW_1; \
	MENU trans15_Press_VIEW_1_page; \
	MENU trans15_Press_Simple_Dialog_Mandatory_B; \
	UNIT trans15_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans15_Press_Sensor_unit_1; \
	MENU trans15_Press_Tab_s_mandatory_B; \
	MENU trans15_Press_Tab_s_input_meassurelimit_mandatory_B; \
	MENU trans15_Press_Tab_s_input_table_mandatory_B; \
	MENU trans15_Press_Tab_m_mandatory_B; \
	MENU trans15_Press_Tab_m_input_meassurelimit_mandatory_B; \
	MENU trans15_Press_Tab_m_input_table_mandatory_B

#define USE_TRANS15_PRESS_OPTIONAL_BOTH \
	VARIABLE trans15_Press_SENSOR_DIAPHRAGM_MATERIAL; \
	MENU trans15_Press_SENSOR_DIAPHRAGM_MATERIAL_page; \
	COMMAND trans15_Press_SENSOR_DIAPHRAGM_MATERIAL_read; \
	COMMAND trans15_Press_SENSOR_DIAPHRAGM_MATERIAL_write; \
	VARIABLE trans15_Press_SENSOR_FILL_FLUID; \
	MENU trans15_Press_SENSOR_FILL_FLUID_page; \
	COMMAND trans15_Press_SENSOR_FILL_FLUID_read; \
	COMMAND trans15_Press_SENSOR_FILL_FLUID_write; \
	VARIABLE trans15_Press_SENSOR_MAX_STATIC_PRESSURE; \
	MENU trans15_Press_SENSOR_MAX_STATIC_PRESSURE_page; \
	COMMAND trans15_Press_SENSOR_MAX_STATIC_PRESSURE_read; \
	VARIABLE trans15_Press_SENSOR_O_RING_MATERIAL; \
	MENU trans15_Press_SENSOR_O_RING_MATERIAL_page; \
	COMMAND trans15_Press_SENSOR_O_RING_MATERIAL_read; \
	COMMAND trans15_Press_SENSOR_O_RING_MATERIAL_write; \
	VARIABLE trans15_Press_PROCESS_CONNECTION_TYPE; \
	MENU trans15_Press_PROCESS_CONNECTION_TYPE_page; \
	COMMAND trans15_Press_PROCESS_CONNECTION_TYPE_read; \
	COMMAND trans15_Press_PROCESS_CONNECTION_TYPE_write; \
	VARIABLE trans15_Press_PROCESS_CONNECTION_MATERIAL; \
	MENU trans15_Press_PROCESS_CONNECTION_MATERIAL_page; \
	COMMAND trans15_Press_PROCESS_CONNECTION_MATERIAL_read; \
	COMMAND trans15_Press_PROCESS_CONNECTION_MATERIAL_write; \
	COLLECTION trans15_Press_TEMPERATURE; \
	VARIABLE trans15_Press_TEMPERATURE_Value; \
	VARIABLE trans15_Press_TEMPERATURE_Status_Quality; \
	VARIABLE trans15_Press_TEMPERATURE_Status_Limit; \
	MENU trans15_Press_TEMPERATURE_page; \
	COMMAND trans15_Press_TEMPERATURE_read; \
	VARIABLE trans15_Press_TEMPERATURE_UNIT; \
	MENU trans15_Press_TEMPERATURE_UNIT_page; \
	COMMAND trans15_Press_TEMPERATURE_UNIT_read; \
	COMMAND trans15_Press_TEMPERATURE_UNIT_write; \
	COLLECTION trans15_Press_SECONDARY_VALUE_1; \
	VARIABLE trans15_Press_SECONDARY_VALUE_1_Value; \
	VARIABLE trans15_Press_SECONDARY_VALUE_1_Status_Quality; \
	VARIABLE trans15_Press_SECONDARY_VALUE_1_Status_Limit; \
	MENU trans15_Press_SECONDARY_VALUE_1_page; \
	COMMAND trans15_Press_SECONDARY_VALUE_1_read; \
	VARIABLE trans15_Press_SECONDARY_VALUE_1_UNIT; \
	MENU trans15_Press_SECONDARY_VALUE_1_UNIT_page; \
	COMMAND trans15_Press_SECONDARY_VALUE_1_UNIT_read; \
	COMMAND trans15_Press_SECONDARY_VALUE_1_UNIT_write; \
	COLLECTION trans15_Press_SECONDARY_VALUE_2; \
	VARIABLE trans15_Press_SECONDARY_VALUE_2_Value; \
	VARIABLE trans15_Press_SECONDARY_VALUE_2_Status_Quality; \
	VARIABLE trans15_Press_SECONDARY_VALUE_2_Status_Limit; \
	MENU trans15_Press_SECONDARY_VALUE_2_page; \
	COMMAND trans15_Press_SECONDARY_VALUE_2_read; \
	VARIABLE trans15_Press_SECONDARY_VALUE_2_UNIT; \
	MENU trans15_Press_SECONDARY_VALUE_2_UNIT_page; \
	COMMAND trans15_Press_SECONDARY_VALUE_2_UNIT_read; \
	COMMAND trans15_Press_SECONDARY_VALUE_2_UNIT_write; \
	COLLECTION trans15_Press_SCALE_IN; \
	VARIABLE trans15_Press_SCALE_IN_Upper_Value; \
	VARIABLE trans15_Press_SCALE_IN_Lower_Value; \
	MENU trans15_Press_SCALE_IN_page; \
	COMMAND trans15_Press_SCALE_IN_read; \
	COMMAND trans15_Press_SCALE_IN_write; \
	COLLECTION trans15_Press_SCALE_OUT; \
	VARIABLE trans15_Press_SCALE_OUT_Upper_Value; \
	VARIABLE trans15_Press_SCALE_OUT_Lower_Value; \
	MENU trans15_Press_SCALE_OUT_page; \
	COMMAND trans15_Press_SCALE_OUT_read; \
	COMMAND trans15_Press_SCALE_OUT_write; \
	VARIABLE trans15_Press_LOW_FLOW_CUT_OFF; \
	MENU trans15_Press_LOW_FLOW_CUT_OFF_page; \
	COMMAND trans15_Press_LOW_FLOW_CUT_OFF_read; \
	COMMAND trans15_Press_LOW_FLOW_CUT_OFF_write; \
	VARIABLE trans15_Press_FLOW_LIN_SQRT_POINT; \
	MENU trans15_Press_FLOW_LIN_SQRT_POINT_page; \
	COMMAND trans15_Press_FLOW_LIN_SQRT_POINT_read; \
	COMMAND trans15_Press_FLOW_LIN_SQRT_POINT_write; \
	VARIABLE trans15_Press_TAB_ACTUAL_NUMBER; \
	MENU trans15_Press_TAB_ACTUAL_NUMBER_page; \
	COMMAND trans15_Press_TAB_ACTUAL_NUMBER_read; \
	VARIABLE trans15_Press_TAB_ENTRY; \
	MENU trans15_Press_TAB_ENTRY_page; \
	COMMAND trans15_Press_TAB_ENTRY_read; \
	COMMAND trans15_Press_TAB_ENTRY_write; \
	VARIABLE trans15_Press_TAB_MAX_NUMBER; \
	MENU trans15_Press_TAB_MAX_NUMBER_page; \
	COMMAND trans15_Press_TAB_MAX_NUMBER_read; \
	VARIABLE trans15_Press_TAB_MIN_NUMBER; \
	MENU trans15_Press_TAB_MIN_NUMBER_page; \
	COMMAND trans15_Press_TAB_MIN_NUMBER_read; \
	VARIABLE trans15_Press_TAB_OP_CODE; \
	MENU trans15_Press_TAB_OP_CODE_page; \
	COMMAND trans15_Press_TAB_OP_CODE_read; \
	COMMAND trans15_Press_TAB_OP_CODE_write; \
	VARIABLE trans15_Press_TAB_STATUS; \
	MENU trans15_Press_TAB_STATUS_page; \
	COMMAND trans15_Press_TAB_STATUS_read; \
	COLLECTION trans15_Press_TAB_X_Y_VALUE; \
	VARIABLE trans15_Press_TAB_X_Y_VALUE_Upper_Value; \
	VARIABLE trans15_Press_TAB_X_Y_VALUE_Lower_Value; \
	MENU trans15_Press_TAB_X_Y_VALUE_page; \
	COMMAND trans15_Press_TAB_X_Y_VALUE_read; \
	COMMAND trans15_Press_TAB_X_Y_VALUE_write; \
	VARIABLE trans15_Press_MAX_SENSOR_VALUE; \
	MENU trans15_Press_MAX_SENSOR_VALUE_page; \
	COMMAND trans15_Press_MAX_SENSOR_VALUE_read; \
	COMMAND trans15_Press_MAX_SENSOR_VALUE_write; \
	VARIABLE trans15_Press_MIN_SENSOR_VALUE; \
	MENU trans15_Press_MIN_SENSOR_VALUE_page; \
	COMMAND trans15_Press_MIN_SENSOR_VALUE_read; \
	COMMAND trans15_Press_MIN_SENSOR_VALUE_write; \
	VARIABLE trans15_Press_MAX_TEMPERATURE; \
	MENU trans15_Press_MAX_TEMPERATURE_page; \
	COMMAND trans15_Press_MAX_TEMPERATURE_read; \
	COMMAND trans15_Press_MAX_TEMPERATURE_write; \
	VARIABLE trans15_Press_MIN_TEMPERATURE; \
	MENU trans15_Press_MIN_TEMPERATURE_page; \
	COMMAND trans15_Press_MIN_TEMPERATURE_read; \
	COMMAND trans15_Press_MIN_TEMPERATURE_write; \
	UNIT trans15_Press_PRIMARY_VALUE_UNIT_unit_2; \
	UNIT trans15_Press_Sensor_unit_2; \
	UNIT trans15_Press_Temperature_unit; \
	UNIT trans15_Press_Secondary_Value_1_unit; \
	UNIT trans15_Press_Secondary_Value_2_unit

#define USE_TRANS15_PRESS_OPTIONAL_A \
	USE_TRANS15_PRESS_OPTIONAL_BOTH; \
	VARIABLE trans15_Press_SENSOR_VALUE; \
	MENU trans15_Press_SENSOR_VALUE_page; \
	COMMAND trans15_Press_SENSOR_VALUE_read; \
	VARIABLE trans15_Press_SENSOR_HI_LIM; \
	MENU trans15_Press_SENSOR_HI_LIM_page; \
	COMMAND trans15_Press_SENSOR_HI_LIM_read; \
	VARIABLE trans15_Press_SENSOR_LO_LIM; \
	MENU trans15_Press_SENSOR_LO_LIM_page; \
	COMMAND trans15_Press_SENSOR_LO_LIM_read; \
	VARIABLE trans15_Press_CAL_POINT_HI; \
	MENU trans15_Press_CAL_POINT_HI_page; \
	COMMAND trans15_Press_CAL_POINT_HI_read; \
	COMMAND trans15_Press_CAL_POINT_HI_write; \
	VARIABLE trans15_Press_CAL_POINT_LO; \
	MENU trans15_Press_CAL_POINT_LO_page; \
	COMMAND trans15_Press_CAL_POINT_LO_read; \
	COMMAND trans15_Press_CAL_POINT_LO_write; \
	VARIABLE trans15_Press_CAL_MIN_SPAN; \
	MENU trans15_Press_CAL_MIN_SPAN_page; \
	COMMAND trans15_Press_CAL_MIN_SPAN_read; \
	VARIABLE trans15_Press_SENSOR_UNIT; \
	MENU trans15_Press_SENSOR_UNIT_page; \
	COMMAND trans15_Press_SENSOR_UNIT_read; \
	COMMAND trans15_Press_SENSOR_UNIT_write; \
	COLLECTION trans15_Press_TRIMMED_VALUE; \
	VARIABLE trans15_Press_TRIMMED_VALUE_Value; \
	VARIABLE trans15_Press_TRIMMED_VALUE_Status_Quality; \
	VARIABLE trans15_Press_TRIMMED_VALUE_Status_Limit; \
	MENU trans15_Press_TRIMMED_VALUE_page; \
	COMMAND trans15_Press_TRIMMED_VALUE_read; \
	VARIABLE trans15_Press_SENSOR_TYPE; \
	MENU trans15_Press_SENSOR_TYPE_page; \
	COMMAND trans15_Press_SENSOR_TYPE_read; \
	VARIABLE trans15_Press_SENSOR_SERIAL_NUMBER; \
	MENU trans15_Press_SENSOR_SERIAL_NUMBER_page; \
	COMMAND trans15_Press_SENSOR_SERIAL_NUMBER_read; \
	COLLECTION trans15_Press_PRIMARY_VALUE; \
	VARIABLE trans15_Press_PRIMARY_VALUE_Value; \
	VARIABLE trans15_Press_PRIMARY_VALUE_Status_Quality; \
	VARIABLE trans15_Press_PRIMARY_VALUE_Status_Limit; \
	MENU trans15_Press_PRIMARY_VALUE_page; \
	COMMAND trans15_Press_PRIMARY_VALUE_read; \
	VARIABLE trans15_Press_PRIMARY_VALUE_UNIT; \
	MENU trans15_Press_PRIMARY_VALUE_UNIT_page; \
	COMMAND trans15_Press_PRIMARY_VALUE_UNIT_read; \
	COMMAND trans15_Press_PRIMARY_VALUE_UNIT_write; \
	VARIABLE trans15_Press_PRIMARY_VALUE_TYPE; \
	MENU trans15_Press_PRIMARY_VALUE_TYPE_page; \
	COMMAND trans15_Press_PRIMARY_VALUE_TYPE_read; \
	COMMAND trans15_Press_PRIMARY_VALUE_TYPE_write; \
	VARIABLE trans15_Press_LIN_TYPE; \
	MENU trans15_Press_LIN_TYPE_page; \
	COMMAND trans15_Press_LIN_TYPE_read; \
	COMMAND trans15_Press_LIN_TYPE_write; \
	COLLECTION trans15_Press_VIEW_1; \
	MENU trans15_Press_VIEW_1_page; \
	MENU trans15_Press_Simple_Dialog_Optional_A; \
	UNIT trans15_Press_PRIMARY_VALUE_UNIT_unit_1; \
	UNIT trans15_Press_Sensor_unit_1

#define USE_TRANS15_PRESS_OPTIONAL_B \
	USE_TRANS15_PRESS_OPTIONAL_BOTH; \
	MENU trans15_Press_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS15_PRESS_MANDATORY_A USE_TRANS_PRESS_MANDATORY_A(trans15_Press_)
#define USE_TRANS15_PRESS_MANDATORY_B USE_TRANS_PRESS_MANDATORY_B(trans15_Press_)
#define USE_TRANS15_PRESS_OPTIONAL_A  USE_TRANS_PRESS_OPTIONAL_A(trans15_Press_)
#define USE_TRANS15_PRESS_OPTIONAL_B  USE_TRANS_PRESS_OPTIONAL_B(trans15_Press_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC1_AI_MANDATORY_BOTH \
	BLOCK func1_AI_block; \
	COLLECTION func1_AI_BLOCK_OBJECT; \
	VARIABLE func1_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func1_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func1_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func1_AI_BLOCK_OBJECT_Class; \
	VARIABLE func1_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func1_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func1_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func1_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func1_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func1_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func1_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func1_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func1_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func1_AI_BLOCK_OBJECT_page; \
	COMMAND func1_AI_BLOCK_OBJECT_read; \
	VARIABLE func1_AI_ST_REV; \
	MENU func1_AI_ST_REV_page; \
	COMMAND func1_AI_ST_REV_read; \
	VARIABLE func1_AI_TAG_DESC; \
	MENU func1_AI_TAG_DESC_page; \
	COMMAND func1_AI_TAG_DESC_read; \
	COMMAND func1_AI_TAG_DESC_write; \
	VARIABLE func1_AI_STRATEGY; \
	MENU func1_AI_STRATEGY_page; \
	COMMAND func1_AI_STRATEGY_read; \
	COMMAND func1_AI_STRATEGY_write; \
	VARIABLE func1_AI_ALERT_KEY; \
	MENU func1_AI_ALERT_KEY_page; \
	COMMAND func1_AI_ALERT_KEY_read; \
	COMMAND func1_AI_ALERT_KEY_write; \
	VARIABLE func1_AI_TARGET_MODE; \
	MENU func1_AI_TARGET_MODE_page; \
	COMMAND func1_AI_TARGET_MODE_read; \
	COMMAND func1_AI_TARGET_MODE_write; \
	COLLECTION func1_AI_MODE_BLK; \
	VARIABLE func1_AI_MODE_BLK_Actual; \
	VARIABLE func1_AI_MODE_BLK_Permitted; \
	VARIABLE func1_AI_MODE_BLK_Normal; \
	MENU func1_AI_MODE_BLK_page; \
	COMMAND func1_AI_MODE_BLK_read; \
	COLLECTION func1_AI_ALARM_SUM; \
	VARIABLE func1_AI_ALARM_SUM_Current; \
	VARIABLE func1_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func1_AI_ALARM_SUM_Unreported; \
	VARIABLE func1_AI_ALARM_SUM_Disabled; \
	MENU func1_AI_ALARM_SUM_page; \
	COMMAND func1_AI_ALARM_SUM_read; \
	COLLECTION func1_AI_BATCH; \
	VARIABLE func1_AI_BATCH_Batch_ID; \
	VARIABLE func1_AI_BATCH_Rup; \
	VARIABLE func1_AI_BATCH_Operation; \
	VARIABLE func1_AI_BATCH_Phase; \
	MENU func1_AI_BATCH_page; \
	COMMAND func1_AI_BATCH_read; \
	COMMAND func1_AI_BATCH_write; \
	COLLECTION func1_AI_OUT; \
	VARIABLE func1_AI_OUT_Value; \
	VARIABLE func1_AI_OUT_Status_Quality; \
	VARIABLE func1_AI_OUT_Status_Limit; \
	MENU func1_AI_OUT_page; \
	COMMAND func1_AI_OUT_read; \
	COMMAND func1_AI_OUT_write; \
	COLLECTION func1_AI_PV_SCALE; \
	VARIABLE func1_AI_PV_SCALE_Upper_Value; \
	VARIABLE func1_AI_PV_SCALE_Lower_Value; \
	MENU func1_AI_PV_SCALE_page; \
	COMMAND func1_AI_PV_SCALE_read; \
	COMMAND func1_AI_PV_SCALE_write; \
	VARIABLE func1_AI_PV_FTIME; \
	MENU func1_AI_PV_FTIME_page; \
	COMMAND func1_AI_PV_FTIME_read; \
	COMMAND func1_AI_PV_FTIME_write; \
	VARIABLE func1_AI_ALARM_HYS; \
	MENU func1_AI_ALARM_HYS_page; \
	COMMAND func1_AI_ALARM_HYS_read; \
	COMMAND func1_AI_ALARM_HYS_write; \
	VARIABLE func1_AI_HI_HI_LIM; \
	MENU func1_AI_HI_HI_LIM_page; \
	COMMAND func1_AI_HI_HI_LIM_read; \
	COMMAND func1_AI_HI_HI_LIM_write; \
	VARIABLE func1_AI_HI_LIM; \
	MENU func1_AI_HI_LIM_page; \
	COMMAND func1_AI_HI_LIM_read; \
	COMMAND func1_AI_HI_LIM_write; \
	VARIABLE func1_AI_LO_LIM; \
	MENU func1_AI_LO_LIM_page; \
	COMMAND func1_AI_LO_LIM_read; \
	COMMAND func1_AI_LO_LIM_write; \
	VARIABLE func1_AI_LO_LO_LIM; \
	MENU func1_AI_LO_LO_LIM_page; \
	COMMAND func1_AI_LO_LO_LIM_read; \
	COMMAND func1_AI_LO_LO_LIM_write

#define USE_FUNC1_AI_MANDATORY_A \
	USE_FUNC1_AI_MANDATORY_BOTH; \
	MENU func1_AI_Simple_Dialog_Mandatory_A; \
	MENU func1_AI_Display_mandatory_A; \
	CHART func1_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func1_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func1_AI_Display_out_mandatory_A; \
	MENU func1_AI_Tab_s_mandatory_A; \
	MENU func1_AI_Tab_s_pv_range_mandatory_A; \
	MENU func1_AI_Tab_s_limits_mandatory_A; \
	MENU func1_AI_Tab_m_mandatory_A; \
	MENU func1_AI_Tab_m_pv_range_mandatory_A; \
	MENU func1_AI_Tab_m_limits_mandatory_A

#define USE_FUNC1_AI_MANDATORY_B \
	USE_FUNC1_AI_MANDATORY_BOTH; \
	COLLECTION func1_AI_OUT_SCALE; \
	VARIABLE func1_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func1_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func1_AI_OUT_SCALE_Units_Index; \
	VARIABLE func1_AI_OUT_SCALE_Decimal_Point; \
	MENU func1_AI_OUT_SCALE_page; \
	COMMAND func1_AI_OUT_SCALE_read; \
	COMMAND func1_AI_OUT_SCALE_write; \
	VARIABLE func1_AI_LIN_TYPE; \
	MENU func1_AI_LIN_TYPE_page; \
	COMMAND func1_AI_LIN_TYPE_read; \
	COMMAND func1_AI_LIN_TYPE_write; \
	VARIABLE func1_AI_CHANNEL; \
	MENU func1_AI_CHANNEL_page; \
	COMMAND func1_AI_CHANNEL_read; \
	COMMAND func1_AI_CHANNEL_write; \
	COLLECTION func1_AI_SIMULATE; \
	VARIABLE func1_AI_SIMULATE_Status_Quality; \
	VARIABLE func1_AI_SIMULATE_Status_Limit; \
	VARIABLE func1_AI_SIMULATE_Value; \
	VARIABLE func1_AI_SIMULATE_Enabled; \
	MENU func1_AI_SIMULATE_page; \
	COMMAND func1_AI_SIMULATE_read; \
	COMMAND func1_AI_SIMULATE_write; \
	COLLECTION func1_AI_VIEW_1; \
	MENU func1_AI_VIEW_1_page; \
	MENU func1_AI_Simple_Dialog_Mandatory_B; \
	UNIT func1_AI_OUT_SCALE_unit_1; \
	MENU func1_AI_Simulation; \
	MENU func1_AI_Simulation_input; \
	MENU func1_AI_Simulation_input_group; \
	MENU func1_AI_Simulation_output; \
	MENU func1_AI_Simulation_output_group; \
	MENU func1_AI_Display_mandatory_B; \
	CHART func1_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func1_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func1_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func1_AI_Display_out_mandatory_B; \
	MENU func1_AI_Display_in_mandatory_B; \
	MENU func1_AI_Tab_s_mandatory_B; \
	MENU func1_AI_Tab_s_pv_range_mandatory_B; \
	MENU func1_AI_Tab_s_outscale_mandatory_B; \
	MENU func1_AI_Tab_s_limits_mandatory_B; \
	MENU func1_AI_Tab_s_interface_mandatory_B; \
	MENU func1_AI_Tab_m_mandatory_B; \
	MENU func1_AI_Tab_m_pv_range_mandatory_B; \
	MENU func1_AI_Tab_m_outscale_mandatory_B; \
	MENU func1_AI_Tab_m_limits_mandatory_B

#define USE_FUNC1_AI_OPTIONAL_BOTH \
	VARIABLE func1_AI_FSAFE_TYPE; \
	MENU func1_AI_FSAFE_TYPE_page; \
	COMMAND func1_AI_FSAFE_TYPE_read; \
	COMMAND func1_AI_FSAFE_TYPE_write; \
	VARIABLE func1_AI_FSAFE_VALUE; \
	MENU func1_AI_FSAFE_VALUE_page; \
	COMMAND func1_AI_FSAFE_VALUE_read; \
	COMMAND func1_AI_FSAFE_VALUE_write; \
	COLLECTION func1_AI_HI_HI_ALM; \
	VARIABLE func1_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func1_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func1_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func1_AI_HI_HI_ALM_Subcode; \
	VARIABLE func1_AI_HI_HI_ALM_Value; \
	MENU func1_AI_HI_HI_ALM_page; \
	COMMAND func1_AI_HI_HI_ALM_read; \
	COLLECTION func1_AI_HI_ALM; \
	VARIABLE func1_AI_HI_ALM_Unacknowledged; \
	VARIABLE func1_AI_HI_ALM_Alarm_State; \
	VARIABLE func1_AI_HI_ALM_Time_Stamp; \
	VARIABLE func1_AI_HI_ALM_Subcode; \
	VARIABLE func1_AI_HI_ALM_Value; \
	MENU func1_AI_HI_ALM_page; \
	COMMAND func1_AI_HI_ALM_read; \
	COLLECTION func1_AI_LO_ALM; \
	VARIABLE func1_AI_LO_ALM_Unacknowledged; \
	VARIABLE func1_AI_LO_ALM_Alarm_State; \
	VARIABLE func1_AI_LO_ALM_Time_Stamp; \
	VARIABLE func1_AI_LO_ALM_Subcode; \
	VARIABLE func1_AI_LO_ALM_Value; \
	MENU func1_AI_LO_ALM_page; \
	COMMAND func1_AI_LO_ALM_read; \
	COLLECTION func1_AI_LO_LO_ALM; \
	VARIABLE func1_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func1_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func1_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func1_AI_LO_LO_ALM_Subcode; \
	VARIABLE func1_AI_LO_LO_ALM_Value; \
	MENU func1_AI_LO_LO_ALM_page; \
	COMMAND func1_AI_LO_LO_ALM_read; \
	VARIABLE func1_AI_OUT_UNIT_TEXT; \
	MENU func1_AI_OUT_UNIT_TEXT_page; \
	COMMAND func1_AI_OUT_UNIT_TEXT_read; \
	COMMAND func1_AI_OUT_UNIT_TEXT_write

#define USE_FUNC1_AI_OPTIONAL_A \
	USE_FUNC1_AI_OPTIONAL_BOTH; \
	COLLECTION func1_AI_OUT_SCALE; \
	VARIABLE func1_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func1_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func1_AI_OUT_SCALE_Units_Index; \
	VARIABLE func1_AI_OUT_SCALE_Decimal_Point; \
	MENU func1_AI_OUT_SCALE_page; \
	COMMAND func1_AI_OUT_SCALE_read; \
	COMMAND func1_AI_OUT_SCALE_write; \
	VARIABLE func1_AI_LIN_TYPE; \
	MENU func1_AI_LIN_TYPE_page; \
	COMMAND func1_AI_LIN_TYPE_read; \
	COMMAND func1_AI_LIN_TYPE_write; \
	VARIABLE func1_AI_CHANNEL; \
	MENU func1_AI_CHANNEL_page; \
	COMMAND func1_AI_CHANNEL_read; \
	COMMAND func1_AI_CHANNEL_write; \
	COLLECTION func1_AI_SIMULATE; \
	VARIABLE func1_AI_SIMULATE_Status_Quality; \
	VARIABLE func1_AI_SIMULATE_Status_Limit; \
	VARIABLE func1_AI_SIMULATE_Value; \
	VARIABLE func1_AI_SIMULATE_Enabled; \
	MENU func1_AI_SIMULATE_page; \
	COMMAND func1_AI_SIMULATE_read; \
	COMMAND func1_AI_SIMULATE_write; \
	COLLECTION func1_AI_VIEW_1; \
	MENU func1_AI_VIEW_1_page; \
	MENU func1_AI_Simple_Dialog_Optional_A; \
	UNIT func1_AI_OUT_SCALE_unit_1; \
	UNIT func1_AI_OUT_SCALE_unit_2

#define USE_FUNC1_AI_OPTIONAL_B \
	USE_FUNC1_AI_OPTIONAL_BOTH; \
	MENU func1_AI_Simple_Dialog_Optional_B; \
	UNIT func1_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC_AI_MANDATORY_BOTH(prefix) \
	BLOCK prefix ## block; \
	COLLECTION prefix ## BLOCK_OBJECT; \
	VARIABLE prefix ## BLOCK_OBJECT_Reserved; \
	VARIABLE prefix ## BLOCK_OBJECT_Block_Object; \
	VARIABLE prefix ## BLOCK_OBJECT_Parent_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Reference; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Execution_Time; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Views; \
	MENU prefix ## BLOCK_OBJECT_page; \
	COMMAND prefix ## BLOCK_OBJECT_read; \
	VARIABLE prefix ## ST_REV; \
	MENU prefix ## ST_REV_page; \
	COMMAND prefix ## ST_REV_read; \
	VARIABLE prefix ## TAG_DESC; \
	MENU prefix ## TAG_DESC_page; \
	COMMAND prefix ## TAG_DESC_read; \
	COMMAND prefix ## TAG_DESC_write; \
	VARIABLE prefix ## STRATEGY; \
	MENU prefix ## STRATEGY_page; \
	COMMAND prefix ## STRATEGY_read; \
	COMMAND prefix ## STRATEGY_write; \
	VARIABLE prefix ## ALERT_KEY; \
	MENU prefix ## ALERT_KEY_page; \
	COMMAND prefix ## ALERT_KEY_read; \
	COMMAND prefix ## ALERT_KEY_write; \
	VARIABLE prefix ## TARGET_MODE; \
	MENU prefix ## TARGET_MODE_page; \
	COMMAND prefix ## TARGET_MODE_read; \
	COMMAND prefix ## TARGET_MODE_write; \
	COLLECTION prefix ## MODE_BLK; \
	VARIABLE prefix ## MODE_BLK_Actual; \
	VARIABLE prefix ## MODE_BLK_Permitted; \
	VARIABLE prefix ## MODE_BLK_Normal; \
	MENU prefix ## MODE_BLK_page; \
	COMMAND prefix ## MODE_BLK_read; \
	COLLECTION prefix ## ALARM_SUM; \
	VARIABLE prefix ## ALARM_SUM_Current; \
	VARIABLE prefix ## ALARM_SUM_Unacknowledged; \
	VARIABLE prefix ## ALARM_SUM_Unreported; \
	VARIABLE prefix ## ALARM_SUM_Disabled; \
	MENU prefix ## ALARM_SUM_page; \
	COMMAND prefix ## ALARM_SUM_read; \
	COLLECTION prefix ## BATCH; \
	VARIABLE prefix ## BATCH_Batch_ID; \
	VARIABLE prefix ## BATCH_Rup; \
	VARIABLE prefix ## BATCH_Operation; \
	VARIABLE prefix ## BATCH_Phase; \
	MENU prefix ## BATCH_page; \
	COMMAND prefix ## BATCH_read; \
	COMMAND prefix ## BATCH_write; \
	COLLECTION prefix ## OUT; \
	VARIABLE prefix ## OUT_Value; \
	VARIABLE prefix ## OUT_Status_Quality; \
	VARIABLE prefix ## OUT_Status_Limit; \
	MENU prefix ## OUT_page; \
	COMMAND prefix ## OUT_read; \
	COMMAND prefix ## OUT_write; \
	COLLECTION prefix ## PV_SCALE; \
	VARIABLE prefix ## PV_SCALE_Upper_Value; \
	VARIABLE prefix ## PV_SCALE_Lower_Value; \
	MENU prefix ## PV_SCALE_page; \
	COMMAND prefix ## PV_SCALE_read; \
	COMMAND prefix ## PV_SCALE_write; \
	VARIABLE prefix ## PV_FTIME; \
	MENU prefix ## PV_FTIME_page; \
	COMMAND prefix ## PV_FTIME_read; \
	COMMAND prefix ## PV_FTIME_write; \
	VARIABLE prefix ## ALARM_HYS; \
	MENU prefix ## ALARM_HYS_page; \
	COMMAND prefix ## ALARM_HYS_read; \
	COMMAND prefix ## ALARM_HYS_write; \
	VARIABLE prefix ## HI_HI_LIM; \
	MENU prefix ## HI_HI_LIM_page; \
	COMMAND prefix ## HI_HI_LIM_read; \
	COMMAND prefix ## HI_HI_LIM_write; \
	VARIABLE prefix ## HI_LIM; \
	MENU prefix ## HI_LIM_page; \
	COMMAND prefix ## HI_LIM_read; \
	COMMAND prefix ## HI_LIM_write; \
	VARIABLE prefix ## LO_LIM; \
	MENU prefix ## LO_LIM_page; \
	COMMAND prefix ## LO_LIM_read; \
	COMMAND prefix ## LO_LIM_write; \
	VARIABLE prefix ## LO_LO_LIM; \
	MENU prefix ## LO_LO_LIM_page; \
	COMMAND prefix ## LO_LO_LIM_read; \
	COMMAND prefix ## LO_LO_LIM_write

#define USE_FUNC_AI_MANDATORY_A(prefix) \
	USE_FUNC_AI_MANDATORY_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Mandatory_A; \
	MENU prefix ## Display_mandatory_A; \
	CHART prefix ## Display_BarVal_out_mandatory_A; \
	SOURCE prefix ## Display_BarVal_out_source_mandatory_A; \
	MENU prefix ## Display_out_mandatory_A; \
	MENU prefix ## Tab_s_mandatory_A; \
	MENU prefix ## Tab_s_pv_range_mandatory_A; \
	MENU prefix ## Tab_s_limits_mandatory_A; \
	MENU prefix ## Tab_m_mandatory_A; \
	MENU prefix ## Tab_m_pv_range_mandatory_A; \
	MENU prefix ## Tab_m_limits_mandatory_A

#define USE_FUNC_AI_MANDATORY_B(prefix) \
	USE_FUNC_AI_MANDATORY_BOTH(prefix); \
	COLLECTION prefix ## OUT_SCALE; \
	VARIABLE prefix ## OUT_SCALE_Upper_Value; \
	VARIABLE prefix ## OUT_SCALE_Lower_Value; \
	VARIABLE prefix ## OUT_SCALE_Units_Index; \
	VARIABLE prefix ## OUT_SCALE_Decimal_Point; \
	MENU prefix ## OUT_SCALE_page; \
	COMMAND prefix ## OUT_SCALE_read; \
	COMMAND prefix ## OUT_SCALE_write; \
	VARIABLE prefix ## LIN_TYPE; \
	MENU prefix ## LIN_TYPE_page; \
	COMMAND prefix ## LIN_TYPE_read; \
	COMMAND prefix ## LIN_TYPE_write; \
	VARIABLE prefix ## CHANNEL; \
	MENU prefix ## CHANNEL_page; \
	COMMAND prefix ## CHANNEL_read; \
	COMMAND prefix ## CHANNEL_write; \
	COLLECTION prefix ## SIMULATE; \
	VARIABLE prefix ## SIMULATE_Status_Quality; \
	VARIABLE prefix ## SIMULATE_Status_Limit; \
	VARIABLE prefix ## SIMULATE_Value; \
	VARIABLE prefix ## SIMULATE_Enabled; \
	MENU prefix ## SIMULATE_page; \
	COMMAND prefix ## SIMULATE_read; \
	COMMAND prefix ## SIMULATE_write; \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Mandatory_B; \
	UNIT prefix ## OUT_SCALE_unit_1; \
	MENU prefix ## Simulation; \
	MENU prefix ## Simulation_input; \
	MENU prefix ## Simulation_input_group; \
	MENU prefix ## Simulation_output; \
	MENU prefix ## Simulation_output_group; \
	MENU prefix ## Display_mandatory_B; \
	CHART prefix ## Display_BarVal_out_mandatory_B; \
	SOURCE prefix ## Display_BarVal_out_source_mandatory_B; \
	AXIS prefix ## Display_BarVal_out_axis_mandatory_B; \
	MENU prefix ## Display_out_mandatory_B; \
	MENU prefix ## Display_in_mandatory_B; \
	MENU prefix ## Tab_s_mandatory_B; \
	MENU prefix ## Tab_s_pv_range_mandatory_B; \
	MENU prefix ## Tab_s_outscale_mandatory_B; \
	MENU prefix ## Tab_s_limits_mandatory_B; \
	MENU prefix ## Tab_s_interface_mandatory_B; \
	MENU prefix ## Tab_m_mandatory_B; \
	MENU prefix ## Tab_m_pv_range_mandatory_B; \
	MENU prefix ## Tab_m_outscale_mandatory_B; \
	MENU prefix ## Tab_m_limits_mandatory_B

#define USE_FUNC_AI_OPTIONAL_BOTH(prefix) \
	VARIABLE prefix ## FSAFE_TYPE; \
	MENU prefix ## FSAFE_TYPE_page; \
	COMMAND prefix ## FSAFE_TYPE_read; \
	COMMAND prefix ## FSAFE_TYPE_write; \
	VARIABLE prefix ## FSAFE_VALUE; \
	MENU prefix ## FSAFE_VALUE_page; \
	COMMAND prefix ## FSAFE_VALUE_read; \
	COMMAND prefix ## FSAFE_VALUE_write; \
	COLLECTION prefix ## HI_HI_ALM; \
	VARIABLE prefix ## HI_HI_ALM_Unacknowledged; \
	VARIABLE prefix ## HI_HI_ALM_Alarm_State; \
	VARIABLE prefix ## HI_HI_ALM_Time_Stamp; \
	VARIABLE prefix ## HI_HI_ALM_Subcode; \
	VARIABLE prefix ## HI_HI_ALM_Value; \
	MENU prefix ## HI_HI_ALM_page; \
	COMMAND prefix ## HI_HI_ALM_read; \
	COLLECTION prefix ## HI_ALM; \
	VARIABLE prefix ## HI_ALM_Unacknowledged; \
	VARIABLE prefix ## HI_ALM_Alarm_State; \
	VARIABLE prefix ## HI_ALM_Time_Stamp; \
	VARIABLE prefix ## HI_ALM_Subcode; \
	VARIABLE prefix ## HI_ALM_Value; \
	MENU prefix ## HI_ALM_page; \
	COMMAND prefix ## HI_ALM_read; \
	COLLECTION prefix ## LO_ALM; \
	VARIABLE prefix ## LO_ALM_Unacknowledged; \
	VARIABLE prefix ## LO_ALM_Alarm_State; \
	VARIABLE prefix ## LO_ALM_Time_Stamp; \
	VARIABLE prefix ## LO_ALM_Subcode; \
	VARIABLE prefix ## LO_ALM_Value; \
	MENU prefix ## LO_ALM_page; \
	COMMAND prefix ## LO_ALM_read; \
	COLLECTION prefix ## LO_LO_ALM; \
	VARIABLE prefix ## LO_LO_ALM_Unacknowledged; \
	VARIABLE prefix ## LO_LO_ALM_Alarm_State; \
	VARIABLE prefix ## LO_LO_ALM_Time_Stamp; \
	VARIABLE prefix ## LO_LO_ALM_Subcode; \
	VARIABLE prefix ## LO_LO_ALM_Value; \
	MENU prefix ## LO_LO_ALM_page; \
	COMMAND prefix ## LO_LO_ALM_read; \
	VARIABLE prefix ## OUT_UNIT_TEXT; \
	MENU prefix ## OUT_UNIT_TEXT_page; \
	COMMAND prefix ## OUT_UNIT_TEXT_read; \
	COMMAND prefix ## OUT_UNIT_TEXT_write

#define USE_FUNC_AI_OPTIONAL_A(prefix) \
	USE_FUNC_AI_OPTIONAL_BOTH(prefix); \
	COLLECTION prefix ## OUT_SCALE; \
	VARIABLE prefix ## OUT_SCALE_Upper_Value; \
	VARIABLE prefix ## OUT_SCALE_Lower_Value; \
	VARIABLE prefix ## OUT_SCALE_Units_Index; \
	VARIABLE prefix ## OUT_SCALE_Decimal_Point; \
	MENU prefix ## OUT_SCALE_page; \
	COMMAND prefix ## OUT_SCALE_read; \
	COMMAND prefix ## OUT_SCALE_write; \
	VARIABLE prefix ## LIN_TYPE; \
	MENU prefix ## LIN_TYPE_page; \
	COMMAND prefix ## LIN_TYPE_read; \
	COMMAND prefix ## LIN_TYPE_write; \
	VARIABLE prefix ## CHANNEL; \
	MENU prefix ## CHANNEL_page; \
	COMMAND prefix ## CHANNEL_read; \
	COMMAND prefix ## CHANNEL_write; \
	COLLECTION prefix ## SIMULATE; \
	VARIABLE prefix ## SIMULATE_Status_Quality; \
	VARIABLE prefix ## SIMULATE_Status_Limit; \
	VARIABLE prefix ## SIMULATE_Value; \
	VARIABLE prefix ## SIMULATE_Enabled; \
	MENU prefix ## SIMULATE_page; \
	COMMAND prefix ## SIMULATE_read; \
	COMMAND prefix ## SIMULATE_write; \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Optional_A; \
	UNIT prefix ## OUT_SCALE_unit_1; \
	UNIT prefix ## OUT_SCALE_unit_2

#define USE_FUNC_AI_OPTIONAL_B(prefix) \
	USE_FUNC_AI_OPTIONAL_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Optional_B; \
	UNIT prefix ## OUT_SCALE_unit_2

#define USE_FUNC1_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func1_AI_)
#define USE_FUNC1_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func1_AI_)
#define USE_FUNC1_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func1_AI_)
#define USE_FUNC1_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func1_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC2_AI_MANDATORY_BOTH \
	BLOCK func2_AI_block; \
	COLLECTION func2_AI_BLOCK_OBJECT; \
	VARIABLE func2_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func2_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func2_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func2_AI_BLOCK_OBJECT_Class; \
	VARIABLE func2_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func2_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func2_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func2_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func2_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func2_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func2_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func2_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func2_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func2_AI_BLOCK_OBJECT_page; \
	COMMAND func2_AI_BLOCK_OBJECT_read; \
	VARIABLE func2_AI_ST_REV; \
	MENU func2_AI_ST_REV_page; \
	COMMAND func2_AI_ST_REV_read; \
	VARIABLE func2_AI_TAG_DESC; \
	MENU func2_AI_TAG_DESC_page; \
	COMMAND func2_AI_TAG_DESC_read; \
	COMMAND func2_AI_TAG_DESC_write; \
	VARIABLE func2_AI_STRATEGY; \
	MENU func2_AI_STRATEGY_page; \
	COMMAND func2_AI_STRATEGY_read; \
	COMMAND func2_AI_STRATEGY_write; \
	VARIABLE func2_AI_ALERT_KEY; \
	MENU func2_AI_ALERT_KEY_page; \
	COMMAND func2_AI_ALERT_KEY_read; \
	COMMAND func2_AI_ALERT_KEY_write; \
	VARIABLE func2_AI_TARGET_MODE; \
	MENU func2_AI_TARGET_MODE_page; \
	COMMAND func2_AI_TARGET_MODE_read; \
	COMMAND func2_AI_TARGET_MODE_write; \
	COLLECTION func2_AI_MODE_BLK; \
	VARIABLE func2_AI_MODE_BLK_Actual; \
	VARIABLE func2_AI_MODE_BLK_Permitted; \
	VARIABLE func2_AI_MODE_BLK_Normal; \
	MENU func2_AI_MODE_BLK_page; \
	COMMAND func2_AI_MODE_BLK_read; \
	COLLECTION func2_AI_ALARM_SUM; \
	VARIABLE func2_AI_ALARM_SUM_Current; \
	VARIABLE func2_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func2_AI_ALARM_SUM_Unreported; \
	VARIABLE func2_AI_ALARM_SUM_Disabled; \
	MENU func2_AI_ALARM_SUM_page; \
	COMMAND func2_AI_ALARM_SUM_read; \
	COLLECTION func2_AI_BATCH; \
	VARIABLE func2_AI_BATCH_Batch_ID; \
	VARIABLE func2_AI_BATCH_Rup; \
	VARIABLE func2_AI_BATCH_Operation; \
	VARIABLE func2_AI_BATCH_Phase; \
	MENU func2_AI_BATCH_page; \
	COMMAND func2_AI_BATCH_read; \
	COMMAND func2_AI_BATCH_write; \
	COLLECTION func2_AI_OUT; \
	VARIABLE func2_AI_OUT_Value; \
	VARIABLE func2_AI_OUT_Status_Quality; \
	VARIABLE func2_AI_OUT_Status_Limit; \
	MENU func2_AI_OUT_page; \
	COMMAND func2_AI_OUT_read; \
	COMMAND func2_AI_OUT_write; \
	COLLECTION func2_AI_PV_SCALE; \
	VARIABLE func2_AI_PV_SCALE_Upper_Value; \
	VARIABLE func2_AI_PV_SCALE_Lower_Value; \
	MENU func2_AI_PV_SCALE_page; \
	COMMAND func2_AI_PV_SCALE_read; \
	COMMAND func2_AI_PV_SCALE_write; \
	VARIABLE func2_AI_PV_FTIME; \
	MENU func2_AI_PV_FTIME_page; \
	COMMAND func2_AI_PV_FTIME_read; \
	COMMAND func2_AI_PV_FTIME_write; \
	VARIABLE func2_AI_ALARM_HYS; \
	MENU func2_AI_ALARM_HYS_page; \
	COMMAND func2_AI_ALARM_HYS_read; \
	COMMAND func2_AI_ALARM_HYS_write; \
	VARIABLE func2_AI_HI_HI_LIM; \
	MENU func2_AI_HI_HI_LIM_page; \
	COMMAND func2_AI_HI_HI_LIM_read; \
	COMMAND func2_AI_HI_HI_LIM_write; \
	VARIABLE func2_AI_HI_LIM; \
	MENU func2_AI_HI_LIM_page; \
	COMMAND func2_AI_HI_LIM_read; \
	COMMAND func2_AI_HI_LIM_write; \
	VARIABLE func2_AI_LO_LIM; \
	MENU func2_AI_LO_LIM_page; \
	COMMAND func2_AI_LO_LIM_read; \
	COMMAND func2_AI_LO_LIM_write; \
	VARIABLE func2_AI_LO_LO_LIM; \
	MENU func2_AI_LO_LO_LIM_page; \
	COMMAND func2_AI_LO_LO_LIM_read; \
	COMMAND func2_AI_LO_LO_LIM_write

#define USE_FUNC2_AI_MANDATORY_A \
	USE_FUNC2_AI_MANDATORY_BOTH; \
	MENU func2_AI_Simple_Dialog_Mandatory_A; \
	MENU func2_AI_Display_mandatory_A; \
	CHART func2_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func2_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func2_AI_Display_out_mandatory_A; \
	MENU func2_AI_Tab_s_mandatory_A; \
	MENU func2_AI_Tab_s_pv_range_mandatory_A; \
	MENU func2_AI_Tab_s_limits_mandatory_A; \
	MENU func2_AI_Tab_m_mandatory_A; \
	MENU func2_AI_Tab_m_pv_range_mandatory_A; \
	MENU func2_AI_Tab_m_limits_mandatory_A

#define USE_FUNC2_AI_MANDATORY_B \
	USE_FUNC2_AI_MANDATORY_BOTH; \
	COLLECTION func2_AI_OUT_SCALE; \
	VARIABLE func2_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func2_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func2_AI_OUT_SCALE_Units_Index; \
	VARIABLE func2_AI_OUT_SCALE_Decimal_Point; \
	MENU func2_AI_OUT_SCALE_page; \
	COMMAND func2_AI_OUT_SCALE_read; \
	COMMAND func2_AI_OUT_SCALE_write; \
	VARIABLE func2_AI_LIN_TYPE; \
	MENU func2_AI_LIN_TYPE_page; \
	COMMAND func2_AI_LIN_TYPE_read; \
	COMMAND func2_AI_LIN_TYPE_write; \
	VARIABLE func2_AI_CHANNEL; \
	MENU func2_AI_CHANNEL_page; \
	COMMAND func2_AI_CHANNEL_read; \
	COMMAND func2_AI_CHANNEL_write; \
	COLLECTION func2_AI_SIMULATE; \
	VARIABLE func2_AI_SIMULATE_Status_Quality; \
	VARIABLE func2_AI_SIMULATE_Status_Limit; \
	VARIABLE func2_AI_SIMULATE_Value; \
	VARIABLE func2_AI_SIMULATE_Enabled; \
	MENU func2_AI_SIMULATE_page; \
	COMMAND func2_AI_SIMULATE_read; \
	COMMAND func2_AI_SIMULATE_write; \
	COLLECTION func2_AI_VIEW_1; \
	MENU func2_AI_VIEW_1_page; \
	MENU func2_AI_Simple_Dialog_Mandatory_B; \
	UNIT func2_AI_OUT_SCALE_unit_1; \
	MENU func2_AI_Simulation; \
	MENU func2_AI_Simulation_input; \
	MENU func2_AI_Simulation_input_group; \
	MENU func2_AI_Simulation_output; \
	MENU func2_AI_Simulation_output_group; \
	MENU func2_AI_Display_mandatory_B; \
	CHART func2_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func2_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func2_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func2_AI_Display_out_mandatory_B; \
	MENU func2_AI_Display_in_mandatory_B; \
	MENU func2_AI_Tab_s_mandatory_B; \
	MENU func2_AI_Tab_s_pv_range_mandatory_B; \
	MENU func2_AI_Tab_s_outscale_mandatory_B; \
	MENU func2_AI_Tab_s_limits_mandatory_B; \
	MENU func2_AI_Tab_s_interface_mandatory_B; \
	MENU func2_AI_Tab_m_mandatory_B; \
	MENU func2_AI_Tab_m_pv_range_mandatory_B; \
	MENU func2_AI_Tab_m_outscale_mandatory_B; \
	MENU func2_AI_Tab_m_limits_mandatory_B

#define USE_FUNC2_AI_OPTIONAL_BOTH \
	VARIABLE func2_AI_FSAFE_TYPE; \
	MENU func2_AI_FSAFE_TYPE_page; \
	COMMAND func2_AI_FSAFE_TYPE_read; \
	COMMAND func2_AI_FSAFE_TYPE_write; \
	VARIABLE func2_AI_FSAFE_VALUE; \
	MENU func2_AI_FSAFE_VALUE_page; \
	COMMAND func2_AI_FSAFE_VALUE_read; \
	COMMAND func2_AI_FSAFE_VALUE_write; \
	COLLECTION func2_AI_HI_HI_ALM; \
	VARIABLE func2_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func2_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func2_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func2_AI_HI_HI_ALM_Subcode; \
	VARIABLE func2_AI_HI_HI_ALM_Value; \
	MENU func2_AI_HI_HI_ALM_page; \
	COMMAND func2_AI_HI_HI_ALM_read; \
	COLLECTION func2_AI_HI_ALM; \
	VARIABLE func2_AI_HI_ALM_Unacknowledged; \
	VARIABLE func2_AI_HI_ALM_Alarm_State; \
	VARIABLE func2_AI_HI_ALM_Time_Stamp; \
	VARIABLE func2_AI_HI_ALM_Subcode; \
	VARIABLE func2_AI_HI_ALM_Value; \
	MENU func2_AI_HI_ALM_page; \
	COMMAND func2_AI_HI_ALM_read; \
	COLLECTION func2_AI_LO_ALM; \
	VARIABLE func2_AI_LO_ALM_Unacknowledged; \
	VARIABLE func2_AI_LO_ALM_Alarm_State; \
	VARIABLE func2_AI_LO_ALM_Time_Stamp; \
	VARIABLE func2_AI_LO_ALM_Subcode; \
	VARIABLE func2_AI_LO_ALM_Value; \
	MENU func2_AI_LO_ALM_page; \
	COMMAND func2_AI_LO_ALM_read; \
	COLLECTION func2_AI_LO_LO_ALM; \
	VARIABLE func2_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func2_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func2_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func2_AI_LO_LO_ALM_Subcode; \
	VARIABLE func2_AI_LO_LO_ALM_Value; \
	MENU func2_AI_LO_LO_ALM_page; \
	COMMAND func2_AI_LO_LO_ALM_read; \
	VARIABLE func2_AI_OUT_UNIT_TEXT; \
	MENU func2_AI_OUT_UNIT_TEXT_page; \
	COMMAND func2_AI_OUT_UNIT_TEXT_read; \
	COMMAND func2_AI_OUT_UNIT_TEXT_write

#define USE_FUNC2_AI_OPTIONAL_A \
	USE_FUNC2_AI_OPTIONAL_BOTH; \
	COLLECTION func2_AI_OUT_SCALE; \
	VARIABLE func2_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func2_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func2_AI_OUT_SCALE_Units_Index; \
	VARIABLE func2_AI_OUT_SCALE_Decimal_Point; \
	MENU func2_AI_OUT_SCALE_page; \
	COMMAND func2_AI_OUT_SCALE_read; \
	COMMAND func2_AI_OUT_SCALE_write; \
	VARIABLE func2_AI_LIN_TYPE; \
	MENU func2_AI_LIN_TYPE_page; \
	COMMAND func2_AI_LIN_TYPE_read; \
	COMMAND func2_AI_LIN_TYPE_write; \
	VARIABLE func2_AI_CHANNEL; \
	MENU func2_AI_CHANNEL_page; \
	COMMAND func2_AI_CHANNEL_read; \
	COMMAND func2_AI_CHANNEL_write; \
	COLLECTION func2_AI_SIMULATE; \
	VARIABLE func2_AI_SIMULATE_Status_Quality; \
	VARIABLE func2_AI_SIMULATE_Status_Limit; \
	VARIABLE func2_AI_SIMULATE_Value; \
	VARIABLE func2_AI_SIMULATE_Enabled; \
	MENU func2_AI_SIMULATE_page; \
	COMMAND func2_AI_SIMULATE_read; \
	COMMAND func2_AI_SIMULATE_write; \
	COLLECTION func2_AI_VIEW_1; \
	MENU func2_AI_VIEW_1_page; \
	MENU func2_AI_Simple_Dialog_Optional_A; \
	UNIT func2_AI_OUT_SCALE_unit_1; \
	UNIT func2_AI_OUT_SCALE_unit_2

#define USE_FUNC2_AI_OPTIONAL_B \
	USE_FUNC2_AI_OPTIONAL_BOTH; \
	MENU func2_AI_Simple_Dialog_Optional_B; \
	UNIT func2_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC2_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func2_AI_)
#define USE_FUNC2_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func2_AI_)
#define USE_FUNC2_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func2_AI_)
#define USE_FUNC2_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func2_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC3_AI_MANDATORY_BOTH \
	BLOCK func3_AI_block; \
	COLLECTION func3_AI_BLOCK_OBJECT; \
	VARIABLE func3_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func3_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func3_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func3_AI_BLOCK_OBJECT_Class; \
	VARIABLE func3_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func3_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func3_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func3_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func3_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func3_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func3_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func3_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func3_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func3_AI_BLOCK_OBJECT_page; \
	COMMAND func3_AI_BLOCK_OBJECT_read; \
	VARIABLE func3_AI_ST_REV; \
	MENU func3_AI_ST_REV_page; \
	COMMAND func3_AI_ST_REV_read; \
	VARIABLE func3_AI_TAG_DESC; \
	MENU func3_AI_TAG_DESC_page; \
	COMMAND func3_AI_TAG_DESC_read; \
	COMMAND func3_AI_TAG_DESC_write; \
	VARIABLE func3_AI_STRATEGY; \
	MENU func3_AI_STRATEGY_page; \
	COMMAND func3_AI_STRATEGY_read; \
	COMMAND func3_AI_STRATEGY_write; \
	VARIABLE func3_AI_ALERT_KEY; \
	MENU func3_AI_ALERT_KEY_page; \
	COMMAND func3_AI_ALERT_KEY_read; \
	COMMAND func3_AI_ALERT_KEY_write; \
	VARIABLE func3_AI_TARGET_MODE; \
	MENU func3_AI_TARGET_MODE_page; \
	COMMAND func3_AI_TARGET_MODE_read; \
	COMMAND func3_AI_TARGET_MODE_write; \
	COLLECTION func3_AI_MODE_BLK; \
	VARIABLE func3_AI_MODE_BLK_Actual; \
	VARIABLE func3_AI_MODE_BLK_Permitted; \
	VARIABLE func3_AI_MODE_BLK_Normal; \
	MENU func3_AI_MODE_BLK_page; \
	COMMAND func3_AI_MODE_BLK_read; \
	COLLECTION func3_AI_ALARM_SUM; \
	VARIABLE func3_AI_ALARM_SUM_Current; \
	VARIABLE func3_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func3_AI_ALARM_SUM_Unreported; \
	VARIABLE func3_AI_ALARM_SUM_Disabled; \
	MENU func3_AI_ALARM_SUM_page; \
	COMMAND func3_AI_ALARM_SUM_read; \
	COLLECTION func3_AI_BATCH; \
	VARIABLE func3_AI_BATCH_Batch_ID; \
	VARIABLE func3_AI_BATCH_Rup; \
	VARIABLE func3_AI_BATCH_Operation; \
	VARIABLE func3_AI_BATCH_Phase; \
	MENU func3_AI_BATCH_page; \
	COMMAND func3_AI_BATCH_read; \
	COMMAND func3_AI_BATCH_write; \
	COLLECTION func3_AI_OUT; \
	VARIABLE func3_AI_OUT_Value; \
	VARIABLE func3_AI_OUT_Status_Quality; \
	VARIABLE func3_AI_OUT_Status_Limit; \
	MENU func3_AI_OUT_page; \
	COMMAND func3_AI_OUT_read; \
	COMMAND func3_AI_OUT_write; \
	COLLECTION func3_AI_PV_SCALE; \
	VARIABLE func3_AI_PV_SCALE_Upper_Value; \
	VARIABLE func3_AI_PV_SCALE_Lower_Value; \
	MENU func3_AI_PV_SCALE_page; \
	COMMAND func3_AI_PV_SCALE_read; \
	COMMAND func3_AI_PV_SCALE_write; \
	VARIABLE func3_AI_PV_FTIME; \
	MENU func3_AI_PV_FTIME_page; \
	COMMAND func3_AI_PV_FTIME_read; \
	COMMAND func3_AI_PV_FTIME_write; \
	VARIABLE func3_AI_ALARM_HYS; \
	MENU func3_AI_ALARM_HYS_page; \
	COMMAND func3_AI_ALARM_HYS_read; \
	COMMAND func3_AI_ALARM_HYS_write; \
	VARIABLE func3_AI_HI_HI_LIM; \
	MENU func3_AI_HI_HI_LIM_page; \
	COMMAND func3_AI_HI_HI_LIM_read; \
	COMMAND func3_AI_HI_HI_LIM_write; \
	VARIABLE func3_AI_HI_LIM; \
	MENU func3_AI_HI_LIM_page; \
	COMMAND func3_AI_HI_LIM_read; \
	COMMAND func3_AI_HI_LIM_write; \
	VARIABLE func3_AI_LO_LIM; \
	MENU func3_AI_LO_LIM_page; \
	COMMAND func3_AI_LO_LIM_read; \
	COMMAND func3_AI_LO_LIM_write; \
	VARIABLE func3_AI_LO_LO_LIM; \
	MENU func3_AI_LO_LO_LIM_page; \
	COMMAND func3_AI_LO_LO_LIM_read; \
	COMMAND func3_AI_LO_LO_LIM_write

#define USE_FUNC3_AI_MANDATORY_A \
	USE_FUNC3_AI_MANDATORY_BOTH; \
	MENU func3_AI_Simple_Dialog_Mandatory_A; \
	MENU func3_AI_Display_mandatory_A; \
	CHART func3_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func3_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func3_AI_Display_out_mandatory_A; \
	MENU func3_AI_Tab_s_mandatory_A; \
	MENU func3_AI_Tab_s_pv_range_mandatory_A; \
	MENU func3_AI_Tab_s_limits_mandatory_A; \
	MENU func3_AI_Tab_m_mandatory_A; \
	MENU func3_AI_Tab_m_pv_range_mandatory_A; \
	MENU func3_AI_Tab_m_limits_mandatory_A

#define USE_FUNC3_AI_MANDATORY_B \
	USE_FUNC3_AI_MANDATORY_BOTH; \
	COLLECTION func3_AI_OUT_SCALE; \
	VARIABLE func3_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func3_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func3_AI_OUT_SCALE_Units_Index; \
	VARIABLE func3_AI_OUT_SCALE_Decimal_Point; \
	MENU func3_AI_OUT_SCALE_page; \
	COMMAND func3_AI_OUT_SCALE_read; \
	COMMAND func3_AI_OUT_SCALE_write; \
	VARIABLE func3_AI_LIN_TYPE; \
	MENU func3_AI_LIN_TYPE_page; \
	COMMAND func3_AI_LIN_TYPE_read; \
	COMMAND func3_AI_LIN_TYPE_write; \
	VARIABLE func3_AI_CHANNEL; \
	MENU func3_AI_CHANNEL_page; \
	COMMAND func3_AI_CHANNEL_read; \
	COMMAND func3_AI_CHANNEL_write; \
	COLLECTION func3_AI_SIMULATE; \
	VARIABLE func3_AI_SIMULATE_Status_Quality; \
	VARIABLE func3_AI_SIMULATE_Status_Limit; \
	VARIABLE func3_AI_SIMULATE_Value; \
	VARIABLE func3_AI_SIMULATE_Enabled; \
	MENU func3_AI_SIMULATE_page; \
	COMMAND func3_AI_SIMULATE_read; \
	COMMAND func3_AI_SIMULATE_write; \
	COLLECTION func3_AI_VIEW_1; \
	MENU func3_AI_VIEW_1_page; \
	MENU func3_AI_Simple_Dialog_Mandatory_B; \
	UNIT func3_AI_OUT_SCALE_unit_1; \
	MENU func3_AI_Simulation; \
	MENU func3_AI_Simulation_input; \
	MENU func3_AI_Simulation_input_group; \
	MENU func3_AI_Simulation_output; \
	MENU func3_AI_Simulation_output_group; \
	MENU func3_AI_Display_mandatory_B; \
	CHART func3_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func3_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func3_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func3_AI_Display_out_mandatory_B; \
	MENU func3_AI_Display_in_mandatory_B; \
	MENU func3_AI_Tab_s_mandatory_B; \
	MENU func3_AI_Tab_s_pv_range_mandatory_B; \
	MENU func3_AI_Tab_s_outscale_mandatory_B; \
	MENU func3_AI_Tab_s_limits_mandatory_B; \
	MENU func3_AI_Tab_s_interface_mandatory_B; \
	MENU func3_AI_Tab_m_mandatory_B; \
	MENU func3_AI_Tab_m_pv_range_mandatory_B; \
	MENU func3_AI_Tab_m_outscale_mandatory_B; \
	MENU func3_AI_Tab_m_limits_mandatory_B

#define USE_FUNC3_AI_OPTIONAL_BOTH \
	VARIABLE func3_AI_FSAFE_TYPE; \
	MENU func3_AI_FSAFE_TYPE_page; \
	COMMAND func3_AI_FSAFE_TYPE_read; \
	COMMAND func3_AI_FSAFE_TYPE_write; \
	VARIABLE func3_AI_FSAFE_VALUE; \
	MENU func3_AI_FSAFE_VALUE_page; \
	COMMAND func3_AI_FSAFE_VALUE_read; \
	COMMAND func3_AI_FSAFE_VALUE_write; \
	COLLECTION func3_AI_HI_HI_ALM; \
	VARIABLE func3_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func3_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func3_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func3_AI_HI_HI_ALM_Subcode; \
	VARIABLE func3_AI_HI_HI_ALM_Value; \
	MENU func3_AI_HI_HI_ALM_page; \
	COMMAND func3_AI_HI_HI_ALM_read; \
	COLLECTION func3_AI_HI_ALM; \
	VARIABLE func3_AI_HI_ALM_Unacknowledged; \
	VARIABLE func3_AI_HI_ALM_Alarm_State; \
	VARIABLE func3_AI_HI_ALM_Time_Stamp; \
	VARIABLE func3_AI_HI_ALM_Subcode; \
	VARIABLE func3_AI_HI_ALM_Value; \
	MENU func3_AI_HI_ALM_page; \
	COMMAND func3_AI_HI_ALM_read; \
	COLLECTION func3_AI_LO_ALM; \
	VARIABLE func3_AI_LO_ALM_Unacknowledged; \
	VARIABLE func3_AI_LO_ALM_Alarm_State; \
	VARIABLE func3_AI_LO_ALM_Time_Stamp; \
	VARIABLE func3_AI_LO_ALM_Subcode; \
	VARIABLE func3_AI_LO_ALM_Value; \
	MENU func3_AI_LO_ALM_page; \
	COMMAND func3_AI_LO_ALM_read; \
	COLLECTION func3_AI_LO_LO_ALM; \
	VARIABLE func3_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func3_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func3_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func3_AI_LO_LO_ALM_Subcode; \
	VARIABLE func3_AI_LO_LO_ALM_Value; \
	MENU func3_AI_LO_LO_ALM_page; \
	COMMAND func3_AI_LO_LO_ALM_read; \
	VARIABLE func3_AI_OUT_UNIT_TEXT; \
	MENU func3_AI_OUT_UNIT_TEXT_page; \
	COMMAND func3_AI_OUT_UNIT_TEXT_read; \
	COMMAND func3_AI_OUT_UNIT_TEXT_write

#define USE_FUNC3_AI_OPTIONAL_A \
	USE_FUNC3_AI_OPTIONAL_BOTH; \
	COLLECTION func3_AI_OUT_SCALE; \
	VARIABLE func3_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func3_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func3_AI_OUT_SCALE_Units_Index; \
	VARIABLE func3_AI_OUT_SCALE_Decimal_Point; \
	MENU func3_AI_OUT_SCALE_page; \
	COMMAND func3_AI_OUT_SCALE_read; \
	COMMAND func3_AI_OUT_SCALE_write; \
	VARIABLE func3_AI_LIN_TYPE; \
	MENU func3_AI_LIN_TYPE_page; \
	COMMAND func3_AI_LIN_TYPE_read; \
	COMMAND func3_AI_LIN_TYPE_write; \
	VARIABLE func3_AI_CHANNEL; \
	MENU func3_AI_CHANNEL_page; \
	COMMAND func3_AI_CHANNEL_read; \
	COMMAND func3_AI_CHANNEL_write; \
	COLLECTION func3_AI_SIMULATE; \
	VARIABLE func3_AI_SIMULATE_Status_Quality; \
	VARIABLE func3_AI_SIMULATE_Status_Limit; \
	VARIABLE func3_AI_SIMULATE_Value; \
	VARIABLE func3_AI_SIMULATE_Enabled; \
	MENU func3_AI_SIMULATE_page; \
	COMMAND func3_AI_SIMULATE_read; \
	COMMAND func3_AI_SIMULATE_write; \
	COLLECTION func3_AI_VIEW_1; \
	MENU func3_AI_VIEW_1_page; \
	MENU func3_AI_Simple_Dialog_Optional_A; \
	UNIT func3_AI_OUT_SCALE_unit_1; \
	UNIT func3_AI_OUT_SCALE_unit_2

#define USE_FUNC3_AI_OPTIONAL_B \
	USE_FUNC3_AI_OPTIONAL_BOTH; \
	MENU func3_AI_Simple_Dialog_Optional_B; \
	UNIT func3_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC3_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func3_AI_)
#define USE_FUNC3_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func3_AI_)
#define USE_FUNC3_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func3_AI_)
#define USE_FUNC3_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func3_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC4_AI_MANDATORY_BOTH \
	BLOCK func4_AI_block; \
	COLLECTION func4_AI_BLOCK_OBJECT; \
	VARIABLE func4_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func4_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func4_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func4_AI_BLOCK_OBJECT_Class; \
	VARIABLE func4_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func4_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func4_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func4_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func4_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func4_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func4_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func4_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func4_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func4_AI_BLOCK_OBJECT_page; \
	COMMAND func4_AI_BLOCK_OBJECT_read; \
	VARIABLE func4_AI_ST_REV; \
	MENU func4_AI_ST_REV_page; \
	COMMAND func4_AI_ST_REV_read; \
	VARIABLE func4_AI_TAG_DESC; \
	MENU func4_AI_TAG_DESC_page; \
	COMMAND func4_AI_TAG_DESC_read; \
	COMMAND func4_AI_TAG_DESC_write; \
	VARIABLE func4_AI_STRATEGY; \
	MENU func4_AI_STRATEGY_page; \
	COMMAND func4_AI_STRATEGY_read; \
	COMMAND func4_AI_STRATEGY_write; \
	VARIABLE func4_AI_ALERT_KEY; \
	MENU func4_AI_ALERT_KEY_page; \
	COMMAND func4_AI_ALERT_KEY_read; \
	COMMAND func4_AI_ALERT_KEY_write; \
	VARIABLE func4_AI_TARGET_MODE; \
	MENU func4_AI_TARGET_MODE_page; \
	COMMAND func4_AI_TARGET_MODE_read; \
	COMMAND func4_AI_TARGET_MODE_write; \
	COLLECTION func4_AI_MODE_BLK; \
	VARIABLE func4_AI_MODE_BLK_Actual; \
	VARIABLE func4_AI_MODE_BLK_Permitted; \
	VARIABLE func4_AI_MODE_BLK_Normal; \
	MENU func4_AI_MODE_BLK_page; \
	COMMAND func4_AI_MODE_BLK_read; \
	COLLECTION func4_AI_ALARM_SUM; \
	VARIABLE func4_AI_ALARM_SUM_Current; \
	VARIABLE func4_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func4_AI_ALARM_SUM_Unreported; \
	VARIABLE func4_AI_ALARM_SUM_Disabled; \
	MENU func4_AI_ALARM_SUM_page; \
	COMMAND func4_AI_ALARM_SUM_read; \
	COLLECTION func4_AI_BATCH; \
	VARIABLE func4_AI_BATCH_Batch_ID; \
	VARIABLE func4_AI_BATCH_Rup; \
	VARIABLE func4_AI_BATCH_Operation; \
	VARIABLE func4_AI_BATCH_Phase; \
	MENU func4_AI_BATCH_page; \
	COMMAND func4_AI_BATCH_read; \
	COMMAND func4_AI_BATCH_write; \
	COLLECTION func4_AI_OUT; \
	VARIABLE func4_AI_OUT_Value; \
	VARIABLE func4_AI_OUT_Status_Quality; \
	VARIABLE func4_AI_OUT_Status_Limit; \
	MENU func4_AI_OUT_page; \
	COMMAND func4_AI_OUT_read; \
	COMMAND func4_AI_OUT_write; \
	COLLECTION func4_AI_PV_SCALE; \
	VARIABLE func4_AI_PV_SCALE_Upper_Value; \
	VARIABLE func4_AI_PV_SCALE_Lower_Value; \
	MENU func4_AI_PV_SCALE_page; \
	COMMAND func4_AI_PV_SCALE_read; \
	COMMAND func4_AI_PV_SCALE_write; \
	VARIABLE func4_AI_PV_FTIME; \
	MENU func4_AI_PV_FTIME_page; \
	COMMAND func4_AI_PV_FTIME_read; \
	COMMAND func4_AI_PV_FTIME_write; \
	VARIABLE func4_AI_ALARM_HYS; \
	MENU func4_AI_ALARM_HYS_page; \
	COMMAND func4_AI_ALARM_HYS_read; \
	COMMAND func4_AI_ALARM_HYS_write; \
	VARIABLE func4_AI_HI_HI_LIM; \
	MENU func4_AI_HI_HI_LIM_page; \
	COMMAND func4_AI_HI_HI_LIM_read; \
	COMMAND func4_AI_HI_HI_LIM_write; \
	VARIABLE func4_AI_HI_LIM; \
	MENU func4_AI_HI_LIM_page; \
	COMMAND func4_AI_HI_LIM_read; \
	COMMAND func4_AI_HI_LIM_write; \
	VARIABLE func4_AI_LO_LIM; \
	MENU func4_AI_LO_LIM_page; \
	COMMAND func4_AI_LO_LIM_read; \
	COMMAND func4_AI_LO_LIM_write; \
	VARIABLE func4_AI_LO_LO_LIM; \
	MENU func4_AI_LO_LO_LIM_page; \
	COMMAND func4_AI_LO_LO_LIM_read; \
	COMMAND func4_AI_LO_LO_LIM_write

#define USE_FUNC4_AI_MANDATORY_A \
	USE_FUNC4_AI_MANDATORY_BOTH; \
	MENU func4_AI_Simple_Dialog_Mandatory_A; \
	MENU func4_AI_Display_mandatory_A; \
	CHART func4_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func4_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func4_AI_Display_out_mandatory_A; \
	MENU func4_AI_Tab_s_mandatory_A; \
	MENU func4_AI_Tab_s_pv_range_mandatory_A; \
	MENU func4_AI_Tab_s_limits_mandatory_A; \
	MENU func4_AI_Tab_m_mandatory_A; \
	MENU func4_AI_Tab_m_pv_range_mandatory_A; \
	MENU func4_AI_Tab_m_limits_mandatory_A

#define USE_FUNC4_AI_MANDATORY_B \
	USE_FUNC4_AI_MANDATORY_BOTH; \
	COLLECTION func4_AI_OUT_SCALE; \
	VARIABLE func4_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func4_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func4_AI_OUT_SCALE_Units_Index; \
	VARIABLE func4_AI_OUT_SCALE_Decimal_Point; \
	MENU func4_AI_OUT_SCALE_page; \
	COMMAND func4_AI_OUT_SCALE_read; \
	COMMAND func4_AI_OUT_SCALE_write; \
	VARIABLE func4_AI_LIN_TYPE; \
	MENU func4_AI_LIN_TYPE_page; \
	COMMAND func4_AI_LIN_TYPE_read; \
	COMMAND func4_AI_LIN_TYPE_write; \
	VARIABLE func4_AI_CHANNEL; \
	MENU func4_AI_CHANNEL_page; \
	COMMAND func4_AI_CHANNEL_read; \
	COMMAND func4_AI_CHANNEL_write; \
	COLLECTION func4_AI_SIMULATE; \
	VARIABLE func4_AI_SIMULATE_Status_Quality; \
	VARIABLE func4_AI_SIMULATE_Status_Limit; \
	VARIABLE func4_AI_SIMULATE_Value; \
	VARIABLE func4_AI_SIMULATE_Enabled; \
	MENU func4_AI_SIMULATE_page; \
	COMMAND func4_AI_SIMULATE_read; \
	COMMAND func4_AI_SIMULATE_write; \
	COLLECTION func4_AI_VIEW_1; \
	MENU func4_AI_VIEW_1_page; \
	MENU func4_AI_Simple_Dialog_Mandatory_B; \
	UNIT func4_AI_OUT_SCALE_unit_1; \
	MENU func4_AI_Simulation; \
	MENU func4_AI_Simulation_input; \
	MENU func4_AI_Simulation_input_group; \
	MENU func4_AI_Simulation_output; \
	MENU func4_AI_Simulation_output_group; \
	MENU func4_AI_Display_mandatory_B; \
	CHART func4_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func4_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func4_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func4_AI_Display_out_mandatory_B; \
	MENU func4_AI_Display_in_mandatory_B; \
	MENU func4_AI_Tab_s_mandatory_B; \
	MENU func4_AI_Tab_s_pv_range_mandatory_B; \
	MENU func4_AI_Tab_s_outscale_mandatory_B; \
	MENU func4_AI_Tab_s_limits_mandatory_B; \
	MENU func4_AI_Tab_s_interface_mandatory_B; \
	MENU func4_AI_Tab_m_mandatory_B; \
	MENU func4_AI_Tab_m_pv_range_mandatory_B; \
	MENU func4_AI_Tab_m_outscale_mandatory_B; \
	MENU func4_AI_Tab_m_limits_mandatory_B

#define USE_FUNC4_AI_OPTIONAL_BOTH \
	VARIABLE func4_AI_FSAFE_TYPE; \
	MENU func4_AI_FSAFE_TYPE_page; \
	COMMAND func4_AI_FSAFE_TYPE_read; \
	COMMAND func4_AI_FSAFE_TYPE_write; \
	VARIABLE func4_AI_FSAFE_VALUE; \
	MENU func4_AI_FSAFE_VALUE_page; \
	COMMAND func4_AI_FSAFE_VALUE_read; \
	COMMAND func4_AI_FSAFE_VALUE_write; \
	COLLECTION func4_AI_HI_HI_ALM; \
	VARIABLE func4_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func4_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func4_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func4_AI_HI_HI_ALM_Subcode; \
	VARIABLE func4_AI_HI_HI_ALM_Value; \
	MENU func4_AI_HI_HI_ALM_page; \
	COMMAND func4_AI_HI_HI_ALM_read; \
	COLLECTION func4_AI_HI_ALM; \
	VARIABLE func4_AI_HI_ALM_Unacknowledged; \
	VARIABLE func4_AI_HI_ALM_Alarm_State; \
	VARIABLE func4_AI_HI_ALM_Time_Stamp; \
	VARIABLE func4_AI_HI_ALM_Subcode; \
	VARIABLE func4_AI_HI_ALM_Value; \
	MENU func4_AI_HI_ALM_page; \
	COMMAND func4_AI_HI_ALM_read; \
	COLLECTION func4_AI_LO_ALM; \
	VARIABLE func4_AI_LO_ALM_Unacknowledged; \
	VARIABLE func4_AI_LO_ALM_Alarm_State; \
	VARIABLE func4_AI_LO_ALM_Time_Stamp; \
	VARIABLE func4_AI_LO_ALM_Subcode; \
	VARIABLE func4_AI_LO_ALM_Value; \
	MENU func4_AI_LO_ALM_page; \
	COMMAND func4_AI_LO_ALM_read; \
	COLLECTION func4_AI_LO_LO_ALM; \
	VARIABLE func4_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func4_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func4_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func4_AI_LO_LO_ALM_Subcode; \
	VARIABLE func4_AI_LO_LO_ALM_Value; \
	MENU func4_AI_LO_LO_ALM_page; \
	COMMAND func4_AI_LO_LO_ALM_read; \
	VARIABLE func4_AI_OUT_UNIT_TEXT; \
	MENU func4_AI_OUT_UNIT_TEXT_page; \
	COMMAND func4_AI_OUT_UNIT_TEXT_read; \
	COMMAND func4_AI_OUT_UNIT_TEXT_write

#define USE_FUNC4_AI_OPTIONAL_A \
	USE_FUNC4_AI_OPTIONAL_BOTH; \
	COLLECTION func4_AI_OUT_SCALE; \
	VARIABLE func4_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func4_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func4_AI_OUT_SCALE_Units_Index; \
	VARIABLE func4_AI_OUT_SCALE_Decimal_Point; \
	MENU func4_AI_OUT_SCALE_page; \
	COMMAND func4_AI_OUT_SCALE_read; \
	COMMAND func4_AI_OUT_SCALE_write; \
	VARIABLE func4_AI_LIN_TYPE; \
	MENU func4_AI_LIN_TYPE_page; \
	COMMAND func4_AI_LIN_TYPE_read; \
	COMMAND func4_AI_LIN_TYPE_write; \
	VARIABLE func4_AI_CHANNEL; \
	MENU func4_AI_CHANNEL_page; \
	COMMAND func4_AI_CHANNEL_read; \
	COMMAND func4_AI_CHANNEL_write; \
	COLLECTION func4_AI_SIMULATE; \
	VARIABLE func4_AI_SIMULATE_Status_Quality; \
	VARIABLE func4_AI_SIMULATE_Status_Limit; \
	VARIABLE func4_AI_SIMULATE_Value; \
	VARIABLE func4_AI_SIMULATE_Enabled; \
	MENU func4_AI_SIMULATE_page; \
	COMMAND func4_AI_SIMULATE_read; \
	COMMAND func4_AI_SIMULATE_write; \
	COLLECTION func4_AI_VIEW_1; \
	MENU func4_AI_VIEW_1_page; \
	MENU func4_AI_Simple_Dialog_Optional_A; \
	UNIT func4_AI_OUT_SCALE_unit_1; \
	UNIT func4_AI_OUT_SCALE_unit_2

#define USE_FUNC4_AI_OPTIONAL_B \
	USE_FUNC4_AI_OPTIONAL_BOTH; \
	MENU func4_AI_Simple_Dialog_Optional_B; \
	UNIT func4_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC4_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func4_AI_)
#define USE_FUNC4_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func4_AI_)
#define USE_FUNC4_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func4_AI_)
#define USE_FUNC4_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func4_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC5_AI_MANDATORY_BOTH \
	BLOCK func5_AI_block; \
	COLLECTION func5_AI_BLOCK_OBJECT; \
	VARIABLE func5_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func5_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func5_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func5_AI_BLOCK_OBJECT_Class; \
	VARIABLE func5_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func5_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func5_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func5_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func5_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func5_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func5_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func5_AI_BLOCK_OBJECT_page; \
	COMMAND func5_AI_BLOCK_OBJECT_read; \
	VARIABLE func5_AI_ST_REV; \
	MENU func5_AI_ST_REV_page; \
	COMMAND func5_AI_ST_REV_read; \
	VARIABLE func5_AI_TAG_DESC; \
	MENU func5_AI_TAG_DESC_page; \
	COMMAND func5_AI_TAG_DESC_read; \
	COMMAND func5_AI_TAG_DESC_write; \
	VARIABLE func5_AI_STRATEGY; \
	MENU func5_AI_STRATEGY_page; \
	COMMAND func5_AI_STRATEGY_read; \
	COMMAND func5_AI_STRATEGY_write; \
	VARIABLE func5_AI_ALERT_KEY; \
	MENU func5_AI_ALERT_KEY_page; \
	COMMAND func5_AI_ALERT_KEY_read; \
	COMMAND func5_AI_ALERT_KEY_write; \
	VARIABLE func5_AI_TARGET_MODE; \
	MENU func5_AI_TARGET_MODE_page; \
	COMMAND func5_AI_TARGET_MODE_read; \
	COMMAND func5_AI_TARGET_MODE_write; \
	COLLECTION func5_AI_MODE_BLK; \
	VARIABLE func5_AI_MODE_BLK_Actual; \
	VARIABLE func5_AI_MODE_BLK_Permitted; \
	VARIABLE func5_AI_MODE_BLK_Normal; \
	MENU func5_AI_MODE_BLK_page; \
	COMMAND func5_AI_MODE_BLK_read; \
	COLLECTION func5_AI_ALARM_SUM; \
	VARIABLE func5_AI_ALARM_SUM_Current; \
	VARIABLE func5_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func5_AI_ALARM_SUM_Unreported; \
	VARIABLE func5_AI_ALARM_SUM_Disabled; \
	MENU func5_AI_ALARM_SUM_page; \
	COMMAND func5_AI_ALARM_SUM_read; \
	COLLECTION func5_AI_BATCH; \
	VARIABLE func5_AI_BATCH_Batch_ID; \
	VARIABLE func5_AI_BATCH_Rup; \
	VARIABLE func5_AI_BATCH_Operation; \
	VARIABLE func5_AI_BATCH_Phase; \
	MENU func5_AI_BATCH_page; \
	COMMAND func5_AI_BATCH_read; \
	COMMAND func5_AI_BATCH_write; \
	COLLECTION func5_AI_OUT; \
	VARIABLE func5_AI_OUT_Value; \
	VARIABLE func5_AI_OUT_Status_Quality; \
	VARIABLE func5_AI_OUT_Status_Limit; \
	MENU func5_AI_OUT_page; \
	COMMAND func5_AI_OUT_read; \
	COMMAND func5_AI_OUT_write; \
	COLLECTION func5_AI_PV_SCALE; \
	VARIABLE func5_AI_PV_SCALE_Upper_Value; \
	VARIABLE func5_AI_PV_SCALE_Lower_Value; \
	MENU func5_AI_PV_SCALE_page; \
	COMMAND func5_AI_PV_SCALE_read; \
	COMMAND func5_AI_PV_SCALE_write; \
	VARIABLE func5_AI_PV_FTIME; \
	MENU func5_AI_PV_FTIME_page; \
	COMMAND func5_AI_PV_FTIME_read; \
	COMMAND func5_AI_PV_FTIME_write; \
	VARIABLE func5_AI_ALARM_HYS; \
	MENU func5_AI_ALARM_HYS_page; \
	COMMAND func5_AI_ALARM_HYS_read; \
	COMMAND func5_AI_ALARM_HYS_write; \
	VARIABLE func5_AI_HI_HI_LIM; \
	MENU func5_AI_HI_HI_LIM_page; \
	COMMAND func5_AI_HI_HI_LIM_read; \
	COMMAND func5_AI_HI_HI_LIM_write; \
	VARIABLE func5_AI_HI_LIM; \
	MENU func5_AI_HI_LIM_page; \
	COMMAND func5_AI_HI_LIM_read; \
	COMMAND func5_AI_HI_LIM_write; \
	VARIABLE func5_AI_LO_LIM; \
	MENU func5_AI_LO_LIM_page; \
	COMMAND func5_AI_LO_LIM_read; \
	COMMAND func5_AI_LO_LIM_write; \
	VARIABLE func5_AI_LO_LO_LIM; \
	MENU func5_AI_LO_LO_LIM_page; \
	COMMAND func5_AI_LO_LO_LIM_read; \
	COMMAND func5_AI_LO_LO_LIM_write

#define USE_FUNC5_AI_MANDATORY_A \
	USE_FUNC5_AI_MANDATORY_BOTH; \
	MENU func5_AI_Simple_Dialog_Mandatory_A; \
	MENU func5_AI_Display_mandatory_A; \
	CHART func5_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func5_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func5_AI_Display_out_mandatory_A; \
	MENU func5_AI_Tab_s_mandatory_A; \
	MENU func5_AI_Tab_s_pv_range_mandatory_A; \
	MENU func5_AI_Tab_s_limits_mandatory_A; \
	MENU func5_AI_Tab_m_mandatory_A; \
	MENU func5_AI_Tab_m_pv_range_mandatory_A; \
	MENU func5_AI_Tab_m_limits_mandatory_A

#define USE_FUNC5_AI_MANDATORY_B \
	USE_FUNC5_AI_MANDATORY_BOTH; \
	COLLECTION func5_AI_OUT_SCALE; \
	VARIABLE func5_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func5_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func5_AI_OUT_SCALE_Units_Index; \
	VARIABLE func5_AI_OUT_SCALE_Decimal_Point; \
	MENU func5_AI_OUT_SCALE_page; \
	COMMAND func5_AI_OUT_SCALE_read; \
	COMMAND func5_AI_OUT_SCALE_write; \
	VARIABLE func5_AI_LIN_TYPE; \
	MENU func5_AI_LIN_TYPE_page; \
	COMMAND func5_AI_LIN_TYPE_read; \
	COMMAND func5_AI_LIN_TYPE_write; \
	VARIABLE func5_AI_CHANNEL; \
	MENU func5_AI_CHANNEL_page; \
	COMMAND func5_AI_CHANNEL_read; \
	COMMAND func5_AI_CHANNEL_write; \
	COLLECTION func5_AI_SIMULATE; \
	VARIABLE func5_AI_SIMULATE_Status_Quality; \
	VARIABLE func5_AI_SIMULATE_Status_Limit; \
	VARIABLE func5_AI_SIMULATE_Value; \
	VARIABLE func5_AI_SIMULATE_Enabled; \
	MENU func5_AI_SIMULATE_page; \
	COMMAND func5_AI_SIMULATE_read; \
	COMMAND func5_AI_SIMULATE_write; \
	COLLECTION func5_AI_VIEW_1; \
	MENU func5_AI_VIEW_1_page; \
	MENU func5_AI_Simple_Dialog_Mandatory_B; \
	UNIT func5_AI_OUT_SCALE_unit_1; \
	MENU func5_AI_Simulation; \
	MENU func5_AI_Simulation_input; \
	MENU func5_AI_Simulation_input_group; \
	MENU func5_AI_Simulation_output; \
	MENU func5_AI_Simulation_output_group; \
	MENU func5_AI_Display_mandatory_B; \
	CHART func5_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func5_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func5_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func5_AI_Display_out_mandatory_B; \
	MENU func5_AI_Display_in_mandatory_B; \
	MENU func5_AI_Tab_s_mandatory_B; \
	MENU func5_AI_Tab_s_pv_range_mandatory_B; \
	MENU func5_AI_Tab_s_outscale_mandatory_B; \
	MENU func5_AI_Tab_s_limits_mandatory_B; \
	MENU func5_AI_Tab_s_interface_mandatory_B; \
	MENU func5_AI_Tab_m_mandatory_B; \
	MENU func5_AI_Tab_m_pv_range_mandatory_B; \
	MENU func5_AI_Tab_m_outscale_mandatory_B; \
	MENU func5_AI_Tab_m_limits_mandatory_B

#define USE_FUNC5_AI_OPTIONAL_BOTH \
	VARIABLE func5_AI_FSAFE_TYPE; \
	MENU func5_AI_FSAFE_TYPE_page; \
	COMMAND func5_AI_FSAFE_TYPE_read; \
	COMMAND func5_AI_FSAFE_TYPE_write; \
	VARIABLE func5_AI_FSAFE_VALUE; \
	MENU func5_AI_FSAFE_VALUE_page; \
	COMMAND func5_AI_FSAFE_VALUE_read; \
	COMMAND func5_AI_FSAFE_VALUE_write; \
	COLLECTION func5_AI_HI_HI_ALM; \
	VARIABLE func5_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func5_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func5_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func5_AI_HI_HI_ALM_Subcode; \
	VARIABLE func5_AI_HI_HI_ALM_Value; \
	MENU func5_AI_HI_HI_ALM_page; \
	COMMAND func5_AI_HI_HI_ALM_read; \
	COLLECTION func5_AI_HI_ALM; \
	VARIABLE func5_AI_HI_ALM_Unacknowledged; \
	VARIABLE func5_AI_HI_ALM_Alarm_State; \
	VARIABLE func5_AI_HI_ALM_Time_Stamp; \
	VARIABLE func5_AI_HI_ALM_Subcode; \
	VARIABLE func5_AI_HI_ALM_Value; \
	MENU func5_AI_HI_ALM_page; \
	COMMAND func5_AI_HI_ALM_read; \
	COLLECTION func5_AI_LO_ALM; \
	VARIABLE func5_AI_LO_ALM_Unacknowledged; \
	VARIABLE func5_AI_LO_ALM_Alarm_State; \
	VARIABLE func5_AI_LO_ALM_Time_Stamp; \
	VARIABLE func5_AI_LO_ALM_Subcode; \
	VARIABLE func5_AI_LO_ALM_Value; \
	MENU func5_AI_LO_ALM_page; \
	COMMAND func5_AI_LO_ALM_read; \
	COLLECTION func5_AI_LO_LO_ALM; \
	VARIABLE func5_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func5_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func5_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func5_AI_LO_LO_ALM_Subcode; \
	VARIABLE func5_AI_LO_LO_ALM_Value; \
	MENU func5_AI_LO_LO_ALM_page; \
	COMMAND func5_AI_LO_LO_ALM_read; \
	VARIABLE func5_AI_OUT_UNIT_TEXT; \
	MENU func5_AI_OUT_UNIT_TEXT_page; \
	COMMAND func5_AI_OUT_UNIT_TEXT_read; \
	COMMAND func5_AI_OUT_UNIT_TEXT_write

#define USE_FUNC5_AI_OPTIONAL_A \
	USE_FUNC5_AI_OPTIONAL_BOTH; \
	COLLECTION func5_AI_OUT_SCALE; \
	VARIABLE func5_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func5_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func5_AI_OUT_SCALE_Units_Index; \
	VARIABLE func5_AI_OUT_SCALE_Decimal_Point; \
	MENU func5_AI_OUT_SCALE_page; \
	COMMAND func5_AI_OUT_SCALE_read; \
	COMMAND func5_AI_OUT_SCALE_write; \
	VARIABLE func5_AI_LIN_TYPE; \
	MENU func5_AI_LIN_TYPE_page; \
	COMMAND func5_AI_LIN_TYPE_read; \
	COMMAND func5_AI_LIN_TYPE_write; \
	VARIABLE func5_AI_CHANNEL; \
	MENU func5_AI_CHANNEL_page; \
	COMMAND func5_AI_CHANNEL_read; \
	COMMAND func5_AI_CHANNEL_write; \
	COLLECTION func5_AI_SIMULATE; \
	VARIABLE func5_AI_SIMULATE_Status_Quality; \
	VARIABLE func5_AI_SIMULATE_Status_Limit; \
	VARIABLE func5_AI_SIMULATE_Value; \
	VARIABLE func5_AI_SIMULATE_Enabled; \
	MENU func5_AI_SIMULATE_page; \
	COMMAND func5_AI_SIMULATE_read; \
	COMMAND func5_AI_SIMULATE_write; \
	COLLECTION func5_AI_VIEW_1; \
	MENU func5_AI_VIEW_1_page; \
	MENU func5_AI_Simple_Dialog_Optional_A; \
	UNIT func5_AI_OUT_SCALE_unit_1; \
	UNIT func5_AI_OUT_SCALE_unit_2

#define USE_FUNC5_AI_OPTIONAL_B \
	USE_FUNC5_AI_OPTIONAL_BOTH; \
	MENU func5_AI_Simple_Dialog_Optional_B; \
	UNIT func5_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC5_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func5_AI_)
#define USE_FUNC5_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func5_AI_)
#define USE_FUNC5_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func5_AI_)
#define USE_FUNC5_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func5_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC6_AI_MANDATORY_BOTH \
	BLOCK func6_AI_block; \
	COLLECTION func6_AI_BLOCK_OBJECT; \
	VARIABLE func6_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func6_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func6_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func6_AI_BLOCK_OBJECT_Class; \
	VARIABLE func6_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func6_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func6_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func6_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func6_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func6_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func6_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func6_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func6_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func6_AI_BLOCK_OBJECT_page; \
	COMMAND func6_AI_BLOCK_OBJECT_read; \
	VARIABLE func6_AI_ST_REV; \
	MENU func6_AI_ST_REV_page; \
	COMMAND func6_AI_ST_REV_read; \
	VARIABLE func6_AI_TAG_DESC; \
	MENU func6_AI_TAG_DESC_page; \
	COMMAND func6_AI_TAG_DESC_read; \
	COMMAND func6_AI_TAG_DESC_write; \
	VARIABLE func6_AI_STRATEGY; \
	MENU func6_AI_STRATEGY_page; \
	COMMAND func6_AI_STRATEGY_read; \
	COMMAND func6_AI_STRATEGY_write; \
	VARIABLE func6_AI_ALERT_KEY; \
	MENU func6_AI_ALERT_KEY_page; \
	COMMAND func6_AI_ALERT_KEY_read; \
	COMMAND func6_AI_ALERT_KEY_write; \
	VARIABLE func6_AI_TARGET_MODE; \
	MENU func6_AI_TARGET_MODE_page; \
	COMMAND func6_AI_TARGET_MODE_read; \
	COMMAND func6_AI_TARGET_MODE_write; \
	COLLECTION func6_AI_MODE_BLK; \
	VARIABLE func6_AI_MODE_BLK_Actual; \
	VARIABLE func6_AI_MODE_BLK_Permitted; \
	VARIABLE func6_AI_MODE_BLK_Normal; \
	MENU func6_AI_MODE_BLK_page; \
	COMMAND func6_AI_MODE_BLK_read; \
	COLLECTION func6_AI_ALARM_SUM; \
	VARIABLE func6_AI_ALARM_SUM_Current; \
	VARIABLE func6_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func6_AI_ALARM_SUM_Unreported; \
	VARIABLE func6_AI_ALARM_SUM_Disabled; \
	MENU func6_AI_ALARM_SUM_page; \
	COMMAND func6_AI_ALARM_SUM_read; \
	COLLECTION func6_AI_BATCH; \
	VARIABLE func6_AI_BATCH_Batch_ID; \
	VARIABLE func6_AI_BATCH_Rup; \
	VARIABLE func6_AI_BATCH_Operation; \
	VARIABLE func6_AI_BATCH_Phase; \
	MENU func6_AI_BATCH_page; \
	COMMAND func6_AI_BATCH_read; \
	COMMAND func6_AI_BATCH_write; \
	COLLECTION func6_AI_OUT; \
	VARIABLE func6_AI_OUT_Value; \
	VARIABLE func6_AI_OUT_Status_Quality; \
	VARIABLE func6_AI_OUT_Status_Limit; \
	MENU func6_AI_OUT_page; \
	COMMAND func6_AI_OUT_read; \
	COMMAND func6_AI_OUT_write; \
	COLLECTION func6_AI_PV_SCALE; \
	VARIABLE func6_AI_PV_SCALE_Upper_Value; \
	VARIABLE func6_AI_PV_SCALE_Lower_Value; \
	MENU func6_AI_PV_SCALE_page; \
	COMMAND func6_AI_PV_SCALE_read; \
	COMMAND func6_AI_PV_SCALE_write; \
	VARIABLE func6_AI_PV_FTIME; \
	MENU func6_AI_PV_FTIME_page; \
	COMMAND func6_AI_PV_FTIME_read; \
	COMMAND func6_AI_PV_FTIME_write; \
	VARIABLE func6_AI_ALARM_HYS; \
	MENU func6_AI_ALARM_HYS_page; \
	COMMAND func6_AI_ALARM_HYS_read; \
	COMMAND func6_AI_ALARM_HYS_write; \
	VARIABLE func6_AI_HI_HI_LIM; \
	MENU func6_AI_HI_HI_LIM_page; \
	COMMAND func6_AI_HI_HI_LIM_read; \
	COMMAND func6_AI_HI_HI_LIM_write; \
	VARIABLE func6_AI_HI_LIM; \
	MENU func6_AI_HI_LIM_page; \
	COMMAND func6_AI_HI_LIM_read; \
	COMMAND func6_AI_HI_LIM_write; \
	VARIABLE func6_AI_LO_LIM; \
	MENU func6_AI_LO_LIM_page; \
	COMMAND func6_AI_LO_LIM_read; \
	COMMAND func6_AI_LO_LIM_write; \
	VARIABLE func6_AI_LO_LO_LIM; \
	MENU func6_AI_LO_LO_LIM_page; \
	COMMAND func6_AI_LO_LO_LIM_read; \
	COMMAND func6_AI_LO_LO_LIM_write

#define USE_FUNC6_AI_MANDATORY_A \
	USE_FUNC6_AI_MANDATORY_BOTH; \
	MENU func6_AI_Simple_Dialog_Mandatory_A; \
	MENU func6_AI_Display_mandatory_A; \
	CHART func6_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func6_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func6_AI_Display_out_mandatory_A; \
	MENU func6_AI_Tab_s_mandatory_A; \
	MENU func6_AI_Tab_s_pv_range_mandatory_A; \
	MENU func6_AI_Tab_s_limits_mandatory_A; \
	MENU func6_AI_Tab_m_mandatory_A; \
	MENU func6_AI_Tab_m_pv_range_mandatory_A; \
	MENU func6_AI_Tab_m_limits_mandatory_A

#define USE_FUNC6_AI_MANDATORY_B \
	USE_FUNC6_AI_MANDATORY_BOTH; \
	COLLECTION func6_AI_OUT_SCALE; \
	VARIABLE func6_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func6_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func6_AI_OUT_SCALE_Units_Index; \
	VARIABLE func6_AI_OUT_SCALE_Decimal_Point; \
	MENU func6_AI_OUT_SCALE_page; \
	COMMAND func6_AI_OUT_SCALE_read; \
	COMMAND func6_AI_OUT_SCALE_write; \
	VARIABLE func6_AI_LIN_TYPE; \
	MENU func6_AI_LIN_TYPE_page; \
	COMMAND func6_AI_LIN_TYPE_read; \
	COMMAND func6_AI_LIN_TYPE_write; \
	VARIABLE func6_AI_CHANNEL; \
	MENU func6_AI_CHANNEL_page; \
	COMMAND func6_AI_CHANNEL_read; \
	COMMAND func6_AI_CHANNEL_write; \
	COLLECTION func6_AI_SIMULATE; \
	VARIABLE func6_AI_SIMULATE_Status_Quality; \
	VARIABLE func6_AI_SIMULATE_Status_Limit; \
	VARIABLE func6_AI_SIMULATE_Value; \
	VARIABLE func6_AI_SIMULATE_Enabled; \
	MENU func6_AI_SIMULATE_page; \
	COMMAND func6_AI_SIMULATE_read; \
	COMMAND func6_AI_SIMULATE_write; \
	COLLECTION func6_AI_VIEW_1; \
	MENU func6_AI_VIEW_1_page; \
	MENU func6_AI_Simple_Dialog_Mandatory_B; \
	UNIT func6_AI_OUT_SCALE_unit_1; \
	MENU func6_AI_Simulation; \
	MENU func6_AI_Simulation_input; \
	MENU func6_AI_Simulation_input_group; \
	MENU func6_AI_Simulation_output; \
	MENU func6_AI_Simulation_output_group; \
	MENU func6_AI_Display_mandatory_B; \
	CHART func6_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func6_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func6_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func6_AI_Display_out_mandatory_B; \
	MENU func6_AI_Display_in_mandatory_B; \
	MENU func6_AI_Tab_s_mandatory_B; \
	MENU func6_AI_Tab_s_pv_range_mandatory_B; \
	MENU func6_AI_Tab_s_outscale_mandatory_B; \
	MENU func6_AI_Tab_s_limits_mandatory_B; \
	MENU func6_AI_Tab_s_interface_mandatory_B; \
	MENU func6_AI_Tab_m_mandatory_B; \
	MENU func6_AI_Tab_m_pv_range_mandatory_B; \
	MENU func6_AI_Tab_m_outscale_mandatory_B; \
	MENU func6_AI_Tab_m_limits_mandatory_B

#define USE_FUNC6_AI_OPTIONAL_BOTH \
	VARIABLE func6_AI_FSAFE_TYPE; \
	MENU func6_AI_FSAFE_TYPE_page; \
	COMMAND func6_AI_FSAFE_TYPE_read; \
	COMMAND func6_AI_FSAFE_TYPE_write; \
	VARIABLE func6_AI_FSAFE_VALUE; \
	MENU func6_AI_FSAFE_VALUE_page; \
	COMMAND func6_AI_FSAFE_VALUE_read; \
	COMMAND func6_AI_FSAFE_VALUE_write; \
	COLLECTION func6_AI_HI_HI_ALM; \
	VARIABLE func6_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func6_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func6_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func6_AI_HI_HI_ALM_Subcode; \
	VARIABLE func6_AI_HI_HI_ALM_Value; \
	MENU func6_AI_HI_HI_ALM_page; \
	COMMAND func6_AI_HI_HI_ALM_read; \
	COLLECTION func6_AI_HI_ALM; \
	VARIABLE func6_AI_HI_ALM_Unacknowledged; \
	VARIABLE func6_AI_HI_ALM_Alarm_State; \
	VARIABLE func6_AI_HI_ALM_Time_Stamp; \
	VARIABLE func6_AI_HI_ALM_Subcode; \
	VARIABLE func6_AI_HI_ALM_Value; \
	MENU func6_AI_HI_ALM_page; \
	COMMAND func6_AI_HI_ALM_read; \
	COLLECTION func6_AI_LO_ALM; \
	VARIABLE func6_AI_LO_ALM_Unacknowledged; \
	VARIABLE func6_AI_LO_ALM_Alarm_State; \
	VARIABLE func6_AI_LO_ALM_Time_Stamp; \
	VARIABLE func6_AI_LO_ALM_Subcode; \
	VARIABLE func6_AI_LO_ALM_Value; \
	MENU func6_AI_LO_ALM_page; \
	COMMAND func6_AI_LO_ALM_read; \
	COLLECTION func6_AI_LO_LO_ALM; \
	VARIABLE func6_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func6_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func6_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func6_AI_LO_LO_ALM_Subcode; \
	VARIABLE func6_AI_LO_LO_ALM_Value; \
	MENU func6_AI_LO_LO_ALM_page; \
	COMMAND func6_AI_LO_LO_ALM_read; \
	VARIABLE func6_AI_OUT_UNIT_TEXT; \
	MENU func6_AI_OUT_UNIT_TEXT_page; \
	COMMAND func6_AI_OUT_UNIT_TEXT_read; \
	COMMAND func6_AI_OUT_UNIT_TEXT_write

#define USE_FUNC6_AI_OPTIONAL_A \
	USE_FUNC6_AI_OPTIONAL_BOTH; \
	COLLECTION func6_AI_OUT_SCALE; \
	VARIABLE func6_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func6_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func6_AI_OUT_SCALE_Units_Index; \
	VARIABLE func6_AI_OUT_SCALE_Decimal_Point; \
	MENU func6_AI_OUT_SCALE_page; \
	COMMAND func6_AI_OUT_SCALE_read; \
	COMMAND func6_AI_OUT_SCALE_write; \
	VARIABLE func6_AI_LIN_TYPE; \
	MENU func6_AI_LIN_TYPE_page; \
	COMMAND func6_AI_LIN_TYPE_read; \
	COMMAND func6_AI_LIN_TYPE_write; \
	VARIABLE func6_AI_CHANNEL; \
	MENU func6_AI_CHANNEL_page; \
	COMMAND func6_AI_CHANNEL_read; \
	COMMAND func6_AI_CHANNEL_write; \
	COLLECTION func6_AI_SIMULATE; \
	VARIABLE func6_AI_SIMULATE_Status_Quality; \
	VARIABLE func6_AI_SIMULATE_Status_Limit; \
	VARIABLE func6_AI_SIMULATE_Value; \
	VARIABLE func6_AI_SIMULATE_Enabled; \
	MENU func6_AI_SIMULATE_page; \
	COMMAND func6_AI_SIMULATE_read; \
	COMMAND func6_AI_SIMULATE_write; \
	COLLECTION func6_AI_VIEW_1; \
	MENU func6_AI_VIEW_1_page; \
	MENU func6_AI_Simple_Dialog_Optional_A; \
	UNIT func6_AI_OUT_SCALE_unit_1; \
	UNIT func6_AI_OUT_SCALE_unit_2

#define USE_FUNC6_AI_OPTIONAL_B \
	USE_FUNC6_AI_OPTIONAL_BOTH; \
	MENU func6_AI_Simple_Dialog_Optional_B; \
	UNIT func6_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC6_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func6_AI_)
#define USE_FUNC6_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func6_AI_)
#define USE_FUNC6_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func6_AI_)
#define USE_FUNC6_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func6_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC7_AI_MANDATORY_BOTH \
	BLOCK func7_AI_block; \
	COLLECTION func7_AI_BLOCK_OBJECT; \
	VARIABLE func7_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func7_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func7_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func7_AI_BLOCK_OBJECT_Class; \
	VARIABLE func7_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func7_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func7_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func7_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func7_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func7_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func7_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func7_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func7_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func7_AI_BLOCK_OBJECT_page; \
	COMMAND func7_AI_BLOCK_OBJECT_read; \
	VARIABLE func7_AI_ST_REV; \
	MENU func7_AI_ST_REV_page; \
	COMMAND func7_AI_ST_REV_read; \
	VARIABLE func7_AI_TAG_DESC; \
	MENU func7_AI_TAG_DESC_page; \
	COMMAND func7_AI_TAG_DESC_read; \
	COMMAND func7_AI_TAG_DESC_write; \
	VARIABLE func7_AI_STRATEGY; \
	MENU func7_AI_STRATEGY_page; \
	COMMAND func7_AI_STRATEGY_read; \
	COMMAND func7_AI_STRATEGY_write; \
	VARIABLE func7_AI_ALERT_KEY; \
	MENU func7_AI_ALERT_KEY_page; \
	COMMAND func7_AI_ALERT_KEY_read; \
	COMMAND func7_AI_ALERT_KEY_write; \
	VARIABLE func7_AI_TARGET_MODE; \
	MENU func7_AI_TARGET_MODE_page; \
	COMMAND func7_AI_TARGET_MODE_read; \
	COMMAND func7_AI_TARGET_MODE_write; \
	COLLECTION func7_AI_MODE_BLK; \
	VARIABLE func7_AI_MODE_BLK_Actual; \
	VARIABLE func7_AI_MODE_BLK_Permitted; \
	VARIABLE func7_AI_MODE_BLK_Normal; \
	MENU func7_AI_MODE_BLK_page; \
	COMMAND func7_AI_MODE_BLK_read; \
	COLLECTION func7_AI_ALARM_SUM; \
	VARIABLE func7_AI_ALARM_SUM_Current; \
	VARIABLE func7_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func7_AI_ALARM_SUM_Unreported; \
	VARIABLE func7_AI_ALARM_SUM_Disabled; \
	MENU func7_AI_ALARM_SUM_page; \
	COMMAND func7_AI_ALARM_SUM_read; \
	COLLECTION func7_AI_BATCH; \
	VARIABLE func7_AI_BATCH_Batch_ID; \
	VARIABLE func7_AI_BATCH_Rup; \
	VARIABLE func7_AI_BATCH_Operation; \
	VARIABLE func7_AI_BATCH_Phase; \
	MENU func7_AI_BATCH_page; \
	COMMAND func7_AI_BATCH_read; \
	COMMAND func7_AI_BATCH_write; \
	COLLECTION func7_AI_OUT; \
	VARIABLE func7_AI_OUT_Value; \
	VARIABLE func7_AI_OUT_Status_Quality; \
	VARIABLE func7_AI_OUT_Status_Limit; \
	MENU func7_AI_OUT_page; \
	COMMAND func7_AI_OUT_read; \
	COMMAND func7_AI_OUT_write; \
	COLLECTION func7_AI_PV_SCALE; \
	VARIABLE func7_AI_PV_SCALE_Upper_Value; \
	VARIABLE func7_AI_PV_SCALE_Lower_Value; \
	MENU func7_AI_PV_SCALE_page; \
	COMMAND func7_AI_PV_SCALE_read; \
	COMMAND func7_AI_PV_SCALE_write; \
	VARIABLE func7_AI_PV_FTIME; \
	MENU func7_AI_PV_FTIME_page; \
	COMMAND func7_AI_PV_FTIME_read; \
	COMMAND func7_AI_PV_FTIME_write; \
	VARIABLE func7_AI_ALARM_HYS; \
	MENU func7_AI_ALARM_HYS_page; \
	COMMAND func7_AI_ALARM_HYS_read; \
	COMMAND func7_AI_ALARM_HYS_write; \
	VARIABLE func7_AI_HI_HI_LIM; \
	MENU func7_AI_HI_HI_LIM_page; \
	COMMAND func7_AI_HI_HI_LIM_read; \
	COMMAND func7_AI_HI_HI_LIM_write; \
	VARIABLE func7_AI_HI_LIM; \
	MENU func7_AI_HI_LIM_page; \
	COMMAND func7_AI_HI_LIM_read; \
	COMMAND func7_AI_HI_LIM_write; \
	VARIABLE func7_AI_LO_LIM; \
	MENU func7_AI_LO_LIM_page; \
	COMMAND func7_AI_LO_LIM_read; \
	COMMAND func7_AI_LO_LIM_write; \
	VARIABLE func7_AI_LO_LO_LIM; \
	MENU func7_AI_LO_LO_LIM_page; \
	COMMAND func7_AI_LO_LO_LIM_read; \
	COMMAND func7_AI_LO_LO_LIM_write

#define USE_FUNC7_AI_MANDATORY_A \
	USE_FUNC7_AI_MANDATORY_BOTH; \
	MENU func7_AI_Simple_Dialog_Mandatory_A; \
	MENU func7_AI_Display_mandatory_A; \
	CHART func7_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func7_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func7_AI_Display_out_mandatory_A; \
	MENU func7_AI_Tab_s_mandatory_A; \
	MENU func7_AI_Tab_s_pv_range_mandatory_A; \
	MENU func7_AI_Tab_s_limits_mandatory_A; \
	MENU func7_AI_Tab_m_mandatory_A; \
	MENU func7_AI_Tab_m_pv_range_mandatory_A; \
	MENU func7_AI_Tab_m_limits_mandatory_A

#define USE_FUNC7_AI_MANDATORY_B \
	USE_FUNC7_AI_MANDATORY_BOTH; \
	COLLECTION func7_AI_OUT_SCALE; \
	VARIABLE func7_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func7_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func7_AI_OUT_SCALE_Units_Index; \
	VARIABLE func7_AI_OUT_SCALE_Decimal_Point; \
	MENU func7_AI_OUT_SCALE_page; \
	COMMAND func7_AI_OUT_SCALE_read; \
	COMMAND func7_AI_OUT_SCALE_write; \
	VARIABLE func7_AI_LIN_TYPE; \
	MENU func7_AI_LIN_TYPE_page; \
	COMMAND func7_AI_LIN_TYPE_read; \
	COMMAND func7_AI_LIN_TYPE_write; \
	VARIABLE func7_AI_CHANNEL; \
	MENU func7_AI_CHANNEL_page; \
	COMMAND func7_AI_CHANNEL_read; \
	COMMAND func7_AI_CHANNEL_write; \
	COLLECTION func7_AI_SIMULATE; \
	VARIABLE func7_AI_SIMULATE_Status_Quality; \
	VARIABLE func7_AI_SIMULATE_Status_Limit; \
	VARIABLE func7_AI_SIMULATE_Value; \
	VARIABLE func7_AI_SIMULATE_Enabled; \
	MENU func7_AI_SIMULATE_page; \
	COMMAND func7_AI_SIMULATE_read; \
	COMMAND func7_AI_SIMULATE_write; \
	COLLECTION func7_AI_VIEW_1; \
	MENU func7_AI_VIEW_1_page; \
	MENU func7_AI_Simple_Dialog_Mandatory_B; \
	UNIT func7_AI_OUT_SCALE_unit_1; \
	MENU func7_AI_Simulation; \
	MENU func7_AI_Simulation_input; \
	MENU func7_AI_Simulation_input_group; \
	MENU func7_AI_Simulation_output; \
	MENU func7_AI_Simulation_output_group; \
	MENU func7_AI_Display_mandatory_B; \
	CHART func7_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func7_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func7_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func7_AI_Display_out_mandatory_B; \
	MENU func7_AI_Display_in_mandatory_B; \
	MENU func7_AI_Tab_s_mandatory_B; \
	MENU func7_AI_Tab_s_pv_range_mandatory_B; \
	MENU func7_AI_Tab_s_outscale_mandatory_B; \
	MENU func7_AI_Tab_s_limits_mandatory_B; \
	MENU func7_AI_Tab_s_interface_mandatory_B; \
	MENU func7_AI_Tab_m_mandatory_B; \
	MENU func7_AI_Tab_m_pv_range_mandatory_B; \
	MENU func7_AI_Tab_m_outscale_mandatory_B; \
	MENU func7_AI_Tab_m_limits_mandatory_B

#define USE_FUNC7_AI_OPTIONAL_BOTH \
	VARIABLE func7_AI_FSAFE_TYPE; \
	MENU func7_AI_FSAFE_TYPE_page; \
	COMMAND func7_AI_FSAFE_TYPE_read; \
	COMMAND func7_AI_FSAFE_TYPE_write; \
	VARIABLE func7_AI_FSAFE_VALUE; \
	MENU func7_AI_FSAFE_VALUE_page; \
	COMMAND func7_AI_FSAFE_VALUE_read; \
	COMMAND func7_AI_FSAFE_VALUE_write; \
	COLLECTION func7_AI_HI_HI_ALM; \
	VARIABLE func7_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func7_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func7_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func7_AI_HI_HI_ALM_Subcode; \
	VARIABLE func7_AI_HI_HI_ALM_Value; \
	MENU func7_AI_HI_HI_ALM_page; \
	COMMAND func7_AI_HI_HI_ALM_read; \
	COLLECTION func7_AI_HI_ALM; \
	VARIABLE func7_AI_HI_ALM_Unacknowledged; \
	VARIABLE func7_AI_HI_ALM_Alarm_State; \
	VARIABLE func7_AI_HI_ALM_Time_Stamp; \
	VARIABLE func7_AI_HI_ALM_Subcode; \
	VARIABLE func7_AI_HI_ALM_Value; \
	MENU func7_AI_HI_ALM_page; \
	COMMAND func7_AI_HI_ALM_read; \
	COLLECTION func7_AI_LO_ALM; \
	VARIABLE func7_AI_LO_ALM_Unacknowledged; \
	VARIABLE func7_AI_LO_ALM_Alarm_State; \
	VARIABLE func7_AI_LO_ALM_Time_Stamp; \
	VARIABLE func7_AI_LO_ALM_Subcode; \
	VARIABLE func7_AI_LO_ALM_Value; \
	MENU func7_AI_LO_ALM_page; \
	COMMAND func7_AI_LO_ALM_read; \
	COLLECTION func7_AI_LO_LO_ALM; \
	VARIABLE func7_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func7_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func7_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func7_AI_LO_LO_ALM_Subcode; \
	VARIABLE func7_AI_LO_LO_ALM_Value; \
	MENU func7_AI_LO_LO_ALM_page; \
	COMMAND func7_AI_LO_LO_ALM_read; \
	VARIABLE func7_AI_OUT_UNIT_TEXT; \
	MENU func7_AI_OUT_UNIT_TEXT_page; \
	COMMAND func7_AI_OUT_UNIT_TEXT_read; \
	COMMAND func7_AI_OUT_UNIT_TEXT_write

#define USE_FUNC7_AI_OPTIONAL_A \
	USE_FUNC7_AI_OPTIONAL_BOTH; \
	COLLECTION func7_AI_OUT_SCALE; \
	VARIABLE func7_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func7_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func7_AI_OUT_SCALE_Units_Index; \
	VARIABLE func7_AI_OUT_SCALE_Decimal_Point; \
	MENU func7_AI_OUT_SCALE_page; \
	COMMAND func7_AI_OUT_SCALE_read; \
	COMMAND func7_AI_OUT_SCALE_write; \
	VARIABLE func7_AI_LIN_TYPE; \
	MENU func7_AI_LIN_TYPE_page; \
	COMMAND func7_AI_LIN_TYPE_read; \
	COMMAND func7_AI_LIN_TYPE_write; \
	VARIABLE func7_AI_CHANNEL; \
	MENU func7_AI_CHANNEL_page; \
	COMMAND func7_AI_CHANNEL_read; \
	COMMAND func7_AI_CHANNEL_write; \
	COLLECTION func7_AI_SIMULATE; \
	VARIABLE func7_AI_SIMULATE_Status_Quality; \
	VARIABLE func7_AI_SIMULATE_Status_Limit; \
	VARIABLE func7_AI_SIMULATE_Value; \
	VARIABLE func7_AI_SIMULATE_Enabled; \
	MENU func7_AI_SIMULATE_page; \
	COMMAND func7_AI_SIMULATE_read; \
	COMMAND func7_AI_SIMULATE_write; \
	COLLECTION func7_AI_VIEW_1; \
	MENU func7_AI_VIEW_1_page; \
	MENU func7_AI_Simple_Dialog_Optional_A; \
	UNIT func7_AI_OUT_SCALE_unit_1; \
	UNIT func7_AI_OUT_SCALE_unit_2

#define USE_FUNC7_AI_OPTIONAL_B \
	USE_FUNC7_AI_OPTIONAL_BOTH; \
	MENU func7_AI_Simple_Dialog_Optional_B; \
	UNIT func7_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC7_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func7_AI_)
#define USE_FUNC7_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func7_AI_)
#define USE_FUNC7_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func7_AI_)
#define USE_FUNC7_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func7_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC8_AI_MANDATORY_BOTH \
	BLOCK func8_AI_block; \
	COLLECTION func8_AI_BLOCK_OBJECT; \
	VARIABLE func8_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func8_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func8_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func8_AI_BLOCK_OBJECT_Class; \
	VARIABLE func8_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func8_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func8_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func8_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func8_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func8_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func8_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func8_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func8_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func8_AI_BLOCK_OBJECT_page; \
	COMMAND func8_AI_BLOCK_OBJECT_read; \
	VARIABLE func8_AI_ST_REV; \
	MENU func8_AI_ST_REV_page; \
	COMMAND func8_AI_ST_REV_read; \
	VARIABLE func8_AI_TAG_DESC; \
	MENU func8_AI_TAG_DESC_page; \
	COMMAND func8_AI_TAG_DESC_read; \
	COMMAND func8_AI_TAG_DESC_write; \
	VARIABLE func8_AI_STRATEGY; \
	MENU func8_AI_STRATEGY_page; \
	COMMAND func8_AI_STRATEGY_read; \
	COMMAND func8_AI_STRATEGY_write; \
	VARIABLE func8_AI_ALERT_KEY; \
	MENU func8_AI_ALERT_KEY_page; \
	COMMAND func8_AI_ALERT_KEY_read; \
	COMMAND func8_AI_ALERT_KEY_write; \
	VARIABLE func8_AI_TARGET_MODE; \
	MENU func8_AI_TARGET_MODE_page; \
	COMMAND func8_AI_TARGET_MODE_read; \
	COMMAND func8_AI_TARGET_MODE_write; \
	COLLECTION func8_AI_MODE_BLK; \
	VARIABLE func8_AI_MODE_BLK_Actual; \
	VARIABLE func8_AI_MODE_BLK_Permitted; \
	VARIABLE func8_AI_MODE_BLK_Normal; \
	MENU func8_AI_MODE_BLK_page; \
	COMMAND func8_AI_MODE_BLK_read; \
	COLLECTION func8_AI_ALARM_SUM; \
	VARIABLE func8_AI_ALARM_SUM_Current; \
	VARIABLE func8_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func8_AI_ALARM_SUM_Unreported; \
	VARIABLE func8_AI_ALARM_SUM_Disabled; \
	MENU func8_AI_ALARM_SUM_page; \
	COMMAND func8_AI_ALARM_SUM_read; \
	COLLECTION func8_AI_BATCH; \
	VARIABLE func8_AI_BATCH_Batch_ID; \
	VARIABLE func8_AI_BATCH_Rup; \
	VARIABLE func8_AI_BATCH_Operation; \
	VARIABLE func8_AI_BATCH_Phase; \
	MENU func8_AI_BATCH_page; \
	COMMAND func8_AI_BATCH_read; \
	COMMAND func8_AI_BATCH_write; \
	COLLECTION func8_AI_OUT; \
	VARIABLE func8_AI_OUT_Value; \
	VARIABLE func8_AI_OUT_Status_Quality; \
	VARIABLE func8_AI_OUT_Status_Limit; \
	MENU func8_AI_OUT_page; \
	COMMAND func8_AI_OUT_read; \
	COMMAND func8_AI_OUT_write; \
	COLLECTION func8_AI_PV_SCALE; \
	VARIABLE func8_AI_PV_SCALE_Upper_Value; \
	VARIABLE func8_AI_PV_SCALE_Lower_Value; \
	MENU func8_AI_PV_SCALE_page; \
	COMMAND func8_AI_PV_SCALE_read; \
	COMMAND func8_AI_PV_SCALE_write; \
	VARIABLE func8_AI_PV_FTIME; \
	MENU func8_AI_PV_FTIME_page; \
	COMMAND func8_AI_PV_FTIME_read; \
	COMMAND func8_AI_PV_FTIME_write; \
	VARIABLE func8_AI_ALARM_HYS; \
	MENU func8_AI_ALARM_HYS_page; \
	COMMAND func8_AI_ALARM_HYS_read; \
	COMMAND func8_AI_ALARM_HYS_write; \
	VARIABLE func8_AI_HI_HI_LIM; \
	MENU func8_AI_HI_HI_LIM_page; \
	COMMAND func8_AI_HI_HI_LIM_read; \
	COMMAND func8_AI_HI_HI_LIM_write; \
	VARIABLE func8_AI_HI_LIM; \
	MENU func8_AI_HI_LIM_page; \
	COMMAND func8_AI_HI_LIM_read; \
	COMMAND func8_AI_HI_LIM_write; \
	VARIABLE func8_AI_LO_LIM; \
	MENU func8_AI_LO_LIM_page; \
	COMMAND func8_AI_LO_LIM_read; \
	COMMAND func8_AI_LO_LIM_write; \
	VARIABLE func8_AI_LO_LO_LIM; \
	MENU func8_AI_LO_LO_LIM_page; \
	COMMAND func8_AI_LO_LO_LIM_read; \
	COMMAND func8_AI_LO_LO_LIM_write

#define USE_FUNC8_AI_MANDATORY_A \
	USE_FUNC8_AI_MANDATORY_BOTH; \
	MENU func8_AI_Simple_Dialog_Mandatory_A; \
	MENU func8_AI_Display_mandatory_A; \
	CHART func8_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func8_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func8_AI_Display_out_mandatory_A; \
	MENU func8_AI_Tab_s_mandatory_A; \
	MENU func8_AI_Tab_s_pv_range_mandatory_A; \
	MENU func8_AI_Tab_s_limits_mandatory_A; \
	MENU func8_AI_Tab_m_mandatory_A; \
	MENU func8_AI_Tab_m_pv_range_mandatory_A; \
	MENU func8_AI_Tab_m_limits_mandatory_A

#define USE_FUNC8_AI_MANDATORY_B \
	USE_FUNC8_AI_MANDATORY_BOTH; \
	COLLECTION func8_AI_OUT_SCALE; \
	VARIABLE func8_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func8_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func8_AI_OUT_SCALE_Units_Index; \
	VARIABLE func8_AI_OUT_SCALE_Decimal_Point; \
	MENU func8_AI_OUT_SCALE_page; \
	COMMAND func8_AI_OUT_SCALE_read; \
	COMMAND func8_AI_OUT_SCALE_write; \
	VARIABLE func8_AI_LIN_TYPE; \
	MENU func8_AI_LIN_TYPE_page; \
	COMMAND func8_AI_LIN_TYPE_read; \
	COMMAND func8_AI_LIN_TYPE_write; \
	VARIABLE func8_AI_CHANNEL; \
	MENU func8_AI_CHANNEL_page; \
	COMMAND func8_AI_CHANNEL_read; \
	COMMAND func8_AI_CHANNEL_write; \
	COLLECTION func8_AI_SIMULATE; \
	VARIABLE func8_AI_SIMULATE_Status_Quality; \
	VARIABLE func8_AI_SIMULATE_Status_Limit; \
	VARIABLE func8_AI_SIMULATE_Value; \
	VARIABLE func8_AI_SIMULATE_Enabled; \
	MENU func8_AI_SIMULATE_page; \
	COMMAND func8_AI_SIMULATE_read; \
	COMMAND func8_AI_SIMULATE_write; \
	COLLECTION func8_AI_VIEW_1; \
	MENU func8_AI_VIEW_1_page; \
	MENU func8_AI_Simple_Dialog_Mandatory_B; \
	UNIT func8_AI_OUT_SCALE_unit_1; \
	MENU func8_AI_Simulation; \
	MENU func8_AI_Simulation_input; \
	MENU func8_AI_Simulation_input_group; \
	MENU func8_AI_Simulation_output; \
	MENU func8_AI_Simulation_output_group; \
	MENU func8_AI_Display_mandatory_B; \
	CHART func8_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func8_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func8_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func8_AI_Display_out_mandatory_B; \
	MENU func8_AI_Display_in_mandatory_B; \
	MENU func8_AI_Tab_s_mandatory_B; \
	MENU func8_AI_Tab_s_pv_range_mandatory_B; \
	MENU func8_AI_Tab_s_outscale_mandatory_B; \
	MENU func8_AI_Tab_s_limits_mandatory_B; \
	MENU func8_AI_Tab_s_interface_mandatory_B; \
	MENU func8_AI_Tab_m_mandatory_B; \
	MENU func8_AI_Tab_m_pv_range_mandatory_B; \
	MENU func8_AI_Tab_m_outscale_mandatory_B; \
	MENU func8_AI_Tab_m_limits_mandatory_B

#define USE_FUNC8_AI_OPTIONAL_BOTH \
	VARIABLE func8_AI_FSAFE_TYPE; \
	MENU func8_AI_FSAFE_TYPE_page; \
	COMMAND func8_AI_FSAFE_TYPE_read; \
	COMMAND func8_AI_FSAFE_TYPE_write; \
	VARIABLE func8_AI_FSAFE_VALUE; \
	MENU func8_AI_FSAFE_VALUE_page; \
	COMMAND func8_AI_FSAFE_VALUE_read; \
	COMMAND func8_AI_FSAFE_VALUE_write; \
	COLLECTION func8_AI_HI_HI_ALM; \
	VARIABLE func8_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func8_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func8_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func8_AI_HI_HI_ALM_Subcode; \
	VARIABLE func8_AI_HI_HI_ALM_Value; \
	MENU func8_AI_HI_HI_ALM_page; \
	COMMAND func8_AI_HI_HI_ALM_read; \
	COLLECTION func8_AI_HI_ALM; \
	VARIABLE func8_AI_HI_ALM_Unacknowledged; \
	VARIABLE func8_AI_HI_ALM_Alarm_State; \
	VARIABLE func8_AI_HI_ALM_Time_Stamp; \
	VARIABLE func8_AI_HI_ALM_Subcode; \
	VARIABLE func8_AI_HI_ALM_Value; \
	MENU func8_AI_HI_ALM_page; \
	COMMAND func8_AI_HI_ALM_read; \
	COLLECTION func8_AI_LO_ALM; \
	VARIABLE func8_AI_LO_ALM_Unacknowledged; \
	VARIABLE func8_AI_LO_ALM_Alarm_State; \
	VARIABLE func8_AI_LO_ALM_Time_Stamp; \
	VARIABLE func8_AI_LO_ALM_Subcode; \
	VARIABLE func8_AI_LO_ALM_Value; \
	MENU func8_AI_LO_ALM_page; \
	COMMAND func8_AI_LO_ALM_read; \
	COLLECTION func8_AI_LO_LO_ALM; \
	VARIABLE func8_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func8_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func8_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func8_AI_LO_LO_ALM_Subcode; \
	VARIABLE func8_AI_LO_LO_ALM_Value; \
	MENU func8_AI_LO_LO_ALM_page; \
	COMMAND func8_AI_LO_LO_ALM_read; \
	VARIABLE func8_AI_OUT_UNIT_TEXT; \
	MENU func8_AI_OUT_UNIT_TEXT_page; \
	COMMAND func8_AI_OUT_UNIT_TEXT_read; \
	COMMAND func8_AI_OUT_UNIT_TEXT_write

#define USE_FUNC8_AI_OPTIONAL_A \
	USE_FUNC8_AI_OPTIONAL_BOTH; \
	COLLECTION func8_AI_OUT_SCALE; \
	VARIABLE func8_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func8_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func8_AI_OUT_SCALE_Units_Index; \
	VARIABLE func8_AI_OUT_SCALE_Decimal_Point; \
	MENU func8_AI_OUT_SCALE_page; \
	COMMAND func8_AI_OUT_SCALE_read; \
	COMMAND func8_AI_OUT_SCALE_write; \
	VARIABLE func8_AI_LIN_TYPE; \
	MENU func8_AI_LIN_TYPE_page; \
	COMMAND func8_AI_LIN_TYPE_read; \
	COMMAND func8_AI_LIN_TYPE_write; \
	VARIABLE func8_AI_CHANNEL; \
	MENU func8_AI_CHANNEL_page; \
	COMMAND func8_AI_CHANNEL_read; \
	COMMAND func8_AI_CHANNEL_write; \
	COLLECTION func8_AI_SIMULATE; \
	VARIABLE func8_AI_SIMULATE_Status_Quality; \
	VARIABLE func8_AI_SIMULATE_Status_Limit; \
	VARIABLE func8_AI_SIMULATE_Value; \
	VARIABLE func8_AI_SIMULATE_Enabled; \
	MENU func8_AI_SIMULATE_page; \
	COMMAND func8_AI_SIMULATE_read; \
	COMMAND func8_AI_SIMULATE_write; \
	COLLECTION func8_AI_VIEW_1; \
	MENU func8_AI_VIEW_1_page; \
	MENU func8_AI_Simple_Dialog_Optional_A; \
	UNIT func8_AI_OUT_SCALE_unit_1; \
	UNIT func8_AI_OUT_SCALE_unit_2

#define USE_FUNC8_AI_OPTIONAL_B \
	USE_FUNC8_AI_OPTIONAL_BOTH; \
	MENU func8_AI_Simple_Dialog_Optional_B; \
	UNIT func8_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC8_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func8_AI_)
#define USE_FUNC8_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func8_AI_)
#define USE_FUNC8_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func8_AI_)
#define USE_FUNC8_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func8_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC9_AI_MANDATORY_BOTH \
	BLOCK func9_AI_block; \
	COLLECTION func9_AI_BLOCK_OBJECT; \
	VARIABLE func9_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func9_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func9_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func9_AI_BLOCK_OBJECT_Class; \
	VARIABLE func9_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func9_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func9_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func9_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func9_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func9_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func9_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func9_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func9_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func9_AI_BLOCK_OBJECT_page; \
	COMMAND func9_AI_BLOCK_OBJECT_read; \
	VARIABLE func9_AI_ST_REV; \
	MENU func9_AI_ST_REV_page; \
	COMMAND func9_AI_ST_REV_read; \
	VARIABLE func9_AI_TAG_DESC; \
	MENU func9_AI_TAG_DESC_page; \
	COMMAND func9_AI_TAG_DESC_read; \
	COMMAND func9_AI_TAG_DESC_write; \
	VARIABLE func9_AI_STRATEGY; \
	MENU func9_AI_STRATEGY_page; \
	COMMAND func9_AI_STRATEGY_read; \
	COMMAND func9_AI_STRATEGY_write; \
	VARIABLE func9_AI_ALERT_KEY; \
	MENU func9_AI_ALERT_KEY_page; \
	COMMAND func9_AI_ALERT_KEY_read; \
	COMMAND func9_AI_ALERT_KEY_write; \
	VARIABLE func9_AI_TARGET_MODE; \
	MENU func9_AI_TARGET_MODE_page; \
	COMMAND func9_AI_TARGET_MODE_read; \
	COMMAND func9_AI_TARGET_MODE_write; \
	COLLECTION func9_AI_MODE_BLK; \
	VARIABLE func9_AI_MODE_BLK_Actual; \
	VARIABLE func9_AI_MODE_BLK_Permitted; \
	VARIABLE func9_AI_MODE_BLK_Normal; \
	MENU func9_AI_MODE_BLK_page; \
	COMMAND func9_AI_MODE_BLK_read; \
	COLLECTION func9_AI_ALARM_SUM; \
	VARIABLE func9_AI_ALARM_SUM_Current; \
	VARIABLE func9_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func9_AI_ALARM_SUM_Unreported; \
	VARIABLE func9_AI_ALARM_SUM_Disabled; \
	MENU func9_AI_ALARM_SUM_page; \
	COMMAND func9_AI_ALARM_SUM_read; \
	COLLECTION func9_AI_BATCH; \
	VARIABLE func9_AI_BATCH_Batch_ID; \
	VARIABLE func9_AI_BATCH_Rup; \
	VARIABLE func9_AI_BATCH_Operation; \
	VARIABLE func9_AI_BATCH_Phase; \
	MENU func9_AI_BATCH_page; \
	COMMAND func9_AI_BATCH_read; \
	COMMAND func9_AI_BATCH_write; \
	COLLECTION func9_AI_OUT; \
	VARIABLE func9_AI_OUT_Value; \
	VARIABLE func9_AI_OUT_Status_Quality; \
	VARIABLE func9_AI_OUT_Status_Limit; \
	MENU func9_AI_OUT_page; \
	COMMAND func9_AI_OUT_read; \
	COMMAND func9_AI_OUT_write; \
	COLLECTION func9_AI_PV_SCALE; \
	VARIABLE func9_AI_PV_SCALE_Upper_Value; \
	VARIABLE func9_AI_PV_SCALE_Lower_Value; \
	MENU func9_AI_PV_SCALE_page; \
	COMMAND func9_AI_PV_SCALE_read; \
	COMMAND func9_AI_PV_SCALE_write; \
	VARIABLE func9_AI_PV_FTIME; \
	MENU func9_AI_PV_FTIME_page; \
	COMMAND func9_AI_PV_FTIME_read; \
	COMMAND func9_AI_PV_FTIME_write; \
	VARIABLE func9_AI_ALARM_HYS; \
	MENU func9_AI_ALARM_HYS_page; \
	COMMAND func9_AI_ALARM_HYS_read; \
	COMMAND func9_AI_ALARM_HYS_write; \
	VARIABLE func9_AI_HI_HI_LIM; \
	MENU func9_AI_HI_HI_LIM_page; \
	COMMAND func9_AI_HI_HI_LIM_read; \
	COMMAND func9_AI_HI_HI_LIM_write; \
	VARIABLE func9_AI_HI_LIM; \
	MENU func9_AI_HI_LIM_page; \
	COMMAND func9_AI_HI_LIM_read; \
	COMMAND func9_AI_HI_LIM_write; \
	VARIABLE func9_AI_LO_LIM; \
	MENU func9_AI_LO_LIM_page; \
	COMMAND func9_AI_LO_LIM_read; \
	COMMAND func9_AI_LO_LIM_write; \
	VARIABLE func9_AI_LO_LO_LIM; \
	MENU func9_AI_LO_LO_LIM_page; \
	COMMAND func9_AI_LO_LO_LIM_read; \
	COMMAND func9_AI_LO_LO_LIM_write

#define USE_FUNC9_AI_MANDATORY_A \
	USE_FUNC9_AI_MANDATORY_BOTH; \
	MENU func9_AI_Simple_Dialog_Mandatory_A; \
	MENU func9_AI_Display_mandatory_A; \
	CHART func9_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func9_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func9_AI_Display_out_mandatory_A; \
	MENU func9_AI_Tab_s_mandatory_A; \
	MENU func9_AI_Tab_s_pv_range_mandatory_A; \
	MENU func9_AI_Tab_s_limits_mandatory_A; \
	MENU func9_AI_Tab_m_mandatory_A; \
	MENU func9_AI_Tab_m_pv_range_mandatory_A; \
	MENU func9_AI_Tab_m_limits_mandatory_A

#define USE_FUNC9_AI_MANDATORY_B \
	USE_FUNC9_AI_MANDATORY_BOTH; \
	COLLECTION func9_AI_OUT_SCALE; \
	VARIABLE func9_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func9_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func9_AI_OUT_SCALE_Units_Index; \
	VARIABLE func9_AI_OUT_SCALE_Decimal_Point; \
	MENU func9_AI_OUT_SCALE_page; \
	COMMAND func9_AI_OUT_SCALE_read; \
	COMMAND func9_AI_OUT_SCALE_write; \
	VARIABLE func9_AI_LIN_TYPE; \
	MENU func9_AI_LIN_TYPE_page; \
	COMMAND func9_AI_LIN_TYPE_read; \
	COMMAND func9_AI_LIN_TYPE_write; \
	VARIABLE func9_AI_CHANNEL; \
	MENU func9_AI_CHANNEL_page; \
	COMMAND func9_AI_CHANNEL_read; \
	COMMAND func9_AI_CHANNEL_write; \
	COLLECTION func9_AI_SIMULATE; \
	VARIABLE func9_AI_SIMULATE_Status_Quality; \
	VARIABLE func9_AI_SIMULATE_Status_Limit; \
	VARIABLE func9_AI_SIMULATE_Value; \
	VARIABLE func9_AI_SIMULATE_Enabled; \
	MENU func9_AI_SIMULATE_page; \
	COMMAND func9_AI_SIMULATE_read; \
	COMMAND func9_AI_SIMULATE_write; \
	COLLECTION func9_AI_VIEW_1; \
	MENU func9_AI_VIEW_1_page; \
	MENU func9_AI_Simple_Dialog_Mandatory_B; \
	UNIT func9_AI_OUT_SCALE_unit_1; \
	MENU func9_AI_Simulation; \
	MENU func9_AI_Simulation_input; \
	MENU func9_AI_Simulation_input_group; \
	MENU func9_AI_Simulation_output; \
	MENU func9_AI_Simulation_output_group; \
	MENU func9_AI_Display_mandatory_B; \
	CHART func9_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func9_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func9_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func9_AI_Display_out_mandatory_B; \
	MENU func9_AI_Display_in_mandatory_B; \
	MENU func9_AI_Tab_s_mandatory_B; \
	MENU func9_AI_Tab_s_pv_range_mandatory_B; \
	MENU func9_AI_Tab_s_outscale_mandatory_B; \
	MENU func9_AI_Tab_s_limits_mandatory_B; \
	MENU func9_AI_Tab_s_interface_mandatory_B; \
	MENU func9_AI_Tab_m_mandatory_B; \
	MENU func9_AI_Tab_m_pv_range_mandatory_B; \
	MENU func9_AI_Tab_m_outscale_mandatory_B; \
	MENU func9_AI_Tab_m_limits_mandatory_B

#define USE_FUNC9_AI_OPTIONAL_BOTH \
	VARIABLE func9_AI_FSAFE_TYPE; \
	MENU func9_AI_FSAFE_TYPE_page; \
	COMMAND func9_AI_FSAFE_TYPE_read; \
	COMMAND func9_AI_FSAFE_TYPE_write; \
	VARIABLE func9_AI_FSAFE_VALUE; \
	MENU func9_AI_FSAFE_VALUE_page; \
	COMMAND func9_AI_FSAFE_VALUE_read; \
	COMMAND func9_AI_FSAFE_VALUE_write; \
	COLLECTION func9_AI_HI_HI_ALM; \
	VARIABLE func9_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func9_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func9_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func9_AI_HI_HI_ALM_Subcode; \
	VARIABLE func9_AI_HI_HI_ALM_Value; \
	MENU func9_AI_HI_HI_ALM_page; \
	COMMAND func9_AI_HI_HI_ALM_read; \
	COLLECTION func9_AI_HI_ALM; \
	VARIABLE func9_AI_HI_ALM_Unacknowledged; \
	VARIABLE func9_AI_HI_ALM_Alarm_State; \
	VARIABLE func9_AI_HI_ALM_Time_Stamp; \
	VARIABLE func9_AI_HI_ALM_Subcode; \
	VARIABLE func9_AI_HI_ALM_Value; \
	MENU func9_AI_HI_ALM_page; \
	COMMAND func9_AI_HI_ALM_read; \
	COLLECTION func9_AI_LO_ALM; \
	VARIABLE func9_AI_LO_ALM_Unacknowledged; \
	VARIABLE func9_AI_LO_ALM_Alarm_State; \
	VARIABLE func9_AI_LO_ALM_Time_Stamp; \
	VARIABLE func9_AI_LO_ALM_Subcode; \
	VARIABLE func9_AI_LO_ALM_Value; \
	MENU func9_AI_LO_ALM_page; \
	COMMAND func9_AI_LO_ALM_read; \
	COLLECTION func9_AI_LO_LO_ALM; \
	VARIABLE func9_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func9_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func9_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func9_AI_LO_LO_ALM_Subcode; \
	VARIABLE func9_AI_LO_LO_ALM_Value; \
	MENU func9_AI_LO_LO_ALM_page; \
	COMMAND func9_AI_LO_LO_ALM_read; \
	VARIABLE func9_AI_OUT_UNIT_TEXT; \
	MENU func9_AI_OUT_UNIT_TEXT_page; \
	COMMAND func9_AI_OUT_UNIT_TEXT_read; \
	COMMAND func9_AI_OUT_UNIT_TEXT_write

#define USE_FUNC9_AI_OPTIONAL_A \
	USE_FUNC9_AI_OPTIONAL_BOTH; \
	COLLECTION func9_AI_OUT_SCALE; \
	VARIABLE func9_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func9_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func9_AI_OUT_SCALE_Units_Index; \
	VARIABLE func9_AI_OUT_SCALE_Decimal_Point; \
	MENU func9_AI_OUT_SCALE_page; \
	COMMAND func9_AI_OUT_SCALE_read; \
	COMMAND func9_AI_OUT_SCALE_write; \
	VARIABLE func9_AI_LIN_TYPE; \
	MENU func9_AI_LIN_TYPE_page; \
	COMMAND func9_AI_LIN_TYPE_read; \
	COMMAND func9_AI_LIN_TYPE_write; \
	VARIABLE func9_AI_CHANNEL; \
	MENU func9_AI_CHANNEL_page; \
	COMMAND func9_AI_CHANNEL_read; \
	COMMAND func9_AI_CHANNEL_write; \
	COLLECTION func9_AI_SIMULATE; \
	VARIABLE func9_AI_SIMULATE_Status_Quality; \
	VARIABLE func9_AI_SIMULATE_Status_Limit; \
	VARIABLE func9_AI_SIMULATE_Value; \
	VARIABLE func9_AI_SIMULATE_Enabled; \
	MENU func9_AI_SIMULATE_page; \
	COMMAND func9_AI_SIMULATE_read; \
	COMMAND func9_AI_SIMULATE_write; \
	COLLECTION func9_AI_VIEW_1; \
	MENU func9_AI_VIEW_1_page; \
	MENU func9_AI_Simple_Dialog_Optional_A; \
	UNIT func9_AI_OUT_SCALE_unit_1; \
	UNIT func9_AI_OUT_SCALE_unit_2

#define USE_FUNC9_AI_OPTIONAL_B \
	USE_FUNC9_AI_OPTIONAL_BOTH; \
	MENU func9_AI_Simple_Dialog_Optional_B; \
	UNIT func9_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC9_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func9_AI_)
#define USE_FUNC9_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func9_AI_)
#define USE_FUNC9_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func9_AI_)
#define USE_FUNC9_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func9_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC10_AI_MANDATORY_BOTH \
	BLOCK func10_AI_block; \
	COLLECTION func10_AI_BLOCK_OBJECT; \
	VARIABLE func10_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func10_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func10_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func10_AI_BLOCK_OBJECT_Class; \
	VARIABLE func10_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func10_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func10_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func10_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func10_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func10_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func10_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func10_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func10_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func10_AI_BLOCK_OBJECT_page; \
	COMMAND func10_AI_BLOCK_OBJECT_read; \
	VARIABLE func10_AI_ST_REV; \
	MENU func10_AI_ST_REV_page; \
	COMMAND func10_AI_ST_REV_read; \
	VARIABLE func10_AI_TAG_DESC; \
	MENU func10_AI_TAG_DESC_page; \
	COMMAND func10_AI_TAG_DESC_read; \
	COMMAND func10_AI_TAG_DESC_write; \
	VARIABLE func10_AI_STRATEGY; \
	MENU func10_AI_STRATEGY_page; \
	COMMAND func10_AI_STRATEGY_read; \
	COMMAND func10_AI_STRATEGY_write; \
	VARIABLE func10_AI_ALERT_KEY; \
	MENU func10_AI_ALERT_KEY_page; \
	COMMAND func10_AI_ALERT_KEY_read; \
	COMMAND func10_AI_ALERT_KEY_write; \
	VARIABLE func10_AI_TARGET_MODE; \
	MENU func10_AI_TARGET_MODE_page; \
	COMMAND func10_AI_TARGET_MODE_read; \
	COMMAND func10_AI_TARGET_MODE_write; \
	COLLECTION func10_AI_MODE_BLK; \
	VARIABLE func10_AI_MODE_BLK_Actual; \
	VARIABLE func10_AI_MODE_BLK_Permitted; \
	VARIABLE func10_AI_MODE_BLK_Normal; \
	MENU func10_AI_MODE_BLK_page; \
	COMMAND func10_AI_MODE_BLK_read; \
	COLLECTION func10_AI_ALARM_SUM; \
	VARIABLE func10_AI_ALARM_SUM_Current; \
	VARIABLE func10_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func10_AI_ALARM_SUM_Unreported; \
	VARIABLE func10_AI_ALARM_SUM_Disabled; \
	MENU func10_AI_ALARM_SUM_page; \
	COMMAND func10_AI_ALARM_SUM_read; \
	COLLECTION func10_AI_BATCH; \
	VARIABLE func10_AI_BATCH_Batch_ID; \
	VARIABLE func10_AI_BATCH_Rup; \
	VARIABLE func10_AI_BATCH_Operation; \
	VARIABLE func10_AI_BATCH_Phase; \
	MENU func10_AI_BATCH_page; \
	COMMAND func10_AI_BATCH_read; \
	COMMAND func10_AI_BATCH_write; \
	COLLECTION func10_AI_OUT; \
	VARIABLE func10_AI_OUT_Value; \
	VARIABLE func10_AI_OUT_Status_Quality; \
	VARIABLE func10_AI_OUT_Status_Limit; \
	MENU func10_AI_OUT_page; \
	COMMAND func10_AI_OUT_read; \
	COMMAND func10_AI_OUT_write; \
	COLLECTION func10_AI_PV_SCALE; \
	VARIABLE func10_AI_PV_SCALE_Upper_Value; \
	VARIABLE func10_AI_PV_SCALE_Lower_Value; \
	MENU func10_AI_PV_SCALE_page; \
	COMMAND func10_AI_PV_SCALE_read; \
	COMMAND func10_AI_PV_SCALE_write; \
	VARIABLE func10_AI_PV_FTIME; \
	MENU func10_AI_PV_FTIME_page; \
	COMMAND func10_AI_PV_FTIME_read; \
	COMMAND func10_AI_PV_FTIME_write; \
	VARIABLE func10_AI_ALARM_HYS; \
	MENU func10_AI_ALARM_HYS_page; \
	COMMAND func10_AI_ALARM_HYS_read; \
	COMMAND func10_AI_ALARM_HYS_write; \
	VARIABLE func10_AI_HI_HI_LIM; \
	MENU func10_AI_HI_HI_LIM_page; \
	COMMAND func10_AI_HI_HI_LIM_read; \
	COMMAND func10_AI_HI_HI_LIM_write; \
	VARIABLE func10_AI_HI_LIM; \
	MENU func10_AI_HI_LIM_page; \
	COMMAND func10_AI_HI_LIM_read; \
	COMMAND func10_AI_HI_LIM_write; \
	VARIABLE func10_AI_LO_LIM; \
	MENU func10_AI_LO_LIM_page; \
	COMMAND func10_AI_LO_LIM_read; \
	COMMAND func10_AI_LO_LIM_write; \
	VARIABLE func10_AI_LO_LO_LIM; \
	MENU func10_AI_LO_LO_LIM_page; \
	COMMAND func10_AI_LO_LO_LIM_read; \
	COMMAND func10_AI_LO_LO_LIM_write

#define USE_FUNC10_AI_MANDATORY_A \
	USE_FUNC10_AI_MANDATORY_BOTH; \
	MENU func10_AI_Simple_Dialog_Mandatory_A; \
	MENU func10_AI_Display_mandatory_A; \
	CHART func10_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func10_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func10_AI_Display_out_mandatory_A; \
	MENU func10_AI_Tab_s_mandatory_A; \
	MENU func10_AI_Tab_s_pv_range_mandatory_A; \
	MENU func10_AI_Tab_s_limits_mandatory_A; \
	MENU func10_AI_Tab_m_mandatory_A; \
	MENU func10_AI_Tab_m_pv_range_mandatory_A; \
	MENU func10_AI_Tab_m_limits_mandatory_A

#define USE_FUNC10_AI_MANDATORY_B \
	USE_FUNC10_AI_MANDATORY_BOTH; \
	COLLECTION func10_AI_OUT_SCALE; \
	VARIABLE func10_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func10_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func10_AI_OUT_SCALE_Units_Index; \
	VARIABLE func10_AI_OUT_SCALE_Decimal_Point; \
	MENU func10_AI_OUT_SCALE_page; \
	COMMAND func10_AI_OUT_SCALE_read; \
	COMMAND func10_AI_OUT_SCALE_write; \
	VARIABLE func10_AI_LIN_TYPE; \
	MENU func10_AI_LIN_TYPE_page; \
	COMMAND func10_AI_LIN_TYPE_read; \
	COMMAND func10_AI_LIN_TYPE_write; \
	VARIABLE func10_AI_CHANNEL; \
	MENU func10_AI_CHANNEL_page; \
	COMMAND func10_AI_CHANNEL_read; \
	COMMAND func10_AI_CHANNEL_write; \
	COLLECTION func10_AI_SIMULATE; \
	VARIABLE func10_AI_SIMULATE_Status_Quality; \
	VARIABLE func10_AI_SIMULATE_Status_Limit; \
	VARIABLE func10_AI_SIMULATE_Value; \
	VARIABLE func10_AI_SIMULATE_Enabled; \
	MENU func10_AI_SIMULATE_page; \
	COMMAND func10_AI_SIMULATE_read; \
	COMMAND func10_AI_SIMULATE_write; \
	COLLECTION func10_AI_VIEW_1; \
	MENU func10_AI_VIEW_1_page; \
	MENU func10_AI_Simple_Dialog_Mandatory_B; \
	UNIT func10_AI_OUT_SCALE_unit_1; \
	MENU func10_AI_Simulation; \
	MENU func10_AI_Simulation_input; \
	MENU func10_AI_Simulation_input_group; \
	MENU func10_AI_Simulation_output; \
	MENU func10_AI_Simulation_output_group; \
	MENU func10_AI_Display_mandatory_B; \
	CHART func10_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func10_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func10_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func10_AI_Display_out_mandatory_B; \
	MENU func10_AI_Display_in_mandatory_B; \
	MENU func10_AI_Tab_s_mandatory_B; \
	MENU func10_AI_Tab_s_pv_range_mandatory_B; \
	MENU func10_AI_Tab_s_outscale_mandatory_B; \
	MENU func10_AI_Tab_s_limits_mandatory_B; \
	MENU func10_AI_Tab_s_interface_mandatory_B; \
	MENU func10_AI_Tab_m_mandatory_B; \
	MENU func10_AI_Tab_m_pv_range_mandatory_B; \
	MENU func10_AI_Tab_m_outscale_mandatory_B; \
	MENU func10_AI_Tab_m_limits_mandatory_B

#define USE_FUNC10_AI_OPTIONAL_BOTH \
	VARIABLE func10_AI_FSAFE_TYPE; \
	MENU func10_AI_FSAFE_TYPE_page; \
	COMMAND func10_AI_FSAFE_TYPE_read; \
	COMMAND func10_AI_FSAFE_TYPE_write; \
	VARIABLE func10_AI_FSAFE_VALUE; \
	MENU func10_AI_FSAFE_VALUE_page; \
	COMMAND func10_AI_FSAFE_VALUE_read; \
	COMMAND func10_AI_FSAFE_VALUE_write; \
	COLLECTION func10_AI_HI_HI_ALM; \
	VARIABLE func10_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func10_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func10_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func10_AI_HI_HI_ALM_Subcode; \
	VARIABLE func10_AI_HI_HI_ALM_Value; \
	MENU func10_AI_HI_HI_ALM_page; \
	COMMAND func10_AI_HI_HI_ALM_read; \
	COLLECTION func10_AI_HI_ALM; \
	VARIABLE func10_AI_HI_ALM_Unacknowledged; \
	VARIABLE func10_AI_HI_ALM_Alarm_State; \
	VARIABLE func10_AI_HI_ALM_Time_Stamp; \
	VARIABLE func10_AI_HI_ALM_Subcode; \
	VARIABLE func10_AI_HI_ALM_Value; \
	MENU func10_AI_HI_ALM_page; \
	COMMAND func10_AI_HI_ALM_read; \
	COLLECTION func10_AI_LO_ALM; \
	VARIABLE func10_AI_LO_ALM_Unacknowledged; \
	VARIABLE func10_AI_LO_ALM_Alarm_State; \
	VARIABLE func10_AI_LO_ALM_Time_Stamp; \
	VARIABLE func10_AI_LO_ALM_Subcode; \
	VARIABLE func10_AI_LO_ALM_Value; \
	MENU func10_AI_LO_ALM_page; \
	COMMAND func10_AI_LO_ALM_read; \
	COLLECTION func10_AI_LO_LO_ALM; \
	VARIABLE func10_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func10_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func10_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func10_AI_LO_LO_ALM_Subcode; \
	VARIABLE func10_AI_LO_LO_ALM_Value; \
	MENU func10_AI_LO_LO_ALM_page; \
	COMMAND func10_AI_LO_LO_ALM_read; \
	VARIABLE func10_AI_OUT_UNIT_TEXT; \
	MENU func10_AI_OUT_UNIT_TEXT_page; \
	COMMAND func10_AI_OUT_UNIT_TEXT_read; \
	COMMAND func10_AI_OUT_UNIT_TEXT_write

#define USE_FUNC10_AI_OPTIONAL_A \
	USE_FUNC10_AI_OPTIONAL_BOTH; \
	COLLECTION func10_AI_OUT_SCALE; \
	VARIABLE func10_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func10_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func10_AI_OUT_SCALE_Units_Index; \
	VARIABLE func10_AI_OUT_SCALE_Decimal_Point; \
	MENU func10_AI_OUT_SCALE_page; \
	COMMAND func10_AI_OUT_SCALE_read; \
	COMMAND func10_AI_OUT_SCALE_write; \
	VARIABLE func10_AI_LIN_TYPE; \
	MENU func10_AI_LIN_TYPE_page; \
	COMMAND func10_AI_LIN_TYPE_read; \
	COMMAND func10_AI_LIN_TYPE_write; \
	VARIABLE func10_AI_CHANNEL; \
	MENU func10_AI_CHANNEL_page; \
	COMMAND func10_AI_CHANNEL_read; \
	COMMAND func10_AI_CHANNEL_write; \
	COLLECTION func10_AI_SIMULATE; \
	VARIABLE func10_AI_SIMULATE_Status_Quality; \
	VARIABLE func10_AI_SIMULATE_Status_Limit; \
	VARIABLE func10_AI_SIMULATE_Value; \
	VARIABLE func10_AI_SIMULATE_Enabled; \
	MENU func10_AI_SIMULATE_page; \
	COMMAND func10_AI_SIMULATE_read; \
	COMMAND func10_AI_SIMULATE_write; \
	COLLECTION func10_AI_VIEW_1; \
	MENU func10_AI_VIEW_1_page; \
	MENU func10_AI_Simple_Dialog_Optional_A; \
	UNIT func10_AI_OUT_SCALE_unit_1; \
	UNIT func10_AI_OUT_SCALE_unit_2

#define USE_FUNC10_AI_OPTIONAL_B \
	USE_FUNC10_AI_OPTIONAL_BOTH; \
	MENU func10_AI_Simple_Dialog_Optional_B; \
	UNIT func10_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC10_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func10_AI_)
#define USE_FUNC10_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func10_AI_)
#define USE_FUNC10_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func10_AI_)
#define USE_FUNC10_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func10_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC11_AI_MANDATORY_BOTH \
	BLOCK func11_AI_block; \
	COLLECTION func11_AI_BLOCK_OBJECT; \
	VARIABLE func11_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func11_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func11_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func11_AI_BLOCK_OBJECT_Class; \
	VARIABLE func11_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func11_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func11_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func11_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func11_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func11_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func11_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func11_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func11_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func11_AI_BLOCK_OBJECT_page; \
	COMMAND func11_AI_BLOCK_OBJECT_read; \
	VARIABLE func11_AI_ST_REV; \
	MENU func11_AI_ST_REV_page; \
	COMMAND func11_AI_ST_REV_read; \
	VARIABLE func11_AI_TAG_DESC; \
	MENU func11_AI_TAG_DESC_page; \
	COMMAND func11_AI_TAG_DESC_read; \
	COMMAND func11_AI_TAG_DESC_write; \
	VARIABLE func11_AI_STRATEGY; \
	MENU func11_AI_STRATEGY_page; \
	COMMAND func11_AI_STRATEGY_read; \
	COMMAND func11_AI_STRATEGY_write; \
	VARIABLE func11_AI_ALERT_KEY; \
	MENU func11_AI_ALERT_KEY_page; \
	COMMAND func11_AI_ALERT_KEY_read; \
	COMMAND func11_AI_ALERT_KEY_write; \
	VARIABLE func11_AI_TARGET_MODE; \
	MENU func11_AI_TARGET_MODE_page; \
	COMMAND func11_AI_TARGET_MODE_read; \
	COMMAND func11_AI_TARGET_MODE_write; \
	COLLECTION func11_AI_MODE_BLK; \
	VARIABLE func11_AI_MODE_BLK_Actual; \
	VARIABLE func11_AI_MODE_BLK_Permitted; \
	VARIABLE func11_AI_MODE_BLK_Normal; \
	MENU func11_AI_MODE_BLK_page; \
	COMMAND func11_AI_MODE_BLK_read; \
	COLLECTION func11_AI_ALARM_SUM; \
	VARIABLE func11_AI_ALARM_SUM_Current; \
	VARIABLE func11_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func11_AI_ALARM_SUM_Unreported; \
	VARIABLE func11_AI_ALARM_SUM_Disabled; \
	MENU func11_AI_ALARM_SUM_page; \
	COMMAND func11_AI_ALARM_SUM_read; \
	COLLECTION func11_AI_BATCH; \
	VARIABLE func11_AI_BATCH_Batch_ID; \
	VARIABLE func11_AI_BATCH_Rup; \
	VARIABLE func11_AI_BATCH_Operation; \
	VARIABLE func11_AI_BATCH_Phase; \
	MENU func11_AI_BATCH_page; \
	COMMAND func11_AI_BATCH_read; \
	COMMAND func11_AI_BATCH_write; \
	COLLECTION func11_AI_OUT; \
	VARIABLE func11_AI_OUT_Value; \
	VARIABLE func11_AI_OUT_Status_Quality; \
	VARIABLE func11_AI_OUT_Status_Limit; \
	MENU func11_AI_OUT_page; \
	COMMAND func11_AI_OUT_read; \
	COMMAND func11_AI_OUT_write; \
	COLLECTION func11_AI_PV_SCALE; \
	VARIABLE func11_AI_PV_SCALE_Upper_Value; \
	VARIABLE func11_AI_PV_SCALE_Lower_Value; \
	MENU func11_AI_PV_SCALE_page; \
	COMMAND func11_AI_PV_SCALE_read; \
	COMMAND func11_AI_PV_SCALE_write; \
	VARIABLE func11_AI_PV_FTIME; \
	MENU func11_AI_PV_FTIME_page; \
	COMMAND func11_AI_PV_FTIME_read; \
	COMMAND func11_AI_PV_FTIME_write; \
	VARIABLE func11_AI_ALARM_HYS; \
	MENU func11_AI_ALARM_HYS_page; \
	COMMAND func11_AI_ALARM_HYS_read; \
	COMMAND func11_AI_ALARM_HYS_write; \
	VARIABLE func11_AI_HI_HI_LIM; \
	MENU func11_AI_HI_HI_LIM_page; \
	COMMAND func11_AI_HI_HI_LIM_read; \
	COMMAND func11_AI_HI_HI_LIM_write; \
	VARIABLE func11_AI_HI_LIM; \
	MENU func11_AI_HI_LIM_page; \
	COMMAND func11_AI_HI_LIM_read; \
	COMMAND func11_AI_HI_LIM_write; \
	VARIABLE func11_AI_LO_LIM; \
	MENU func11_AI_LO_LIM_page; \
	COMMAND func11_AI_LO_LIM_read; \
	COMMAND func11_AI_LO_LIM_write; \
	VARIABLE func11_AI_LO_LO_LIM; \
	MENU func11_AI_LO_LO_LIM_page; \
	COMMAND func11_AI_LO_LO_LIM_read; \
	COMMAND func11_AI_LO_LO_LIM_write

#define USE_FUNC11_AI_MANDATORY_A \
	USE_FUNC11_AI_MANDATORY_BOTH; \
	MENU func11_AI_Simple_Dialog_Mandatory_A; \
	MENU func11_AI_Display_mandatory_A; \
	CHART func11_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func11_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func11_AI_Display_out_mandatory_A; \
	MENU func11_AI_Tab_s_mandatory_A; \
	MENU func11_AI_Tab_s_pv_range_mandatory_A; \
	MENU func11_AI_Tab_s_limits_mandatory_A; \
	MENU func11_AI_Tab_m_mandatory_A; \
	MENU func11_AI_Tab_m_pv_range_mandatory_A; \
	MENU func11_AI_Tab_m_limits_mandatory_A

#define USE_FUNC11_AI_MANDATORY_B \
	USE_FUNC11_AI_MANDATORY_BOTH; \
	COLLECTION func11_AI_OUT_SCALE; \
	VARIABLE func11_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func11_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func11_AI_OUT_SCALE_Units_Index; \
	VARIABLE func11_AI_OUT_SCALE_Decimal_Point; \
	MENU func11_AI_OUT_SCALE_page; \
	COMMAND func11_AI_OUT_SCALE_read; \
	COMMAND func11_AI_OUT_SCALE_write; \
	VARIABLE func11_AI_LIN_TYPE; \
	MENU func11_AI_LIN_TYPE_page; \
	COMMAND func11_AI_LIN_TYPE_read; \
	COMMAND func11_AI_LIN_TYPE_write; \
	VARIABLE func11_AI_CHANNEL; \
	MENU func11_AI_CHANNEL_page; \
	COMMAND func11_AI_CHANNEL_read; \
	COMMAND func11_AI_CHANNEL_write; \
	COLLECTION func11_AI_SIMULATE; \
	VARIABLE func11_AI_SIMULATE_Status_Quality; \
	VARIABLE func11_AI_SIMULATE_Status_Limit; \
	VARIABLE func11_AI_SIMULATE_Value; \
	VARIABLE func11_AI_SIMULATE_Enabled; \
	MENU func11_AI_SIMULATE_page; \
	COMMAND func11_AI_SIMULATE_read; \
	COMMAND func11_AI_SIMULATE_write; \
	COLLECTION func11_AI_VIEW_1; \
	MENU func11_AI_VIEW_1_page; \
	MENU func11_AI_Simple_Dialog_Mandatory_B; \
	UNIT func11_AI_OUT_SCALE_unit_1; \
	MENU func11_AI_Simulation; \
	MENU func11_AI_Simulation_input; \
	MENU func11_AI_Simulation_input_group; \
	MENU func11_AI_Simulation_output; \
	MENU func11_AI_Simulation_output_group; \
	MENU func11_AI_Display_mandatory_B; \
	CHART func11_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func11_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func11_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func11_AI_Display_out_mandatory_B; \
	MENU func11_AI_Display_in_mandatory_B; \
	MENU func11_AI_Tab_s_mandatory_B; \
	MENU func11_AI_Tab_s_pv_range_mandatory_B; \
	MENU func11_AI_Tab_s_outscale_mandatory_B; \
	MENU func11_AI_Tab_s_limits_mandatory_B; \
	MENU func11_AI_Tab_s_interface_mandatory_B; \
	MENU func11_AI_Tab_m_mandatory_B; \
	MENU func11_AI_Tab_m_pv_range_mandatory_B; \
	MENU func11_AI_Tab_m_outscale_mandatory_B; \
	MENU func11_AI_Tab_m_limits_mandatory_B

#define USE_FUNC11_AI_OPTIONAL_BOTH \
	VARIABLE func11_AI_FSAFE_TYPE; \
	MENU func11_AI_FSAFE_TYPE_page; \
	COMMAND func11_AI_FSAFE_TYPE_read; \
	COMMAND func11_AI_FSAFE_TYPE_write; \
	VARIABLE func11_AI_FSAFE_VALUE; \
	MENU func11_AI_FSAFE_VALUE_page; \
	COMMAND func11_AI_FSAFE_VALUE_read; \
	COMMAND func11_AI_FSAFE_VALUE_write; \
	COLLECTION func11_AI_HI_HI_ALM; \
	VARIABLE func11_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func11_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func11_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func11_AI_HI_HI_ALM_Subcode; \
	VARIABLE func11_AI_HI_HI_ALM_Value; \
	MENU func11_AI_HI_HI_ALM_page; \
	COMMAND func11_AI_HI_HI_ALM_read; \
	COLLECTION func11_AI_HI_ALM; \
	VARIABLE func11_AI_HI_ALM_Unacknowledged; \
	VARIABLE func11_AI_HI_ALM_Alarm_State; \
	VARIABLE func11_AI_HI_ALM_Time_Stamp; \
	VARIABLE func11_AI_HI_ALM_Subcode; \
	VARIABLE func11_AI_HI_ALM_Value; \
	MENU func11_AI_HI_ALM_page; \
	COMMAND func11_AI_HI_ALM_read; \
	COLLECTION func11_AI_LO_ALM; \
	VARIABLE func11_AI_LO_ALM_Unacknowledged; \
	VARIABLE func11_AI_LO_ALM_Alarm_State; \
	VARIABLE func11_AI_LO_ALM_Time_Stamp; \
	VARIABLE func11_AI_LO_ALM_Subcode; \
	VARIABLE func11_AI_LO_ALM_Value; \
	MENU func11_AI_LO_ALM_page; \
	COMMAND func11_AI_LO_ALM_read; \
	COLLECTION func11_AI_LO_LO_ALM; \
	VARIABLE func11_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func11_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func11_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func11_AI_LO_LO_ALM_Subcode; \
	VARIABLE func11_AI_LO_LO_ALM_Value; \
	MENU func11_AI_LO_LO_ALM_page; \
	COMMAND func11_AI_LO_LO_ALM_read; \
	VARIABLE func11_AI_OUT_UNIT_TEXT; \
	MENU func11_AI_OUT_UNIT_TEXT_page; \
	COMMAND func11_AI_OUT_UNIT_TEXT_read; \
	COMMAND func11_AI_OUT_UNIT_TEXT_write

#define USE_FUNC11_AI_OPTIONAL_A \
	USE_FUNC11_AI_OPTIONAL_BOTH; \
	COLLECTION func11_AI_OUT_SCALE; \
	VARIABLE func11_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func11_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func11_AI_OUT_SCALE_Units_Index; \
	VARIABLE func11_AI_OUT_SCALE_Decimal_Point; \
	MENU func11_AI_OUT_SCALE_page; \
	COMMAND func11_AI_OUT_SCALE_read; \
	COMMAND func11_AI_OUT_SCALE_write; \
	VARIABLE func11_AI_LIN_TYPE; \
	MENU func11_AI_LIN_TYPE_page; \
	COMMAND func11_AI_LIN_TYPE_read; \
	COMMAND func11_AI_LIN_TYPE_write; \
	VARIABLE func11_AI_CHANNEL; \
	MENU func11_AI_CHANNEL_page; \
	COMMAND func11_AI_CHANNEL_read; \
	COMMAND func11_AI_CHANNEL_write; \
	COLLECTION func11_AI_SIMULATE; \
	VARIABLE func11_AI_SIMULATE_Status_Quality; \
	VARIABLE func11_AI_SIMULATE_Status_Limit; \
	VARIABLE func11_AI_SIMULATE_Value; \
	VARIABLE func11_AI_SIMULATE_Enabled; \
	MENU func11_AI_SIMULATE_page; \
	COMMAND func11_AI_SIMULATE_read; \
	COMMAND func11_AI_SIMULATE_write; \
	COLLECTION func11_AI_VIEW_1; \
	MENU func11_AI_VIEW_1_page; \
	MENU func11_AI_Simple_Dialog_Optional_A; \
	UNIT func11_AI_OUT_SCALE_unit_1; \
	UNIT func11_AI_OUT_SCALE_unit_2

#define USE_FUNC11_AI_OPTIONAL_B \
	USE_FUNC11_AI_OPTIONAL_BOTH; \
	MENU func11_AI_Simple_Dialog_Optional_B; \
	UNIT func11_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC11_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func11_AI_)
#define USE_FUNC11_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func11_AI_)
#define USE_FUNC11_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func11_AI_)
#define USE_FUNC11_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func11_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC12_AI_MANDATORY_BOTH \
	BLOCK func12_AI_block; \
	COLLECTION func12_AI_BLOCK_OBJECT; \
	VARIABLE func12_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func12_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func12_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func12_AI_BLOCK_OBJECT_Class; \
	VARIABLE func12_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func12_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func12_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func12_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func12_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func12_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func12_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func12_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func12_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func12_AI_BLOCK_OBJECT_page; \
	COMMAND func12_AI_BLOCK_OBJECT_read; \
	VARIABLE func12_AI_ST_REV; \
	MENU func12_AI_ST_REV_page; \
	COMMAND func12_AI_ST_REV_read; \
	VARIABLE func12_AI_TAG_DESC; \
	MENU func12_AI_TAG_DESC_page; \
	COMMAND func12_AI_TAG_DESC_read; \
	COMMAND func12_AI_TAG_DESC_write; \
	VARIABLE func12_AI_STRATEGY; \
	MENU func12_AI_STRATEGY_page; \
	COMMAND func12_AI_STRATEGY_read; \
	COMMAND func12_AI_STRATEGY_write; \
	VARIABLE func12_AI_ALERT_KEY; \
	MENU func12_AI_ALERT_KEY_page; \
	COMMAND func12_AI_ALERT_KEY_read; \
	COMMAND func12_AI_ALERT_KEY_write; \
	VARIABLE func12_AI_TARGET_MODE; \
	MENU func12_AI_TARGET_MODE_page; \
	COMMAND func12_AI_TARGET_MODE_read; \
	COMMAND func12_AI_TARGET_MODE_write; \
	COLLECTION func12_AI_MODE_BLK; \
	VARIABLE func12_AI_MODE_BLK_Actual; \
	VARIABLE func12_AI_MODE_BLK_Permitted; \
	VARIABLE func12_AI_MODE_BLK_Normal; \
	MENU func12_AI_MODE_BLK_page; \
	COMMAND func12_AI_MODE_BLK_read; \
	COLLECTION func12_AI_ALARM_SUM; \
	VARIABLE func12_AI_ALARM_SUM_Current; \
	VARIABLE func12_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func12_AI_ALARM_SUM_Unreported; \
	VARIABLE func12_AI_ALARM_SUM_Disabled; \
	MENU func12_AI_ALARM_SUM_page; \
	COMMAND func12_AI_ALARM_SUM_read; \
	COLLECTION func12_AI_BATCH; \
	VARIABLE func12_AI_BATCH_Batch_ID; \
	VARIABLE func12_AI_BATCH_Rup; \
	VARIABLE func12_AI_BATCH_Operation; \
	VARIABLE func12_AI_BATCH_Phase; \
	MENU func12_AI_BATCH_page; \
	COMMAND func12_AI_BATCH_read; \
	COMMAND func12_AI_BATCH_write; \
	COLLECTION func12_AI_OUT; \
	VARIABLE func12_AI_OUT_Value; \
	VARIABLE func12_AI_OUT_Status_Quality; \
	VARIABLE func12_AI_OUT_Status_Limit; \
	MENU func12_AI_OUT_page; \
	COMMAND func12_AI_OUT_read; \
	COMMAND func12_AI_OUT_write; \
	COLLECTION func12_AI_PV_SCALE; \
	VARIABLE func12_AI_PV_SCALE_Upper_Value; \
	VARIABLE func12_AI_PV_SCALE_Lower_Value; \
	MENU func12_AI_PV_SCALE_page; \
	COMMAND func12_AI_PV_SCALE_read; \
	COMMAND func12_AI_PV_SCALE_write; \
	VARIABLE func12_AI_PV_FTIME; \
	MENU func12_AI_PV_FTIME_page; \
	COMMAND func12_AI_PV_FTIME_read; \
	COMMAND func12_AI_PV_FTIME_write; \
	VARIABLE func12_AI_ALARM_HYS; \
	MENU func12_AI_ALARM_HYS_page; \
	COMMAND func12_AI_ALARM_HYS_read; \
	COMMAND func12_AI_ALARM_HYS_write; \
	VARIABLE func12_AI_HI_HI_LIM; \
	MENU func12_AI_HI_HI_LIM_page; \
	COMMAND func12_AI_HI_HI_LIM_read; \
	COMMAND func12_AI_HI_HI_LIM_write; \
	VARIABLE func12_AI_HI_LIM; \
	MENU func12_AI_HI_LIM_page; \
	COMMAND func12_AI_HI_LIM_read; \
	COMMAND func12_AI_HI_LIM_write; \
	VARIABLE func12_AI_LO_LIM; \
	MENU func12_AI_LO_LIM_page; \
	COMMAND func12_AI_LO_LIM_read; \
	COMMAND func12_AI_LO_LIM_write; \
	VARIABLE func12_AI_LO_LO_LIM; \
	MENU func12_AI_LO_LO_LIM_page; \
	COMMAND func12_AI_LO_LO_LIM_read; \
	COMMAND func12_AI_LO_LO_LIM_write

#define USE_FUNC12_AI_MANDATORY_A \
	USE_FUNC12_AI_MANDATORY_BOTH; \
	MENU func12_AI_Simple_Dialog_Mandatory_A; \
	MENU func12_AI_Display_mandatory_A; \
	CHART func12_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func12_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func12_AI_Display_out_mandatory_A; \
	MENU func12_AI_Tab_s_mandatory_A; \
	MENU func12_AI_Tab_s_pv_range_mandatory_A; \
	MENU func12_AI_Tab_s_limits_mandatory_A; \
	MENU func12_AI_Tab_m_mandatory_A; \
	MENU func12_AI_Tab_m_pv_range_mandatory_A; \
	MENU func12_AI_Tab_m_limits_mandatory_A

#define USE_FUNC12_AI_MANDATORY_B \
	USE_FUNC12_AI_MANDATORY_BOTH; \
	COLLECTION func12_AI_OUT_SCALE; \
	VARIABLE func12_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func12_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func12_AI_OUT_SCALE_Units_Index; \
	VARIABLE func12_AI_OUT_SCALE_Decimal_Point; \
	MENU func12_AI_OUT_SCALE_page; \
	COMMAND func12_AI_OUT_SCALE_read; \
	COMMAND func12_AI_OUT_SCALE_write; \
	VARIABLE func12_AI_LIN_TYPE; \
	MENU func12_AI_LIN_TYPE_page; \
	COMMAND func12_AI_LIN_TYPE_read; \
	COMMAND func12_AI_LIN_TYPE_write; \
	VARIABLE func12_AI_CHANNEL; \
	MENU func12_AI_CHANNEL_page; \
	COMMAND func12_AI_CHANNEL_read; \
	COMMAND func12_AI_CHANNEL_write; \
	COLLECTION func12_AI_SIMULATE; \
	VARIABLE func12_AI_SIMULATE_Status_Quality; \
	VARIABLE func12_AI_SIMULATE_Status_Limit; \
	VARIABLE func12_AI_SIMULATE_Value; \
	VARIABLE func12_AI_SIMULATE_Enabled; \
	MENU func12_AI_SIMULATE_page; \
	COMMAND func12_AI_SIMULATE_read; \
	COMMAND func12_AI_SIMULATE_write; \
	COLLECTION func12_AI_VIEW_1; \
	MENU func12_AI_VIEW_1_page; \
	MENU func12_AI_Simple_Dialog_Mandatory_B; \
	UNIT func12_AI_OUT_SCALE_unit_1; \
	MENU func12_AI_Simulation; \
	MENU func12_AI_Simulation_input; \
	MENU func12_AI_Simulation_input_group; \
	MENU func12_AI_Simulation_output; \
	MENU func12_AI_Simulation_output_group; \
	MENU func12_AI_Display_mandatory_B; \
	CHART func12_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func12_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func12_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func12_AI_Display_out_mandatory_B; \
	MENU func12_AI_Display_in_mandatory_B; \
	MENU func12_AI_Tab_s_mandatory_B; \
	MENU func12_AI_Tab_s_pv_range_mandatory_B; \
	MENU func12_AI_Tab_s_outscale_mandatory_B; \
	MENU func12_AI_Tab_s_limits_mandatory_B; \
	MENU func12_AI_Tab_s_interface_mandatory_B; \
	MENU func12_AI_Tab_m_mandatory_B; \
	MENU func12_AI_Tab_m_pv_range_mandatory_B; \
	MENU func12_AI_Tab_m_outscale_mandatory_B; \
	MENU func12_AI_Tab_m_limits_mandatory_B

#define USE_FUNC12_AI_OPTIONAL_BOTH \
	VARIABLE func12_AI_FSAFE_TYPE; \
	MENU func12_AI_FSAFE_TYPE_page; \
	COMMAND func12_AI_FSAFE_TYPE_read; \
	COMMAND func12_AI_FSAFE_TYPE_write; \
	VARIABLE func12_AI_FSAFE_VALUE; \
	MENU func12_AI_FSAFE_VALUE_page; \
	COMMAND func12_AI_FSAFE_VALUE_read; \
	COMMAND func12_AI_FSAFE_VALUE_write; \
	COLLECTION func12_AI_HI_HI_ALM; \
	VARIABLE func12_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func12_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func12_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func12_AI_HI_HI_ALM_Subcode; \
	VARIABLE func12_AI_HI_HI_ALM_Value; \
	MENU func12_AI_HI_HI_ALM_page; \
	COMMAND func12_AI_HI_HI_ALM_read; \
	COLLECTION func12_AI_HI_ALM; \
	VARIABLE func12_AI_HI_ALM_Unacknowledged; \
	VARIABLE func12_AI_HI_ALM_Alarm_State; \
	VARIABLE func12_AI_HI_ALM_Time_Stamp; \
	VARIABLE func12_AI_HI_ALM_Subcode; \
	VARIABLE func12_AI_HI_ALM_Value; \
	MENU func12_AI_HI_ALM_page; \
	COMMAND func12_AI_HI_ALM_read; \
	COLLECTION func12_AI_LO_ALM; \
	VARIABLE func12_AI_LO_ALM_Unacknowledged; \
	VARIABLE func12_AI_LO_ALM_Alarm_State; \
	VARIABLE func12_AI_LO_ALM_Time_Stamp; \
	VARIABLE func12_AI_LO_ALM_Subcode; \
	VARIABLE func12_AI_LO_ALM_Value; \
	MENU func12_AI_LO_ALM_page; \
	COMMAND func12_AI_LO_ALM_read; \
	COLLECTION func12_AI_LO_LO_ALM; \
	VARIABLE func12_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func12_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func12_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func12_AI_LO_LO_ALM_Subcode; \
	VARIABLE func12_AI_LO_LO_ALM_Value; \
	MENU func12_AI_LO_LO_ALM_page; \
	COMMAND func12_AI_LO_LO_ALM_read; \
	VARIABLE func12_AI_OUT_UNIT_TEXT; \
	MENU func12_AI_OUT_UNIT_TEXT_page; \
	COMMAND func12_AI_OUT_UNIT_TEXT_read; \
	COMMAND func12_AI_OUT_UNIT_TEXT_write

#define USE_FUNC12_AI_OPTIONAL_A \
	USE_FUNC12_AI_OPTIONAL_BOTH; \
	COLLECTION func12_AI_OUT_SCALE; \
	VARIABLE func12_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func12_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func12_AI_OUT_SCALE_Units_Index; \
	VARIABLE func12_AI_OUT_SCALE_Decimal_Point; \
	MENU func12_AI_OUT_SCALE_page; \
	COMMAND func12_AI_OUT_SCALE_read; \
	COMMAND func12_AI_OUT_SCALE_write; \
	VARIABLE func12_AI_LIN_TYPE; \
	MENU func12_AI_LIN_TYPE_page; \
	COMMAND func12_AI_LIN_TYPE_read; \
	COMMAND func12_AI_LIN_TYPE_write; \
	VARIABLE func12_AI_CHANNEL; \
	MENU func12_AI_CHANNEL_page; \
	COMMAND func12_AI_CHANNEL_read; \
	COMMAND func12_AI_CHANNEL_write; \
	COLLECTION func12_AI_SIMULATE; \
	VARIABLE func12_AI_SIMULATE_Status_Quality; \
	VARIABLE func12_AI_SIMULATE_Status_Limit; \
	VARIABLE func12_AI_SIMULATE_Value; \
	VARIABLE func12_AI_SIMULATE_Enabled; \
	MENU func12_AI_SIMULATE_page; \
	COMMAND func12_AI_SIMULATE_read; \
	COMMAND func12_AI_SIMULATE_write; \
	COLLECTION func12_AI_VIEW_1; \
	MENU func12_AI_VIEW_1_page; \
	MENU func12_AI_Simple_Dialog_Optional_A; \
	UNIT func12_AI_OUT_SCALE_unit_1; \
	UNIT func12_AI_OUT_SCALE_unit_2

#define USE_FUNC12_AI_OPTIONAL_B \
	USE_FUNC12_AI_OPTIONAL_BOTH; \
	MENU func12_AI_Simple_Dialog_Optional_B; \
	UNIT func12_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC12_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func12_AI_)
#define USE_FUNC12_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func12_AI_)
#define USE_FUNC12_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func12_AI_)
#define USE_FUNC12_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func12_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC13_AI_MANDATORY_BOTH \
	BLOCK func13_AI_block; \
	COLLECTION func13_AI_BLOCK_OBJECT; \
	VARIABLE func13_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func13_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func13_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func13_AI_BLOCK_OBJECT_Class; \
	VARIABLE func13_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func13_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func13_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func13_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func13_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func13_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func13_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func13_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func13_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func13_AI_BLOCK_OBJECT_page; \
	COMMAND func13_AI_BLOCK_OBJECT_read; \
	VARIABLE func13_AI_ST_REV; \
	MENU func13_AI_ST_REV_page; \
	COMMAND func13_AI_ST_REV_read; \
	VARIABLE func13_AI_TAG_DESC; \
	MENU func13_AI_TAG_DESC_page; \
	COMMAND func13_AI_TAG_DESC_read; \
	COMMAND func13_AI_TAG_DESC_write; \
	VARIABLE func13_AI_STRATEGY; \
	MENU func13_AI_STRATEGY_page; \
	COMMAND func13_AI_STRATEGY_read; \
	COMMAND func13_AI_STRATEGY_write; \
	VARIABLE func13_AI_ALERT_KEY; \
	MENU func13_AI_ALERT_KEY_page; \
	COMMAND func13_AI_ALERT_KEY_read; \
	COMMAND func13_AI_ALERT_KEY_write; \
	VARIABLE func13_AI_TARGET_MODE; \
	MENU func13_AI_TARGET_MODE_page; \
	COMMAND func13_AI_TARGET_MODE_read; \
	COMMAND func13_AI_TARGET_MODE_write; \
	COLLECTION func13_AI_MODE_BLK; \
	VARIABLE func13_AI_MODE_BLK_Actual; \
	VARIABLE func13_AI_MODE_BLK_Permitted; \
	VARIABLE func13_AI_MODE_BLK_Normal; \
	MENU func13_AI_MODE_BLK_page; \
	COMMAND func13_AI_MODE_BLK_read; \
	COLLECTION func13_AI_ALARM_SUM; \
	VARIABLE func13_AI_ALARM_SUM_Current; \
	VARIABLE func13_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func13_AI_ALARM_SUM_Unreported; \
	VARIABLE func13_AI_ALARM_SUM_Disabled; \
	MENU func13_AI_ALARM_SUM_page; \
	COMMAND func13_AI_ALARM_SUM_read; \
	COLLECTION func13_AI_BATCH; \
	VARIABLE func13_AI_BATCH_Batch_ID; \
	VARIABLE func13_AI_BATCH_Rup; \
	VARIABLE func13_AI_BATCH_Operation; \
	VARIABLE func13_AI_BATCH_Phase; \
	MENU func13_AI_BATCH_page; \
	COMMAND func13_AI_BATCH_read; \
	COMMAND func13_AI_BATCH_write; \
	COLLECTION func13_AI_OUT; \
	VARIABLE func13_AI_OUT_Value; \
	VARIABLE func13_AI_OUT_Status_Quality; \
	VARIABLE func13_AI_OUT_Status_Limit; \
	MENU func13_AI_OUT_page; \
	COMMAND func13_AI_OUT_read; \
	COMMAND func13_AI_OUT_write; \
	COLLECTION func13_AI_PV_SCALE; \
	VARIABLE func13_AI_PV_SCALE_Upper_Value; \
	VARIABLE func13_AI_PV_SCALE_Lower_Value; \
	MENU func13_AI_PV_SCALE_page; \
	COMMAND func13_AI_PV_SCALE_read; \
	COMMAND func13_AI_PV_SCALE_write; \
	VARIABLE func13_AI_PV_FTIME; \
	MENU func13_AI_PV_FTIME_page; \
	COMMAND func13_AI_PV_FTIME_read; \
	COMMAND func13_AI_PV_FTIME_write; \
	VARIABLE func13_AI_ALARM_HYS; \
	MENU func13_AI_ALARM_HYS_page; \
	COMMAND func13_AI_ALARM_HYS_read; \
	COMMAND func13_AI_ALARM_HYS_write; \
	VARIABLE func13_AI_HI_HI_LIM; \
	MENU func13_AI_HI_HI_LIM_page; \
	COMMAND func13_AI_HI_HI_LIM_read; \
	COMMAND func13_AI_HI_HI_LIM_write; \
	VARIABLE func13_AI_HI_LIM; \
	MENU func13_AI_HI_LIM_page; \
	COMMAND func13_AI_HI_LIM_read; \
	COMMAND func13_AI_HI_LIM_write; \
	VARIABLE func13_AI_LO_LIM; \
	MENU func13_AI_LO_LIM_page; \
	COMMAND func13_AI_LO_LIM_read; \
	COMMAND func13_AI_LO_LIM_write; \
	VARIABLE func13_AI_LO_LO_LIM; \
	MENU func13_AI_LO_LO_LIM_page; \
	COMMAND func13_AI_LO_LO_LIM_read; \
	COMMAND func13_AI_LO_LO_LIM_write

#define USE_FUNC13_AI_MANDATORY_A \
	USE_FUNC13_AI_MANDATORY_BOTH; \
	MENU func13_AI_Simple_Dialog_Mandatory_A; \
	MENU func13_AI_Display_mandatory_A; \
	CHART func13_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func13_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func13_AI_Display_out_mandatory_A; \
	MENU func13_AI_Tab_s_mandatory_A; \
	MENU func13_AI_Tab_s_pv_range_mandatory_A; \
	MENU func13_AI_Tab_s_limits_mandatory_A; \
	MENU func13_AI_Tab_m_mandatory_A; \
	MENU func13_AI_Tab_m_pv_range_mandatory_A; \
	MENU func13_AI_Tab_m_limits_mandatory_A

#define USE_FUNC13_AI_MANDATORY_B \
	USE_FUNC13_AI_MANDATORY_BOTH; \
	COLLECTION func13_AI_OUT_SCALE; \
	VARIABLE func13_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func13_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func13_AI_OUT_SCALE_Units_Index; \
	VARIABLE func13_AI_OUT_SCALE_Decimal_Point; \
	MENU func13_AI_OUT_SCALE_page; \
	COMMAND func13_AI_OUT_SCALE_read; \
	COMMAND func13_AI_OUT_SCALE_write; \
	VARIABLE func13_AI_LIN_TYPE; \
	MENU func13_AI_LIN_TYPE_page; \
	COMMAND func13_AI_LIN_TYPE_read; \
	COMMAND func13_AI_LIN_TYPE_write; \
	VARIABLE func13_AI_CHANNEL; \
	MENU func13_AI_CHANNEL_page; \
	COMMAND func13_AI_CHANNEL_read; \
	COMMAND func13_AI_CHANNEL_write; \
	COLLECTION func13_AI_SIMULATE; \
	VARIABLE func13_AI_SIMULATE_Status_Quality; \
	VARIABLE func13_AI_SIMULATE_Status_Limit; \
	VARIABLE func13_AI_SIMULATE_Value; \
	VARIABLE func13_AI_SIMULATE_Enabled; \
	MENU func13_AI_SIMULATE_page; \
	COMMAND func13_AI_SIMULATE_read; \
	COMMAND func13_AI_SIMULATE_write; \
	COLLECTION func13_AI_VIEW_1; \
	MENU func13_AI_VIEW_1_page; \
	MENU func13_AI_Simple_Dialog_Mandatory_B; \
	UNIT func13_AI_OUT_SCALE_unit_1; \
	MENU func13_AI_Simulation; \
	MENU func13_AI_Simulation_input; \
	MENU func13_AI_Simulation_input_group; \
	MENU func13_AI_Simulation_output; \
	MENU func13_AI_Simulation_output_group; \
	MENU func13_AI_Display_mandatory_B; \
	CHART func13_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func13_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func13_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func13_AI_Display_out_mandatory_B; \
	MENU func13_AI_Display_in_mandatory_B; \
	MENU func13_AI_Tab_s_mandatory_B; \
	MENU func13_AI_Tab_s_pv_range_mandatory_B; \
	MENU func13_AI_Tab_s_outscale_mandatory_B; \
	MENU func13_AI_Tab_s_limits_mandatory_B; \
	MENU func13_AI_Tab_s_interface_mandatory_B; \
	MENU func13_AI_Tab_m_mandatory_B; \
	MENU func13_AI_Tab_m_pv_range_mandatory_B; \
	MENU func13_AI_Tab_m_outscale_mandatory_B; \
	MENU func13_AI_Tab_m_limits_mandatory_B

#define USE_FUNC13_AI_OPTIONAL_BOTH \
	VARIABLE func13_AI_FSAFE_TYPE; \
	MENU func13_AI_FSAFE_TYPE_page; \
	COMMAND func13_AI_FSAFE_TYPE_read; \
	COMMAND func13_AI_FSAFE_TYPE_write; \
	VARIABLE func13_AI_FSAFE_VALUE; \
	MENU func13_AI_FSAFE_VALUE_page; \
	COMMAND func13_AI_FSAFE_VALUE_read; \
	COMMAND func13_AI_FSAFE_VALUE_write; \
	COLLECTION func13_AI_HI_HI_ALM; \
	VARIABLE func13_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func13_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func13_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func13_AI_HI_HI_ALM_Subcode; \
	VARIABLE func13_AI_HI_HI_ALM_Value; \
	MENU func13_AI_HI_HI_ALM_page; \
	COMMAND func13_AI_HI_HI_ALM_read; \
	COLLECTION func13_AI_HI_ALM; \
	VARIABLE func13_AI_HI_ALM_Unacknowledged; \
	VARIABLE func13_AI_HI_ALM_Alarm_State; \
	VARIABLE func13_AI_HI_ALM_Time_Stamp; \
	VARIABLE func13_AI_HI_ALM_Subcode; \
	VARIABLE func13_AI_HI_ALM_Value; \
	MENU func13_AI_HI_ALM_page; \
	COMMAND func13_AI_HI_ALM_read; \
	COLLECTION func13_AI_LO_ALM; \
	VARIABLE func13_AI_LO_ALM_Unacknowledged; \
	VARIABLE func13_AI_LO_ALM_Alarm_State; \
	VARIABLE func13_AI_LO_ALM_Time_Stamp; \
	VARIABLE func13_AI_LO_ALM_Subcode; \
	VARIABLE func13_AI_LO_ALM_Value; \
	MENU func13_AI_LO_ALM_page; \
	COMMAND func13_AI_LO_ALM_read; \
	COLLECTION func13_AI_LO_LO_ALM; \
	VARIABLE func13_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func13_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func13_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func13_AI_LO_LO_ALM_Subcode; \
	VARIABLE func13_AI_LO_LO_ALM_Value; \
	MENU func13_AI_LO_LO_ALM_page; \
	COMMAND func13_AI_LO_LO_ALM_read; \
	VARIABLE func13_AI_OUT_UNIT_TEXT; \
	MENU func13_AI_OUT_UNIT_TEXT_page; \
	COMMAND func13_AI_OUT_UNIT_TEXT_read; \
	COMMAND func13_AI_OUT_UNIT_TEXT_write

#define USE_FUNC13_AI_OPTIONAL_A \
	USE_FUNC13_AI_OPTIONAL_BOTH; \
	COLLECTION func13_AI_OUT_SCALE; \
	VARIABLE func13_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func13_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func13_AI_OUT_SCALE_Units_Index; \
	VARIABLE func13_AI_OUT_SCALE_Decimal_Point; \
	MENU func13_AI_OUT_SCALE_page; \
	COMMAND func13_AI_OUT_SCALE_read; \
	COMMAND func13_AI_OUT_SCALE_write; \
	VARIABLE func13_AI_LIN_TYPE; \
	MENU func13_AI_LIN_TYPE_page; \
	COMMAND func13_AI_LIN_TYPE_read; \
	COMMAND func13_AI_LIN_TYPE_write; \
	VARIABLE func13_AI_CHANNEL; \
	MENU func13_AI_CHANNEL_page; \
	COMMAND func13_AI_CHANNEL_read; \
	COMMAND func13_AI_CHANNEL_write; \
	COLLECTION func13_AI_SIMULATE; \
	VARIABLE func13_AI_SIMULATE_Status_Quality; \
	VARIABLE func13_AI_SIMULATE_Status_Limit; \
	VARIABLE func13_AI_SIMULATE_Value; \
	VARIABLE func13_AI_SIMULATE_Enabled; \
	MENU func13_AI_SIMULATE_page; \
	COMMAND func13_AI_SIMULATE_read; \
	COMMAND func13_AI_SIMULATE_write; \
	COLLECTION func13_AI_VIEW_1; \
	MENU func13_AI_VIEW_1_page; \
	MENU func13_AI_Simple_Dialog_Optional_A; \
	UNIT func13_AI_OUT_SCALE_unit_1; \
	UNIT func13_AI_OUT_SCALE_unit_2

#define USE_FUNC13_AI_OPTIONAL_B \
	USE_FUNC13_AI_OPTIONAL_BOTH; \
	MENU func13_AI_Simple_Dialog_Optional_B; \
	UNIT func13_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC13_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func13_AI_)
#define USE_FUNC13_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func13_AI_)
#define USE_FUNC13_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func13_AI_)
#define USE_FUNC13_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func13_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC14_AI_MANDATORY_BOTH \
	BLOCK func14_AI_block; \
	COLLECTION func14_AI_BLOCK_OBJECT; \
	VARIABLE func14_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func14_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func14_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func14_AI_BLOCK_OBJECT_Class; \
	VARIABLE func14_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func14_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func14_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func14_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func14_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func14_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func14_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func14_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func14_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func14_AI_BLOCK_OBJECT_page; \
	COMMAND func14_AI_BLOCK_OBJECT_read; \
	VARIABLE func14_AI_ST_REV; \
	MENU func14_AI_ST_REV_page; \
	COMMAND func14_AI_ST_REV_read; \
	VARIABLE func14_AI_TAG_DESC; \
	MENU func14_AI_TAG_DESC_page; \
	COMMAND func14_AI_TAG_DESC_read; \
	COMMAND func14_AI_TAG_DESC_write; \
	VARIABLE func14_AI_STRATEGY; \
	MENU func14_AI_STRATEGY_page; \
	COMMAND func14_AI_STRATEGY_read; \
	COMMAND func14_AI_STRATEGY_write; \
	VARIABLE func14_AI_ALERT_KEY; \
	MENU func14_AI_ALERT_KEY_page; \
	COMMAND func14_AI_ALERT_KEY_read; \
	COMMAND func14_AI_ALERT_KEY_write; \
	VARIABLE func14_AI_TARGET_MODE; \
	MENU func14_AI_TARGET_MODE_page; \
	COMMAND func14_AI_TARGET_MODE_read; \
	COMMAND func14_AI_TARGET_MODE_write; \
	COLLECTION func14_AI_MODE_BLK; \
	VARIABLE func14_AI_MODE_BLK_Actual; \
	VARIABLE func14_AI_MODE_BLK_Permitted; \
	VARIABLE func14_AI_MODE_BLK_Normal; \
	MENU func14_AI_MODE_BLK_page; \
	COMMAND func14_AI_MODE_BLK_read; \
	COLLECTION func14_AI_ALARM_SUM; \
	VARIABLE func14_AI_ALARM_SUM_Current; \
	VARIABLE func14_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func14_AI_ALARM_SUM_Unreported; \
	VARIABLE func14_AI_ALARM_SUM_Disabled; \
	MENU func14_AI_ALARM_SUM_page; \
	COMMAND func14_AI_ALARM_SUM_read; \
	COLLECTION func14_AI_BATCH; \
	VARIABLE func14_AI_BATCH_Batch_ID; \
	VARIABLE func14_AI_BATCH_Rup; \
	VARIABLE func14_AI_BATCH_Operation; \
	VARIABLE func14_AI_BATCH_Phase; \
	MENU func14_AI_BATCH_page; \
	COMMAND func14_AI_BATCH_read; \
	COMMAND func14_AI_BATCH_write; \
	COLLECTION func14_AI_OUT; \
	VARIABLE func14_AI_OUT_Value; \
	VARIABLE func14_AI_OUT_Status_Quality; \
	VARIABLE func14_AI_OUT_Status_Limit; \
	MENU func14_AI_OUT_page; \
	COMMAND func14_AI_OUT_read; \
	COMMAND func14_AI_OUT_write; \
	COLLECTION func14_AI_PV_SCALE; \
	VARIABLE func14_AI_PV_SCALE_Upper_Value; \
	VARIABLE func14_AI_PV_SCALE_Lower_Value; \
	MENU func14_AI_PV_SCALE_page; \
	COMMAND func14_AI_PV_SCALE_read; \
	COMMAND func14_AI_PV_SCALE_write; \
	VARIABLE func14_AI_PV_FTIME; \
	MENU func14_AI_PV_FTIME_page; \
	COMMAND func14_AI_PV_FTIME_read; \
	COMMAND func14_AI_PV_FTIME_write; \
	VARIABLE func14_AI_ALARM_HYS; \
	MENU func14_AI_ALARM_HYS_page; \
	COMMAND func14_AI_ALARM_HYS_read; \
	COMMAND func14_AI_ALARM_HYS_write; \
	VARIABLE func14_AI_HI_HI_LIM; \
	MENU func14_AI_HI_HI_LIM_page; \
	COMMAND func14_AI_HI_HI_LIM_read; \
	COMMAND func14_AI_HI_HI_LIM_write; \
	VARIABLE func14_AI_HI_LIM; \
	MENU func14_AI_HI_LIM_page; \
	COMMAND func14_AI_HI_LIM_read; \
	COMMAND func14_AI_HI_LIM_write; \
	VARIABLE func14_AI_LO_LIM; \
	MENU func14_AI_LO_LIM_page; \
	COMMAND func14_AI_LO_LIM_read; \
	COMMAND func14_AI_LO_LIM_write; \
	VARIABLE func14_AI_LO_LO_LIM; \
	MENU func14_AI_LO_LO_LIM_page; \
	COMMAND func14_AI_LO_LO_LIM_read; \
	COMMAND func14_AI_LO_LO_LIM_write

#define USE_FUNC14_AI_MANDATORY_A \
	USE_FUNC14_AI_MANDATORY_BOTH; \
	MENU func14_AI_Simple_Dialog_Mandatory_A; \
	MENU func14_AI_Display_mandatory_A; \
	CHART func14_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func14_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func14_AI_Display_out_mandatory_A; \
	MENU func14_AI_Tab_s_mandatory_A; \
	MENU func14_AI_Tab_s_pv_range_mandatory_A; \
	MENU func14_AI_Tab_s_limits_mandatory_A; \
	MENU func14_AI_Tab_m_mandatory_A; \
	MENU func14_AI_Tab_m_pv_range_mandatory_A; \
	MENU func14_AI_Tab_m_limits_mandatory_A

#define USE_FUNC14_AI_MANDATORY_B \
	USE_FUNC14_AI_MANDATORY_BOTH; \
	COLLECTION func14_AI_OUT_SCALE; \
	VARIABLE func14_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func14_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func14_AI_OUT_SCALE_Units_Index; \
	VARIABLE func14_AI_OUT_SCALE_Decimal_Point; \
	MENU func14_AI_OUT_SCALE_page; \
	COMMAND func14_AI_OUT_SCALE_read; \
	COMMAND func14_AI_OUT_SCALE_write; \
	VARIABLE func14_AI_LIN_TYPE; \
	MENU func14_AI_LIN_TYPE_page; \
	COMMAND func14_AI_LIN_TYPE_read; \
	COMMAND func14_AI_LIN_TYPE_write; \
	VARIABLE func14_AI_CHANNEL; \
	MENU func14_AI_CHANNEL_page; \
	COMMAND func14_AI_CHANNEL_read; \
	COMMAND func14_AI_CHANNEL_write; \
	COLLECTION func14_AI_SIMULATE; \
	VARIABLE func14_AI_SIMULATE_Status_Quality; \
	VARIABLE func14_AI_SIMULATE_Status_Limit; \
	VARIABLE func14_AI_SIMULATE_Value; \
	VARIABLE func14_AI_SIMULATE_Enabled; \
	MENU func14_AI_SIMULATE_page; \
	COMMAND func14_AI_SIMULATE_read; \
	COMMAND func14_AI_SIMULATE_write; \
	COLLECTION func14_AI_VIEW_1; \
	MENU func14_AI_VIEW_1_page; \
	MENU func14_AI_Simple_Dialog_Mandatory_B; \
	UNIT func14_AI_OUT_SCALE_unit_1; \
	MENU func14_AI_Simulation; \
	MENU func14_AI_Simulation_input; \
	MENU func14_AI_Simulation_input_group; \
	MENU func14_AI_Simulation_output; \
	MENU func14_AI_Simulation_output_group; \
	MENU func14_AI_Display_mandatory_B; \
	CHART func14_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func14_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func14_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func14_AI_Display_out_mandatory_B; \
	MENU func14_AI_Display_in_mandatory_B; \
	MENU func14_AI_Tab_s_mandatory_B; \
	MENU func14_AI_Tab_s_pv_range_mandatory_B; \
	MENU func14_AI_Tab_s_outscale_mandatory_B; \
	MENU func14_AI_Tab_s_limits_mandatory_B; \
	MENU func14_AI_Tab_s_interface_mandatory_B; \
	MENU func14_AI_Tab_m_mandatory_B; \
	MENU func14_AI_Tab_m_pv_range_mandatory_B; \
	MENU func14_AI_Tab_m_outscale_mandatory_B; \
	MENU func14_AI_Tab_m_limits_mandatory_B

#define USE_FUNC14_AI_OPTIONAL_BOTH \
	VARIABLE func14_AI_FSAFE_TYPE; \
	MENU func14_AI_FSAFE_TYPE_page; \
	COMMAND func14_AI_FSAFE_TYPE_read; \
	COMMAND func14_AI_FSAFE_TYPE_write; \
	VARIABLE func14_AI_FSAFE_VALUE; \
	MENU func14_AI_FSAFE_VALUE_page; \
	COMMAND func14_AI_FSAFE_VALUE_read; \
	COMMAND func14_AI_FSAFE_VALUE_write; \
	COLLECTION func14_AI_HI_HI_ALM; \
	VARIABLE func14_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func14_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func14_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func14_AI_HI_HI_ALM_Subcode; \
	VARIABLE func14_AI_HI_HI_ALM_Value; \
	MENU func14_AI_HI_HI_ALM_page; \
	COMMAND func14_AI_HI_HI_ALM_read; \
	COLLECTION func14_AI_HI_ALM; \
	VARIABLE func14_AI_HI_ALM_Unacknowledged; \
	VARIABLE func14_AI_HI_ALM_Alarm_State; \
	VARIABLE func14_AI_HI_ALM_Time_Stamp; \
	VARIABLE func14_AI_HI_ALM_Subcode; \
	VARIABLE func14_AI_HI_ALM_Value; \
	MENU func14_AI_HI_ALM_page; \
	COMMAND func14_AI_HI_ALM_read; \
	COLLECTION func14_AI_LO_ALM; \
	VARIABLE func14_AI_LO_ALM_Unacknowledged; \
	VARIABLE func14_AI_LO_ALM_Alarm_State; \
	VARIABLE func14_AI_LO_ALM_Time_Stamp; \
	VARIABLE func14_AI_LO_ALM_Subcode; \
	VARIABLE func14_AI_LO_ALM_Value; \
	MENU func14_AI_LO_ALM_page; \
	COMMAND func14_AI_LO_ALM_read; \
	COLLECTION func14_AI_LO_LO_ALM; \
	VARIABLE func14_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func14_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func14_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func14_AI_LO_LO_ALM_Subcode; \
	VARIABLE func14_AI_LO_LO_ALM_Value; \
	MENU func14_AI_LO_LO_ALM_page; \
	COMMAND func14_AI_LO_LO_ALM_read; \
	VARIABLE func14_AI_OUT_UNIT_TEXT; \
	MENU func14_AI_OUT_UNIT_TEXT_page; \
	COMMAND func14_AI_OUT_UNIT_TEXT_read; \
	COMMAND func14_AI_OUT_UNIT_TEXT_write

#define USE_FUNC14_AI_OPTIONAL_A \
	USE_FUNC14_AI_OPTIONAL_BOTH; \
	COLLECTION func14_AI_OUT_SCALE; \
	VARIABLE func14_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func14_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func14_AI_OUT_SCALE_Units_Index; \
	VARIABLE func14_AI_OUT_SCALE_Decimal_Point; \
	MENU func14_AI_OUT_SCALE_page; \
	COMMAND func14_AI_OUT_SCALE_read; \
	COMMAND func14_AI_OUT_SCALE_write; \
	VARIABLE func14_AI_LIN_TYPE; \
	MENU func14_AI_LIN_TYPE_page; \
	COMMAND func14_AI_LIN_TYPE_read; \
	COMMAND func14_AI_LIN_TYPE_write; \
	VARIABLE func14_AI_CHANNEL; \
	MENU func14_AI_CHANNEL_page; \
	COMMAND func14_AI_CHANNEL_read; \
	COMMAND func14_AI_CHANNEL_write; \
	COLLECTION func14_AI_SIMULATE; \
	VARIABLE func14_AI_SIMULATE_Status_Quality; \
	VARIABLE func14_AI_SIMULATE_Status_Limit; \
	VARIABLE func14_AI_SIMULATE_Value; \
	VARIABLE func14_AI_SIMULATE_Enabled; \
	MENU func14_AI_SIMULATE_page; \
	COMMAND func14_AI_SIMULATE_read; \
	COMMAND func14_AI_SIMULATE_write; \
	COLLECTION func14_AI_VIEW_1; \
	MENU func14_AI_VIEW_1_page; \
	MENU func14_AI_Simple_Dialog_Optional_A; \
	UNIT func14_AI_OUT_SCALE_unit_1; \
	UNIT func14_AI_OUT_SCALE_unit_2

#define USE_FUNC14_AI_OPTIONAL_B \
	USE_FUNC14_AI_OPTIONAL_BOTH; \
	MENU func14_AI_Simple_Dialog_Optional_B; \
	UNIT func14_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC14_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func14_AI_)
#define USE_FUNC14_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func14_AI_)
#define USE_FUNC14_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func14_AI_)
#define USE_FUNC14_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func14_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC15_AI_MANDATORY_BOTH \
	BLOCK func15_AI_block; \
	COLLECTION func15_AI_BLOCK_OBJECT; \
	VARIABLE func15_AI_BLOCK_OBJECT_Reserved; \
	VARIABLE func15_AI_BLOCK_OBJECT_Block_Object; \
	VARIABLE func15_AI_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func15_AI_BLOCK_OBJECT_Class; \
	VARIABLE func15_AI_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func15_AI_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func15_AI_BLOCK_OBJECT_Profile; \
	VARIABLE func15_AI_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func15_AI_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func15_AI_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func15_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func15_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func15_AI_BLOCK_OBJECT_Number_of_Views; \
	MENU func15_AI_BLOCK_OBJECT_page; \
	COMMAND func15_AI_BLOCK_OBJECT_read; \
	VARIABLE func15_AI_ST_REV; \
	MENU func15_AI_ST_REV_page; \
	COMMAND func15_AI_ST_REV_read; \
	VARIABLE func15_AI_TAG_DESC; \
	MENU func15_AI_TAG_DESC_page; \
	COMMAND func15_AI_TAG_DESC_read; \
	COMMAND func15_AI_TAG_DESC_write; \
	VARIABLE func15_AI_STRATEGY; \
	MENU func15_AI_STRATEGY_page; \
	COMMAND func15_AI_STRATEGY_read; \
	COMMAND func15_AI_STRATEGY_write; \
	VARIABLE func15_AI_ALERT_KEY; \
	MENU func15_AI_ALERT_KEY_page; \
	COMMAND func15_AI_ALERT_KEY_read; \
	COMMAND func15_AI_ALERT_KEY_write; \
	VARIABLE func15_AI_TARGET_MODE; \
	MENU func15_AI_TARGET_MODE_page; \
	COMMAND func15_AI_TARGET_MODE_read; \
	COMMAND func15_AI_TARGET_MODE_write; \
	COLLECTION func15_AI_MODE_BLK; \
	VARIABLE func15_AI_MODE_BLK_Actual; \
	VARIABLE func15_AI_MODE_BLK_Permitted; \
	VARIABLE func15_AI_MODE_BLK_Normal; \
	MENU func15_AI_MODE_BLK_page; \
	COMMAND func15_AI_MODE_BLK_read; \
	COLLECTION func15_AI_ALARM_SUM; \
	VARIABLE func15_AI_ALARM_SUM_Current; \
	VARIABLE func15_AI_ALARM_SUM_Unacknowledged; \
	VARIABLE func15_AI_ALARM_SUM_Unreported; \
	VARIABLE func15_AI_ALARM_SUM_Disabled; \
	MENU func15_AI_ALARM_SUM_page; \
	COMMAND func15_AI_ALARM_SUM_read; \
	COLLECTION func15_AI_BATCH; \
	VARIABLE func15_AI_BATCH_Batch_ID; \
	VARIABLE func15_AI_BATCH_Rup; \
	VARIABLE func15_AI_BATCH_Operation; \
	VARIABLE func15_AI_BATCH_Phase; \
	MENU func15_AI_BATCH_page; \
	COMMAND func15_AI_BATCH_read; \
	COMMAND func15_AI_BATCH_write; \
	COLLECTION func15_AI_OUT; \
	VARIABLE func15_AI_OUT_Value; \
	VARIABLE func15_AI_OUT_Status_Quality; \
	VARIABLE func15_AI_OUT_Status_Limit; \
	MENU func15_AI_OUT_page; \
	COMMAND func15_AI_OUT_read; \
	COMMAND func15_AI_OUT_write; \
	COLLECTION func15_AI_PV_SCALE; \
	VARIABLE func15_AI_PV_SCALE_Upper_Value; \
	VARIABLE func15_AI_PV_SCALE_Lower_Value; \
	MENU func15_AI_PV_SCALE_page; \
	COMMAND func15_AI_PV_SCALE_read; \
	COMMAND func15_AI_PV_SCALE_write; \
	VARIABLE func15_AI_PV_FTIME; \
	MENU func15_AI_PV_FTIME_page; \
	COMMAND func15_AI_PV_FTIME_read; \
	COMMAND func15_AI_PV_FTIME_write; \
	VARIABLE func15_AI_ALARM_HYS; \
	MENU func15_AI_ALARM_HYS_page; \
	COMMAND func15_AI_ALARM_HYS_read; \
	COMMAND func15_AI_ALARM_HYS_write; \
	VARIABLE func15_AI_HI_HI_LIM; \
	MENU func15_AI_HI_HI_LIM_page; \
	COMMAND func15_AI_HI_HI_LIM_read; \
	COMMAND func15_AI_HI_HI_LIM_write; \
	VARIABLE func15_AI_HI_LIM; \
	MENU func15_AI_HI_LIM_page; \
	COMMAND func15_AI_HI_LIM_read; \
	COMMAND func15_AI_HI_LIM_write; \
	VARIABLE func15_AI_LO_LIM; \
	MENU func15_AI_LO_LIM_page; \
	COMMAND func15_AI_LO_LIM_read; \
	COMMAND func15_AI_LO_LIM_write; \
	VARIABLE func15_AI_LO_LO_LIM; \
	MENU func15_AI_LO_LO_LIM_page; \
	COMMAND func15_AI_LO_LO_LIM_read; \
	COMMAND func15_AI_LO_LO_LIM_write

#define USE_FUNC15_AI_MANDATORY_A \
	USE_FUNC15_AI_MANDATORY_BOTH; \
	MENU func15_AI_Simple_Dialog_Mandatory_A; \
	MENU func15_AI_Display_mandatory_A; \
	CHART func15_AI_Display_BarVal_out_mandatory_A; \
	SOURCE func15_AI_Display_BarVal_out_source_mandatory_A; \
	MENU func15_AI_Display_out_mandatory_A; \
	MENU func15_AI_Tab_s_mandatory_A; \
	MENU func15_AI_Tab_s_pv_range_mandatory_A; \
	MENU func15_AI_Tab_s_limits_mandatory_A; \
	MENU func15_AI_Tab_m_mandatory_A; \
	MENU func15_AI_Tab_m_pv_range_mandatory_A; \
	MENU func15_AI_Tab_m_limits_mandatory_A

#define USE_FUNC15_AI_MANDATORY_B \
	USE_FUNC15_AI_MANDATORY_BOTH; \
	COLLECTION func15_AI_OUT_SCALE; \
	VARIABLE func15_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func15_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func15_AI_OUT_SCALE_Units_Index; \
	VARIABLE func15_AI_OUT_SCALE_Decimal_Point; \
	MENU func15_AI_OUT_SCALE_page; \
	COMMAND func15_AI_OUT_SCALE_read; \
	COMMAND func15_AI_OUT_SCALE_write; \
	VARIABLE func15_AI_LIN_TYPE; \
	MENU func15_AI_LIN_TYPE_page; \
	COMMAND func15_AI_LIN_TYPE_read; \
	COMMAND func15_AI_LIN_TYPE_write; \
	VARIABLE func15_AI_CHANNEL; \
	MENU func15_AI_CHANNEL_page; \
	COMMAND func15_AI_CHANNEL_read; \
	COMMAND func15_AI_CHANNEL_write; \
	COLLECTION func15_AI_SIMULATE; \
	VARIABLE func15_AI_SIMULATE_Status_Quality; \
	VARIABLE func15_AI_SIMULATE_Status_Limit; \
	VARIABLE func15_AI_SIMULATE_Value; \
	VARIABLE func15_AI_SIMULATE_Enabled; \
	MENU func15_AI_SIMULATE_page; \
	COMMAND func15_AI_SIMULATE_read; \
	COMMAND func15_AI_SIMULATE_write; \
	COLLECTION func15_AI_VIEW_1; \
	MENU func15_AI_VIEW_1_page; \
	MENU func15_AI_Simple_Dialog_Mandatory_B; \
	UNIT func15_AI_OUT_SCALE_unit_1; \
	MENU func15_AI_Simulation; \
	MENU func15_AI_Simulation_input; \
	MENU func15_AI_Simulation_input_group; \
	MENU func15_AI_Simulation_output; \
	MENU func15_AI_Simulation_output_group; \
	MENU func15_AI_Display_mandatory_B; \
	CHART func15_AI_Display_BarVal_out_mandatory_B; \
	SOURCE func15_AI_Display_BarVal_out_source_mandatory_B; \
	AXIS func15_AI_Display_BarVal_out_axis_mandatory_B; \
	MENU func15_AI_Display_out_mandatory_B; \
	MENU func15_AI_Display_in_mandatory_B; \
	MENU func15_AI_Tab_s_mandatory_B; \
	MENU func15_AI_Tab_s_pv_range_mandatory_B; \
	MENU func15_AI_Tab_s_outscale_mandatory_B; \
	MENU func15_AI_Tab_s_limits_mandatory_B; \
	MENU func15_AI_Tab_s_interface_mandatory_B; \
	MENU func15_AI_Tab_m_mandatory_B; \
	MENU func15_AI_Tab_m_pv_range_mandatory_B; \
	MENU func15_AI_Tab_m_outscale_mandatory_B; \
	MENU func15_AI_Tab_m_limits_mandatory_B

#define USE_FUNC15_AI_OPTIONAL_BOTH \
	VARIABLE func15_AI_FSAFE_TYPE; \
	MENU func15_AI_FSAFE_TYPE_page; \
	COMMAND func15_AI_FSAFE_TYPE_read; \
	COMMAND func15_AI_FSAFE_TYPE_write; \
	VARIABLE func15_AI_FSAFE_VALUE; \
	MENU func15_AI_FSAFE_VALUE_page; \
	COMMAND func15_AI_FSAFE_VALUE_read; \
	COMMAND func15_AI_FSAFE_VALUE_write; \
	COLLECTION func15_AI_HI_HI_ALM; \
	VARIABLE func15_AI_HI_HI_ALM_Unacknowledged; \
	VARIABLE func15_AI_HI_HI_ALM_Alarm_State; \
	VARIABLE func15_AI_HI_HI_ALM_Time_Stamp; \
	VARIABLE func15_AI_HI_HI_ALM_Subcode; \
	VARIABLE func15_AI_HI_HI_ALM_Value; \
	MENU func15_AI_HI_HI_ALM_page; \
	COMMAND func15_AI_HI_HI_ALM_read; \
	COLLECTION func15_AI_HI_ALM; \
	VARIABLE func15_AI_HI_ALM_Unacknowledged; \
	VARIABLE func15_AI_HI_ALM_Alarm_State; \
	VARIABLE func15_AI_HI_ALM_Time_Stamp; \
	VARIABLE func15_AI_HI_ALM_Subcode; \
	VARIABLE func15_AI_HI_ALM_Value; \
	MENU func15_AI_HI_ALM_page; \
	COMMAND func15_AI_HI_ALM_read; \
	COLLECTION func15_AI_LO_ALM; \
	VARIABLE func15_AI_LO_ALM_Unacknowledged; \
	VARIABLE func15_AI_LO_ALM_Alarm_State; \
	VARIABLE func15_AI_LO_ALM_Time_Stamp; \
	VARIABLE func15_AI_LO_ALM_Subcode; \
	VARIABLE func15_AI_LO_ALM_Value; \
	MENU func15_AI_LO_ALM_page; \
	COMMAND func15_AI_LO_ALM_read; \
	COLLECTION func15_AI_LO_LO_ALM; \
	VARIABLE func15_AI_LO_LO_ALM_Unacknowledged; \
	VARIABLE func15_AI_LO_LO_ALM_Alarm_State; \
	VARIABLE func15_AI_LO_LO_ALM_Time_Stamp; \
	VARIABLE func15_AI_LO_LO_ALM_Subcode; \
	VARIABLE func15_AI_LO_LO_ALM_Value; \
	MENU func15_AI_LO_LO_ALM_page; \
	COMMAND func15_AI_LO_LO_ALM_read; \
	VARIABLE func15_AI_OUT_UNIT_TEXT; \
	MENU func15_AI_OUT_UNIT_TEXT_page; \
	COMMAND func15_AI_OUT_UNIT_TEXT_read; \
	COMMAND func15_AI_OUT_UNIT_TEXT_write

#define USE_FUNC15_AI_OPTIONAL_A \
	USE_FUNC15_AI_OPTIONAL_BOTH; \
	COLLECTION func15_AI_OUT_SCALE; \
	VARIABLE func15_AI_OUT_SCALE_Upper_Value; \
	VARIABLE func15_AI_OUT_SCALE_Lower_Value; \
	VARIABLE func15_AI_OUT_SCALE_Units_Index; \
	VARIABLE func15_AI_OUT_SCALE_Decimal_Point; \
	MENU func15_AI_OUT_SCALE_page; \
	COMMAND func15_AI_OUT_SCALE_read; \
	COMMAND func15_AI_OUT_SCALE_write; \
	VARIABLE func15_AI_LIN_TYPE; \
	MENU func15_AI_LIN_TYPE_page; \
	COMMAND func15_AI_LIN_TYPE_read; \
	COMMAND func15_AI_LIN_TYPE_write; \
	VARIABLE func15_AI_CHANNEL; \
	MENU func15_AI_CHANNEL_page; \
	COMMAND func15_AI_CHANNEL_read; \
	COMMAND func15_AI_CHANNEL_write; \
	COLLECTION func15_AI_SIMULATE; \
	VARIABLE func15_AI_SIMULATE_Status_Quality; \
	VARIABLE func15_AI_SIMULATE_Status_Limit; \
	VARIABLE func15_AI_SIMULATE_Value; \
	VARIABLE func15_AI_SIMULATE_Enabled; \
	MENU func15_AI_SIMULATE_page; \
	COMMAND func15_AI_SIMULATE_read; \
	COMMAND func15_AI_SIMULATE_write; \
	COLLECTION func15_AI_VIEW_1; \
	MENU func15_AI_VIEW_1_page; \
	MENU func15_AI_Simple_Dialog_Optional_A; \
	UNIT func15_AI_OUT_SCALE_unit_1; \
	UNIT func15_AI_OUT_SCALE_unit_2

#define USE_FUNC15_AI_OPTIONAL_B \
	USE_FUNC15_AI_OPTIONAL_BOTH; \
	MENU func15_AI_Simple_Dialog_Optional_B; \
	UNIT func15_AI_OUT_SCALE_unit_2

#else /* CPP_CANT_CONCAT */

#define USE_FUNC15_AI_MANDATORY_A USE_FUNC_AI_MANDATORY_A(func15_AI_)
#define USE_FUNC15_AI_MANDATORY_B USE_FUNC_AI_MANDATORY_B(func15_AI_)
#define USE_FUNC15_AI_OPTIONAL_A  USE_FUNC_AI_OPTIONAL_A(func15_AI_)
#define USE_FUNC15_AI_OPTIONAL_B  USE_FUNC_AI_OPTIONAL_B(func15_AI_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC1_TOT_MANDATORY_BOTH \
	BLOCK func1_TOT_block; \
	COLLECTION func1_TOT_BLOCK_OBJECT; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func1_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func1_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func1_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func1_TOT_BLOCK_OBJECT_page; \
	COMMAND func1_TOT_BLOCK_OBJECT_read; \
	VARIABLE func1_TOT_ST_REV; \
	MENU func1_TOT_ST_REV_page; \
	COMMAND func1_TOT_ST_REV_read; \
	VARIABLE func1_TOT_TAG_DESC; \
	MENU func1_TOT_TAG_DESC_page; \
	COMMAND func1_TOT_TAG_DESC_read; \
	COMMAND func1_TOT_TAG_DESC_write; \
	VARIABLE func1_TOT_STRATEGY; \
	MENU func1_TOT_STRATEGY_page; \
	COMMAND func1_TOT_STRATEGY_read; \
	COMMAND func1_TOT_STRATEGY_write; \
	VARIABLE func1_TOT_ALERT_KEY; \
	MENU func1_TOT_ALERT_KEY_page; \
	COMMAND func1_TOT_ALERT_KEY_read; \
	COMMAND func1_TOT_ALERT_KEY_write; \
	VARIABLE func1_TOT_TARGET_MODE; \
	MENU func1_TOT_TARGET_MODE_page; \
	COMMAND func1_TOT_TARGET_MODE_read; \
	COMMAND func1_TOT_TARGET_MODE_write; \
	COLLECTION func1_TOT_MODE_BLK; \
	VARIABLE func1_TOT_MODE_BLK_Actual; \
	VARIABLE func1_TOT_MODE_BLK_Permitted; \
	VARIABLE func1_TOT_MODE_BLK_Normal; \
	MENU func1_TOT_MODE_BLK_page; \
	COMMAND func1_TOT_MODE_BLK_read; \
	COLLECTION func1_TOT_ALARM_SUM; \
	VARIABLE func1_TOT_ALARM_SUM_Current; \
	VARIABLE func1_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func1_TOT_ALARM_SUM_Unreported; \
	VARIABLE func1_TOT_ALARM_SUM_Disabled; \
	MENU func1_TOT_ALARM_SUM_page; \
	COMMAND func1_TOT_ALARM_SUM_read; \
	COLLECTION func1_TOT_BATCH; \
	VARIABLE func1_TOT_BATCH_Batch_ID; \
	VARIABLE func1_TOT_BATCH_Rup; \
	VARIABLE func1_TOT_BATCH_Operation; \
	VARIABLE func1_TOT_BATCH_Phase; \
	MENU func1_TOT_BATCH_page; \
	COMMAND func1_TOT_BATCH_read; \
	COMMAND func1_TOT_BATCH_write; \
	COLLECTION func1_TOT_TOTAL; \
	VARIABLE func1_TOT_TOTAL_Value; \
	VARIABLE func1_TOT_TOTAL_Status_Quality; \
	VARIABLE func1_TOT_TOTAL_Status_Limit; \
	MENU func1_TOT_TOTAL_page; \
	COMMAND func1_TOT_TOTAL_read; \
	COMMAND func1_TOT_TOTAL_write; \
	VARIABLE func1_TOT_UNIT_TOT; \
	MENU func1_TOT_UNIT_TOT_page; \
	COMMAND func1_TOT_UNIT_TOT_read; \
	COMMAND func1_TOT_UNIT_TOT_write; \
	VARIABLE func1_TOT_ALARM_HYS; \
	MENU func1_TOT_ALARM_HYS_page; \
	COMMAND func1_TOT_ALARM_HYS_read; \
	COMMAND func1_TOT_ALARM_HYS_write; \
	VARIABLE func1_TOT_HI_HI_LIM; \
	MENU func1_TOT_HI_HI_LIM_page; \
	COMMAND func1_TOT_HI_HI_LIM_read; \
	COMMAND func1_TOT_HI_HI_LIM_write; \
	VARIABLE func1_TOT_HI_LIM; \
	MENU func1_TOT_HI_LIM_page; \
	COMMAND func1_TOT_HI_LIM_read; \
	COMMAND func1_TOT_HI_LIM_write; \
	VARIABLE func1_TOT_LO_LIM; \
	MENU func1_TOT_LO_LIM_page; \
	COMMAND func1_TOT_LO_LIM_read; \
	COMMAND func1_TOT_LO_LIM_write; \
	VARIABLE func1_TOT_LO_LO_LIM; \
	MENU func1_TOT_LO_LO_LIM_page; \
	COMMAND func1_TOT_LO_LO_LIM_read; \
	COMMAND func1_TOT_LO_LO_LIM_write; \
	UNIT func1_TOT_unit_1; \
	MENU func1_TOT_Display; \
	MENU func1_TOT_Display_out; \
	MENU func1_TOT_Tab_s_tot_limits

#define USE_FUNC1_TOT_MANDATORY_A \
	USE_FUNC1_TOT_MANDATORY_BOTH; \
	MENU func1_TOT_Simple_Dialog_Mandatory_A; \
	MENU func1_TOT_Tab_s_mandatory_A; \
	MENU func1_TOT_Tab_m_mandatory_A

#define USE_FUNC1_TOT_MANDATORY_B \
	USE_FUNC1_TOT_MANDATORY_BOTH; \
	VARIABLE func1_TOT_CHANNEL; \
	MENU func1_TOT_CHANNEL_page; \
	COMMAND func1_TOT_CHANNEL_read; \
	COMMAND func1_TOT_CHANNEL_write; \
	VARIABLE func1_TOT_SET_TOT; \
	MENU func1_TOT_SET_TOT_page; \
	COMMAND func1_TOT_SET_TOT_read; \
	COMMAND func1_TOT_SET_TOT_write; \
	VARIABLE func1_TOT_MODE_TOT; \
	MENU func1_TOT_MODE_TOT_page; \
	COMMAND func1_TOT_MODE_TOT_read; \
	COMMAND func1_TOT_MODE_TOT_write; \
	VARIABLE func1_TOT_FAIL_TOT; \
	MENU func1_TOT_FAIL_TOT_page; \
	COMMAND func1_TOT_FAIL_TOT_read; \
	COMMAND func1_TOT_FAIL_TOT_write; \
	VARIABLE func1_TOT_PRESET_TOT; \
	MENU func1_TOT_PRESET_TOT_page; \
	COMMAND func1_TOT_PRESET_TOT_read; \
	COMMAND func1_TOT_PRESET_TOT_write; \
	COLLECTION func1_TOT_VIEW_1; \
	MENU func1_TOT_VIEW_1_page; \
	MENU func1_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func1_TOT_unit_2; \
	MENU func1_TOT_Reset; \
	MENU func1_TOT_Reset_page; \
	METHOD func1_TOT_Reset_totalizer; \
	METHOD func1_TOT_Preset_totalizer; \
	MENU func1_TOT_Tab_s_mandatory_B; \
	MENU func1_TOT_Tab_m_mandatory_B

#define USE_FUNC1_TOT_OPTIONAL_BOTH \
	COLLECTION func1_TOT_HI_HI_ALM; \
	VARIABLE func1_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func1_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func1_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func1_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func1_TOT_HI_HI_ALM_Value; \
	MENU func1_TOT_HI_HI_ALM_page; \
	COMMAND func1_TOT_HI_HI_ALM_read; \
	COLLECTION func1_TOT_HI_ALM; \
	VARIABLE func1_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func1_TOT_HI_ALM_Alarm_State; \
	VARIABLE func1_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func1_TOT_HI_ALM_Subcode; \
	VARIABLE func1_TOT_HI_ALM_Value; \
	MENU func1_TOT_HI_ALM_page; \
	COMMAND func1_TOT_HI_ALM_read; \
	COLLECTION func1_TOT_LO_ALM; \
	VARIABLE func1_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func1_TOT_LO_ALM_Alarm_State; \
	VARIABLE func1_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func1_TOT_LO_ALM_Subcode; \
	VARIABLE func1_TOT_LO_ALM_Value; \
	MENU func1_TOT_LO_ALM_page; \
	COMMAND func1_TOT_LO_ALM_read; \
	COLLECTION func1_TOT_LO_LO_ALM; \
	VARIABLE func1_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func1_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func1_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func1_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func1_TOT_LO_LO_ALM_Value; \
	MENU func1_TOT_LO_LO_ALM_page; \
	COMMAND func1_TOT_LO_LO_ALM_read

#define USE_FUNC1_TOT_OPTIONAL_A \
	USE_FUNC1_TOT_OPTIONAL_BOTH; \
	VARIABLE func1_TOT_CHANNEL; \
	MENU func1_TOT_CHANNEL_page; \
	COMMAND func1_TOT_CHANNEL_read; \
	COMMAND func1_TOT_CHANNEL_write; \
	VARIABLE func1_TOT_SET_TOT; \
	MENU func1_TOT_SET_TOT_page; \
	COMMAND func1_TOT_SET_TOT_read; \
	COMMAND func1_TOT_SET_TOT_write; \
	VARIABLE func1_TOT_MODE_TOT; \
	MENU func1_TOT_MODE_TOT_page; \
	COMMAND func1_TOT_MODE_TOT_read; \
	COMMAND func1_TOT_MODE_TOT_write; \
	VARIABLE func1_TOT_FAIL_TOT; \
	MENU func1_TOT_FAIL_TOT_page; \
	COMMAND func1_TOT_FAIL_TOT_read; \
	COMMAND func1_TOT_FAIL_TOT_write; \
	VARIABLE func1_TOT_PRESET_TOT; \
	MENU func1_TOT_PRESET_TOT_page; \
	COMMAND func1_TOT_PRESET_TOT_read; \
	COMMAND func1_TOT_PRESET_TOT_write; \
	COLLECTION func1_TOT_VIEW_1; \
	MENU func1_TOT_VIEW_1_page; \
	MENU func1_TOT_Simple_Dialog_Optional_A

#define USE_FUNC1_TOT_OPTIONAL_B \
	USE_FUNC1_TOT_OPTIONAL_BOTH; \
	MENU func1_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC_TOT_MANDATORY_BOTH(prefix) \
	BLOCK prefix ## block; \
	COLLECTION prefix ## BLOCK_OBJECT; \
	VARIABLE prefix ## BLOCK_OBJECT_Reserved; \
	VARIABLE prefix ## BLOCK_OBJECT_Block_Object; \
	VARIABLE prefix ## BLOCK_OBJECT_Parent_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Reference; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Execution_Time; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Views; \
	MENU prefix ## BLOCK_OBJECT_page; \
	COMMAND prefix ## BLOCK_OBJECT_read; \
	VARIABLE prefix ## ST_REV; \
	MENU prefix ## ST_REV_page; \
	COMMAND prefix ## ST_REV_read; \
	VARIABLE prefix ## TAG_DESC; \
	MENU prefix ## TAG_DESC_page; \
	COMMAND prefix ## TAG_DESC_read; \
	COMMAND prefix ## TAG_DESC_write; \
	VARIABLE prefix ## STRATEGY; \
	MENU prefix ## STRATEGY_page; \
	COMMAND prefix ## STRATEGY_read; \
	COMMAND prefix ## STRATEGY_write; \
	VARIABLE prefix ## ALERT_KEY; \
	MENU prefix ## ALERT_KEY_page; \
	COMMAND prefix ## ALERT_KEY_read; \
	COMMAND prefix ## ALERT_KEY_write; \
	VARIABLE prefix ## TARGET_MODE; \
	MENU prefix ## TARGET_MODE_page; \
	COMMAND prefix ## TARGET_MODE_read; \
	COMMAND prefix ## TARGET_MODE_write; \
	COLLECTION prefix ## MODE_BLK; \
	VARIABLE prefix ## MODE_BLK_Actual; \
	VARIABLE prefix ## MODE_BLK_Permitted; \
	VARIABLE prefix ## MODE_BLK_Normal; \
	MENU prefix ## MODE_BLK_page; \
	COMMAND prefix ## MODE_BLK_read; \
	COLLECTION prefix ## ALARM_SUM; \
	VARIABLE prefix ## ALARM_SUM_Current; \
	VARIABLE prefix ## ALARM_SUM_Unacknowledged; \
	VARIABLE prefix ## ALARM_SUM_Unreported; \
	VARIABLE prefix ## ALARM_SUM_Disabled; \
	MENU prefix ## ALARM_SUM_page; \
	COMMAND prefix ## ALARM_SUM_read; \
	COLLECTION prefix ## BATCH; \
	VARIABLE prefix ## BATCH_Batch_ID; \
	VARIABLE prefix ## BATCH_Rup; \
	VARIABLE prefix ## BATCH_Operation; \
	VARIABLE prefix ## BATCH_Phase; \
	MENU prefix ## BATCH_page; \
	COMMAND prefix ## BATCH_read; \
	COMMAND prefix ## BATCH_write; \
	COLLECTION prefix ## TOTAL; \
	VARIABLE prefix ## TOTAL_Value; \
	VARIABLE prefix ## TOTAL_Status_Quality; \
	VARIABLE prefix ## TOTAL_Status_Limit; \
	MENU prefix ## TOTAL_page; \
	COMMAND prefix ## TOTAL_read; \
	COMMAND prefix ## TOTAL_write; \
	VARIABLE prefix ## UNIT_TOT; \
	MENU prefix ## UNIT_TOT_page; \
	COMMAND prefix ## UNIT_TOT_read; \
	COMMAND prefix ## UNIT_TOT_write; \
	VARIABLE prefix ## ALARM_HYS; \
	MENU prefix ## ALARM_HYS_page; \
	COMMAND prefix ## ALARM_HYS_read; \
	COMMAND prefix ## ALARM_HYS_write; \
	VARIABLE prefix ## HI_HI_LIM; \
	MENU prefix ## HI_HI_LIM_page; \
	COMMAND prefix ## HI_HI_LIM_read; \
	COMMAND prefix ## HI_HI_LIM_write; \
	VARIABLE prefix ## HI_LIM; \
	MENU prefix ## HI_LIM_page; \
	COMMAND prefix ## HI_LIM_read; \
	COMMAND prefix ## HI_LIM_write; \
	VARIABLE prefix ## LO_LIM; \
	MENU prefix ## LO_LIM_page; \
	COMMAND prefix ## LO_LIM_read; \
	COMMAND prefix ## LO_LIM_write; \
	VARIABLE prefix ## LO_LO_LIM; \
	MENU prefix ## LO_LO_LIM_page; \
	COMMAND prefix ## LO_LO_LIM_read; \
	COMMAND prefix ## LO_LO_LIM_write; \
	UNIT prefix ## unit_1; \
	MENU prefix ## Display; \
	MENU prefix ## Display_out; \
	MENU prefix ## Tab_s_tot_limits

#define USE_FUNC_TOT_MANDATORY_A(prefix) \
	USE_FUNC_TOT_MANDATORY_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Mandatory_A; \
	MENU prefix ## Tab_s_mandatory_A; \
	MENU prefix ## Tab_m_mandatory_A

#define USE_FUNC_TOT_MANDATORY_B(prefix) \
	USE_FUNC_TOT_MANDATORY_BOTH(prefix); \
	VARIABLE prefix ## CHANNEL; \
	MENU prefix ## CHANNEL_page; \
	COMMAND prefix ## CHANNEL_read; \
	COMMAND prefix ## CHANNEL_write; \
	VARIABLE prefix ## SET_TOT; \
	MENU prefix ## SET_TOT_page; \
	COMMAND prefix ## SET_TOT_read; \
	COMMAND prefix ## SET_TOT_write; \
	VARIABLE prefix ## MODE_TOT; \
	MENU prefix ## MODE_TOT_page; \
	COMMAND prefix ## MODE_TOT_read; \
	COMMAND prefix ## MODE_TOT_write; \
	VARIABLE prefix ## FAIL_TOT; \
	MENU prefix ## FAIL_TOT_page; \
	COMMAND prefix ## FAIL_TOT_read; \
	COMMAND prefix ## FAIL_TOT_write; \
	VARIABLE prefix ## PRESET_TOT; \
	MENU prefix ## PRESET_TOT_page; \
	COMMAND prefix ## PRESET_TOT_read; \
	COMMAND prefix ## PRESET_TOT_write; \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Mandatory_B; \
	UNIT prefix ## unit_2; \
	MENU prefix ## Reset; \
	MENU prefix ## Reset_page; \
	METHOD prefix ## Reset_totalizer; \
	METHOD prefix ## Preset_totalizer; \
	MENU prefix ## Tab_s_mandatory_B; \
	MENU prefix ## Tab_m_mandatory_B

#define USE_FUNC_TOT_OPTIONAL_BOTH(prefix) \
	COLLECTION prefix ## HI_HI_ALM; \
	VARIABLE prefix ## HI_HI_ALM_Unacknowledged; \
	VARIABLE prefix ## HI_HI_ALM_Alarm_State; \
	VARIABLE prefix ## HI_HI_ALM_Time_Stamp; \
	VARIABLE prefix ## HI_HI_ALM_Subcode; \
	VARIABLE prefix ## HI_HI_ALM_Value; \
	MENU prefix ## HI_HI_ALM_page; \
	COMMAND prefix ## HI_HI_ALM_read; \
	COLLECTION prefix ## HI_ALM; \
	VARIABLE prefix ## HI_ALM_Unacknowledged; \
	VARIABLE prefix ## HI_ALM_Alarm_State; \
	VARIABLE prefix ## HI_ALM_Time_Stamp; \
	VARIABLE prefix ## HI_ALM_Subcode; \
	VARIABLE prefix ## HI_ALM_Value; \
	MENU prefix ## HI_ALM_page; \
	COMMAND prefix ## HI_ALM_read; \
	COLLECTION prefix ## LO_ALM; \
	VARIABLE prefix ## LO_ALM_Unacknowledged; \
	VARIABLE prefix ## LO_ALM_Alarm_State; \
	VARIABLE prefix ## LO_ALM_Time_Stamp; \
	VARIABLE prefix ## LO_ALM_Subcode; \
	VARIABLE prefix ## LO_ALM_Value; \
	MENU prefix ## LO_ALM_page; \
	COMMAND prefix ## LO_ALM_read; \
	COLLECTION prefix ## LO_LO_ALM; \
	VARIABLE prefix ## LO_LO_ALM_Unacknowledged; \
	VARIABLE prefix ## LO_LO_ALM_Alarm_State; \
	VARIABLE prefix ## LO_LO_ALM_Time_Stamp; \
	VARIABLE prefix ## LO_LO_ALM_Subcode; \
	VARIABLE prefix ## LO_LO_ALM_Value; \
	MENU prefix ## LO_LO_ALM_page; \
	COMMAND prefix ## LO_LO_ALM_read

#define USE_FUNC_TOT_OPTIONAL_A(prefix) \
	USE_FUNC_TOT_OPTIONAL_BOTH(prefix); \
	VARIABLE prefix ## CHANNEL; \
	MENU prefix ## CHANNEL_page; \
	COMMAND prefix ## CHANNEL_read; \
	COMMAND prefix ## CHANNEL_write; \
	VARIABLE prefix ## SET_TOT; \
	MENU prefix ## SET_TOT_page; \
	COMMAND prefix ## SET_TOT_read; \
	COMMAND prefix ## SET_TOT_write; \
	VARIABLE prefix ## MODE_TOT; \
	MENU prefix ## MODE_TOT_page; \
	COMMAND prefix ## MODE_TOT_read; \
	COMMAND prefix ## MODE_TOT_write; \
	VARIABLE prefix ## FAIL_TOT; \
	MENU prefix ## FAIL_TOT_page; \
	COMMAND prefix ## FAIL_TOT_read; \
	COMMAND prefix ## FAIL_TOT_write; \
	VARIABLE prefix ## PRESET_TOT; \
	MENU prefix ## PRESET_TOT_page; \
	COMMAND prefix ## PRESET_TOT_read; \
	COMMAND prefix ## PRESET_TOT_write; \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Optional_A

#define USE_FUNC_TOT_OPTIONAL_B(prefix) \
	USE_FUNC_TOT_OPTIONAL_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Optional_B

#define USE_FUNC1_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func1_TOT_)
#define USE_FUNC1_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func1_TOT_)
#define USE_FUNC1_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func1_TOT_)
#define USE_FUNC1_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func1_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC2_TOT_MANDATORY_BOTH \
	BLOCK func2_TOT_block; \
	COLLECTION func2_TOT_BLOCK_OBJECT; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func2_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func2_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func2_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func2_TOT_BLOCK_OBJECT_page; \
	COMMAND func2_TOT_BLOCK_OBJECT_read; \
	VARIABLE func2_TOT_ST_REV; \
	MENU func2_TOT_ST_REV_page; \
	COMMAND func2_TOT_ST_REV_read; \
	VARIABLE func2_TOT_TAG_DESC; \
	MENU func2_TOT_TAG_DESC_page; \
	COMMAND func2_TOT_TAG_DESC_read; \
	COMMAND func2_TOT_TAG_DESC_write; \
	VARIABLE func2_TOT_STRATEGY; \
	MENU func2_TOT_STRATEGY_page; \
	COMMAND func2_TOT_STRATEGY_read; \
	COMMAND func2_TOT_STRATEGY_write; \
	VARIABLE func2_TOT_ALERT_KEY; \
	MENU func2_TOT_ALERT_KEY_page; \
	COMMAND func2_TOT_ALERT_KEY_read; \
	COMMAND func2_TOT_ALERT_KEY_write; \
	VARIABLE func2_TOT_TARGET_MODE; \
	MENU func2_TOT_TARGET_MODE_page; \
	COMMAND func2_TOT_TARGET_MODE_read; \
	COMMAND func2_TOT_TARGET_MODE_write; \
	COLLECTION func2_TOT_MODE_BLK; \
	VARIABLE func2_TOT_MODE_BLK_Actual; \
	VARIABLE func2_TOT_MODE_BLK_Permitted; \
	VARIABLE func2_TOT_MODE_BLK_Normal; \
	MENU func2_TOT_MODE_BLK_page; \
	COMMAND func2_TOT_MODE_BLK_read; \
	COLLECTION func2_TOT_ALARM_SUM; \
	VARIABLE func2_TOT_ALARM_SUM_Current; \
	VARIABLE func2_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func2_TOT_ALARM_SUM_Unreported; \
	VARIABLE func2_TOT_ALARM_SUM_Disabled; \
	MENU func2_TOT_ALARM_SUM_page; \
	COMMAND func2_TOT_ALARM_SUM_read; \
	COLLECTION func2_TOT_BATCH; \
	VARIABLE func2_TOT_BATCH_Batch_ID; \
	VARIABLE func2_TOT_BATCH_Rup; \
	VARIABLE func2_TOT_BATCH_Operation; \
	VARIABLE func2_TOT_BATCH_Phase; \
	MENU func2_TOT_BATCH_page; \
	COMMAND func2_TOT_BATCH_read; \
	COMMAND func2_TOT_BATCH_write; \
	COLLECTION func2_TOT_TOTAL; \
	VARIABLE func2_TOT_TOTAL_Value; \
	VARIABLE func2_TOT_TOTAL_Status_Quality; \
	VARIABLE func2_TOT_TOTAL_Status_Limit; \
	MENU func2_TOT_TOTAL_page; \
	COMMAND func2_TOT_TOTAL_read; \
	COMMAND func2_TOT_TOTAL_write; \
	VARIABLE func2_TOT_UNIT_TOT; \
	MENU func2_TOT_UNIT_TOT_page; \
	COMMAND func2_TOT_UNIT_TOT_read; \
	COMMAND func2_TOT_UNIT_TOT_write; \
	VARIABLE func2_TOT_ALARM_HYS; \
	MENU func2_TOT_ALARM_HYS_page; \
	COMMAND func2_TOT_ALARM_HYS_read; \
	COMMAND func2_TOT_ALARM_HYS_write; \
	VARIABLE func2_TOT_HI_HI_LIM; \
	MENU func2_TOT_HI_HI_LIM_page; \
	COMMAND func2_TOT_HI_HI_LIM_read; \
	COMMAND func2_TOT_HI_HI_LIM_write; \
	VARIABLE func2_TOT_HI_LIM; \
	MENU func2_TOT_HI_LIM_page; \
	COMMAND func2_TOT_HI_LIM_read; \
	COMMAND func2_TOT_HI_LIM_write; \
	VARIABLE func2_TOT_LO_LIM; \
	MENU func2_TOT_LO_LIM_page; \
	COMMAND func2_TOT_LO_LIM_read; \
	COMMAND func2_TOT_LO_LIM_write; \
	VARIABLE func2_TOT_LO_LO_LIM; \
	MENU func2_TOT_LO_LO_LIM_page; \
	COMMAND func2_TOT_LO_LO_LIM_read; \
	COMMAND func2_TOT_LO_LO_LIM_write; \
	UNIT func2_TOT_unit_1; \
	MENU func2_TOT_Display; \
	MENU func2_TOT_Display_out; \
	MENU func2_TOT_Tab_s_tot_limits

#define USE_FUNC2_TOT_MANDATORY_A \
	USE_FUNC2_TOT_MANDATORY_BOTH; \
	MENU func2_TOT_Simple_Dialog_Mandatory_A; \
	MENU func2_TOT_Tab_s_mandatory_A; \
	MENU func2_TOT_Tab_m_mandatory_A

#define USE_FUNC2_TOT_MANDATORY_B \
	USE_FUNC2_TOT_MANDATORY_BOTH; \
	VARIABLE func2_TOT_CHANNEL; \
	MENU func2_TOT_CHANNEL_page; \
	COMMAND func2_TOT_CHANNEL_read; \
	COMMAND func2_TOT_CHANNEL_write; \
	VARIABLE func2_TOT_SET_TOT; \
	MENU func2_TOT_SET_TOT_page; \
	COMMAND func2_TOT_SET_TOT_read; \
	COMMAND func2_TOT_SET_TOT_write; \
	VARIABLE func2_TOT_MODE_TOT; \
	MENU func2_TOT_MODE_TOT_page; \
	COMMAND func2_TOT_MODE_TOT_read; \
	COMMAND func2_TOT_MODE_TOT_write; \
	VARIABLE func2_TOT_FAIL_TOT; \
	MENU func2_TOT_FAIL_TOT_page; \
	COMMAND func2_TOT_FAIL_TOT_read; \
	COMMAND func2_TOT_FAIL_TOT_write; \
	VARIABLE func2_TOT_PRESET_TOT; \
	MENU func2_TOT_PRESET_TOT_page; \
	COMMAND func2_TOT_PRESET_TOT_read; \
	COMMAND func2_TOT_PRESET_TOT_write; \
	COLLECTION func2_TOT_VIEW_1; \
	MENU func2_TOT_VIEW_1_page; \
	MENU func2_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func2_TOT_unit_2; \
	MENU func2_TOT_Reset; \
	MENU func2_TOT_Reset_page; \
	METHOD func2_TOT_Reset_totalizer; \
	METHOD func2_TOT_Preset_totalizer; \
	MENU func2_TOT_Tab_s_mandatory_B; \
	MENU func2_TOT_Tab_m_mandatory_B

#define USE_FUNC2_TOT_OPTIONAL_BOTH \
	COLLECTION func2_TOT_HI_HI_ALM; \
	VARIABLE func2_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func2_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func2_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func2_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func2_TOT_HI_HI_ALM_Value; \
	MENU func2_TOT_HI_HI_ALM_page; \
	COMMAND func2_TOT_HI_HI_ALM_read; \
	COLLECTION func2_TOT_HI_ALM; \
	VARIABLE func2_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func2_TOT_HI_ALM_Alarm_State; \
	VARIABLE func2_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func2_TOT_HI_ALM_Subcode; \
	VARIABLE func2_TOT_HI_ALM_Value; \
	MENU func2_TOT_HI_ALM_page; \
	COMMAND func2_TOT_HI_ALM_read; \
	COLLECTION func2_TOT_LO_ALM; \
	VARIABLE func2_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func2_TOT_LO_ALM_Alarm_State; \
	VARIABLE func2_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func2_TOT_LO_ALM_Subcode; \
	VARIABLE func2_TOT_LO_ALM_Value; \
	MENU func2_TOT_LO_ALM_page; \
	COMMAND func2_TOT_LO_ALM_read; \
	COLLECTION func2_TOT_LO_LO_ALM; \
	VARIABLE func2_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func2_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func2_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func2_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func2_TOT_LO_LO_ALM_Value; \
	MENU func2_TOT_LO_LO_ALM_page; \
	COMMAND func2_TOT_LO_LO_ALM_read

#define USE_FUNC2_TOT_OPTIONAL_A \
	USE_FUNC2_TOT_OPTIONAL_BOTH; \
	VARIABLE func2_TOT_CHANNEL; \
	MENU func2_TOT_CHANNEL_page; \
	COMMAND func2_TOT_CHANNEL_read; \
	COMMAND func2_TOT_CHANNEL_write; \
	VARIABLE func2_TOT_SET_TOT; \
	MENU func2_TOT_SET_TOT_page; \
	COMMAND func2_TOT_SET_TOT_read; \
	COMMAND func2_TOT_SET_TOT_write; \
	VARIABLE func2_TOT_MODE_TOT; \
	MENU func2_TOT_MODE_TOT_page; \
	COMMAND func2_TOT_MODE_TOT_read; \
	COMMAND func2_TOT_MODE_TOT_write; \
	VARIABLE func2_TOT_FAIL_TOT; \
	MENU func2_TOT_FAIL_TOT_page; \
	COMMAND func2_TOT_FAIL_TOT_read; \
	COMMAND func2_TOT_FAIL_TOT_write; \
	VARIABLE func2_TOT_PRESET_TOT; \
	MENU func2_TOT_PRESET_TOT_page; \
	COMMAND func2_TOT_PRESET_TOT_read; \
	COMMAND func2_TOT_PRESET_TOT_write; \
	COLLECTION func2_TOT_VIEW_1; \
	MENU func2_TOT_VIEW_1_page; \
	MENU func2_TOT_Simple_Dialog_Optional_A

#define USE_FUNC2_TOT_OPTIONAL_B \
	USE_FUNC2_TOT_OPTIONAL_BOTH; \
	MENU func2_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC2_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func2_TOT_)
#define USE_FUNC2_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func2_TOT_)
#define USE_FUNC2_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func2_TOT_)
#define USE_FUNC2_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func2_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC3_TOT_MANDATORY_BOTH \
	BLOCK func3_TOT_block; \
	COLLECTION func3_TOT_BLOCK_OBJECT; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func3_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func3_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func3_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func3_TOT_BLOCK_OBJECT_page; \
	COMMAND func3_TOT_BLOCK_OBJECT_read; \
	VARIABLE func3_TOT_ST_REV; \
	MENU func3_TOT_ST_REV_page; \
	COMMAND func3_TOT_ST_REV_read; \
	VARIABLE func3_TOT_TAG_DESC; \
	MENU func3_TOT_TAG_DESC_page; \
	COMMAND func3_TOT_TAG_DESC_read; \
	COMMAND func3_TOT_TAG_DESC_write; \
	VARIABLE func3_TOT_STRATEGY; \
	MENU func3_TOT_STRATEGY_page; \
	COMMAND func3_TOT_STRATEGY_read; \
	COMMAND func3_TOT_STRATEGY_write; \
	VARIABLE func3_TOT_ALERT_KEY; \
	MENU func3_TOT_ALERT_KEY_page; \
	COMMAND func3_TOT_ALERT_KEY_read; \
	COMMAND func3_TOT_ALERT_KEY_write; \
	VARIABLE func3_TOT_TARGET_MODE; \
	MENU func3_TOT_TARGET_MODE_page; \
	COMMAND func3_TOT_TARGET_MODE_read; \
	COMMAND func3_TOT_TARGET_MODE_write; \
	COLLECTION func3_TOT_MODE_BLK; \
	VARIABLE func3_TOT_MODE_BLK_Actual; \
	VARIABLE func3_TOT_MODE_BLK_Permitted; \
	VARIABLE func3_TOT_MODE_BLK_Normal; \
	MENU func3_TOT_MODE_BLK_page; \
	COMMAND func3_TOT_MODE_BLK_read; \
	COLLECTION func3_TOT_ALARM_SUM; \
	VARIABLE func3_TOT_ALARM_SUM_Current; \
	VARIABLE func3_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func3_TOT_ALARM_SUM_Unreported; \
	VARIABLE func3_TOT_ALARM_SUM_Disabled; \
	MENU func3_TOT_ALARM_SUM_page; \
	COMMAND func3_TOT_ALARM_SUM_read; \
	COLLECTION func3_TOT_BATCH; \
	VARIABLE func3_TOT_BATCH_Batch_ID; \
	VARIABLE func3_TOT_BATCH_Rup; \
	VARIABLE func3_TOT_BATCH_Operation; \
	VARIABLE func3_TOT_BATCH_Phase; \
	MENU func3_TOT_BATCH_page; \
	COMMAND func3_TOT_BATCH_read; \
	COMMAND func3_TOT_BATCH_write; \
	COLLECTION func3_TOT_TOTAL; \
	VARIABLE func3_TOT_TOTAL_Value; \
	VARIABLE func3_TOT_TOTAL_Status_Quality; \
	VARIABLE func3_TOT_TOTAL_Status_Limit; \
	MENU func3_TOT_TOTAL_page; \
	COMMAND func3_TOT_TOTAL_read; \
	COMMAND func3_TOT_TOTAL_write; \
	VARIABLE func3_TOT_UNIT_TOT; \
	MENU func3_TOT_UNIT_TOT_page; \
	COMMAND func3_TOT_UNIT_TOT_read; \
	COMMAND func3_TOT_UNIT_TOT_write; \
	VARIABLE func3_TOT_ALARM_HYS; \
	MENU func3_TOT_ALARM_HYS_page; \
	COMMAND func3_TOT_ALARM_HYS_read; \
	COMMAND func3_TOT_ALARM_HYS_write; \
	VARIABLE func3_TOT_HI_HI_LIM; \
	MENU func3_TOT_HI_HI_LIM_page; \
	COMMAND func3_TOT_HI_HI_LIM_read; \
	COMMAND func3_TOT_HI_HI_LIM_write; \
	VARIABLE func3_TOT_HI_LIM; \
	MENU func3_TOT_HI_LIM_page; \
	COMMAND func3_TOT_HI_LIM_read; \
	COMMAND func3_TOT_HI_LIM_write; \
	VARIABLE func3_TOT_LO_LIM; \
	MENU func3_TOT_LO_LIM_page; \
	COMMAND func3_TOT_LO_LIM_read; \
	COMMAND func3_TOT_LO_LIM_write; \
	VARIABLE func3_TOT_LO_LO_LIM; \
	MENU func3_TOT_LO_LO_LIM_page; \
	COMMAND func3_TOT_LO_LO_LIM_read; \
	COMMAND func3_TOT_LO_LO_LIM_write; \
	UNIT func3_TOT_unit_1; \
	MENU func3_TOT_Display; \
	MENU func3_TOT_Display_out; \
	MENU func3_TOT_Tab_s_tot_limits

#define USE_FUNC3_TOT_MANDATORY_A \
	USE_FUNC3_TOT_MANDATORY_BOTH; \
	MENU func3_TOT_Simple_Dialog_Mandatory_A; \
	MENU func3_TOT_Tab_s_mandatory_A; \
	MENU func3_TOT_Tab_m_mandatory_A

#define USE_FUNC3_TOT_MANDATORY_B \
	USE_FUNC3_TOT_MANDATORY_BOTH; \
	VARIABLE func3_TOT_CHANNEL; \
	MENU func3_TOT_CHANNEL_page; \
	COMMAND func3_TOT_CHANNEL_read; \
	COMMAND func3_TOT_CHANNEL_write; \
	VARIABLE func3_TOT_SET_TOT; \
	MENU func3_TOT_SET_TOT_page; \
	COMMAND func3_TOT_SET_TOT_read; \
	COMMAND func3_TOT_SET_TOT_write; \
	VARIABLE func3_TOT_MODE_TOT; \
	MENU func3_TOT_MODE_TOT_page; \
	COMMAND func3_TOT_MODE_TOT_read; \
	COMMAND func3_TOT_MODE_TOT_write; \
	VARIABLE func3_TOT_FAIL_TOT; \
	MENU func3_TOT_FAIL_TOT_page; \
	COMMAND func3_TOT_FAIL_TOT_read; \
	COMMAND func3_TOT_FAIL_TOT_write; \
	VARIABLE func3_TOT_PRESET_TOT; \
	MENU func3_TOT_PRESET_TOT_page; \
	COMMAND func3_TOT_PRESET_TOT_read; \
	COMMAND func3_TOT_PRESET_TOT_write; \
	COLLECTION func3_TOT_VIEW_1; \
	MENU func3_TOT_VIEW_1_page; \
	MENU func3_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func3_TOT_unit_2; \
	MENU func3_TOT_Reset; \
	MENU func3_TOT_Reset_page; \
	METHOD func3_TOT_Reset_totalizer; \
	METHOD func3_TOT_Preset_totalizer; \
	MENU func3_TOT_Tab_s_mandatory_B; \
	MENU func3_TOT_Tab_m_mandatory_B

#define USE_FUNC3_TOT_OPTIONAL_BOTH \
	COLLECTION func3_TOT_HI_HI_ALM; \
	VARIABLE func3_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func3_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func3_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func3_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func3_TOT_HI_HI_ALM_Value; \
	MENU func3_TOT_HI_HI_ALM_page; \
	COMMAND func3_TOT_HI_HI_ALM_read; \
	COLLECTION func3_TOT_HI_ALM; \
	VARIABLE func3_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func3_TOT_HI_ALM_Alarm_State; \
	VARIABLE func3_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func3_TOT_HI_ALM_Subcode; \
	VARIABLE func3_TOT_HI_ALM_Value; \
	MENU func3_TOT_HI_ALM_page; \
	COMMAND func3_TOT_HI_ALM_read; \
	COLLECTION func3_TOT_LO_ALM; \
	VARIABLE func3_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func3_TOT_LO_ALM_Alarm_State; \
	VARIABLE func3_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func3_TOT_LO_ALM_Subcode; \
	VARIABLE func3_TOT_LO_ALM_Value; \
	MENU func3_TOT_LO_ALM_page; \
	COMMAND func3_TOT_LO_ALM_read; \
	COLLECTION func3_TOT_LO_LO_ALM; \
	VARIABLE func3_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func3_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func3_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func3_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func3_TOT_LO_LO_ALM_Value; \
	MENU func3_TOT_LO_LO_ALM_page; \
	COMMAND func3_TOT_LO_LO_ALM_read

#define USE_FUNC3_TOT_OPTIONAL_A \
	USE_FUNC3_TOT_OPTIONAL_BOTH; \
	VARIABLE func3_TOT_CHANNEL; \
	MENU func3_TOT_CHANNEL_page; \
	COMMAND func3_TOT_CHANNEL_read; \
	COMMAND func3_TOT_CHANNEL_write; \
	VARIABLE func3_TOT_SET_TOT; \
	MENU func3_TOT_SET_TOT_page; \
	COMMAND func3_TOT_SET_TOT_read; \
	COMMAND func3_TOT_SET_TOT_write; \
	VARIABLE func3_TOT_MODE_TOT; \
	MENU func3_TOT_MODE_TOT_page; \
	COMMAND func3_TOT_MODE_TOT_read; \
	COMMAND func3_TOT_MODE_TOT_write; \
	VARIABLE func3_TOT_FAIL_TOT; \
	MENU func3_TOT_FAIL_TOT_page; \
	COMMAND func3_TOT_FAIL_TOT_read; \
	COMMAND func3_TOT_FAIL_TOT_write; \
	VARIABLE func3_TOT_PRESET_TOT; \
	MENU func3_TOT_PRESET_TOT_page; \
	COMMAND func3_TOT_PRESET_TOT_read; \
	COMMAND func3_TOT_PRESET_TOT_write; \
	COLLECTION func3_TOT_VIEW_1; \
	MENU func3_TOT_VIEW_1_page; \
	MENU func3_TOT_Simple_Dialog_Optional_A

#define USE_FUNC3_TOT_OPTIONAL_B \
	USE_FUNC3_TOT_OPTIONAL_BOTH; \
	MENU func3_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC3_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func3_TOT_)
#define USE_FUNC3_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func3_TOT_)
#define USE_FUNC3_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func3_TOT_)
#define USE_FUNC3_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func3_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC4_TOT_MANDATORY_BOTH \
	BLOCK func4_TOT_block; \
	COLLECTION func4_TOT_BLOCK_OBJECT; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func4_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func4_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func4_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func4_TOT_BLOCK_OBJECT_page; \
	COMMAND func4_TOT_BLOCK_OBJECT_read; \
	VARIABLE func4_TOT_ST_REV; \
	MENU func4_TOT_ST_REV_page; \
	COMMAND func4_TOT_ST_REV_read; \
	VARIABLE func4_TOT_TAG_DESC; \
	MENU func4_TOT_TAG_DESC_page; \
	COMMAND func4_TOT_TAG_DESC_read; \
	COMMAND func4_TOT_TAG_DESC_write; \
	VARIABLE func4_TOT_STRATEGY; \
	MENU func4_TOT_STRATEGY_page; \
	COMMAND func4_TOT_STRATEGY_read; \
	COMMAND func4_TOT_STRATEGY_write; \
	VARIABLE func4_TOT_ALERT_KEY; \
	MENU func4_TOT_ALERT_KEY_page; \
	COMMAND func4_TOT_ALERT_KEY_read; \
	COMMAND func4_TOT_ALERT_KEY_write; \
	VARIABLE func4_TOT_TARGET_MODE; \
	MENU func4_TOT_TARGET_MODE_page; \
	COMMAND func4_TOT_TARGET_MODE_read; \
	COMMAND func4_TOT_TARGET_MODE_write; \
	COLLECTION func4_TOT_MODE_BLK; \
	VARIABLE func4_TOT_MODE_BLK_Actual; \
	VARIABLE func4_TOT_MODE_BLK_Permitted; \
	VARIABLE func4_TOT_MODE_BLK_Normal; \
	MENU func4_TOT_MODE_BLK_page; \
	COMMAND func4_TOT_MODE_BLK_read; \
	COLLECTION func4_TOT_ALARM_SUM; \
	VARIABLE func4_TOT_ALARM_SUM_Current; \
	VARIABLE func4_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func4_TOT_ALARM_SUM_Unreported; \
	VARIABLE func4_TOT_ALARM_SUM_Disabled; \
	MENU func4_TOT_ALARM_SUM_page; \
	COMMAND func4_TOT_ALARM_SUM_read; \
	COLLECTION func4_TOT_BATCH; \
	VARIABLE func4_TOT_BATCH_Batch_ID; \
	VARIABLE func4_TOT_BATCH_Rup; \
	VARIABLE func4_TOT_BATCH_Operation; \
	VARIABLE func4_TOT_BATCH_Phase; \
	MENU func4_TOT_BATCH_page; \
	COMMAND func4_TOT_BATCH_read; \
	COMMAND func4_TOT_BATCH_write; \
	COLLECTION func4_TOT_TOTAL; \
	VARIABLE func4_TOT_TOTAL_Value; \
	VARIABLE func4_TOT_TOTAL_Status_Quality; \
	VARIABLE func4_TOT_TOTAL_Status_Limit; \
	MENU func4_TOT_TOTAL_page; \
	COMMAND func4_TOT_TOTAL_read; \
	COMMAND func4_TOT_TOTAL_write; \
	VARIABLE func4_TOT_UNIT_TOT; \
	MENU func4_TOT_UNIT_TOT_page; \
	COMMAND func4_TOT_UNIT_TOT_read; \
	COMMAND func4_TOT_UNIT_TOT_write; \
	VARIABLE func4_TOT_ALARM_HYS; \
	MENU func4_TOT_ALARM_HYS_page; \
	COMMAND func4_TOT_ALARM_HYS_read; \
	COMMAND func4_TOT_ALARM_HYS_write; \
	VARIABLE func4_TOT_HI_HI_LIM; \
	MENU func4_TOT_HI_HI_LIM_page; \
	COMMAND func4_TOT_HI_HI_LIM_read; \
	COMMAND func4_TOT_HI_HI_LIM_write; \
	VARIABLE func4_TOT_HI_LIM; \
	MENU func4_TOT_HI_LIM_page; \
	COMMAND func4_TOT_HI_LIM_read; \
	COMMAND func4_TOT_HI_LIM_write; \
	VARIABLE func4_TOT_LO_LIM; \
	MENU func4_TOT_LO_LIM_page; \
	COMMAND func4_TOT_LO_LIM_read; \
	COMMAND func4_TOT_LO_LIM_write; \
	VARIABLE func4_TOT_LO_LO_LIM; \
	MENU func4_TOT_LO_LO_LIM_page; \
	COMMAND func4_TOT_LO_LO_LIM_read; \
	COMMAND func4_TOT_LO_LO_LIM_write; \
	UNIT func4_TOT_unit_1; \
	MENU func4_TOT_Display; \
	MENU func4_TOT_Display_out; \
	MENU func4_TOT_Tab_s_tot_limits

#define USE_FUNC4_TOT_MANDATORY_A \
	USE_FUNC4_TOT_MANDATORY_BOTH; \
	MENU func4_TOT_Simple_Dialog_Mandatory_A; \
	MENU func4_TOT_Tab_s_mandatory_A; \
	MENU func4_TOT_Tab_m_mandatory_A

#define USE_FUNC4_TOT_MANDATORY_B \
	USE_FUNC4_TOT_MANDATORY_BOTH; \
	VARIABLE func4_TOT_CHANNEL; \
	MENU func4_TOT_CHANNEL_page; \
	COMMAND func4_TOT_CHANNEL_read; \
	COMMAND func4_TOT_CHANNEL_write; \
	VARIABLE func4_TOT_SET_TOT; \
	MENU func4_TOT_SET_TOT_page; \
	COMMAND func4_TOT_SET_TOT_read; \
	COMMAND func4_TOT_SET_TOT_write; \
	VARIABLE func4_TOT_MODE_TOT; \
	MENU func4_TOT_MODE_TOT_page; \
	COMMAND func4_TOT_MODE_TOT_read; \
	COMMAND func4_TOT_MODE_TOT_write; \
	VARIABLE func4_TOT_FAIL_TOT; \
	MENU func4_TOT_FAIL_TOT_page; \
	COMMAND func4_TOT_FAIL_TOT_read; \
	COMMAND func4_TOT_FAIL_TOT_write; \
	VARIABLE func4_TOT_PRESET_TOT; \
	MENU func4_TOT_PRESET_TOT_page; \
	COMMAND func4_TOT_PRESET_TOT_read; \
	COMMAND func4_TOT_PRESET_TOT_write; \
	COLLECTION func4_TOT_VIEW_1; \
	MENU func4_TOT_VIEW_1_page; \
	MENU func4_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func4_TOT_unit_2; \
	MENU func4_TOT_Reset; \
	MENU func4_TOT_Reset_page; \
	METHOD func4_TOT_Reset_totalizer; \
	METHOD func4_TOT_Preset_totalizer; \
	MENU func4_TOT_Tab_s_mandatory_B; \
	MENU func4_TOT_Tab_m_mandatory_B

#define USE_FUNC4_TOT_OPTIONAL_BOTH \
	COLLECTION func4_TOT_HI_HI_ALM; \
	VARIABLE func4_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func4_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func4_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func4_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func4_TOT_HI_HI_ALM_Value; \
	MENU func4_TOT_HI_HI_ALM_page; \
	COMMAND func4_TOT_HI_HI_ALM_read; \
	COLLECTION func4_TOT_HI_ALM; \
	VARIABLE func4_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func4_TOT_HI_ALM_Alarm_State; \
	VARIABLE func4_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func4_TOT_HI_ALM_Subcode; \
	VARIABLE func4_TOT_HI_ALM_Value; \
	MENU func4_TOT_HI_ALM_page; \
	COMMAND func4_TOT_HI_ALM_read; \
	COLLECTION func4_TOT_LO_ALM; \
	VARIABLE func4_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func4_TOT_LO_ALM_Alarm_State; \
	VARIABLE func4_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func4_TOT_LO_ALM_Subcode; \
	VARIABLE func4_TOT_LO_ALM_Value; \
	MENU func4_TOT_LO_ALM_page; \
	COMMAND func4_TOT_LO_ALM_read; \
	COLLECTION func4_TOT_LO_LO_ALM; \
	VARIABLE func4_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func4_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func4_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func4_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func4_TOT_LO_LO_ALM_Value; \
	MENU func4_TOT_LO_LO_ALM_page; \
	COMMAND func4_TOT_LO_LO_ALM_read

#define USE_FUNC4_TOT_OPTIONAL_A \
	USE_FUNC4_TOT_OPTIONAL_BOTH; \
	VARIABLE func4_TOT_CHANNEL; \
	MENU func4_TOT_CHANNEL_page; \
	COMMAND func4_TOT_CHANNEL_read; \
	COMMAND func4_TOT_CHANNEL_write; \
	VARIABLE func4_TOT_SET_TOT; \
	MENU func4_TOT_SET_TOT_page; \
	COMMAND func4_TOT_SET_TOT_read; \
	COMMAND func4_TOT_SET_TOT_write; \
	VARIABLE func4_TOT_MODE_TOT; \
	MENU func4_TOT_MODE_TOT_page; \
	COMMAND func4_TOT_MODE_TOT_read; \
	COMMAND func4_TOT_MODE_TOT_write; \
	VARIABLE func4_TOT_FAIL_TOT; \
	MENU func4_TOT_FAIL_TOT_page; \
	COMMAND func4_TOT_FAIL_TOT_read; \
	COMMAND func4_TOT_FAIL_TOT_write; \
	VARIABLE func4_TOT_PRESET_TOT; \
	MENU func4_TOT_PRESET_TOT_page; \
	COMMAND func4_TOT_PRESET_TOT_read; \
	COMMAND func4_TOT_PRESET_TOT_write; \
	COLLECTION func4_TOT_VIEW_1; \
	MENU func4_TOT_VIEW_1_page; \
	MENU func4_TOT_Simple_Dialog_Optional_A

#define USE_FUNC4_TOT_OPTIONAL_B \
	USE_FUNC4_TOT_OPTIONAL_BOTH; \
	MENU func4_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC4_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func4_TOT_)
#define USE_FUNC4_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func4_TOT_)
#define USE_FUNC4_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func4_TOT_)
#define USE_FUNC4_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func4_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC5_TOT_MANDATORY_BOTH \
	BLOCK func5_TOT_block; \
	COLLECTION func5_TOT_BLOCK_OBJECT; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func5_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func5_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func5_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func5_TOT_BLOCK_OBJECT_page; \
	COMMAND func5_TOT_BLOCK_OBJECT_read; \
	VARIABLE func5_TOT_ST_REV; \
	MENU func5_TOT_ST_REV_page; \
	COMMAND func5_TOT_ST_REV_read; \
	VARIABLE func5_TOT_TAG_DESC; \
	MENU func5_TOT_TAG_DESC_page; \
	COMMAND func5_TOT_TAG_DESC_read; \
	COMMAND func5_TOT_TAG_DESC_write; \
	VARIABLE func5_TOT_STRATEGY; \
	MENU func5_TOT_STRATEGY_page; \
	COMMAND func5_TOT_STRATEGY_read; \
	COMMAND func5_TOT_STRATEGY_write; \
	VARIABLE func5_TOT_ALERT_KEY; \
	MENU func5_TOT_ALERT_KEY_page; \
	COMMAND func5_TOT_ALERT_KEY_read; \
	COMMAND func5_TOT_ALERT_KEY_write; \
	VARIABLE func5_TOT_TARGET_MODE; \
	MENU func5_TOT_TARGET_MODE_page; \
	COMMAND func5_TOT_TARGET_MODE_read; \
	COMMAND func5_TOT_TARGET_MODE_write; \
	COLLECTION func5_TOT_MODE_BLK; \
	VARIABLE func5_TOT_MODE_BLK_Actual; \
	VARIABLE func5_TOT_MODE_BLK_Permitted; \
	VARIABLE func5_TOT_MODE_BLK_Normal; \
	MENU func5_TOT_MODE_BLK_page; \
	COMMAND func5_TOT_MODE_BLK_read; \
	COLLECTION func5_TOT_ALARM_SUM; \
	VARIABLE func5_TOT_ALARM_SUM_Current; \
	VARIABLE func5_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func5_TOT_ALARM_SUM_Unreported; \
	VARIABLE func5_TOT_ALARM_SUM_Disabled; \
	MENU func5_TOT_ALARM_SUM_page; \
	COMMAND func5_TOT_ALARM_SUM_read; \
	COLLECTION func5_TOT_BATCH; \
	VARIABLE func5_TOT_BATCH_Batch_ID; \
	VARIABLE func5_TOT_BATCH_Rup; \
	VARIABLE func5_TOT_BATCH_Operation; \
	VARIABLE func5_TOT_BATCH_Phase; \
	MENU func5_TOT_BATCH_page; \
	COMMAND func5_TOT_BATCH_read; \
	COMMAND func5_TOT_BATCH_write; \
	COLLECTION func5_TOT_TOTAL; \
	VARIABLE func5_TOT_TOTAL_Value; \
	VARIABLE func5_TOT_TOTAL_Status_Quality; \
	VARIABLE func5_TOT_TOTAL_Status_Limit; \
	MENU func5_TOT_TOTAL_page; \
	COMMAND func5_TOT_TOTAL_read; \
	COMMAND func5_TOT_TOTAL_write; \
	VARIABLE func5_TOT_UNIT_TOT; \
	MENU func5_TOT_UNIT_TOT_page; \
	COMMAND func5_TOT_UNIT_TOT_read; \
	COMMAND func5_TOT_UNIT_TOT_write; \
	VARIABLE func5_TOT_ALARM_HYS; \
	MENU func5_TOT_ALARM_HYS_page; \
	COMMAND func5_TOT_ALARM_HYS_read; \
	COMMAND func5_TOT_ALARM_HYS_write; \
	VARIABLE func5_TOT_HI_HI_LIM; \
	MENU func5_TOT_HI_HI_LIM_page; \
	COMMAND func5_TOT_HI_HI_LIM_read; \
	COMMAND func5_TOT_HI_HI_LIM_write; \
	VARIABLE func5_TOT_HI_LIM; \
	MENU func5_TOT_HI_LIM_page; \
	COMMAND func5_TOT_HI_LIM_read; \
	COMMAND func5_TOT_HI_LIM_write; \
	VARIABLE func5_TOT_LO_LIM; \
	MENU func5_TOT_LO_LIM_page; \
	COMMAND func5_TOT_LO_LIM_read; \
	COMMAND func5_TOT_LO_LIM_write; \
	VARIABLE func5_TOT_LO_LO_LIM; \
	MENU func5_TOT_LO_LO_LIM_page; \
	COMMAND func5_TOT_LO_LO_LIM_read; \
	COMMAND func5_TOT_LO_LO_LIM_write; \
	UNIT func5_TOT_unit_1; \
	MENU func5_TOT_Display; \
	MENU func5_TOT_Display_out; \
	MENU func5_TOT_Tab_s_tot_limits

#define USE_FUNC5_TOT_MANDATORY_A \
	USE_FUNC5_TOT_MANDATORY_BOTH; \
	MENU func5_TOT_Simple_Dialog_Mandatory_A; \
	MENU func5_TOT_Tab_s_mandatory_A; \
	MENU func5_TOT_Tab_m_mandatory_A

#define USE_FUNC5_TOT_MANDATORY_B \
	USE_FUNC5_TOT_MANDATORY_BOTH; \
	VARIABLE func5_TOT_CHANNEL; \
	MENU func5_TOT_CHANNEL_page; \
	COMMAND func5_TOT_CHANNEL_read; \
	COMMAND func5_TOT_CHANNEL_write; \
	VARIABLE func5_TOT_SET_TOT; \
	MENU func5_TOT_SET_TOT_page; \
	COMMAND func5_TOT_SET_TOT_read; \
	COMMAND func5_TOT_SET_TOT_write; \
	VARIABLE func5_TOT_MODE_TOT; \
	MENU func5_TOT_MODE_TOT_page; \
	COMMAND func5_TOT_MODE_TOT_read; \
	COMMAND func5_TOT_MODE_TOT_write; \
	VARIABLE func5_TOT_FAIL_TOT; \
	MENU func5_TOT_FAIL_TOT_page; \
	COMMAND func5_TOT_FAIL_TOT_read; \
	COMMAND func5_TOT_FAIL_TOT_write; \
	VARIABLE func5_TOT_PRESET_TOT; \
	MENU func5_TOT_PRESET_TOT_page; \
	COMMAND func5_TOT_PRESET_TOT_read; \
	COMMAND func5_TOT_PRESET_TOT_write; \
	COLLECTION func5_TOT_VIEW_1; \
	MENU func5_TOT_VIEW_1_page; \
	MENU func5_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func5_TOT_unit_2; \
	MENU func5_TOT_Reset; \
	MENU func5_TOT_Reset_page; \
	METHOD func5_TOT_Reset_totalizer; \
	METHOD func5_TOT_Preset_totalizer; \
	MENU func5_TOT_Tab_s_mandatory_B; \
	MENU func5_TOT_Tab_m_mandatory_B

#define USE_FUNC5_TOT_OPTIONAL_BOTH \
	COLLECTION func5_TOT_HI_HI_ALM; \
	VARIABLE func5_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func5_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func5_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func5_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func5_TOT_HI_HI_ALM_Value; \
	MENU func5_TOT_HI_HI_ALM_page; \
	COMMAND func5_TOT_HI_HI_ALM_read; \
	COLLECTION func5_TOT_HI_ALM; \
	VARIABLE func5_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func5_TOT_HI_ALM_Alarm_State; \
	VARIABLE func5_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func5_TOT_HI_ALM_Subcode; \
	VARIABLE func5_TOT_HI_ALM_Value; \
	MENU func5_TOT_HI_ALM_page; \
	COMMAND func5_TOT_HI_ALM_read; \
	COLLECTION func5_TOT_LO_ALM; \
	VARIABLE func5_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func5_TOT_LO_ALM_Alarm_State; \
	VARIABLE func5_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func5_TOT_LO_ALM_Subcode; \
	VARIABLE func5_TOT_LO_ALM_Value; \
	MENU func5_TOT_LO_ALM_page; \
	COMMAND func5_TOT_LO_ALM_read; \
	COLLECTION func5_TOT_LO_LO_ALM; \
	VARIABLE func5_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func5_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func5_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func5_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func5_TOT_LO_LO_ALM_Value; \
	MENU func5_TOT_LO_LO_ALM_page; \
	COMMAND func5_TOT_LO_LO_ALM_read

#define USE_FUNC5_TOT_OPTIONAL_A \
	USE_FUNC5_TOT_OPTIONAL_BOTH; \
	VARIABLE func5_TOT_CHANNEL; \
	MENU func5_TOT_CHANNEL_page; \
	COMMAND func5_TOT_CHANNEL_read; \
	COMMAND func5_TOT_CHANNEL_write; \
	VARIABLE func5_TOT_SET_TOT; \
	MENU func5_TOT_SET_TOT_page; \
	COMMAND func5_TOT_SET_TOT_read; \
	COMMAND func5_TOT_SET_TOT_write; \
	VARIABLE func5_TOT_MODE_TOT; \
	MENU func5_TOT_MODE_TOT_page; \
	COMMAND func5_TOT_MODE_TOT_read; \
	COMMAND func5_TOT_MODE_TOT_write; \
	VARIABLE func5_TOT_FAIL_TOT; \
	MENU func5_TOT_FAIL_TOT_page; \
	COMMAND func5_TOT_FAIL_TOT_read; \
	COMMAND func5_TOT_FAIL_TOT_write; \
	VARIABLE func5_TOT_PRESET_TOT; \
	MENU func5_TOT_PRESET_TOT_page; \
	COMMAND func5_TOT_PRESET_TOT_read; \
	COMMAND func5_TOT_PRESET_TOT_write; \
	COLLECTION func5_TOT_VIEW_1; \
	MENU func5_TOT_VIEW_1_page; \
	MENU func5_TOT_Simple_Dialog_Optional_A

#define USE_FUNC5_TOT_OPTIONAL_B \
	USE_FUNC5_TOT_OPTIONAL_BOTH; \
	MENU func5_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC5_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func5_TOT_)
#define USE_FUNC5_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func5_TOT_)
#define USE_FUNC5_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func5_TOT_)
#define USE_FUNC5_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func5_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC6_TOT_MANDATORY_BOTH \
	BLOCK func6_TOT_block; \
	COLLECTION func6_TOT_BLOCK_OBJECT; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func6_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func6_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func6_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func6_TOT_BLOCK_OBJECT_page; \
	COMMAND func6_TOT_BLOCK_OBJECT_read; \
	VARIABLE func6_TOT_ST_REV; \
	MENU func6_TOT_ST_REV_page; \
	COMMAND func6_TOT_ST_REV_read; \
	VARIABLE func6_TOT_TAG_DESC; \
	MENU func6_TOT_TAG_DESC_page; \
	COMMAND func6_TOT_TAG_DESC_read; \
	COMMAND func6_TOT_TAG_DESC_write; \
	VARIABLE func6_TOT_STRATEGY; \
	MENU func6_TOT_STRATEGY_page; \
	COMMAND func6_TOT_STRATEGY_read; \
	COMMAND func6_TOT_STRATEGY_write; \
	VARIABLE func6_TOT_ALERT_KEY; \
	MENU func6_TOT_ALERT_KEY_page; \
	COMMAND func6_TOT_ALERT_KEY_read; \
	COMMAND func6_TOT_ALERT_KEY_write; \
	VARIABLE func6_TOT_TARGET_MODE; \
	MENU func6_TOT_TARGET_MODE_page; \
	COMMAND func6_TOT_TARGET_MODE_read; \
	COMMAND func6_TOT_TARGET_MODE_write; \
	COLLECTION func6_TOT_MODE_BLK; \
	VARIABLE func6_TOT_MODE_BLK_Actual; \
	VARIABLE func6_TOT_MODE_BLK_Permitted; \
	VARIABLE func6_TOT_MODE_BLK_Normal; \
	MENU func6_TOT_MODE_BLK_page; \
	COMMAND func6_TOT_MODE_BLK_read; \
	COLLECTION func6_TOT_ALARM_SUM; \
	VARIABLE func6_TOT_ALARM_SUM_Current; \
	VARIABLE func6_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func6_TOT_ALARM_SUM_Unreported; \
	VARIABLE func6_TOT_ALARM_SUM_Disabled; \
	MENU func6_TOT_ALARM_SUM_page; \
	COMMAND func6_TOT_ALARM_SUM_read; \
	COLLECTION func6_TOT_BATCH; \
	VARIABLE func6_TOT_BATCH_Batch_ID; \
	VARIABLE func6_TOT_BATCH_Rup; \
	VARIABLE func6_TOT_BATCH_Operation; \
	VARIABLE func6_TOT_BATCH_Phase; \
	MENU func6_TOT_BATCH_page; \
	COMMAND func6_TOT_BATCH_read; \
	COMMAND func6_TOT_BATCH_write; \
	COLLECTION func6_TOT_TOTAL; \
	VARIABLE func6_TOT_TOTAL_Value; \
	VARIABLE func6_TOT_TOTAL_Status_Quality; \
	VARIABLE func6_TOT_TOTAL_Status_Limit; \
	MENU func6_TOT_TOTAL_page; \
	COMMAND func6_TOT_TOTAL_read; \
	COMMAND func6_TOT_TOTAL_write; \
	VARIABLE func6_TOT_UNIT_TOT; \
	MENU func6_TOT_UNIT_TOT_page; \
	COMMAND func6_TOT_UNIT_TOT_read; \
	COMMAND func6_TOT_UNIT_TOT_write; \
	VARIABLE func6_TOT_ALARM_HYS; \
	MENU func6_TOT_ALARM_HYS_page; \
	COMMAND func6_TOT_ALARM_HYS_read; \
	COMMAND func6_TOT_ALARM_HYS_write; \
	VARIABLE func6_TOT_HI_HI_LIM; \
	MENU func6_TOT_HI_HI_LIM_page; \
	COMMAND func6_TOT_HI_HI_LIM_read; \
	COMMAND func6_TOT_HI_HI_LIM_write; \
	VARIABLE func6_TOT_HI_LIM; \
	MENU func6_TOT_HI_LIM_page; \
	COMMAND func6_TOT_HI_LIM_read; \
	COMMAND func6_TOT_HI_LIM_write; \
	VARIABLE func6_TOT_LO_LIM; \
	MENU func6_TOT_LO_LIM_page; \
	COMMAND func6_TOT_LO_LIM_read; \
	COMMAND func6_TOT_LO_LIM_write; \
	VARIABLE func6_TOT_LO_LO_LIM; \
	MENU func6_TOT_LO_LO_LIM_page; \
	COMMAND func6_TOT_LO_LO_LIM_read; \
	COMMAND func6_TOT_LO_LO_LIM_write; \
	UNIT func6_TOT_unit_1; \
	MENU func6_TOT_Display; \
	MENU func6_TOT_Display_out; \
	MENU func6_TOT_Tab_s_tot_limits

#define USE_FUNC6_TOT_MANDATORY_A \
	USE_FUNC6_TOT_MANDATORY_BOTH; \
	MENU func6_TOT_Simple_Dialog_Mandatory_A; \
	MENU func6_TOT_Tab_s_mandatory_A; \
	MENU func6_TOT_Tab_m_mandatory_A

#define USE_FUNC6_TOT_MANDATORY_B \
	USE_FUNC6_TOT_MANDATORY_BOTH; \
	VARIABLE func6_TOT_CHANNEL; \
	MENU func6_TOT_CHANNEL_page; \
	COMMAND func6_TOT_CHANNEL_read; \
	COMMAND func6_TOT_CHANNEL_write; \
	VARIABLE func6_TOT_SET_TOT; \
	MENU func6_TOT_SET_TOT_page; \
	COMMAND func6_TOT_SET_TOT_read; \
	COMMAND func6_TOT_SET_TOT_write; \
	VARIABLE func6_TOT_MODE_TOT; \
	MENU func6_TOT_MODE_TOT_page; \
	COMMAND func6_TOT_MODE_TOT_read; \
	COMMAND func6_TOT_MODE_TOT_write; \
	VARIABLE func6_TOT_FAIL_TOT; \
	MENU func6_TOT_FAIL_TOT_page; \
	COMMAND func6_TOT_FAIL_TOT_read; \
	COMMAND func6_TOT_FAIL_TOT_write; \
	VARIABLE func6_TOT_PRESET_TOT; \
	MENU func6_TOT_PRESET_TOT_page; \
	COMMAND func6_TOT_PRESET_TOT_read; \
	COMMAND func6_TOT_PRESET_TOT_write; \
	COLLECTION func6_TOT_VIEW_1; \
	MENU func6_TOT_VIEW_1_page; \
	MENU func6_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func6_TOT_unit_2; \
	MENU func6_TOT_Reset; \
	MENU func6_TOT_Reset_page; \
	METHOD func6_TOT_Reset_totalizer; \
	METHOD func6_TOT_Preset_totalizer; \
	MENU func6_TOT_Tab_s_mandatory_B; \
	MENU func6_TOT_Tab_m_mandatory_B

#define USE_FUNC6_TOT_OPTIONAL_BOTH \
	COLLECTION func6_TOT_HI_HI_ALM; \
	VARIABLE func6_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func6_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func6_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func6_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func6_TOT_HI_HI_ALM_Value; \
	MENU func6_TOT_HI_HI_ALM_page; \
	COMMAND func6_TOT_HI_HI_ALM_read; \
	COLLECTION func6_TOT_HI_ALM; \
	VARIABLE func6_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func6_TOT_HI_ALM_Alarm_State; \
	VARIABLE func6_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func6_TOT_HI_ALM_Subcode; \
	VARIABLE func6_TOT_HI_ALM_Value; \
	MENU func6_TOT_HI_ALM_page; \
	COMMAND func6_TOT_HI_ALM_read; \
	COLLECTION func6_TOT_LO_ALM; \
	VARIABLE func6_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func6_TOT_LO_ALM_Alarm_State; \
	VARIABLE func6_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func6_TOT_LO_ALM_Subcode; \
	VARIABLE func6_TOT_LO_ALM_Value; \
	MENU func6_TOT_LO_ALM_page; \
	COMMAND func6_TOT_LO_ALM_read; \
	COLLECTION func6_TOT_LO_LO_ALM; \
	VARIABLE func6_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func6_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func6_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func6_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func6_TOT_LO_LO_ALM_Value; \
	MENU func6_TOT_LO_LO_ALM_page; \
	COMMAND func6_TOT_LO_LO_ALM_read

#define USE_FUNC6_TOT_OPTIONAL_A \
	USE_FUNC6_TOT_OPTIONAL_BOTH; \
	VARIABLE func6_TOT_CHANNEL; \
	MENU func6_TOT_CHANNEL_page; \
	COMMAND func6_TOT_CHANNEL_read; \
	COMMAND func6_TOT_CHANNEL_write; \
	VARIABLE func6_TOT_SET_TOT; \
	MENU func6_TOT_SET_TOT_page; \
	COMMAND func6_TOT_SET_TOT_read; \
	COMMAND func6_TOT_SET_TOT_write; \
	VARIABLE func6_TOT_MODE_TOT; \
	MENU func6_TOT_MODE_TOT_page; \
	COMMAND func6_TOT_MODE_TOT_read; \
	COMMAND func6_TOT_MODE_TOT_write; \
	VARIABLE func6_TOT_FAIL_TOT; \
	MENU func6_TOT_FAIL_TOT_page; \
	COMMAND func6_TOT_FAIL_TOT_read; \
	COMMAND func6_TOT_FAIL_TOT_write; \
	VARIABLE func6_TOT_PRESET_TOT; \
	MENU func6_TOT_PRESET_TOT_page; \
	COMMAND func6_TOT_PRESET_TOT_read; \
	COMMAND func6_TOT_PRESET_TOT_write; \
	COLLECTION func6_TOT_VIEW_1; \
	MENU func6_TOT_VIEW_1_page; \
	MENU func6_TOT_Simple_Dialog_Optional_A

#define USE_FUNC6_TOT_OPTIONAL_B \
	USE_FUNC6_TOT_OPTIONAL_BOTH; \
	MENU func6_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC6_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func6_TOT_)
#define USE_FUNC6_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func6_TOT_)
#define USE_FUNC6_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func6_TOT_)
#define USE_FUNC6_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func6_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC7_TOT_MANDATORY_BOTH \
	BLOCK func7_TOT_block; \
	COLLECTION func7_TOT_BLOCK_OBJECT; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func7_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func7_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func7_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func7_TOT_BLOCK_OBJECT_page; \
	COMMAND func7_TOT_BLOCK_OBJECT_read; \
	VARIABLE func7_TOT_ST_REV; \
	MENU func7_TOT_ST_REV_page; \
	COMMAND func7_TOT_ST_REV_read; \
	VARIABLE func7_TOT_TAG_DESC; \
	MENU func7_TOT_TAG_DESC_page; \
	COMMAND func7_TOT_TAG_DESC_read; \
	COMMAND func7_TOT_TAG_DESC_write; \
	VARIABLE func7_TOT_STRATEGY; \
	MENU func7_TOT_STRATEGY_page; \
	COMMAND func7_TOT_STRATEGY_read; \
	COMMAND func7_TOT_STRATEGY_write; \
	VARIABLE func7_TOT_ALERT_KEY; \
	MENU func7_TOT_ALERT_KEY_page; \
	COMMAND func7_TOT_ALERT_KEY_read; \
	COMMAND func7_TOT_ALERT_KEY_write; \
	VARIABLE func7_TOT_TARGET_MODE; \
	MENU func7_TOT_TARGET_MODE_page; \
	COMMAND func7_TOT_TARGET_MODE_read; \
	COMMAND func7_TOT_TARGET_MODE_write; \
	COLLECTION func7_TOT_MODE_BLK; \
	VARIABLE func7_TOT_MODE_BLK_Actual; \
	VARIABLE func7_TOT_MODE_BLK_Permitted; \
	VARIABLE func7_TOT_MODE_BLK_Normal; \
	MENU func7_TOT_MODE_BLK_page; \
	COMMAND func7_TOT_MODE_BLK_read; \
	COLLECTION func7_TOT_ALARM_SUM; \
	VARIABLE func7_TOT_ALARM_SUM_Current; \
	VARIABLE func7_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func7_TOT_ALARM_SUM_Unreported; \
	VARIABLE func7_TOT_ALARM_SUM_Disabled; \
	MENU func7_TOT_ALARM_SUM_page; \
	COMMAND func7_TOT_ALARM_SUM_read; \
	COLLECTION func7_TOT_BATCH; \
	VARIABLE func7_TOT_BATCH_Batch_ID; \
	VARIABLE func7_TOT_BATCH_Rup; \
	VARIABLE func7_TOT_BATCH_Operation; \
	VARIABLE func7_TOT_BATCH_Phase; \
	MENU func7_TOT_BATCH_page; \
	COMMAND func7_TOT_BATCH_read; \
	COMMAND func7_TOT_BATCH_write; \
	COLLECTION func7_TOT_TOTAL; \
	VARIABLE func7_TOT_TOTAL_Value; \
	VARIABLE func7_TOT_TOTAL_Status_Quality; \
	VARIABLE func7_TOT_TOTAL_Status_Limit; \
	MENU func7_TOT_TOTAL_page; \
	COMMAND func7_TOT_TOTAL_read; \
	COMMAND func7_TOT_TOTAL_write; \
	VARIABLE func7_TOT_UNIT_TOT; \
	MENU func7_TOT_UNIT_TOT_page; \
	COMMAND func7_TOT_UNIT_TOT_read; \
	COMMAND func7_TOT_UNIT_TOT_write; \
	VARIABLE func7_TOT_ALARM_HYS; \
	MENU func7_TOT_ALARM_HYS_page; \
	COMMAND func7_TOT_ALARM_HYS_read; \
	COMMAND func7_TOT_ALARM_HYS_write; \
	VARIABLE func7_TOT_HI_HI_LIM; \
	MENU func7_TOT_HI_HI_LIM_page; \
	COMMAND func7_TOT_HI_HI_LIM_read; \
	COMMAND func7_TOT_HI_HI_LIM_write; \
	VARIABLE func7_TOT_HI_LIM; \
	MENU func7_TOT_HI_LIM_page; \
	COMMAND func7_TOT_HI_LIM_read; \
	COMMAND func7_TOT_HI_LIM_write; \
	VARIABLE func7_TOT_LO_LIM; \
	MENU func7_TOT_LO_LIM_page; \
	COMMAND func7_TOT_LO_LIM_read; \
	COMMAND func7_TOT_LO_LIM_write; \
	VARIABLE func7_TOT_LO_LO_LIM; \
	MENU func7_TOT_LO_LO_LIM_page; \
	COMMAND func7_TOT_LO_LO_LIM_read; \
	COMMAND func7_TOT_LO_LO_LIM_write; \
	UNIT func7_TOT_unit_1; \
	MENU func7_TOT_Display; \
	MENU func7_TOT_Display_out; \
	MENU func7_TOT_Tab_s_tot_limits

#define USE_FUNC7_TOT_MANDATORY_A \
	USE_FUNC7_TOT_MANDATORY_BOTH; \
	MENU func7_TOT_Simple_Dialog_Mandatory_A; \
	MENU func7_TOT_Tab_s_mandatory_A; \
	MENU func7_TOT_Tab_m_mandatory_A

#define USE_FUNC7_TOT_MANDATORY_B \
	USE_FUNC7_TOT_MANDATORY_BOTH; \
	VARIABLE func7_TOT_CHANNEL; \
	MENU func7_TOT_CHANNEL_page; \
	COMMAND func7_TOT_CHANNEL_read; \
	COMMAND func7_TOT_CHANNEL_write; \
	VARIABLE func7_TOT_SET_TOT; \
	MENU func7_TOT_SET_TOT_page; \
	COMMAND func7_TOT_SET_TOT_read; \
	COMMAND func7_TOT_SET_TOT_write; \
	VARIABLE func7_TOT_MODE_TOT; \
	MENU func7_TOT_MODE_TOT_page; \
	COMMAND func7_TOT_MODE_TOT_read; \
	COMMAND func7_TOT_MODE_TOT_write; \
	VARIABLE func7_TOT_FAIL_TOT; \
	MENU func7_TOT_FAIL_TOT_page; \
	COMMAND func7_TOT_FAIL_TOT_read; \
	COMMAND func7_TOT_FAIL_TOT_write; \
	VARIABLE func7_TOT_PRESET_TOT; \
	MENU func7_TOT_PRESET_TOT_page; \
	COMMAND func7_TOT_PRESET_TOT_read; \
	COMMAND func7_TOT_PRESET_TOT_write; \
	COLLECTION func7_TOT_VIEW_1; \
	MENU func7_TOT_VIEW_1_page; \
	MENU func7_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func7_TOT_unit_2; \
	MENU func7_TOT_Reset; \
	MENU func7_TOT_Reset_page; \
	METHOD func7_TOT_Reset_totalizer; \
	METHOD func7_TOT_Preset_totalizer; \
	MENU func7_TOT_Tab_s_mandatory_B; \
	MENU func7_TOT_Tab_m_mandatory_B

#define USE_FUNC7_TOT_OPTIONAL_BOTH \
	COLLECTION func7_TOT_HI_HI_ALM; \
	VARIABLE func7_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func7_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func7_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func7_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func7_TOT_HI_HI_ALM_Value; \
	MENU func7_TOT_HI_HI_ALM_page; \
	COMMAND func7_TOT_HI_HI_ALM_read; \
	COLLECTION func7_TOT_HI_ALM; \
	VARIABLE func7_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func7_TOT_HI_ALM_Alarm_State; \
	VARIABLE func7_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func7_TOT_HI_ALM_Subcode; \
	VARIABLE func7_TOT_HI_ALM_Value; \
	MENU func7_TOT_HI_ALM_page; \
	COMMAND func7_TOT_HI_ALM_read; \
	COLLECTION func7_TOT_LO_ALM; \
	VARIABLE func7_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func7_TOT_LO_ALM_Alarm_State; \
	VARIABLE func7_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func7_TOT_LO_ALM_Subcode; \
	VARIABLE func7_TOT_LO_ALM_Value; \
	MENU func7_TOT_LO_ALM_page; \
	COMMAND func7_TOT_LO_ALM_read; \
	COLLECTION func7_TOT_LO_LO_ALM; \
	VARIABLE func7_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func7_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func7_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func7_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func7_TOT_LO_LO_ALM_Value; \
	MENU func7_TOT_LO_LO_ALM_page; \
	COMMAND func7_TOT_LO_LO_ALM_read

#define USE_FUNC7_TOT_OPTIONAL_A \
	USE_FUNC7_TOT_OPTIONAL_BOTH; \
	VARIABLE func7_TOT_CHANNEL; \
	MENU func7_TOT_CHANNEL_page; \
	COMMAND func7_TOT_CHANNEL_read; \
	COMMAND func7_TOT_CHANNEL_write; \
	VARIABLE func7_TOT_SET_TOT; \
	MENU func7_TOT_SET_TOT_page; \
	COMMAND func7_TOT_SET_TOT_read; \
	COMMAND func7_TOT_SET_TOT_write; \
	VARIABLE func7_TOT_MODE_TOT; \
	MENU func7_TOT_MODE_TOT_page; \
	COMMAND func7_TOT_MODE_TOT_read; \
	COMMAND func7_TOT_MODE_TOT_write; \
	VARIABLE func7_TOT_FAIL_TOT; \
	MENU func7_TOT_FAIL_TOT_page; \
	COMMAND func7_TOT_FAIL_TOT_read; \
	COMMAND func7_TOT_FAIL_TOT_write; \
	VARIABLE func7_TOT_PRESET_TOT; \
	MENU func7_TOT_PRESET_TOT_page; \
	COMMAND func7_TOT_PRESET_TOT_read; \
	COMMAND func7_TOT_PRESET_TOT_write; \
	COLLECTION func7_TOT_VIEW_1; \
	MENU func7_TOT_VIEW_1_page; \
	MENU func7_TOT_Simple_Dialog_Optional_A

#define USE_FUNC7_TOT_OPTIONAL_B \
	USE_FUNC7_TOT_OPTIONAL_BOTH; \
	MENU func7_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC7_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func7_TOT_)
#define USE_FUNC7_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func7_TOT_)
#define USE_FUNC7_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func7_TOT_)
#define USE_FUNC7_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func7_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC8_TOT_MANDATORY_BOTH \
	BLOCK func8_TOT_block; \
	COLLECTION func8_TOT_BLOCK_OBJECT; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func8_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func8_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func8_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func8_TOT_BLOCK_OBJECT_page; \
	COMMAND func8_TOT_BLOCK_OBJECT_read; \
	VARIABLE func8_TOT_ST_REV; \
	MENU func8_TOT_ST_REV_page; \
	COMMAND func8_TOT_ST_REV_read; \
	VARIABLE func8_TOT_TAG_DESC; \
	MENU func8_TOT_TAG_DESC_page; \
	COMMAND func8_TOT_TAG_DESC_read; \
	COMMAND func8_TOT_TAG_DESC_write; \
	VARIABLE func8_TOT_STRATEGY; \
	MENU func8_TOT_STRATEGY_page; \
	COMMAND func8_TOT_STRATEGY_read; \
	COMMAND func8_TOT_STRATEGY_write; \
	VARIABLE func8_TOT_ALERT_KEY; \
	MENU func8_TOT_ALERT_KEY_page; \
	COMMAND func8_TOT_ALERT_KEY_read; \
	COMMAND func8_TOT_ALERT_KEY_write; \
	VARIABLE func8_TOT_TARGET_MODE; \
	MENU func8_TOT_TARGET_MODE_page; \
	COMMAND func8_TOT_TARGET_MODE_read; \
	COMMAND func8_TOT_TARGET_MODE_write; \
	COLLECTION func8_TOT_MODE_BLK; \
	VARIABLE func8_TOT_MODE_BLK_Actual; \
	VARIABLE func8_TOT_MODE_BLK_Permitted; \
	VARIABLE func8_TOT_MODE_BLK_Normal; \
	MENU func8_TOT_MODE_BLK_page; \
	COMMAND func8_TOT_MODE_BLK_read; \
	COLLECTION func8_TOT_ALARM_SUM; \
	VARIABLE func8_TOT_ALARM_SUM_Current; \
	VARIABLE func8_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func8_TOT_ALARM_SUM_Unreported; \
	VARIABLE func8_TOT_ALARM_SUM_Disabled; \
	MENU func8_TOT_ALARM_SUM_page; \
	COMMAND func8_TOT_ALARM_SUM_read; \
	COLLECTION func8_TOT_BATCH; \
	VARIABLE func8_TOT_BATCH_Batch_ID; \
	VARIABLE func8_TOT_BATCH_Rup; \
	VARIABLE func8_TOT_BATCH_Operation; \
	VARIABLE func8_TOT_BATCH_Phase; \
	MENU func8_TOT_BATCH_page; \
	COMMAND func8_TOT_BATCH_read; \
	COMMAND func8_TOT_BATCH_write; \
	COLLECTION func8_TOT_TOTAL; \
	VARIABLE func8_TOT_TOTAL_Value; \
	VARIABLE func8_TOT_TOTAL_Status_Quality; \
	VARIABLE func8_TOT_TOTAL_Status_Limit; \
	MENU func8_TOT_TOTAL_page; \
	COMMAND func8_TOT_TOTAL_read; \
	COMMAND func8_TOT_TOTAL_write; \
	VARIABLE func8_TOT_UNIT_TOT; \
	MENU func8_TOT_UNIT_TOT_page; \
	COMMAND func8_TOT_UNIT_TOT_read; \
	COMMAND func8_TOT_UNIT_TOT_write; \
	VARIABLE func8_TOT_ALARM_HYS; \
	MENU func8_TOT_ALARM_HYS_page; \
	COMMAND func8_TOT_ALARM_HYS_read; \
	COMMAND func8_TOT_ALARM_HYS_write; \
	VARIABLE func8_TOT_HI_HI_LIM; \
	MENU func8_TOT_HI_HI_LIM_page; \
	COMMAND func8_TOT_HI_HI_LIM_read; \
	COMMAND func8_TOT_HI_HI_LIM_write; \
	VARIABLE func8_TOT_HI_LIM; \
	MENU func8_TOT_HI_LIM_page; \
	COMMAND func8_TOT_HI_LIM_read; \
	COMMAND func8_TOT_HI_LIM_write; \
	VARIABLE func8_TOT_LO_LIM; \
	MENU func8_TOT_LO_LIM_page; \
	COMMAND func8_TOT_LO_LIM_read; \
	COMMAND func8_TOT_LO_LIM_write; \
	VARIABLE func8_TOT_LO_LO_LIM; \
	MENU func8_TOT_LO_LO_LIM_page; \
	COMMAND func8_TOT_LO_LO_LIM_read; \
	COMMAND func8_TOT_LO_LO_LIM_write; \
	UNIT func8_TOT_unit_1; \
	MENU func8_TOT_Display; \
	MENU func8_TOT_Display_out; \
	MENU func8_TOT_Tab_s_tot_limits

#define USE_FUNC8_TOT_MANDATORY_A \
	USE_FUNC8_TOT_MANDATORY_BOTH; \
	MENU func8_TOT_Simple_Dialog_Mandatory_A; \
	MENU func8_TOT_Tab_s_mandatory_A; \
	MENU func8_TOT_Tab_m_mandatory_A

#define USE_FUNC8_TOT_MANDATORY_B \
	USE_FUNC8_TOT_MANDATORY_BOTH; \
	VARIABLE func8_TOT_CHANNEL; \
	MENU func8_TOT_CHANNEL_page; \
	COMMAND func8_TOT_CHANNEL_read; \
	COMMAND func8_TOT_CHANNEL_write; \
	VARIABLE func8_TOT_SET_TOT; \
	MENU func8_TOT_SET_TOT_page; \
	COMMAND func8_TOT_SET_TOT_read; \
	COMMAND func8_TOT_SET_TOT_write; \
	VARIABLE func8_TOT_MODE_TOT; \
	MENU func8_TOT_MODE_TOT_page; \
	COMMAND func8_TOT_MODE_TOT_read; \
	COMMAND func8_TOT_MODE_TOT_write; \
	VARIABLE func8_TOT_FAIL_TOT; \
	MENU func8_TOT_FAIL_TOT_page; \
	COMMAND func8_TOT_FAIL_TOT_read; \
	COMMAND func8_TOT_FAIL_TOT_write; \
	VARIABLE func8_TOT_PRESET_TOT; \
	MENU func8_TOT_PRESET_TOT_page; \
	COMMAND func8_TOT_PRESET_TOT_read; \
	COMMAND func8_TOT_PRESET_TOT_write; \
	COLLECTION func8_TOT_VIEW_1; \
	MENU func8_TOT_VIEW_1_page; \
	MENU func8_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func8_TOT_unit_2; \
	MENU func8_TOT_Reset; \
	MENU func8_TOT_Reset_page; \
	METHOD func8_TOT_Reset_totalizer; \
	METHOD func8_TOT_Preset_totalizer; \
	MENU func8_TOT_Tab_s_mandatory_B; \
	MENU func8_TOT_Tab_m_mandatory_B

#define USE_FUNC8_TOT_OPTIONAL_BOTH \
	COLLECTION func8_TOT_HI_HI_ALM; \
	VARIABLE func8_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func8_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func8_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func8_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func8_TOT_HI_HI_ALM_Value; \
	MENU func8_TOT_HI_HI_ALM_page; \
	COMMAND func8_TOT_HI_HI_ALM_read; \
	COLLECTION func8_TOT_HI_ALM; \
	VARIABLE func8_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func8_TOT_HI_ALM_Alarm_State; \
	VARIABLE func8_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func8_TOT_HI_ALM_Subcode; \
	VARIABLE func8_TOT_HI_ALM_Value; \
	MENU func8_TOT_HI_ALM_page; \
	COMMAND func8_TOT_HI_ALM_read; \
	COLLECTION func8_TOT_LO_ALM; \
	VARIABLE func8_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func8_TOT_LO_ALM_Alarm_State; \
	VARIABLE func8_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func8_TOT_LO_ALM_Subcode; \
	VARIABLE func8_TOT_LO_ALM_Value; \
	MENU func8_TOT_LO_ALM_page; \
	COMMAND func8_TOT_LO_ALM_read; \
	COLLECTION func8_TOT_LO_LO_ALM; \
	VARIABLE func8_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func8_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func8_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func8_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func8_TOT_LO_LO_ALM_Value; \
	MENU func8_TOT_LO_LO_ALM_page; \
	COMMAND func8_TOT_LO_LO_ALM_read

#define USE_FUNC8_TOT_OPTIONAL_A \
	USE_FUNC8_TOT_OPTIONAL_BOTH; \
	VARIABLE func8_TOT_CHANNEL; \
	MENU func8_TOT_CHANNEL_page; \
	COMMAND func8_TOT_CHANNEL_read; \
	COMMAND func8_TOT_CHANNEL_write; \
	VARIABLE func8_TOT_SET_TOT; \
	MENU func8_TOT_SET_TOT_page; \
	COMMAND func8_TOT_SET_TOT_read; \
	COMMAND func8_TOT_SET_TOT_write; \
	VARIABLE func8_TOT_MODE_TOT; \
	MENU func8_TOT_MODE_TOT_page; \
	COMMAND func8_TOT_MODE_TOT_read; \
	COMMAND func8_TOT_MODE_TOT_write; \
	VARIABLE func8_TOT_FAIL_TOT; \
	MENU func8_TOT_FAIL_TOT_page; \
	COMMAND func8_TOT_FAIL_TOT_read; \
	COMMAND func8_TOT_FAIL_TOT_write; \
	VARIABLE func8_TOT_PRESET_TOT; \
	MENU func8_TOT_PRESET_TOT_page; \
	COMMAND func8_TOT_PRESET_TOT_read; \
	COMMAND func8_TOT_PRESET_TOT_write; \
	COLLECTION func8_TOT_VIEW_1; \
	MENU func8_TOT_VIEW_1_page; \
	MENU func8_TOT_Simple_Dialog_Optional_A

#define USE_FUNC8_TOT_OPTIONAL_B \
	USE_FUNC8_TOT_OPTIONAL_BOTH; \
	MENU func8_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC8_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func8_TOT_)
#define USE_FUNC8_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func8_TOT_)
#define USE_FUNC8_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func8_TOT_)
#define USE_FUNC8_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func8_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC9_TOT_MANDATORY_BOTH \
	BLOCK func9_TOT_block; \
	COLLECTION func9_TOT_BLOCK_OBJECT; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func9_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func9_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func9_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func9_TOT_BLOCK_OBJECT_page; \
	COMMAND func9_TOT_BLOCK_OBJECT_read; \
	VARIABLE func9_TOT_ST_REV; \
	MENU func9_TOT_ST_REV_page; \
	COMMAND func9_TOT_ST_REV_read; \
	VARIABLE func9_TOT_TAG_DESC; \
	MENU func9_TOT_TAG_DESC_page; \
	COMMAND func9_TOT_TAG_DESC_read; \
	COMMAND func9_TOT_TAG_DESC_write; \
	VARIABLE func9_TOT_STRATEGY; \
	MENU func9_TOT_STRATEGY_page; \
	COMMAND func9_TOT_STRATEGY_read; \
	COMMAND func9_TOT_STRATEGY_write; \
	VARIABLE func9_TOT_ALERT_KEY; \
	MENU func9_TOT_ALERT_KEY_page; \
	COMMAND func9_TOT_ALERT_KEY_read; \
	COMMAND func9_TOT_ALERT_KEY_write; \
	VARIABLE func9_TOT_TARGET_MODE; \
	MENU func9_TOT_TARGET_MODE_page; \
	COMMAND func9_TOT_TARGET_MODE_read; \
	COMMAND func9_TOT_TARGET_MODE_write; \
	COLLECTION func9_TOT_MODE_BLK; \
	VARIABLE func9_TOT_MODE_BLK_Actual; \
	VARIABLE func9_TOT_MODE_BLK_Permitted; \
	VARIABLE func9_TOT_MODE_BLK_Normal; \
	MENU func9_TOT_MODE_BLK_page; \
	COMMAND func9_TOT_MODE_BLK_read; \
	COLLECTION func9_TOT_ALARM_SUM; \
	VARIABLE func9_TOT_ALARM_SUM_Current; \
	VARIABLE func9_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func9_TOT_ALARM_SUM_Unreported; \
	VARIABLE func9_TOT_ALARM_SUM_Disabled; \
	MENU func9_TOT_ALARM_SUM_page; \
	COMMAND func9_TOT_ALARM_SUM_read; \
	COLLECTION func9_TOT_BATCH; \
	VARIABLE func9_TOT_BATCH_Batch_ID; \
	VARIABLE func9_TOT_BATCH_Rup; \
	VARIABLE func9_TOT_BATCH_Operation; \
	VARIABLE func9_TOT_BATCH_Phase; \
	MENU func9_TOT_BATCH_page; \
	COMMAND func9_TOT_BATCH_read; \
	COMMAND func9_TOT_BATCH_write; \
	COLLECTION func9_TOT_TOTAL; \
	VARIABLE func9_TOT_TOTAL_Value; \
	VARIABLE func9_TOT_TOTAL_Status_Quality; \
	VARIABLE func9_TOT_TOTAL_Status_Limit; \
	MENU func9_TOT_TOTAL_page; \
	COMMAND func9_TOT_TOTAL_read; \
	COMMAND func9_TOT_TOTAL_write; \
	VARIABLE func9_TOT_UNIT_TOT; \
	MENU func9_TOT_UNIT_TOT_page; \
	COMMAND func9_TOT_UNIT_TOT_read; \
	COMMAND func9_TOT_UNIT_TOT_write; \
	VARIABLE func9_TOT_ALARM_HYS; \
	MENU func9_TOT_ALARM_HYS_page; \
	COMMAND func9_TOT_ALARM_HYS_read; \
	COMMAND func9_TOT_ALARM_HYS_write; \
	VARIABLE func9_TOT_HI_HI_LIM; \
	MENU func9_TOT_HI_HI_LIM_page; \
	COMMAND func9_TOT_HI_HI_LIM_read; \
	COMMAND func9_TOT_HI_HI_LIM_write; \
	VARIABLE func9_TOT_HI_LIM; \
	MENU func9_TOT_HI_LIM_page; \
	COMMAND func9_TOT_HI_LIM_read; \
	COMMAND func9_TOT_HI_LIM_write; \
	VARIABLE func9_TOT_LO_LIM; \
	MENU func9_TOT_LO_LIM_page; \
	COMMAND func9_TOT_LO_LIM_read; \
	COMMAND func9_TOT_LO_LIM_write; \
	VARIABLE func9_TOT_LO_LO_LIM; \
	MENU func9_TOT_LO_LO_LIM_page; \
	COMMAND func9_TOT_LO_LO_LIM_read; \
	COMMAND func9_TOT_LO_LO_LIM_write; \
	UNIT func9_TOT_unit_1; \
	MENU func9_TOT_Display; \
	MENU func9_TOT_Display_out; \
	MENU func9_TOT_Tab_s_tot_limits

#define USE_FUNC9_TOT_MANDATORY_A \
	USE_FUNC9_TOT_MANDATORY_BOTH; \
	MENU func9_TOT_Simple_Dialog_Mandatory_A; \
	MENU func9_TOT_Tab_s_mandatory_A; \
	MENU func9_TOT_Tab_m_mandatory_A

#define USE_FUNC9_TOT_MANDATORY_B \
	USE_FUNC9_TOT_MANDATORY_BOTH; \
	VARIABLE func9_TOT_CHANNEL; \
	MENU func9_TOT_CHANNEL_page; \
	COMMAND func9_TOT_CHANNEL_read; \
	COMMAND func9_TOT_CHANNEL_write; \
	VARIABLE func9_TOT_SET_TOT; \
	MENU func9_TOT_SET_TOT_page; \
	COMMAND func9_TOT_SET_TOT_read; \
	COMMAND func9_TOT_SET_TOT_write; \
	VARIABLE func9_TOT_MODE_TOT; \
	MENU func9_TOT_MODE_TOT_page; \
	COMMAND func9_TOT_MODE_TOT_read; \
	COMMAND func9_TOT_MODE_TOT_write; \
	VARIABLE func9_TOT_FAIL_TOT; \
	MENU func9_TOT_FAIL_TOT_page; \
	COMMAND func9_TOT_FAIL_TOT_read; \
	COMMAND func9_TOT_FAIL_TOT_write; \
	VARIABLE func9_TOT_PRESET_TOT; \
	MENU func9_TOT_PRESET_TOT_page; \
	COMMAND func9_TOT_PRESET_TOT_read; \
	COMMAND func9_TOT_PRESET_TOT_write; \
	COLLECTION func9_TOT_VIEW_1; \
	MENU func9_TOT_VIEW_1_page; \
	MENU func9_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func9_TOT_unit_2; \
	MENU func9_TOT_Reset; \
	MENU func9_TOT_Reset_page; \
	METHOD func9_TOT_Reset_totalizer; \
	METHOD func9_TOT_Preset_totalizer; \
	MENU func9_TOT_Tab_s_mandatory_B; \
	MENU func9_TOT_Tab_m_mandatory_B

#define USE_FUNC9_TOT_OPTIONAL_BOTH \
	COLLECTION func9_TOT_HI_HI_ALM; \
	VARIABLE func9_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func9_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func9_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func9_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func9_TOT_HI_HI_ALM_Value; \
	MENU func9_TOT_HI_HI_ALM_page; \
	COMMAND func9_TOT_HI_HI_ALM_read; \
	COLLECTION func9_TOT_HI_ALM; \
	VARIABLE func9_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func9_TOT_HI_ALM_Alarm_State; \
	VARIABLE func9_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func9_TOT_HI_ALM_Subcode; \
	VARIABLE func9_TOT_HI_ALM_Value; \
	MENU func9_TOT_HI_ALM_page; \
	COMMAND func9_TOT_HI_ALM_read; \
	COLLECTION func9_TOT_LO_ALM; \
	VARIABLE func9_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func9_TOT_LO_ALM_Alarm_State; \
	VARIABLE func9_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func9_TOT_LO_ALM_Subcode; \
	VARIABLE func9_TOT_LO_ALM_Value; \
	MENU func9_TOT_LO_ALM_page; \
	COMMAND func9_TOT_LO_ALM_read; \
	COLLECTION func9_TOT_LO_LO_ALM; \
	VARIABLE func9_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func9_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func9_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func9_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func9_TOT_LO_LO_ALM_Value; \
	MENU func9_TOT_LO_LO_ALM_page; \
	COMMAND func9_TOT_LO_LO_ALM_read

#define USE_FUNC9_TOT_OPTIONAL_A \
	USE_FUNC9_TOT_OPTIONAL_BOTH; \
	VARIABLE func9_TOT_CHANNEL; \
	MENU func9_TOT_CHANNEL_page; \
	COMMAND func9_TOT_CHANNEL_read; \
	COMMAND func9_TOT_CHANNEL_write; \
	VARIABLE func9_TOT_SET_TOT; \
	MENU func9_TOT_SET_TOT_page; \
	COMMAND func9_TOT_SET_TOT_read; \
	COMMAND func9_TOT_SET_TOT_write; \
	VARIABLE func9_TOT_MODE_TOT; \
	MENU func9_TOT_MODE_TOT_page; \
	COMMAND func9_TOT_MODE_TOT_read; \
	COMMAND func9_TOT_MODE_TOT_write; \
	VARIABLE func9_TOT_FAIL_TOT; \
	MENU func9_TOT_FAIL_TOT_page; \
	COMMAND func9_TOT_FAIL_TOT_read; \
	COMMAND func9_TOT_FAIL_TOT_write; \
	VARIABLE func9_TOT_PRESET_TOT; \
	MENU func9_TOT_PRESET_TOT_page; \
	COMMAND func9_TOT_PRESET_TOT_read; \
	COMMAND func9_TOT_PRESET_TOT_write; \
	COLLECTION func9_TOT_VIEW_1; \
	MENU func9_TOT_VIEW_1_page; \
	MENU func9_TOT_Simple_Dialog_Optional_A

#define USE_FUNC9_TOT_OPTIONAL_B \
	USE_FUNC9_TOT_OPTIONAL_BOTH; \
	MENU func9_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC9_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func9_TOT_)
#define USE_FUNC9_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func9_TOT_)
#define USE_FUNC9_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func9_TOT_)
#define USE_FUNC9_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func9_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC10_TOT_MANDATORY_BOTH \
	BLOCK func10_TOT_block; \
	COLLECTION func10_TOT_BLOCK_OBJECT; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func10_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func10_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func10_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func10_TOT_BLOCK_OBJECT_page; \
	COMMAND func10_TOT_BLOCK_OBJECT_read; \
	VARIABLE func10_TOT_ST_REV; \
	MENU func10_TOT_ST_REV_page; \
	COMMAND func10_TOT_ST_REV_read; \
	VARIABLE func10_TOT_TAG_DESC; \
	MENU func10_TOT_TAG_DESC_page; \
	COMMAND func10_TOT_TAG_DESC_read; \
	COMMAND func10_TOT_TAG_DESC_write; \
	VARIABLE func10_TOT_STRATEGY; \
	MENU func10_TOT_STRATEGY_page; \
	COMMAND func10_TOT_STRATEGY_read; \
	COMMAND func10_TOT_STRATEGY_write; \
	VARIABLE func10_TOT_ALERT_KEY; \
	MENU func10_TOT_ALERT_KEY_page; \
	COMMAND func10_TOT_ALERT_KEY_read; \
	COMMAND func10_TOT_ALERT_KEY_write; \
	VARIABLE func10_TOT_TARGET_MODE; \
	MENU func10_TOT_TARGET_MODE_page; \
	COMMAND func10_TOT_TARGET_MODE_read; \
	COMMAND func10_TOT_TARGET_MODE_write; \
	COLLECTION func10_TOT_MODE_BLK; \
	VARIABLE func10_TOT_MODE_BLK_Actual; \
	VARIABLE func10_TOT_MODE_BLK_Permitted; \
	VARIABLE func10_TOT_MODE_BLK_Normal; \
	MENU func10_TOT_MODE_BLK_page; \
	COMMAND func10_TOT_MODE_BLK_read; \
	COLLECTION func10_TOT_ALARM_SUM; \
	VARIABLE func10_TOT_ALARM_SUM_Current; \
	VARIABLE func10_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func10_TOT_ALARM_SUM_Unreported; \
	VARIABLE func10_TOT_ALARM_SUM_Disabled; \
	MENU func10_TOT_ALARM_SUM_page; \
	COMMAND func10_TOT_ALARM_SUM_read; \
	COLLECTION func10_TOT_BATCH; \
	VARIABLE func10_TOT_BATCH_Batch_ID; \
	VARIABLE func10_TOT_BATCH_Rup; \
	VARIABLE func10_TOT_BATCH_Operation; \
	VARIABLE func10_TOT_BATCH_Phase; \
	MENU func10_TOT_BATCH_page; \
	COMMAND func10_TOT_BATCH_read; \
	COMMAND func10_TOT_BATCH_write; \
	COLLECTION func10_TOT_TOTAL; \
	VARIABLE func10_TOT_TOTAL_Value; \
	VARIABLE func10_TOT_TOTAL_Status_Quality; \
	VARIABLE func10_TOT_TOTAL_Status_Limit; \
	MENU func10_TOT_TOTAL_page; \
	COMMAND func10_TOT_TOTAL_read; \
	COMMAND func10_TOT_TOTAL_write; \
	VARIABLE func10_TOT_UNIT_TOT; \
	MENU func10_TOT_UNIT_TOT_page; \
	COMMAND func10_TOT_UNIT_TOT_read; \
	COMMAND func10_TOT_UNIT_TOT_write; \
	VARIABLE func10_TOT_ALARM_HYS; \
	MENU func10_TOT_ALARM_HYS_page; \
	COMMAND func10_TOT_ALARM_HYS_read; \
	COMMAND func10_TOT_ALARM_HYS_write; \
	VARIABLE func10_TOT_HI_HI_LIM; \
	MENU func10_TOT_HI_HI_LIM_page; \
	COMMAND func10_TOT_HI_HI_LIM_read; \
	COMMAND func10_TOT_HI_HI_LIM_write; \
	VARIABLE func10_TOT_HI_LIM; \
	MENU func10_TOT_HI_LIM_page; \
	COMMAND func10_TOT_HI_LIM_read; \
	COMMAND func10_TOT_HI_LIM_write; \
	VARIABLE func10_TOT_LO_LIM; \
	MENU func10_TOT_LO_LIM_page; \
	COMMAND func10_TOT_LO_LIM_read; \
	COMMAND func10_TOT_LO_LIM_write; \
	VARIABLE func10_TOT_LO_LO_LIM; \
	MENU func10_TOT_LO_LO_LIM_page; \
	COMMAND func10_TOT_LO_LO_LIM_read; \
	COMMAND func10_TOT_LO_LO_LIM_write; \
	UNIT func10_TOT_unit_1; \
	MENU func10_TOT_Display; \
	MENU func10_TOT_Display_out; \
	MENU func10_TOT_Tab_s_tot_limits

#define USE_FUNC10_TOT_MANDATORY_A \
	USE_FUNC10_TOT_MANDATORY_BOTH; \
	MENU func10_TOT_Simple_Dialog_Mandatory_A; \
	MENU func10_TOT_Tab_s_mandatory_A; \
	MENU func10_TOT_Tab_m_mandatory_A

#define USE_FUNC10_TOT_MANDATORY_B \
	USE_FUNC10_TOT_MANDATORY_BOTH; \
	VARIABLE func10_TOT_CHANNEL; \
	MENU func10_TOT_CHANNEL_page; \
	COMMAND func10_TOT_CHANNEL_read; \
	COMMAND func10_TOT_CHANNEL_write; \
	VARIABLE func10_TOT_SET_TOT; \
	MENU func10_TOT_SET_TOT_page; \
	COMMAND func10_TOT_SET_TOT_read; \
	COMMAND func10_TOT_SET_TOT_write; \
	VARIABLE func10_TOT_MODE_TOT; \
	MENU func10_TOT_MODE_TOT_page; \
	COMMAND func10_TOT_MODE_TOT_read; \
	COMMAND func10_TOT_MODE_TOT_write; \
	VARIABLE func10_TOT_FAIL_TOT; \
	MENU func10_TOT_FAIL_TOT_page; \
	COMMAND func10_TOT_FAIL_TOT_read; \
	COMMAND func10_TOT_FAIL_TOT_write; \
	VARIABLE func10_TOT_PRESET_TOT; \
	MENU func10_TOT_PRESET_TOT_page; \
	COMMAND func10_TOT_PRESET_TOT_read; \
	COMMAND func10_TOT_PRESET_TOT_write; \
	COLLECTION func10_TOT_VIEW_1; \
	MENU func10_TOT_VIEW_1_page; \
	MENU func10_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func10_TOT_unit_2; \
	MENU func10_TOT_Reset; \
	MENU func10_TOT_Reset_page; \
	METHOD func10_TOT_Reset_totalizer; \
	METHOD func10_TOT_Preset_totalizer; \
	MENU func10_TOT_Tab_s_mandatory_B; \
	MENU func10_TOT_Tab_m_mandatory_B

#define USE_FUNC10_TOT_OPTIONAL_BOTH \
	COLLECTION func10_TOT_HI_HI_ALM; \
	VARIABLE func10_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func10_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func10_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func10_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func10_TOT_HI_HI_ALM_Value; \
	MENU func10_TOT_HI_HI_ALM_page; \
	COMMAND func10_TOT_HI_HI_ALM_read; \
	COLLECTION func10_TOT_HI_ALM; \
	VARIABLE func10_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func10_TOT_HI_ALM_Alarm_State; \
	VARIABLE func10_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func10_TOT_HI_ALM_Subcode; \
	VARIABLE func10_TOT_HI_ALM_Value; \
	MENU func10_TOT_HI_ALM_page; \
	COMMAND func10_TOT_HI_ALM_read; \
	COLLECTION func10_TOT_LO_ALM; \
	VARIABLE func10_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func10_TOT_LO_ALM_Alarm_State; \
	VARIABLE func10_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func10_TOT_LO_ALM_Subcode; \
	VARIABLE func10_TOT_LO_ALM_Value; \
	MENU func10_TOT_LO_ALM_page; \
	COMMAND func10_TOT_LO_ALM_read; \
	COLLECTION func10_TOT_LO_LO_ALM; \
	VARIABLE func10_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func10_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func10_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func10_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func10_TOT_LO_LO_ALM_Value; \
	MENU func10_TOT_LO_LO_ALM_page; \
	COMMAND func10_TOT_LO_LO_ALM_read

#define USE_FUNC10_TOT_OPTIONAL_A \
	USE_FUNC10_TOT_OPTIONAL_BOTH; \
	VARIABLE func10_TOT_CHANNEL; \
	MENU func10_TOT_CHANNEL_page; \
	COMMAND func10_TOT_CHANNEL_read; \
	COMMAND func10_TOT_CHANNEL_write; \
	VARIABLE func10_TOT_SET_TOT; \
	MENU func10_TOT_SET_TOT_page; \
	COMMAND func10_TOT_SET_TOT_read; \
	COMMAND func10_TOT_SET_TOT_write; \
	VARIABLE func10_TOT_MODE_TOT; \
	MENU func10_TOT_MODE_TOT_page; \
	COMMAND func10_TOT_MODE_TOT_read; \
	COMMAND func10_TOT_MODE_TOT_write; \
	VARIABLE func10_TOT_FAIL_TOT; \
	MENU func10_TOT_FAIL_TOT_page; \
	COMMAND func10_TOT_FAIL_TOT_read; \
	COMMAND func10_TOT_FAIL_TOT_write; \
	VARIABLE func10_TOT_PRESET_TOT; \
	MENU func10_TOT_PRESET_TOT_page; \
	COMMAND func10_TOT_PRESET_TOT_read; \
	COMMAND func10_TOT_PRESET_TOT_write; \
	COLLECTION func10_TOT_VIEW_1; \
	MENU func10_TOT_VIEW_1_page; \
	MENU func10_TOT_Simple_Dialog_Optional_A

#define USE_FUNC10_TOT_OPTIONAL_B \
	USE_FUNC10_TOT_OPTIONAL_BOTH; \
	MENU func10_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC10_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func10_TOT_)
#define USE_FUNC10_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func10_TOT_)
#define USE_FUNC10_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func10_TOT_)
#define USE_FUNC10_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func10_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC11_TOT_MANDATORY_BOTH \
	BLOCK func11_TOT_block; \
	COLLECTION func11_TOT_BLOCK_OBJECT; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func11_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func11_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func11_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func11_TOT_BLOCK_OBJECT_page; \
	COMMAND func11_TOT_BLOCK_OBJECT_read; \
	VARIABLE func11_TOT_ST_REV; \
	MENU func11_TOT_ST_REV_page; \
	COMMAND func11_TOT_ST_REV_read; \
	VARIABLE func11_TOT_TAG_DESC; \
	MENU func11_TOT_TAG_DESC_page; \
	COMMAND func11_TOT_TAG_DESC_read; \
	COMMAND func11_TOT_TAG_DESC_write; \
	VARIABLE func11_TOT_STRATEGY; \
	MENU func11_TOT_STRATEGY_page; \
	COMMAND func11_TOT_STRATEGY_read; \
	COMMAND func11_TOT_STRATEGY_write; \
	VARIABLE func11_TOT_ALERT_KEY; \
	MENU func11_TOT_ALERT_KEY_page; \
	COMMAND func11_TOT_ALERT_KEY_read; \
	COMMAND func11_TOT_ALERT_KEY_write; \
	VARIABLE func11_TOT_TARGET_MODE; \
	MENU func11_TOT_TARGET_MODE_page; \
	COMMAND func11_TOT_TARGET_MODE_read; \
	COMMAND func11_TOT_TARGET_MODE_write; \
	COLLECTION func11_TOT_MODE_BLK; \
	VARIABLE func11_TOT_MODE_BLK_Actual; \
	VARIABLE func11_TOT_MODE_BLK_Permitted; \
	VARIABLE func11_TOT_MODE_BLK_Normal; \
	MENU func11_TOT_MODE_BLK_page; \
	COMMAND func11_TOT_MODE_BLK_read; \
	COLLECTION func11_TOT_ALARM_SUM; \
	VARIABLE func11_TOT_ALARM_SUM_Current; \
	VARIABLE func11_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func11_TOT_ALARM_SUM_Unreported; \
	VARIABLE func11_TOT_ALARM_SUM_Disabled; \
	MENU func11_TOT_ALARM_SUM_page; \
	COMMAND func11_TOT_ALARM_SUM_read; \
	COLLECTION func11_TOT_BATCH; \
	VARIABLE func11_TOT_BATCH_Batch_ID; \
	VARIABLE func11_TOT_BATCH_Rup; \
	VARIABLE func11_TOT_BATCH_Operation; \
	VARIABLE func11_TOT_BATCH_Phase; \
	MENU func11_TOT_BATCH_page; \
	COMMAND func11_TOT_BATCH_read; \
	COMMAND func11_TOT_BATCH_write; \
	COLLECTION func11_TOT_TOTAL; \
	VARIABLE func11_TOT_TOTAL_Value; \
	VARIABLE func11_TOT_TOTAL_Status_Quality; \
	VARIABLE func11_TOT_TOTAL_Status_Limit; \
	MENU func11_TOT_TOTAL_page; \
	COMMAND func11_TOT_TOTAL_read; \
	COMMAND func11_TOT_TOTAL_write; \
	VARIABLE func11_TOT_UNIT_TOT; \
	MENU func11_TOT_UNIT_TOT_page; \
	COMMAND func11_TOT_UNIT_TOT_read; \
	COMMAND func11_TOT_UNIT_TOT_write; \
	VARIABLE func11_TOT_ALARM_HYS; \
	MENU func11_TOT_ALARM_HYS_page; \
	COMMAND func11_TOT_ALARM_HYS_read; \
	COMMAND func11_TOT_ALARM_HYS_write; \
	VARIABLE func11_TOT_HI_HI_LIM; \
	MENU func11_TOT_HI_HI_LIM_page; \
	COMMAND func11_TOT_HI_HI_LIM_read; \
	COMMAND func11_TOT_HI_HI_LIM_write; \
	VARIABLE func11_TOT_HI_LIM; \
	MENU func11_TOT_HI_LIM_page; \
	COMMAND func11_TOT_HI_LIM_read; \
	COMMAND func11_TOT_HI_LIM_write; \
	VARIABLE func11_TOT_LO_LIM; \
	MENU func11_TOT_LO_LIM_page; \
	COMMAND func11_TOT_LO_LIM_read; \
	COMMAND func11_TOT_LO_LIM_write; \
	VARIABLE func11_TOT_LO_LO_LIM; \
	MENU func11_TOT_LO_LO_LIM_page; \
	COMMAND func11_TOT_LO_LO_LIM_read; \
	COMMAND func11_TOT_LO_LO_LIM_write; \
	UNIT func11_TOT_unit_1; \
	MENU func11_TOT_Display; \
	MENU func11_TOT_Display_out; \
	MENU func11_TOT_Tab_s_tot_limits

#define USE_FUNC11_TOT_MANDATORY_A \
	USE_FUNC11_TOT_MANDATORY_BOTH; \
	MENU func11_TOT_Simple_Dialog_Mandatory_A; \
	MENU func11_TOT_Tab_s_mandatory_A; \
	MENU func11_TOT_Tab_m_mandatory_A

#define USE_FUNC11_TOT_MANDATORY_B \
	USE_FUNC11_TOT_MANDATORY_BOTH; \
	VARIABLE func11_TOT_CHANNEL; \
	MENU func11_TOT_CHANNEL_page; \
	COMMAND func11_TOT_CHANNEL_read; \
	COMMAND func11_TOT_CHANNEL_write; \
	VARIABLE func11_TOT_SET_TOT; \
	MENU func11_TOT_SET_TOT_page; \
	COMMAND func11_TOT_SET_TOT_read; \
	COMMAND func11_TOT_SET_TOT_write; \
	VARIABLE func11_TOT_MODE_TOT; \
	MENU func11_TOT_MODE_TOT_page; \
	COMMAND func11_TOT_MODE_TOT_read; \
	COMMAND func11_TOT_MODE_TOT_write; \
	VARIABLE func11_TOT_FAIL_TOT; \
	MENU func11_TOT_FAIL_TOT_page; \
	COMMAND func11_TOT_FAIL_TOT_read; \
	COMMAND func11_TOT_FAIL_TOT_write; \
	VARIABLE func11_TOT_PRESET_TOT; \
	MENU func11_TOT_PRESET_TOT_page; \
	COMMAND func11_TOT_PRESET_TOT_read; \
	COMMAND func11_TOT_PRESET_TOT_write; \
	COLLECTION func11_TOT_VIEW_1; \
	MENU func11_TOT_VIEW_1_page; \
	MENU func11_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func11_TOT_unit_2; \
	MENU func11_TOT_Reset; \
	MENU func11_TOT_Reset_page; \
	METHOD func11_TOT_Reset_totalizer; \
	METHOD func11_TOT_Preset_totalizer; \
	MENU func11_TOT_Tab_s_mandatory_B; \
	MENU func11_TOT_Tab_m_mandatory_B

#define USE_FUNC11_TOT_OPTIONAL_BOTH \
	COLLECTION func11_TOT_HI_HI_ALM; \
	VARIABLE func11_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func11_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func11_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func11_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func11_TOT_HI_HI_ALM_Value; \
	MENU func11_TOT_HI_HI_ALM_page; \
	COMMAND func11_TOT_HI_HI_ALM_read; \
	COLLECTION func11_TOT_HI_ALM; \
	VARIABLE func11_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func11_TOT_HI_ALM_Alarm_State; \
	VARIABLE func11_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func11_TOT_HI_ALM_Subcode; \
	VARIABLE func11_TOT_HI_ALM_Value; \
	MENU func11_TOT_HI_ALM_page; \
	COMMAND func11_TOT_HI_ALM_read; \
	COLLECTION func11_TOT_LO_ALM; \
	VARIABLE func11_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func11_TOT_LO_ALM_Alarm_State; \
	VARIABLE func11_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func11_TOT_LO_ALM_Subcode; \
	VARIABLE func11_TOT_LO_ALM_Value; \
	MENU func11_TOT_LO_ALM_page; \
	COMMAND func11_TOT_LO_ALM_read; \
	COLLECTION func11_TOT_LO_LO_ALM; \
	VARIABLE func11_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func11_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func11_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func11_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func11_TOT_LO_LO_ALM_Value; \
	MENU func11_TOT_LO_LO_ALM_page; \
	COMMAND func11_TOT_LO_LO_ALM_read

#define USE_FUNC11_TOT_OPTIONAL_A \
	USE_FUNC11_TOT_OPTIONAL_BOTH; \
	VARIABLE func11_TOT_CHANNEL; \
	MENU func11_TOT_CHANNEL_page; \
	COMMAND func11_TOT_CHANNEL_read; \
	COMMAND func11_TOT_CHANNEL_write; \
	VARIABLE func11_TOT_SET_TOT; \
	MENU func11_TOT_SET_TOT_page; \
	COMMAND func11_TOT_SET_TOT_read; \
	COMMAND func11_TOT_SET_TOT_write; \
	VARIABLE func11_TOT_MODE_TOT; \
	MENU func11_TOT_MODE_TOT_page; \
	COMMAND func11_TOT_MODE_TOT_read; \
	COMMAND func11_TOT_MODE_TOT_write; \
	VARIABLE func11_TOT_FAIL_TOT; \
	MENU func11_TOT_FAIL_TOT_page; \
	COMMAND func11_TOT_FAIL_TOT_read; \
	COMMAND func11_TOT_FAIL_TOT_write; \
	VARIABLE func11_TOT_PRESET_TOT; \
	MENU func11_TOT_PRESET_TOT_page; \
	COMMAND func11_TOT_PRESET_TOT_read; \
	COMMAND func11_TOT_PRESET_TOT_write; \
	COLLECTION func11_TOT_VIEW_1; \
	MENU func11_TOT_VIEW_1_page; \
	MENU func11_TOT_Simple_Dialog_Optional_A

#define USE_FUNC11_TOT_OPTIONAL_B \
	USE_FUNC11_TOT_OPTIONAL_BOTH; \
	MENU func11_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC11_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func11_TOT_)
#define USE_FUNC11_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func11_TOT_)
#define USE_FUNC11_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func11_TOT_)
#define USE_FUNC11_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func11_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC12_TOT_MANDATORY_BOTH \
	BLOCK func12_TOT_block; \
	COLLECTION func12_TOT_BLOCK_OBJECT; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func12_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func12_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func12_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func12_TOT_BLOCK_OBJECT_page; \
	COMMAND func12_TOT_BLOCK_OBJECT_read; \
	VARIABLE func12_TOT_ST_REV; \
	MENU func12_TOT_ST_REV_page; \
	COMMAND func12_TOT_ST_REV_read; \
	VARIABLE func12_TOT_TAG_DESC; \
	MENU func12_TOT_TAG_DESC_page; \
	COMMAND func12_TOT_TAG_DESC_read; \
	COMMAND func12_TOT_TAG_DESC_write; \
	VARIABLE func12_TOT_STRATEGY; \
	MENU func12_TOT_STRATEGY_page; \
	COMMAND func12_TOT_STRATEGY_read; \
	COMMAND func12_TOT_STRATEGY_write; \
	VARIABLE func12_TOT_ALERT_KEY; \
	MENU func12_TOT_ALERT_KEY_page; \
	COMMAND func12_TOT_ALERT_KEY_read; \
	COMMAND func12_TOT_ALERT_KEY_write; \
	VARIABLE func12_TOT_TARGET_MODE; \
	MENU func12_TOT_TARGET_MODE_page; \
	COMMAND func12_TOT_TARGET_MODE_read; \
	COMMAND func12_TOT_TARGET_MODE_write; \
	COLLECTION func12_TOT_MODE_BLK; \
	VARIABLE func12_TOT_MODE_BLK_Actual; \
	VARIABLE func12_TOT_MODE_BLK_Permitted; \
	VARIABLE func12_TOT_MODE_BLK_Normal; \
	MENU func12_TOT_MODE_BLK_page; \
	COMMAND func12_TOT_MODE_BLK_read; \
	COLLECTION func12_TOT_ALARM_SUM; \
	VARIABLE func12_TOT_ALARM_SUM_Current; \
	VARIABLE func12_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func12_TOT_ALARM_SUM_Unreported; \
	VARIABLE func12_TOT_ALARM_SUM_Disabled; \
	MENU func12_TOT_ALARM_SUM_page; \
	COMMAND func12_TOT_ALARM_SUM_read; \
	COLLECTION func12_TOT_BATCH; \
	VARIABLE func12_TOT_BATCH_Batch_ID; \
	VARIABLE func12_TOT_BATCH_Rup; \
	VARIABLE func12_TOT_BATCH_Operation; \
	VARIABLE func12_TOT_BATCH_Phase; \
	MENU func12_TOT_BATCH_page; \
	COMMAND func12_TOT_BATCH_read; \
	COMMAND func12_TOT_BATCH_write; \
	COLLECTION func12_TOT_TOTAL; \
	VARIABLE func12_TOT_TOTAL_Value; \
	VARIABLE func12_TOT_TOTAL_Status_Quality; \
	VARIABLE func12_TOT_TOTAL_Status_Limit; \
	MENU func12_TOT_TOTAL_page; \
	COMMAND func12_TOT_TOTAL_read; \
	COMMAND func12_TOT_TOTAL_write; \
	VARIABLE func12_TOT_UNIT_TOT; \
	MENU func12_TOT_UNIT_TOT_page; \
	COMMAND func12_TOT_UNIT_TOT_read; \
	COMMAND func12_TOT_UNIT_TOT_write; \
	VARIABLE func12_TOT_ALARM_HYS; \
	MENU func12_TOT_ALARM_HYS_page; \
	COMMAND func12_TOT_ALARM_HYS_read; \
	COMMAND func12_TOT_ALARM_HYS_write; \
	VARIABLE func12_TOT_HI_HI_LIM; \
	MENU func12_TOT_HI_HI_LIM_page; \
	COMMAND func12_TOT_HI_HI_LIM_read; \
	COMMAND func12_TOT_HI_HI_LIM_write; \
	VARIABLE func12_TOT_HI_LIM; \
	MENU func12_TOT_HI_LIM_page; \
	COMMAND func12_TOT_HI_LIM_read; \
	COMMAND func12_TOT_HI_LIM_write; \
	VARIABLE func12_TOT_LO_LIM; \
	MENU func12_TOT_LO_LIM_page; \
	COMMAND func12_TOT_LO_LIM_read; \
	COMMAND func12_TOT_LO_LIM_write; \
	VARIABLE func12_TOT_LO_LO_LIM; \
	MENU func12_TOT_LO_LO_LIM_page; \
	COMMAND func12_TOT_LO_LO_LIM_read; \
	COMMAND func12_TOT_LO_LO_LIM_write; \
	UNIT func12_TOT_unit_1; \
	MENU func12_TOT_Display; \
	MENU func12_TOT_Display_out; \
	MENU func12_TOT_Tab_s_tot_limits

#define USE_FUNC12_TOT_MANDATORY_A \
	USE_FUNC12_TOT_MANDATORY_BOTH; \
	MENU func12_TOT_Simple_Dialog_Mandatory_A; \
	MENU func12_TOT_Tab_s_mandatory_A; \
	MENU func12_TOT_Tab_m_mandatory_A

#define USE_FUNC12_TOT_MANDATORY_B \
	USE_FUNC12_TOT_MANDATORY_BOTH; \
	VARIABLE func12_TOT_CHANNEL; \
	MENU func12_TOT_CHANNEL_page; \
	COMMAND func12_TOT_CHANNEL_read; \
	COMMAND func12_TOT_CHANNEL_write; \
	VARIABLE func12_TOT_SET_TOT; \
	MENU func12_TOT_SET_TOT_page; \
	COMMAND func12_TOT_SET_TOT_read; \
	COMMAND func12_TOT_SET_TOT_write; \
	VARIABLE func12_TOT_MODE_TOT; \
	MENU func12_TOT_MODE_TOT_page; \
	COMMAND func12_TOT_MODE_TOT_read; \
	COMMAND func12_TOT_MODE_TOT_write; \
	VARIABLE func12_TOT_FAIL_TOT; \
	MENU func12_TOT_FAIL_TOT_page; \
	COMMAND func12_TOT_FAIL_TOT_read; \
	COMMAND func12_TOT_FAIL_TOT_write; \
	VARIABLE func12_TOT_PRESET_TOT; \
	MENU func12_TOT_PRESET_TOT_page; \
	COMMAND func12_TOT_PRESET_TOT_read; \
	COMMAND func12_TOT_PRESET_TOT_write; \
	COLLECTION func12_TOT_VIEW_1; \
	MENU func12_TOT_VIEW_1_page; \
	MENU func12_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func12_TOT_unit_2; \
	MENU func12_TOT_Reset; \
	MENU func12_TOT_Reset_page; \
	METHOD func12_TOT_Reset_totalizer; \
	METHOD func12_TOT_Preset_totalizer; \
	MENU func12_TOT_Tab_s_mandatory_B; \
	MENU func12_TOT_Tab_m_mandatory_B

#define USE_FUNC12_TOT_OPTIONAL_BOTH \
	COLLECTION func12_TOT_HI_HI_ALM; \
	VARIABLE func12_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func12_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func12_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func12_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func12_TOT_HI_HI_ALM_Value; \
	MENU func12_TOT_HI_HI_ALM_page; \
	COMMAND func12_TOT_HI_HI_ALM_read; \
	COLLECTION func12_TOT_HI_ALM; \
	VARIABLE func12_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func12_TOT_HI_ALM_Alarm_State; \
	VARIABLE func12_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func12_TOT_HI_ALM_Subcode; \
	VARIABLE func12_TOT_HI_ALM_Value; \
	MENU func12_TOT_HI_ALM_page; \
	COMMAND func12_TOT_HI_ALM_read; \
	COLLECTION func12_TOT_LO_ALM; \
	VARIABLE func12_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func12_TOT_LO_ALM_Alarm_State; \
	VARIABLE func12_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func12_TOT_LO_ALM_Subcode; \
	VARIABLE func12_TOT_LO_ALM_Value; \
	MENU func12_TOT_LO_ALM_page; \
	COMMAND func12_TOT_LO_ALM_read; \
	COLLECTION func12_TOT_LO_LO_ALM; \
	VARIABLE func12_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func12_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func12_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func12_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func12_TOT_LO_LO_ALM_Value; \
	MENU func12_TOT_LO_LO_ALM_page; \
	COMMAND func12_TOT_LO_LO_ALM_read

#define USE_FUNC12_TOT_OPTIONAL_A \
	USE_FUNC12_TOT_OPTIONAL_BOTH; \
	VARIABLE func12_TOT_CHANNEL; \
	MENU func12_TOT_CHANNEL_page; \
	COMMAND func12_TOT_CHANNEL_read; \
	COMMAND func12_TOT_CHANNEL_write; \
	VARIABLE func12_TOT_SET_TOT; \
	MENU func12_TOT_SET_TOT_page; \
	COMMAND func12_TOT_SET_TOT_read; \
	COMMAND func12_TOT_SET_TOT_write; \
	VARIABLE func12_TOT_MODE_TOT; \
	MENU func12_TOT_MODE_TOT_page; \
	COMMAND func12_TOT_MODE_TOT_read; \
	COMMAND func12_TOT_MODE_TOT_write; \
	VARIABLE func12_TOT_FAIL_TOT; \
	MENU func12_TOT_FAIL_TOT_page; \
	COMMAND func12_TOT_FAIL_TOT_read; \
	COMMAND func12_TOT_FAIL_TOT_write; \
	VARIABLE func12_TOT_PRESET_TOT; \
	MENU func12_TOT_PRESET_TOT_page; \
	COMMAND func12_TOT_PRESET_TOT_read; \
	COMMAND func12_TOT_PRESET_TOT_write; \
	COLLECTION func12_TOT_VIEW_1; \
	MENU func12_TOT_VIEW_1_page; \
	MENU func12_TOT_Simple_Dialog_Optional_A

#define USE_FUNC12_TOT_OPTIONAL_B \
	USE_FUNC12_TOT_OPTIONAL_BOTH; \
	MENU func12_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC12_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func12_TOT_)
#define USE_FUNC12_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func12_TOT_)
#define USE_FUNC12_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func12_TOT_)
#define USE_FUNC12_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func12_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC13_TOT_MANDATORY_BOTH \
	BLOCK func13_TOT_block; \
	COLLECTION func13_TOT_BLOCK_OBJECT; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func13_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func13_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func13_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func13_TOT_BLOCK_OBJECT_page; \
	COMMAND func13_TOT_BLOCK_OBJECT_read; \
	VARIABLE func13_TOT_ST_REV; \
	MENU func13_TOT_ST_REV_page; \
	COMMAND func13_TOT_ST_REV_read; \
	VARIABLE func13_TOT_TAG_DESC; \
	MENU func13_TOT_TAG_DESC_page; \
	COMMAND func13_TOT_TAG_DESC_read; \
	COMMAND func13_TOT_TAG_DESC_write; \
	VARIABLE func13_TOT_STRATEGY; \
	MENU func13_TOT_STRATEGY_page; \
	COMMAND func13_TOT_STRATEGY_read; \
	COMMAND func13_TOT_STRATEGY_write; \
	VARIABLE func13_TOT_ALERT_KEY; \
	MENU func13_TOT_ALERT_KEY_page; \
	COMMAND func13_TOT_ALERT_KEY_read; \
	COMMAND func13_TOT_ALERT_KEY_write; \
	VARIABLE func13_TOT_TARGET_MODE; \
	MENU func13_TOT_TARGET_MODE_page; \
	COMMAND func13_TOT_TARGET_MODE_read; \
	COMMAND func13_TOT_TARGET_MODE_write; \
	COLLECTION func13_TOT_MODE_BLK; \
	VARIABLE func13_TOT_MODE_BLK_Actual; \
	VARIABLE func13_TOT_MODE_BLK_Permitted; \
	VARIABLE func13_TOT_MODE_BLK_Normal; \
	MENU func13_TOT_MODE_BLK_page; \
	COMMAND func13_TOT_MODE_BLK_read; \
	COLLECTION func13_TOT_ALARM_SUM; \
	VARIABLE func13_TOT_ALARM_SUM_Current; \
	VARIABLE func13_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func13_TOT_ALARM_SUM_Unreported; \
	VARIABLE func13_TOT_ALARM_SUM_Disabled; \
	MENU func13_TOT_ALARM_SUM_page; \
	COMMAND func13_TOT_ALARM_SUM_read; \
	COLLECTION func13_TOT_BATCH; \
	VARIABLE func13_TOT_BATCH_Batch_ID; \
	VARIABLE func13_TOT_BATCH_Rup; \
	VARIABLE func13_TOT_BATCH_Operation; \
	VARIABLE func13_TOT_BATCH_Phase; \
	MENU func13_TOT_BATCH_page; \
	COMMAND func13_TOT_BATCH_read; \
	COMMAND func13_TOT_BATCH_write; \
	COLLECTION func13_TOT_TOTAL; \
	VARIABLE func13_TOT_TOTAL_Value; \
	VARIABLE func13_TOT_TOTAL_Status_Quality; \
	VARIABLE func13_TOT_TOTAL_Status_Limit; \
	MENU func13_TOT_TOTAL_page; \
	COMMAND func13_TOT_TOTAL_read; \
	COMMAND func13_TOT_TOTAL_write; \
	VARIABLE func13_TOT_UNIT_TOT; \
	MENU func13_TOT_UNIT_TOT_page; \
	COMMAND func13_TOT_UNIT_TOT_read; \
	COMMAND func13_TOT_UNIT_TOT_write; \
	VARIABLE func13_TOT_ALARM_HYS; \
	MENU func13_TOT_ALARM_HYS_page; \
	COMMAND func13_TOT_ALARM_HYS_read; \
	COMMAND func13_TOT_ALARM_HYS_write; \
	VARIABLE func13_TOT_HI_HI_LIM; \
	MENU func13_TOT_HI_HI_LIM_page; \
	COMMAND func13_TOT_HI_HI_LIM_read; \
	COMMAND func13_TOT_HI_HI_LIM_write; \
	VARIABLE func13_TOT_HI_LIM; \
	MENU func13_TOT_HI_LIM_page; \
	COMMAND func13_TOT_HI_LIM_read; \
	COMMAND func13_TOT_HI_LIM_write; \
	VARIABLE func13_TOT_LO_LIM; \
	MENU func13_TOT_LO_LIM_page; \
	COMMAND func13_TOT_LO_LIM_read; \
	COMMAND func13_TOT_LO_LIM_write; \
	VARIABLE func13_TOT_LO_LO_LIM; \
	MENU func13_TOT_LO_LO_LIM_page; \
	COMMAND func13_TOT_LO_LO_LIM_read; \
	COMMAND func13_TOT_LO_LO_LIM_write; \
	UNIT func13_TOT_unit_1; \
	MENU func13_TOT_Display; \
	MENU func13_TOT_Display_out; \
	MENU func13_TOT_Tab_s_tot_limits

#define USE_FUNC13_TOT_MANDATORY_A \
	USE_FUNC13_TOT_MANDATORY_BOTH; \
	MENU func13_TOT_Simple_Dialog_Mandatory_A; \
	MENU func13_TOT_Tab_s_mandatory_A; \
	MENU func13_TOT_Tab_m_mandatory_A

#define USE_FUNC13_TOT_MANDATORY_B \
	USE_FUNC13_TOT_MANDATORY_BOTH; \
	VARIABLE func13_TOT_CHANNEL; \
	MENU func13_TOT_CHANNEL_page; \
	COMMAND func13_TOT_CHANNEL_read; \
	COMMAND func13_TOT_CHANNEL_write; \
	VARIABLE func13_TOT_SET_TOT; \
	MENU func13_TOT_SET_TOT_page; \
	COMMAND func13_TOT_SET_TOT_read; \
	COMMAND func13_TOT_SET_TOT_write; \
	VARIABLE func13_TOT_MODE_TOT; \
	MENU func13_TOT_MODE_TOT_page; \
	COMMAND func13_TOT_MODE_TOT_read; \
	COMMAND func13_TOT_MODE_TOT_write; \
	VARIABLE func13_TOT_FAIL_TOT; \
	MENU func13_TOT_FAIL_TOT_page; \
	COMMAND func13_TOT_FAIL_TOT_read; \
	COMMAND func13_TOT_FAIL_TOT_write; \
	VARIABLE func13_TOT_PRESET_TOT; \
	MENU func13_TOT_PRESET_TOT_page; \
	COMMAND func13_TOT_PRESET_TOT_read; \
	COMMAND func13_TOT_PRESET_TOT_write; \
	COLLECTION func13_TOT_VIEW_1; \
	MENU func13_TOT_VIEW_1_page; \
	MENU func13_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func13_TOT_unit_2; \
	MENU func13_TOT_Reset; \
	MENU func13_TOT_Reset_page; \
	METHOD func13_TOT_Reset_totalizer; \
	METHOD func13_TOT_Preset_totalizer; \
	MENU func13_TOT_Tab_s_mandatory_B; \
	MENU func13_TOT_Tab_m_mandatory_B

#define USE_FUNC13_TOT_OPTIONAL_BOTH \
	COLLECTION func13_TOT_HI_HI_ALM; \
	VARIABLE func13_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func13_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func13_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func13_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func13_TOT_HI_HI_ALM_Value; \
	MENU func13_TOT_HI_HI_ALM_page; \
	COMMAND func13_TOT_HI_HI_ALM_read; \
	COLLECTION func13_TOT_HI_ALM; \
	VARIABLE func13_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func13_TOT_HI_ALM_Alarm_State; \
	VARIABLE func13_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func13_TOT_HI_ALM_Subcode; \
	VARIABLE func13_TOT_HI_ALM_Value; \
	MENU func13_TOT_HI_ALM_page; \
	COMMAND func13_TOT_HI_ALM_read; \
	COLLECTION func13_TOT_LO_ALM; \
	VARIABLE func13_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func13_TOT_LO_ALM_Alarm_State; \
	VARIABLE func13_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func13_TOT_LO_ALM_Subcode; \
	VARIABLE func13_TOT_LO_ALM_Value; \
	MENU func13_TOT_LO_ALM_page; \
	COMMAND func13_TOT_LO_ALM_read; \
	COLLECTION func13_TOT_LO_LO_ALM; \
	VARIABLE func13_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func13_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func13_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func13_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func13_TOT_LO_LO_ALM_Value; \
	MENU func13_TOT_LO_LO_ALM_page; \
	COMMAND func13_TOT_LO_LO_ALM_read

#define USE_FUNC13_TOT_OPTIONAL_A \
	USE_FUNC13_TOT_OPTIONAL_BOTH; \
	VARIABLE func13_TOT_CHANNEL; \
	MENU func13_TOT_CHANNEL_page; \
	COMMAND func13_TOT_CHANNEL_read; \
	COMMAND func13_TOT_CHANNEL_write; \
	VARIABLE func13_TOT_SET_TOT; \
	MENU func13_TOT_SET_TOT_page; \
	COMMAND func13_TOT_SET_TOT_read; \
	COMMAND func13_TOT_SET_TOT_write; \
	VARIABLE func13_TOT_MODE_TOT; \
	MENU func13_TOT_MODE_TOT_page; \
	COMMAND func13_TOT_MODE_TOT_read; \
	COMMAND func13_TOT_MODE_TOT_write; \
	VARIABLE func13_TOT_FAIL_TOT; \
	MENU func13_TOT_FAIL_TOT_page; \
	COMMAND func13_TOT_FAIL_TOT_read; \
	COMMAND func13_TOT_FAIL_TOT_write; \
	VARIABLE func13_TOT_PRESET_TOT; \
	MENU func13_TOT_PRESET_TOT_page; \
	COMMAND func13_TOT_PRESET_TOT_read; \
	COMMAND func13_TOT_PRESET_TOT_write; \
	COLLECTION func13_TOT_VIEW_1; \
	MENU func13_TOT_VIEW_1_page; \
	MENU func13_TOT_Simple_Dialog_Optional_A

#define USE_FUNC13_TOT_OPTIONAL_B \
	USE_FUNC13_TOT_OPTIONAL_BOTH; \
	MENU func13_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC13_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func13_TOT_)
#define USE_FUNC13_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func13_TOT_)
#define USE_FUNC13_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func13_TOT_)
#define USE_FUNC13_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func13_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC14_TOT_MANDATORY_BOTH \
	BLOCK func14_TOT_block; \
	COLLECTION func14_TOT_BLOCK_OBJECT; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func14_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func14_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func14_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func14_TOT_BLOCK_OBJECT_page; \
	COMMAND func14_TOT_BLOCK_OBJECT_read; \
	VARIABLE func14_TOT_ST_REV; \
	MENU func14_TOT_ST_REV_page; \
	COMMAND func14_TOT_ST_REV_read; \
	VARIABLE func14_TOT_TAG_DESC; \
	MENU func14_TOT_TAG_DESC_page; \
	COMMAND func14_TOT_TAG_DESC_read; \
	COMMAND func14_TOT_TAG_DESC_write; \
	VARIABLE func14_TOT_STRATEGY; \
	MENU func14_TOT_STRATEGY_page; \
	COMMAND func14_TOT_STRATEGY_read; \
	COMMAND func14_TOT_STRATEGY_write; \
	VARIABLE func14_TOT_ALERT_KEY; \
	MENU func14_TOT_ALERT_KEY_page; \
	COMMAND func14_TOT_ALERT_KEY_read; \
	COMMAND func14_TOT_ALERT_KEY_write; \
	VARIABLE func14_TOT_TARGET_MODE; \
	MENU func14_TOT_TARGET_MODE_page; \
	COMMAND func14_TOT_TARGET_MODE_read; \
	COMMAND func14_TOT_TARGET_MODE_write; \
	COLLECTION func14_TOT_MODE_BLK; \
	VARIABLE func14_TOT_MODE_BLK_Actual; \
	VARIABLE func14_TOT_MODE_BLK_Permitted; \
	VARIABLE func14_TOT_MODE_BLK_Normal; \
	MENU func14_TOT_MODE_BLK_page; \
	COMMAND func14_TOT_MODE_BLK_read; \
	COLLECTION func14_TOT_ALARM_SUM; \
	VARIABLE func14_TOT_ALARM_SUM_Current; \
	VARIABLE func14_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func14_TOT_ALARM_SUM_Unreported; \
	VARIABLE func14_TOT_ALARM_SUM_Disabled; \
	MENU func14_TOT_ALARM_SUM_page; \
	COMMAND func14_TOT_ALARM_SUM_read; \
	COLLECTION func14_TOT_BATCH; \
	VARIABLE func14_TOT_BATCH_Batch_ID; \
	VARIABLE func14_TOT_BATCH_Rup; \
	VARIABLE func14_TOT_BATCH_Operation; \
	VARIABLE func14_TOT_BATCH_Phase; \
	MENU func14_TOT_BATCH_page; \
	COMMAND func14_TOT_BATCH_read; \
	COMMAND func14_TOT_BATCH_write; \
	COLLECTION func14_TOT_TOTAL; \
	VARIABLE func14_TOT_TOTAL_Value; \
	VARIABLE func14_TOT_TOTAL_Status_Quality; \
	VARIABLE func14_TOT_TOTAL_Status_Limit; \
	MENU func14_TOT_TOTAL_page; \
	COMMAND func14_TOT_TOTAL_read; \
	COMMAND func14_TOT_TOTAL_write; \
	VARIABLE func14_TOT_UNIT_TOT; \
	MENU func14_TOT_UNIT_TOT_page; \
	COMMAND func14_TOT_UNIT_TOT_read; \
	COMMAND func14_TOT_UNIT_TOT_write; \
	VARIABLE func14_TOT_ALARM_HYS; \
	MENU func14_TOT_ALARM_HYS_page; \
	COMMAND func14_TOT_ALARM_HYS_read; \
	COMMAND func14_TOT_ALARM_HYS_write; \
	VARIABLE func14_TOT_HI_HI_LIM; \
	MENU func14_TOT_HI_HI_LIM_page; \
	COMMAND func14_TOT_HI_HI_LIM_read; \
	COMMAND func14_TOT_HI_HI_LIM_write; \
	VARIABLE func14_TOT_HI_LIM; \
	MENU func14_TOT_HI_LIM_page; \
	COMMAND func14_TOT_HI_LIM_read; \
	COMMAND func14_TOT_HI_LIM_write; \
	VARIABLE func14_TOT_LO_LIM; \
	MENU func14_TOT_LO_LIM_page; \
	COMMAND func14_TOT_LO_LIM_read; \
	COMMAND func14_TOT_LO_LIM_write; \
	VARIABLE func14_TOT_LO_LO_LIM; \
	MENU func14_TOT_LO_LO_LIM_page; \
	COMMAND func14_TOT_LO_LO_LIM_read; \
	COMMAND func14_TOT_LO_LO_LIM_write; \
	UNIT func14_TOT_unit_1; \
	MENU func14_TOT_Display; \
	MENU func14_TOT_Display_out; \
	MENU func14_TOT_Tab_s_tot_limits

#define USE_FUNC14_TOT_MANDATORY_A \
	USE_FUNC14_TOT_MANDATORY_BOTH; \
	MENU func14_TOT_Simple_Dialog_Mandatory_A; \
	MENU func14_TOT_Tab_s_mandatory_A; \
	MENU func14_TOT_Tab_m_mandatory_A

#define USE_FUNC14_TOT_MANDATORY_B \
	USE_FUNC14_TOT_MANDATORY_BOTH; \
	VARIABLE func14_TOT_CHANNEL; \
	MENU func14_TOT_CHANNEL_page; \
	COMMAND func14_TOT_CHANNEL_read; \
	COMMAND func14_TOT_CHANNEL_write; \
	VARIABLE func14_TOT_SET_TOT; \
	MENU func14_TOT_SET_TOT_page; \
	COMMAND func14_TOT_SET_TOT_read; \
	COMMAND func14_TOT_SET_TOT_write; \
	VARIABLE func14_TOT_MODE_TOT; \
	MENU func14_TOT_MODE_TOT_page; \
	COMMAND func14_TOT_MODE_TOT_read; \
	COMMAND func14_TOT_MODE_TOT_write; \
	VARIABLE func14_TOT_FAIL_TOT; \
	MENU func14_TOT_FAIL_TOT_page; \
	COMMAND func14_TOT_FAIL_TOT_read; \
	COMMAND func14_TOT_FAIL_TOT_write; \
	VARIABLE func14_TOT_PRESET_TOT; \
	MENU func14_TOT_PRESET_TOT_page; \
	COMMAND func14_TOT_PRESET_TOT_read; \
	COMMAND func14_TOT_PRESET_TOT_write; \
	COLLECTION func14_TOT_VIEW_1; \
	MENU func14_TOT_VIEW_1_page; \
	MENU func14_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func14_TOT_unit_2; \
	MENU func14_TOT_Reset; \
	MENU func14_TOT_Reset_page; \
	METHOD func14_TOT_Reset_totalizer; \
	METHOD func14_TOT_Preset_totalizer; \
	MENU func14_TOT_Tab_s_mandatory_B; \
	MENU func14_TOT_Tab_m_mandatory_B

#define USE_FUNC14_TOT_OPTIONAL_BOTH \
	COLLECTION func14_TOT_HI_HI_ALM; \
	VARIABLE func14_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func14_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func14_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func14_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func14_TOT_HI_HI_ALM_Value; \
	MENU func14_TOT_HI_HI_ALM_page; \
	COMMAND func14_TOT_HI_HI_ALM_read; \
	COLLECTION func14_TOT_HI_ALM; \
	VARIABLE func14_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func14_TOT_HI_ALM_Alarm_State; \
	VARIABLE func14_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func14_TOT_HI_ALM_Subcode; \
	VARIABLE func14_TOT_HI_ALM_Value; \
	MENU func14_TOT_HI_ALM_page; \
	COMMAND func14_TOT_HI_ALM_read; \
	COLLECTION func14_TOT_LO_ALM; \
	VARIABLE func14_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func14_TOT_LO_ALM_Alarm_State; \
	VARIABLE func14_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func14_TOT_LO_ALM_Subcode; \
	VARIABLE func14_TOT_LO_ALM_Value; \
	MENU func14_TOT_LO_ALM_page; \
	COMMAND func14_TOT_LO_ALM_read; \
	COLLECTION func14_TOT_LO_LO_ALM; \
	VARIABLE func14_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func14_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func14_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func14_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func14_TOT_LO_LO_ALM_Value; \
	MENU func14_TOT_LO_LO_ALM_page; \
	COMMAND func14_TOT_LO_LO_ALM_read

#define USE_FUNC14_TOT_OPTIONAL_A \
	USE_FUNC14_TOT_OPTIONAL_BOTH; \
	VARIABLE func14_TOT_CHANNEL; \
	MENU func14_TOT_CHANNEL_page; \
	COMMAND func14_TOT_CHANNEL_read; \
	COMMAND func14_TOT_CHANNEL_write; \
	VARIABLE func14_TOT_SET_TOT; \
	MENU func14_TOT_SET_TOT_page; \
	COMMAND func14_TOT_SET_TOT_read; \
	COMMAND func14_TOT_SET_TOT_write; \
	VARIABLE func14_TOT_MODE_TOT; \
	MENU func14_TOT_MODE_TOT_page; \
	COMMAND func14_TOT_MODE_TOT_read; \
	COMMAND func14_TOT_MODE_TOT_write; \
	VARIABLE func14_TOT_FAIL_TOT; \
	MENU func14_TOT_FAIL_TOT_page; \
	COMMAND func14_TOT_FAIL_TOT_read; \
	COMMAND func14_TOT_FAIL_TOT_write; \
	VARIABLE func14_TOT_PRESET_TOT; \
	MENU func14_TOT_PRESET_TOT_page; \
	COMMAND func14_TOT_PRESET_TOT_read; \
	COMMAND func14_TOT_PRESET_TOT_write; \
	COLLECTION func14_TOT_VIEW_1; \
	MENU func14_TOT_VIEW_1_page; \
	MENU func14_TOT_Simple_Dialog_Optional_A

#define USE_FUNC14_TOT_OPTIONAL_B \
	USE_FUNC14_TOT_OPTIONAL_BOTH; \
	MENU func14_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC14_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func14_TOT_)
#define USE_FUNC14_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func14_TOT_)
#define USE_FUNC14_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func14_TOT_)
#define USE_FUNC14_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func14_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_FUNC15_TOT_MANDATORY_BOTH \
	BLOCK func15_TOT_block; \
	COLLECTION func15_TOT_BLOCK_OBJECT; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Reserved; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Block_Object; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Parent_Class; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Class; \
	VARIABLE func15_TOT_BLOCK_OBJECT_DD_Reference; \
	VARIABLE func15_TOT_BLOCK_OBJECT_DD_Revision; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Profile; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Execution_Time; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE func15_TOT_BLOCK_OBJECT_Number_of_Views; \
	MENU func15_TOT_BLOCK_OBJECT_page; \
	COMMAND func15_TOT_BLOCK_OBJECT_read; \
	VARIABLE func15_TOT_ST_REV; \
	MENU func15_TOT_ST_REV_page; \
	COMMAND func15_TOT_ST_REV_read; \
	VARIABLE func15_TOT_TAG_DESC; \
	MENU func15_TOT_TAG_DESC_page; \
	COMMAND func15_TOT_TAG_DESC_read; \
	COMMAND func15_TOT_TAG_DESC_write; \
	VARIABLE func15_TOT_STRATEGY; \
	MENU func15_TOT_STRATEGY_page; \
	COMMAND func15_TOT_STRATEGY_read; \
	COMMAND func15_TOT_STRATEGY_write; \
	VARIABLE func15_TOT_ALERT_KEY; \
	MENU func15_TOT_ALERT_KEY_page; \
	COMMAND func15_TOT_ALERT_KEY_read; \
	COMMAND func15_TOT_ALERT_KEY_write; \
	VARIABLE func15_TOT_TARGET_MODE; \
	MENU func15_TOT_TARGET_MODE_page; \
	COMMAND func15_TOT_TARGET_MODE_read; \
	COMMAND func15_TOT_TARGET_MODE_write; \
	COLLECTION func15_TOT_MODE_BLK; \
	VARIABLE func15_TOT_MODE_BLK_Actual; \
	VARIABLE func15_TOT_MODE_BLK_Permitted; \
	VARIABLE func15_TOT_MODE_BLK_Normal; \
	MENU func15_TOT_MODE_BLK_page; \
	COMMAND func15_TOT_MODE_BLK_read; \
	COLLECTION func15_TOT_ALARM_SUM; \
	VARIABLE func15_TOT_ALARM_SUM_Current; \
	VARIABLE func15_TOT_ALARM_SUM_Unacknowledged; \
	VARIABLE func15_TOT_ALARM_SUM_Unreported; \
	VARIABLE func15_TOT_ALARM_SUM_Disabled; \
	MENU func15_TOT_ALARM_SUM_page; \
	COMMAND func15_TOT_ALARM_SUM_read; \
	COLLECTION func15_TOT_BATCH; \
	VARIABLE func15_TOT_BATCH_Batch_ID; \
	VARIABLE func15_TOT_BATCH_Rup; \
	VARIABLE func15_TOT_BATCH_Operation; \
	VARIABLE func15_TOT_BATCH_Phase; \
	MENU func15_TOT_BATCH_page; \
	COMMAND func15_TOT_BATCH_read; \
	COMMAND func15_TOT_BATCH_write; \
	COLLECTION func15_TOT_TOTAL; \
	VARIABLE func15_TOT_TOTAL_Value; \
	VARIABLE func15_TOT_TOTAL_Status_Quality; \
	VARIABLE func15_TOT_TOTAL_Status_Limit; \
	MENU func15_TOT_TOTAL_page; \
	COMMAND func15_TOT_TOTAL_read; \
	COMMAND func15_TOT_TOTAL_write; \
	VARIABLE func15_TOT_UNIT_TOT; \
	MENU func15_TOT_UNIT_TOT_page; \
	COMMAND func15_TOT_UNIT_TOT_read; \
	COMMAND func15_TOT_UNIT_TOT_write; \
	VARIABLE func15_TOT_ALARM_HYS; \
	MENU func15_TOT_ALARM_HYS_page; \
	COMMAND func15_TOT_ALARM_HYS_read; \
	COMMAND func15_TOT_ALARM_HYS_write; \
	VARIABLE func15_TOT_HI_HI_LIM; \
	MENU func15_TOT_HI_HI_LIM_page; \
	COMMAND func15_TOT_HI_HI_LIM_read; \
	COMMAND func15_TOT_HI_HI_LIM_write; \
	VARIABLE func15_TOT_HI_LIM; \
	MENU func15_TOT_HI_LIM_page; \
	COMMAND func15_TOT_HI_LIM_read; \
	COMMAND func15_TOT_HI_LIM_write; \
	VARIABLE func15_TOT_LO_LIM; \
	MENU func15_TOT_LO_LIM_page; \
	COMMAND func15_TOT_LO_LIM_read; \
	COMMAND func15_TOT_LO_LIM_write; \
	VARIABLE func15_TOT_LO_LO_LIM; \
	MENU func15_TOT_LO_LO_LIM_page; \
	COMMAND func15_TOT_LO_LO_LIM_read; \
	COMMAND func15_TOT_LO_LO_LIM_write; \
	UNIT func15_TOT_unit_1; \
	MENU func15_TOT_Display; \
	MENU func15_TOT_Display_out; \
	MENU func15_TOT_Tab_s_tot_limits

#define USE_FUNC15_TOT_MANDATORY_A \
	USE_FUNC15_TOT_MANDATORY_BOTH; \
	MENU func15_TOT_Simple_Dialog_Mandatory_A; \
	MENU func15_TOT_Tab_s_mandatory_A; \
	MENU func15_TOT_Tab_m_mandatory_A

#define USE_FUNC15_TOT_MANDATORY_B \
	USE_FUNC15_TOT_MANDATORY_BOTH; \
	VARIABLE func15_TOT_CHANNEL; \
	MENU func15_TOT_CHANNEL_page; \
	COMMAND func15_TOT_CHANNEL_read; \
	COMMAND func15_TOT_CHANNEL_write; \
	VARIABLE func15_TOT_SET_TOT; \
	MENU func15_TOT_SET_TOT_page; \
	COMMAND func15_TOT_SET_TOT_read; \
	COMMAND func15_TOT_SET_TOT_write; \
	VARIABLE func15_TOT_MODE_TOT; \
	MENU func15_TOT_MODE_TOT_page; \
	COMMAND func15_TOT_MODE_TOT_read; \
	COMMAND func15_TOT_MODE_TOT_write; \
	VARIABLE func15_TOT_FAIL_TOT; \
	MENU func15_TOT_FAIL_TOT_page; \
	COMMAND func15_TOT_FAIL_TOT_read; \
	COMMAND func15_TOT_FAIL_TOT_write; \
	VARIABLE func15_TOT_PRESET_TOT; \
	MENU func15_TOT_PRESET_TOT_page; \
	COMMAND func15_TOT_PRESET_TOT_read; \
	COMMAND func15_TOT_PRESET_TOT_write; \
	COLLECTION func15_TOT_VIEW_1; \
	MENU func15_TOT_VIEW_1_page; \
	MENU func15_TOT_Simple_Dialog_Mandatory_B; \
	UNIT func15_TOT_unit_2; \
	MENU func15_TOT_Reset; \
	MENU func15_TOT_Reset_page; \
	METHOD func15_TOT_Reset_totalizer; \
	METHOD func15_TOT_Preset_totalizer; \
	MENU func15_TOT_Tab_s_mandatory_B; \
	MENU func15_TOT_Tab_m_mandatory_B

#define USE_FUNC15_TOT_OPTIONAL_BOTH \
	COLLECTION func15_TOT_HI_HI_ALM; \
	VARIABLE func15_TOT_HI_HI_ALM_Unacknowledged; \
	VARIABLE func15_TOT_HI_HI_ALM_Alarm_State; \
	VARIABLE func15_TOT_HI_HI_ALM_Time_Stamp; \
	VARIABLE func15_TOT_HI_HI_ALM_Subcode; \
	VARIABLE func15_TOT_HI_HI_ALM_Value; \
	MENU func15_TOT_HI_HI_ALM_page; \
	COMMAND func15_TOT_HI_HI_ALM_read; \
	COLLECTION func15_TOT_HI_ALM; \
	VARIABLE func15_TOT_HI_ALM_Unacknowledged; \
	VARIABLE func15_TOT_HI_ALM_Alarm_State; \
	VARIABLE func15_TOT_HI_ALM_Time_Stamp; \
	VARIABLE func15_TOT_HI_ALM_Subcode; \
	VARIABLE func15_TOT_HI_ALM_Value; \
	MENU func15_TOT_HI_ALM_page; \
	COMMAND func15_TOT_HI_ALM_read; \
	COLLECTION func15_TOT_LO_ALM; \
	VARIABLE func15_TOT_LO_ALM_Unacknowledged; \
	VARIABLE func15_TOT_LO_ALM_Alarm_State; \
	VARIABLE func15_TOT_LO_ALM_Time_Stamp; \
	VARIABLE func15_TOT_LO_ALM_Subcode; \
	VARIABLE func15_TOT_LO_ALM_Value; \
	MENU func15_TOT_LO_ALM_page; \
	COMMAND func15_TOT_LO_ALM_read; \
	COLLECTION func15_TOT_LO_LO_ALM; \
	VARIABLE func15_TOT_LO_LO_ALM_Unacknowledged; \
	VARIABLE func15_TOT_LO_LO_ALM_Alarm_State; \
	VARIABLE func15_TOT_LO_LO_ALM_Time_Stamp; \
	VARIABLE func15_TOT_LO_LO_ALM_Subcode; \
	VARIABLE func15_TOT_LO_LO_ALM_Value; \
	MENU func15_TOT_LO_LO_ALM_page; \
	COMMAND func15_TOT_LO_LO_ALM_read

#define USE_FUNC15_TOT_OPTIONAL_A \
	USE_FUNC15_TOT_OPTIONAL_BOTH; \
	VARIABLE func15_TOT_CHANNEL; \
	MENU func15_TOT_CHANNEL_page; \
	COMMAND func15_TOT_CHANNEL_read; \
	COMMAND func15_TOT_CHANNEL_write; \
	VARIABLE func15_TOT_SET_TOT; \
	MENU func15_TOT_SET_TOT_page; \
	COMMAND func15_TOT_SET_TOT_read; \
	COMMAND func15_TOT_SET_TOT_write; \
	VARIABLE func15_TOT_MODE_TOT; \
	MENU func15_TOT_MODE_TOT_page; \
	COMMAND func15_TOT_MODE_TOT_read; \
	COMMAND func15_TOT_MODE_TOT_write; \
	VARIABLE func15_TOT_FAIL_TOT; \
	MENU func15_TOT_FAIL_TOT_page; \
	COMMAND func15_TOT_FAIL_TOT_read; \
	COMMAND func15_TOT_FAIL_TOT_write; \
	VARIABLE func15_TOT_PRESET_TOT; \
	MENU func15_TOT_PRESET_TOT_page; \
	COMMAND func15_TOT_PRESET_TOT_read; \
	COMMAND func15_TOT_PRESET_TOT_write; \
	COLLECTION func15_TOT_VIEW_1; \
	MENU func15_TOT_VIEW_1_page; \
	MENU func15_TOT_Simple_Dialog_Optional_A

#define USE_FUNC15_TOT_OPTIONAL_B \
	USE_FUNC15_TOT_OPTIONAL_BOTH; \
	MENU func15_TOT_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_FUNC15_TOT_MANDATORY_A USE_FUNC_TOT_MANDATORY_A(func15_TOT_)
#define USE_FUNC15_TOT_MANDATORY_B USE_FUNC_TOT_MANDATORY_B(func15_TOT_)
#define USE_FUNC15_TOT_OPTIONAL_A  USE_FUNC_TOT_OPTIONAL_A(func15_TOT_)
#define USE_FUNC15_TOT_OPTIONAL_B  USE_FUNC_TOT_OPTIONAL_B(func15_TOT_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS1_FLOWCM_MANDATORY_BOTH \
	BLOCK trans1_FlowCM_block; \
	COLLECTION trans1_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans1_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans1_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans1_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans1_FlowCM_ST_REV; \
	MENU trans1_FlowCM_ST_REV_page; \
	COMMAND trans1_FlowCM_ST_REV_read; \
	VARIABLE trans1_FlowCM_TAG_DESC; \
	MENU trans1_FlowCM_TAG_DESC_page; \
	COMMAND trans1_FlowCM_TAG_DESC_read; \
	COMMAND trans1_FlowCM_TAG_DESC_write; \
	VARIABLE trans1_FlowCM_STRATEGY; \
	MENU trans1_FlowCM_STRATEGY_page; \
	COMMAND trans1_FlowCM_STRATEGY_read; \
	COMMAND trans1_FlowCM_STRATEGY_write; \
	VARIABLE trans1_FlowCM_ALERT_KEY; \
	MENU trans1_FlowCM_ALERT_KEY_page; \
	COMMAND trans1_FlowCM_ALERT_KEY_read; \
	COMMAND trans1_FlowCM_ALERT_KEY_write; \
	VARIABLE trans1_FlowCM_TARGET_MODE; \
	MENU trans1_FlowCM_TARGET_MODE_page; \
	COMMAND trans1_FlowCM_TARGET_MODE_read; \
	COMMAND trans1_FlowCM_TARGET_MODE_write; \
	COLLECTION trans1_FlowCM_MODE_BLK; \
	VARIABLE trans1_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans1_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans1_FlowCM_MODE_BLK_Normal; \
	MENU trans1_FlowCM_MODE_BLK_page; \
	COMMAND trans1_FlowCM_MODE_BLK_read; \
	COLLECTION trans1_FlowCM_ALARM_SUM; \
	VARIABLE trans1_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans1_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans1_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans1_FlowCM_ALARM_SUM_Disabled; \
	MENU trans1_FlowCM_ALARM_SUM_page; \
	COMMAND trans1_FlowCM_ALARM_SUM_read; \
	VARIABLE trans1_FlowCM_CALIBR_FACTOR; \
	MENU trans1_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans1_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans1_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans1_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans1_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans1_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans1_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans1_FlowCM_MEASUREMENT_MODE; \
	MENU trans1_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans1_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans1_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans1_FlowCM_FLOW_DIRECTION; \
	MENU trans1_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans1_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans1_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans1_FlowCM_ZERO_POINT; \
	MENU trans1_FlowCM_ZERO_POINT_page; \
	COMMAND trans1_FlowCM_ZERO_POINT_read; \
	COMMAND trans1_FlowCM_ZERO_POINT_write; \
	VARIABLE trans1_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans1_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans1_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans1_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans1_FlowCM_ZERO_POINT_UNIT; \
	MENU trans1_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans1_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans1_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans1_FlowCM_NOMINAL_SIZE; \
	MENU trans1_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans1_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans1_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans1_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans1_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans1_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans1_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans1_FlowCM_MASS_FLOW; \
	VARIABLE trans1_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans1_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans1_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans1_FlowCM_MASS_FLOW_page; \
	COMMAND trans1_FlowCM_MASS_FLOW_read; \
	VARIABLE trans1_FlowCM_MASS_FLOW_UNITS; \
	MENU trans1_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans1_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans1_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans1_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans1_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans1_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans1_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans1_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans1_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans1_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans1_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans1_FlowCM_DENSITY; \
	VARIABLE trans1_FlowCM_DENSITY_Value; \
	VARIABLE trans1_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans1_FlowCM_DENSITY_Status_Limit; \
	MENU trans1_FlowCM_DENSITY_page; \
	COMMAND trans1_FlowCM_DENSITY_read; \
	VARIABLE trans1_FlowCM_DENSITY_UNITS; \
	MENU trans1_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans1_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans1_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans1_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans1_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans1_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans1_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans1_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans1_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans1_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans1_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans1_FlowCM_TEMPERATURE; \
	VARIABLE trans1_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans1_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans1_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans1_FlowCM_TEMPERATURE_page; \
	COMMAND trans1_FlowCM_TEMPERATURE_read; \
	VARIABLE trans1_FlowCM_TEMPERATURE_UNITS; \
	MENU trans1_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans1_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans1_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans1_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans1_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans1_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans1_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans1_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans1_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans1_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans1_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans1_FlowCM_unit_nominal_size; \
	UNIT trans1_FlowCM_unit_zero_point; \
	UNIT trans1_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans1_FlowCM_unit_density; \
	UNIT trans1_FlowCM_unit_temperature

#define USE_TRANS1_FLOWCM_MANDATORY_A \
	USE_TRANS1_FLOWCM_MANDATORY_BOTH; \
	MENU trans1_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS1_FLOWCM_MANDATORY_B \
	USE_TRANS1_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans1_FlowCM_VIEW_1; \
	MENU trans1_FlowCM_VIEW_1_page; \
	MENU trans1_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS1_FLOWCM_OPTIONAL_A \
	COLLECTION trans1_FlowCM_VIEW_1; \
	MENU trans1_FlowCM_VIEW_1_page; \
	MENU trans1_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS1_FLOWCM_OPTIONAL_B \
	MENU trans1_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS_FLOWCM_MANDATORY_BOTH(prefix) \
	BLOCK prefix ## block; \
	COLLECTION prefix ## BLOCK_OBJECT; \
	VARIABLE prefix ## BLOCK_OBJECT_Reserved; \
	VARIABLE prefix ## BLOCK_OBJECT_Block_Object; \
	VARIABLE prefix ## BLOCK_OBJECT_Parent_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Reference; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Execution_Time; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Views; \
	MENU prefix ## BLOCK_OBJECT_page; \
	COMMAND prefix ## BLOCK_OBJECT_read; \
	VARIABLE prefix ## ST_REV; \
	MENU prefix ## ST_REV_page; \
	COMMAND prefix ## ST_REV_read; \
	VARIABLE prefix ## TAG_DESC; \
	MENU prefix ## TAG_DESC_page; \
	COMMAND prefix ## TAG_DESC_read; \
	COMMAND prefix ## TAG_DESC_write; \
	VARIABLE prefix ## STRATEGY; \
	MENU prefix ## STRATEGY_page; \
	COMMAND prefix ## STRATEGY_read; \
	COMMAND prefix ## STRATEGY_write; \
	VARIABLE prefix ## ALERT_KEY; \
	MENU prefix ## ALERT_KEY_page; \
	COMMAND prefix ## ALERT_KEY_read; \
	COMMAND prefix ## ALERT_KEY_write; \
	VARIABLE prefix ## TARGET_MODE; \
	MENU prefix ## TARGET_MODE_page; \
	COMMAND prefix ## TARGET_MODE_read; \
	COMMAND prefix ## TARGET_MODE_write; \
	COLLECTION prefix ## MODE_BLK; \
	VARIABLE prefix ## MODE_BLK_Actual; \
	VARIABLE prefix ## MODE_BLK_Permitted; \
	VARIABLE prefix ## MODE_BLK_Normal; \
	MENU prefix ## MODE_BLK_page; \
	COMMAND prefix ## MODE_BLK_read; \
	COLLECTION prefix ## ALARM_SUM; \
	VARIABLE prefix ## ALARM_SUM_Current; \
	VARIABLE prefix ## ALARM_SUM_Unacknowledged; \
	VARIABLE prefix ## ALARM_SUM_Unreported; \
	VARIABLE prefix ## ALARM_SUM_Disabled; \
	MENU prefix ## ALARM_SUM_page; \
	COMMAND prefix ## ALARM_SUM_read; \
	VARIABLE prefix ## CALIBR_FACTOR; \
	MENU prefix ## CALIBR_FACTOR_page; \
	COMMAND prefix ## CALIBR_FACTOR_read; \
	COMMAND prefix ## CALIBR_FACTOR_write; \
	VARIABLE prefix ## LOW_FLOW_CUTOFF; \
	MENU prefix ## LOW_FLOW_CUTOFF_page; \
	COMMAND prefix ## LOW_FLOW_CUTOFF_read; \
	COMMAND prefix ## LOW_FLOW_CUTOFF_write; \
	VARIABLE prefix ## MEASUREMENT_MODE; \
	MENU prefix ## MEASUREMENT_MODE_page; \
	COMMAND prefix ## MEASUREMENT_MODE_read; \
	COMMAND prefix ## MEASUREMENT_MODE_write; \
	VARIABLE prefix ## FLOW_DIRECTION; \
	MENU prefix ## FLOW_DIRECTION_page; \
	COMMAND prefix ## FLOW_DIRECTION_read; \
	COMMAND prefix ## FLOW_DIRECTION_write; \
	VARIABLE prefix ## ZERO_POINT; \
	MENU prefix ## ZERO_POINT_page; \
	COMMAND prefix ## ZERO_POINT_read; \
	COMMAND prefix ## ZERO_POINT_write; \
	VARIABLE prefix ## ZERO_POINT_ADJUST; \
	MENU prefix ## ZERO_POINT_ADJUST_page; \
	COMMAND prefix ## ZERO_POINT_ADJUST_read; \
	COMMAND prefix ## ZERO_POINT_ADJUST_write; \
	VARIABLE prefix ## ZERO_POINT_UNIT; \
	MENU prefix ## ZERO_POINT_UNIT_page; \
	COMMAND prefix ## ZERO_POINT_UNIT_read; \
	COMMAND prefix ## ZERO_POINT_UNIT_write; \
	VARIABLE prefix ## NOMINAL_SIZE; \
	MENU prefix ## NOMINAL_SIZE_page; \
	COMMAND prefix ## NOMINAL_SIZE_read; \
	COMMAND prefix ## NOMINAL_SIZE_write; \
	VARIABLE prefix ## NOMINAL_SIZE_UNITS; \
	MENU prefix ## NOMINAL_SIZE_UNITS_page; \
	COMMAND prefix ## NOMINAL_SIZE_UNITS_read; \
	COMMAND prefix ## NOMINAL_SIZE_UNITS_write; \
	COLLECTION prefix ## MASS_FLOW; \
	VARIABLE prefix ## MASS_FLOW_Value; \
	VARIABLE prefix ## MASS_FLOW_Status_Quality; \
	VARIABLE prefix ## MASS_FLOW_Status_Limit; \
	MENU prefix ## MASS_FLOW_page; \
	COMMAND prefix ## MASS_FLOW_read; \
	VARIABLE prefix ## MASS_FLOW_UNITS; \
	MENU prefix ## MASS_FLOW_UNITS_page; \
	COMMAND prefix ## MASS_FLOW_UNITS_read; \
	COMMAND prefix ## MASS_FLOW_UNITS_write; \
	VARIABLE prefix ## MASS_FLOW_LO_LIMIT; \
	MENU prefix ## MASS_FLOW_LO_LIMIT_page; \
	COMMAND prefix ## MASS_FLOW_LO_LIMIT_read; \
	COMMAND prefix ## MASS_FLOW_LO_LIMIT_write; \
	VARIABLE prefix ## MASS_FLOW_HI_LIMIT; \
	MENU prefix ## MASS_FLOW_HI_LIMIT_page; \
	COMMAND prefix ## MASS_FLOW_HI_LIMIT_read; \
	COMMAND prefix ## MASS_FLOW_HI_LIMIT_write; \
	COLLECTION prefix ## DENSITY; \
	VARIABLE prefix ## DENSITY_Value; \
	VARIABLE prefix ## DENSITY_Status_Quality; \
	VARIABLE prefix ## DENSITY_Status_Limit; \
	MENU prefix ## DENSITY_page; \
	COMMAND prefix ## DENSITY_read; \
	VARIABLE prefix ## DENSITY_UNITS; \
	MENU prefix ## DENSITY_UNITS_page; \
	COMMAND prefix ## DENSITY_UNITS_read; \
	COMMAND prefix ## DENSITY_UNITS_write; \
	VARIABLE prefix ## DENSITY_LO_LIMIT; \
	MENU prefix ## DENSITY_LO_LIMIT_page; \
	COMMAND prefix ## DENSITY_LO_LIMIT_read; \
	COMMAND prefix ## DENSITY_LO_LIMIT_write; \
	VARIABLE prefix ## DENSITY_HI_LIMIT; \
	MENU prefix ## DENSITY_HI_LIMIT_page; \
	COMMAND prefix ## DENSITY_HI_LIMIT_read; \
	COMMAND prefix ## DENSITY_HI_LIMIT_write; \
	COLLECTION prefix ## TEMPERATURE; \
	VARIABLE prefix ## TEMPERATURE_Value; \
	VARIABLE prefix ## TEMPERATURE_Status_Quality; \
	VARIABLE prefix ## TEMPERATURE_Status_Limit; \
	MENU prefix ## TEMPERATURE_page; \
	COMMAND prefix ## TEMPERATURE_read; \
	VARIABLE prefix ## TEMPERATURE_UNITS; \
	MENU prefix ## TEMPERATURE_UNITS_page; \
	COMMAND prefix ## TEMPERATURE_UNITS_read; \
	COMMAND prefix ## TEMPERATURE_UNITS_write; \
	VARIABLE prefix ## TEMPERATURE_LO_LIMIT; \
	MENU prefix ## TEMPERATURE_LO_LIMIT_page; \
	COMMAND prefix ## TEMPERATURE_LO_LIMIT_read; \
	COMMAND prefix ## TEMPERATURE_LO_LIMIT_write; \
	VARIABLE prefix ## TEMPERATURE_HI_LIMIT; \
	MENU prefix ## TEMPERATURE_HI_LIMIT_page; \
	COMMAND prefix ## TEMPERATURE_HI_LIMIT_read; \
	COMMAND prefix ## TEMPERATURE_HI_LIMIT_write; \
	UNIT prefix ## unit_nominal_size; \
	UNIT prefix ## unit_zero_point; \
	UNIT prefix ## unit_TB_MASS_FLOW_UNIT; \
	UNIT prefix ## unit_density; \
	UNIT prefix ## unit_temperature

#define USE_TRANS_FLOWCM_MANDATORY_A(prefix) \
	USE_TRANS_FLOWCM_MANDATORY_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Mandatory_A

#define USE_TRANS_FLOWCM_MANDATORY_B(prefix) \
	USE_TRANS_FLOWCM_MANDATORY_BOTH(prefix); \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Mandatory_B

#define USE_TRANS_FLOWCM_OPTIONAL_A(prefix) \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Optional_A

#define USE_TRANS_FLOWCM_OPTIONAL_B(prefix) \
	MENU prefix ## Simple_Dialog_Optional_B

#define USE_TRANS1_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans1_FlowCM_)
#define USE_TRANS1_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans1_FlowCM_)
#define USE_TRANS1_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans1_FlowCM_)
#define USE_TRANS1_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans1_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS2_FLOWCM_MANDATORY_BOTH \
	BLOCK trans2_FlowCM_block; \
	COLLECTION trans2_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans2_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans2_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans2_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans2_FlowCM_ST_REV; \
	MENU trans2_FlowCM_ST_REV_page; \
	COMMAND trans2_FlowCM_ST_REV_read; \
	VARIABLE trans2_FlowCM_TAG_DESC; \
	MENU trans2_FlowCM_TAG_DESC_page; \
	COMMAND trans2_FlowCM_TAG_DESC_read; \
	COMMAND trans2_FlowCM_TAG_DESC_write; \
	VARIABLE trans2_FlowCM_STRATEGY; \
	MENU trans2_FlowCM_STRATEGY_page; \
	COMMAND trans2_FlowCM_STRATEGY_read; \
	COMMAND trans2_FlowCM_STRATEGY_write; \
	VARIABLE trans2_FlowCM_ALERT_KEY; \
	MENU trans2_FlowCM_ALERT_KEY_page; \
	COMMAND trans2_FlowCM_ALERT_KEY_read; \
	COMMAND trans2_FlowCM_ALERT_KEY_write; \
	VARIABLE trans2_FlowCM_TARGET_MODE; \
	MENU trans2_FlowCM_TARGET_MODE_page; \
	COMMAND trans2_FlowCM_TARGET_MODE_read; \
	COMMAND trans2_FlowCM_TARGET_MODE_write; \
	COLLECTION trans2_FlowCM_MODE_BLK; \
	VARIABLE trans2_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans2_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans2_FlowCM_MODE_BLK_Normal; \
	MENU trans2_FlowCM_MODE_BLK_page; \
	COMMAND trans2_FlowCM_MODE_BLK_read; \
	COLLECTION trans2_FlowCM_ALARM_SUM; \
	VARIABLE trans2_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans2_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans2_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans2_FlowCM_ALARM_SUM_Disabled; \
	MENU trans2_FlowCM_ALARM_SUM_page; \
	COMMAND trans2_FlowCM_ALARM_SUM_read; \
	VARIABLE trans2_FlowCM_CALIBR_FACTOR; \
	MENU trans2_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans2_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans2_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans2_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans2_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans2_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans2_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans2_FlowCM_MEASUREMENT_MODE; \
	MENU trans2_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans2_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans2_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans2_FlowCM_FLOW_DIRECTION; \
	MENU trans2_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans2_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans2_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans2_FlowCM_ZERO_POINT; \
	MENU trans2_FlowCM_ZERO_POINT_page; \
	COMMAND trans2_FlowCM_ZERO_POINT_read; \
	COMMAND trans2_FlowCM_ZERO_POINT_write; \
	VARIABLE trans2_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans2_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans2_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans2_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans2_FlowCM_ZERO_POINT_UNIT; \
	MENU trans2_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans2_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans2_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans2_FlowCM_NOMINAL_SIZE; \
	MENU trans2_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans2_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans2_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans2_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans2_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans2_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans2_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans2_FlowCM_MASS_FLOW; \
	VARIABLE trans2_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans2_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans2_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans2_FlowCM_MASS_FLOW_page; \
	COMMAND trans2_FlowCM_MASS_FLOW_read; \
	VARIABLE trans2_FlowCM_MASS_FLOW_UNITS; \
	MENU trans2_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans2_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans2_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans2_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans2_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans2_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans2_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans2_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans2_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans2_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans2_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans2_FlowCM_DENSITY; \
	VARIABLE trans2_FlowCM_DENSITY_Value; \
	VARIABLE trans2_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans2_FlowCM_DENSITY_Status_Limit; \
	MENU trans2_FlowCM_DENSITY_page; \
	COMMAND trans2_FlowCM_DENSITY_read; \
	VARIABLE trans2_FlowCM_DENSITY_UNITS; \
	MENU trans2_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans2_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans2_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans2_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans2_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans2_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans2_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans2_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans2_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans2_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans2_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans2_FlowCM_TEMPERATURE; \
	VARIABLE trans2_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans2_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans2_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans2_FlowCM_TEMPERATURE_page; \
	COMMAND trans2_FlowCM_TEMPERATURE_read; \
	VARIABLE trans2_FlowCM_TEMPERATURE_UNITS; \
	MENU trans2_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans2_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans2_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans2_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans2_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans2_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans2_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans2_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans2_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans2_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans2_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans2_FlowCM_unit_nominal_size; \
	UNIT trans2_FlowCM_unit_zero_point; \
	UNIT trans2_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans2_FlowCM_unit_density; \
	UNIT trans2_FlowCM_unit_temperature

#define USE_TRANS2_FLOWCM_MANDATORY_A \
	USE_TRANS2_FLOWCM_MANDATORY_BOTH; \
	MENU trans2_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS2_FLOWCM_MANDATORY_B \
	USE_TRANS2_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans2_FlowCM_VIEW_1; \
	MENU trans2_FlowCM_VIEW_1_page; \
	MENU trans2_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS2_FLOWCM_OPTIONAL_A \
	COLLECTION trans2_FlowCM_VIEW_1; \
	MENU trans2_FlowCM_VIEW_1_page; \
	MENU trans2_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS2_FLOWCM_OPTIONAL_B \
	MENU trans2_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS2_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans2_FlowCM_)
#define USE_TRANS2_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans2_FlowCM_)
#define USE_TRANS2_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans2_FlowCM_)
#define USE_TRANS2_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans2_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS3_FLOWCM_MANDATORY_BOTH \
	BLOCK trans3_FlowCM_block; \
	COLLECTION trans3_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans3_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans3_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans3_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans3_FlowCM_ST_REV; \
	MENU trans3_FlowCM_ST_REV_page; \
	COMMAND trans3_FlowCM_ST_REV_read; \
	VARIABLE trans3_FlowCM_TAG_DESC; \
	MENU trans3_FlowCM_TAG_DESC_page; \
	COMMAND trans3_FlowCM_TAG_DESC_read; \
	COMMAND trans3_FlowCM_TAG_DESC_write; \
	VARIABLE trans3_FlowCM_STRATEGY; \
	MENU trans3_FlowCM_STRATEGY_page; \
	COMMAND trans3_FlowCM_STRATEGY_read; \
	COMMAND trans3_FlowCM_STRATEGY_write; \
	VARIABLE trans3_FlowCM_ALERT_KEY; \
	MENU trans3_FlowCM_ALERT_KEY_page; \
	COMMAND trans3_FlowCM_ALERT_KEY_read; \
	COMMAND trans3_FlowCM_ALERT_KEY_write; \
	VARIABLE trans3_FlowCM_TARGET_MODE; \
	MENU trans3_FlowCM_TARGET_MODE_page; \
	COMMAND trans3_FlowCM_TARGET_MODE_read; \
	COMMAND trans3_FlowCM_TARGET_MODE_write; \
	COLLECTION trans3_FlowCM_MODE_BLK; \
	VARIABLE trans3_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans3_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans3_FlowCM_MODE_BLK_Normal; \
	MENU trans3_FlowCM_MODE_BLK_page; \
	COMMAND trans3_FlowCM_MODE_BLK_read; \
	COLLECTION trans3_FlowCM_ALARM_SUM; \
	VARIABLE trans3_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans3_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans3_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans3_FlowCM_ALARM_SUM_Disabled; \
	MENU trans3_FlowCM_ALARM_SUM_page; \
	COMMAND trans3_FlowCM_ALARM_SUM_read; \
	VARIABLE trans3_FlowCM_CALIBR_FACTOR; \
	MENU trans3_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans3_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans3_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans3_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans3_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans3_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans3_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans3_FlowCM_MEASUREMENT_MODE; \
	MENU trans3_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans3_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans3_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans3_FlowCM_FLOW_DIRECTION; \
	MENU trans3_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans3_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans3_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans3_FlowCM_ZERO_POINT; \
	MENU trans3_FlowCM_ZERO_POINT_page; \
	COMMAND trans3_FlowCM_ZERO_POINT_read; \
	COMMAND trans3_FlowCM_ZERO_POINT_write; \
	VARIABLE trans3_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans3_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans3_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans3_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans3_FlowCM_ZERO_POINT_UNIT; \
	MENU trans3_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans3_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans3_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans3_FlowCM_NOMINAL_SIZE; \
	MENU trans3_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans3_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans3_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans3_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans3_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans3_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans3_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans3_FlowCM_MASS_FLOW; \
	VARIABLE trans3_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans3_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans3_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans3_FlowCM_MASS_FLOW_page; \
	COMMAND trans3_FlowCM_MASS_FLOW_read; \
	VARIABLE trans3_FlowCM_MASS_FLOW_UNITS; \
	MENU trans3_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans3_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans3_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans3_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans3_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans3_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans3_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans3_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans3_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans3_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans3_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans3_FlowCM_DENSITY; \
	VARIABLE trans3_FlowCM_DENSITY_Value; \
	VARIABLE trans3_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans3_FlowCM_DENSITY_Status_Limit; \
	MENU trans3_FlowCM_DENSITY_page; \
	COMMAND trans3_FlowCM_DENSITY_read; \
	VARIABLE trans3_FlowCM_DENSITY_UNITS; \
	MENU trans3_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans3_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans3_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans3_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans3_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans3_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans3_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans3_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans3_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans3_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans3_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans3_FlowCM_TEMPERATURE; \
	VARIABLE trans3_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans3_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans3_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans3_FlowCM_TEMPERATURE_page; \
	COMMAND trans3_FlowCM_TEMPERATURE_read; \
	VARIABLE trans3_FlowCM_TEMPERATURE_UNITS; \
	MENU trans3_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans3_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans3_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans3_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans3_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans3_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans3_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans3_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans3_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans3_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans3_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans3_FlowCM_unit_nominal_size; \
	UNIT trans3_FlowCM_unit_zero_point; \
	UNIT trans3_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans3_FlowCM_unit_density; \
	UNIT trans3_FlowCM_unit_temperature

#define USE_TRANS3_FLOWCM_MANDATORY_A \
	USE_TRANS3_FLOWCM_MANDATORY_BOTH; \
	MENU trans3_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS3_FLOWCM_MANDATORY_B \
	USE_TRANS3_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans3_FlowCM_VIEW_1; \
	MENU trans3_FlowCM_VIEW_1_page; \
	MENU trans3_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS3_FLOWCM_OPTIONAL_A \
	COLLECTION trans3_FlowCM_VIEW_1; \
	MENU trans3_FlowCM_VIEW_1_page; \
	MENU trans3_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS3_FLOWCM_OPTIONAL_B \
	MENU trans3_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS3_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans3_FlowCM_)
#define USE_TRANS3_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans3_FlowCM_)
#define USE_TRANS3_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans3_FlowCM_)
#define USE_TRANS3_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans3_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS4_FLOWCM_MANDATORY_BOTH \
	BLOCK trans4_FlowCM_block; \
	COLLECTION trans4_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans4_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans4_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans4_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans4_FlowCM_ST_REV; \
	MENU trans4_FlowCM_ST_REV_page; \
	COMMAND trans4_FlowCM_ST_REV_read; \
	VARIABLE trans4_FlowCM_TAG_DESC; \
	MENU trans4_FlowCM_TAG_DESC_page; \
	COMMAND trans4_FlowCM_TAG_DESC_read; \
	COMMAND trans4_FlowCM_TAG_DESC_write; \
	VARIABLE trans4_FlowCM_STRATEGY; \
	MENU trans4_FlowCM_STRATEGY_page; \
	COMMAND trans4_FlowCM_STRATEGY_read; \
	COMMAND trans4_FlowCM_STRATEGY_write; \
	VARIABLE trans4_FlowCM_ALERT_KEY; \
	MENU trans4_FlowCM_ALERT_KEY_page; \
	COMMAND trans4_FlowCM_ALERT_KEY_read; \
	COMMAND trans4_FlowCM_ALERT_KEY_write; \
	VARIABLE trans4_FlowCM_TARGET_MODE; \
	MENU trans4_FlowCM_TARGET_MODE_page; \
	COMMAND trans4_FlowCM_TARGET_MODE_read; \
	COMMAND trans4_FlowCM_TARGET_MODE_write; \
	COLLECTION trans4_FlowCM_MODE_BLK; \
	VARIABLE trans4_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans4_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans4_FlowCM_MODE_BLK_Normal; \
	MENU trans4_FlowCM_MODE_BLK_page; \
	COMMAND trans4_FlowCM_MODE_BLK_read; \
	COLLECTION trans4_FlowCM_ALARM_SUM; \
	VARIABLE trans4_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans4_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans4_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans4_FlowCM_ALARM_SUM_Disabled; \
	MENU trans4_FlowCM_ALARM_SUM_page; \
	COMMAND trans4_FlowCM_ALARM_SUM_read; \
	VARIABLE trans4_FlowCM_CALIBR_FACTOR; \
	MENU trans4_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans4_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans4_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans4_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans4_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans4_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans4_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans4_FlowCM_MEASUREMENT_MODE; \
	MENU trans4_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans4_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans4_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans4_FlowCM_FLOW_DIRECTION; \
	MENU trans4_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans4_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans4_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans4_FlowCM_ZERO_POINT; \
	MENU trans4_FlowCM_ZERO_POINT_page; \
	COMMAND trans4_FlowCM_ZERO_POINT_read; \
	COMMAND trans4_FlowCM_ZERO_POINT_write; \
	VARIABLE trans4_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans4_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans4_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans4_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans4_FlowCM_ZERO_POINT_UNIT; \
	MENU trans4_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans4_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans4_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans4_FlowCM_NOMINAL_SIZE; \
	MENU trans4_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans4_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans4_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans4_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans4_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans4_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans4_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans4_FlowCM_MASS_FLOW; \
	VARIABLE trans4_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans4_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans4_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans4_FlowCM_MASS_FLOW_page; \
	COMMAND trans4_FlowCM_MASS_FLOW_read; \
	VARIABLE trans4_FlowCM_MASS_FLOW_UNITS; \
	MENU trans4_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans4_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans4_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans4_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans4_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans4_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans4_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans4_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans4_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans4_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans4_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans4_FlowCM_DENSITY; \
	VARIABLE trans4_FlowCM_DENSITY_Value; \
	VARIABLE trans4_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans4_FlowCM_DENSITY_Status_Limit; \
	MENU trans4_FlowCM_DENSITY_page; \
	COMMAND trans4_FlowCM_DENSITY_read; \
	VARIABLE trans4_FlowCM_DENSITY_UNITS; \
	MENU trans4_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans4_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans4_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans4_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans4_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans4_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans4_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans4_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans4_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans4_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans4_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans4_FlowCM_TEMPERATURE; \
	VARIABLE trans4_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans4_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans4_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans4_FlowCM_TEMPERATURE_page; \
	COMMAND trans4_FlowCM_TEMPERATURE_read; \
	VARIABLE trans4_FlowCM_TEMPERATURE_UNITS; \
	MENU trans4_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans4_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans4_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans4_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans4_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans4_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans4_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans4_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans4_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans4_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans4_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans4_FlowCM_unit_nominal_size; \
	UNIT trans4_FlowCM_unit_zero_point; \
	UNIT trans4_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans4_FlowCM_unit_density; \
	UNIT trans4_FlowCM_unit_temperature

#define USE_TRANS4_FLOWCM_MANDATORY_A \
	USE_TRANS4_FLOWCM_MANDATORY_BOTH; \
	MENU trans4_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS4_FLOWCM_MANDATORY_B \
	USE_TRANS4_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans4_FlowCM_VIEW_1; \
	MENU trans4_FlowCM_VIEW_1_page; \
	MENU trans4_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS4_FLOWCM_OPTIONAL_A \
	COLLECTION trans4_FlowCM_VIEW_1; \
	MENU trans4_FlowCM_VIEW_1_page; \
	MENU trans4_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS4_FLOWCM_OPTIONAL_B \
	MENU trans4_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS4_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans4_FlowCM_)
#define USE_TRANS4_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans4_FlowCM_)
#define USE_TRANS4_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans4_FlowCM_)
#define USE_TRANS4_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans4_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS5_FLOWCM_MANDATORY_BOTH \
	BLOCK trans5_FlowCM_block; \
	COLLECTION trans5_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans5_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans5_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans5_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans5_FlowCM_ST_REV; \
	MENU trans5_FlowCM_ST_REV_page; \
	COMMAND trans5_FlowCM_ST_REV_read; \
	VARIABLE trans5_FlowCM_TAG_DESC; \
	MENU trans5_FlowCM_TAG_DESC_page; \
	COMMAND trans5_FlowCM_TAG_DESC_read; \
	COMMAND trans5_FlowCM_TAG_DESC_write; \
	VARIABLE trans5_FlowCM_STRATEGY; \
	MENU trans5_FlowCM_STRATEGY_page; \
	COMMAND trans5_FlowCM_STRATEGY_read; \
	COMMAND trans5_FlowCM_STRATEGY_write; \
	VARIABLE trans5_FlowCM_ALERT_KEY; \
	MENU trans5_FlowCM_ALERT_KEY_page; \
	COMMAND trans5_FlowCM_ALERT_KEY_read; \
	COMMAND trans5_FlowCM_ALERT_KEY_write; \
	VARIABLE trans5_FlowCM_TARGET_MODE; \
	MENU trans5_FlowCM_TARGET_MODE_page; \
	COMMAND trans5_FlowCM_TARGET_MODE_read; \
	COMMAND trans5_FlowCM_TARGET_MODE_write; \
	COLLECTION trans5_FlowCM_MODE_BLK; \
	VARIABLE trans5_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans5_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans5_FlowCM_MODE_BLK_Normal; \
	MENU trans5_FlowCM_MODE_BLK_page; \
	COMMAND trans5_FlowCM_MODE_BLK_read; \
	COLLECTION trans5_FlowCM_ALARM_SUM; \
	VARIABLE trans5_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans5_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans5_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans5_FlowCM_ALARM_SUM_Disabled; \
	MENU trans5_FlowCM_ALARM_SUM_page; \
	COMMAND trans5_FlowCM_ALARM_SUM_read; \
	VARIABLE trans5_FlowCM_CALIBR_FACTOR; \
	MENU trans5_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans5_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans5_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans5_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans5_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans5_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans5_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans5_FlowCM_MEASUREMENT_MODE; \
	MENU trans5_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans5_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans5_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans5_FlowCM_FLOW_DIRECTION; \
	MENU trans5_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans5_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans5_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans5_FlowCM_ZERO_POINT; \
	MENU trans5_FlowCM_ZERO_POINT_page; \
	COMMAND trans5_FlowCM_ZERO_POINT_read; \
	COMMAND trans5_FlowCM_ZERO_POINT_write; \
	VARIABLE trans5_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans5_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans5_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans5_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans5_FlowCM_ZERO_POINT_UNIT; \
	MENU trans5_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans5_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans5_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans5_FlowCM_NOMINAL_SIZE; \
	MENU trans5_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans5_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans5_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans5_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans5_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans5_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans5_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans5_FlowCM_MASS_FLOW; \
	VARIABLE trans5_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans5_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans5_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans5_FlowCM_MASS_FLOW_page; \
	COMMAND trans5_FlowCM_MASS_FLOW_read; \
	VARIABLE trans5_FlowCM_MASS_FLOW_UNITS; \
	MENU trans5_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans5_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans5_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans5_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans5_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans5_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans5_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans5_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans5_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans5_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans5_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans5_FlowCM_DENSITY; \
	VARIABLE trans5_FlowCM_DENSITY_Value; \
	VARIABLE trans5_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans5_FlowCM_DENSITY_Status_Limit; \
	MENU trans5_FlowCM_DENSITY_page; \
	COMMAND trans5_FlowCM_DENSITY_read; \
	VARIABLE trans5_FlowCM_DENSITY_UNITS; \
	MENU trans5_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans5_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans5_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans5_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans5_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans5_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans5_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans5_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans5_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans5_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans5_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans5_FlowCM_TEMPERATURE; \
	VARIABLE trans5_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans5_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans5_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans5_FlowCM_TEMPERATURE_page; \
	COMMAND trans5_FlowCM_TEMPERATURE_read; \
	VARIABLE trans5_FlowCM_TEMPERATURE_UNITS; \
	MENU trans5_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans5_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans5_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans5_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans5_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans5_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans5_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans5_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans5_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans5_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans5_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans5_FlowCM_unit_nominal_size; \
	UNIT trans5_FlowCM_unit_zero_point; \
	UNIT trans5_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans5_FlowCM_unit_density; \
	UNIT trans5_FlowCM_unit_temperature

#define USE_TRANS5_FLOWCM_MANDATORY_A \
	USE_TRANS5_FLOWCM_MANDATORY_BOTH; \
	MENU trans5_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS5_FLOWCM_MANDATORY_B \
	USE_TRANS5_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans5_FlowCM_VIEW_1; \
	MENU trans5_FlowCM_VIEW_1_page; \
	MENU trans5_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS5_FLOWCM_OPTIONAL_A \
	COLLECTION trans5_FlowCM_VIEW_1; \
	MENU trans5_FlowCM_VIEW_1_page; \
	MENU trans5_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS5_FLOWCM_OPTIONAL_B \
	MENU trans5_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS5_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans5_FlowCM_)
#define USE_TRANS5_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans5_FlowCM_)
#define USE_TRANS5_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans5_FlowCM_)
#define USE_TRANS5_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans5_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS6_FLOWCM_MANDATORY_BOTH \
	BLOCK trans6_FlowCM_block; \
	COLLECTION trans6_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans6_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans6_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans6_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans6_FlowCM_ST_REV; \
	MENU trans6_FlowCM_ST_REV_page; \
	COMMAND trans6_FlowCM_ST_REV_read; \
	VARIABLE trans6_FlowCM_TAG_DESC; \
	MENU trans6_FlowCM_TAG_DESC_page; \
	COMMAND trans6_FlowCM_TAG_DESC_read; \
	COMMAND trans6_FlowCM_TAG_DESC_write; \
	VARIABLE trans6_FlowCM_STRATEGY; \
	MENU trans6_FlowCM_STRATEGY_page; \
	COMMAND trans6_FlowCM_STRATEGY_read; \
	COMMAND trans6_FlowCM_STRATEGY_write; \
	VARIABLE trans6_FlowCM_ALERT_KEY; \
	MENU trans6_FlowCM_ALERT_KEY_page; \
	COMMAND trans6_FlowCM_ALERT_KEY_read; \
	COMMAND trans6_FlowCM_ALERT_KEY_write; \
	VARIABLE trans6_FlowCM_TARGET_MODE; \
	MENU trans6_FlowCM_TARGET_MODE_page; \
	COMMAND trans6_FlowCM_TARGET_MODE_read; \
	COMMAND trans6_FlowCM_TARGET_MODE_write; \
	COLLECTION trans6_FlowCM_MODE_BLK; \
	VARIABLE trans6_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans6_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans6_FlowCM_MODE_BLK_Normal; \
	MENU trans6_FlowCM_MODE_BLK_page; \
	COMMAND trans6_FlowCM_MODE_BLK_read; \
	COLLECTION trans6_FlowCM_ALARM_SUM; \
	VARIABLE trans6_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans6_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans6_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans6_FlowCM_ALARM_SUM_Disabled; \
	MENU trans6_FlowCM_ALARM_SUM_page; \
	COMMAND trans6_FlowCM_ALARM_SUM_read; \
	VARIABLE trans6_FlowCM_CALIBR_FACTOR; \
	MENU trans6_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans6_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans6_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans6_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans6_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans6_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans6_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans6_FlowCM_MEASUREMENT_MODE; \
	MENU trans6_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans6_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans6_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans6_FlowCM_FLOW_DIRECTION; \
	MENU trans6_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans6_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans6_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans6_FlowCM_ZERO_POINT; \
	MENU trans6_FlowCM_ZERO_POINT_page; \
	COMMAND trans6_FlowCM_ZERO_POINT_read; \
	COMMAND trans6_FlowCM_ZERO_POINT_write; \
	VARIABLE trans6_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans6_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans6_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans6_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans6_FlowCM_ZERO_POINT_UNIT; \
	MENU trans6_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans6_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans6_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans6_FlowCM_NOMINAL_SIZE; \
	MENU trans6_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans6_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans6_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans6_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans6_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans6_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans6_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans6_FlowCM_MASS_FLOW; \
	VARIABLE trans6_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans6_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans6_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans6_FlowCM_MASS_FLOW_page; \
	COMMAND trans6_FlowCM_MASS_FLOW_read; \
	VARIABLE trans6_FlowCM_MASS_FLOW_UNITS; \
	MENU trans6_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans6_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans6_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans6_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans6_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans6_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans6_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans6_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans6_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans6_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans6_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans6_FlowCM_DENSITY; \
	VARIABLE trans6_FlowCM_DENSITY_Value; \
	VARIABLE trans6_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans6_FlowCM_DENSITY_Status_Limit; \
	MENU trans6_FlowCM_DENSITY_page; \
	COMMAND trans6_FlowCM_DENSITY_read; \
	VARIABLE trans6_FlowCM_DENSITY_UNITS; \
	MENU trans6_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans6_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans6_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans6_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans6_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans6_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans6_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans6_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans6_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans6_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans6_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans6_FlowCM_TEMPERATURE; \
	VARIABLE trans6_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans6_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans6_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans6_FlowCM_TEMPERATURE_page; \
	COMMAND trans6_FlowCM_TEMPERATURE_read; \
	VARIABLE trans6_FlowCM_TEMPERATURE_UNITS; \
	MENU trans6_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans6_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans6_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans6_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans6_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans6_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans6_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans6_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans6_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans6_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans6_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans6_FlowCM_unit_nominal_size; \
	UNIT trans6_FlowCM_unit_zero_point; \
	UNIT trans6_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans6_FlowCM_unit_density; \
	UNIT trans6_FlowCM_unit_temperature

#define USE_TRANS6_FLOWCM_MANDATORY_A \
	USE_TRANS6_FLOWCM_MANDATORY_BOTH; \
	MENU trans6_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS6_FLOWCM_MANDATORY_B \
	USE_TRANS6_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans6_FlowCM_VIEW_1; \
	MENU trans6_FlowCM_VIEW_1_page; \
	MENU trans6_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS6_FLOWCM_OPTIONAL_A \
	COLLECTION trans6_FlowCM_VIEW_1; \
	MENU trans6_FlowCM_VIEW_1_page; \
	MENU trans6_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS6_FLOWCM_OPTIONAL_B \
	MENU trans6_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS6_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans6_FlowCM_)
#define USE_TRANS6_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans6_FlowCM_)
#define USE_TRANS6_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans6_FlowCM_)
#define USE_TRANS6_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans6_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS7_FLOWCM_MANDATORY_BOTH \
	BLOCK trans7_FlowCM_block; \
	COLLECTION trans7_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans7_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans7_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans7_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans7_FlowCM_ST_REV; \
	MENU trans7_FlowCM_ST_REV_page; \
	COMMAND trans7_FlowCM_ST_REV_read; \
	VARIABLE trans7_FlowCM_TAG_DESC; \
	MENU trans7_FlowCM_TAG_DESC_page; \
	COMMAND trans7_FlowCM_TAG_DESC_read; \
	COMMAND trans7_FlowCM_TAG_DESC_write; \
	VARIABLE trans7_FlowCM_STRATEGY; \
	MENU trans7_FlowCM_STRATEGY_page; \
	COMMAND trans7_FlowCM_STRATEGY_read; \
	COMMAND trans7_FlowCM_STRATEGY_write; \
	VARIABLE trans7_FlowCM_ALERT_KEY; \
	MENU trans7_FlowCM_ALERT_KEY_page; \
	COMMAND trans7_FlowCM_ALERT_KEY_read; \
	COMMAND trans7_FlowCM_ALERT_KEY_write; \
	VARIABLE trans7_FlowCM_TARGET_MODE; \
	MENU trans7_FlowCM_TARGET_MODE_page; \
	COMMAND trans7_FlowCM_TARGET_MODE_read; \
	COMMAND trans7_FlowCM_TARGET_MODE_write; \
	COLLECTION trans7_FlowCM_MODE_BLK; \
	VARIABLE trans7_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans7_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans7_FlowCM_MODE_BLK_Normal; \
	MENU trans7_FlowCM_MODE_BLK_page; \
	COMMAND trans7_FlowCM_MODE_BLK_read; \
	COLLECTION trans7_FlowCM_ALARM_SUM; \
	VARIABLE trans7_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans7_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans7_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans7_FlowCM_ALARM_SUM_Disabled; \
	MENU trans7_FlowCM_ALARM_SUM_page; \
	COMMAND trans7_FlowCM_ALARM_SUM_read; \
	VARIABLE trans7_FlowCM_CALIBR_FACTOR; \
	MENU trans7_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans7_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans7_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans7_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans7_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans7_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans7_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans7_FlowCM_MEASUREMENT_MODE; \
	MENU trans7_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans7_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans7_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans7_FlowCM_FLOW_DIRECTION; \
	MENU trans7_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans7_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans7_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans7_FlowCM_ZERO_POINT; \
	MENU trans7_FlowCM_ZERO_POINT_page; \
	COMMAND trans7_FlowCM_ZERO_POINT_read; \
	COMMAND trans7_FlowCM_ZERO_POINT_write; \
	VARIABLE trans7_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans7_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans7_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans7_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans7_FlowCM_ZERO_POINT_UNIT; \
	MENU trans7_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans7_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans7_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans7_FlowCM_NOMINAL_SIZE; \
	MENU trans7_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans7_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans7_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans7_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans7_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans7_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans7_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans7_FlowCM_MASS_FLOW; \
	VARIABLE trans7_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans7_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans7_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans7_FlowCM_MASS_FLOW_page; \
	COMMAND trans7_FlowCM_MASS_FLOW_read; \
	VARIABLE trans7_FlowCM_MASS_FLOW_UNITS; \
	MENU trans7_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans7_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans7_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans7_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans7_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans7_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans7_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans7_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans7_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans7_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans7_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans7_FlowCM_DENSITY; \
	VARIABLE trans7_FlowCM_DENSITY_Value; \
	VARIABLE trans7_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans7_FlowCM_DENSITY_Status_Limit; \
	MENU trans7_FlowCM_DENSITY_page; \
	COMMAND trans7_FlowCM_DENSITY_read; \
	VARIABLE trans7_FlowCM_DENSITY_UNITS; \
	MENU trans7_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans7_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans7_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans7_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans7_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans7_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans7_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans7_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans7_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans7_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans7_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans7_FlowCM_TEMPERATURE; \
	VARIABLE trans7_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans7_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans7_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans7_FlowCM_TEMPERATURE_page; \
	COMMAND trans7_FlowCM_TEMPERATURE_read; \
	VARIABLE trans7_FlowCM_TEMPERATURE_UNITS; \
	MENU trans7_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans7_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans7_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans7_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans7_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans7_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans7_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans7_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans7_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans7_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans7_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans7_FlowCM_unit_nominal_size; \
	UNIT trans7_FlowCM_unit_zero_point; \
	UNIT trans7_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans7_FlowCM_unit_density; \
	UNIT trans7_FlowCM_unit_temperature

#define USE_TRANS7_FLOWCM_MANDATORY_A \
	USE_TRANS7_FLOWCM_MANDATORY_BOTH; \
	MENU trans7_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS7_FLOWCM_MANDATORY_B \
	USE_TRANS7_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans7_FlowCM_VIEW_1; \
	MENU trans7_FlowCM_VIEW_1_page; \
	MENU trans7_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS7_FLOWCM_OPTIONAL_A \
	COLLECTION trans7_FlowCM_VIEW_1; \
	MENU trans7_FlowCM_VIEW_1_page; \
	MENU trans7_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS7_FLOWCM_OPTIONAL_B \
	MENU trans7_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS7_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans7_FlowCM_)
#define USE_TRANS7_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans7_FlowCM_)
#define USE_TRANS7_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans7_FlowCM_)
#define USE_TRANS7_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans7_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS8_FLOWCM_MANDATORY_BOTH \
	BLOCK trans8_FlowCM_block; \
	COLLECTION trans8_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans8_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans8_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans8_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans8_FlowCM_ST_REV; \
	MENU trans8_FlowCM_ST_REV_page; \
	COMMAND trans8_FlowCM_ST_REV_read; \
	VARIABLE trans8_FlowCM_TAG_DESC; \
	MENU trans8_FlowCM_TAG_DESC_page; \
	COMMAND trans8_FlowCM_TAG_DESC_read; \
	COMMAND trans8_FlowCM_TAG_DESC_write; \
	VARIABLE trans8_FlowCM_STRATEGY; \
	MENU trans8_FlowCM_STRATEGY_page; \
	COMMAND trans8_FlowCM_STRATEGY_read; \
	COMMAND trans8_FlowCM_STRATEGY_write; \
	VARIABLE trans8_FlowCM_ALERT_KEY; \
	MENU trans8_FlowCM_ALERT_KEY_page; \
	COMMAND trans8_FlowCM_ALERT_KEY_read; \
	COMMAND trans8_FlowCM_ALERT_KEY_write; \
	VARIABLE trans8_FlowCM_TARGET_MODE; \
	MENU trans8_FlowCM_TARGET_MODE_page; \
	COMMAND trans8_FlowCM_TARGET_MODE_read; \
	COMMAND trans8_FlowCM_TARGET_MODE_write; \
	COLLECTION trans8_FlowCM_MODE_BLK; \
	VARIABLE trans8_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans8_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans8_FlowCM_MODE_BLK_Normal; \
	MENU trans8_FlowCM_MODE_BLK_page; \
	COMMAND trans8_FlowCM_MODE_BLK_read; \
	COLLECTION trans8_FlowCM_ALARM_SUM; \
	VARIABLE trans8_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans8_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans8_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans8_FlowCM_ALARM_SUM_Disabled; \
	MENU trans8_FlowCM_ALARM_SUM_page; \
	COMMAND trans8_FlowCM_ALARM_SUM_read; \
	VARIABLE trans8_FlowCM_CALIBR_FACTOR; \
	MENU trans8_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans8_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans8_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans8_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans8_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans8_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans8_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans8_FlowCM_MEASUREMENT_MODE; \
	MENU trans8_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans8_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans8_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans8_FlowCM_FLOW_DIRECTION; \
	MENU trans8_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans8_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans8_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans8_FlowCM_ZERO_POINT; \
	MENU trans8_FlowCM_ZERO_POINT_page; \
	COMMAND trans8_FlowCM_ZERO_POINT_read; \
	COMMAND trans8_FlowCM_ZERO_POINT_write; \
	VARIABLE trans8_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans8_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans8_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans8_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans8_FlowCM_ZERO_POINT_UNIT; \
	MENU trans8_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans8_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans8_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans8_FlowCM_NOMINAL_SIZE; \
	MENU trans8_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans8_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans8_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans8_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans8_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans8_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans8_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans8_FlowCM_MASS_FLOW; \
	VARIABLE trans8_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans8_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans8_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans8_FlowCM_MASS_FLOW_page; \
	COMMAND trans8_FlowCM_MASS_FLOW_read; \
	VARIABLE trans8_FlowCM_MASS_FLOW_UNITS; \
	MENU trans8_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans8_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans8_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans8_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans8_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans8_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans8_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans8_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans8_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans8_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans8_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans8_FlowCM_DENSITY; \
	VARIABLE trans8_FlowCM_DENSITY_Value; \
	VARIABLE trans8_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans8_FlowCM_DENSITY_Status_Limit; \
	MENU trans8_FlowCM_DENSITY_page; \
	COMMAND trans8_FlowCM_DENSITY_read; \
	VARIABLE trans8_FlowCM_DENSITY_UNITS; \
	MENU trans8_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans8_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans8_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans8_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans8_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans8_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans8_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans8_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans8_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans8_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans8_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans8_FlowCM_TEMPERATURE; \
	VARIABLE trans8_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans8_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans8_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans8_FlowCM_TEMPERATURE_page; \
	COMMAND trans8_FlowCM_TEMPERATURE_read; \
	VARIABLE trans8_FlowCM_TEMPERATURE_UNITS; \
	MENU trans8_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans8_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans8_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans8_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans8_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans8_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans8_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans8_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans8_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans8_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans8_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans8_FlowCM_unit_nominal_size; \
	UNIT trans8_FlowCM_unit_zero_point; \
	UNIT trans8_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans8_FlowCM_unit_density; \
	UNIT trans8_FlowCM_unit_temperature

#define USE_TRANS8_FLOWCM_MANDATORY_A \
	USE_TRANS8_FLOWCM_MANDATORY_BOTH; \
	MENU trans8_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS8_FLOWCM_MANDATORY_B \
	USE_TRANS8_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans8_FlowCM_VIEW_1; \
	MENU trans8_FlowCM_VIEW_1_page; \
	MENU trans8_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS8_FLOWCM_OPTIONAL_A \
	COLLECTION trans8_FlowCM_VIEW_1; \
	MENU trans8_FlowCM_VIEW_1_page; \
	MENU trans8_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS8_FLOWCM_OPTIONAL_B \
	MENU trans8_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS8_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans8_FlowCM_)
#define USE_TRANS8_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans8_FlowCM_)
#define USE_TRANS8_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans8_FlowCM_)
#define USE_TRANS8_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans8_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS9_FLOWCM_MANDATORY_BOTH \
	BLOCK trans9_FlowCM_block; \
	COLLECTION trans9_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans9_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans9_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans9_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans9_FlowCM_ST_REV; \
	MENU trans9_FlowCM_ST_REV_page; \
	COMMAND trans9_FlowCM_ST_REV_read; \
	VARIABLE trans9_FlowCM_TAG_DESC; \
	MENU trans9_FlowCM_TAG_DESC_page; \
	COMMAND trans9_FlowCM_TAG_DESC_read; \
	COMMAND trans9_FlowCM_TAG_DESC_write; \
	VARIABLE trans9_FlowCM_STRATEGY; \
	MENU trans9_FlowCM_STRATEGY_page; \
	COMMAND trans9_FlowCM_STRATEGY_read; \
	COMMAND trans9_FlowCM_STRATEGY_write; \
	VARIABLE trans9_FlowCM_ALERT_KEY; \
	MENU trans9_FlowCM_ALERT_KEY_page; \
	COMMAND trans9_FlowCM_ALERT_KEY_read; \
	COMMAND trans9_FlowCM_ALERT_KEY_write; \
	VARIABLE trans9_FlowCM_TARGET_MODE; \
	MENU trans9_FlowCM_TARGET_MODE_page; \
	COMMAND trans9_FlowCM_TARGET_MODE_read; \
	COMMAND trans9_FlowCM_TARGET_MODE_write; \
	COLLECTION trans9_FlowCM_MODE_BLK; \
	VARIABLE trans9_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans9_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans9_FlowCM_MODE_BLK_Normal; \
	MENU trans9_FlowCM_MODE_BLK_page; \
	COMMAND trans9_FlowCM_MODE_BLK_read; \
	COLLECTION trans9_FlowCM_ALARM_SUM; \
	VARIABLE trans9_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans9_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans9_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans9_FlowCM_ALARM_SUM_Disabled; \
	MENU trans9_FlowCM_ALARM_SUM_page; \
	COMMAND trans9_FlowCM_ALARM_SUM_read; \
	VARIABLE trans9_FlowCM_CALIBR_FACTOR; \
	MENU trans9_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans9_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans9_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans9_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans9_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans9_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans9_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans9_FlowCM_MEASUREMENT_MODE; \
	MENU trans9_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans9_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans9_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans9_FlowCM_FLOW_DIRECTION; \
	MENU trans9_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans9_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans9_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans9_FlowCM_ZERO_POINT; \
	MENU trans9_FlowCM_ZERO_POINT_page; \
	COMMAND trans9_FlowCM_ZERO_POINT_read; \
	COMMAND trans9_FlowCM_ZERO_POINT_write; \
	VARIABLE trans9_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans9_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans9_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans9_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans9_FlowCM_ZERO_POINT_UNIT; \
	MENU trans9_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans9_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans9_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans9_FlowCM_NOMINAL_SIZE; \
	MENU trans9_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans9_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans9_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans9_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans9_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans9_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans9_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans9_FlowCM_MASS_FLOW; \
	VARIABLE trans9_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans9_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans9_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans9_FlowCM_MASS_FLOW_page; \
	COMMAND trans9_FlowCM_MASS_FLOW_read; \
	VARIABLE trans9_FlowCM_MASS_FLOW_UNITS; \
	MENU trans9_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans9_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans9_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans9_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans9_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans9_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans9_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans9_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans9_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans9_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans9_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans9_FlowCM_DENSITY; \
	VARIABLE trans9_FlowCM_DENSITY_Value; \
	VARIABLE trans9_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans9_FlowCM_DENSITY_Status_Limit; \
	MENU trans9_FlowCM_DENSITY_page; \
	COMMAND trans9_FlowCM_DENSITY_read; \
	VARIABLE trans9_FlowCM_DENSITY_UNITS; \
	MENU trans9_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans9_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans9_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans9_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans9_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans9_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans9_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans9_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans9_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans9_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans9_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans9_FlowCM_TEMPERATURE; \
	VARIABLE trans9_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans9_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans9_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans9_FlowCM_TEMPERATURE_page; \
	COMMAND trans9_FlowCM_TEMPERATURE_read; \
	VARIABLE trans9_FlowCM_TEMPERATURE_UNITS; \
	MENU trans9_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans9_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans9_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans9_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans9_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans9_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans9_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans9_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans9_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans9_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans9_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans9_FlowCM_unit_nominal_size; \
	UNIT trans9_FlowCM_unit_zero_point; \
	UNIT trans9_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans9_FlowCM_unit_density; \
	UNIT trans9_FlowCM_unit_temperature

#define USE_TRANS9_FLOWCM_MANDATORY_A \
	USE_TRANS9_FLOWCM_MANDATORY_BOTH; \
	MENU trans9_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS9_FLOWCM_MANDATORY_B \
	USE_TRANS9_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans9_FlowCM_VIEW_1; \
	MENU trans9_FlowCM_VIEW_1_page; \
	MENU trans9_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS9_FLOWCM_OPTIONAL_A \
	COLLECTION trans9_FlowCM_VIEW_1; \
	MENU trans9_FlowCM_VIEW_1_page; \
	MENU trans9_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS9_FLOWCM_OPTIONAL_B \
	MENU trans9_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS9_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans9_FlowCM_)
#define USE_TRANS9_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans9_FlowCM_)
#define USE_TRANS9_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans9_FlowCM_)
#define USE_TRANS9_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans9_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS10_FLOWCM_MANDATORY_BOTH \
	BLOCK trans10_FlowCM_block; \
	COLLECTION trans10_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans10_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans10_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans10_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans10_FlowCM_ST_REV; \
	MENU trans10_FlowCM_ST_REV_page; \
	COMMAND trans10_FlowCM_ST_REV_read; \
	VARIABLE trans10_FlowCM_TAG_DESC; \
	MENU trans10_FlowCM_TAG_DESC_page; \
	COMMAND trans10_FlowCM_TAG_DESC_read; \
	COMMAND trans10_FlowCM_TAG_DESC_write; \
	VARIABLE trans10_FlowCM_STRATEGY; \
	MENU trans10_FlowCM_STRATEGY_page; \
	COMMAND trans10_FlowCM_STRATEGY_read; \
	COMMAND trans10_FlowCM_STRATEGY_write; \
	VARIABLE trans10_FlowCM_ALERT_KEY; \
	MENU trans10_FlowCM_ALERT_KEY_page; \
	COMMAND trans10_FlowCM_ALERT_KEY_read; \
	COMMAND trans10_FlowCM_ALERT_KEY_write; \
	VARIABLE trans10_FlowCM_TARGET_MODE; \
	MENU trans10_FlowCM_TARGET_MODE_page; \
	COMMAND trans10_FlowCM_TARGET_MODE_read; \
	COMMAND trans10_FlowCM_TARGET_MODE_write; \
	COLLECTION trans10_FlowCM_MODE_BLK; \
	VARIABLE trans10_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans10_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans10_FlowCM_MODE_BLK_Normal; \
	MENU trans10_FlowCM_MODE_BLK_page; \
	COMMAND trans10_FlowCM_MODE_BLK_read; \
	COLLECTION trans10_FlowCM_ALARM_SUM; \
	VARIABLE trans10_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans10_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans10_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans10_FlowCM_ALARM_SUM_Disabled; \
	MENU trans10_FlowCM_ALARM_SUM_page; \
	COMMAND trans10_FlowCM_ALARM_SUM_read; \
	VARIABLE trans10_FlowCM_CALIBR_FACTOR; \
	MENU trans10_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans10_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans10_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans10_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans10_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans10_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans10_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans10_FlowCM_MEASUREMENT_MODE; \
	MENU trans10_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans10_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans10_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans10_FlowCM_FLOW_DIRECTION; \
	MENU trans10_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans10_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans10_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans10_FlowCM_ZERO_POINT; \
	MENU trans10_FlowCM_ZERO_POINT_page; \
	COMMAND trans10_FlowCM_ZERO_POINT_read; \
	COMMAND trans10_FlowCM_ZERO_POINT_write; \
	VARIABLE trans10_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans10_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans10_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans10_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans10_FlowCM_ZERO_POINT_UNIT; \
	MENU trans10_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans10_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans10_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans10_FlowCM_NOMINAL_SIZE; \
	MENU trans10_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans10_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans10_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans10_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans10_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans10_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans10_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans10_FlowCM_MASS_FLOW; \
	VARIABLE trans10_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans10_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans10_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans10_FlowCM_MASS_FLOW_page; \
	COMMAND trans10_FlowCM_MASS_FLOW_read; \
	VARIABLE trans10_FlowCM_MASS_FLOW_UNITS; \
	MENU trans10_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans10_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans10_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans10_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans10_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans10_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans10_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans10_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans10_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans10_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans10_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans10_FlowCM_DENSITY; \
	VARIABLE trans10_FlowCM_DENSITY_Value; \
	VARIABLE trans10_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans10_FlowCM_DENSITY_Status_Limit; \
	MENU trans10_FlowCM_DENSITY_page; \
	COMMAND trans10_FlowCM_DENSITY_read; \
	VARIABLE trans10_FlowCM_DENSITY_UNITS; \
	MENU trans10_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans10_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans10_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans10_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans10_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans10_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans10_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans10_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans10_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans10_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans10_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans10_FlowCM_TEMPERATURE; \
	VARIABLE trans10_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans10_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans10_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans10_FlowCM_TEMPERATURE_page; \
	COMMAND trans10_FlowCM_TEMPERATURE_read; \
	VARIABLE trans10_FlowCM_TEMPERATURE_UNITS; \
	MENU trans10_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans10_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans10_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans10_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans10_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans10_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans10_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans10_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans10_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans10_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans10_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans10_FlowCM_unit_nominal_size; \
	UNIT trans10_FlowCM_unit_zero_point; \
	UNIT trans10_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans10_FlowCM_unit_density; \
	UNIT trans10_FlowCM_unit_temperature

#define USE_TRANS10_FLOWCM_MANDATORY_A \
	USE_TRANS10_FLOWCM_MANDATORY_BOTH; \
	MENU trans10_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS10_FLOWCM_MANDATORY_B \
	USE_TRANS10_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans10_FlowCM_VIEW_1; \
	MENU trans10_FlowCM_VIEW_1_page; \
	MENU trans10_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS10_FLOWCM_OPTIONAL_A \
	COLLECTION trans10_FlowCM_VIEW_1; \
	MENU trans10_FlowCM_VIEW_1_page; \
	MENU trans10_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS10_FLOWCM_OPTIONAL_B \
	MENU trans10_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS10_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans10_FlowCM_)
#define USE_TRANS10_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans10_FlowCM_)
#define USE_TRANS10_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans10_FlowCM_)
#define USE_TRANS10_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans10_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS11_FLOWCM_MANDATORY_BOTH \
	BLOCK trans11_FlowCM_block; \
	COLLECTION trans11_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans11_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans11_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans11_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans11_FlowCM_ST_REV; \
	MENU trans11_FlowCM_ST_REV_page; \
	COMMAND trans11_FlowCM_ST_REV_read; \
	VARIABLE trans11_FlowCM_TAG_DESC; \
	MENU trans11_FlowCM_TAG_DESC_page; \
	COMMAND trans11_FlowCM_TAG_DESC_read; \
	COMMAND trans11_FlowCM_TAG_DESC_write; \
	VARIABLE trans11_FlowCM_STRATEGY; \
	MENU trans11_FlowCM_STRATEGY_page; \
	COMMAND trans11_FlowCM_STRATEGY_read; \
	COMMAND trans11_FlowCM_STRATEGY_write; \
	VARIABLE trans11_FlowCM_ALERT_KEY; \
	MENU trans11_FlowCM_ALERT_KEY_page; \
	COMMAND trans11_FlowCM_ALERT_KEY_read; \
	COMMAND trans11_FlowCM_ALERT_KEY_write; \
	VARIABLE trans11_FlowCM_TARGET_MODE; \
	MENU trans11_FlowCM_TARGET_MODE_page; \
	COMMAND trans11_FlowCM_TARGET_MODE_read; \
	COMMAND trans11_FlowCM_TARGET_MODE_write; \
	COLLECTION trans11_FlowCM_MODE_BLK; \
	VARIABLE trans11_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans11_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans11_FlowCM_MODE_BLK_Normal; \
	MENU trans11_FlowCM_MODE_BLK_page; \
	COMMAND trans11_FlowCM_MODE_BLK_read; \
	COLLECTION trans11_FlowCM_ALARM_SUM; \
	VARIABLE trans11_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans11_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans11_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans11_FlowCM_ALARM_SUM_Disabled; \
	MENU trans11_FlowCM_ALARM_SUM_page; \
	COMMAND trans11_FlowCM_ALARM_SUM_read; \
	VARIABLE trans11_FlowCM_CALIBR_FACTOR; \
	MENU trans11_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans11_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans11_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans11_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans11_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans11_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans11_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans11_FlowCM_MEASUREMENT_MODE; \
	MENU trans11_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans11_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans11_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans11_FlowCM_FLOW_DIRECTION; \
	MENU trans11_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans11_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans11_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans11_FlowCM_ZERO_POINT; \
	MENU trans11_FlowCM_ZERO_POINT_page; \
	COMMAND trans11_FlowCM_ZERO_POINT_read; \
	COMMAND trans11_FlowCM_ZERO_POINT_write; \
	VARIABLE trans11_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans11_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans11_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans11_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans11_FlowCM_ZERO_POINT_UNIT; \
	MENU trans11_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans11_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans11_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans11_FlowCM_NOMINAL_SIZE; \
	MENU trans11_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans11_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans11_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans11_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans11_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans11_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans11_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans11_FlowCM_MASS_FLOW; \
	VARIABLE trans11_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans11_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans11_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans11_FlowCM_MASS_FLOW_page; \
	COMMAND trans11_FlowCM_MASS_FLOW_read; \
	VARIABLE trans11_FlowCM_MASS_FLOW_UNITS; \
	MENU trans11_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans11_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans11_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans11_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans11_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans11_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans11_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans11_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans11_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans11_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans11_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans11_FlowCM_DENSITY; \
	VARIABLE trans11_FlowCM_DENSITY_Value; \
	VARIABLE trans11_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans11_FlowCM_DENSITY_Status_Limit; \
	MENU trans11_FlowCM_DENSITY_page; \
	COMMAND trans11_FlowCM_DENSITY_read; \
	VARIABLE trans11_FlowCM_DENSITY_UNITS; \
	MENU trans11_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans11_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans11_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans11_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans11_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans11_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans11_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans11_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans11_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans11_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans11_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans11_FlowCM_TEMPERATURE; \
	VARIABLE trans11_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans11_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans11_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans11_FlowCM_TEMPERATURE_page; \
	COMMAND trans11_FlowCM_TEMPERATURE_read; \
	VARIABLE trans11_FlowCM_TEMPERATURE_UNITS; \
	MENU trans11_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans11_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans11_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans11_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans11_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans11_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans11_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans11_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans11_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans11_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans11_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans11_FlowCM_unit_nominal_size; \
	UNIT trans11_FlowCM_unit_zero_point; \
	UNIT trans11_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans11_FlowCM_unit_density; \
	UNIT trans11_FlowCM_unit_temperature

#define USE_TRANS11_FLOWCM_MANDATORY_A \
	USE_TRANS11_FLOWCM_MANDATORY_BOTH; \
	MENU trans11_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS11_FLOWCM_MANDATORY_B \
	USE_TRANS11_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans11_FlowCM_VIEW_1; \
	MENU trans11_FlowCM_VIEW_1_page; \
	MENU trans11_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS11_FLOWCM_OPTIONAL_A \
	COLLECTION trans11_FlowCM_VIEW_1; \
	MENU trans11_FlowCM_VIEW_1_page; \
	MENU trans11_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS11_FLOWCM_OPTIONAL_B \
	MENU trans11_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS11_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans11_FlowCM_)
#define USE_TRANS11_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans11_FlowCM_)
#define USE_TRANS11_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans11_FlowCM_)
#define USE_TRANS11_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans11_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS12_FLOWCM_MANDATORY_BOTH \
	BLOCK trans12_FlowCM_block; \
	COLLECTION trans12_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans12_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans12_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans12_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans12_FlowCM_ST_REV; \
	MENU trans12_FlowCM_ST_REV_page; \
	COMMAND trans12_FlowCM_ST_REV_read; \
	VARIABLE trans12_FlowCM_TAG_DESC; \
	MENU trans12_FlowCM_TAG_DESC_page; \
	COMMAND trans12_FlowCM_TAG_DESC_read; \
	COMMAND trans12_FlowCM_TAG_DESC_write; \
	VARIABLE trans12_FlowCM_STRATEGY; \
	MENU trans12_FlowCM_STRATEGY_page; \
	COMMAND trans12_FlowCM_STRATEGY_read; \
	COMMAND trans12_FlowCM_STRATEGY_write; \
	VARIABLE trans12_FlowCM_ALERT_KEY; \
	MENU trans12_FlowCM_ALERT_KEY_page; \
	COMMAND trans12_FlowCM_ALERT_KEY_read; \
	COMMAND trans12_FlowCM_ALERT_KEY_write; \
	VARIABLE trans12_FlowCM_TARGET_MODE; \
	MENU trans12_FlowCM_TARGET_MODE_page; \
	COMMAND trans12_FlowCM_TARGET_MODE_read; \
	COMMAND trans12_FlowCM_TARGET_MODE_write; \
	COLLECTION trans12_FlowCM_MODE_BLK; \
	VARIABLE trans12_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans12_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans12_FlowCM_MODE_BLK_Normal; \
	MENU trans12_FlowCM_MODE_BLK_page; \
	COMMAND trans12_FlowCM_MODE_BLK_read; \
	COLLECTION trans12_FlowCM_ALARM_SUM; \
	VARIABLE trans12_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans12_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans12_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans12_FlowCM_ALARM_SUM_Disabled; \
	MENU trans12_FlowCM_ALARM_SUM_page; \
	COMMAND trans12_FlowCM_ALARM_SUM_read; \
	VARIABLE trans12_FlowCM_CALIBR_FACTOR; \
	MENU trans12_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans12_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans12_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans12_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans12_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans12_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans12_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans12_FlowCM_MEASUREMENT_MODE; \
	MENU trans12_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans12_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans12_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans12_FlowCM_FLOW_DIRECTION; \
	MENU trans12_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans12_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans12_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans12_FlowCM_ZERO_POINT; \
	MENU trans12_FlowCM_ZERO_POINT_page; \
	COMMAND trans12_FlowCM_ZERO_POINT_read; \
	COMMAND trans12_FlowCM_ZERO_POINT_write; \
	VARIABLE trans12_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans12_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans12_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans12_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans12_FlowCM_ZERO_POINT_UNIT; \
	MENU trans12_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans12_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans12_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans12_FlowCM_NOMINAL_SIZE; \
	MENU trans12_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans12_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans12_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans12_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans12_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans12_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans12_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans12_FlowCM_MASS_FLOW; \
	VARIABLE trans12_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans12_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans12_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans12_FlowCM_MASS_FLOW_page; \
	COMMAND trans12_FlowCM_MASS_FLOW_read; \
	VARIABLE trans12_FlowCM_MASS_FLOW_UNITS; \
	MENU trans12_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans12_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans12_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans12_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans12_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans12_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans12_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans12_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans12_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans12_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans12_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans12_FlowCM_DENSITY; \
	VARIABLE trans12_FlowCM_DENSITY_Value; \
	VARIABLE trans12_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans12_FlowCM_DENSITY_Status_Limit; \
	MENU trans12_FlowCM_DENSITY_page; \
	COMMAND trans12_FlowCM_DENSITY_read; \
	VARIABLE trans12_FlowCM_DENSITY_UNITS; \
	MENU trans12_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans12_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans12_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans12_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans12_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans12_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans12_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans12_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans12_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans12_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans12_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans12_FlowCM_TEMPERATURE; \
	VARIABLE trans12_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans12_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans12_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans12_FlowCM_TEMPERATURE_page; \
	COMMAND trans12_FlowCM_TEMPERATURE_read; \
	VARIABLE trans12_FlowCM_TEMPERATURE_UNITS; \
	MENU trans12_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans12_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans12_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans12_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans12_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans12_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans12_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans12_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans12_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans12_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans12_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans12_FlowCM_unit_nominal_size; \
	UNIT trans12_FlowCM_unit_zero_point; \
	UNIT trans12_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans12_FlowCM_unit_density; \
	UNIT trans12_FlowCM_unit_temperature

#define USE_TRANS12_FLOWCM_MANDATORY_A \
	USE_TRANS12_FLOWCM_MANDATORY_BOTH; \
	MENU trans12_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS12_FLOWCM_MANDATORY_B \
	USE_TRANS12_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans12_FlowCM_VIEW_1; \
	MENU trans12_FlowCM_VIEW_1_page; \
	MENU trans12_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS12_FLOWCM_OPTIONAL_A \
	COLLECTION trans12_FlowCM_VIEW_1; \
	MENU trans12_FlowCM_VIEW_1_page; \
	MENU trans12_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS12_FLOWCM_OPTIONAL_B \
	MENU trans12_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS12_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans12_FlowCM_)
#define USE_TRANS12_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans12_FlowCM_)
#define USE_TRANS12_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans12_FlowCM_)
#define USE_TRANS12_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans12_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS13_FLOWCM_MANDATORY_BOTH \
	BLOCK trans13_FlowCM_block; \
	COLLECTION trans13_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans13_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans13_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans13_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans13_FlowCM_ST_REV; \
	MENU trans13_FlowCM_ST_REV_page; \
	COMMAND trans13_FlowCM_ST_REV_read; \
	VARIABLE trans13_FlowCM_TAG_DESC; \
	MENU trans13_FlowCM_TAG_DESC_page; \
	COMMAND trans13_FlowCM_TAG_DESC_read; \
	COMMAND trans13_FlowCM_TAG_DESC_write; \
	VARIABLE trans13_FlowCM_STRATEGY; \
	MENU trans13_FlowCM_STRATEGY_page; \
	COMMAND trans13_FlowCM_STRATEGY_read; \
	COMMAND trans13_FlowCM_STRATEGY_write; \
	VARIABLE trans13_FlowCM_ALERT_KEY; \
	MENU trans13_FlowCM_ALERT_KEY_page; \
	COMMAND trans13_FlowCM_ALERT_KEY_read; \
	COMMAND trans13_FlowCM_ALERT_KEY_write; \
	VARIABLE trans13_FlowCM_TARGET_MODE; \
	MENU trans13_FlowCM_TARGET_MODE_page; \
	COMMAND trans13_FlowCM_TARGET_MODE_read; \
	COMMAND trans13_FlowCM_TARGET_MODE_write; \
	COLLECTION trans13_FlowCM_MODE_BLK; \
	VARIABLE trans13_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans13_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans13_FlowCM_MODE_BLK_Normal; \
	MENU trans13_FlowCM_MODE_BLK_page; \
	COMMAND trans13_FlowCM_MODE_BLK_read; \
	COLLECTION trans13_FlowCM_ALARM_SUM; \
	VARIABLE trans13_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans13_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans13_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans13_FlowCM_ALARM_SUM_Disabled; \
	MENU trans13_FlowCM_ALARM_SUM_page; \
	COMMAND trans13_FlowCM_ALARM_SUM_read; \
	VARIABLE trans13_FlowCM_CALIBR_FACTOR; \
	MENU trans13_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans13_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans13_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans13_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans13_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans13_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans13_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans13_FlowCM_MEASUREMENT_MODE; \
	MENU trans13_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans13_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans13_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans13_FlowCM_FLOW_DIRECTION; \
	MENU trans13_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans13_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans13_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans13_FlowCM_ZERO_POINT; \
	MENU trans13_FlowCM_ZERO_POINT_page; \
	COMMAND trans13_FlowCM_ZERO_POINT_read; \
	COMMAND trans13_FlowCM_ZERO_POINT_write; \
	VARIABLE trans13_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans13_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans13_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans13_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans13_FlowCM_ZERO_POINT_UNIT; \
	MENU trans13_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans13_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans13_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans13_FlowCM_NOMINAL_SIZE; \
	MENU trans13_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans13_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans13_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans13_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans13_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans13_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans13_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans13_FlowCM_MASS_FLOW; \
	VARIABLE trans13_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans13_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans13_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans13_FlowCM_MASS_FLOW_page; \
	COMMAND trans13_FlowCM_MASS_FLOW_read; \
	VARIABLE trans13_FlowCM_MASS_FLOW_UNITS; \
	MENU trans13_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans13_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans13_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans13_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans13_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans13_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans13_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans13_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans13_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans13_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans13_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans13_FlowCM_DENSITY; \
	VARIABLE trans13_FlowCM_DENSITY_Value; \
	VARIABLE trans13_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans13_FlowCM_DENSITY_Status_Limit; \
	MENU trans13_FlowCM_DENSITY_page; \
	COMMAND trans13_FlowCM_DENSITY_read; \
	VARIABLE trans13_FlowCM_DENSITY_UNITS; \
	MENU trans13_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans13_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans13_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans13_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans13_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans13_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans13_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans13_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans13_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans13_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans13_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans13_FlowCM_TEMPERATURE; \
	VARIABLE trans13_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans13_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans13_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans13_FlowCM_TEMPERATURE_page; \
	COMMAND trans13_FlowCM_TEMPERATURE_read; \
	VARIABLE trans13_FlowCM_TEMPERATURE_UNITS; \
	MENU trans13_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans13_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans13_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans13_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans13_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans13_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans13_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans13_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans13_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans13_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans13_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans13_FlowCM_unit_nominal_size; \
	UNIT trans13_FlowCM_unit_zero_point; \
	UNIT trans13_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans13_FlowCM_unit_density; \
	UNIT trans13_FlowCM_unit_temperature

#define USE_TRANS13_FLOWCM_MANDATORY_A \
	USE_TRANS13_FLOWCM_MANDATORY_BOTH; \
	MENU trans13_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS13_FLOWCM_MANDATORY_B \
	USE_TRANS13_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans13_FlowCM_VIEW_1; \
	MENU trans13_FlowCM_VIEW_1_page; \
	MENU trans13_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS13_FLOWCM_OPTIONAL_A \
	COLLECTION trans13_FlowCM_VIEW_1; \
	MENU trans13_FlowCM_VIEW_1_page; \
	MENU trans13_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS13_FLOWCM_OPTIONAL_B \
	MENU trans13_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS13_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans13_FlowCM_)
#define USE_TRANS13_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans13_FlowCM_)
#define USE_TRANS13_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans13_FlowCM_)
#define USE_TRANS13_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans13_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS14_FLOWCM_MANDATORY_BOTH \
	BLOCK trans14_FlowCM_block; \
	COLLECTION trans14_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans14_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans14_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans14_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans14_FlowCM_ST_REV; \
	MENU trans14_FlowCM_ST_REV_page; \
	COMMAND trans14_FlowCM_ST_REV_read; \
	VARIABLE trans14_FlowCM_TAG_DESC; \
	MENU trans14_FlowCM_TAG_DESC_page; \
	COMMAND trans14_FlowCM_TAG_DESC_read; \
	COMMAND trans14_FlowCM_TAG_DESC_write; \
	VARIABLE trans14_FlowCM_STRATEGY; \
	MENU trans14_FlowCM_STRATEGY_page; \
	COMMAND trans14_FlowCM_STRATEGY_read; \
	COMMAND trans14_FlowCM_STRATEGY_write; \
	VARIABLE trans14_FlowCM_ALERT_KEY; \
	MENU trans14_FlowCM_ALERT_KEY_page; \
	COMMAND trans14_FlowCM_ALERT_KEY_read; \
	COMMAND trans14_FlowCM_ALERT_KEY_write; \
	VARIABLE trans14_FlowCM_TARGET_MODE; \
	MENU trans14_FlowCM_TARGET_MODE_page; \
	COMMAND trans14_FlowCM_TARGET_MODE_read; \
	COMMAND trans14_FlowCM_TARGET_MODE_write; \
	COLLECTION trans14_FlowCM_MODE_BLK; \
	VARIABLE trans14_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans14_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans14_FlowCM_MODE_BLK_Normal; \
	MENU trans14_FlowCM_MODE_BLK_page; \
	COMMAND trans14_FlowCM_MODE_BLK_read; \
	COLLECTION trans14_FlowCM_ALARM_SUM; \
	VARIABLE trans14_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans14_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans14_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans14_FlowCM_ALARM_SUM_Disabled; \
	MENU trans14_FlowCM_ALARM_SUM_page; \
	COMMAND trans14_FlowCM_ALARM_SUM_read; \
	VARIABLE trans14_FlowCM_CALIBR_FACTOR; \
	MENU trans14_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans14_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans14_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans14_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans14_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans14_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans14_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans14_FlowCM_MEASUREMENT_MODE; \
	MENU trans14_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans14_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans14_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans14_FlowCM_FLOW_DIRECTION; \
	MENU trans14_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans14_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans14_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans14_FlowCM_ZERO_POINT; \
	MENU trans14_FlowCM_ZERO_POINT_page; \
	COMMAND trans14_FlowCM_ZERO_POINT_read; \
	COMMAND trans14_FlowCM_ZERO_POINT_write; \
	VARIABLE trans14_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans14_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans14_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans14_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans14_FlowCM_ZERO_POINT_UNIT; \
	MENU trans14_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans14_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans14_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans14_FlowCM_NOMINAL_SIZE; \
	MENU trans14_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans14_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans14_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans14_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans14_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans14_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans14_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans14_FlowCM_MASS_FLOW; \
	VARIABLE trans14_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans14_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans14_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans14_FlowCM_MASS_FLOW_page; \
	COMMAND trans14_FlowCM_MASS_FLOW_read; \
	VARIABLE trans14_FlowCM_MASS_FLOW_UNITS; \
	MENU trans14_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans14_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans14_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans14_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans14_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans14_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans14_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans14_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans14_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans14_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans14_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans14_FlowCM_DENSITY; \
	VARIABLE trans14_FlowCM_DENSITY_Value; \
	VARIABLE trans14_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans14_FlowCM_DENSITY_Status_Limit; \
	MENU trans14_FlowCM_DENSITY_page; \
	COMMAND trans14_FlowCM_DENSITY_read; \
	VARIABLE trans14_FlowCM_DENSITY_UNITS; \
	MENU trans14_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans14_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans14_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans14_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans14_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans14_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans14_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans14_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans14_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans14_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans14_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans14_FlowCM_TEMPERATURE; \
	VARIABLE trans14_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans14_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans14_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans14_FlowCM_TEMPERATURE_page; \
	COMMAND trans14_FlowCM_TEMPERATURE_read; \
	VARIABLE trans14_FlowCM_TEMPERATURE_UNITS; \
	MENU trans14_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans14_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans14_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans14_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans14_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans14_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans14_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans14_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans14_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans14_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans14_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans14_FlowCM_unit_nominal_size; \
	UNIT trans14_FlowCM_unit_zero_point; \
	UNIT trans14_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans14_FlowCM_unit_density; \
	UNIT trans14_FlowCM_unit_temperature

#define USE_TRANS14_FLOWCM_MANDATORY_A \
	USE_TRANS14_FLOWCM_MANDATORY_BOTH; \
	MENU trans14_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS14_FLOWCM_MANDATORY_B \
	USE_TRANS14_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans14_FlowCM_VIEW_1; \
	MENU trans14_FlowCM_VIEW_1_page; \
	MENU trans14_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS14_FLOWCM_OPTIONAL_A \
	COLLECTION trans14_FlowCM_VIEW_1; \
	MENU trans14_FlowCM_VIEW_1_page; \
	MENU trans14_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS14_FLOWCM_OPTIONAL_B \
	MENU trans14_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS14_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans14_FlowCM_)
#define USE_TRANS14_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans14_FlowCM_)
#define USE_TRANS14_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans14_FlowCM_)
#define USE_TRANS14_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans14_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS15_FLOWCM_MANDATORY_BOTH \
	BLOCK trans15_FlowCM_block; \
	COLLECTION trans15_FlowCM_BLOCK_OBJECT; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Class; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Profile; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans15_FlowCM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans15_FlowCM_BLOCK_OBJECT_page; \
	COMMAND trans15_FlowCM_BLOCK_OBJECT_read; \
	VARIABLE trans15_FlowCM_ST_REV; \
	MENU trans15_FlowCM_ST_REV_page; \
	COMMAND trans15_FlowCM_ST_REV_read; \
	VARIABLE trans15_FlowCM_TAG_DESC; \
	MENU trans15_FlowCM_TAG_DESC_page; \
	COMMAND trans15_FlowCM_TAG_DESC_read; \
	COMMAND trans15_FlowCM_TAG_DESC_write; \
	VARIABLE trans15_FlowCM_STRATEGY; \
	MENU trans15_FlowCM_STRATEGY_page; \
	COMMAND trans15_FlowCM_STRATEGY_read; \
	COMMAND trans15_FlowCM_STRATEGY_write; \
	VARIABLE trans15_FlowCM_ALERT_KEY; \
	MENU trans15_FlowCM_ALERT_KEY_page; \
	COMMAND trans15_FlowCM_ALERT_KEY_read; \
	COMMAND trans15_FlowCM_ALERT_KEY_write; \
	VARIABLE trans15_FlowCM_TARGET_MODE; \
	MENU trans15_FlowCM_TARGET_MODE_page; \
	COMMAND trans15_FlowCM_TARGET_MODE_read; \
	COMMAND trans15_FlowCM_TARGET_MODE_write; \
	COLLECTION trans15_FlowCM_MODE_BLK; \
	VARIABLE trans15_FlowCM_MODE_BLK_Actual; \
	VARIABLE trans15_FlowCM_MODE_BLK_Permitted; \
	VARIABLE trans15_FlowCM_MODE_BLK_Normal; \
	MENU trans15_FlowCM_MODE_BLK_page; \
	COMMAND trans15_FlowCM_MODE_BLK_read; \
	COLLECTION trans15_FlowCM_ALARM_SUM; \
	VARIABLE trans15_FlowCM_ALARM_SUM_Current; \
	VARIABLE trans15_FlowCM_ALARM_SUM_Unacknowledged; \
	VARIABLE trans15_FlowCM_ALARM_SUM_Unreported; \
	VARIABLE trans15_FlowCM_ALARM_SUM_Disabled; \
	MENU trans15_FlowCM_ALARM_SUM_page; \
	COMMAND trans15_FlowCM_ALARM_SUM_read; \
	VARIABLE trans15_FlowCM_CALIBR_FACTOR; \
	MENU trans15_FlowCM_CALIBR_FACTOR_page; \
	COMMAND trans15_FlowCM_CALIBR_FACTOR_read; \
	COMMAND trans15_FlowCM_CALIBR_FACTOR_write; \
	VARIABLE trans15_FlowCM_LOW_FLOW_CUTOFF; \
	MENU trans15_FlowCM_LOW_FLOW_CUTOFF_page; \
	COMMAND trans15_FlowCM_LOW_FLOW_CUTOFF_read; \
	COMMAND trans15_FlowCM_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans15_FlowCM_MEASUREMENT_MODE; \
	MENU trans15_FlowCM_MEASUREMENT_MODE_page; \
	COMMAND trans15_FlowCM_MEASUREMENT_MODE_read; \
	COMMAND trans15_FlowCM_MEASUREMENT_MODE_write; \
	VARIABLE trans15_FlowCM_FLOW_DIRECTION; \
	MENU trans15_FlowCM_FLOW_DIRECTION_page; \
	COMMAND trans15_FlowCM_FLOW_DIRECTION_read; \
	COMMAND trans15_FlowCM_FLOW_DIRECTION_write; \
	VARIABLE trans15_FlowCM_ZERO_POINT; \
	MENU trans15_FlowCM_ZERO_POINT_page; \
	COMMAND trans15_FlowCM_ZERO_POINT_read; \
	COMMAND trans15_FlowCM_ZERO_POINT_write; \
	VARIABLE trans15_FlowCM_ZERO_POINT_ADJUST; \
	MENU trans15_FlowCM_ZERO_POINT_ADJUST_page; \
	COMMAND trans15_FlowCM_ZERO_POINT_ADJUST_read; \
	COMMAND trans15_FlowCM_ZERO_POINT_ADJUST_write; \
	VARIABLE trans15_FlowCM_ZERO_POINT_UNIT; \
	MENU trans15_FlowCM_ZERO_POINT_UNIT_page; \
	COMMAND trans15_FlowCM_ZERO_POINT_UNIT_read; \
	COMMAND trans15_FlowCM_ZERO_POINT_UNIT_write; \
	VARIABLE trans15_FlowCM_NOMINAL_SIZE; \
	MENU trans15_FlowCM_NOMINAL_SIZE_page; \
	COMMAND trans15_FlowCM_NOMINAL_SIZE_read; \
	COMMAND trans15_FlowCM_NOMINAL_SIZE_write; \
	VARIABLE trans15_FlowCM_NOMINAL_SIZE_UNITS; \
	MENU trans15_FlowCM_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans15_FlowCM_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans15_FlowCM_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans15_FlowCM_MASS_FLOW; \
	VARIABLE trans15_FlowCM_MASS_FLOW_Value; \
	VARIABLE trans15_FlowCM_MASS_FLOW_Status_Quality; \
	VARIABLE trans15_FlowCM_MASS_FLOW_Status_Limit; \
	MENU trans15_FlowCM_MASS_FLOW_page; \
	COMMAND trans15_FlowCM_MASS_FLOW_read; \
	VARIABLE trans15_FlowCM_MASS_FLOW_UNITS; \
	MENU trans15_FlowCM_MASS_FLOW_UNITS_page; \
	COMMAND trans15_FlowCM_MASS_FLOW_UNITS_read; \
	COMMAND trans15_FlowCM_MASS_FLOW_UNITS_write; \
	VARIABLE trans15_FlowCM_MASS_FLOW_LO_LIMIT; \
	MENU trans15_FlowCM_MASS_FLOW_LO_LIMIT_page; \
	COMMAND trans15_FlowCM_MASS_FLOW_LO_LIMIT_read; \
	COMMAND trans15_FlowCM_MASS_FLOW_LO_LIMIT_write; \
	VARIABLE trans15_FlowCM_MASS_FLOW_HI_LIMIT; \
	MENU trans15_FlowCM_MASS_FLOW_HI_LIMIT_page; \
	COMMAND trans15_FlowCM_MASS_FLOW_HI_LIMIT_read; \
	COMMAND trans15_FlowCM_MASS_FLOW_HI_LIMIT_write; \
	COLLECTION trans15_FlowCM_DENSITY; \
	VARIABLE trans15_FlowCM_DENSITY_Value; \
	VARIABLE trans15_FlowCM_DENSITY_Status_Quality; \
	VARIABLE trans15_FlowCM_DENSITY_Status_Limit; \
	MENU trans15_FlowCM_DENSITY_page; \
	COMMAND trans15_FlowCM_DENSITY_read; \
	VARIABLE trans15_FlowCM_DENSITY_UNITS; \
	MENU trans15_FlowCM_DENSITY_UNITS_page; \
	COMMAND trans15_FlowCM_DENSITY_UNITS_read; \
	COMMAND trans15_FlowCM_DENSITY_UNITS_write; \
	VARIABLE trans15_FlowCM_DENSITY_LO_LIMIT; \
	MENU trans15_FlowCM_DENSITY_LO_LIMIT_page; \
	COMMAND trans15_FlowCM_DENSITY_LO_LIMIT_read; \
	COMMAND trans15_FlowCM_DENSITY_LO_LIMIT_write; \
	VARIABLE trans15_FlowCM_DENSITY_HI_LIMIT; \
	MENU trans15_FlowCM_DENSITY_HI_LIMIT_page; \
	COMMAND trans15_FlowCM_DENSITY_HI_LIMIT_read; \
	COMMAND trans15_FlowCM_DENSITY_HI_LIMIT_write; \
	COLLECTION trans15_FlowCM_TEMPERATURE; \
	VARIABLE trans15_FlowCM_TEMPERATURE_Value; \
	VARIABLE trans15_FlowCM_TEMPERATURE_Status_Quality; \
	VARIABLE trans15_FlowCM_TEMPERATURE_Status_Limit; \
	MENU trans15_FlowCM_TEMPERATURE_page; \
	COMMAND trans15_FlowCM_TEMPERATURE_read; \
	VARIABLE trans15_FlowCM_TEMPERATURE_UNITS; \
	MENU trans15_FlowCM_TEMPERATURE_UNITS_page; \
	COMMAND trans15_FlowCM_TEMPERATURE_UNITS_read; \
	COMMAND trans15_FlowCM_TEMPERATURE_UNITS_write; \
	VARIABLE trans15_FlowCM_TEMPERATURE_LO_LIMIT; \
	MENU trans15_FlowCM_TEMPERATURE_LO_LIMIT_page; \
	COMMAND trans15_FlowCM_TEMPERATURE_LO_LIMIT_read; \
	COMMAND trans15_FlowCM_TEMPERATURE_LO_LIMIT_write; \
	VARIABLE trans15_FlowCM_TEMPERATURE_HI_LIMIT; \
	MENU trans15_FlowCM_TEMPERATURE_HI_LIMIT_page; \
	COMMAND trans15_FlowCM_TEMPERATURE_HI_LIMIT_read; \
	COMMAND trans15_FlowCM_TEMPERATURE_HI_LIMIT_write; \
	UNIT trans15_FlowCM_unit_nominal_size; \
	UNIT trans15_FlowCM_unit_zero_point; \
	UNIT trans15_FlowCM_unit_TB_MASS_FLOW_UNIT; \
	UNIT trans15_FlowCM_unit_density; \
	UNIT trans15_FlowCM_unit_temperature

#define USE_TRANS15_FLOWCM_MANDATORY_A \
	USE_TRANS15_FLOWCM_MANDATORY_BOTH; \
	MENU trans15_FlowCM_Simple_Dialog_Mandatory_A

#define USE_TRANS15_FLOWCM_MANDATORY_B \
	USE_TRANS15_FLOWCM_MANDATORY_BOTH; \
	COLLECTION trans15_FlowCM_VIEW_1; \
	MENU trans15_FlowCM_VIEW_1_page; \
	MENU trans15_FlowCM_Simple_Dialog_Mandatory_B

#define USE_TRANS15_FLOWCM_OPTIONAL_A \
	COLLECTION trans15_FlowCM_VIEW_1; \
	MENU trans15_FlowCM_VIEW_1_page; \
	MENU trans15_FlowCM_Simple_Dialog_Optional_A

#define USE_TRANS15_FLOWCM_OPTIONAL_B \
	MENU trans15_FlowCM_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS15_FLOWCM_MANDATORY_A USE_TRANS_FLOWCM_MANDATORY_A(trans15_FlowCM_)
#define USE_TRANS15_FLOWCM_MANDATORY_B USE_TRANS_FLOWCM_MANDATORY_B(trans15_FlowCM_)
#define USE_TRANS15_FLOWCM_OPTIONAL_A  USE_TRANS_FLOWCM_OPTIONAL_A(trans15_FlowCM_)
#define USE_TRANS15_FLOWCM_OPTIONAL_B  USE_TRANS_FLOWCM_OPTIONAL_B(trans15_FlowCM_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS1_FLOWE_MANDATORY_BOTH \
	BLOCK trans1_FlowE_block; \
	COLLECTION trans1_FlowE_BLOCK_OBJECT; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans1_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans1_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans1_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans1_FlowE_ST_REV; \
	MENU trans1_FlowE_ST_REV_page; \
	COMMAND trans1_FlowE_ST_REV_read; \
	VARIABLE trans1_FlowE_TAG_DESC; \
	MENU trans1_FlowE_TAG_DESC_page; \
	COMMAND trans1_FlowE_TAG_DESC_read; \
	COMMAND trans1_FlowE_TAG_DESC_write; \
	VARIABLE trans1_FlowE_STRATEGY; \
	MENU trans1_FlowE_STRATEGY_page; \
	COMMAND trans1_FlowE_STRATEGY_read; \
	COMMAND trans1_FlowE_STRATEGY_write; \
	VARIABLE trans1_FlowE_ALERT_KEY; \
	MENU trans1_FlowE_ALERT_KEY_page; \
	COMMAND trans1_FlowE_ALERT_KEY_read; \
	COMMAND trans1_FlowE_ALERT_KEY_write; \
	VARIABLE trans1_FlowE_TARGET_MODE; \
	MENU trans1_FlowE_TARGET_MODE_page; \
	COMMAND trans1_FlowE_TARGET_MODE_read; \
	COMMAND trans1_FlowE_TARGET_MODE_write; \
	COLLECTION trans1_FlowE_MODE_BLK; \
	VARIABLE trans1_FlowE_MODE_BLK_Actual; \
	VARIABLE trans1_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans1_FlowE_MODE_BLK_Normal; \
	MENU trans1_FlowE_MODE_BLK_page; \
	COMMAND trans1_FlowE_MODE_BLK_read; \
	COLLECTION trans1_FlowE_ALARM_SUM; \
	VARIABLE trans1_FlowE_ALARM_SUM_Current; \
	VARIABLE trans1_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans1_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans1_FlowE_ALARM_SUM_Disabled; \
	MENU trans1_FlowE_ALARM_SUM_page; \
	COMMAND trans1_FlowE_ALARM_SUM_read; \
	VARIABLE trans1_FlowE_CALIBR_FACTOR; \
	MENU trans1_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans1_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans1_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans1_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans1_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans1_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans1_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans1_FlowE_MEASUREMENT_MODE; \
	MENU trans1_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans1_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans1_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans1_FlowE_FLOW_DIRECTION; \
	MENU trans1_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans1_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans1_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans1_FlowE_ZERO_POINT; \
	MENU trans1_FlowE_ZERO_POINT_page; \
	COMMAND trans1_FlowE_ZERO_POINT_read; \
	COMMAND trans1_FlowE_ZERO_POINT_write; \
	VARIABLE trans1_FlowE_ZERO_POINT_ADJUST; \
	MENU trans1_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans1_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans1_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans1_FlowE_ZERO_POINT_UNIT; \
	MENU trans1_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans1_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans1_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans1_FlowE_NOMINAL_SIZE; \
	MENU trans1_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans1_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans1_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans1_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans1_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans1_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans1_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans1_FlowE_VOLUME_FLOW; \
	VARIABLE trans1_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans1_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans1_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans1_FlowE_VOLUME_FLOW_page; \
	COMMAND trans1_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans1_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans1_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans1_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans1_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans1_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans1_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans1_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans1_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans1_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans1_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans1_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans1_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans1_FlowE_SAMPLING_FREQ; \
	VARIABLE trans1_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans1_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans1_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans1_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans1_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans1_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans1_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans1_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans1_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans1_FlowE_unit_nominal_size; \
	UNIT trans1_FlowE_unit_volume_flow; \
	UNIT trans1_FlowE_unit_zero_point; \
	UNIT trans1_FlowE_unit_sampling_freq

#define USE_TRANS1_FLOWE_MANDATORY_A \
	USE_TRANS1_FLOWE_MANDATORY_BOTH; \
	MENU trans1_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS1_FLOWE_MANDATORY_B \
	USE_TRANS1_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans1_FlowE_VIEW_1; \
	MENU trans1_FlowE_VIEW_1_page; \
	MENU trans1_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS1_FLOWE_OPTIONAL_A \
	COLLECTION trans1_FlowE_VIEW_1; \
	MENU trans1_FlowE_VIEW_1_page; \
	MENU trans1_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS1_FLOWE_OPTIONAL_B \
	MENU trans1_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS_FLOWE_MANDATORY_BOTH(prefix) \
	BLOCK prefix ## block; \
	COLLECTION prefix ## BLOCK_OBJECT; \
	VARIABLE prefix ## BLOCK_OBJECT_Reserved; \
	VARIABLE prefix ## BLOCK_OBJECT_Block_Object; \
	VARIABLE prefix ## BLOCK_OBJECT_Parent_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_Class; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Reference; \
	VARIABLE prefix ## BLOCK_OBJECT_DD_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile; \
	VARIABLE prefix ## BLOCK_OBJECT_Profile_Revision; \
	VARIABLE prefix ## BLOCK_OBJECT_Execution_Time; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE prefix ## BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE prefix ## BLOCK_OBJECT_Number_of_Views; \
	MENU prefix ## BLOCK_OBJECT_page; \
	COMMAND prefix ## BLOCK_OBJECT_read; \
	VARIABLE prefix ## ST_REV; \
	MENU prefix ## ST_REV_page; \
	COMMAND prefix ## ST_REV_read; \
	VARIABLE prefix ## TAG_DESC; \
	MENU prefix ## TAG_DESC_page; \
	COMMAND prefix ## TAG_DESC_read; \
	COMMAND prefix ## TAG_DESC_write; \
	VARIABLE prefix ## STRATEGY; \
	MENU prefix ## STRATEGY_page; \
	COMMAND prefix ## STRATEGY_read; \
	COMMAND prefix ## STRATEGY_write; \
	VARIABLE prefix ## ALERT_KEY; \
	MENU prefix ## ALERT_KEY_page; \
	COMMAND prefix ## ALERT_KEY_read; \
	COMMAND prefix ## ALERT_KEY_write; \
	VARIABLE prefix ## TARGET_MODE; \
	MENU prefix ## TARGET_MODE_page; \
	COMMAND prefix ## TARGET_MODE_read; \
	COMMAND prefix ## TARGET_MODE_write; \
	COLLECTION prefix ## MODE_BLK; \
	VARIABLE prefix ## MODE_BLK_Actual; \
	VARIABLE prefix ## MODE_BLK_Permitted; \
	VARIABLE prefix ## MODE_BLK_Normal; \
	MENU prefix ## MODE_BLK_page; \
	COMMAND prefix ## MODE_BLK_read; \
	COLLECTION prefix ## ALARM_SUM; \
	VARIABLE prefix ## ALARM_SUM_Current; \
	VARIABLE prefix ## ALARM_SUM_Unacknowledged; \
	VARIABLE prefix ## ALARM_SUM_Unreported; \
	VARIABLE prefix ## ALARM_SUM_Disabled; \
	MENU prefix ## ALARM_SUM_page; \
	COMMAND prefix ## ALARM_SUM_read; \
	VARIABLE prefix ## CALIBR_FACTOR; \
	MENU prefix ## CALIBR_FACTOR_page; \
	COMMAND prefix ## CALIBR_FACTOR_read; \
	COMMAND prefix ## CALIBR_FACTOR_write; \
	VARIABLE prefix ## LOW_FLOW_CUTOFF; \
	MENU prefix ## LOW_FLOW_CUTOFF_page; \
	COMMAND prefix ## LOW_FLOW_CUTOFF_read; \
	COMMAND prefix ## LOW_FLOW_CUTOFF_write; \
	VARIABLE prefix ## MEASUREMENT_MODE; \
	MENU prefix ## MEASUREMENT_MODE_page; \
	COMMAND prefix ## MEASUREMENT_MODE_read; \
	COMMAND prefix ## MEASUREMENT_MODE_write; \
	VARIABLE prefix ## FLOW_DIRECTION; \
	MENU prefix ## FLOW_DIRECTION_page; \
	COMMAND prefix ## FLOW_DIRECTION_read; \
	COMMAND prefix ## FLOW_DIRECTION_write; \
	VARIABLE prefix ## ZERO_POINT; \
	MENU prefix ## ZERO_POINT_page; \
	COMMAND prefix ## ZERO_POINT_read; \
	COMMAND prefix ## ZERO_POINT_write; \
	VARIABLE prefix ## ZERO_POINT_ADJUST; \
	MENU prefix ## ZERO_POINT_ADJUST_page; \
	COMMAND prefix ## ZERO_POINT_ADJUST_read; \
	COMMAND prefix ## ZERO_POINT_ADJUST_write; \
	VARIABLE prefix ## ZERO_POINT_UNIT; \
	MENU prefix ## ZERO_POINT_UNIT_page; \
	COMMAND prefix ## ZERO_POINT_UNIT_read; \
	COMMAND prefix ## ZERO_POINT_UNIT_write; \
	VARIABLE prefix ## NOMINAL_SIZE; \
	MENU prefix ## NOMINAL_SIZE_page; \
	COMMAND prefix ## NOMINAL_SIZE_read; \
	COMMAND prefix ## NOMINAL_SIZE_write; \
	VARIABLE prefix ## NOMINAL_SIZE_UNITS; \
	MENU prefix ## NOMINAL_SIZE_UNITS_page; \
	COMMAND prefix ## NOMINAL_SIZE_UNITS_read; \
	COMMAND prefix ## NOMINAL_SIZE_UNITS_write; \
	COLLECTION prefix ## VOLUME_FLOW; \
	VARIABLE prefix ## VOLUME_FLOW_Value; \
	VARIABLE prefix ## VOLUME_FLOW_Status_Quality; \
	VARIABLE prefix ## VOLUME_FLOW_Status_Limit; \
	MENU prefix ## VOLUME_FLOW_page; \
	COMMAND prefix ## VOLUME_FLOW_read; \
	VARIABLE prefix ## VOLUME_FLOW_UNITS; \
	MENU prefix ## VOLUME_FLOW_UNITS_page; \
	COMMAND prefix ## VOLUME_FLOW_UNITS_read; \
	COMMAND prefix ## VOLUME_FLOW_UNITS_write; \
	VARIABLE prefix ## VOLUME_FLOW_LO_LIMIT; \
	MENU prefix ## VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND prefix ## VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND prefix ## VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE prefix ## VOLUME_FLOW_HI_LIMIT; \
	MENU prefix ## VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND prefix ## VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND prefix ## VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION prefix ## SAMPLING_FREQ; \
	VARIABLE prefix ## SAMPLING_FREQ_Value; \
	VARIABLE prefix ## SAMPLING_FREQ_Status_Quality; \
	VARIABLE prefix ## SAMPLING_FREQ_Status_Limit; \
	MENU prefix ## SAMPLING_FREQ_page; \
	COMMAND prefix ## SAMPLING_FREQ_read; \
	VARIABLE prefix ## SAMPLING_FREQ_UNITS; \
	MENU prefix ## SAMPLING_FREQ_UNITS_page; \
	COMMAND prefix ## SAMPLING_FREQ_UNITS_read; \
	COMMAND prefix ## SAMPLING_FREQ_UNITS_write; \
	UNIT prefix ## unit_nominal_size; \
	UNIT prefix ## unit_volume_flow; \
	UNIT prefix ## unit_zero_point; \
	UNIT prefix ## unit_sampling_freq

#define USE_TRANS_FLOWE_MANDATORY_A(prefix) \
	USE_TRANS_FLOWE_MANDATORY_BOTH(prefix); \
	MENU prefix ## Simple_Dialog_Mandatory_A

#define USE_TRANS_FLOWE_MANDATORY_B(prefix) \
	USE_TRANS_FLOWE_MANDATORY_BOTH(prefix); \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Mandatory_B

#define USE_TRANS_FLOWE_OPTIONAL_A(prefix) \
	COLLECTION prefix ## VIEW_1; \
	MENU prefix ## VIEW_1_page; \
	MENU prefix ## Simple_Dialog_Optional_A

#define USE_TRANS_FLOWE_OPTIONAL_B(prefix) \
	MENU prefix ## Simple_Dialog_Optional_B

#define USE_TRANS1_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans1_FlowE_)
#define USE_TRANS1_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans1_FlowE_)
#define USE_TRANS1_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans1_FlowE_)
#define USE_TRANS1_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans1_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS2_FLOWE_MANDATORY_BOTH \
	BLOCK trans2_FlowE_block; \
	COLLECTION trans2_FlowE_BLOCK_OBJECT; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans2_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans2_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans2_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans2_FlowE_ST_REV; \
	MENU trans2_FlowE_ST_REV_page; \
	COMMAND trans2_FlowE_ST_REV_read; \
	VARIABLE trans2_FlowE_TAG_DESC; \
	MENU trans2_FlowE_TAG_DESC_page; \
	COMMAND trans2_FlowE_TAG_DESC_read; \
	COMMAND trans2_FlowE_TAG_DESC_write; \
	VARIABLE trans2_FlowE_STRATEGY; \
	MENU trans2_FlowE_STRATEGY_page; \
	COMMAND trans2_FlowE_STRATEGY_read; \
	COMMAND trans2_FlowE_STRATEGY_write; \
	VARIABLE trans2_FlowE_ALERT_KEY; \
	MENU trans2_FlowE_ALERT_KEY_page; \
	COMMAND trans2_FlowE_ALERT_KEY_read; \
	COMMAND trans2_FlowE_ALERT_KEY_write; \
	VARIABLE trans2_FlowE_TARGET_MODE; \
	MENU trans2_FlowE_TARGET_MODE_page; \
	COMMAND trans2_FlowE_TARGET_MODE_read; \
	COMMAND trans2_FlowE_TARGET_MODE_write; \
	COLLECTION trans2_FlowE_MODE_BLK; \
	VARIABLE trans2_FlowE_MODE_BLK_Actual; \
	VARIABLE trans2_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans2_FlowE_MODE_BLK_Normal; \
	MENU trans2_FlowE_MODE_BLK_page; \
	COMMAND trans2_FlowE_MODE_BLK_read; \
	COLLECTION trans2_FlowE_ALARM_SUM; \
	VARIABLE trans2_FlowE_ALARM_SUM_Current; \
	VARIABLE trans2_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans2_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans2_FlowE_ALARM_SUM_Disabled; \
	MENU trans2_FlowE_ALARM_SUM_page; \
	COMMAND trans2_FlowE_ALARM_SUM_read; \
	VARIABLE trans2_FlowE_CALIBR_FACTOR; \
	MENU trans2_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans2_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans2_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans2_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans2_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans2_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans2_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans2_FlowE_MEASUREMENT_MODE; \
	MENU trans2_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans2_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans2_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans2_FlowE_FLOW_DIRECTION; \
	MENU trans2_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans2_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans2_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans2_FlowE_ZERO_POINT; \
	MENU trans2_FlowE_ZERO_POINT_page; \
	COMMAND trans2_FlowE_ZERO_POINT_read; \
	COMMAND trans2_FlowE_ZERO_POINT_write; \
	VARIABLE trans2_FlowE_ZERO_POINT_ADJUST; \
	MENU trans2_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans2_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans2_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans2_FlowE_ZERO_POINT_UNIT; \
	MENU trans2_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans2_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans2_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans2_FlowE_NOMINAL_SIZE; \
	MENU trans2_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans2_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans2_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans2_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans2_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans2_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans2_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans2_FlowE_VOLUME_FLOW; \
	VARIABLE trans2_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans2_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans2_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans2_FlowE_VOLUME_FLOW_page; \
	COMMAND trans2_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans2_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans2_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans2_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans2_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans2_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans2_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans2_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans2_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans2_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans2_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans2_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans2_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans2_FlowE_SAMPLING_FREQ; \
	VARIABLE trans2_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans2_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans2_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans2_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans2_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans2_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans2_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans2_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans2_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans2_FlowE_unit_nominal_size; \
	UNIT trans2_FlowE_unit_volume_flow; \
	UNIT trans2_FlowE_unit_zero_point; \
	UNIT trans2_FlowE_unit_sampling_freq

#define USE_TRANS2_FLOWE_MANDATORY_A \
	USE_TRANS2_FLOWE_MANDATORY_BOTH; \
	MENU trans2_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS2_FLOWE_MANDATORY_B \
	USE_TRANS2_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans2_FlowE_VIEW_1; \
	MENU trans2_FlowE_VIEW_1_page; \
	MENU trans2_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS2_FLOWE_OPTIONAL_A \
	COLLECTION trans2_FlowE_VIEW_1; \
	MENU trans2_FlowE_VIEW_1_page; \
	MENU trans2_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS2_FLOWE_OPTIONAL_B \
	MENU trans2_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS2_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans2_FlowE_)
#define USE_TRANS2_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans2_FlowE_)
#define USE_TRANS2_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans2_FlowE_)
#define USE_TRANS2_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans2_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS3_FLOWE_MANDATORY_BOTH \
	BLOCK trans3_FlowE_block; \
	COLLECTION trans3_FlowE_BLOCK_OBJECT; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans3_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans3_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans3_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans3_FlowE_ST_REV; \
	MENU trans3_FlowE_ST_REV_page; \
	COMMAND trans3_FlowE_ST_REV_read; \
	VARIABLE trans3_FlowE_TAG_DESC; \
	MENU trans3_FlowE_TAG_DESC_page; \
	COMMAND trans3_FlowE_TAG_DESC_read; \
	COMMAND trans3_FlowE_TAG_DESC_write; \
	VARIABLE trans3_FlowE_STRATEGY; \
	MENU trans3_FlowE_STRATEGY_page; \
	COMMAND trans3_FlowE_STRATEGY_read; \
	COMMAND trans3_FlowE_STRATEGY_write; \
	VARIABLE trans3_FlowE_ALERT_KEY; \
	MENU trans3_FlowE_ALERT_KEY_page; \
	COMMAND trans3_FlowE_ALERT_KEY_read; \
	COMMAND trans3_FlowE_ALERT_KEY_write; \
	VARIABLE trans3_FlowE_TARGET_MODE; \
	MENU trans3_FlowE_TARGET_MODE_page; \
	COMMAND trans3_FlowE_TARGET_MODE_read; \
	COMMAND trans3_FlowE_TARGET_MODE_write; \
	COLLECTION trans3_FlowE_MODE_BLK; \
	VARIABLE trans3_FlowE_MODE_BLK_Actual; \
	VARIABLE trans3_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans3_FlowE_MODE_BLK_Normal; \
	MENU trans3_FlowE_MODE_BLK_page; \
	COMMAND trans3_FlowE_MODE_BLK_read; \
	COLLECTION trans3_FlowE_ALARM_SUM; \
	VARIABLE trans3_FlowE_ALARM_SUM_Current; \
	VARIABLE trans3_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans3_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans3_FlowE_ALARM_SUM_Disabled; \
	MENU trans3_FlowE_ALARM_SUM_page; \
	COMMAND trans3_FlowE_ALARM_SUM_read; \
	VARIABLE trans3_FlowE_CALIBR_FACTOR; \
	MENU trans3_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans3_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans3_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans3_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans3_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans3_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans3_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans3_FlowE_MEASUREMENT_MODE; \
	MENU trans3_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans3_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans3_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans3_FlowE_FLOW_DIRECTION; \
	MENU trans3_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans3_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans3_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans3_FlowE_ZERO_POINT; \
	MENU trans3_FlowE_ZERO_POINT_page; \
	COMMAND trans3_FlowE_ZERO_POINT_read; \
	COMMAND trans3_FlowE_ZERO_POINT_write; \
	VARIABLE trans3_FlowE_ZERO_POINT_ADJUST; \
	MENU trans3_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans3_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans3_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans3_FlowE_ZERO_POINT_UNIT; \
	MENU trans3_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans3_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans3_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans3_FlowE_NOMINAL_SIZE; \
	MENU trans3_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans3_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans3_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans3_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans3_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans3_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans3_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans3_FlowE_VOLUME_FLOW; \
	VARIABLE trans3_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans3_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans3_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans3_FlowE_VOLUME_FLOW_page; \
	COMMAND trans3_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans3_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans3_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans3_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans3_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans3_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans3_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans3_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans3_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans3_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans3_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans3_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans3_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans3_FlowE_SAMPLING_FREQ; \
	VARIABLE trans3_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans3_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans3_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans3_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans3_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans3_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans3_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans3_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans3_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans3_FlowE_unit_nominal_size; \
	UNIT trans3_FlowE_unit_volume_flow; \
	UNIT trans3_FlowE_unit_zero_point; \
	UNIT trans3_FlowE_unit_sampling_freq

#define USE_TRANS3_FLOWE_MANDATORY_A \
	USE_TRANS3_FLOWE_MANDATORY_BOTH; \
	MENU trans3_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS3_FLOWE_MANDATORY_B \
	USE_TRANS3_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans3_FlowE_VIEW_1; \
	MENU trans3_FlowE_VIEW_1_page; \
	MENU trans3_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS3_FLOWE_OPTIONAL_A \
	COLLECTION trans3_FlowE_VIEW_1; \
	MENU trans3_FlowE_VIEW_1_page; \
	MENU trans3_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS3_FLOWE_OPTIONAL_B \
	MENU trans3_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS3_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans3_FlowE_)
#define USE_TRANS3_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans3_FlowE_)
#define USE_TRANS3_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans3_FlowE_)
#define USE_TRANS3_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans3_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS4_FLOWE_MANDATORY_BOTH \
	BLOCK trans4_FlowE_block; \
	COLLECTION trans4_FlowE_BLOCK_OBJECT; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans4_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans4_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans4_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans4_FlowE_ST_REV; \
	MENU trans4_FlowE_ST_REV_page; \
	COMMAND trans4_FlowE_ST_REV_read; \
	VARIABLE trans4_FlowE_TAG_DESC; \
	MENU trans4_FlowE_TAG_DESC_page; \
	COMMAND trans4_FlowE_TAG_DESC_read; \
	COMMAND trans4_FlowE_TAG_DESC_write; \
	VARIABLE trans4_FlowE_STRATEGY; \
	MENU trans4_FlowE_STRATEGY_page; \
	COMMAND trans4_FlowE_STRATEGY_read; \
	COMMAND trans4_FlowE_STRATEGY_write; \
	VARIABLE trans4_FlowE_ALERT_KEY; \
	MENU trans4_FlowE_ALERT_KEY_page; \
	COMMAND trans4_FlowE_ALERT_KEY_read; \
	COMMAND trans4_FlowE_ALERT_KEY_write; \
	VARIABLE trans4_FlowE_TARGET_MODE; \
	MENU trans4_FlowE_TARGET_MODE_page; \
	COMMAND trans4_FlowE_TARGET_MODE_read; \
	COMMAND trans4_FlowE_TARGET_MODE_write; \
	COLLECTION trans4_FlowE_MODE_BLK; \
	VARIABLE trans4_FlowE_MODE_BLK_Actual; \
	VARIABLE trans4_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans4_FlowE_MODE_BLK_Normal; \
	MENU trans4_FlowE_MODE_BLK_page; \
	COMMAND trans4_FlowE_MODE_BLK_read; \
	COLLECTION trans4_FlowE_ALARM_SUM; \
	VARIABLE trans4_FlowE_ALARM_SUM_Current; \
	VARIABLE trans4_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans4_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans4_FlowE_ALARM_SUM_Disabled; \
	MENU trans4_FlowE_ALARM_SUM_page; \
	COMMAND trans4_FlowE_ALARM_SUM_read; \
	VARIABLE trans4_FlowE_CALIBR_FACTOR; \
	MENU trans4_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans4_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans4_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans4_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans4_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans4_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans4_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans4_FlowE_MEASUREMENT_MODE; \
	MENU trans4_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans4_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans4_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans4_FlowE_FLOW_DIRECTION; \
	MENU trans4_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans4_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans4_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans4_FlowE_ZERO_POINT; \
	MENU trans4_FlowE_ZERO_POINT_page; \
	COMMAND trans4_FlowE_ZERO_POINT_read; \
	COMMAND trans4_FlowE_ZERO_POINT_write; \
	VARIABLE trans4_FlowE_ZERO_POINT_ADJUST; \
	MENU trans4_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans4_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans4_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans4_FlowE_ZERO_POINT_UNIT; \
	MENU trans4_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans4_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans4_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans4_FlowE_NOMINAL_SIZE; \
	MENU trans4_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans4_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans4_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans4_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans4_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans4_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans4_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans4_FlowE_VOLUME_FLOW; \
	VARIABLE trans4_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans4_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans4_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans4_FlowE_VOLUME_FLOW_page; \
	COMMAND trans4_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans4_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans4_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans4_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans4_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans4_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans4_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans4_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans4_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans4_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans4_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans4_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans4_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans4_FlowE_SAMPLING_FREQ; \
	VARIABLE trans4_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans4_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans4_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans4_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans4_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans4_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans4_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans4_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans4_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans4_FlowE_unit_nominal_size; \
	UNIT trans4_FlowE_unit_volume_flow; \
	UNIT trans4_FlowE_unit_zero_point; \
	UNIT trans4_FlowE_unit_sampling_freq

#define USE_TRANS4_FLOWE_MANDATORY_A \
	USE_TRANS4_FLOWE_MANDATORY_BOTH; \
	MENU trans4_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS4_FLOWE_MANDATORY_B \
	USE_TRANS4_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans4_FlowE_VIEW_1; \
	MENU trans4_FlowE_VIEW_1_page; \
	MENU trans4_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS4_FLOWE_OPTIONAL_A \
	COLLECTION trans4_FlowE_VIEW_1; \
	MENU trans4_FlowE_VIEW_1_page; \
	MENU trans4_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS4_FLOWE_OPTIONAL_B \
	MENU trans4_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS4_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans4_FlowE_)
#define USE_TRANS4_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans4_FlowE_)
#define USE_TRANS4_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans4_FlowE_)
#define USE_TRANS4_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans4_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS5_FLOWE_MANDATORY_BOTH \
	BLOCK trans5_FlowE_block; \
	COLLECTION trans5_FlowE_BLOCK_OBJECT; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans5_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans5_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans5_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans5_FlowE_ST_REV; \
	MENU trans5_FlowE_ST_REV_page; \
	COMMAND trans5_FlowE_ST_REV_read; \
	VARIABLE trans5_FlowE_TAG_DESC; \
	MENU trans5_FlowE_TAG_DESC_page; \
	COMMAND trans5_FlowE_TAG_DESC_read; \
	COMMAND trans5_FlowE_TAG_DESC_write; \
	VARIABLE trans5_FlowE_STRATEGY; \
	MENU trans5_FlowE_STRATEGY_page; \
	COMMAND trans5_FlowE_STRATEGY_read; \
	COMMAND trans5_FlowE_STRATEGY_write; \
	VARIABLE trans5_FlowE_ALERT_KEY; \
	MENU trans5_FlowE_ALERT_KEY_page; \
	COMMAND trans5_FlowE_ALERT_KEY_read; \
	COMMAND trans5_FlowE_ALERT_KEY_write; \
	VARIABLE trans5_FlowE_TARGET_MODE; \
	MENU trans5_FlowE_TARGET_MODE_page; \
	COMMAND trans5_FlowE_TARGET_MODE_read; \
	COMMAND trans5_FlowE_TARGET_MODE_write; \
	COLLECTION trans5_FlowE_MODE_BLK; \
	VARIABLE trans5_FlowE_MODE_BLK_Actual; \
	VARIABLE trans5_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans5_FlowE_MODE_BLK_Normal; \
	MENU trans5_FlowE_MODE_BLK_page; \
	COMMAND trans5_FlowE_MODE_BLK_read; \
	COLLECTION trans5_FlowE_ALARM_SUM; \
	VARIABLE trans5_FlowE_ALARM_SUM_Current; \
	VARIABLE trans5_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans5_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans5_FlowE_ALARM_SUM_Disabled; \
	MENU trans5_FlowE_ALARM_SUM_page; \
	COMMAND trans5_FlowE_ALARM_SUM_read; \
	VARIABLE trans5_FlowE_CALIBR_FACTOR; \
	MENU trans5_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans5_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans5_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans5_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans5_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans5_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans5_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans5_FlowE_MEASUREMENT_MODE; \
	MENU trans5_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans5_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans5_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans5_FlowE_FLOW_DIRECTION; \
	MENU trans5_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans5_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans5_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans5_FlowE_ZERO_POINT; \
	MENU trans5_FlowE_ZERO_POINT_page; \
	COMMAND trans5_FlowE_ZERO_POINT_read; \
	COMMAND trans5_FlowE_ZERO_POINT_write; \
	VARIABLE trans5_FlowE_ZERO_POINT_ADJUST; \
	MENU trans5_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans5_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans5_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans5_FlowE_ZERO_POINT_UNIT; \
	MENU trans5_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans5_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans5_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans5_FlowE_NOMINAL_SIZE; \
	MENU trans5_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans5_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans5_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans5_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans5_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans5_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans5_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans5_FlowE_VOLUME_FLOW; \
	VARIABLE trans5_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans5_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans5_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans5_FlowE_VOLUME_FLOW_page; \
	COMMAND trans5_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans5_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans5_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans5_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans5_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans5_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans5_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans5_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans5_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans5_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans5_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans5_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans5_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans5_FlowE_SAMPLING_FREQ; \
	VARIABLE trans5_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans5_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans5_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans5_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans5_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans5_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans5_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans5_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans5_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans5_FlowE_unit_nominal_size; \
	UNIT trans5_FlowE_unit_volume_flow; \
	UNIT trans5_FlowE_unit_zero_point; \
	UNIT trans5_FlowE_unit_sampling_freq

#define USE_TRANS5_FLOWE_MANDATORY_A \
	USE_TRANS5_FLOWE_MANDATORY_BOTH; \
	MENU trans5_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS5_FLOWE_MANDATORY_B \
	USE_TRANS5_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans5_FlowE_VIEW_1; \
	MENU trans5_FlowE_VIEW_1_page; \
	MENU trans5_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS5_FLOWE_OPTIONAL_A \
	COLLECTION trans5_FlowE_VIEW_1; \
	MENU trans5_FlowE_VIEW_1_page; \
	MENU trans5_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS5_FLOWE_OPTIONAL_B \
	MENU trans5_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS5_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans5_FlowE_)
#define USE_TRANS5_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans5_FlowE_)
#define USE_TRANS5_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans5_FlowE_)
#define USE_TRANS5_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans5_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS6_FLOWE_MANDATORY_BOTH \
	BLOCK trans6_FlowE_block; \
	COLLECTION trans6_FlowE_BLOCK_OBJECT; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans6_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans6_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans6_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans6_FlowE_ST_REV; \
	MENU trans6_FlowE_ST_REV_page; \
	COMMAND trans6_FlowE_ST_REV_read; \
	VARIABLE trans6_FlowE_TAG_DESC; \
	MENU trans6_FlowE_TAG_DESC_page; \
	COMMAND trans6_FlowE_TAG_DESC_read; \
	COMMAND trans6_FlowE_TAG_DESC_write; \
	VARIABLE trans6_FlowE_STRATEGY; \
	MENU trans6_FlowE_STRATEGY_page; \
	COMMAND trans6_FlowE_STRATEGY_read; \
	COMMAND trans6_FlowE_STRATEGY_write; \
	VARIABLE trans6_FlowE_ALERT_KEY; \
	MENU trans6_FlowE_ALERT_KEY_page; \
	COMMAND trans6_FlowE_ALERT_KEY_read; \
	COMMAND trans6_FlowE_ALERT_KEY_write; \
	VARIABLE trans6_FlowE_TARGET_MODE; \
	MENU trans6_FlowE_TARGET_MODE_page; \
	COMMAND trans6_FlowE_TARGET_MODE_read; \
	COMMAND trans6_FlowE_TARGET_MODE_write; \
	COLLECTION trans6_FlowE_MODE_BLK; \
	VARIABLE trans6_FlowE_MODE_BLK_Actual; \
	VARIABLE trans6_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans6_FlowE_MODE_BLK_Normal; \
	MENU trans6_FlowE_MODE_BLK_page; \
	COMMAND trans6_FlowE_MODE_BLK_read; \
	COLLECTION trans6_FlowE_ALARM_SUM; \
	VARIABLE trans6_FlowE_ALARM_SUM_Current; \
	VARIABLE trans6_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans6_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans6_FlowE_ALARM_SUM_Disabled; \
	MENU trans6_FlowE_ALARM_SUM_page; \
	COMMAND trans6_FlowE_ALARM_SUM_read; \
	VARIABLE trans6_FlowE_CALIBR_FACTOR; \
	MENU trans6_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans6_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans6_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans6_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans6_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans6_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans6_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans6_FlowE_MEASUREMENT_MODE; \
	MENU trans6_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans6_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans6_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans6_FlowE_FLOW_DIRECTION; \
	MENU trans6_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans6_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans6_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans6_FlowE_ZERO_POINT; \
	MENU trans6_FlowE_ZERO_POINT_page; \
	COMMAND trans6_FlowE_ZERO_POINT_read; \
	COMMAND trans6_FlowE_ZERO_POINT_write; \
	VARIABLE trans6_FlowE_ZERO_POINT_ADJUST; \
	MENU trans6_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans6_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans6_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans6_FlowE_ZERO_POINT_UNIT; \
	MENU trans6_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans6_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans6_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans6_FlowE_NOMINAL_SIZE; \
	MENU trans6_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans6_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans6_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans6_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans6_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans6_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans6_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans6_FlowE_VOLUME_FLOW; \
	VARIABLE trans6_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans6_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans6_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans6_FlowE_VOLUME_FLOW_page; \
	COMMAND trans6_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans6_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans6_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans6_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans6_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans6_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans6_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans6_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans6_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans6_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans6_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans6_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans6_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans6_FlowE_SAMPLING_FREQ; \
	VARIABLE trans6_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans6_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans6_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans6_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans6_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans6_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans6_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans6_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans6_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans6_FlowE_unit_nominal_size; \
	UNIT trans6_FlowE_unit_volume_flow; \
	UNIT trans6_FlowE_unit_zero_point; \
	UNIT trans6_FlowE_unit_sampling_freq

#define USE_TRANS6_FLOWE_MANDATORY_A \
	USE_TRANS6_FLOWE_MANDATORY_BOTH; \
	MENU trans6_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS6_FLOWE_MANDATORY_B \
	USE_TRANS6_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans6_FlowE_VIEW_1; \
	MENU trans6_FlowE_VIEW_1_page; \
	MENU trans6_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS6_FLOWE_OPTIONAL_A \
	COLLECTION trans6_FlowE_VIEW_1; \
	MENU trans6_FlowE_VIEW_1_page; \
	MENU trans6_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS6_FLOWE_OPTIONAL_B \
	MENU trans6_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS6_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans6_FlowE_)
#define USE_TRANS6_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans6_FlowE_)
#define USE_TRANS6_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans6_FlowE_)
#define USE_TRANS6_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans6_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS7_FLOWE_MANDATORY_BOTH \
	BLOCK trans7_FlowE_block; \
	COLLECTION trans7_FlowE_BLOCK_OBJECT; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans7_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans7_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans7_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans7_FlowE_ST_REV; \
	MENU trans7_FlowE_ST_REV_page; \
	COMMAND trans7_FlowE_ST_REV_read; \
	VARIABLE trans7_FlowE_TAG_DESC; \
	MENU trans7_FlowE_TAG_DESC_page; \
	COMMAND trans7_FlowE_TAG_DESC_read; \
	COMMAND trans7_FlowE_TAG_DESC_write; \
	VARIABLE trans7_FlowE_STRATEGY; \
	MENU trans7_FlowE_STRATEGY_page; \
	COMMAND trans7_FlowE_STRATEGY_read; \
	COMMAND trans7_FlowE_STRATEGY_write; \
	VARIABLE trans7_FlowE_ALERT_KEY; \
	MENU trans7_FlowE_ALERT_KEY_page; \
	COMMAND trans7_FlowE_ALERT_KEY_read; \
	COMMAND trans7_FlowE_ALERT_KEY_write; \
	VARIABLE trans7_FlowE_TARGET_MODE; \
	MENU trans7_FlowE_TARGET_MODE_page; \
	COMMAND trans7_FlowE_TARGET_MODE_read; \
	COMMAND trans7_FlowE_TARGET_MODE_write; \
	COLLECTION trans7_FlowE_MODE_BLK; \
	VARIABLE trans7_FlowE_MODE_BLK_Actual; \
	VARIABLE trans7_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans7_FlowE_MODE_BLK_Normal; \
	MENU trans7_FlowE_MODE_BLK_page; \
	COMMAND trans7_FlowE_MODE_BLK_read; \
	COLLECTION trans7_FlowE_ALARM_SUM; \
	VARIABLE trans7_FlowE_ALARM_SUM_Current; \
	VARIABLE trans7_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans7_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans7_FlowE_ALARM_SUM_Disabled; \
	MENU trans7_FlowE_ALARM_SUM_page; \
	COMMAND trans7_FlowE_ALARM_SUM_read; \
	VARIABLE trans7_FlowE_CALIBR_FACTOR; \
	MENU trans7_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans7_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans7_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans7_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans7_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans7_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans7_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans7_FlowE_MEASUREMENT_MODE; \
	MENU trans7_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans7_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans7_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans7_FlowE_FLOW_DIRECTION; \
	MENU trans7_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans7_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans7_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans7_FlowE_ZERO_POINT; \
	MENU trans7_FlowE_ZERO_POINT_page; \
	COMMAND trans7_FlowE_ZERO_POINT_read; \
	COMMAND trans7_FlowE_ZERO_POINT_write; \
	VARIABLE trans7_FlowE_ZERO_POINT_ADJUST; \
	MENU trans7_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans7_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans7_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans7_FlowE_ZERO_POINT_UNIT; \
	MENU trans7_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans7_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans7_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans7_FlowE_NOMINAL_SIZE; \
	MENU trans7_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans7_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans7_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans7_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans7_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans7_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans7_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans7_FlowE_VOLUME_FLOW; \
	VARIABLE trans7_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans7_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans7_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans7_FlowE_VOLUME_FLOW_page; \
	COMMAND trans7_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans7_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans7_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans7_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans7_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans7_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans7_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans7_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans7_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans7_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans7_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans7_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans7_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans7_FlowE_SAMPLING_FREQ; \
	VARIABLE trans7_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans7_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans7_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans7_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans7_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans7_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans7_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans7_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans7_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans7_FlowE_unit_nominal_size; \
	UNIT trans7_FlowE_unit_volume_flow; \
	UNIT trans7_FlowE_unit_zero_point; \
	UNIT trans7_FlowE_unit_sampling_freq

#define USE_TRANS7_FLOWE_MANDATORY_A \
	USE_TRANS7_FLOWE_MANDATORY_BOTH; \
	MENU trans7_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS7_FLOWE_MANDATORY_B \
	USE_TRANS7_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans7_FlowE_VIEW_1; \
	MENU trans7_FlowE_VIEW_1_page; \
	MENU trans7_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS7_FLOWE_OPTIONAL_A \
	COLLECTION trans7_FlowE_VIEW_1; \
	MENU trans7_FlowE_VIEW_1_page; \
	MENU trans7_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS7_FLOWE_OPTIONAL_B \
	MENU trans7_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS7_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans7_FlowE_)
#define USE_TRANS7_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans7_FlowE_)
#define USE_TRANS7_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans7_FlowE_)
#define USE_TRANS7_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans7_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS8_FLOWE_MANDATORY_BOTH \
	BLOCK trans8_FlowE_block; \
	COLLECTION trans8_FlowE_BLOCK_OBJECT; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans8_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans8_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans8_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans8_FlowE_ST_REV; \
	MENU trans8_FlowE_ST_REV_page; \
	COMMAND trans8_FlowE_ST_REV_read; \
	VARIABLE trans8_FlowE_TAG_DESC; \
	MENU trans8_FlowE_TAG_DESC_page; \
	COMMAND trans8_FlowE_TAG_DESC_read; \
	COMMAND trans8_FlowE_TAG_DESC_write; \
	VARIABLE trans8_FlowE_STRATEGY; \
	MENU trans8_FlowE_STRATEGY_page; \
	COMMAND trans8_FlowE_STRATEGY_read; \
	COMMAND trans8_FlowE_STRATEGY_write; \
	VARIABLE trans8_FlowE_ALERT_KEY; \
	MENU trans8_FlowE_ALERT_KEY_page; \
	COMMAND trans8_FlowE_ALERT_KEY_read; \
	COMMAND trans8_FlowE_ALERT_KEY_write; \
	VARIABLE trans8_FlowE_TARGET_MODE; \
	MENU trans8_FlowE_TARGET_MODE_page; \
	COMMAND trans8_FlowE_TARGET_MODE_read; \
	COMMAND trans8_FlowE_TARGET_MODE_write; \
	COLLECTION trans8_FlowE_MODE_BLK; \
	VARIABLE trans8_FlowE_MODE_BLK_Actual; \
	VARIABLE trans8_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans8_FlowE_MODE_BLK_Normal; \
	MENU trans8_FlowE_MODE_BLK_page; \
	COMMAND trans8_FlowE_MODE_BLK_read; \
	COLLECTION trans8_FlowE_ALARM_SUM; \
	VARIABLE trans8_FlowE_ALARM_SUM_Current; \
	VARIABLE trans8_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans8_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans8_FlowE_ALARM_SUM_Disabled; \
	MENU trans8_FlowE_ALARM_SUM_page; \
	COMMAND trans8_FlowE_ALARM_SUM_read; \
	VARIABLE trans8_FlowE_CALIBR_FACTOR; \
	MENU trans8_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans8_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans8_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans8_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans8_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans8_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans8_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans8_FlowE_MEASUREMENT_MODE; \
	MENU trans8_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans8_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans8_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans8_FlowE_FLOW_DIRECTION; \
	MENU trans8_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans8_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans8_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans8_FlowE_ZERO_POINT; \
	MENU trans8_FlowE_ZERO_POINT_page; \
	COMMAND trans8_FlowE_ZERO_POINT_read; \
	COMMAND trans8_FlowE_ZERO_POINT_write; \
	VARIABLE trans8_FlowE_ZERO_POINT_ADJUST; \
	MENU trans8_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans8_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans8_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans8_FlowE_ZERO_POINT_UNIT; \
	MENU trans8_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans8_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans8_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans8_FlowE_NOMINAL_SIZE; \
	MENU trans8_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans8_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans8_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans8_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans8_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans8_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans8_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans8_FlowE_VOLUME_FLOW; \
	VARIABLE trans8_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans8_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans8_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans8_FlowE_VOLUME_FLOW_page; \
	COMMAND trans8_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans8_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans8_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans8_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans8_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans8_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans8_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans8_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans8_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans8_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans8_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans8_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans8_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans8_FlowE_SAMPLING_FREQ; \
	VARIABLE trans8_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans8_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans8_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans8_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans8_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans8_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans8_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans8_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans8_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans8_FlowE_unit_nominal_size; \
	UNIT trans8_FlowE_unit_volume_flow; \
	UNIT trans8_FlowE_unit_zero_point; \
	UNIT trans8_FlowE_unit_sampling_freq

#define USE_TRANS8_FLOWE_MANDATORY_A \
	USE_TRANS8_FLOWE_MANDATORY_BOTH; \
	MENU trans8_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS8_FLOWE_MANDATORY_B \
	USE_TRANS8_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans8_FlowE_VIEW_1; \
	MENU trans8_FlowE_VIEW_1_page; \
	MENU trans8_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS8_FLOWE_OPTIONAL_A \
	COLLECTION trans8_FlowE_VIEW_1; \
	MENU trans8_FlowE_VIEW_1_page; \
	MENU trans8_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS8_FLOWE_OPTIONAL_B \
	MENU trans8_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS8_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans8_FlowE_)
#define USE_TRANS8_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans8_FlowE_)
#define USE_TRANS8_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans8_FlowE_)
#define USE_TRANS8_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans8_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS9_FLOWE_MANDATORY_BOTH \
	BLOCK trans9_FlowE_block; \
	COLLECTION trans9_FlowE_BLOCK_OBJECT; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans9_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans9_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans9_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans9_FlowE_ST_REV; \
	MENU trans9_FlowE_ST_REV_page; \
	COMMAND trans9_FlowE_ST_REV_read; \
	VARIABLE trans9_FlowE_TAG_DESC; \
	MENU trans9_FlowE_TAG_DESC_page; \
	COMMAND trans9_FlowE_TAG_DESC_read; \
	COMMAND trans9_FlowE_TAG_DESC_write; \
	VARIABLE trans9_FlowE_STRATEGY; \
	MENU trans9_FlowE_STRATEGY_page; \
	COMMAND trans9_FlowE_STRATEGY_read; \
	COMMAND trans9_FlowE_STRATEGY_write; \
	VARIABLE trans9_FlowE_ALERT_KEY; \
	MENU trans9_FlowE_ALERT_KEY_page; \
	COMMAND trans9_FlowE_ALERT_KEY_read; \
	COMMAND trans9_FlowE_ALERT_KEY_write; \
	VARIABLE trans9_FlowE_TARGET_MODE; \
	MENU trans9_FlowE_TARGET_MODE_page; \
	COMMAND trans9_FlowE_TARGET_MODE_read; \
	COMMAND trans9_FlowE_TARGET_MODE_write; \
	COLLECTION trans9_FlowE_MODE_BLK; \
	VARIABLE trans9_FlowE_MODE_BLK_Actual; \
	VARIABLE trans9_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans9_FlowE_MODE_BLK_Normal; \
	MENU trans9_FlowE_MODE_BLK_page; \
	COMMAND trans9_FlowE_MODE_BLK_read; \
	COLLECTION trans9_FlowE_ALARM_SUM; \
	VARIABLE trans9_FlowE_ALARM_SUM_Current; \
	VARIABLE trans9_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans9_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans9_FlowE_ALARM_SUM_Disabled; \
	MENU trans9_FlowE_ALARM_SUM_page; \
	COMMAND trans9_FlowE_ALARM_SUM_read; \
	VARIABLE trans9_FlowE_CALIBR_FACTOR; \
	MENU trans9_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans9_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans9_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans9_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans9_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans9_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans9_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans9_FlowE_MEASUREMENT_MODE; \
	MENU trans9_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans9_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans9_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans9_FlowE_FLOW_DIRECTION; \
	MENU trans9_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans9_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans9_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans9_FlowE_ZERO_POINT; \
	MENU trans9_FlowE_ZERO_POINT_page; \
	COMMAND trans9_FlowE_ZERO_POINT_read; \
	COMMAND trans9_FlowE_ZERO_POINT_write; \
	VARIABLE trans9_FlowE_ZERO_POINT_ADJUST; \
	MENU trans9_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans9_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans9_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans9_FlowE_ZERO_POINT_UNIT; \
	MENU trans9_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans9_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans9_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans9_FlowE_NOMINAL_SIZE; \
	MENU trans9_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans9_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans9_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans9_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans9_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans9_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans9_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans9_FlowE_VOLUME_FLOW; \
	VARIABLE trans9_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans9_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans9_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans9_FlowE_VOLUME_FLOW_page; \
	COMMAND trans9_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans9_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans9_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans9_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans9_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans9_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans9_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans9_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans9_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans9_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans9_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans9_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans9_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans9_FlowE_SAMPLING_FREQ; \
	VARIABLE trans9_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans9_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans9_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans9_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans9_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans9_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans9_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans9_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans9_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans9_FlowE_unit_nominal_size; \
	UNIT trans9_FlowE_unit_volume_flow; \
	UNIT trans9_FlowE_unit_zero_point; \
	UNIT trans9_FlowE_unit_sampling_freq

#define USE_TRANS9_FLOWE_MANDATORY_A \
	USE_TRANS9_FLOWE_MANDATORY_BOTH; \
	MENU trans9_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS9_FLOWE_MANDATORY_B \
	USE_TRANS9_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans9_FlowE_VIEW_1; \
	MENU trans9_FlowE_VIEW_1_page; \
	MENU trans9_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS9_FLOWE_OPTIONAL_A \
	COLLECTION trans9_FlowE_VIEW_1; \
	MENU trans9_FlowE_VIEW_1_page; \
	MENU trans9_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS9_FLOWE_OPTIONAL_B \
	MENU trans9_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS9_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans9_FlowE_)
#define USE_TRANS9_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans9_FlowE_)
#define USE_TRANS9_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans9_FlowE_)
#define USE_TRANS9_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans9_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS10_FLOWE_MANDATORY_BOTH \
	BLOCK trans10_FlowE_block; \
	COLLECTION trans10_FlowE_BLOCK_OBJECT; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans10_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans10_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans10_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans10_FlowE_ST_REV; \
	MENU trans10_FlowE_ST_REV_page; \
	COMMAND trans10_FlowE_ST_REV_read; \
	VARIABLE trans10_FlowE_TAG_DESC; \
	MENU trans10_FlowE_TAG_DESC_page; \
	COMMAND trans10_FlowE_TAG_DESC_read; \
	COMMAND trans10_FlowE_TAG_DESC_write; \
	VARIABLE trans10_FlowE_STRATEGY; \
	MENU trans10_FlowE_STRATEGY_page; \
	COMMAND trans10_FlowE_STRATEGY_read; \
	COMMAND trans10_FlowE_STRATEGY_write; \
	VARIABLE trans10_FlowE_ALERT_KEY; \
	MENU trans10_FlowE_ALERT_KEY_page; \
	COMMAND trans10_FlowE_ALERT_KEY_read; \
	COMMAND trans10_FlowE_ALERT_KEY_write; \
	VARIABLE trans10_FlowE_TARGET_MODE; \
	MENU trans10_FlowE_TARGET_MODE_page; \
	COMMAND trans10_FlowE_TARGET_MODE_read; \
	COMMAND trans10_FlowE_TARGET_MODE_write; \
	COLLECTION trans10_FlowE_MODE_BLK; \
	VARIABLE trans10_FlowE_MODE_BLK_Actual; \
	VARIABLE trans10_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans10_FlowE_MODE_BLK_Normal; \
	MENU trans10_FlowE_MODE_BLK_page; \
	COMMAND trans10_FlowE_MODE_BLK_read; \
	COLLECTION trans10_FlowE_ALARM_SUM; \
	VARIABLE trans10_FlowE_ALARM_SUM_Current; \
	VARIABLE trans10_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans10_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans10_FlowE_ALARM_SUM_Disabled; \
	MENU trans10_FlowE_ALARM_SUM_page; \
	COMMAND trans10_FlowE_ALARM_SUM_read; \
	VARIABLE trans10_FlowE_CALIBR_FACTOR; \
	MENU trans10_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans10_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans10_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans10_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans10_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans10_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans10_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans10_FlowE_MEASUREMENT_MODE; \
	MENU trans10_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans10_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans10_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans10_FlowE_FLOW_DIRECTION; \
	MENU trans10_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans10_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans10_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans10_FlowE_ZERO_POINT; \
	MENU trans10_FlowE_ZERO_POINT_page; \
	COMMAND trans10_FlowE_ZERO_POINT_read; \
	COMMAND trans10_FlowE_ZERO_POINT_write; \
	VARIABLE trans10_FlowE_ZERO_POINT_ADJUST; \
	MENU trans10_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans10_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans10_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans10_FlowE_ZERO_POINT_UNIT; \
	MENU trans10_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans10_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans10_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans10_FlowE_NOMINAL_SIZE; \
	MENU trans10_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans10_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans10_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans10_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans10_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans10_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans10_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans10_FlowE_VOLUME_FLOW; \
	VARIABLE trans10_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans10_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans10_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans10_FlowE_VOLUME_FLOW_page; \
	COMMAND trans10_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans10_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans10_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans10_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans10_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans10_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans10_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans10_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans10_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans10_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans10_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans10_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans10_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans10_FlowE_SAMPLING_FREQ; \
	VARIABLE trans10_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans10_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans10_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans10_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans10_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans10_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans10_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans10_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans10_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans10_FlowE_unit_nominal_size; \
	UNIT trans10_FlowE_unit_volume_flow; \
	UNIT trans10_FlowE_unit_zero_point; \
	UNIT trans10_FlowE_unit_sampling_freq

#define USE_TRANS10_FLOWE_MANDATORY_A \
	USE_TRANS10_FLOWE_MANDATORY_BOTH; \
	MENU trans10_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS10_FLOWE_MANDATORY_B \
	USE_TRANS10_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans10_FlowE_VIEW_1; \
	MENU trans10_FlowE_VIEW_1_page; \
	MENU trans10_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS10_FLOWE_OPTIONAL_A \
	COLLECTION trans10_FlowE_VIEW_1; \
	MENU trans10_FlowE_VIEW_1_page; \
	MENU trans10_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS10_FLOWE_OPTIONAL_B \
	MENU trans10_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS10_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans10_FlowE_)
#define USE_TRANS10_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans10_FlowE_)
#define USE_TRANS10_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans10_FlowE_)
#define USE_TRANS10_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans10_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS11_FLOWE_MANDATORY_BOTH \
	BLOCK trans11_FlowE_block; \
	COLLECTION trans11_FlowE_BLOCK_OBJECT; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans11_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans11_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans11_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans11_FlowE_ST_REV; \
	MENU trans11_FlowE_ST_REV_page; \
	COMMAND trans11_FlowE_ST_REV_read; \
	VARIABLE trans11_FlowE_TAG_DESC; \
	MENU trans11_FlowE_TAG_DESC_page; \
	COMMAND trans11_FlowE_TAG_DESC_read; \
	COMMAND trans11_FlowE_TAG_DESC_write; \
	VARIABLE trans11_FlowE_STRATEGY; \
	MENU trans11_FlowE_STRATEGY_page; \
	COMMAND trans11_FlowE_STRATEGY_read; \
	COMMAND trans11_FlowE_STRATEGY_write; \
	VARIABLE trans11_FlowE_ALERT_KEY; \
	MENU trans11_FlowE_ALERT_KEY_page; \
	COMMAND trans11_FlowE_ALERT_KEY_read; \
	COMMAND trans11_FlowE_ALERT_KEY_write; \
	VARIABLE trans11_FlowE_TARGET_MODE; \
	MENU trans11_FlowE_TARGET_MODE_page; \
	COMMAND trans11_FlowE_TARGET_MODE_read; \
	COMMAND trans11_FlowE_TARGET_MODE_write; \
	COLLECTION trans11_FlowE_MODE_BLK; \
	VARIABLE trans11_FlowE_MODE_BLK_Actual; \
	VARIABLE trans11_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans11_FlowE_MODE_BLK_Normal; \
	MENU trans11_FlowE_MODE_BLK_page; \
	COMMAND trans11_FlowE_MODE_BLK_read; \
	COLLECTION trans11_FlowE_ALARM_SUM; \
	VARIABLE trans11_FlowE_ALARM_SUM_Current; \
	VARIABLE trans11_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans11_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans11_FlowE_ALARM_SUM_Disabled; \
	MENU trans11_FlowE_ALARM_SUM_page; \
	COMMAND trans11_FlowE_ALARM_SUM_read; \
	VARIABLE trans11_FlowE_CALIBR_FACTOR; \
	MENU trans11_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans11_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans11_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans11_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans11_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans11_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans11_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans11_FlowE_MEASUREMENT_MODE; \
	MENU trans11_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans11_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans11_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans11_FlowE_FLOW_DIRECTION; \
	MENU trans11_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans11_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans11_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans11_FlowE_ZERO_POINT; \
	MENU trans11_FlowE_ZERO_POINT_page; \
	COMMAND trans11_FlowE_ZERO_POINT_read; \
	COMMAND trans11_FlowE_ZERO_POINT_write; \
	VARIABLE trans11_FlowE_ZERO_POINT_ADJUST; \
	MENU trans11_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans11_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans11_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans11_FlowE_ZERO_POINT_UNIT; \
	MENU trans11_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans11_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans11_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans11_FlowE_NOMINAL_SIZE; \
	MENU trans11_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans11_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans11_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans11_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans11_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans11_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans11_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans11_FlowE_VOLUME_FLOW; \
	VARIABLE trans11_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans11_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans11_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans11_FlowE_VOLUME_FLOW_page; \
	COMMAND trans11_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans11_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans11_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans11_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans11_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans11_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans11_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans11_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans11_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans11_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans11_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans11_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans11_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans11_FlowE_SAMPLING_FREQ; \
	VARIABLE trans11_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans11_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans11_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans11_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans11_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans11_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans11_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans11_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans11_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans11_FlowE_unit_nominal_size; \
	UNIT trans11_FlowE_unit_volume_flow; \
	UNIT trans11_FlowE_unit_zero_point; \
	UNIT trans11_FlowE_unit_sampling_freq

#define USE_TRANS11_FLOWE_MANDATORY_A \
	USE_TRANS11_FLOWE_MANDATORY_BOTH; \
	MENU trans11_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS11_FLOWE_MANDATORY_B \
	USE_TRANS11_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans11_FlowE_VIEW_1; \
	MENU trans11_FlowE_VIEW_1_page; \
	MENU trans11_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS11_FLOWE_OPTIONAL_A \
	COLLECTION trans11_FlowE_VIEW_1; \
	MENU trans11_FlowE_VIEW_1_page; \
	MENU trans11_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS11_FLOWE_OPTIONAL_B \
	MENU trans11_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS11_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans11_FlowE_)
#define USE_TRANS11_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans11_FlowE_)
#define USE_TRANS11_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans11_FlowE_)
#define USE_TRANS11_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans11_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS12_FLOWE_MANDATORY_BOTH \
	BLOCK trans12_FlowE_block; \
	COLLECTION trans12_FlowE_BLOCK_OBJECT; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans12_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans12_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans12_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans12_FlowE_ST_REV; \
	MENU trans12_FlowE_ST_REV_page; \
	COMMAND trans12_FlowE_ST_REV_read; \
	VARIABLE trans12_FlowE_TAG_DESC; \
	MENU trans12_FlowE_TAG_DESC_page; \
	COMMAND trans12_FlowE_TAG_DESC_read; \
	COMMAND trans12_FlowE_TAG_DESC_write; \
	VARIABLE trans12_FlowE_STRATEGY; \
	MENU trans12_FlowE_STRATEGY_page; \
	COMMAND trans12_FlowE_STRATEGY_read; \
	COMMAND trans12_FlowE_STRATEGY_write; \
	VARIABLE trans12_FlowE_ALERT_KEY; \
	MENU trans12_FlowE_ALERT_KEY_page; \
	COMMAND trans12_FlowE_ALERT_KEY_read; \
	COMMAND trans12_FlowE_ALERT_KEY_write; \
	VARIABLE trans12_FlowE_TARGET_MODE; \
	MENU trans12_FlowE_TARGET_MODE_page; \
	COMMAND trans12_FlowE_TARGET_MODE_read; \
	COMMAND trans12_FlowE_TARGET_MODE_write; \
	COLLECTION trans12_FlowE_MODE_BLK; \
	VARIABLE trans12_FlowE_MODE_BLK_Actual; \
	VARIABLE trans12_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans12_FlowE_MODE_BLK_Normal; \
	MENU trans12_FlowE_MODE_BLK_page; \
	COMMAND trans12_FlowE_MODE_BLK_read; \
	COLLECTION trans12_FlowE_ALARM_SUM; \
	VARIABLE trans12_FlowE_ALARM_SUM_Current; \
	VARIABLE trans12_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans12_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans12_FlowE_ALARM_SUM_Disabled; \
	MENU trans12_FlowE_ALARM_SUM_page; \
	COMMAND trans12_FlowE_ALARM_SUM_read; \
	VARIABLE trans12_FlowE_CALIBR_FACTOR; \
	MENU trans12_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans12_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans12_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans12_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans12_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans12_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans12_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans12_FlowE_MEASUREMENT_MODE; \
	MENU trans12_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans12_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans12_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans12_FlowE_FLOW_DIRECTION; \
	MENU trans12_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans12_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans12_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans12_FlowE_ZERO_POINT; \
	MENU trans12_FlowE_ZERO_POINT_page; \
	COMMAND trans12_FlowE_ZERO_POINT_read; \
	COMMAND trans12_FlowE_ZERO_POINT_write; \
	VARIABLE trans12_FlowE_ZERO_POINT_ADJUST; \
	MENU trans12_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans12_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans12_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans12_FlowE_ZERO_POINT_UNIT; \
	MENU trans12_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans12_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans12_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans12_FlowE_NOMINAL_SIZE; \
	MENU trans12_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans12_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans12_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans12_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans12_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans12_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans12_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans12_FlowE_VOLUME_FLOW; \
	VARIABLE trans12_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans12_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans12_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans12_FlowE_VOLUME_FLOW_page; \
	COMMAND trans12_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans12_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans12_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans12_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans12_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans12_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans12_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans12_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans12_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans12_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans12_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans12_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans12_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans12_FlowE_SAMPLING_FREQ; \
	VARIABLE trans12_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans12_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans12_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans12_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans12_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans12_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans12_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans12_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans12_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans12_FlowE_unit_nominal_size; \
	UNIT trans12_FlowE_unit_volume_flow; \
	UNIT trans12_FlowE_unit_zero_point; \
	UNIT trans12_FlowE_unit_sampling_freq

#define USE_TRANS12_FLOWE_MANDATORY_A \
	USE_TRANS12_FLOWE_MANDATORY_BOTH; \
	MENU trans12_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS12_FLOWE_MANDATORY_B \
	USE_TRANS12_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans12_FlowE_VIEW_1; \
	MENU trans12_FlowE_VIEW_1_page; \
	MENU trans12_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS12_FLOWE_OPTIONAL_A \
	COLLECTION trans12_FlowE_VIEW_1; \
	MENU trans12_FlowE_VIEW_1_page; \
	MENU trans12_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS12_FLOWE_OPTIONAL_B \
	MENU trans12_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS12_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans12_FlowE_)
#define USE_TRANS12_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans12_FlowE_)
#define USE_TRANS12_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans12_FlowE_)
#define USE_TRANS12_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans12_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS13_FLOWE_MANDATORY_BOTH \
	BLOCK trans13_FlowE_block; \
	COLLECTION trans13_FlowE_BLOCK_OBJECT; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans13_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans13_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans13_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans13_FlowE_ST_REV; \
	MENU trans13_FlowE_ST_REV_page; \
	COMMAND trans13_FlowE_ST_REV_read; \
	VARIABLE trans13_FlowE_TAG_DESC; \
	MENU trans13_FlowE_TAG_DESC_page; \
	COMMAND trans13_FlowE_TAG_DESC_read; \
	COMMAND trans13_FlowE_TAG_DESC_write; \
	VARIABLE trans13_FlowE_STRATEGY; \
	MENU trans13_FlowE_STRATEGY_page; \
	COMMAND trans13_FlowE_STRATEGY_read; \
	COMMAND trans13_FlowE_STRATEGY_write; \
	VARIABLE trans13_FlowE_ALERT_KEY; \
	MENU trans13_FlowE_ALERT_KEY_page; \
	COMMAND trans13_FlowE_ALERT_KEY_read; \
	COMMAND trans13_FlowE_ALERT_KEY_write; \
	VARIABLE trans13_FlowE_TARGET_MODE; \
	MENU trans13_FlowE_TARGET_MODE_page; \
	COMMAND trans13_FlowE_TARGET_MODE_read; \
	COMMAND trans13_FlowE_TARGET_MODE_write; \
	COLLECTION trans13_FlowE_MODE_BLK; \
	VARIABLE trans13_FlowE_MODE_BLK_Actual; \
	VARIABLE trans13_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans13_FlowE_MODE_BLK_Normal; \
	MENU trans13_FlowE_MODE_BLK_page; \
	COMMAND trans13_FlowE_MODE_BLK_read; \
	COLLECTION trans13_FlowE_ALARM_SUM; \
	VARIABLE trans13_FlowE_ALARM_SUM_Current; \
	VARIABLE trans13_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans13_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans13_FlowE_ALARM_SUM_Disabled; \
	MENU trans13_FlowE_ALARM_SUM_page; \
	COMMAND trans13_FlowE_ALARM_SUM_read; \
	VARIABLE trans13_FlowE_CALIBR_FACTOR; \
	MENU trans13_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans13_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans13_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans13_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans13_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans13_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans13_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans13_FlowE_MEASUREMENT_MODE; \
	MENU trans13_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans13_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans13_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans13_FlowE_FLOW_DIRECTION; \
	MENU trans13_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans13_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans13_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans13_FlowE_ZERO_POINT; \
	MENU trans13_FlowE_ZERO_POINT_page; \
	COMMAND trans13_FlowE_ZERO_POINT_read; \
	COMMAND trans13_FlowE_ZERO_POINT_write; \
	VARIABLE trans13_FlowE_ZERO_POINT_ADJUST; \
	MENU trans13_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans13_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans13_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans13_FlowE_ZERO_POINT_UNIT; \
	MENU trans13_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans13_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans13_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans13_FlowE_NOMINAL_SIZE; \
	MENU trans13_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans13_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans13_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans13_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans13_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans13_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans13_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans13_FlowE_VOLUME_FLOW; \
	VARIABLE trans13_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans13_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans13_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans13_FlowE_VOLUME_FLOW_page; \
	COMMAND trans13_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans13_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans13_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans13_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans13_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans13_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans13_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans13_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans13_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans13_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans13_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans13_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans13_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans13_FlowE_SAMPLING_FREQ; \
	VARIABLE trans13_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans13_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans13_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans13_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans13_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans13_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans13_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans13_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans13_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans13_FlowE_unit_nominal_size; \
	UNIT trans13_FlowE_unit_volume_flow; \
	UNIT trans13_FlowE_unit_zero_point; \
	UNIT trans13_FlowE_unit_sampling_freq

#define USE_TRANS13_FLOWE_MANDATORY_A \
	USE_TRANS13_FLOWE_MANDATORY_BOTH; \
	MENU trans13_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS13_FLOWE_MANDATORY_B \
	USE_TRANS13_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans13_FlowE_VIEW_1; \
	MENU trans13_FlowE_VIEW_1_page; \
	MENU trans13_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS13_FLOWE_OPTIONAL_A \
	COLLECTION trans13_FlowE_VIEW_1; \
	MENU trans13_FlowE_VIEW_1_page; \
	MENU trans13_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS13_FLOWE_OPTIONAL_B \
	MENU trans13_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS13_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans13_FlowE_)
#define USE_TRANS13_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans13_FlowE_)
#define USE_TRANS13_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans13_FlowE_)
#define USE_TRANS13_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans13_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS14_FLOWE_MANDATORY_BOTH \
	BLOCK trans14_FlowE_block; \
	COLLECTION trans14_FlowE_BLOCK_OBJECT; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans14_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans14_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans14_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans14_FlowE_ST_REV; \
	MENU trans14_FlowE_ST_REV_page; \
	COMMAND trans14_FlowE_ST_REV_read; \
	VARIABLE trans14_FlowE_TAG_DESC; \
	MENU trans14_FlowE_TAG_DESC_page; \
	COMMAND trans14_FlowE_TAG_DESC_read; \
	COMMAND trans14_FlowE_TAG_DESC_write; \
	VARIABLE trans14_FlowE_STRATEGY; \
	MENU trans14_FlowE_STRATEGY_page; \
	COMMAND trans14_FlowE_STRATEGY_read; \
	COMMAND trans14_FlowE_STRATEGY_write; \
	VARIABLE trans14_FlowE_ALERT_KEY; \
	MENU trans14_FlowE_ALERT_KEY_page; \
	COMMAND trans14_FlowE_ALERT_KEY_read; \
	COMMAND trans14_FlowE_ALERT_KEY_write; \
	VARIABLE trans14_FlowE_TARGET_MODE; \
	MENU trans14_FlowE_TARGET_MODE_page; \
	COMMAND trans14_FlowE_TARGET_MODE_read; \
	COMMAND trans14_FlowE_TARGET_MODE_write; \
	COLLECTION trans14_FlowE_MODE_BLK; \
	VARIABLE trans14_FlowE_MODE_BLK_Actual; \
	VARIABLE trans14_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans14_FlowE_MODE_BLK_Normal; \
	MENU trans14_FlowE_MODE_BLK_page; \
	COMMAND trans14_FlowE_MODE_BLK_read; \
	COLLECTION trans14_FlowE_ALARM_SUM; \
	VARIABLE trans14_FlowE_ALARM_SUM_Current; \
	VARIABLE trans14_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans14_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans14_FlowE_ALARM_SUM_Disabled; \
	MENU trans14_FlowE_ALARM_SUM_page; \
	COMMAND trans14_FlowE_ALARM_SUM_read; \
	VARIABLE trans14_FlowE_CALIBR_FACTOR; \
	MENU trans14_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans14_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans14_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans14_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans14_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans14_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans14_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans14_FlowE_MEASUREMENT_MODE; \
	MENU trans14_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans14_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans14_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans14_FlowE_FLOW_DIRECTION; \
	MENU trans14_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans14_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans14_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans14_FlowE_ZERO_POINT; \
	MENU trans14_FlowE_ZERO_POINT_page; \
	COMMAND trans14_FlowE_ZERO_POINT_read; \
	COMMAND trans14_FlowE_ZERO_POINT_write; \
	VARIABLE trans14_FlowE_ZERO_POINT_ADJUST; \
	MENU trans14_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans14_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans14_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans14_FlowE_ZERO_POINT_UNIT; \
	MENU trans14_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans14_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans14_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans14_FlowE_NOMINAL_SIZE; \
	MENU trans14_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans14_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans14_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans14_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans14_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans14_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans14_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans14_FlowE_VOLUME_FLOW; \
	VARIABLE trans14_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans14_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans14_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans14_FlowE_VOLUME_FLOW_page; \
	COMMAND trans14_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans14_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans14_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans14_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans14_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans14_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans14_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans14_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans14_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans14_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans14_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans14_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans14_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans14_FlowE_SAMPLING_FREQ; \
	VARIABLE trans14_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans14_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans14_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans14_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans14_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans14_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans14_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans14_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans14_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans14_FlowE_unit_nominal_size; \
	UNIT trans14_FlowE_unit_volume_flow; \
	UNIT trans14_FlowE_unit_zero_point; \
	UNIT trans14_FlowE_unit_sampling_freq

#define USE_TRANS14_FLOWE_MANDATORY_A \
	USE_TRANS14_FLOWE_MANDATORY_BOTH; \
	MENU trans14_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS14_FLOWE_MANDATORY_B \
	USE_TRANS14_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans14_FlowE_VIEW_1; \
	MENU trans14_FlowE_VIEW_1_page; \
	MENU trans14_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS14_FLOWE_OPTIONAL_A \
	COLLECTION trans14_FlowE_VIEW_1; \
	MENU trans14_FlowE_VIEW_1_page; \
	MENU trans14_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS14_FLOWE_OPTIONAL_B \
	MENU trans14_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS14_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans14_FlowE_)
#define USE_TRANS14_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans14_FlowE_)
#define USE_TRANS14_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans14_FlowE_)
#define USE_TRANS14_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans14_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS15_FLOWE_MANDATORY_BOTH \
	BLOCK trans15_FlowE_block; \
	COLLECTION trans15_FlowE_BLOCK_OBJECT; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Reserved; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Class; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Profile; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans15_FlowE_BLOCK_OBJECT_Number_of_Views; \
	MENU trans15_FlowE_BLOCK_OBJECT_page; \
	COMMAND trans15_FlowE_BLOCK_OBJECT_read; \
	VARIABLE trans15_FlowE_ST_REV; \
	MENU trans15_FlowE_ST_REV_page; \
	COMMAND trans15_FlowE_ST_REV_read; \
	VARIABLE trans15_FlowE_TAG_DESC; \
	MENU trans15_FlowE_TAG_DESC_page; \
	COMMAND trans15_FlowE_TAG_DESC_read; \
	COMMAND trans15_FlowE_TAG_DESC_write; \
	VARIABLE trans15_FlowE_STRATEGY; \
	MENU trans15_FlowE_STRATEGY_page; \
	COMMAND trans15_FlowE_STRATEGY_read; \
	COMMAND trans15_FlowE_STRATEGY_write; \
	VARIABLE trans15_FlowE_ALERT_KEY; \
	MENU trans15_FlowE_ALERT_KEY_page; \
	COMMAND trans15_FlowE_ALERT_KEY_read; \
	COMMAND trans15_FlowE_ALERT_KEY_write; \
	VARIABLE trans15_FlowE_TARGET_MODE; \
	MENU trans15_FlowE_TARGET_MODE_page; \
	COMMAND trans15_FlowE_TARGET_MODE_read; \
	COMMAND trans15_FlowE_TARGET_MODE_write; \
	COLLECTION trans15_FlowE_MODE_BLK; \
	VARIABLE trans15_FlowE_MODE_BLK_Actual; \
	VARIABLE trans15_FlowE_MODE_BLK_Permitted; \
	VARIABLE trans15_FlowE_MODE_BLK_Normal; \
	MENU trans15_FlowE_MODE_BLK_page; \
	COMMAND trans15_FlowE_MODE_BLK_read; \
	COLLECTION trans15_FlowE_ALARM_SUM; \
	VARIABLE trans15_FlowE_ALARM_SUM_Current; \
	VARIABLE trans15_FlowE_ALARM_SUM_Unacknowledged; \
	VARIABLE trans15_FlowE_ALARM_SUM_Unreported; \
	VARIABLE trans15_FlowE_ALARM_SUM_Disabled; \
	MENU trans15_FlowE_ALARM_SUM_page; \
	COMMAND trans15_FlowE_ALARM_SUM_read; \
	VARIABLE trans15_FlowE_CALIBR_FACTOR; \
	MENU trans15_FlowE_CALIBR_FACTOR_page; \
	COMMAND trans15_FlowE_CALIBR_FACTOR_read; \
	COMMAND trans15_FlowE_CALIBR_FACTOR_write; \
	VARIABLE trans15_FlowE_LOW_FLOW_CUTOFF; \
	MENU trans15_FlowE_LOW_FLOW_CUTOFF_page; \
	COMMAND trans15_FlowE_LOW_FLOW_CUTOFF_read; \
	COMMAND trans15_FlowE_LOW_FLOW_CUTOFF_write; \
	VARIABLE trans15_FlowE_MEASUREMENT_MODE; \
	MENU trans15_FlowE_MEASUREMENT_MODE_page; \
	COMMAND trans15_FlowE_MEASUREMENT_MODE_read; \
	COMMAND trans15_FlowE_MEASUREMENT_MODE_write; \
	VARIABLE trans15_FlowE_FLOW_DIRECTION; \
	MENU trans15_FlowE_FLOW_DIRECTION_page; \
	COMMAND trans15_FlowE_FLOW_DIRECTION_read; \
	COMMAND trans15_FlowE_FLOW_DIRECTION_write; \
	VARIABLE trans15_FlowE_ZERO_POINT; \
	MENU trans15_FlowE_ZERO_POINT_page; \
	COMMAND trans15_FlowE_ZERO_POINT_read; \
	COMMAND trans15_FlowE_ZERO_POINT_write; \
	VARIABLE trans15_FlowE_ZERO_POINT_ADJUST; \
	MENU trans15_FlowE_ZERO_POINT_ADJUST_page; \
	COMMAND trans15_FlowE_ZERO_POINT_ADJUST_read; \
	COMMAND trans15_FlowE_ZERO_POINT_ADJUST_write; \
	VARIABLE trans15_FlowE_ZERO_POINT_UNIT; \
	MENU trans15_FlowE_ZERO_POINT_UNIT_page; \
	COMMAND trans15_FlowE_ZERO_POINT_UNIT_read; \
	COMMAND trans15_FlowE_ZERO_POINT_UNIT_write; \
	VARIABLE trans15_FlowE_NOMINAL_SIZE; \
	MENU trans15_FlowE_NOMINAL_SIZE_page; \
	COMMAND trans15_FlowE_NOMINAL_SIZE_read; \
	COMMAND trans15_FlowE_NOMINAL_SIZE_write; \
	VARIABLE trans15_FlowE_NOMINAL_SIZE_UNITS; \
	MENU trans15_FlowE_NOMINAL_SIZE_UNITS_page; \
	COMMAND trans15_FlowE_NOMINAL_SIZE_UNITS_read; \
	COMMAND trans15_FlowE_NOMINAL_SIZE_UNITS_write; \
	COLLECTION trans15_FlowE_VOLUME_FLOW; \
	VARIABLE trans15_FlowE_VOLUME_FLOW_Value; \
	VARIABLE trans15_FlowE_VOLUME_FLOW_Status_Quality; \
	VARIABLE trans15_FlowE_VOLUME_FLOW_Status_Limit; \
	MENU trans15_FlowE_VOLUME_FLOW_page; \
	COMMAND trans15_FlowE_VOLUME_FLOW_read; \
	VARIABLE trans15_FlowE_VOLUME_FLOW_UNITS; \
	MENU trans15_FlowE_VOLUME_FLOW_UNITS_page; \
	COMMAND trans15_FlowE_VOLUME_FLOW_UNITS_read; \
	COMMAND trans15_FlowE_VOLUME_FLOW_UNITS_write; \
	VARIABLE trans15_FlowE_VOLUME_FLOW_LO_LIMIT; \
	MENU trans15_FlowE_VOLUME_FLOW_LO_LIMIT_page; \
	COMMAND trans15_FlowE_VOLUME_FLOW_LO_LIMIT_read; \
	COMMAND trans15_FlowE_VOLUME_FLOW_LO_LIMIT_write; \
	VARIABLE trans15_FlowE_VOLUME_FLOW_HI_LIMIT; \
	MENU trans15_FlowE_VOLUME_FLOW_HI_LIMIT_page; \
	COMMAND trans15_FlowE_VOLUME_FLOW_HI_LIMIT_read; \
	COMMAND trans15_FlowE_VOLUME_FLOW_HI_LIMIT_write; \
	COLLECTION trans15_FlowE_SAMPLING_FREQ; \
	VARIABLE trans15_FlowE_SAMPLING_FREQ_Value; \
	VARIABLE trans15_FlowE_SAMPLING_FREQ_Status_Quality; \
	VARIABLE trans15_FlowE_SAMPLING_FREQ_Status_Limit; \
	MENU trans15_FlowE_SAMPLING_FREQ_page; \
	COMMAND trans15_FlowE_SAMPLING_FREQ_read; \
	VARIABLE trans15_FlowE_SAMPLING_FREQ_UNITS; \
	MENU trans15_FlowE_SAMPLING_FREQ_UNITS_page; \
	COMMAND trans15_FlowE_SAMPLING_FREQ_UNITS_read; \
	COMMAND trans15_FlowE_SAMPLING_FREQ_UNITS_write; \
	UNIT trans15_FlowE_unit_nominal_size; \
	UNIT trans15_FlowE_unit_volume_flow; \
	UNIT trans15_FlowE_unit_zero_point; \
	UNIT trans15_FlowE_unit_sampling_freq

#define USE_TRANS15_FLOWE_MANDATORY_A \
	USE_TRANS15_FLOWE_MANDATORY_BOTH; \
	MENU trans15_FlowE_Simple_Dialog_Mandatory_A

#define USE_TRANS15_FLOWE_MANDATORY_B \
	USE_TRANS15_FLOWE_MANDATORY_BOTH; \
	COLLECTION trans15_FlowE_VIEW_1; \
	MENU trans15_FlowE_VIEW_1_page; \
	MENU trans15_FlowE_Simple_Dialog_Mandatory_B

#define USE_TRANS15_FLOWE_OPTIONAL_A \
	COLLECTION trans15_FlowE_VIEW_1; \
	MENU trans15_FlowE_VIEW_1_page; \
	MENU trans15_FlowE_Simple_Dialog_Optional_A

#define USE_TRANS15_FLOWE_OPTIONAL_B \
	MENU trans15_FlowE_Simple_Dialog_Optional_B

#else /* CPP_CANT_CONCAT */

#define USE_TRANS15_FLOWE_MANDATORY_A USE_TRANS_FLOWE_MANDATORY_A(trans15_FlowE_)
#define USE_TRANS15_FLOWE_MANDATORY_B USE_TRANS_FLOWE_MANDATORY_B(trans15_FlowE_)
#define USE_TRANS15_FLOWE_OPTIONAL_A  USE_TRANS_FLOWE_OPTIONAL_A(trans15_FlowE_)
#define USE_TRANS15_FLOWE_OPTIONAL_B  USE_TRANS_FLOWE_OPTIONAL_B(trans15_FlowE_)

#endif /* CPP_CANT_CONCAT */

#ifdef CPP_CANT_CONCAT

#define USE_TRANS1_FLOWTM_MANDATORY_BOTH \
	BLOCK trans1_FlowTM_block; \
	COLLECTION trans1_FlowTM_BLOCK_OBJECT; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Reserved; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Block_Object; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Parent_Class; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Class; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_DD_Reference; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_DD_Revision; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Profile; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Profile_Revision; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Execution_Time; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Number_of_Parameters; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Address_of_VIEW_1_Slot; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Address_of_VIEW_1_Index; \
	VARIABLE trans1_FlowTM_BLOCK_OBJECT_Number_of_Views; \
	MENU trans1_FlowTM_BLOCK_OBJECT_page; \
	COMMAND trans1_FlowTM_BLOCK_OBJECT_read; \
	VARIABLE trans1_FlowTM_ST_REV; \
	MENU trans1_FlowTM_ST_REV_page; \
	COMMAND trans1_FlowTM_ST_REV_read; \
	VARIABLE t