/*---------------------------------------------------------------------------------------------*/
/*	Copyright (C) Fint (2012). All Rights Reserved	*/
/*	Product:		SIMATIC PDM				*/
/*                                                          					*/
/*	Device:		HPA		*/

/*	Description:	Device Description			*/
/*	Dictionary:		HART_lib.h			*/
/*                                                          			*/
/*  $Revision:   1.0  $						*/
/*  $Date:   Juli 25 2012  $				*/
/*---------------------------------------------------------------------------------------------*/



#include "pa_import.h"
#include "pa_macros.h"
#include "pa_units.h"
#include "HART_lib.h"
#include "Manufacturer_List.h"
//#include "rsp_codes.h";

#define DEFAULT_MANUFACTURER_ID  1449



 
 
#define UNIT_LIST								    	\
		{ 1000,	[unit_1000],	[unit_1000_help]	},	\
		{ 1001,	[unit_1001],	[unit_1001_help]	},	\
		{ 1002,	[unit_1002],	[unit_1002_help]	},	\
		{ 1003,	[unit_1003],	[unit_1003_help]	},	\
		{ 1004,	[unit_1004],	[unit_1004_help]	},	\
		{ 1005,	[unit_1005],	[unit_1005_help]	},	\
		{ 1006,	[unit_1006],	[unit_1006_help]	},	\
		{ 1007,	[unit_1007],	[unit_1007_help]	},	\
		{ 1008,	[unit_1008],	[unit_1008_help]	},	\
		{ 1009,	[unit_1009],	[unit_1009_help]	},	\
		{ 1010,	[unit_1010],	[unit_1010_help]	},	\
		{ 1011,	[unit_1011],	[unit_1011_help]	},	\
		{ 1012,	[unit_1012],	[unit_1012_help]	},	\
		{ 1013,	[unit_1013],	[unit_1013_help]	},	\
		{ 1014,	[unit_1014],	[unit_1014_help]	},	\
		{ 1015,	[unit_1015],	[unit_1015_help]	},	\
		{ 1016,	[unit_1016],	[unit_1016_help]	},	\
		{ 1017,	[unit_1017],	[unit_1017_help]	},	\
		{ 1018,	[unit_1018],	[unit_1018_help]	},	\
		{ 1019,	[unit_1019],	[unit_1019_help]	},	\
		{ 1020,	[unit_1020],	[unit_1020_help]	},	\
		{ 1021,	[unit_1021],	[unit_1021_help]	},	\
		{ 1022,	[unit_1022],	[unit_1022_help]	},	\
		{ 1023,	[unit_1023],	[unit_1023_help]	},	\
		{ 1024,	[unit_1024],	[unit_1024_help]	},	\
		{ 1025,	[unit_1025],	[unit_1025_help]	},	\
		{ 1026,	[unit_1026],	[unit_1026_help]	},	\
		{ 1027,	[unit_1027],	[unit_1027_help]	},	\
		{ 1028,	[unit_1028],	[unit_1028_help]	},	\
		{ 1029,	[unit_1029],	[unit_1029_help]	},	\
		{ 1030,	[unit_1030],	[unit_1030_help]	},	\
		{ 1031,	[unit_1031],	[unit_1031_help]	},	\
		{ 1032,	[unit_1032],	[unit_1032_help]	},	\
		{ 1033,	[unit_1033],	[unit_1033_help]	},	\
		{ 1034,	[unit_1034],	[unit_1034_help]	},	\
		{ 1035,	[unit_1035],	[unit_1035_help]	},	\
		{ 1036,	[unit_1036],	[unit_1036_help]	},	\
		{ 1037,	[unit_1037],	[unit_1037_help]	},	\
		{ 1038,	[unit_1038],	[unit_1038_help]	},	\
		{ 1039,	[unit_1039],	[unit_1039_help]	},	\
		{ 1040,	[unit_1040],	[unit_1040_help]	},	\
		{ 1041,	[unit_1041],	[unit_1041_help]	},	\
		{ 1042,	[unit_1042],	[unit_1042_help]	},	\
		{ 1043,	[unit_1043],	[unit_1043_help]	},	\
		{ 1044,	[unit_1044],	[unit_1044_help]	},	\
		{ 1045,	[unit_1045],	[unit_1045_help]	},	\
		{ 1046,	[unit_1046],	[unit_1046_help]	},	\
		{ 1047,	[unit_1047],	[unit_1047_help]	},	\
		{ 1048,	[unit_1048],	[unit_1048_help]	},	\
		{ 1049,	[unit_1049],	[unit_1049_help]	},	\
		{ 1050,	[unit_1050],	[unit_1050_help]	},	\
		{ 1051,	[unit_1051],	[unit_1051_help]	},	\
		{ 1052,	[unit_1052],	[unit_1052_help]	},	\
		{ 1053,	[unit_1053],	[unit_1053_help]	},	\
		{ 1054,	[unit_1054],	[unit_1054_help]	},	\
		{ 1055,	[unit_1055],	[unit_1055_help]	},	\
		{ 1056,	[unit_1056],	[unit_1056_help]	},	\
		{ 1057,	[unit_1057],	[unit_1057_help]	},	\
		{ 1058,	[unit_1058],	[unit_1058_help]	},	\
		{ 1059,	[unit_1059],	[unit_1059_help]	},	\
		{ 1060,	[unit_1060],	[unit_1060_help]	},	\
		{ 1061,	[unit_1061],	[unit_1061_help]	},	\
		{ 1062,	[unit_1062],	[unit_1062_help]	},	\
		{ 1063,	[unit_1063],	[unit_1063_help]	},	\
		{ 1064,	[unit_1064],	[unit_1064_help]	},	\
		{ 1065,	[unit_1065],	[unit_1065_help]	},	\
		{ 1066,	[unit_1066],	[unit_1066_help]	},	\
		{ 1067,	[unit_1067],	[unit_1067_help]	},	\
		{ 1068,	[unit_1068],	[unit_1068_help]	},	\
		{ 1069,	[unit_1069],	[unit_1069_help]	},	\
		{ 1070,	[unit_1070],	[unit_1070_help]	},	\
		{ 1071,	[unit_1071],	[unit_1071_help]	},	\
		{ 1072,	[unit_1072],	[unit_1072_help]	},	\
		{ 1073,	[unit_1073],	[unit_1073_help]	},	\
		{ 1074,	[unit_1074],	[unit_1074_help]	},	\
		{ 1075,	[unit_1075],	[unit_1075_help]	},	\
		{ 1076,	[unit_1076],	[unit_1076_help]	},	\
		{ 1077,	[unit_1077],	[unit_1077_help]	},	\
		{ 1078,	[unit_1078],	[unit_1078_help]	},	\
		{ 1079,	[unit_1079],	[unit_1079_help]	},	\
		{ 1080,	[unit_1080],	[unit_1080_help]	},	\
		{ 1081,	[unit_1081],	[unit_1081_help]	},	\
		{ 1082,	[unit_1082],	[unit_1082_help]	},	\
		{ 1083,	[unit_1083],	[unit_1083_help]	},	\
		{ 1084,	[unit_1084],	[unit_1084_help]	},	\
		{ 1085,	[unit_1085],	[unit_1085_help]	},	\
		{ 1086,	[unit_1086],	[unit_1086_help]	},	\
		{ 1087,	[unit_1087],	[unit_1087_help]	},	\
		{ 1088,	[unit_1088],	[unit_1088_help]	},	\
		{ 1089,	[unit_1089],	[unit_1089_help]	},	\
		{ 1090,	[unit_1090],	[unit_1090_help]	},	\
		{ 1091,	[unit_1091],	[unit_1091_help]	},	\
		{ 1092,	[unit_1092],	[unit_1092_help]	},	\
		{ 1093,	[unit_1093],	[unit_1093_help]	},	\
		{ 1094,	[unit_1094],	[unit_1094_help]	},	\
		{ 1095,	[unit_1095],	[unit_1095_help]	},	\
		{ 1096,	[unit_1096],	[unit_1096_help]	},	\
		{ 1097,	[unit_1097],	[unit_1097_help]	},	\
		{ 1098,	[unit_1098],	[unit_1098_help]	},	\
		{ 1099,	[unit_1099],	[unit_1099_help]	},	\
		{ 1100,	[unit_1100],	[unit_1100_help]	},	\
		{ 1101,	[unit_1101],	[unit_1101_help]	},	\
		{ 1102,	[unit_1102],	[unit_1102_help]	},	\
		{ 1103,	[unit_1103],	[unit_1103_help]	},	\
		{ 1104,	[unit_1104],	[unit_1104_help]	},	\
		{ 1105,	[unit_1105],	[unit_1105_help]	},	\
		{ 1106,	[unit_1106],	[unit_1106_help]	},	\
		{ 1107,	[unit_1107],	[unit_1107_help]	},	\
		{ 1108,	[unit_1108],	[unit_1108_help]	},	\
		{ 1109,	[unit_1109],	[unit_1109_help]	},	\
		{ 1110,	[unit_1110],	[unit_1110_help]	},	\
		{ 1111,	[unit_1111],	[unit_1111_help]	},	\
		{ 1112,	[unit_1112],	[unit_1112_help]	},	\
		{ 1113,	[unit_1113],	[unit_1113_help]	},	\
		{ 1114,	[unit_1114],	[unit_1114_help]	},	\
		{ 1115,	[unit_1115],	[unit_1115_help]	},	\
		{ 1116,	[unit_1116],	[unit_1116_help]	},	\
		{ 1117,	[unit_1117],	[unit_1117_help]	},	\
		{ 1118,	[unit_1118],	[unit_1118_help]	},	\
		{ 1119,	[unit_1119],	[unit_1119_help]	},	\
		{ 1120,	[unit_1120],	[unit_1120_help]	},	\
		{ 1121,	[unit_1121],	[unit_1121_help]	},	\
		{ 1122,	[unit_1122],	[unit_1122_help]	},	\
		{ 1123,	[unit_1123],	[unit_1123_help]	},	\
		{ 1124,	[unit_1124],	[unit_1124_help]	},	\
		{ 1125,	[unit_1125],	[unit_1125_help]	},	\
		{ 1126,	[unit_1126],	[unit_1126_help]	},	\
		{ 1127,	[unit_1127],	[unit_1127_help]	},	\
		{ 1128,	[unit_1128],	[unit_1128_help]	},	\
		{ 1129,	[unit_1129],	[unit_1129_help]	},	\
		{ 1130,	[unit_1130],	[unit_1130_help]	},	\
		{ 1131,	[unit_1131],	[unit_1131_help]	},	\
		{ 1132,	[unit_1132],	[unit_1132_help]	},	\
		{ 1133,	[unit_1133],	[unit_1133_help]	},	\
		{ 1134,	[unit_1134],	[unit_1134_help]	},	\
		{ 1135,	[unit_1135],	[unit_1135_help]	},	\
		{ 1136,	[unit_1136],	[unit_1136_help]	},	\
		{ 1137,	[unit_1137],	[unit_1137_help]	},	\
		{ 1138,	[unit_1138],	[unit_1138_help]	},	\
		{ 1139,	[unit_1139],	[unit_1139_help]	},	\
		{ 1140,	[unit_1140],	[unit_1140_help]	},	\
		{ 1141,	[unit_1141],	[unit_1141_help]	},	\
		{ 1142,	[unit_1142],	[unit_1142_help]	},	\
		{ 1143,	[unit_1143],	[unit_1143_help]	},	\
		{ 1144,	[unit_1144],	[unit_1144_help]	},	\
		{ 1145,	[unit_1145],	[unit_1145_help]	},	\
		{ 1146,	[unit_1146],	[unit_1146_help]	},	\
		{ 1147,	[unit_1147],	[unit_1147_help]	},	\
		{ 1148,	[unit_1148],	[unit_1148_help]	},	\
		{ 1149,	[unit_1149],	[unit_1149_help]	},	\
		{ 1140,	[unit_1140],	[unit_1140_help]	},	\
		{ 1141,	[unit_1141],	[unit_1141_help]	},	\
		{ 1142,	[unit_1142],	[unit_1142_help]	},	\
		{ 1144,	[unit_1144],	[unit_1144_help]	},	\
		{ 1144,	[unit_1144],	[unit_1144_help]	},	\
		{ 1145,	[unit_1145],	[unit_1145_help]	},	\
		{ 1146,	[unit_1146],	[unit_1146_help]	},	\
		{ 1147,	[unit_1147],	[unit_1147_help]	},	\
		{ 1148,	[unit_1148],	[unit_1148_help]	},	\
		{ 1149,	[unit_1149],	[unit_1149_help]	},	\
		{ 1150,	[unit_1150],	[unit_1150_help]	},	\
		{ 1151,	[unit_1151],	[unit_1151_help]	},	\
		{ 1152,	[unit_1152],	[unit_1152_help]	},	\
		{ 1153,	[unit_1153],	[unit_1153_help]	},	\
		{ 1154,	[unit_1154],	[unit_1154_help]	},	\
		{ 1155,	[unit_1155],	[unit_1155_help]	},	\
		{ 1156,	[unit_1156],	[unit_1156_help]	},	\
		{ 1157,	[unit_1157],	[unit_1157_help]	},	\
		{ 1158,	[unit_1158],	[unit_1158_help]	},	\
		{ 1159,	[unit_1159],	[unit_1159_help]	},	\
		{ 1160,	[unit_1160],	[unit_1160_help]	},	\
		{ 1161,	[unit_1161],	[unit_1161_help]	},	\
		{ 1162,	[unit_1162],	[unit_1162_help]	},	\
		{ 1163,	[unit_1163],	[unit_1163_help]	},	\
		{ 1164,	[unit_1164],	[unit_1164_help]	},	\
		{ 1165,	[unit_1165],	[unit_1165_help]	},	\
		{ 1166,	[unit_1166],	[unit_1166_help]	},	\
		{ 1167,	[unit_1167],	[unit_1167_help]	},	\
		{ 1168,	[unit_1168],	[unit_1168_help]	},	\
		{ 1169,	[unit_1169],	[unit_1169_help]	},	\
		{ 1170,	[unit_1170],	[unit_1170_help]	},	\
		{ 1171,	[unit_1171],	[unit_1171_help]	},	\
		{ 1172,	[unit_1172],	[unit_1172_help]	},	\
		{ 1173,	[unit_1173],	[unit_1173_help]	},	\
		{ 1174,	[unit_1174],	[unit_1174_help]	},	\
		{ 1175,	[unit_1175],	[unit_1175_help]	},	\
		{ 1176,	[unit_1176],	[unit_1176_help]	},	\
		{ 1177,	[unit_1177],	[unit_1177_help]	},	\
		{ 1178,	[unit_1178],	[unit_1178_help]	},	\
		{ 1179,	[unit_1179],	[unit_1179_help]	},	\
		{ 1180,	[unit_1180],	[unit_1180_help]	},	\
		{ 1181,	[unit_1181],	[unit_1181_help]	},	\
		{ 1182,	[unit_1182],	[unit_1182_help]	},	\
		{ 1183,	[unit_1183],	[unit_1183_help]	},	\
		{ 1184,	[unit_1184],	[unit_1184_help]	},	\
		{ 1185,	[unit_1185],	[unit_1185_help]	},	\
		{ 1186,	[unit_1186],	[unit_1186_help]	},	\
		{ 1187,	[unit_1187],	[unit_1187_help]	},	\
		{ 1188,	[unit_1188],	[unit_1188_help]	},	\
		{ 1189,	[unit_1189],	[unit_1189_help]	},	\
		{ 1190,	[unit_1190],	[unit_1190_help]	},	\
		{ 1191,	[unit_1191],	[unit_1191_help]	},	\
		{ 1192,	[unit_1192],	[unit_1192_help]	},	\
		{ 1193,	[unit_1193],	[unit_1193_help]	},	\
		{ 1194,	[unit_1194],	[unit_1194_help]	},	\
		{ 1195,	[unit_1195],	[unit_1195_help]	},	\
		{ 1196,	[unit_1196],	[unit_1196_help]	},	\
		{ 1197,	[unit_1197],	[unit_1197_help]	},	\
		{ 1198,	[unit_1198],	[unit_1198_help]	},	\
		{ 1199,	[unit_1199],	[unit_1199_help]	},	\
		{ 1200,	[unit_1200],	[unit_1200_help]	},	\
		{ 1201,	[unit_1201],	[unit_1201_help]	},	\
		{ 1202,	[unit_1202],	[unit_1202_help]	},	\
		{ 1203,	[unit_1203],	[unit_1203_help]	},	\
		{ 1204,	[unit_1204],	[unit_1204_help]	},	\
		{ 1205,	[unit_1205],	[unit_1205_help]	},	\
		{ 1206,	[unit_1206],	[unit_1206_help]	},	\
		{ 1207,	[unit_1207],	[unit_1207_help]	},	\
		{ 1208,	[unit_1208],	[unit_1208_help]	},	\
		{ 1209,	[unit_1209],	[unit_1209_help]	},	\
		{ 1210,	[unit_1210],	[unit_1210_help]	},	\
		{ 1211,	[unit_1211],	[unit_1211_help]	},	\
		{ 1212,	[unit_1212],	[unit_1212_help]	},	\
		{ 1213,	[unit_1213],	[unit_1213_help]	},	\
		{ 1214,	[unit_1214],	[unit_1214_help]	},	\
		{ 1215,	[unit_1215],	[unit_1215_help]	},	\
		{ 1216,	[unit_1216],	[unit_1216_help]	},	\
		{ 1217,	[unit_1217],	[unit_1217_help]	},	\
		{ 1218,	[unit_1218],	[unit_1218_help]	},	\
		{ 1219,	[unit_1219],	[unit_1219_help]	},	\
		{ 1220,	[unit_1220],	[unit_1220_help]	},	\
		{ 1221,	[unit_1221],	[unit_1221_help]	},	\
		{ 1222,	[unit_1222],	[unit_1222_help]	},	\
		{ 1223,	[unit_1223],	[unit_1223_help]	},	\
		{ 1224,	[unit_1224],	[unit_1224_help]	},	\
		{ 1225,	[unit_1225],	[unit_1225_help]	},	\
		{ 1226,	[unit_1226],	[unit_1226_help]	},	\
		{ 1227,	[unit_1227],	[unit_1227_help]	},	\
		{ 1228,	[unit_1228],	[unit_1228_help]	},	\
		{ 1229,	[unit_1229],	[unit_1229_help]	},	\
		{ 1230,	[unit_1230],	[unit_1230_help]	},	\
		{ 1231,	[unit_1231],	[unit_1231_help]	},	\
		{ 1232,	[unit_1232],	[unit_1232_help]	},	\
		{ 1233,	[unit_1233],	[unit_1233_help]	},	\
		{ 1234,	[unit_1234],	[unit_1234_help]	},	\
		{ 1235,	[unit_1235],	[unit_1235_help]	},	\
		{ 1236,	[unit_1236],	[unit_1236_help]	},	\
		{ 1237,	[unit_1237],	[unit_1237_help]	},	\
		{ 1238,	[unit_1238],	[unit_1238_help]	},	\
		{ 1239,	[unit_1239],	[unit_1239_help]	},	\
		{ 1240,	[unit_1240],	[unit_1240_help]	},	\
		{ 1241,	[unit_1241],	[unit_1241_help]	},	\
		{ 1242,	[unit_1242],	[unit_1242_help]	},	\
		{ 1243,	[unit_1243],	[unit_1243_help]	},	\
		{ 1244,	[unit_1244],	[unit_1244_help]	},	\
		{ 1245,	[unit_1245],	[unit_1245_help]	},	\
		{ 1246,	[unit_1246],	[unit_1246_help]	},	\
		{ 1247,	[unit_1247],	[unit_1247_help]	},	\
		{ 1248,	[unit_1248],	[unit_1248_help]	},	\
		{ 1249,	[unit_1249],	[unit_1249_help]	},	\
		{ 1250,	[unit_1250],	[unit_1250_help]	},	\
		{ 1251,	[unit_1251],	[unit_1251_help]	},	\
		{ 1252,	[unit_1252],	[unit_1252_help]	},	\
		{ 1253,	[unit_1253],	[unit_1253_help]	},	\
		{ 1254,	[unit_1254],	[unit_1254_help]	},	\
		{ 1255,	[unit_1255],	[unit_1255_help]	},	\
		{ 1256,	[unit_1256],	[unit_1256_help]	},	\
		{ 1257,	[unit_1257],	[unit_1257_help]	},	\
		{ 1258,	[unit_1258],	[unit_1258_help]	},	\
		{ 1259,	[unit_1259],	[unit_1259_help]	},	\
		{ 1260,	[unit_1260],	[unit_1260_help]	},	\
		{ 1261,	[unit_1261],	[unit_1261_help]	},	\
		{ 1262,	[unit_1262],	[unit_1262_help]	},	\
		{ 1263,	[unit_1263],	[unit_1263_help]	},	\
		{ 1264,	[unit_1264],	[unit_1264_help]	},	\
		{ 1265,	[unit_1265],	[unit_1265_help]	},	\
		{ 1266,	[unit_1266],	[unit_1266_help]	},	\
		{ 1267,	[unit_1267],	[unit_1267_help]	},	\
		{ 1268,	[unit_1268],	[unit_1268_help]	},	\
		{ 1269,	[unit_1269],	[unit_1269_help]	},	\
		{ 1270,	[unit_1270],	[unit_1270_help]	},	\
		{ 1271,	[unit_1271],	[unit_1271_help]	},	\
		{ 1272,	[unit_1272],	[unit_1272_help]	},	\
		{ 1273,	[unit_1273],	[unit_1273_help]	},	\
		{ 1274,	[unit_1274],	[unit_1274_help]	},	\
		{ 1275,	[unit_1275],	[unit_1275_help]	},	\
		{ 1276,	[unit_1276],	[unit_1276_help]	},	\
		{ 1277,	[unit_1277],	[unit_1277_help]	},	\
		{ 1278,	[unit_1278],	[unit_1278_help]	},	\
		{ 1279,	[unit_1279],	[unit_1279_help]	},	\
		{ 1280,	[unit_1280],	[unit_1280_help]	},	\
		{ 1281,	[unit_1281],	[unit_1281_help]	},	\
		{ 1282,	[unit_1282],	[unit_1282_help]	},	\
		{ 1283,	[unit_1283],	[unit_1283_help]	},	\
		{ 1284,	[unit_1284],	[unit_1284_help]	},	\
		{ 1285,	[unit_1285],	[unit_1285_help]	},	\
		{ 1286,	[unit_1286],	[unit_1286_help]	},	\
		{ 1287,	[unit_1287],	[unit_1287_help]	},	\
		{ 1288,	[unit_1288],	[unit_1288_help]	},	\
		{ 1289,	[unit_1289],	[unit_1289_help]	},	\
		{ 1290,	[unit_1290],	[unit_1290_help]	},	\
		{ 1291,	[unit_1291],	[unit_1291_help]	},	\
		{ 1292,	[unit_1292],	[unit_1292_help]	},	\
		{ 1293,	[unit_1293],	[unit_1293_help]	},	\
		{ 1294,	[unit_1294],	[unit_1294_help]	},	\
		{ 1295,	[unit_1295],	[unit_1295_help]	},	\
		{ 1296,	[unit_1296],	[unit_1296_help]	},	\
		{ 1297,	[unit_1297],	[unit_1297_help]	},	\
		{ 1298,	[unit_1298],	[unit_1298_help]	},	\
		{ 1299,	[unit_1299],	[unit_1299_help]	},	\
		{ 1300,	[unit_1300],	[unit_1300_help]	},	\
		{ 1301,	[unit_1301],	[unit_1301_help]	},	\
		{ 1302,	[unit_1302],	[unit_1302_help]	},	\
		{ 1303,	[unit_1303],	[unit_1303_help]	},	\
		{ 1304,	[unit_1304],	[unit_1304_help]	},	\
		{ 1305,	[unit_1305],	[unit_1305_help]	},	\
		{ 1306,	[unit_1306],	[unit_1306_help]	},	\
		{ 1307,	[unit_1307],	[unit_1307_help]	},	\
		{ 1308,	[unit_1308],	[unit_1308_help]	},	\
		{ 1309,	[unit_1309],	[unit_1309_help]	},	\
		{ 1310,	[unit_1310],	[unit_1310_help]	},	\
		{ 1311,	[unit_1311],	[unit_1311_help]	},	\
		{ 1312,	[unit_1312],	[unit_1312_help]	},	\
		{ 1313,	[unit_1313],	[unit_1313_help]	},	\
		{ 1314,	[unit_1314],	[unit_1314_help]	},	\
		{ 1315,	[unit_1315],	[unit_1315_help]	},	\
		{ 1316,	[unit_1316],	[unit_1316_help]	},	\
		{ 1317,	[unit_1317],	[unit_1317_help]	},	\
		{ 1318,	[unit_1318],	[unit_1318_help]	},	\
		{ 1319,	[unit_1319],	[unit_1319_help]	},	\
		{ 1320,	[unit_1320],	[unit_1320_help]	},	\
		{ 1321,	[unit_1321],	[unit_1321_help]	},	\
		{ 1322,	[unit_1322],	[unit_1322_help]	},	\
		{ 1323,	[unit_1323],	[unit_1323_help]	},	\
		{ 1324,	[unit_1324],	[unit_1324_help]	},	\
		{ 1325,	[unit_1325],	[unit_1325_help]	},	\
		{ 1326,	[unit_1326],	[unit_1326_help]	},	\
		{ 1327,	[unit_1327],	[unit_1327_help]	},	\
		{ 1328,	[unit_1328],	[unit_1328_help]	},	\
		{ 1329,	[unit_1329],	[unit_1329_help]	},	\
		{ 1330,	[unit_1330],	[unit_1330_help]	},	\
		{ 1331,	[unit_1331],	[unit_1331_help]	},	\
		{ 1332,	[unit_1332],	[unit_1332_help]	},	\
		{ 1333,	[unit_1333],	[unit_1333_help]	},	\
		{ 1334,	[unit_1334],	[unit_1334_help]	},	\
		{ 1335,	[unit_1335],	[unit_1335_help]	},	\
		{ 1336,	[unit_1336],	[unit_1336_help]	},	\
		{ 1337,	[unit_1337],	[unit_1337_help]	},	\
		{ 1338,	[unit_1338],	[unit_1338_help]	},	\
		{ 1339,	[unit_1339],	[unit_1339_help]	},	\
		{ 1340,	[unit_1340],	[unit_1340_help]	},	\
		{ 1341,	[unit_1341],	[unit_1341_help]	},	\
		{ 1342,	[unit_1342],	[unit_1342_help]	},	\
		{ 1343,	[unit_1343],	[unit_1343_help]	},	\
		{ 1344,	[unit_1344],	[unit_1344_help]	},	\
		{ 1345,	[unit_1345],	[unit_1345_help]	},	\
		{ 1346,	[unit_1346],	[unit_1346_help]	},	\
		{ 1347,	[unit_1347],	[unit_1347_help]	},	\
		{ 1348,	[unit_1348],	[unit_1348_help]	},	\
		{ 1349,	[unit_1349],	[unit_1349_help]	},	\
		{ 1350,	[unit_1350],	[unit_1350_help]	},	\
		{ 1351,	[unit_1351],	[unit_1351_help]	},	\
		{ 1352,	[unit_1352],	[unit_1352_help]	},	\
		{ 1353,	[unit_1353],	[unit_1353_help]	},	\
		{ 1354,	[unit_1354],	[unit_1354_help]	},	\
		{ 1355,	[unit_1355],	[unit_1355_help]	},	\
		{ 1356,	[unit_1356],	[unit_1356_help]	},	\
		{ 1357,	[unit_1357],	[unit_1357_help]	},	\
		{ 1358,	[unit_1358],	[unit_1358_help]	},	\
		{ 1359,	[unit_1359],	[unit_1359_help]	},	\
		{ 1360,	[unit_1360],	[unit_1360_help]	},	\
		{ 1361,	[unit_1361],	[unit_1361_help]	},	\
		{ 1362,	[unit_1362],	[unit_1362_help]	},	\
		{ 1363,	[unit_1363],	[unit_1363_help]	},	\
		{ 1364,	[unit_1364],	[unit_1364_help]	},	\
		{ 1365,	[unit_1365],	[unit_1365_help]	},	\
		{ 1366,	[unit_1366],	[unit_1366_help]	},	\
		{ 1367,	[unit_1367],	[unit_1367_help]	},	\
		{ 1368,	[unit_1368],	[unit_1368_help]	},	\
		{ 1369,	[unit_1369],	[unit_1369_help]	},	\
		{ 1370,	[unit_1370],	[unit_1370_help]	},	\
		{ 1371,	[unit_1371],	[unit_1371_help]	},	\
		{ 1372,	[unit_1372],	[unit_1372_help]	},	\
		{ 1373,	[unit_1373],	[unit_1373_help]	},	\
		{ 1374,	[unit_1374],	[unit_1374_help]	},	\
		{ 1375,	[unit_1375],	[unit_1375_help]	},	\
		{ 1376,	[unit_1376],	[unit_1376_help]	},	\
		{ 1377,	[unit_1377],	[unit_1377_help]	},	\
		{ 1378,	[unit_1378],	[unit_1378_help]	},	\
		{ 1379,	[unit_1379],	[unit_1379_help]	},	\
		{ 1380,	[unit_1380],	[unit_1380_help]	},	\
		{ 1381,	[unit_1381],	[unit_1381_help]	},	\
		{ 1382,	[unit_1382],	[unit_1382_help]	},	\
		{ 1383,	[unit_1383],	[unit_1383_help]	},	\
		{ 1384,	[unit_1384],	[unit_1384_help]	},	\
		{ 1385,	[unit_1385],	[unit_1385_help]	},	\
		{ 1386,	[unit_1386],	[unit_1386_help]	},	\
		{ 1387,	[unit_1387],	[unit_1387_help]	},	\
		{ 1388,	[unit_1388],	[unit_1388_help]	},	\
		{ 1389,	[unit_1389],	[unit_1389_help]	},	\
		{ 1390,	[unit_1390],	[unit_1390_help]	},	\
		{ 1391,	[unit_1391],	[unit_1391_help]	},	\
		{ 1392,	[unit_1392],	[unit_1392_help]	},	\
		{ 1393,	[unit_1393],	[unit_1393_help]	},	\
		{ 1394,	[unit_1394],	[unit_1394_help]	},	\
		{ 1395,	[unit_1395],	[unit_1395_help]	},	\
		{ 1396,	[unit_1396],	[unit_1396_help]	},	\
		{ 1397,	[unit_1397],	[unit_1397_help]	},	\
		{ 1398,	[unit_1398],	[unit_1398_help]	},	\
		{ 1399,	[unit_1399],	[unit_1399_help]	},	\
		{ 1400,	[unit_1400],	[unit_1400_help]	},	\
		{ 1401,	[unit_1401],	[unit_1401_help]	},	\
		{ 1402,	[unit_1402],	[unit_1402_help]	},	\
		{ 1403,	[unit_1403],	[unit_1403_help]	},	\
		{ 1404,	[unit_1404],	[unit_1404_help]	},	\
		{ 1405,	[unit_1405],	[unit_1405_help]	},	\
		{ 1406,	[unit_1406],	[unit_1406_help]	},	\
		{ 1407,	[unit_1407],	[unit_1407_help]	},	\
		{ 1408,	[unit_1408],	[unit_1408_help]	},	\
		{ 1409,	[unit_1409],	[unit_1409_help]	},	\
		{ 1410,	[unit_1410],	[unit_1410_help]	},	\
		{ 1411,	[unit_1411],	[unit_1411_help]	},	\
		{ 1412,	[unit_1412],	[unit_1412_help]	},	\
		{ 1413,	[unit_1413],	[unit_1413_help]	},	\
		{ 1414,	[unit_1414],	[unit_1414_help]	},	\
		{ 1415,	[unit_1415],	[unit_1415_help]	},	\
		{ 1416,	[unit_1416],	[unit_1416_help]	},	\
		{ 1417,	[unit_1417],	[unit_1417_help]	},	\
		{ 1418,	[unit_1418],	[unit_1418_help]	},	\
		{ 1419,	[unit_1419],	[unit_1419_help]	},	\
		{ 1420,	[unit_1420],	[unit_1420_help]	},	\
		{ 1421,	[unit_1421],	[unit_1421_help]	},	\
		{ 1422,	[unit_1422],	[unit_1422_help]	},	\
		{ 1423,	[unit_1423],	[unit_1423_help]	},	\
		{ 1424,	[unit_1424],	[unit_1424_help]	},	\
		{ 1425,	[unit_1425],	[unit_1425_help]	},	\
		{ 1426,	[unit_1426],	[unit_1426_help]	},	\
		{ 1427,	[unit_1427],	[unit_1427_help]	},	\
		{ 1428,	[unit_1428],	[unit_1428_help]	},	\
		{ 1429,	[unit_1429],	[unit_1429_help]	},	\
		{ 1430,	[unit_1430],	[unit_1430_help]	},	\
		{ 1431,	[unit_1431],	[unit_1431_help]	},	\
		{ 1432,	[unit_1432],	[unit_1432_help]	},	\
		{ 1433,	[unit_1433],	[unit_1433_help]	},	\
		{ 1434,	[unit_1434],	[unit_1434_help]	},	\
		{ 1435,	[unit_1435],	[unit_1435_help]	},	\
		{ 1436,	[unit_1436],	[unit_1436_help]	},	\
		{ 1437,	[unit_1437],	[unit_1437_help]	},	\
		{ 1438,	[unit_1438],	[unit_1438_help]	},	\
		{ 1439,	[unit_1439],	[unit_1439_help]	},	\
		{ 1440,	[unit_1440],	[unit_1440_help]	},	\
		{ 1441,	[unit_1441],	[unit_1441_help]	},	\
		{ 1442,	[unit_1442],	[unit_1442_help]	},	\
		{ 1443,	[unit_1443],	[unit_1443_help]	},	\
		{ 1444,	[unit_1444],	[unit_1444_help]	},	\
		{ 1445,	[unit_1445],	[unit_1445_help]	},	\
		{ 1446,	[unit_1446],	[unit_1446_help]	},	\
		{ 1447,	[unit_1447],	[unit_1447_help]	},	\
		{ 1448,	[unit_1448],	[unit_1448_help]	},	\
		{ 1449,	[unit_1449],	[unit_1449_help]	},	\
		{ 1450,	[unit_1450],	[unit_1450_help]	},	\
		{ 1451,	[unit_1451],	[unit_1451_help]	},	\
		{ 1452,	[unit_1452],	[unit_1452_help]	},	\
		{ 1453,	[unit_1453],	[unit_1453_help]	},	\
		{ 1454,	[unit_1454],	[unit_1454_help]	},	\
		{ 1455,	[unit_1455],	[unit_1455_help]	},	\
		{ 1456,	[unit_1456],	[unit_1456_help]	},	\
		{ 1457,	[unit_1457],	[unit_1457_help]	},	\
		{ 1458,	[unit_1458],	[unit_1458_help]	},	\
		{ 1459,	[unit_1459],	[unit_1459_help]	},	\
		{ 1460,	[unit_1460],	[unit_1460_help]	},	\
		{ 1461,	[unit_1461],	[unit_1461_help]	},	\
		{ 1462,	[unit_1462],	[unit_1462_help]	},	\
		{ 1463,	[unit_1463],	[unit_1463_help]	},	\
		{ 1464,	[unit_1464],	[unit_1464_help]	},	\
		{ 1465,	[unit_1465],	[unit_1465_help]	},	\
		{ 1466,	[unit_1466],	[unit_1466_help]	},	\
		{ 1467,	[unit_1467],	[unit_1467_help]	},	\
		{ 1468,	[unit_1468],	[unit_1468_help]	},	\
		{ 1469,	[unit_1469],	[unit_1469_help]	},	\
		{ 1470,	[unit_1470],	[unit_1470_help]	},	\
		{ 1471,	[unit_1471],	[unit_1471_help]	},	\
		{ 1472,	[unit_1472],	[unit_1472_help]	},	\
		{ 1473,	[unit_1473],	[unit_1473_help]	},	\
		{ 1474,	[unit_1474],	[unit_1474_help]	},	\
		{ 1475,	[unit_1475],	[unit_1475_help]	},	\
		{ 1476,	[unit_1476],	[unit_1476_help]	},	\
		{ 1477,	[unit_1477],	[unit_1477_help]	},	\
		{ 1478,	[unit_1478],	[unit_1478_help]	},	\
		{ 1479,	[unit_1479],	[unit_1479_help]	},	\
		{ 1480,	[unit_1480],	[unit_1480_help]	},	\
		{ 1481,	[unit_1481],	[unit_1481_help]	},	\
		{ 1482,	[unit_1482],	[unit_1482_help]	},	\
		{ 1483,	[unit_1483],	[unit_1483_help]	},	\
		{ 1484,	[unit_1484],	[unit_1484_help]	},	\
		{ 1485,	[unit_1485],	[unit_1485_help]	},	\
		{ 1486,	[unit_1486],	[unit_1486_help]	},	\
		{ 1487,	[unit_1487],	[unit_1487_help]	},	\
		{ 1488,	[unit_1488],	[unit_1488_help]	},	\
		{ 1489,	[unit_1489],	[unit_1489_help]	},	\
		{ 1490,	[unit_1490],	[unit_1490_help]	},	\
		{ 1491,	[unit_1491],	[unit_1491_help]	},	\
		{ 1492,	[unit_1492],	[unit_1492_help]	},	\
		{ 1493,	[unit_1493],	[unit_1493_help]	},	\
		{ 1494,	[unit_1494],	[unit_1494_help]	},	\
		{ 1495,	[unit_1495],	[unit_1495_help]	},	\
		{ 1496,	[unit_1496],	[unit_1496_help]	},	\
		{ 1497,	[unit_1497],	[unit_1497_help]	},	\
		{ 1498,	[unit_1498],	[unit_1498_help]	},	\
		{ 1499,	[unit_1499],	[unit_1499_help]	},	\
		{ 1500,	[unit_1500],	[unit_1500_help]	},	\
		{ 1501,	[unit_1501],	[unit_1501_help]	},	\
		{ 1502,	[unit_1502],	[unit_1502_help]	},	\
		{ 1504,	[unit_1504],	[unit_1504_help]	},	\
		{ 1504,	[unit_1504],	[unit_1504_help]	},	\
		{ 1505,	[unit_1505],	[unit_1505_help]	},	\
		{ 1506,	[unit_1506],	[unit_1506_help]	},	\
		{ 1507,	[unit_1507],	[unit_1507_help]	},	\
		{ 1508,	[unit_1508],	[unit_1508_help]	},	\
		{ 1509,	[unit_1509],	[unit_1509_help]	},	\
		{ 1510,	[unit_1510],	[unit_1510_help]	},	\
		{ 1511,	[unit_1511],	[unit_1511_help]	},	\
		{ 1512,	[unit_1512],	[unit_1512_help]	},	\
		{ 1514,	[unit_1514],	[unit_1514_help]	},	\
		{ 1514,	[unit_1514],	[unit_1514_help]	},	\
		{ 1515,	[unit_1515],	[unit_1515_help]	},	\
		{ 1516,	[unit_1516],	[unit_1516_help]	},	\
		{ 1517,	[unit_1517],	[unit_1517_help]	},	\
		{ 1518,	[unit_1518],	[unit_1518_help]	},	\
		{ 1519,	[unit_1519],	[unit_1519_help]	},	\
		{ 1520,	[unit_1520],	[unit_1520_help]	},	\
		{ 1997,	"None",	"No unit. There is no variable available from this instrument"	}	\
  }

#define	TAB_X_LABEL_0			"          x[0]"
#define	TAB_X_LABEL_1			"          x[1]"
#define	TAB_X_LABEL_2			"          x[2]"
#define	TAB_X_LABEL_3			"          x[3]"
#define	TAB_X_LABEL_4			"          x[4]"
#define	TAB_X_LABEL_5			"          x[5]"
#define	TAB_X_LABEL_6			"          x[6]"
#define	TAB_X_LABEL_7			"          x[7]"
#define	TAB_X_LABEL_8			"          x[8]"
#define	TAB_X_LABEL_9			"          x[9]"
#define	TAB_X_LABEL_10			"          x[10]"

#define	TAB_Y_LABEL_0			"User Set   0%"
#define	TAB_Y_LABEL_1			"User Set  10%"
#define	TAB_Y_LABEL_2			"User Set  20%"
#define	TAB_Y_LABEL_3			"User Set  30%"
#define	TAB_Y_LABEL_4			"User Set  40%"
#define	TAB_Y_LABEL_5			"User Set  50%"
#define	TAB_Y_LABEL_6			"User Set  60%"
#define	TAB_Y_LABEL_7			"User Set  70%"
#define	TAB_Y_LABEL_8			"User Set  80%"
#define	TAB_Y_LABEL_9			"User Set  90%"
#define	TAB_Y_LABEL_10			"User Set 100%"



MANUFACTURER	160,  
DEVICE_TYPE		1,  
DEVICE_REVISION  0x0001,
DD_REVISION		1

IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __PHYSICAL_ACTUATOR, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
{

   USE_PHYS_MANDATORY_A;
   USE_PHYS_OPTIONAL_A; 
 
   REDEFINITIONS
    {
	DELETE COLLECTION phys_FEATURE; 
	DELETE VARIABLE phys_FEATURE_Supported; 
//fbi	DELETE VARIABLE phys_FEATURE_Enabled; 
	DELETE MENU phys_FEATURE_page; 
	DELETE COMMAND phys_FEATURE_read; 
	DELETE VARIABLE phys_COND_STATUS_DIAG; 
	DELETE MENU phys_COND_STATUS_DIAG_page; 
	DELETE COMMAND phys_COND_STATUS_DIAG_read; 
	DELETE COMMAND phys_COND_STATUS_DIAG_write; 
//	DELETE MENU phys_Diagnosis_page;
//	DELETE MENU phys_DIAGNOSIS_page;


	
	
	
	VARIABLE phys_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "YT-3300";
		}
	}
	VARIABLE phys_SOFTWARE_REVISION
	{
		REDEFINE TYPE ASCII(16)
		{
			DEFAULT_VALUE "SW Rev 1.0";
		}
	}

	VARIABLE phys_HARDWARE_REVISION
	{
		REDEFINE TYPE ASCII(16)
		{
			DEFAULT_VALUE "HW Rev 1.0";
		}
	}
	VARIABLE phys_DEVICE_ID
	{
		REDEFINE TYPE ASCII(16)
		{
			DEFAULT_VALUE "YT-3300/YT-3400";	// As of 11 Sep 2019 YTC
		}
	}

	VARIABLE phys_DEVICE_SER_NUM
	{
		REDEFINE TYPE ASCII(16)
		{
			DEFAULT_VALUE "Dev serial no 1";
		}
	}
	VARIABLE phys_DEVICE_MAN_ID
	{
	      REDEFINE TYPE        ENUMERATED (2)
	      {
		    DEFAULT_VALUE     DEFAULT_MANUFACTURER_ID ;
		    { 1449, "Rotork YTC Limited" }
	      }
	}
	
        VARIABLE phys_ST_REV
        {
	      REDEFINE LABEL " Ph Block Static Rev";
	}

	VARIABLE phys_IDENT_NUMBER_SELECTOR
	{
		REDEFINE TYPE ENUMERATED(1)
		{
			DEFAULT_VALUE 0;
			{ 0, [PI_phys_IDENT_NUMBER_SELECTOR_enum_0] },
			{ 1, [PI_IDENT_NUMBER_SELECTOR_enum_1] }

		}
	}
        VARIABLE phys_DIAGNOSIS
        {
//            REDEFINE STYLE "MULTILINE 12 21" ;   //hla 26.03.19
	    REDEFINE TYPE BIT_ENUMERATED(4)
	    {
		{ 0, [PI_phys_DIAGNOSIS_enum_0], [PI_empty] },
		{ 0x00080000, [PI_DIAGNOSIS_enum_DIA_WARMSTART], [PI_empty] },
		{ 0x00100000, [PI_DIAGNOSIS_enum_DIA_COLDSTART], [PI_empty] },
		{ 0x00200000, [PI_DIAGNOSIS_enum_DIA_MAINTENANCE], [PI_empty] },
		{ 0x00800000, [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL], [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL_help] },
		{ 0x00000100, [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE], [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE_help] },
		{ 0x00000200, [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM], [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM] },
		{ 0x00000400, [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK], [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK_help] },
		{ 0x00000800, [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND], [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND_help] },
		{ 0x00000080, [PI_DIAGNOSIS_enum_EXTENSION_AVAILABLE], [PI_empty] }
	    }	
	}
        COMMAND phys_DIAGNOSIS_EXTENSION_read
       {
            REDEFINE TRANSACTION
              {
		REQUEST
		{
		}
		REPLY
		{
		    device_specific_status_0, 		
		    device_specific_status_1,
	            device_specific_status_2,
	            ne107_mask_dummy,			
	            ne107_mask_dummy,
	            ne107_mask_dummy
		}
	      }
        } 	
        VARIABLE phys_WRITE_LOCKING
        {
	     REDEFINE TYPE ENUMERATED(2)
	    {
		DEFAULT_VALUE 2457;
//		{ 17185, "Factory mode" }, 		    
		{ 2037, "Factory access" },   
		{ 2457, "Unlock" },
		{ 0,    "Lock" }
	    }
        }
	MENU phys_WRITE_LOCKING_page
       {
	     REDEFINE LABEL "Write Lock";
        }	
	COLLECTION phys_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, phys_ALARM_SUM_Current;
//			Unacknowledged, phys_ALARM_SUM_Unacknowledged;
//			Unreported, phys_ALARM_SUM_Unreported;
//			Disabled, phys_ALARM_SUM_Disabled;
		}
	}
	MENU phys_Simple_Dialog_Mandatory_A
	{
		REDEFINE LABEL    "Physical Block - Device";
		REDEFINE ITEMS
		{
			phys_BLOCK_OBJECT_page,
//			phys_ST_REV_page,
//			phys_TAG_DESC_page,
//			phys_STRATEGY_page,
//			phys_ALERT_KEY_page,
//			phys_TARGET_MODE_page,
//			phys_MODE_BLK_page,
//			phys_ALARM_SUM_page,
//			phys_SOFTWARE_REVISION_page,
//			phys_DEVICE_MAN_ID_page,
//			phys_DEVICE_ID_page,
//			phys_DEVICE_SER_NUM_page,
			phys_DIAGNOSIS_MASK_page 

		}
	}

	MENU phys_Simple_Dialog_Optional_A
	{
		REDEFINE LABEL    "Physical Block - Device";
		REDEFINE ITEMS
		{
			phys_BLOCK_OBJECT_page,
//			phys_TAG_DESC_page,
//			phys_ALERT_KEY_page,
//			phys_TARGET_MODE_page,
//			phys_MODE_BLK_page,
			phys_ALARM_SUM_page,
//			phys_SOFTWARE_REVISION_page,
//			phys_HARDWARE_REVISION_page,
//			phys_DEVICE_MAN_ID_page,
//			phys_DEVICE_ID_page,
//			phys_DEVICE_SER_NUM_page,
//			phys_DIAGNOSIS_EXTENSION_page,
//			phys_DIAGNOSIS_MASK_page,
//			phys_DIAGNOSIS_MASK_EXTENSION_page,
//			phys_DEVICE_CERTIFICATION_page,
			phys_WRITE_LOCKING_page,
//			phys_FACTORY_RESET_page,
//			phys_DESCRIPTOR_page,
//			phys_DEVICE_MESSAGE_page,
//			phys_DEVICE_INSTAL_DATE_page,
//			phys_LOCAL_OP_ENA_page,
			phys_IDENT_NUMBER_SELECTOR_page,
//			phys_HW_WRITE_PROTECTION_page,
			phys_VIEW_1_page_krohne
		}
	}
	
	MENU phys_Reset_page
	{
		REDEFINE ITEMS
		{
			phys_DIAGNOSIS,
			ROWBREAK,
			phys_method_factory_reset_params,
			phys_method_factory_reset_warm,
			phys_method_factory_reset_address
//			phys_method_factory_reset_device_specific
		}
	}
	VARIABLE phys_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE phys_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}
	
    }
  
 
 }
IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_AO, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
{
      USE_FUNC1_AO_MANDATORY_B;
      VARIABLE func1_AO_SETP_DEVIATION;
   REDEFINITIONS       
    {  


	 VARIABLE func1_AO_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "AO";
		}
	}
        VARIABLE func1_AO_TARGET_MODE
        {
	     REDEFINE LABEL " AO FB Target Mode";
	     REDEFINE TYPE ENUMERATED(1)
	     {
		{ 0x02, [PI_mode_RCAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
//		{ 0x20, [PI_mode_LO] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	     }
        }
        VARIABLE func1_AO_MODE_BLK_Actual
        {
	      REDEFINE LABEL "AO FB Actual Mode";
        }
        VARIABLE func1_AO_READBACK_Value
       {
              REDEFINE CONSTANT_UNIT "%";  
	       REDEFINE TYPE FLOAT
	             {
		        DISPLAY_FORMAT  ".1f";
                     }
        }
        VARIABLE func1_AO_SP_Value
        {
            REDEFINE CONSTANT_UNIT "%";  // As of 11 Sep 2019 YTC
	      REDEFINE TYPE FLOAT
	      {
		        DISPLAY_FORMAT  ".1f";	
              }
        }

        VARIABLE func1_AO_SIMULATE_Value    // As of 11 Sep 2019 YTC
        {
            REDEFINE CONSTANT_UNIT "%";  
        }

        VARIABLE func1_AO_CHECK_BACK
       {
      	        REDEFINE TYPE BIT_ENUMERATED(3)
		{

//		        CB_LOCAL_OP ,      /* Bit  2 */
//                       CB_DISC_DIR ,      /* Bit  4 */
//                       CB_UPDATE_EVT,     /* Bit 10 */
//                       CB_SIMULATE ,      /* Bit 11 */
//                       CB_CONTR_INACT ,   /* Bit 14 */
//                       CB_TOT_VALVE_TRAV  /* Bit 16 */
			{ 0x00040000, "Device under local control", [PI_CHECK_BACK_enum_0] },
			{ 0x00100000, "Deviation > 10%", [PI_CHECK_BACK_enum_0] },	
			{ 0x00000400, "Configuration change", [PI_CHECK_BACK_enum_0] },
			{ 0x00000800, "Simulation active", [PI_CHECK_BACK_enum_0] },	
			{ 0x00004000, "Control inactive", [PI_CHECK_BACK_enum_0] },
			{ 0x00000001, "Travel limit exceeded", [PI_CHECK_BACK_enum_0] }			
		}
	}
       VARIABLE func1_AO_PV_SCALE_Upper_Value
        {
	REDEFINE TYPE FLOAT
          {
		DEFAULT_VALUE 60000.0;
	  }
        }	

        VARIABLE func1_AO_MODE_BLK_Permitted
        {
            REDEFINE STYLE "MULTILINE 07 08" ;
	}	


       VARIABLE 	func1_AO_PV_SCALE_Lower_Value
	  {
		DELETE CONSTANT_UNIT;
          }
       VARIABLE 	func1_AO_PV_SCALE_Upper_Value
	  {
		DELETE CONSTANT_UNIT;
          }

        MENU func1_AO_MODE_BLK_page
       {
	         REDEFINE PRE_EDIT_ACTIONS  pre_read_mode_blk
        }  
        MENU func1_AO_ALARM_SUM_page
        {
	         REDEFINE PRE_EDIT_ACTIONS  pre_read_mode_blk
        }	

	MENU func1_AO_Simple_Dialog_Mandatory_B
	{
		REDEFINE LABEL    "Analog Out";
		REDEFINE ITEMS
		{
		func1_AO_BLOCK_OBJECT_page,
		func1_AO_ST_REV_page,
		func1_AO_TAG_DESC_page,
//		func1_AO_STRATEGY_page,
//		func1_AO_ALERT_KEY_page,
		func1_AO_TARGET_MODE_page,
		func1_AO_MODE_BLK_page,
		func1_AO_ALARM_SUM_page,
//		func1_AO_BATCH_page,
		func1_AO_SP_page,
//		func1_AO_PV_SCALE_page,
		func1_AO_READBACK_page,
//		func1_AO_FSAFE_TIME_page,
//		func1_AO_FSAFE_TYPE_page,
//		func1_AO_FSAFE_VALUE_page,
//		func1_AO_RCAS_OUT_page,
		func1_AO_POS_D_page,
//		func1_AO_SETP_DEVIATION_page,
		func1_AO_CHECK_BACK_page,
		func1_AO_CHECK_BACK_MASK_page,
//		func1_AO_SIMULATE_page,
//		func1_AO_INCREASE_CLOSE_page,
		func1_AO_OUT_page,
//		func1_AO_OUT_SCALE_page,
		func1_AO_VIEW_1_page
		}
	}
	COLLECTION func1_AO_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, func1_AO_ALARM_SUM_Current;
//			Unacknowledged, func1_AO_ALARM_SUM_Unacknowledged;
//			Unreported, func1_AO_ALARM_SUM_Unreported;
//			Disabled, func1_AO_ALARM_SUM_Disabled;
		}
	}
	VARIABLE func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}	
     }
  }

IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_AI, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
{
      USE_FUNC1_AI_MANDATORY_B;


   REDEFINITIONS       
    {  
       BLOCK func1_AI_block
       {
	     REDEFINE NUMBER 2;
        }	
	    VARIABLE func1_AI_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "Position Readback";
		}
	}
        VARIABLE func1_AI_ST_REV
        {
	      REDEFINE LABEL " AI Block Static Rev";
	}	
       VARIABLE func1_AI_OUT_SCALE_Upper_Value
        {
	REDEFINE TYPE FLOAT
          {
		DEFAULT_VALUE 100.0;
	  }
        }
       VARIABLE func1_AI_PV_SCALE_Upper_Value
        {
	REDEFINE TYPE FLOAT
          {
		DEFAULT_VALUE 60000.0;
	  }
        }	
	VARIABLE func1_AI_HI_HI_LIM
	{
		REDEFINE TYPE FLOAT
		{
			DEFAULT_VALUE 60000.0;
		}
	}

	VARIABLE func1_AI_LO_LIM
	{
		REDEFINE TYPE FLOAT
		{
			DEFAULT_VALUE 0.0;
		}
	}
	VARIABLE func1_AI_LO_LO_LIM
	{
		REDEFINE TYPE FLOAT
		{
			DEFAULT_VALUE 0.0;
		}
	}

	VARIABLE func1_AI_HI_LIM
	{
		REDEFINE TYPE FLOAT
		{
			DEFAULT_VALUE 60000.0;
		}
	}
        VARIABLE func1_AI_MODE_BLK_Permitted
        {
            REDEFINE STYLE "MULTILINE 07 08" ;
	}	
        VARIABLE func1_AI_ALARM_SUM_Current
        {
            REDEFINE STYLE "MULTILINE 07 05" ;
	}
	VARIABLE func1_AI_CHANNEL
	{
	    REDEFINE HANDLING READ;	    
	    REDEFINE TYPE ENUMERATED(2)
	    {
		{ 0x10b, "Ch1" }

	    }
	}	
     MENU func1_AI_Simulation
     {
       REDEFINE LABEL    "Position Readback";
     }
     MENU func1_AI_Tab_s_mandatory_B
          {
                REDEFINE LABEL    "Position Readback";
          }     
      MENU func1_AI_Tab_m_mandatory_B
          {
                REDEFINE LABEL    "Position Readback";
          }   
       VARIABLE 	func1_AI_PV_SCALE_Lower_Value
	  {
		DELETE CONSTANT_UNIT;
          }
       VARIABLE 	func1_AI_PV_SCALE_Upper_Value
	  {
		DELETE CONSTANT_UNIT;
          }

         AXIS func1_AI_Display_BarVal_out_axis_mandatory_B
         {
              REDEFINE MIN_VALUE func1_AI_OUT_SCALE_Lower_Value;
              REDEFINE MAX_VALUE func1_AI_OUT_SCALE_Upper_Value;
         }
	
	 MENU func1_AI_Tab_s_mandatory_B
	{
	 REDEFINE ITEMS
		{
			func1_AI_ST_REV,
			func1_AI_TAG_DESC,
//			func1_AI_STRATEGY, 
//			func1_AI_ALERT_KEY, 
//			func1_AI_BATCH_Batch_ID,
//			func1_AI_BATCH_Rup,                  
//			func1_AI_BATCH_Operation,            
//			func1_AI_BATCH_Phase,			
//			func1_AI_CHANNEL,
//			func1_AI_OUT_SCALE_Units_Index,			
//			func1_AI_PV_FTIME,
//			func1_AI_Tab_s_pv_range_mandatory_B,
//			func1_AI_Tab_s_outscale_mandatory_B,
			func1_AI_Tab_s_limits_mandatory_B
//			func1_AI_Tab_s_interface_mandatory_B
		}
       }
        MENU func1_AI_MODE_BLK_page
       {
	         REDEFINE PRE_EDIT_ACTIONS  pre_read_mode_blk
        }  
        MENU func1_AI_ALARM_SUM_page
        {
	         REDEFINE PRE_EDIT_ACTIONS  pre_read_mode_blk
        }	
	 MENU func1_AI_Tab_m_mandatory_B
	{
	 REDEFINE ITEMS
		{
		func1_AI_ST_REV,
		func1_AI_TAG_DESC (READ_ONLY),
//		func1_AI_CHANNEL (READ_ONLY),
//		func1_AI_OUT_SCALE_Units_Index (READ_ONLY),
//		func1_AI_PV_FTIME (READ_ONLY),
//		func1_AI_Tab_m_pv_range_mandatory_B,
//		func1_AI_Tab_m_outscale_mandatory_B,
		func1_AI_Tab_m_limits_mandatory_B
//		func1_AI_Tab_s_interface_mandatory_B
		}
       }
       MENU func1_AI_Display_mandatory_B
       {
	 REDEFINE LABEL "Analog Input - Position";
	 REDEFINE ACCESS ONLINE; 
	 REDEFINE ITEMS
	{
		func1_AI_TAG_DESC (READ_ONLY),
		func1_AI_Display_BarVal_out_mandatory_B,
		func1_AI_Display_out_mandatory_B
	}
        }
	MENU func1_AI_Display_in_mandatory_B
	{
	REDEFINE ITEMS
		{
			func1_AI_SIMULATE_Enabled (READ_ONLY)
		}
	}
	MENU func1_AI_Simple_Dialog_Mandatory_B
	{
		REDEFINE LABEL    "Analig In - Position";
		REDEFINE ITEMS
		{
			func1_AI_BLOCK_OBJECT_page,
			func1_AI_TAG_DESC_page,
//			func1_AI_STRATEGY_page,
//			func1_AI_ALERT_KEY_page,
			func1_AI_TARGET_MODE_page,
			func1_AI_MODE_BLK_page,
			func1_AI_ALARM_SUM_page,
//			func1_AI_BATCH_page,
			func1_AI_ALARM_page,
			func1_AI_VIEW_1_page_krohne
		}
	}	
	COLLECTION func1_AI_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, func1_AI_ALARM_SUM_Current;
//			Unacknowledged, func1_AI_ALARM_SUM_Unacknowledged;
//			Unreported, func1_AI_ALARM_SUM_Unreported;
//			Disabled, func1_AI_ALARM_SUM_Disabled;
		}
	}
	VARIABLE func1_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE func1_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}	
     }
  }



      IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_DI, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
 {
  
      USE_FUNC1_DI_MANDATORY_B;


     REDEFINITIONS
     {
       BLOCK func1_DI_block
       {
	     REDEFINE NUMBER 6;
        }	     
	VARIABLE func1_DI_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "DI1";
		}
	}
	VARIABLE func1_DI_ALARM_SUM_Current
        {
            REDEFINE STYLE "MULTILINE 07 05" ;
	}
        VARIABLE func1_DI_MODE_BLK_Permitted
        {
            REDEFINE STYLE "MULTILINE 07 08" ;
	}	
	MENU func1_DI_SIMULATE_page
	     {
	       REDEFINE LABEL    "DI1";
	     }
    
		 
/*	  MENU func1_DI_Tab_s_mandatory_B
	  {
	        REDEFINE ITEMS
		{
			func1_DI_ST_REV,
			func1_DI_TAG_DESC,
			func1_DI_STRATEGY,
			func1_DI_ALERT_KEY,
			func1_DI_BATCH_Batch_ID,
			func1_DI_BATCH_Rup,                  
			func1_DI_BATCH_Operation,            
			func1_DI_BATCH_Phase,
			func1_DI_CHANNEL,
			func1_DI_OUT_SCALE_Units_Index,			
			func1_DI_PV_FTIME,
			func1_DI_Tab_s_pv_range_mandatory_B,
			func1_DI_Tab_s_outscale_mandatory_B,
			func1_DI_Tab_s_limits_mandatory_B
			func1_DI_Tab_s_interface_mandatory_B
		}
         }
	    MENU func1_DI_Tab_m_mandatory_B
	{
	 REDEFINE ITEMS
		{
		func1_DI_ST_REV,
		func1_DI_TAG_DESC (READ_ONLY),
		func1_DI_CHANNEL (READ_ONLY),
		func1_DI_OUT_SCALE_Units_Index (READ_ONLY),
		func1_DI_PV_FTIME (READ_ONLY),
		func1_DI_Tab_m_pv_range_mandatory_B,
		func1_DI_Tab_m_outscale_mandatory_B,
		func1_DI_Tab_m_limits_mandatory_B,
		func1_DI_Tab_s_interface_mandatory_B
		}
       }*/

	MENU func1_DI_Simple_Dialog_Mandatory_B
	{
		REDEFINE LABEL "Digital Input 1";
		REDEFINE ITEMS
		{
			func1_DI_BLOCK_OBJECT_page,
			func1_DI_ST_REV_page,
			func1_DI_TAG_DESC_page,
//			func1_DI_STRATEGY_page,
//			func1_DI_ALERT_KEY_page,
			func1_DI_TARGET_MODE_page,
			func1_DI_MODE_BLK_page,
			func1_DI_ALARM_SUM_page,
//			func1_DI_BATCH_page,
			func1_DI_OUT_D_page,
//			func1_DI_CHANNEL_page,
			func1_DI_INVERT_page,
//			func1_DI_FSAFE_TYPE_page,
			func1_DI_FSAFE_VAL_D_page,
			func1_DI_SIMULATE_page,
			func1_DI_VIEW_1_page
		}
	}	
	COLLECTION func1_DI_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, func1_DI_ALARM_SUM_Current;
//			Unacknowledged, func1_AI_ALARM_SUM_Unacknowledged;
//			Unreported, func1_AI_ALARM_SUM_Unreported;
//			Disabled, func1_AI_ALARM_SUM_Disabled;
		}
	}
	VARIABLE func1_DI_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE func1_DI_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}	
     }
  }
      IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC2_DI, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
 {
  
      USE_FUNC2_DI_MANDATORY_B;


     REDEFINITIONS
     {
       BLOCK func2_DI_block
       {
	     REDEFINE NUMBER 7;
        }	
	 VARIABLE func2_DI_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "DI2";
		}
	}
	        VARIABLE func2_DI_ALARM_SUM_Current
        {
            REDEFINE STYLE "MULTILINE 07 05" ;
	}
        VARIABLE func2_DI_MODE_BLK_Permitted
        {
            REDEFINE STYLE "MULTILINE 07 08" ;
	}			 


	MENU func2_DI_Simple_Dialog_Mandatory_B
	{
		REDEFINE LABEL "Digital Input 2";
		REDEFINE ITEMS
		{
			func2_DI_BLOCK_OBJECT_page,
			func2_DI_ST_REV_page,
			func2_DI_TAG_DESC_page,
//			func2_DI_STRATEGY_page,
//			func2_DI_ALERT_KEY_page,
			func2_DI_TARGET_MODE_page,
			func2_DI_MODE_BLK_page,
			func2_DI_ALARM_SUM_page,
//			func1_DI_BATCH_page,
			func2_DI_OUT_D_page,
//			func1_DI_CHANNEL_page,
			func2_DI_INVERT_page,
//			func1_DI_FSAFE_TYPE_page,
			func2_DI_FSAFE_VAL_D_page,
			func2_DI_SIMULATE_page,
			func2_DI_VIEW_1_page
		}
	}
	COLLECTION func2_DI_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, func2_DI_ALARM_SUM_Current;
//			Unacknowledged, func1_AI_ALARM_SUM_Unacknowledged;
//			Unreported, func1_AI_ALARM_SUM_Unreported;
//			Disabled, func1_AI_ALARM_SUM_Disabled;
		}
	}
	VARIABLE func2_DI_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE func2_DI_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}	
     }
  }
      IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC3_DI, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
 {
  
      USE_FUNC3_DI_MANDATORY_B;


     REDEFINITIONS
     {
       BLOCK func3_DI_block
       {
	     REDEFINE NUMBER 8;
        }	
	 VARIABLE func3_DI_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "DI2";
		}
	}
	        VARIABLE func3_DI_ALARM_SUM_Current
        {
            REDEFINE STYLE "MULTILINE 07 05" ;
	}
        VARIABLE func3_DI_MODE_BLK_Permitted
        {
            REDEFINE STYLE "MULTILINE 07 08" ;
	}			 


	MENU func3_DI_Simple_Dialog_Mandatory_B
	{
		REDEFINE LABEL "Digital Input 3";
		REDEFINE ITEMS
		{
			func3_DI_BLOCK_OBJECT_page,
			func3_DI_ST_REV_page,
			func3_DI_TAG_DESC_page,
//			func3_DI_STRATEGY_page,
//			func3_DI_ALERT_KEY_page,
			func3_DI_TARGET_MODE_page,
			func3_DI_MODE_BLK_page,
			func3_DI_ALARM_SUM_page,
//			func1_DI_BATCH_page,
			func3_DI_OUT_D_page,
//			func1_DI_CHANNEL_page,
			func3_DI_INVERT_page,
//			func1_DI_FSAFE_TYPE_page,
			func3_DI_FSAFE_VAL_D_page,
			func3_DI_SIMULATE_page,
			func3_DI_VIEW_1_page
		}
	}
	COLLECTION func3_DI_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, func3_DI_ALARM_SUM_Current;
//			Unacknowledged, func1_AI_ALARM_SUM_Unacknowledged;
//			Unreported, func1_AI_ALARM_SUM_Unreported;
//			Disabled, func1_AI_ALARM_SUM_Disabled;
		}
	}
	VARIABLE func3_DI_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE func3_DI_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}	
     }
  }

      IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_DO, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
 {
  
      USE_FUNC1_DO_MANDATORY_A;
      USE_FUNC1_DO_OPTIONAL_A;

     REDEFINITIONS
     {
	DELETE VARIABLE func1_DO_FSAFE_TIME; 
	DELETE MENU func1_DO_FSAFE_TIME_page; 
	DELETE COMMAND func1_DO_FSAFE_TIME_read; 
	DELETE COMMAND func1_DO_FSAFE_TIME_write; 
	DELETE VARIABLE func1_DO_FSAFE_TYPE; 
	DELETE MENU func1_DO_FSAFE_TYPE_page; 
	DELETE COMMAND func1_DO_FSAFE_TYPE_read; 
	DELETE COMMAND func1_DO_FSAFE_TYPE_write; 
	DELETE VARIABLE func1_DO_FSAFE_VAL_D; 
	DELETE MENU func1_DO_FSAFE_VAL_D_page; 
	DELETE COMMAND func1_DO_FSAFE_VAL_D_read; 
	DELETE COMMAND func1_DO_FSAFE_VAL_D_write; 
	DELETE COLLECTION func1_DO_VIEW_1; 
	DELETE MENU func1_DO_VIEW_1_page; 
	DELETE MENU func1_DO_Simple_Dialog_Optional_A;
	
	
       BLOCK func1_DO_block
       {
	     REDEFINE NUMBER 3;
        }	
	 VARIABLE func1_DO_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "DO1";
		}
	}
	        VARIABLE func1_DO_ALARM_SUM_Current
        {
            REDEFINE STYLE "MULTILINE 07 05" ;
	}
        VARIABLE func1_DO_MODE_BLK_Permitted
        {
            REDEFINE STYLE "MULTILINE 07 08" ;
	}
        VARIABLE func1_DO_TARGET_MODE
       {
           REDEFINE POST_WRITE_ACTIONS {mode_method}
	   REDEFINE LABEL "DO FB Target Mode";              // As of 11 Sep 2019 YTC
	   REDEFINE TYPE ENUMERATED(1)
	   {
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	  }
        }	
        VARIABLE func1_DO_CHECK_BACK
       {
		REDEFINE TYPE BIT_ENUMERATED(3)
		{
			{ 0x00040000, "Device under local control", [PI_CHECK_BACK_enum_0] },
			{ 0x00100000, "Deviation > 10%", [PI_CHECK_BACK_enum_0] },	
			{ 0x00000400, "Configuration change", [PI_CHECK_BACK_enum_0] },
			{ 0x00000800, "Simulation active", [PI_CHECK_BACK_enum_0] },	
			{ 0x00004000, "Control inactive", [PI_CHECK_BACK_enum_0] },
			{ 0x00000001, "Travel limit exceeded", [PI_CHECK_BACK_enum_0] }				
		}
	}


	COLLECTION func1_DO_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, func1_DO_ALARM_SUM_Current;
//			Unacknowledged, func1_AI_ALARM_SUM_Unacknowledged;
//			Unreported, func1_AI_ALARM_SUM_Unreported;
//			Disabled, func1_AI_ALARM_SUM_Disabled;
		}
	}
	VARIABLE func1_DO_SP_D_Value
	{
		REDEFINE LABEL "Setpoint";
	}
	VARIABLE func1_DO_OUT_D_Status_Quality
	{
	   REDEFINE HANDLING IF ((func1_DO_MODE_BLK_Actual == 0x10) || (func1_DO_MODE_BLK_Actual == 0x08)) { READ & WRITE; } ELSE { READ; }
        }
        VARIABLE func1_DO_OUT_D_Status_Limit
       {
	   REDEFINE HANDLING IF ((func1_DO_MODE_BLK_Actual == 0x10) || (func1_DO_MODE_BLK_Actual == 0x08)) { READ & WRITE; } ELSE { READ; }
        }	
	VARIABLE func1_DO_OUT_D_Value
	{
		REDEFINE LABEL "Output Value";
	}	
	VARIABLE func1_DO_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE func1_DO_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}
        MENU func1_DO_Simple_Dialog_Mandatory_A
        {
		REDEFINE LABEL "Digital Out - Open";
	        REDEFINE ITEMS
	        {
			func1_DO_BLOCK_OBJECT_page,
			func1_DO_ST_REV_page,
			func1_DO_TAG_DESC_page,
//			func1_DO_STRATEGY_page,
//			func1_DO_ALERT_KEY_page,
			func1_DO_TARGET_MODE_page,
			func1_DO_MODE_BLK_page,
			func1_DO_ALARM_SUM_page,
//			func1_DO_BATCH_page,
			func1_DO_SP_D_page,
			func1_DO_INVERT_page,
			func1_DO_CHECK_BACK_page,
			func1_DO_CHECK_BACK_MASK_page
	        }
        }	
     }
  }
      IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC2_DO, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
 {
  
      USE_FUNC2_DO_MANDATORY_A;
      USE_FUNC2_DO_OPTIONAL_A;

     REDEFINITIONS
     {
	DELETE VARIABLE func2_DO_FSAFE_TIME; 
	DELETE MENU func2_DO_FSAFE_TIME_page; 
	DELETE COMMAND func2_DO_FSAFE_TIME_read; 
	DELETE COMMAND func2_DO_FSAFE_TIME_write; 
	DELETE VARIABLE func2_DO_FSAFE_TYPE; 
	DELETE MENU func2_DO_FSAFE_TYPE_page; 
	DELETE COMMAND func2_DO_FSAFE_TYPE_read; 
	DELETE COMMAND func2_DO_FSAFE_TYPE_write; 
	DELETE VARIABLE func2_DO_FSAFE_VAL_D; 
	DELETE MENU func2_DO_FSAFE_VAL_D_page; 
	DELETE COMMAND func2_DO_FSAFE_VAL_D_read; 
	DELETE COMMAND func2_DO_FSAFE_VAL_D_write; 
	DELETE COLLECTION func2_DO_VIEW_1; 
	DELETE MENU func2_DO_VIEW_1_page; 
	DELETE MENU func2_DO_Simple_Dialog_Optional_A;

       BLOCK func2_DO_block
       {
	     REDEFINE NUMBER 4;
        }	
	 VARIABLE func2_DO_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "DO1";
		}
	}
	        VARIABLE func2_DO_ALARM_SUM_Current
        {
            REDEFINE STYLE "MULTILINE 07 05" ;
	}
        VARIABLE func2_DO_MODE_BLK_Permitted
        {
            REDEFINE STYLE "MULTILINE 07 08" ;
	}			 
        VARIABLE func2_DO_CHECK_BACK
       {
		REDEFINE TYPE BIT_ENUMERATED(3)
		{
			{ 0x000004, "Device under local control", [PI_CHECK_BACK_enum_0] },
			{ 0x000010, "Deviation > 10%", [PI_CHECK_BACK_enum_0] },	
			{ 0x004000, "Configuration change", [PI_CHECK_BACK_enum_0] },
			{ 0x008000, "Simulation active", [PI_CHECK_BACK_enum_0] },	
			{ 0x040000, "Device failure", [PI_CHECK_BACK_enum_0] },
			{ 0x100000, "Travel limit exceeded", [PI_CHECK_BACK_enum_0] }			
		}
	}

	COLLECTION func2_DO_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, func2_DO_ALARM_SUM_Current;
//			Unacknowledged, func1_AI_ALARM_SUM_Unacknowledged;
//			Unreported, func1_AI_ALARM_SUM_Unreported;
//			Disabled, func1_AI_ALARM_SUM_Disabled;
		}
	}
	VARIABLE func2_DO_SP_D_Value
	{
		REDEFINE LABEL "Setpoint";
	}
	VARIABLE func2_DO_OUT_D_Status_Quality
	{
	   REDEFINE HANDLING IF ((func2_DO_MODE_BLK_Actual == 0x10) || (func2_DO_MODE_BLK_Actual == 0x08)) { READ & WRITE; } ELSE { READ; }
        }
        VARIABLE func2_DO_OUT_D_Status_Limit
       {
	   REDEFINE HANDLING IF ((func2_DO_MODE_BLK_Actual == 0x10) || (func2_DO_MODE_BLK_Actual == 0x08)) { READ & WRITE; } ELSE { READ; }
        }	
	VARIABLE func2_DO_OUT_D_Value
	{
		REDEFINE LABEL "Output Value";
	}	
	VARIABLE func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}
        MENU func2_DO_Simple_Dialog_Mandatory_A
        {
		REDEFINE LABEL "Digital Out 2 - Close";
	        REDEFINE ITEMS
	        {
			func2_DO_BLOCK_OBJECT_page,
			func2_DO_ST_REV_page,
			func2_DO_TAG_DESC_page,
//			func2_DO_STRATEGY_page,
//			func2_DO_ALERT_KEY_page,
			func2_DO_TARGET_MODE_page,
			func2_DO_MODE_BLK_page,
			func2_DO_ALARM_SUM_page,
//			func2_DO_BATCH_page,
			func2_DO_SP_D_page,
			func2_DO_INVERT_page,
			func2_DO_CHECK_BACK_page,
			func2_DO_CHECK_BACK_MASK_page
	        }
        }		
     }
  } 
      IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC3_DO, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
 {
  
      USE_FUNC3_DO_MANDATORY_A;
      USE_FUNC3_DO_OPTIONAL_A;

     REDEFINITIONS
     {
	DELETE VARIABLE func3_DO_FSAFE_TIME; 
	DELETE MENU func3_DO_FSAFE_TIME_page; 
	DELETE COMMAND func3_DO_FSAFE_TIME_read; 
	DELETE COMMAND func3_DO_FSAFE_TIME_write; 
	DELETE VARIABLE func3_DO_FSAFE_TYPE; 
	DELETE MENU func3_DO_FSAFE_TYPE_page; 
	DELETE COMMAND func3_DO_FSAFE_TYPE_read; 
	DELETE COMMAND func3_DO_FSAFE_TYPE_write; 
	DELETE VARIABLE func3_DO_FSAFE_VAL_D; 
	DELETE MENU func3_DO_FSAFE_VAL_D_page; 
	DELETE COMMAND func3_DO_FSAFE_VAL_D_read; 
	DELETE COMMAND func3_DO_FSAFE_VAL_D_write; 
//	DELETE COLLECTION func3_DO_VIEW_1; 
//	DELETE MENU func3_DO_VIEW__page; 
	DELETE MENU func3_DO_Simple_Dialog_Optional_A;


       BLOCK func3_DO_block
       {
	     REDEFINE NUMBER 5;
        }	
	 VARIABLE func3_DO_TAG_DESC
	{
		REDEFINE TYPE ASCII(32)
		{
			DEFAULT_VALUE "DO1";
		}
	}
	        VARIABLE func3_DO_ALARM_SUM_Current
        {
            REDEFINE STYLE "MULTILINE 07 05" ;
	}
        VARIABLE func3_DO_MODE_BLK_Permitted
        {
            REDEFINE STYLE "MULTILINE 07 08" ;
	}			 
        VARIABLE func3_DO_CHECK_BACK
       {
		REDEFINE TYPE BIT_ENUMERATED(3)
		{
			{ 0x000004, "Device under local control", [PI_CHECK_BACK_enum_0] },
			{ 0x000010, "Deviation > 10%", [PI_CHECK_BACK_enum_0] },	
			{ 0x004000, "Configuration change", [PI_CHECK_BACK_enum_0] },
			{ 0x008000, "Simulation active", [PI_CHECK_BACK_enum_0] },	
			{ 0x040000, "Device failure", [PI_CHECK_BACK_enum_0] },
			{ 0x100000, "Travel limit exceeded", [PI_CHECK_BACK_enum_0] }			
		}
	}


	COLLECTION func3_DO_ALARM_SUM
	{
		REDEFINE MEMBERS
		{
			Current, func3_DO_ALARM_SUM_Current;
//			Unacknowledged, func1_AI_ALARM_SUM_Unacknowledged;
//			Unreported, func1_AI_ALARM_SUM_Unreported;
//			Disabled, func1_AI_ALARM_SUM_Disabled;
		}
	}
	VARIABLE func3_DO_SP_D_Value
	{
		REDEFINE LABEL "Setpoint";
	}
	VARIABLE func3_DO_OUT_D_Status_Quality
	{
	   REDEFINE HANDLING IF ((func3_DO_MODE_BLK_Actual == 0x10) || (func3_DO_MODE_BLK_Actual == 0x08)) { READ & WRITE; } ELSE { READ; }
        }
        VARIABLE func3_DO_OUT_D_Status_Limit
       {
	   REDEFINE HANDLING IF ((func3_DO_MODE_BLK_Actual == 0x10) || (func3_DO_MODE_BLK_Actual == 0x08)) { READ & WRITE; } ELSE { READ; }
        }	
	VARIABLE func3_DO_OUT_D_Value
	{
		REDEFINE LABEL "Output Value";
	}	
	VARIABLE func3_DO_BLOCK_OBJECT_Address_of_VIEW_1_Slot
	{
		REDEFINE LABEL "Slot of View_1";
	}

	VARIABLE func3_DO_BLOCK_OBJECT_Address_of_VIEW_1_Index
	{
		REDEFINE LABEL "Index of View_1";
	}
        MENU func3_DO_Simple_Dialog_Mandatory_A
        {
		REDEFINE LABEL "Digital Out 3 - Stop";		
	        REDEFINE ITEMS
	        {
			func3_DO_BLOCK_OBJECT_page,
			func3_DO_ST_REV_page,
			func3_DO_TAG_DESC_page,
//			func3_DO_STRATEGY_page,
//			func3_DO_ALERT_KEY_page,
			func3_DO_TARGET_MODE_page,
			func3_DO_MODE_BLK_page,
			func3_DO_ALARM_SUM_page,
//			func3_DO_BATCH_page,
			func3_DO_SP_D_page,
			func3_DO_INVERT_page,
			func3_DO_CHECK_BACK_page,
			func3_DO_CHECK_BACK_MASK_page
	        }
        }		
     }
  }
IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __TRANS1_PNEUMATICACTUATOR, DEVICE_REVISION PROFILE_301, DD_REVISION 0x0004
      {
  
         USE_TRANS1_PNEUMATICACTUATOR_MANDATORY_B;
	 USE_TRANS1_PNEUMATICACTUATOR_OPTIONAL_B;
	 REDEFINITIONS
	 {
               DELETE VARIABLE trans1_PneumaticActuator_TAB_X_Y_VALUE_Upper_Value;
               DELETE VARIABLE trans1_PneumaticActuator_TAB_X_Y_VALUE_Lower_Value;
               DELETE COLLECTION trans1_PneumaticActuator_TAB_X_Y_VALUE;
               DELETE MENU trans1_PneumaticActuator_TAB_X_Y_VALUE_page;	
               DELETE COMMAND trans1_PneumaticActuator_TAB_X_Y_VALUE_read;
	       DELETE COMMAND trans1_PneumaticActuator_TAB_X_Y_VALUE_write;
		DELETE VARIABLE trans1_PneumaticActuator_ACT_STROKE_TIME_DEC;
		DELETE COMMAND trans1_PneumaticActuator_ACT_STROKE_TIME_INC_read;
		DELETE MENU trans1_PneumaticActuator_ADD_GEAR_ID_page;
		DELETE MENU trans1_PneumaticActuator_ACT_STROKE_TIME_DEC_page;
		DELETE MENU trans1_PneumaticActuator_ACT_STROKE_TIME_INC_page;
		DELETE COMMAND trans1_PneumaticActuator_ACT_STROKE_TIME_DEC_read;
		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_ID_write;
		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_ID_read;
		DELETE VARIABLE trans1_PneumaticActuator_ACT_STROKE_TIME_INC;
		DELETE VARIABLE trans1_PneumaticActuator_DEVICE_CALIB_DATE;
		DELETE MENU trans1_PneumaticActuator_DEVICE_CALIB_DATE_page;
		DELETE COMMAND trans1_PneumaticActuator_DEVICE_CALIB_DATE_read;
		DELETE COMMAND trans1_PneumaticActuator_DEVICE_CALIB_DATE_write;
		DELETE MENU trans1_PneumaticActuator_DEVICE_CONFIG_DATE_page;
		DELETE VARIABLE trans1_PneumaticActuator_DEVICE_CONFIG_DATE;
		DELETE COMMAND trans1_PneumaticActuator_DEVICE_CONFIG_DATE_write;
		DELETE COMMAND trans1_PneumaticActuator_DEVICE_CONFIG_DATE_read;		
		DELETE VARIABLE trans1_PneumaticActuator_TOT_VALVE_TRAV_LIM;
		DELETE MENU trans1_PneumaticActuator_TOT_VALVE_TRAV_LIM_page;
		DELETE COMMAND trans1_PneumaticActuator_TOT_VALVE_TRAV_LIM_read;
		DELETE COMMAND trans1_PneumaticActuator_TOT_VALVE_TRAV_LIM_write;		
		DELETE VARIABLE trans1_PneumaticActuator_VALVE_MAINT_DATE;
                DELETE MENU trans1_PneumaticActuator_VALVE_MAINT_DATE_page;
		DELETE COMMAND trans1_PneumaticActuator_VALVE_MAINT_DATE_read;
		DELETE COMMAND trans1_PneumaticActuator_VALVE_MAINT_DATE_write;		
		DELETE VARIABLE trans1_PneumaticActuator_TAB_OP_CODE;
		DELETE COMMAND trans1_PneumaticActuator_TAB_OP_CODE_read;
		DELETE COMMAND trans1_PneumaticActuator_TAB_OP_CODE_write;
		DELETE MENU trans1_PneumaticActuator_TAB_OP_CODE_page;
		DELETE VARIABLE trans1_PneumaticActuator_TAB_STATUS;
		DELETE MENU trans1_PneumaticActuator_TAB_STATUS_page;
		DELETE COMMAND trans1_PneumaticActuator_TAB_STATUS_read;
//		DELETE COMMAND trans1_PneumaticActuator_TAB_STATUS_write;
		DELETE VARIABLE trans1_PneumaticActuator_ADD_GEAR_SER_NUM;
		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_SER_NUM_write;
		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_SER_NUM_read;
		DELETE VARIABLE trans1_PneumaticActuator_ADD_GEAR_MAN;
		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_MAN_read;
		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_MAN_write;
		DELETE MENU trans1_PneumaticActuator_ADD_GEAR_MAN_page;
		DELETE VARIABLE trans1_PneumaticActuator_ADD_GEAR_ID;
//		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_ID_write;
		DELETE VARIABLE trans1_PneumaticActuator_ADD_GEAR_INST_DATE;
		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_INST_DATE_read;
		DELETE COMMAND trans1_PneumaticActuator_ADD_GEAR_INST_DATE_write;
		DELETE MENU trans1_PneumaticActuator_ADD_GEAR_INST_DATE_page;
		DELETE MENU trans1_PneumaticActuator_ADD_GEAR_SER_NUM_page;
                VARIABLE trans1_PneumaticActuator_ST_REV
                {
	           REDEFINE LABEL " Positioner Static Rev";
	        }		
                VARIABLE trans1_PneumaticActuator_SELF_CALIB_CMD
                {
	             REDEFINE TYPE ENUMERATED(1)
	             {
		          DEFAULT_VALUE 0;
		          { 0, [PI_IDENT_NUMBER_SELECTOR_enum_1] },
		          { 8, "Auto 1"},
		          { 9, "Auto 2" },
		          { 10, "Auto HF"}			  
	             }
                }
                VARIABLE trans1_PneumaticActuator_TARGET_MODE
                {
	                REDEFINE LABEL "Positioner Target Mode";	              
			REDEFINE TYPE ENUMERATED(1)
	              {
				{ 0x08, [PI_mode_AUTO] },
		                { 0x80, [PI_mode_OUT_OF_SERVICE] }
                	}
                }		
                VARIABLE trans1_PneumaticActuator_SELF_CALIB_STATUS
                {
	             REDEFINE TYPE ENUMERATED(1)
	             {
		          DEFAULT_VALUE 0;
		          { 0, [PI_SELF_CALIB_STATUS_enum_0] },
		          { 2, [PI_SELF_CALIB_STATUS_enum_2] },
		          { 4, [PI_SELF_CALIB_STATUS_enum_4] },
		          { 128, "Range error" },
		          { 129, "Mount error" },
		          { 130, "Check supply pressure" },
			  { 140, "In Autocal" },
		          { 254, [PI_SELF_CALIB_STATUS_enum_254] },
		          { 255, [PI_SELF_CALIB_STATUS_enum_255] }
	              }
                 }
                 VARIABLE trans1_PneumaticActuator_LIN_TYPE
                {
	            REDEFINE HANDLING READ&WRITE;
		    REDEFINE TYPE ENUMERATED(1)
	            {
		            { 0, [PI_LIN_TYPE_enum_0], [PI_LIN_TYPE_enum_0] },
		            { 1, [PI_LIN_TYPE_enum_1] },
		            { 50, [PI_LIN_TYPE_enum_50] },
		            { 51, [PI_LIN_TYPE_enum_51] }
	            }
                }
                VARIABLE trans1_PneumaticActuator_FEEDBACK_VALUE_Value
                {
                     REDEFINE LABEL "Position";
		     REDEFINE CONSTANT_UNIT "%";			
	             REDEFINE 	TYPE FLOAT
                     {
                         DISPLAY_FORMAT ".1f";
                     }				
                }
                VARIABLE trans1_PneumaticActuator_POSITIONING_VALUE_Value
                {
                     REDEFINE LABEL "Setpoint";
		     REDEFINE CONSTANT_UNIT "%";
	             REDEFINE 	TYPE FLOAT
                     {
                         DISPLAY_FORMAT ".1f";
                     }			
                }		
                VARIABLE trans1_PneumaticActuator_VALVE_SER_NUM
                {
	            REDEFINE LABEL "Valve serial Number";
                }		
                VARIABLE trans1_PneumaticActuator_ACTUATOR_SER_NUM
                {
	            REDEFINE LABEL "Actuator serial Number";

                }
                VARIABLE trans1_PneumaticActuator_DEADBAND     //YTC25_02:19
                {
                    REDEFINE MAX_VALUE 20.0;
                    REDEFINE MIN_VALUE 0.0;

                }
               VARIABLE trans1_PneumaticActuator_SERVO_GAIN_1
                {
                     REDEFINE LABEL "KP";
                     REDEFINE MAX_VALUE 500;   //YTC 25_02_19
                     REDEFINE MIN_VALUE 0;
		     REDEFINE 	TYPE FLOAT
	             {
			DISPLAY_FORMAT  ".0f";			
                     }
                 }
               VARIABLE trans1_PneumaticActuator_SERVO_RATE_1    //YTC 25_02_2019
                {
                     REDEFINE LABEL "KI";
                     REDEFINE MAX_VALUE 500;
                     REDEFINE MIN_VALUE 0;
		     REDEFINE 	TYPE FLOAT
	             {
			DISPLAY_FORMAT  ".0f";			
                     }			
                 }
               VARIABLE trans1_PneumaticActuator_SERVO_RESET_1   //YTC 25_02_2019
                {
                     REDEFINE LABEL "KD";
                     REDEFINE MAX_VALUE 500;
		     REDEFINE MIN_VALUE 0;
		     REDEFINE 	TYPE FLOAT
	             {
			DISPLAY_FORMAT  ".0f";			
                     }			
                 }		
               VARIABLE trans1_PneumaticActuator_SERVO_GAIN_2      //YTC25_02_2019
                {
                     REDEFINE LABEL "KP_";
                     REDEFINE MAX_VALUE 100;
                     REDEFINE MIN_VALUE 0;
		     REDEFINE 	TYPE FLOAT
	             {
			DISPLAY_FORMAT  ".0f";			
                     }			
                 }
               VARIABLE trans1_PneumaticActuator_SERVO_RATE_2    //YTC25_02_2019
                {
                     REDEFINE LABEL "KI_";
                     REDEFINE MAX_VALUE 100;
                     REDEFINE MIN_VALUE 0;
		     REDEFINE 	TYPE FLOAT
	             {
			DISPLAY_FORMAT  ".0f";			
                     }			
                 }
               VARIABLE trans1_PneumaticActuator_SERVO_RESET_2   //YTC25_02_2019
                {
                     REDEFINE LABEL "KD_";
		     REDEFINE MAX_VALUE 100;
                     REDEFINE MIN_VALUE 0;
		     REDEFINE 	TYPE FLOAT
	             {
			DISPLAY_FORMAT  ".0f";			
                     }			
                 }
                VARIABLE trans1_PneumaticActuator_ACTUATOR_TYPE
               {
                     REDEFINE TYPE ENUMERATED(1)
	            {
		     { 0, "Electro-pneumatic" }
	             }
		 }
		 VARIABLE trans1_PneumaticActuator_SETP_CUTOFF_DEC    //YTC25_02_2019
                {
	             REDEFINE LABEL "Tight Shut Open";
                 REDEFINE MAX_VALUE 100.0;
                 REDEFINE MIN_VALUE 0.0;

                }
		 VARIABLE trans1_PneumaticActuator_SETP_CUTOFF_INC   //YTC  25_02_2019
                {
	             REDEFINE LABEL "Tight Shut Close";
                 REDEFINE MAX_VALUE 100.0;
                 REDEFINE MIN_VALUE 0.0;

                }
                VARIABLE trans1_PneumaticActuator_RATED_TRAVEL      ///YTC25_2_2019
               {
	            ADD CONSTANT_UNIT "%";
		    REDEFINE LABEL "Total Valve Travel Limit";
                    REDEFINE MAX_VALUE 99999999999;
                    REDEFINE MIN_VALUE 0;
               }
                VARIABLE trans1_PneumaticActuator_TOTAL_VALVE_TRAVEL
               {
	            ADD CONSTANT_UNIT "%";
               }	       
VARIABLE trans1_PneumaticActuator_TRAVEL_LIMIT_LOW   //YTC25_02_2019
{
//	REDEFINE LABEL "Travel limit low";
    REDEFINE LABEL "Lo Lo Alarm";
    REDEFINE MAX_VALUE 110.0;
    REDEFINE MIN_VALUE -10.0;

}

VARIABLE trans1_PneumaticActuator_TRAVEL_LIMIT_UP   //YTC 25_02 2019
{
//	REDEFINE LABEL "Travel limit up";
    REDEFINE LABEL "Hi Hi Alarm";
    REDEFINE MAX_VALUE 110.0;
    REDEFINE MIN_VALUE -10.0;

}		

                VARIABLE trans1_PneumaticActuator_ACTUATOR_ACTION
                {
                     REDEFINE HANDLING READ & WRITE; 		
                 }
		
                MENU trans1_PneumaticActuator_Simple_Dialog_Mandatory_B
                {
	             REDEFINE LABEL "Positioner Transducer Block";
	             REDEFINE ITEMS
	             {
				trans1_PneumaticActuator_BLOCK_OBJECT_page,
				trans1_PneumaticActuator_ST_REV_page,
				trans1_PneumaticActuator_TAG_DESC_page,
				trans1_PneumaticActuator_TARGET_MODE_page,
				trans1_PneumaticActuator_MODE_BLK_page,
				trans1_PneumaticActuator_LIN_TYPE_page,
//				trans1_PneumaticActuator_RATED_TRAVEL_page,
			        trans1_PneumaticActuator_SETP_CUTOFF_LIMIT_page,
			        trans1_PneumaticActuator_VALUE_page,
				trans1_PneumaticActuator_VALVE_page,			     
				trans1_PneumaticActuator_VIEW_1_page
			}
		}		
                MENU trans1_PneumaticActuator_Simple_Dialog_Optional_B
		{
			 REDEFINE ITEMS
			{
				trans1_PneumaticActuator_BLOCK_OBJECT_page,
				trans1_PneumaticActuator_ST_REV_page,
				trans1_PneumaticActuator_TAG_DESC_page,
				trans1_PneumaticActuator_STRATEGY_page,
				trans1_PneumaticActuator_ALERT_KEY_page,
				trans1_PneumaticActuator_TARGET_MODE_page,
				trans1_PneumaticActuator_MODE_BLK_page,
				trans1_PneumaticActuator_ALARM_SUM_page,
		//		trans1_PneumaticActuator_ACT_STROKE_TIME_DEC_page,
		//		trans1_PneumaticActuator_ACT_STROKE_TIME_INC_page,
		//		trans1_PneumaticActuator_TAB_ENTRY_page,
		//		trans1_PneumaticActuator_TAB_X_Y_VALUE_page,
		//		trans1_PneumaticActuator_TAB_MIN_NUMBER_page,
		//		trans1_PneumaticActuator_TAB_MAX_NUMBER_page,
				trans1_PneumaticActuator_TAB_ACTUAL_NUMBER_page,
				trans1_PneumaticActuator_DEADBAND_page,
		//		trans1_PneumaticActuator_DEVICE_CALIB_DATE_page,
		//		trans1_PneumaticActuator_DEVICE_CONFIG_DATE_page,
				trans1_PneumaticActuator_LIN_TYPE_page,
				trans1_PneumaticActuator_RATED_TRAVEL_page,
				trans1_PneumaticActuator_SELF_CALIB_CMD_page,
				trans1_PneumaticActuator_SELF_CALIB_STATUS_page,
				trans1_PneumaticActuator_SERVO_GAIN_1_page,
				trans1_PneumaticActuator_SERVO_RATE_1_page,
				trans1_PneumaticActuator_SERVO_RESET_1_page,
				trans1_PneumaticActuator_SETP_CUTOFF_DEC_page,
				trans1_PneumaticActuator_SETP_CUTOFF_INC_page,
				trans1_PneumaticActuator_TOTAL_VALVE_TRAVEL_page,
		//		trans1_PneumaticActuator_TOT_VALVE_TRAV_LIM_page,
				trans1_PneumaticActuator_TRAVEL_LIMIT_LOW_page,
				trans1_PneumaticActuator_TRAVEL_LIMIT_UP_page,
				trans1_PneumaticActuator_TRAVEL_RATE_DEC_page,
				trans1_PneumaticActuator_TRAVEL_RATE_INC_page,
		//		trans1_PneumaticActuator_VALVE_MAINT_DATE_page,
				trans1_PneumaticActuator_SERVO_GAIN_2_page,
				trans1_PneumaticActuator_SERVO_RATE_2_page,
				trans1_PneumaticActuator_SERVO_RESET_2_page,

				trans1_PneumaticActuator_POSITIONING_VALUE_page,
				trans1_PneumaticActuator_FEEDBACK_VALUE_page,
				trans1_PneumaticActuator_VALVE_MAN_page,
				trans1_PneumaticActuator_ACTUATOR_MAN_page,
				trans1_PneumaticActuator_VALVE_TYPE_page,
				trans1_PneumaticActuator_ACTUATOR_TYPE_page,
				trans1_PneumaticActuator_ACTUATOR_ACTION_page,
				trans1_PneumaticActuator_VALVE_SER_NUM_page,
				trans1_PneumaticActuator_ACTUATOR_SER_NUM_page,

				trans1_PneumaticActuator_VIEW_1_page
	              }	
             }
	     MENU trans1_PneumaticActuator_LIN_TYPE_page
            {
		   REDEFINE VALIDITY IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80){TRUE;} ELSE {FALSE;}	
	           REDEFINE ITEMS
	          {
		        trans1_PneumaticActuator_LIN_TYPE
//			menu_TAB_
	          }
            }


      }
}


 #define		OPTIWAVE	2



/***********************************************************************/

#define	FLOAT_MIN	-3.4E+38
#define	FLOAT_MAX	 3.4E+38












/**************************************************************************************************/
/*    Physical Block								  */
/**************************************************************************************************/

VARIABLE ne107_mask_dummy
 {
	LABEL "Positioner Diagnosis";
	HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;	 
	TYPE BIT_ENUMERATED (1)
	{
		{ 0x8, "Error",           "Masked flag from Ch4" }

	}	
}
VARIABLE device_specific_status_0
 {
	LABEL "Error";
	HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;	 
	TYPE BIT_ENUMERATED (1)
	{
		{ 0x8, "Error>10% for preset deviation time",           "Masked flag from Ch4" },
		{ 0x4, "Check supply pressure",                "Masked flag from Positioner" },
		{ 0x2, "Mount error",                           "Masked flag Positioner" },
		{ 0x1, "Range error",     			"Masked flag Positioner" }

	}	
}
VARIABLE device_specific_status_1
 {
	LABEL "Warning";
	HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;	 
	TYPE BIT_ENUMERATED (1)
	{
		{ 0x80, "Discrete output Setpoint conflict",         	"Masked flag from Positioner" },
		{ 0x20, "Hi Hi Alarm",                         	         "Masked flag Positioner" },		// As of 11 Sep 2019 YTC
		{ 0x10, "Lo Lo Alarm",     				"Masked flag Positioner" },		
		{ 0x8, "PV out of range (upper)",             		"Masked flag from Positioner" },
		{ 0x4, "PV out of range (lower)",                	"Masked flag from Positioner" },
		{ 0x2, "Stroke time <= 1 sec",                         "Masked flag Positioner" },
		{ 0x1, "kI value saturated",     			"Masked flag Positioner" }

	}	
}
VARIABLE device_specific_status_2
 {
	LABEL "Warning";
	HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;	 
	TYPE BIT_ENUMERATED (1)
	{
		{ 0x40, "Hi Alarm",                          "Masked flag Positioner" },
		{ 0x80, "Lo Alarm",     			    "Masked flag Positioner" }

	}	
}
VARIABLE phys_yt33000_device_serial_nu  // HLA 2020 03 17
 {
	LABEL "YT 3300 Serial Number";
	HELP "Serial number of the main positioner";
	HANDLING READ;	
	CLASS CONTAINED;	 
	TYPE ASCII(8)
	{
			DEFAULT_VALUE "No 1";
	}	 
}
COMMAND read_phys_yt33000_device_serial_nu
{
	BLOCK phys_block ;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			phys_yt33000_device_serial_nu
		}
	}
}


/**************************************************************************************************/
/*    Transducer Block								  */
/**************************************************************************************************/
/*--- x|y-Value: Entry 0 ----------------------------------------------*/
		   

VARIABLE trans1_tab_y_value_0					/* optional */
{
	LABEL		TAB_Y_LABEL_0;
	HELP		[lin_tab_y_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
		MIN_VALUE		0.0;
		MAX_VALUE		110.0;
	}
	CONSTANT_UNIT		"%";
	HANDLING	READ & WRITE;

}
VARIABLE trans1_tab_x_value_0					/* optional */
{
	LABEL		TAB_X_LABEL_0;
	HELP		"";
	CLASS		CONTAINED;
	PRE_READ_ACTIONS
	{
		method_set_tab_entry (1)
	}
	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (1)
	}
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
		MIN_VALUE		0.0;
		MAX_VALUE		110.0;
	}
	CONSTANT_UNIT		"%";
	HANDLING	READ & WRITE;

}


/*--- x|y-Value: Entry 1 ----------------------------------------------*/

trans1_tab_y_value_1		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_1;
	REDEFINE	DEFAULT_VALUE	10.0;
}

trans1_tab_x_value_1		LIKE VARIABLE	trans1_tab_y_value_1
{
	REDEFINE	LABEL			TAB_X_LABEL_1;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (2)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (2)
	}
}


/*--- x|y-Value: Entry 2 ----------------------------------------------*/

trans1_tab_y_value_2		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_2;
	REDEFINE	DEFAULT_VALUE	20.0;
}

trans1_tab_x_value_2		LIKE VARIABLE	trans1_tab_y_value_2
{
	REDEFINE	LABEL			TAB_X_LABEL_2;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (3)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (3)
	}
}

/*--- x|y-Value: Entry 3 ----------------------------------------------*/

trans1_tab_y_value_3		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_3;
	REDEFINE	DEFAULT_VALUE	30.0;

}

trans1_tab_x_value_3		LIKE VARIABLE	trans1_tab_y_value_3
{
	REDEFINE	LABEL			TAB_X_LABEL_3;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (4)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (4)
	}
}

/*--- x|y-Value: Entry 4 ----------------------------------------------*/

trans1_tab_y_value_4		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_4;
	REDEFINE	DEFAULT_VALUE	40.0;

}

trans1_tab_x_value_4		LIKE VARIABLE	trans1_tab_y_value_4
{
	REDEFINE	LABEL			TAB_X_LABEL_4;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (5)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (5)
	}
}

/*--- x|y-Value: Entry 5 ----------------------------------------------*/

trans1_tab_y_value_5		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_5;
	REDEFINE	DEFAULT_VALUE	50.0;

}

trans1_tab_x_value_5		LIKE VARIABLE	trans1_tab_y_value_5
{
	REDEFINE	LABEL			TAB_X_LABEL_5;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (6)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (6)
	}
}

/*--- x|y-Value: Entry 6 ----------------------------------------------*/

trans1_tab_y_value_6		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_6;
	REDEFINE	DEFAULT_VALUE	60.0;
}

trans1_tab_x_value_6		LIKE VARIABLE	trans1_tab_y_value_6
{										
	REDEFINE	LABEL			TAB_X_LABEL_6;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (7)
	}
	REDEFINE	PRE_WRITE_ACTIONS   
	{
		method_set_tab_entry (7)
	}
}										
										
/*--- x|y-Value: Entry 7 ----------------------------------------------*/
 
trans1_tab_y_value_7		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_7;
	REDEFINE	DEFAULT_VALUE	70.0;

}

trans1_tab_x_value_7		LIKE VARIABLE	trans1_tab_y_value_7
{											
	REDEFINE	LABEL			TAB_X_LABEL_7;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (8)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (8)
	}
}											
 											
/*--- x|y-Value: Entry 8 ----------------------------------------------*/

trans1_tab_y_value_8		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_8;
	REDEFINE	DEFAULT_VALUE	80.0;


}

trans1_tab_x_value_8		LIKE VARIABLE	trans1_tab_y_value_8
{											
	REDEFINE	LABEL			TAB_X_LABEL_8;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (9)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (9)
	}
}											
											
/*--- x|y-Value: Entry 9 ----------------------------------------------*/

trans1_tab_y_value_9		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_9;
	REDEFINE	DEFAULT_VALUE	90.0;


}

trans1_tab_x_value_9		LIKE VARIABLE	trans1_tab_y_value_9
{											
	REDEFINE	LABEL			TAB_X_LABEL_9;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (10)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (10)
	}
}											
											
/*--- x|y-Value: Entry 10 ---------------------------------------------*/

trans1_tab_y_value_10		LIKE VARIABLE	trans1_tab_y_value_0
{
	REDEFINE	LABEL			TAB_Y_LABEL_10;
	REDEFINE	DEFAULT_VALUE	100.0;


}

trans1_tab_x_value_10		LIKE VARIABLE	trans1_tab_y_value_10
{											
	REDEFINE	LABEL			TAB_X_LABEL_10;
	REDEFINE	PRE_READ_ACTIONS
	{
		method_set_tab_entry (11)
	}
	REDEFINE	PRE_WRITE_ACTIONS
	{
		method_set_tab_entry (11)
	}
}

COMMAND read_trans1_tab_value_0
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION 
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_0, 
			trans1_tab_y_value_0
		}
	}
}



COMMAND write_trans1_tab_value_0
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_0, 
			trans1_tab_y_value_0
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_1
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_1, 
			trans1_tab_y_value_1
		}
	}
}

COMMAND write_trans1_tab_value_1
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_1, 
			trans1_tab_y_value_1
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_2
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_2, 
			trans1_tab_y_value_2
		}
	}
}

COMMAND write_trans1_tab_value_2
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_2, 
			trans1_tab_y_value_2
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_3
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_3, 
			trans1_tab_y_value_3
		}
	}
}

COMMAND write_trans1_tab_value_3
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_3, 
			trans1_tab_y_value_3
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_4
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_4, 
			trans1_tab_y_value_4
		}
	}
}

COMMAND write_trans1_tab_value_4
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_4, 
			trans1_tab_y_value_4
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_5
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_5, 
			trans1_tab_y_value_5
		}
	}
}

COMMAND write_trans1_tab_value_5
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_5, 
			trans1_tab_y_value_5
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_6
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_6, 
			trans1_tab_y_value_6
		}
	}
}

COMMAND write_trans1_tab_value_6
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_6, 
			trans1_tab_y_value_6
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_7
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_7, 
			trans1_tab_y_value_7
		}
	}
}

COMMAND write_trans1_tab_value_7
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_7, 
			trans1_tab_y_value_7
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_8
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_8, 
			trans1_tab_y_value_8
		}
	}
}

COMMAND write_trans1_tab_value_8
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_8, 
			trans1_tab_y_value_8
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_9
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_9, 
			trans1_tab_y_value_9
		}
	}
}

COMMAND write_trans1_tab_value_9
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_9, 
			trans1_tab_y_value_9
		}
		REPLY
		{
		}
	}
}

COMMAND read_trans1_tab_value_10
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{ 
		}
		REPLY
		{
			trans1_tab_x_value_10, 
			trans1_tab_y_value_10
		}
	}
}

COMMAND write_trans1_tab_value_10
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{ 
			trans1_tab_x_value_10, 
			trans1_tab_y_value_10
		}
		REPLY
		{
		}
	}
}


 VARIABLE trans1_yt_ACTING
 {
	LABEL "Actuator Direction";
	HELP "Actuator Direction";
	CLASS CONTAINED;
        HANDLING  READ & WRITE; 				 
	TYPE ENUMERATED (2)
	{
		{ 0, "Direct",             "Direct acting" },
		{ 1, "Reverse",            "Reverse acting" }
	}	
}
 VARIABLE trans1_yt_ZERO  //YTC25_02_2019
 {
	LABEL "PV Zero";
	HELP "Actuator zero";
        MAX_VALUE 4095;
        MIN_VALUE 0;
	CLASS CONTAINED;		 
	TYPE INTEGER (2);
}

 VARIABLE trans1_yt_SPAN/* YTC 25_02_2019 */
 {
	LABEL "PV End";
	HELP "Actuator span";
        MAX_VALUE 4095;
        MIN_VALUE 0;
	CLASS CONTAINED;	 
	TYPE INTEGER (2);
}

COMMAND trans1_yt_ACTING_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 80;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_ACTING
		}
	}
}

COMMAND trans1_yt_ACTING_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 80;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_ACTING
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_ZERO_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 81;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_ZERO
		}
	}
}

COMMAND trans1_yt_ZERO_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 81;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_ZERO
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_SPAN_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 82;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_SPAN
		}
	}
}

COMMAND trans1_yt_SPAN_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 82;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_SPAN
		}
		REPLY
		{
		}
	}
}

VARIABLE trans1_yt_PST_MODE
 {
	LABEL "Mode";
	HELP "Partial stroke mode";
	CLASS CONTAINED;
	HANDLING READ&WRITE;	 
	TYPE ENUMERATED (2)
	{
		{ 0, "PST OFF",             "Partial Stroke Test is not enabled"},
		{ 1, "PST SCHD",                "Partial Stroke Test will run" }
//		{ 2, "PST NOW",                 "Partial Stroke Test will run" }   YTC 25 02 2019
	}	
}
 VARIABLE trans1_yt_PST_START_POSITION   // YTC 25 02 2019
 {
	LABEL "Start position";
	HELP "Partial stroke start position";
	CLASS CONTAINED;
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }	
        CONSTANT_UNIT   "%";
        MIN_VALUE		0.0;
	MAX_VALUE		100.0;
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
 VARIABLE trans1_yt_PST_TARGET_POSITION_1   //YTC 25 02 2019
 {
	LABEL "Target position 1";
	HELP "Partial stroke target position";
	CLASS CONTAINED;
        CONSTANT_UNIT   "%";
        MIN_VALUE		0.0;
	MAX_VALUE		100.0;	 
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
 VARIABLE trans1_yt_PST_TARGET_POSITION_2  //YTC 25 02 2019
 {
	LABEL "Target position 2";
	HELP "Partial stroke target position";
	CLASS CONTAINED;
        CONSTANT_UNIT   "%";
        MIN_VALUE		0.0;
	MAX_VALUE		100.0;	 
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }		 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
 VARIABLE trans1_yt_PST_TOLLERANCE  // YTC 25 02 2019
 {
	LABEL "Tolerance";
	HELP "Partial stroke tolerance";
	CLASS CONTAINED;
        CONSTANT_UNIT   "%";
        MIN_VALUE		0.0;
	MAX_VALUE		10.0;
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }		 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
 VARIABLE trans1_yt_PST_INTERVAL  // YTC 25 02 2019
 {
	LABEL "Interval";
	HELP "Partial stroke interval";
	CLASS CONTAINED;
        CONSTANT_UNIT   "d";
        MIN_VALUE		0;
	MAX_VALUE		365;
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }		 
	TYPE INTEGER (2);	 
}
 VARIABLE trans1_yt_PST_LIMIT_TIME   // YTC 25 02 2019
 {
	LABEL "Limit Time";
	HELP "Partial stroke limit time";
	CLASS CONTAINED;
        CONSTANT_UNIT   "s";
        MIN_VALUE		0;
	MAX_VALUE		600;	 
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }		 
	TYPE INTEGER (2);	 
}
 VARIABLE trans1_yt_PST_LATENCY  // YTC 25 02 2019
 {
	LABEL "Latency";
	HELP "Partial stroke latency";
	CLASS CONTAINED;
        CONSTANT_UNIT   "s";
        MIN_VALUE		0;
	MAX_VALUE		60;	 
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }		 
	TYPE INTEGER (2);	 
}
 VARIABLE trans1_yt_PST_RESULT1  //YTC 25 02 2019
{
	LABEL "Partial Stroke Time 1";
	HELP "Partial stroke time 1";
	CLASS CONTAINED;
    CONSTANT_UNIT "s";
	HANDLING READ;	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
 VARIABLE trans1_yt_PST_RESULT1_ERROR  // YTC 25 02 2019
 {
	LABEL "PST Result 1";
	HELP "Partial stroke result 1";
	CLASS CONTAINED;
	HANDLING READ;	 
	TYPE ENUMERATED (2)
	{
		{ 0, "PASS",                         "Partial Stroke Test passed"},
		{ 1, "Out of Tollerance",            "Partial Stroke Test failed due to tollerance " },
		{ 2, "Limit time over",              "Partial Stroke Test failed "},
		{ 3, "No Reaction",                  "Partial Stroke Test failed " }		
	}	 
}
 VARIABLE trans1_yt_PST_RESULT2  //YTC 25 02 2019
 {
	LABEL "Partial Stroke Time 2";
	HELP "Partial stroke time 2";
	CLASS CONTAINED;
    CONSTANT_UNIT "s";
	HANDLING READ;	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
 VARIABLE trans1_yt_PST_RESULT2_ERROR  //YTC 25 02 2019
 {
	LABEL "PST Result 2";
	HELP "Partial stroke result 2";
	CLASS CONTAINED;
	HANDLING READ;	 
	TYPE ENUMERATED (2)
	{
		{ 0, "PASS",                         "Partial Stroke Test passed"},
		{ 1, "Out of Tollerance",            "Partial Stroke Test failed due to tollernce " },
		{ 2, "Limit time over",              "Partial Stroke Test failed "},
		{ 3, "No Reaction",                  "Partial Stroke Test failed " }
        }		
}
 VARIABLE trans1_yt_PST_RESULT3  //YTC 25 02 2019
 {
	LABEL "Partial Stroke Time 3";
	HELP "Partial stroke time 3";
	CLASS CONTAINED;
    CONSTANT_UNIT "s";
	HANDLING READ;	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
 VARIABLE trans1_yt_PST_RESULT3_ERROR  //YTC 25 02 2019
 {
	LABEL "PST Result 3";
	HELP "Partial stroke result 3";
	CLASS CONTAINED;
	HANDLING READ;	 
	TYPE ENUMERATED (2)
	{
		{ 0, "PASS",                         "Partial Stroke Test passed"},
		{ 1, "Out of Tollerance",            "Partial Stroke Test failed due to tollerance " },
		{ 2, "Limit time over",              "Partial Stroke Test failed "},
		{ 3, "No Reaction",                  "Partial Stroke Test failed " }
        }		
}
 VARIABLE trans1_yt_PSNR_Command
 {
	LABEL "PSNR Command";
	HELP "";
	CLASS CONTAINED;
	HANDLING READ&WRITE;	 
	TYPE ENUMERATED (1)
	{
		{ 0, "None",                         	"No action"},
		{ 1, "Running",            		"Partial Stroke Test Running " },
		{ 2, "PST Done",              		"Partial Stroke Finished "},
		{ 11, "PST Now",              		"Start PST"},
		{ 254, "Device reset",                  "Reset positioner " }		
        }		
}
VARIABLE trans1_yt_CONTROL_MODE
 {
	LABEL "Control Mode";
	HELP "Selects either Discrete or Analog control";
	CLASS CONTAINED;
        HANDLING IF (phys_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }	 
	TYPE ENUMERATED (1)
	{
		{ 0, "Position",            "Analog Control"},
		{ 1, "Discrete",            "Discrete Control" }
        }		
}
COMMAND trans1_yt_PST_MODE_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 83;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_MODE
		}
	}
}

COMMAND trans1_yt_PST_MODE_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 83;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PST_MODE
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PST_START_POSITION_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 84;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_START_POSITION
		}
	}
}

COMMAND trans1_yt_PST_START_POSITION_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 84;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PST_START_POSITION
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PST_TARGET_POSITION_1_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 85;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_TARGET_POSITION_1
		}
	}
}

COMMAND trans1_yt_PST_TARGET_POSITION_1_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 85;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PST_TARGET_POSITION_1
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PST_TARGET_POSITION_2_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 86;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_TARGET_POSITION_2
		}
	}
}

COMMAND trans1_yt_PST_TARGET_POSITION_2_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 86;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PST_TARGET_POSITION_2
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PST_TOLLERANCE_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 87;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_TOLLERANCE
		}
	}
}

COMMAND trans1_yt_PST_TOLLERANCE_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 87;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PST_TOLLERANCE
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PST_INTERVAL_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 88;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_INTERVAL
		}
	}
}

COMMAND trans1_yt_PST_INTERVAL_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 88;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PST_INTERVAL
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PST_LIMIT_TIME_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 89;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_LIMIT_TIME
		}
	}
}

COMMAND trans1_yt_PST_LIMIT_TIME_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 89;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PST_LIMIT_TIME
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PST_LATENCY_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 90;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_LATENCY
		}
	}
}

COMMAND trans1_yt_PST_LATENCY_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 90;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PST_LATENCY
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PST_RESULT1_ERROR_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 92;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_RESULT1_ERROR
		}
	}
}
COMMAND trans1_yt_PST_RESULT1_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 91;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST   
		{
		}
		REPLY
		{
			trans1_yt_PST_RESULT1
		}
	}
}
COMMAND trans1_yt_PST_RESULT2_read
{
	BLOCK trans1_PneumaticActuator_block;   
	INDEX 93;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_RESULT2
		}
	}
}
COMMAND trans1_yt_PST_RESULT2_ERROR_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 94;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_RESULT2_ERROR
		}
	}
}
COMMAND trans1_yt_PST_REtrans1_PneumaticActuatorSULT3_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 95;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_RESULT3
		}
	}
}
COMMAND trans1_yt_PST_RESULT3_ERROR_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 96;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PST_RESULT3_ERROR
		}
	}
}
COMMAND trans1_yt_CONTROL_MODE_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 97;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_CONTROL_MODE
		}
	}
}

COMMAND trans1_yt_CONTROL_MODE_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 97;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_CONTROL_MODE
		}
		REPLY
		{
		}
	}
}
COMMAND trans1_yt_PSNR_Command_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 111;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_PSNR_Command
		}
	}
}

COMMAND trans1_yt_PSNR_Command_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 111;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_PSNR_Command
		}
		REPLY
		{
		}
	}
}
/************************************************************************/
 VARIABLE trans1_yt_DEVIATION_TIME  //YTC 25 02 2019
 {
	LABEL "Deviation Time";
	HELP "";
	CLASS CONTAINED;
	CONSTANT_UNIT "s";
        MIN_VALUE		0;
        MAX_VALUE		1000;	 
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }		 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".0f";
	}	 
}
COMMAND trans1_yt_DEVIATION_TIME_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 104;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_DEVIATION_TIME
		}
	}
}
COMMAND trans1_yt_DEVIATION_TIME_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 104;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_DEVIATION_TIME			
		}
		REPLY
		{
		}
	}
}
/************************************************************************/
 VARIABLE trans1_yt_DEVIATION
 {
	LABEL "Deviation";
	HELP "Dynamic variable";
	CLASS CONTAINED;
    CONSTANT_UNIT "%";		// As of 11 Sep 2019 YTC
	HANDLING READ;	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
COMMAND trans1_yt_DEVIATION_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 105;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_DEVIATION
		}
	}
}



/************************************************************************/
 VARIABLE trans1_yt_SERVO_KF  //YTC 25 02 2019
 {
	LABEL "KF";
	HELP "PID parameter";
	CLASS CONTAINED;
    MIN_VALUE		0.0;
	MAX_VALUE		500.0;
	HANDLING READ&WRITE;	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".0f";
	}	 
}
COMMAND trans1_yt_SERVO_KF_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 106;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_SERVO_KF
		}
	}
}

COMMAND trans1_yt_SERVO_KF_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 106;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_SERVO_KF
		}
		REPLY
		{
		}
	}
}
/************************************************************************/
 VARIABLE trans1_yt_ALARM_HI   //YTC 25 02 2019
 {
	LABEL "Hi Alarm";
	HELP "Alarm limit";
	CLASS CONTAINED;
	CONSTANT_UNIT "%";	 
	HANDLING READ&WRITE;
    MIN_VALUE		0.0;
	MAX_VALUE		100.0;	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
COMMAND trans1_yt_ALARM_HI_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 108;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_ALARM_HI
		}
	}
}

COMMAND trans1_yt_ALARM_HI_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 108;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_ALARM_HI
		}
		REPLY
		{
		}
	}
}
VARIABLE trans1_yt_ALARM_LO  //YTC 25 02 2019
 {
	LABEL "Lo Alarm";
	HELP "Alarm limit";
	CLASS CONTAINED;
	CONSTANT_UNIT "%";
    MIN_VALUE		0.0;
	MAX_VALUE		100.0;
	HANDLING READ&WRITE;	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
COMMAND trans1_yt_ALARM_LO_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 109;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_ALARM_LO
		}
	}
}

COMMAND trans1_yt_ALARM_LO_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 109;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_ALARM_LO
		}
		REPLY
		{
		}
	}
}
/*****************************************************************************/
 VARIABLE trans1_yt_DEVIATION_DEADBAND  // YTC 25 02 2019
 {
	LABEL "Deviation Deadband";
	HELP "";
	CLASS CONTAINED;
	CONSTANT_UNIT "%";
        MIN_VALUE		0.0;
        MAX_VALUE		25.0;
        HANDLING IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80) { READ & WRITE; } ELSE { READ; }	
	 
	TYPE FLOAT
	{
		DISPLAY_FORMAT  ".1f";
	}	 
}
COMMAND trans1_yt_DEVIATION_DEADBAND_read
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 110;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_yt_DEVIATION_DEADBAND
		}
	}
}

COMMAND trans1_yt_DEVIATION_DEADBAND_write
{
	BLOCK trans1_PneumaticActuator_block;
	INDEX 110;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_yt_DEVIATION_DEADBAND
		}
		REPLY
		{
		}
	}
}
/*************************************************************************************************/
/*    Function Block                                                   				  */
/*************************************************************************************************/


#define DEFAULT_UPPER_VAL	DEFAULT_VALUE 10 ;

#define DEFAULT_LOWER_VAL	DEFAULT_VALUE 0 ;

#define FUNC1_TITLE	[trans_blk_parent_class_LEVEL]

#define FUNC1_DEFAULT_UNIT		1342

#define FUNC1_PV	trans1_primary_value_value





/***********************************************************************/
/*    Unit relations                                                   */
/***********************************************************************/







/* Function Block Analog Input */
/*UNIT AI1_PV_SCALE_UNIT
{

	trans1_primary_value_unit:  
	
	func1_AI_PV_SCALE_Lower_Value,
	func1_AI_PV_SCALE_Upper_Value,
	trans1_primary_value_value	
}  */    





/***********************************************************************/
/*    Refresh relations                                                   */
/***********************************************************************/







/* Function Block Analog Input */
REFRESH AI1_OUT_REFRESH
{
	/* func1_AI_pv_unit: */
	func1_AI_TARGET_MODE:
	
	func1_AI_OUT_Value
}



			

/*******************************************************************************/
/*****	MENU Bar  **************************************************************/
/*******************************************************************************/

MENU Menu_Main_Specialist
{
	LABEL		[main_menu];
	ITEMS
	{
//		Menu_File,
		Menu_S_Device,
		Menu_S_View
//		Menu_S_Options,
//		Menu_Help
	}
}

MENU Menu_Main_Maintenance
{
	LABEL		[main_menu];
	ITEMS
	{
//		Menu_File,
		Menu_M_Device
//		Menu_M_View,
//		Menu_M_Options,
//		Menu_Help
	}
}

/*---------------------------------------------------------------------*/
/*    Menu: Device													   */
/*---------------------------------------------------------------------*/

MENU Menu_S_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_NodeAddress,
		SEPARATOR,
		std_LoadinDevice,										
		std_LoadinPC,
		SEPARATOR,
		Menu_control,
		Menu_simulation,
		Menu_configuration,
		method_Autocalibrate,
		Tab_page_diagnostics,
		Menu_phys_FACTORY_RESET

	}
}
MENU Menu_control
{
	LABEL		"Positioner operation";
	STYLE WINDOW;
	ACCESS ONLINE;
	ITEMS
	{
		
		trans1_yt_CONTROL_MODE_PAGE,
		trans1_yt_position_control,
		trans1_yt_simulation_control_page,
		trans1_yt_discrete_control,
        rrans1_yt_plot  //YTC 25 02 2019
//		trans1_yt_discrete_simulation_control



	}
}

MENU rrans1_yt_plot // ytc
{
    LABEL		"YT Plot";
    
    STYLE PAGE;
	ITEMS
	{
        windows_yt_1
    }
}
MENU trans1_yt_CONTROL_MODE_PAGE
{
	LABEL		"Positioner operation";
	STYLE PAGE;
	ITEMS
	{
                phys_TARGET_MODE,
                phys_MODE_BLK_Actual,		
		trans1_yt_CONTROL_MODE

	}
}

MENU trans1_yt_position_control
{
	LABEL "Position control";
	STYLE PAGE;
	VALIDITY IF (trans1_yt_CONTROL_MODE == 0){TRUE;} ELSE {FALSE;} 
	ITEMS
	{
		Func1_AO_set_point_BarVal,
	        func1_AO_TARGET_MODE,
		func1_AO_MODE_BLK_Actual,
		Func1_AO_setpoint_GROUP_control,
		Func1_AO_output_GROUP_control,
		Func1_AO_readback_GROUP

//		Func1_AO_rcas_in_GROUP,
//		Func1_AO_rcas_out_GROUP,
		trans1_yt_DEVIATION,
        COLUMNBREAK,                // As of 11 Sep 2019 YTC
        trans1_PneumaticActuator_TOTAL_VALVE_TRAVEL, // As of 11 Sep 2019 YTC
		
		
		
		
		
		
//		trans1_set_point_BarVal,
//	        func1_AO_TARGET_MODE,
//		func1_AO_MODE_BLK_Actual,
//		trans1_setpoint_GROUP,
//		trans1_output_GROUP,
//		trans1_postion_GROUP,
//		trans1_yt_DEVIATION,
		COLUMNBREAK, 
		ROWBREAK,
		func1_AO_CHECK_BACK,
		COLUMNBREAK,
		func1_AO_ALARM_SUM_Current

	}
}
MENU Func1_AO_setpoint_GROUP_control
{
	LABEL "Setpoint";
	STYLE GROUP;
	ITEMS
	{
			func1_AO_SP_Value ,
		        COLUMNBREAK,
                        func1_AO_SP_Status_Quality ,
                        func1_AO_SP_Status_Limit   
	}
}
MENU Func1_AO_output_GROUP_control
{
	LABEL "Output value";
	STYLE GROUP;
	ITEMS
	{
			func1_AO_OUT_Value,         
		        COLUMNBREAK,
                        func1_AO_OUT_Status_Quality ,
                        func1_AO_OUT_Status_Limit
	}
}
MENU trans1_yt_simulation_control_page
{
	LABEL "Simulation Readback";
	STYLE PAGE; 	
	VALIDITY IF (trans1_yt_CONTROL_MODE == 0){TRUE;} ELSE {FALSE;} 	
	ITEMS
	{
		func1_AO_SIMULATE_Enabled,
		func1_AO_simulation_group,
//		func1_AO_SP_Value,
		func1_AO_READBACK_Value,
		ROWBREAK,
		func1_AO_CHECK_BACK,
         	COLUMNBREAK,
		func1_AO_ALARM_SUM_Current
	}
}

MENU func1_AO_simulation_group
{
	LABEL "Target position of the regulating unit";
	STYLE GROUP;
	ITEMS
	{
		func1_AO_SIMULATE_Value,
		COLUMNBREAK,
		func1_AO_SIMULATE_Status_Quality,
		func1_AO_SIMULATE_Status_Limit
	}
}
MENU trans1_yt_discrete_control
{
	LABEL "Discrete control";
	STYLE PAGE;
	VALIDITY IF (trans1_yt_CONTROL_MODE == 1){TRUE;} ELSE {FALSE;}		// As of 11 Sep 2019 YTC
	ITEMS
	{
	    func1_DO_mode_GROUP,
		func1_DO_setpoint_GROUP,
		func2_DO_setpoint_GROUP,
		func3_DO_setpoint_GROUP,
		func1_DO_CHECK_BACK,
		COLUMNBREAK,
		func1_DO_ALARM_SUM_Current
	}
}
MENU trans1_yt_discrete_control2
{
	LABEL "Discrete control";
	STYLE PAGE;
	VALIDITY IF (trans1_yt_CONTROL_MODE == 1){TRUE;} ELSE {FALSE;} 	
	ITEMS
	{
		func1_DO_setpoint_GROUP1,
		func2_DO_setpoint_GROUP1,
		func3_DO_setpoint_GROUP1,
		func1_DO_CHECK_BACK,
		COLUMNBREAK,
		func1_DO_ALARM_SUM_Current

	}
}
MENU func1_DO_mode_GROUP
{
	LABEL "Mode";
	STYLE GROUP;
	POST_WRITE_ACTIONS {mode_method}
	ITEMS
	{
	    func1_DO_TARGET_MODE,
		func1_DO_MODE_BLK_Actual
	}
}
MENU trans1_setpoint_GROUP
{
	LABEL "Automatic  (AUTO)";
	STYLE GROUP;
	ITEMS
	{

			trans1_PneumaticActuator_POSITIONING_VALUE_Value,
		        COLUMNBREAK,
			trans1_PneumaticActuator_POSITIONING_VALUE_Status_Quality ,
			trans1_PneumaticActuator_POSITIONING_VALUE_Status_Limit	
	}
}
MENU trans1_output_GROUP
{
	LABEL "Manual  (MAN)";
	STYLE GROUP;
	ITEMS
	{

		func1_AO_OUT_Value,
		COLUMNBREAK,
		func1_AO_OUT_Status_Quality,
		func1_AO_OUT_Status_Limit
	}
}
MENU trans1_postion_GROUP
{
	LABEL "Position";
	STYLE GROUP;
	ITEMS
	{
			trans1_PneumaticActuator_FEEDBACK_VALUE_Value,
		        COLUMNBREAK,
			trans1_PneumaticActuator_FEEDBACK_VALUE_Status_Quality ,
			trans1_PneumaticActuator_FEEDBACK_VALUE_Status_Limit 
	}
}


MENU func1_DO_setpoint_GROUP
{
	LABEL "Valve Open";
	STYLE GROUP;
	ITEMS
	{
		func1_DO_SP_D_Value              ,//(READ_ONLY),
		func1_DO_OUT_D_Value,
                COLUMNBREAK,
		func1_DO_OUT_D_Status_Quality ,     //(READ_ONLY),
		func1_DO_OUT_D_Status_Limit        //(READ_ONLY)		
	}
}
MENU func2_DO_setpoint_GROUP
{
	LABEL "Stop";
	STYLE GROUP;
	ITEMS
	{
		func2_DO_SP_D_Value              ,//(READ_ONLY),
		func2_DO_OUT_D_Value,
                COLUMNBREAK,
		func2_DO_OUT_D_Status_Quality ,     //(READ_ONLY),
		func2_DO_OUT_D_Status_Limit        //(READ_ONLY)	
	}
}
MENU func3_DO_setpoint_GROUP
{
	LABEL "Valve Close";
	STYLE GROUP;
	ITEMS
	{
		func3_DO_SP_D_Value               , //(READ_ONLY),
		func3_DO_OUT_D_Value,
                COLUMNBREAK,
		func3_DO_OUT_D_Status_Quality ,     //(READ_ONLY),
		func3_DO_OUT_D_Status_Limit        //(READ_ONLY)		
	}
}


MENU func1_DO_setpoint_GROUP1
{
	LABEL "Valve Open";
	STYLE GROUP;
	ITEMS
	{
		func1_DO_SP_D_Value (READ_ONLY),
		func1_DO_OUT_D_Value,
                COLUMNBREAK,
		func1_DO_OUT_D_Status_Quality ,     //(READ_ONLY),
		func1_DO_OUT_D_Status_Limit        //(READ_ONLY)		
	}
}
MENU func2_DO_setpoint_GROUP1
{
	LABEL "Stop";
	STYLE GROUP;
	ITEMS
	{
		func2_DO_SP_D_Value (READ_ONLY),
		func2_DO_OUT_D_Value,
                COLUMNBREAK,
		func2_DO_OUT_D_Status_Quality ,     //(READ_ONLY),
		func2_DO_OUT_D_Status_Limit        //(READ_ONLY)	
	}
}
MENU func3_DO_setpoint_GROUP1
{
	LABEL "Valve Close";
	STYLE GROUP;
	ITEMS
	{
		func3_DO_SP_D_Value (READ_ONLY),
		func3_DO_OUT_D_Value,
                COLUMNBREAK,
		func3_DO_OUT_D_Status_Quality ,     //(READ_ONLY),
		func3_DO_OUT_D_Status_Limit        //(READ_ONLY)		
	}
}
CHART trans1_set_point_BarVal
{
	LABEL "Setpoint";
	HELP "Setpoint";
	TYPE HORIZONTAL_BAR;
	MEMBERS
	{
		trans1_yt_chart_member1, trans1_setpoint;
		trans1_yt_chart_member2, trans1_read_back;
	}
}

SOURCE trans1_setpoint
{
	Y_AXIS trans1_setpoint_BarVal_out_axis;
	MEMBERS
	{
		trans1_setpoint_member1, trans1_PneumaticActuator_POSITIONING_VALUE_Value;
	}
}
SOURCE trans1_read_back
{
		Y_AXIS trans1_setpoint_BarVal_out_axis;
	MEMBERS
	{
		trans1_setpoint_member2, trans1_PneumaticActuator_FEEDBACK_VALUE_Value;
	}
}
AXIS trans1_setpoint_BarVal_out_axis
{
	MIN_VALUE 0;
	MAX_VALUE 100;
}



MENU Menu_phys_FACTORY_RESET
{
	LABEL		[menu_Device];
	ACCESS ONLINE;
	ITEMS
	{
		phys_Reset,
//		method_RESET,
		phys_WRITE_LOCKING_page


	}
}
MENU Menu_M_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
										
		std_LoadinPC											
	}
}

MENU Menu_simulation
{
	LABEL		[menu_dialog_simulation];
//	STYLE MENU;
	ITEMS
	{ 
		func1_AI_Simulation


		}
}


MENU Menu_page_partial_stroke
{
	LABEL		"Partial Stroke";
	ACCESS ONLINE;
	STYLE GROUP;
	ITEMS
	{
		trans1_yt_PST_MODE,
		trans1_yt_PST_START_POSITION,
		trans1_yt_PST_TARGET_POSITION_1,
		trans1_yt_PST_TARGET_POSITION_2,
		trans1_yt_PST_TOLLERANCE,
		trans1_yt_PST_INTERVAL,
		trans1_yt_PST_LIMIT_TIME,
		trans1_yt_PST_LATENCY,
		trans1_yt_PST_RESULT1,
		trans1_yt_PST_RESULT1_ERROR,		
		trans1_yt_PST_RESULT2,
		trans1_yt_PST_RESULT2_ERROR, 		
		trans1_yt_PST_RESULT3,
		trans1_yt_PST_RESULT3_ERROR		
	}

}
MENU Tab_page_diagnostics
{
	LABEL		"Diagnostic";
//	ACCESS ONLINE;
	ITEMS
	{
		Tab_page_partial_stroke_config,
        Tab_Deviation_Deadbnad_config,  // As of 11 Sep 2019 YTC
        Tab_Deviation_Time_config
//                trans1_yt_DEVIATION_DEADBAND,
//                trans1_yt_DEVIATION_TIME
	}

}

MENU Tab_Deviation_Deadbnad_config		// As of 11 Sep 2019 YTC
{
    LABEL "Deviation Deadband";
    STYLE GROUP;
    ITEMS
    {
        trans1_PneumaticActuator_TARGET_MODE,
        trans1_PneumaticActuator_MODE_BLK_Actual,
        trans1_yt_DEVIATION_DEADBAND
    }
}

MENU Tab_Deviation_Time_config			// As of 11 Sep 2019 YTC
{
    LABEL "Deviation Time";
    STYLE GROUP;
    ITEMS
    {
        trans1_PneumaticActuator_TARGET_MODE,
        trans1_PneumaticActuator_MODE_BLK_Actual,
        trans1_yt_DEVIATION_TIME
    }
}

MENU Tab_page_partial_stroke_config
{
	LABEL		"Partial Stroke Test";
	STYLE GROUP;
	ITEMS
	{
		phys_TARGET_MODE,
                trans1_PneumaticActuator_MODE_BLK_Actual,
		trans1_yt_PST_MODE,
		trans1_yt_PST_START_POSITION,
		trans1_yt_PST_TARGET_POSITION_1,
		trans1_yt_PST_TARGET_POSITION_2,
		trans1_yt_PST_TOLLERANCE,
		trans1_yt_PST_INTERVAL,
		trans1_yt_PST_LIMIT_TIME,
		trans1_yt_PST_LATENCY,
                method_PST,
                trans1_yt_PST_RESULT1,
		trans1_yt_PST_RESULT1_ERROR,		
		trans1_yt_PST_RESULT2,
		trans1_yt_PST_RESULT2_ERROR, 		
		trans1_yt_PST_RESULT3,
		trans1_yt_PST_RESULT3_ERROR		
	}

}
MENU Tab_page_partial_stroke_result
{
	LABEL		"PST result";
//	ACCESS ONLINE;
	ITEMS
	{
		trans1_yt_PST_RESULT1,
		trans1_yt_PST_RESULT1_ERROR,		
		trans1_yt_PST_RESULT2,
		trans1_yt_PST_RESULT2_ERROR, 		
		trans1_yt_PST_RESULT3,
		trans1_yt_PST_RESULT3_ERROR		
	}

}
MENU Menu_configuration
{
	LABEL		"Configuration";
	ACCESS ONLINE;
	STYLE WINDOW;
	ITEMS
	{
                trans1_PneumaticActuator_TARGET_MODE_PAGE,		
		Page_Parameters,
		Page_Device_setup,
		Page_s_input_table		
	}

}
MENU trans1_PneumaticActuator_TARGET_MODE_PAGE
{
	LABEL		"Mode of Positioner";
	ACCESS ONLINE;
	STYLE PAGE;
	ITEMS
	{
                trans1_PneumaticActuator_TARGET_MODE,
                trans1_PneumaticActuator_MODE_BLK_Actual		
	}

}

MENU Page_Parameters
{
	LABEL		"Parameters" ;
	STYLE PAGE;
	ITEMS
	{
	      IF ((trans1_PneumaticActuator_MODE_BLK_Actual == 0x80)& (phys_WRITE_LOCKING == 2457))
              {		
	               trans1_PneumaticActuator_ST_REV,
		       trans1_PneumaticActuator_DEADBAND,	
		       trans1_PneumaticActuator_SERVO_GAIN_1,
		       trans1_PneumaticActuator_SERVO_RATE_1,
		       trans1_PneumaticActuator_SERVO_RESET_1,
		       trans1_PneumaticActuator_SERVO_GAIN_2,
		       trans1_PneumaticActuator_SERVO_RATE_2,
		       trans1_PneumaticActuator_SERVO_RESET_2,
		       trans1_yt_SERVO_KF
	       }
	       ELSE	
	       {
		       trans1_PneumaticActuator_ST_REV              (READ_ONLY),
		       trans1_PneumaticActuator_DEADBAND            (READ_ONLY),	
		       trans1_PneumaticActuator_SERVO_GAIN_1        (READ_ONLY),
		       trans1_PneumaticActuator_SERVO_RATE_1        (READ_ONLY),
		       trans1_PneumaticActuator_SERVO_RESET_1       (READ_ONLY),
		       trans1_PneumaticActuator_SERVO_GAIN_2        (READ_ONLY),
		       trans1_PneumaticActuator_SERVO_RATE_2        (READ_ONLY),
		       trans1_PneumaticActuator_SERVO_RESET_2       (READ_ONLY),
		       trans1_yt_SERVO_KF                           (READ_ONLY)
                 }
	}
}	

MENU Page_Device_setup
{
	LABEL		"Device Setup" ;
	STYLE PAGE;
	ITEMS
	{
	      IF ((trans1_PneumaticActuator_MODE_BLK_Actual == 0x80)& (phys_WRITE_LOCKING == 2457))
              {				
	               trans1_PneumaticActuator_ST_REV,
		       trans1_yt_ACTING,
                       trans1_yt_ZERO,
		       trans1_yt_SPAN,
		       trans1_PneumaticActuator_SETP_CUTOFF_DEC,
		       trans1_PneumaticActuator_SETP_CUTOFF_INC,
		       trans1_PneumaticActuator_TRAVEL_LIMIT_LOW,
		       trans1_PneumaticActuator_TRAVEL_LIMIT_UP,
		       trans1_yt_ALARM_LO,
		       trans1_yt_ALARM_HI,
		       trans1_yt_DEVIATION_DEADBAND,
		       trans1_yt_DEVIATION_TIME
	       }
	       ELSE	
	       {		       
		       trans1_PneumaticActuator_ST_REV,
		       trans1_yt_ACTING                              (READ_ONLY),
                       trans1_yt_ZERO                                (READ_ONLY),
		       trans1_yt_SPAN                                (READ_ONLY),
		       trans1_PneumaticActuator_SETP_CUTOFF_DEC      (READ_ONLY),
		       trans1_PneumaticActuator_SETP_CUTOFF_INC      (READ_ONLY),
		       trans1_PneumaticActuator_TRAVEL_LIMIT_LOW     (READ_ONLY),
		       trans1_PneumaticActuator_TRAVEL_LIMIT_UP      (READ_ONLY),
		       trans1_yt_ALARM_LO                            (READ_ONLY),
		       trans1_yt_ALARM_HI                            (READ_ONLY),
		       trans1_yt_DEVIATION_DEADBAND                  (READ_ONLY),
		       trans1_yt_DEVIATION_TIME                      (READ_ONLY)
		}       
	}
}
MENU Page_s_input_table
{
	LABEL		[menu_input_table];
	STYLE PAGE;
	ITEMS
	{
	      IF ((trans1_PneumaticActuator_MODE_BLK_Actual == 0x80)& (phys_WRITE_LOCKING == 2457))
              {					
		trans1_PneumaticActuator_LIN_TYPE,
		trans1_tab_y_value_0,
		trans1_tab_y_value_1,
		trans1_tab_y_value_2,
		trans1_tab_y_value_3,
		trans1_tab_y_value_4,
		trans1_tab_y_value_5,
		trans1_tab_y_value_6,
		trans1_tab_y_value_7,
		trans1_tab_y_value_8,
		trans1_tab_y_value_9,
		trans1_tab_y_value_10
	       }
	       ELSE	
	       {
		trans1_PneumaticActuator_LIN_TYPE                     (READ_ONLY),
		trans1_tab_y_value_0                                  (READ_ONLY),
		trans1_tab_y_value_1                                  (READ_ONLY),
		trans1_tab_y_value_2                                  (READ_ONLY),
		trans1_tab_y_value_3                                  (READ_ONLY),
		trans1_tab_y_value_4                                  (READ_ONLY),
		trans1_tab_y_value_5                                  (READ_ONLY),
		trans1_tab_y_value_6                                  (READ_ONLY),
		trans1_tab_y_value_7                                  (READ_ONLY),
		trans1_tab_y_value_8                                  (READ_ONLY),
		trans1_tab_y_value_9                                  (READ_ONLY),
		trans1_tab_y_value_10                                 (READ_ONLY)		
		}
	}
}
		
METHOD std_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	DEFINITION
	{
	}
}

METHOD std_LoadinDevice
{
	LABEL		[menu_Device_LoadinDevice];
	DEFINITION
	{
	}
}

METHOD std_LoadinPC
{
	LABEL		[menu_Device_LoadinPC];
	DEFINITION
	{
	}
}
METHOD metod_keep_oos
{
	CLASS		DEVICE;
	LABEL		"OOS mode";
	DEFINITION
	{
		int iValue;
                PUT_MESSAGE("Mode is unchanged.");   
		  	
	}
}
METHOD method_Autocalibrate
{
	CLASS		DEVICE;
	LABEL		"Auto Calibrate";
	DEFINITION
	{
		int iValue;
		int result;
		long ids[2];
		add_abort_method(metod_keep_oos);
		ACKNOWLEDGE("This will start Auto Calibration. Will you proceed?");             // As of 11 Sep 2019 YTC
		ACKNOWLEDGE("The positioner will be taken into OOS mode. Will you proceed?");	// As of 11 Sep 2019 YTC
		iValue = ivar_value(phys_TARGET_MODE);
		iassign(phys_TARGET_MODE, 0x80);  // OoS
		WriteCommand(phys_TARGET_MODE_write);	


		
    	        result = SELECT_FROM_LIST(" Choose calibration to use ", "Auto 1 ;Auto 2;Auto HF;Cancel");	// As of 11 Sep 2019 YTC
                switch(result)
               {
                  case 0:
	                assign_int(trans1_PneumaticActuator_SELF_CALIB_CMD,8);       
	                WriteCommand(trans1_PneumaticActuator_SELF_CALIB_CMD_write);
		        PUT_MESSAGE("Auto 1 in progress.");
                        DELAY(25,"Wait");
                 break;
                 case 1:
	                assign_int(trans1_PneumaticActuator_SELF_CALIB_CMD,9);       
	                WriteCommand(trans1_PneumaticActuator_SELF_CALIB_CMD_write);
                        PUT_MESSAGE("Auto 2 in progress.");
                        DELAY(25,"Wait");		 
                 break;
                 case 2:
	                assign_int(trans1_PneumaticActuator_SELF_CALIB_CMD,10);       
	                WriteCommand(trans1_PneumaticActuator_SELF_CALIB_CMD_write);
                        PUT_MESSAGE("Auto HF in progress.");
		        DELAY(25,"Wait");
                 break;		 
		 case 3:
		        iassign(phys_TARGET_MODE, 0x08);  // AUTO
		        WriteCommand(phys_TARGET_MODE_write);
                 return;		 
               }				     
		
		do
		{
			ReadCommand(trans1_PneumaticActuator_SELF_CALIB_STATUS_read);

	        }while (trans1_PneumaticActuator_SELF_CALIB_STATUS == 140);

		
                ReadCommand(trans1_PneumaticActuator_SELF_CALIB_STATUS_read);		
		ids[0]=VARID(trans1_PneumaticActuator_SELF_CALIB_STATUS);
                put_message(" %{0}", ids);
		if (trans1_PneumaticActuator_SELF_CALIB_STATUS != 254)
		{
			 PUT_MESSAGE("Calibration unsucessful. Device remains in OOS mode");
                         return;			

	        }			
		
                PUT_MESSAGE("Calibration Completed.");		
		ACKNOWLEDGE("The Auto Calibration is complete. The positioner will be taken into AUTO mode. Will you proceed?");

		
		iValue = ivar_value(phys_TARGET_MODE);
		iassign(phys_TARGET_MODE, 0x08);  // AUTO
		WriteCommand(phys_TARGET_MODE_write);	


	
	}
}
METHOD mode_method
{
	CLASS		DEVICE;
	LABEL		"DO Mode";
	DEFINITION
	{
		int iValue;
		ReadCommand(func1_DO_TARGET_MODE_read);		
		iValue = ivar_value(func1_DO_TARGET_MODE);

		iassign(func2_DO_TARGET_MODE, iValue);   
		iassign(func3_DO_TARGET_MODE, iValue);  		
		WriteCommand(func2_DO_TARGET_MODE_write);	
		WriteCommand(func3_DO_TARGET_MODE_write);
		ReadCommand(func2_DO_MODE_BLK_read);	
		ReadCommand(func3_DO_MODE_BLK_read);		

	}
}
METHOD method_PST
{
	CLASS		DEVICE;
	LABEL		"Perform PST Now";
	DEFINITION
	{
		int iValue;
		long ids[2];
		add_abort_method(metod_keep_oos);		
		ACKNOWLEDGE("This will start Partial Stroke Test. Will you proceed?");
		ACKNOWLEDGE("The positioner will be taken into OOS mode. Will you proceed?");	// As of 11 Sep 2019 YTC
		iValue = ivar_value(phys_TARGET_MODE);
		iassign(phys_TARGET_MODE, 0x80);  // OoS
		WriteCommand(phys_TARGET_MODE_write);	
	


	
	        assign_int(trans1_yt_PSNR_Command,11); 
		WriteCommand(trans1_yt_PSNR_Command_write);
	        PUT_MESSAGE("Partial Stroke Test in progress");
                DELAY(2,"");
		
		do
		{
			ReadCommand(trans1_yt_PSNR_Command_read);

	        }while (trans1_yt_PSNR_Command == 1);

                PUT_MESSAGE("Partial Stroke Test is done");
		

//		PUT_MESSAGE("Partial Stroke Test Completed.");
		ReadCommand(trans1_yt_PST_RESULT1_ERROR_read);
		ReadCommand(trans1_yt_PST_RESULT1_read);
		ReadCommand(trans1_yt_PST_RESULT2_read);
		ReadCommand(trans1_yt_PST_RESULT2_ERROR_read);
                ReadCommand(trans1_yt_PST_REtrans1_PneumaticActuatorSULT3_read);
                ReadCommand(trans1_yt_PST_RESULT3_ERROR_read);		
		ACKNOWLEDGE("The Partial Stroke Test is complete. The positioner will be taken into AUTO mode. Will you proceed?");		
		iValue = ivar_value(phys_TARGET_MODE);
		iassign(phys_TARGET_MODE, 0x08);  // AUTO
		WriteCommand(phys_TARGET_MODE_write);	



	}
}
METHOD method_RESET
{
	CLASS		DEVICE;
	LABEL		"Reset";
	DEFINITION
	{
		int iValue;
		long ids[2];
		ACKNOWLEDGE("This will reset the positioner. Will you proceed?");
		ACKNOWLEDGE("The positioner will be taken into OOS mode. Will you proceed?");	// As of 11 Sep 2019 YTC
		iValue = ivar_value(phys_TARGET_MODE);
		iassign(phys_TARGET_MODE, 0x80);  // OoS
		WriteCommand(phys_TARGET_MODE_write);	

	
	
	        assign_int(trans1_yt_PSNR_Command,254); 
		WriteCommand(trans1_yt_PSNR_Command_write);
	        PUT_MESSAGE("Reset in progress");
                DELAY(30,"");


                PUT_MESSAGE("Reset done");
		
		ACKNOWLEDGE("The positioner will be taken into AUTO mode. Will you proceed?");
		
		iValue = ivar_value(phys_TARGET_MODE);
		iassign(phys_TARGET_MODE, 0x08);  // AUTO
		WriteCommand(phys_TARGET_MODE_write);	



	}
}


/*******************************************************************************/
/*****	Online-Windows  ********************************************************/
/*******************************************************************************/

MENU Menu_S_View
{
	LABEL		[menu_View];

	ITEMS
	{
			
		        Online_display,
			window_yt,
			Online_diagnosis


	}
}
MENU Online_tab
{
	LABEL	"YT-3300" ; 
        ACCESS  ONLINE;	
	ITEMS
	{
		phys_ST_REV,
		trans1_PneumaticActuator_TARGET_MODE,
		trans1_PneumaticActuator_MODE_BLK_Actual,
		Tab_Ident,
		Tab_Operation,
		Tab_Parameters,
		Tab_Auto_Cal
		Tab_Man_Cal,
		Tab_Device_setup,
		Tab_s_input_table,
		Tab_page_diagnostics,
		Tab_s_com,   
		Tab_s_output

	}
}
MENU func1_AO_position_control
{
	LABEL "Measured values (Readback/Setpoint)";
	STYLE PAGE;
	ITEMS
	{
		Func1_AO_set_point_BarVal,
		Func1_AO_readback_GROUP
		Func1_AO_setpoint_GROUP,
//		Func1_AO_rcas_in_GROUP,
//		Func1_AO_rcas_out_GROUP,
		trans1_yt_DEVIATION,
//		func1_AO_SETP_DEVIATION,
		func1_AO_CHECK_BACK,		
		COLUMNBREAK, 
		func1_AO_ALARM_SUM_Current


	}
}
CHART Func1_AO_set_point_BarVal
{
	LABEL "Setpoint";
	HELP "Setpoint";
	TYPE HORIZONTAL_BAR;
	MEMBERS
	{
		Func1_AO_yt_chart_member1, Func1_setpoint, "Setpoint";
		Func1_AO_yt_chart_member2, Func1_read_back, "";
	}
}

SOURCE Func1_setpoint
{
	Y_AXIS trans1_setpoint_BarVal_out_axis;
	MEMBERS
	{
		func1_setpoint_member1, func1_AO_SP_Value;
	}
}
SOURCE Func1_read_back
{
	Y_AXIS func1_setpoint_BarVal_out_axis;
	MEMBERS
	{
		func1_setpoint_member2, func1_AO_READBACK_Value;
	}
}
AXIS func1_setpoint_BarVal_out_axis
{
	MIN_VALUE 0;
	MAX_VALUE 100;
}
MENU Func1_AO_readback_GROUP
{
	LABEL "Actual position";
	STYLE GROUP;
	ITEMS
	{
			func1_AO_READBACK_Value,
		        COLUMNBREAK,
                        func1_AO_READBACK_Status_Quality,
			func1_AO_READBACK_Status_Limit
	}
}
MENU Func1_AO_setpoint_GROUP
{
	LABEL "Setpoint";
	STYLE GROUP;
	ITEMS
	{
			func1_AO_SP_Value (READ_ONLY),
		        COLUMNBREAK,
                        func1_AO_SP_Status_Quality (READ_ONLY),
                        func1_AO_SP_Status_Limit    (READ_ONLY)
	}
}
MENU Func1_AO_output_GROUP
{
	LABEL "Output value";
	STYLE GROUP;
	ITEMS
	{
			func1_AO_OUT_Value,         
		        COLUMNBREAK,
                        func1_AO_OUT_Status_Quality ,
                        func1_AO_OUT_Status_Limit
	}
}
/*MENU Func1_AO_rcas_in_GROUP
{
	LABEL "RCAS In";
	STYLE GROUP;
	ITEMS
	{
			func1_AO_RCAS_IN_Value,
		        COLUMNBREAK,
                        func1_AO_SP_Status_Quality,
                        func1_AO_SP_Status_Limit
	}
}
MENU Func1_AO_rcas_out_GROUP
{
	LABEL "RCAS  Out";
	STYLE GROUP;
	ITEMS
	{
			func1_AO_RCAS_OUT_Value,
		        COLUMNBREAK,
                        func1_AO_SP_Status_Quality,
                        func1_AO_SP_Status_Limit
	}
}*/
MENU Online_display
{
	LABEL		"Measured value display";
        STYLE WINDOW;
	ACCESS ONLINE;
	ITEMS
	{


                func1_AO_position_control,
		trans1_yt_discrete_control2
	}
}


MENU Page_display_measure_1
{
	LABEL		"Position";
	STYLE PAGE;
	ITEMS
	{
//		BarVal_sv_display,trans2_primary_value_value
//		BarVal_sv_display,
//		trans2_modbus_address    (READ_ONLY),		
		trans1_PV_Display_out
//		trans1_sensor_value
	}
}
MENU trans1_PV_Display_out
{
	LABEL "Postion";
	STYLE GROUP;
	ITEMS
	{
                trans1_PneumaticActuator_FEEDBACK_VALUE_Value,	
		trans1_PneumaticActuator_MODE_BLK_Actual,
		COLUMNBREAK,
		trans1_PneumaticActuator_FEEDBACK_VALUE_Status_Quality,
		trans1_PneumaticActuator_FEEDBACK_VALUE_Status_Limit

	}
}   

MENU Tab_Auto_Cal
{
	LABEL		"Auto Calibration";
	ACCESS ONLINE;	
	ITEMS
	{ 
            method_Autocalibrate
	
	}
}






MENU Online_dialog
{
	LABEL		"Set up dialog";
	STYLE DIALOG;
	ACCESS ONLINE;	
	ITEMS
	{ 

		phys_Simple_Dialog_Optional_A,
		func1_AO_Simple_Dialog_Mandatory_B,
		func1_AI_Simple_Dialog_Mandatory_B,
		func1_DO_Simple_Dialog_Mandatory_A,
		func2_DO_Simple_Dialog_Mandatory_A,
		func3_DO_Simple_Dialog_Mandatory_A,
		func1_DI_Simple_Dialog_Mandatory_B,
		func2_DI_Simple_Dialog_Mandatory_B,
		func2_DI_Simple_Dialog_Mandatory_B,
		trans1_PneumaticActuator_Simple_Dialog_Mandatory_B
	
	}
}
MENU trans1_PneumaticActuator_SETP_CUTOFF_LIMIT_page
{
	LABEL		"Travel";
	VALIDITY IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80){TRUE;} ELSE {FALSE;}
	STYLE PAGE;
	ACCESS ONLINE;	
	ITEMS
	{ 
                trans1_PneumaticActuator_RATED_TRAVEL,
		trans1_PneumaticActuator_SETP_CUTOFF_DEC,
		trans1_PneumaticActuator_SETP_CUTOFF_INC,
		trans1_PneumaticActuator_TRAVEL_LIMIT_LOW,
		trans1_PneumaticActuator_TRAVEL_LIMIT_UP

	}
}
MENU trans1_PneumaticActuator_VALUE_page
{
	LABEL		"Position";
	STYLE PAGE;
	ACCESS ONLINE;	
	ITEMS
	{ 
		trans1_PneumaticActuator_POSITIONING_VALUE,
		trans1_PneumaticActuator_FEEDBACK_VALUE	
	}
}
MENU trans1_PneumaticActuator_VALVE_page
{
	LABEL		"Valve";
	STYLE PAGE;
	VALIDITY IF (trans1_PneumaticActuator_MODE_BLK_Actual == 0x80){TRUE;} ELSE {FALSE;}		
	ACCESS ONLINE;	
	ITEMS
	{ 
				trans1_PneumaticActuator_VALVE_MAN,
				trans1_PneumaticActuator_ACTUATOR_MAN,
				trans1_PneumaticActuator_VALVE_TYPE,
				trans1_PneumaticActuator_ACTUATOR_TYPE,
				trans1_PneumaticActuator_ACTUATOR_ACTION
	}
}


MENU func1_AI_ALARM_page
{
	LABEL		"ALARM";
	STYLE PAGE;
	ACCESS ONLINE;	
	ITEMS
	{ 
		func1_AI_HI_HI_LIM,
		func1_AI_HI_LIM,
		func1_AI_LO_LO_LIM,
		func1_AI_LO_LIM,
		func1_AI_ALARM_HYS
	
	}
}
AXIS func1_scale_yt
{
	LABEL "Position";
	MIN_VALUE func1_AI_OUT_SCALE_Upper_Value;
	MAX_VALUE func1_AI_OUT_SCALE_Lower_Value;
}



SOURCE pv_yt_display
{
	Y_AXIS func1_scale_yt;
	MEMBERS
	{
		TEST,  func1_AI_OUT_Value, "Position Feedback";
   
	}
}
SOURCE pv_xt_display
{
	Y_AXIS func1_scale_yt;
	MEMBERS
	{
		TEST,  trans1_PneumaticActuator_POSITIONING_VALUE_Value, "Setpoint";
   
	}
}

MENU window_yt
{
	LABEL		"YT Plot";  
        STYLE DIALOG;
	ITEMS
	{

		windows_yt_1
	}
}
CHART  windows_yt_1
{
	LABEL		"YT plot";
	TYPE STRIP;
        CYCLE_TIME 2000;
	MEMBERS
	{
		 TEST,  pv_yt_display;
		 TEST1, pv_xt_display;

               			
         }		

}

MENU Online_diagnosis
{
	LABEL	"Device status";
        STYLE WINDOW;  //YTC 25 02 2019
	ITEMS
	{
		phys_DIAGNOSIS,
                ROWBREAK,
		device_specific_status_0,   // Error
		device_specific_status_1,   // Warning
                ROWBREAK,
		device_specific_status_2    // Warning2
                ROWBREAK
	}
}




/*******************************************************************************/
/*****	Online-Dialogs  ********************************************************/
/*******************************************************************************/
MENU phys_VIEW_1_page_krohne
{
	LABEL [PI_VIEW_1_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_ST_REV,
		phys_MODE_BLK,
		phys_ALARM_SUM,
		phys_DIAGNOSIS
	}
}
MENU func1_AI_VIEW_1_page_krohne
{
	LABEL [PI_VIEW_1_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AI_ST_REV,
		func1_AI_MODE_BLK,
		func1_AI_ALARM_SUM
	}
}


MENU func1_DI_VIEW_1_page_krohne
{
	LABEL [PI_VIEW_1_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_DI_ST_REV,
		func1_DI_MODE_BLK,
		func1_DI_ALARM_SUM
	}
}

/*******************************************************************************/
/*****	Table: Specialist  *****************************************************/
/*******************************************************************************/

MENU Table_Main_Specialist
{
	LABEL	"YT-3300" ;     
	ITEMS
	{
		phys_ST_REV,
		Tab_Ident,
		Tab_Parameters,
		Tab_Device_setup,
		Tab_s_input_table,
		Tab_s_trans1_setup_wait,
		Tab_s_PST,
		Tab_s_com   
//		Tab_s_output
//		Tab_s_certificates
	}
}
MENU Tab_Ident

{
	LABEL		[menu_ident];

	ITEMS
	{
		phys_TAG_DESC,
		phys_DESCRIPTOR,                                 // Opt A, Opt B
		phys_DEVICE_MESSAGE,                             // Opt A, Opt B
		phys_DEVICE_INSTAL_DATE,			 // Opt A, Opt B
		Tab_Device_Ident,
		Tab_Actuator_Ident, 
		Tab_Valve_Ident
	}
}		
MENU Tab_Device_Ident

{
	LABEL		"Device";

	ITEMS
	{		

		phys_DEVICE_MAN_ID,
		phys_DEVICE_ID,
		phys_DEVICE_SER_NUM,
		phys_yt33000_device_serial_nu,
		phys_SOFTWARE_REVISION,
		phys_HARDWARE_REVISION,		
		phys_IDENT_NUMBER_SELECTOR    (READ_ONLY),
		phys_WRITE_LOCKING            (READ_ONLY)

	}
}
MENU Tab_Actuator_Ident

{
	LABEL		"Actuator";

	ITEMS
	{		
		trans1_PneumaticActuator_ACTUATOR_MAN,
		trans1_PneumaticActuator_ACTUATOR_SER_NUM 		
		trans1_PneumaticActuator_ACTUATOR_TYPE,
		trans1_PneumaticActuator_ACTUATOR_ACTION				
	}
}

MENU Tab_Valve_Ident

{
	LABEL		"Valve";

	ITEMS
	{		
		trans1_PneumaticActuator_VALVE_MAN,
		trans1_PneumaticActuator_VALVE_SER_NUM,		
		trans1_PneumaticActuator_VALVE_TYPE		
	}
}
MENU Tab_Operation

{
	LABEL		"Operation";

	ITEMS
	{
		trans1_yt_CONTROL_MODE,
		trans1_PneumaticActuator_FEEDBACK_VALUE,
		trans1_yt_DEVIATION,
		trans1_PneumaticActuator_TOTAL_VALVE_TRAVEL,
		trans1_PneumaticActuator_POSITIONING_VALUE

	}
}
	

MENU Tab_Parameters
{
	LABEL		"Parameters" ;
	ITEMS
	{	
	               trans1_PneumaticActuator_ST_REV,
		       trans1_PneumaticActuator_DEADBAND,	
		       trans1_PneumaticActuator_SERVO_GAIN_1,
		       trans1_PneumaticActuator_SERVO_RATE_1,
		       trans1_PneumaticActuator_SERVO_RESET_1
		       trans1_PneumaticActuator_SERVO_GAIN_2,
		       trans1_PneumaticActuator_SERVO_RATE_2,
		       trans1_PneumaticActuator_SERVO_RESET_2,
		       trans1_yt_SERVO_KF
	}
}
MENU Tab_Man_Cal
{
	LABEL		"Manual Calibration" ;
	ITEMS
	{	
		       trans1_yt_ZERO,
		       trans1_yt_SPAN
	}
}
MENU Tab_Device_setup
{
	LABEL		"Device Setup" ;
	ITEMS
	{	
	               trans1_PneumaticActuator_ST_REV,
		       trans1_yt_ACTING,
                       trans1_yt_ZERO,
		       trans1_yt_SPAN,
		       trans1_PneumaticActuator_SETP_CUTOFF_DEC,
		       trans1_PneumaticActuator_SETP_CUTOFF_INC,
		       trans1_PneumaticActuator_TRAVEL_LIMIT_LOW,
		       trans1_PneumaticActuator_TRAVEL_LIMIT_UP,
		       trans1_yt_ALARM_LO,
		       trans1_yt_ALARM_HI,
		       trans1_yt_DEVIATION_DEADBAND,
		       trans1_yt_DEVIATION_TIME
	}
}
MENU Tab_s_input_table
{
	LABEL		[menu_input_table];
	ITEMS
	{
		trans1_PneumaticActuator_LIN_TYPE,
		trans1_tab_y_value_0,
		trans1_tab_y_value_1,
		trans1_tab_y_value_2,
		trans1_tab_y_value_3,
		trans1_tab_y_value_4,
		trans1_tab_y_value_5,
		trans1_tab_y_value_6,
		trans1_tab_y_value_7,
		trans1_tab_y_value_8,
		trans1_tab_y_value_9,
		trans1_tab_y_value_10
	}
}
MENU Tab_s_PST
{
	LABEL		"PST" ;
	ITEMS
	{
		trans1_yt_PST_MODE                ,
		trans1_yt_PST_START_POSITION  ,
		trans1_yt_PST_TARGET_POSITION_1 ,
		trans1_yt_PST_TARGET_POSITION_2 ,
		trans1_yt_PST_TOLLERANCE,
		trans1_yt_PST_INTERVAL,
		trans1_yt_PST_LIMIT_TIME,
		trans1_yt_PST_LATENCY,
                trans1_yt_PST_RESULT1,
		trans1_yt_PST_RESULT1_ERROR,		
		trans1_yt_PST_RESULT2,
		trans1_yt_PST_RESULT2_ERROR, 		
		trans1_yt_PST_RESULT3,
		trans1_yt_PST_RESULT3_ERROR
         } 
}  		

MENU Tab_s_com
{
	LABEL		"Communication" ;
	ITEMS
	{
//		phys_DEVICE_MAN_ID,
//		phys_DEVICE_ID,
		phys_BLOCK_OBJECT_DD_Revision,
		phys_BLOCK_OBJECT_Profile_Revision				
         } 
}  	 
MENU Tab_s_trans1_setup_wait
{
	LABEL		"Travel limits" ;
	ITEMS
	{

		       trans1_PneumaticActuator_RATED_TRAVEL,	
		       trans1_PneumaticActuator_TOTAL_VALVE_TRAVEL

	              }	
             }

		

MENU Tab_s_output
{
	LABEL		"Setup of read back";
	ITEMS
	{
		func1_AI_Tab_s_mandatory_B		
	}
}

MENU Tab_s_certificates
{
	LABEL		[menu_certificates];
	ITEMS
	{
//		phys_device_certification	(READ_ONLY)
	}
}


/*******************************************************************************/
/*****	Table: Maintenance  ****************************************************/
/*******************************************************************************/



MENU Table_Main_Maintenance
{
	LABEL	"YT3300";
	ITEMS
	{
		Tab_Ident, 
		trans1_PneumaticActuator_BLOCK_OBJECT_Block_Object,   
		Tab_m_output
		
	}
}
MENU Tab_m_output
{
	LABEL		[menu_output];
	ITEMS
	{
		func1_AI_Tab_m_mandatory_B
		
	}
}
/*******************************************************************************/
/*****	Methods		************************************************************/
/*******************************************************************************/

METHOD method_set
{
	LABEL		[transfer];
	HELP		[transfer_help];
	DEFINITION
	{
	}
}
METHOD pre_read_mode_blk
{
	CLASS		DEVICE;
	LABEL		"Pre read mode block";
	DEFINITION
	{
//fbi		int iValue;
		ReadCommand(func1_AI_MODE_BLK_read);	
 	
	}
}

METHOD method_set_mode_oos
{
	CLASS		DEVICE;
	LABEL		"OOS mode";
	DEFINITION
	{
		int iValue;
//		DELAY(2," This operation will take T511 Out of Service and all parameters will be updated.");
		
		iValue = ivar_value(phys_TARGET_MODE);
		iassign(phys_TARGET_MODE, 0x80);  // Out of service
		WriteCommand(phys_TARGET_MODE_write);	

		iValue = ivar_value(trans1_PneumaticActuator_TARGET_MODE);
		iassign(trans1_PneumaticActuator_TARGET_MODE, 0x80);  // Out of service
		WriteCommand(trans1_PneumaticActuator_TARGET_MODE_write);	
		  	
	}
}
METHOD method_set_mode_auto
{
	CLASS		DEVICE;
	LABEL		"Auto mode";
	DEFINITION
	{

		int iValue;
//		DELAY(2," This will return T511 into Service using the present downloaded configuration.");
		
		iValue = ivar_value(phys_TARGET_MODE);
		iassign(phys_TARGET_MODE, 0x08);  // Auto
		WriteCommand(phys_TARGET_MODE_write);	


		iValue = ivar_value(trans1_PneumaticActuator_TARGET_MODE);
		iassign(trans1_PneumaticActuator_TARGET_MODE, 0x08);  // Auto
		WriteCommand(trans1_PneumaticActuator_TARGET_MODE_write);	
		
			
				
	}
}



/*******************************************************************************/
/*****	Commands  **************************************************************/
/*******************************************************************************/

MENU download_variables
{
	LABEL		[menu_load_to_PC];
	ITEMS
	{
	/* PHYSICAL BLOCK ---------------------	*/
	phys_BLOCK_OBJECT_Reserved,                      // Mand A, Mand B
	phys_BLOCK_OBJECT_Block_Object,                  // Mand A, Mand B
	phys_BLOCK_OBJECT_Parent_Class,                  // Mand A, Mand B
	phys_BLOCK_OBJECT_Class,                         // Mand A, Mand B
//fbi	phys_BLOCK_OBJECT_DD_Reference,                  // Mand A, Mand B
	phys_BLOCK_OBJECT_DD_Revision,                   // Mand A, Mand B
	phys_BLOCK_OBJECT_Profile,                       // Mand A, Mand B
	phys_BLOCK_OBJECT_Profile_Revision,              // Mand A, Mand B
	phys_BLOCK_OBJECT_Execution_Time,                // Mand A, Mand B
	phys_BLOCK_OBJECT_Number_of_Parameters,          // Mand A, Mand B
	phys_BLOCK_OBJECT_Address_of_VIEW_1_Slot,        // Mand A, Mand B
	phys_BLOCK_OBJECT_Address_of_VIEW_1_Index,       // Mand A, Mand B
	phys_BLOCK_OBJECT_Number_of_Views,               // Mand A, Mand B
	phys_ST_REV,                                     // Mand A, Mand B
	phys_TAG_DESC,                                   // Mand A, Mand B
	phys_STRATEGY,                                   // Mand A, Mand B
	phys_ALERT_KEY,                                  // Mand A, Mand B
	phys_TARGET_MODE,                                // Mand A, Mand B
	phys_MODE_BLK_Actual,                            // Mand A, Mand B
	phys_MODE_BLK_Permitted,                         // Mand A, Mand B
	phys_MODE_BLK_Normal,                            // Mand A, Mand B
	phys_ALARM_SUM_Current,                          // Mand A, Mand B
	phys_ALARM_SUM_Unacknowledged,                   // Mand A, Mand B
	phys_ALARM_SUM_Unreported,                       // Mand A, Mand B
	phys_ALARM_SUM_Disabled,                         // Mand A, Mand B
	phys_SOFTWARE_REVISION,                          // Mand A, Mand B
	phys_HARDWARE_REVISION,                          // Mand A, Mand B
	phys_DEVICE_MAN_ID,                              // Mand A, Mand B
	phys_DEVICE_ID,                                  // Mand A, Mand B
	phys_DEVICE_SER_NUM,                             // Mand A, Mand B
	phys_DIAGNOSIS,                                  // Mand A, Mand B
	phys_DIAGNOSIS_MASK,                             // Mand A, Mand B
	phys_IDENT_NUMBER_SELECTOR,                      // Mand B, Opt A
//	phys_FEATURE_Supported,                          // Mand A, Mand B
//	phys_FEATURE_Enabled,                            // Mand A, Mand B
//	phys_COND_STATUS_DIAG,                           // Mand A, Mand B
	phys_DESCRIPTOR,                                 // Opt A, Opt B
	phys_DEVICE_MESSAGE,                             // Opt A, Opt B
	phys_DEVICE_INSTAL_DATE,			 // Opt A, Opt B
	phys_WRITE_LOCKING,
	phys_yt33000_device_serial_nu,

 		
		
		


	/* TRANDSDUCER BLOCK ------------------	*/
//			TRANS1_LOAD_TO_PC,
 
	
			
	/* FUNCTION BLOCK 1: ANALOG INPUT -----	*/
//		TRANS1_LOAD_TO_PC

	func1_AI_ST_REV,
//	func1_AI_PV_SCALE_Upper_Value,       // Mand A, Mand B
//	func1_AI_PV_SCALE_Lower_Value,       // Mand A, Mand B	
//	func1_AI_OUT_SCALE_Upper_Value,      // Mand B, Opt A
//	func1_AI_OUT_SCALE_Lower_Value,      // Mand B, Opt A
//	func1_AI_OUT_SCALE_Units_Index,      // Mand B, Opt A
//	func1_AI_OUT_SCALE_Decimal_Point,    // Mand B, Opt A
	func1_AI_HI_HI_LIM,                  // Mand A, Mand B
	func1_AI_HI_LIM,                     // Mand A, Mand B
	func1_AI_LO_LIM,                     // Mand A, Mand B
	func1_AI_LO_LO_LIM,                  // Mand A, Mand B
	func1_AI_TAG_DESC,                   // Mand A, Mand B
	func1_AI_STRATEGY,                   // Mand A, Mand B
	func1_AI_ALERT_KEY,                  // Mand A, Mand B
	func1_AI_TARGET_MODE,                // Mand A, Mand B
//	func1_AI_BATCH_Batch_ID,             // Mand A, Mand B
//	func1_AI_BATCH_Rup,                  // Mand A, Mand B
//	func1_AI_BATCH_Operation,            // Mand A, Mand B
//	func1_AI_BATCH_Phase,                // Mand A, Mand B
	func1_AI_OUT_Value,                  // Mand A, Mand B
	func1_AI_OUT_Status_Quality,         // Mand A, Mand B
	func1_AI_OUT_Status_Limit,           // Mand A, Mand B
	func1_AI_CHANNEL,                    // Mand B, Opt A
//	func1_AI_PV_FTIME,                   // Mand A, Mand B
	func1_AI_ALARM_HYS,                  // Mand A, Mand B
//	func1_AI_SIMULATE_Status_Quality,    // Mand B, Opt A
//	func1_AI_SIMULATE_Status_Limit,      // Mand B, Opt A
//	func1_AI_SIMULATE_Value,             // Mand B, Opt A
//	func1_AI_SIMULATE_Enabled ,          // Mand B, Opt A

        trans1_PneumaticActuator_ST_REV,
	trans1_tab_y_value_0,
	trans1_tab_y_value_1,
	trans1_tab_y_value_2,
 	trans1_tab_y_value_3,
	trans1_tab_y_value_4,
	trans1_tab_y_value_5,
	trans1_tab_y_value_6,
	trans1_tab_y_value_7,
	trans1_tab_y_value_8,
	trans1_tab_y_value_9,
	trans1_tab_y_value_10,

//	trans1_PneumaticActuator_ACT_STROKE_TIME_DEC,
//	trans1_PneumaticActuator_ACT_STROKE_TIME_INC,
	trans1_PneumaticActuator_TAB_ENTRY,
//        trans1_PneumaticActuator_TAB_X_Y_VALUE_Upper_Value,
//	trans1_PneumaticActuator_TAB_X_Y_VALUE_Lower_Value,
	trans1_PneumaticActuator_TAB_MIN_NUMBER,
	trans1_PneumaticActuator_TAB_MAX_NUMBER,
	trans1_PneumaticActuator_TAB_ACTUAL_NUMBER,
	trans1_PneumaticActuator_DEADBAND,
	trans1_PneumaticActuator_LIN_TYPE,
	trans1_PneumaticActuator_RATED_TRAVEL,
//	trans1_PneumaticActuator_DEVICE_CALIB_DATE,
//	trans1_PneumaticActuator_DEVICE_CONFIG_DATE,
	trans1_PneumaticActuator_SERVO_GAIN_1,
	trans1_PneumaticActuator_SERVO_RATE_1,
	trans1_PneumaticActuator_SERVO_RESET_1,
	trans1_PneumaticActuator_SETP_CUTOFF_DEC,
	trans1_PneumaticActuator_SETP_CUTOFF_INC,
	trans1_PneumaticActuator_TOTAL_VALVE_TRAVEL,
	trans1_PneumaticActuator_TRAVEL_LIMIT_LOW,
	trans1_PneumaticActuator_TRAVEL_LIMIT_UP,
//	trans1_PneumaticActuator_TOT_VALVE_TRAV_LIM,
//	trans1_PneumaticActuator_VALVE_MAINT_DATE,
	trans1_PneumaticActuator_SERVO_GAIN_2,
	trans1_PneumaticActuator_SERVO_RATE_2,
	trans1_PneumaticActuator_SERVO_RESET_2,
//	trans1_PneumaticActuator_TAB_OP_CODE,
//	trans1_PneumaticActuator_TAB_STATUS,
        trans1_PneumaticActuator_VALVE_MAN,
	trans1_PneumaticActuator_ACTUATOR_MAN,
	trans1_PneumaticActuator_VALVE_TYPE,
	trans1_PneumaticActuator_ACTUATOR_TYPE,
	trans1_PneumaticActuator_ACTUATOR_ACTION,
	trans1_PneumaticActuator_VALVE_SER_NUM,
	trans1_PneumaticActuator_ACTUATOR_SER_NUM,
//	  trans1_PneumaticActuator_ADD_GEAR_SER_NUM,
//	  trans1_PneumaticActuator_ADD_GEAR_MAN,
//	  trans1_PneumaticActuator_ADD_GEAR_ID,
//	  trans1_PneumaticActuator_ADD_GEAR_INST_DATE,
		       trans1_yt_ACTING,
		       trans1_yt_ZERO,
		       trans1_yt_SPAN,
		       trans1_yt_CONTROL_MODE,
		       trans1_yt_SERVO_KF,
		       trans1_yt_ALARM_LO,
		       trans1_yt_ALARM_HI,
		       trans1_yt_DEVIATION_DEADBAND,
		       trans1_yt_DEVIATION_TIME,

		trans1_yt_PST_MODE,
		trans1_yt_PST_START_POSITION,
		trans1_yt_PST_TARGET_POSITION_1,
		trans1_yt_PST_TARGET_POSITION_2,
		trans1_yt_PST_TOLLERANCE,
		trans1_yt_PST_INTERVAL,
		trans1_yt_PST_LIMIT_TIME,
		trans1_yt_PST_LATENCY,
                trans1_yt_PST_RESULT1,
		trans1_yt_PST_RESULT1_ERROR,		
		trans1_yt_PST_RESULT2,
		trans1_yt_PST_RESULT2_ERROR, 		
		trans1_yt_PST_RESULT3,
		trans1_yt_PST_RESULT3_ERROR		       



	}
}

MENU upload_variables
{
	LABEL		[menu_load_to_device];
	ACCESS ONLINE;
	PRE_WRITE_ACTIONS {method_set_mode_oos}
	POST_WRITE_ACTIONS {method_set_mode_auto}
        ITEMS
		{
	phys_TAG_DESC,                                   // Mand A, Mand B
	phys_STRATEGY,                                   // Mand A, Mand B
	phys_ALERT_KEY,                                  // Mand A, Mand B
//	phys_TARGET_MODE,                                // Mand A, Mand B
	phys_DESCRIPTOR,                                 // Opt A, Opt B
	phys_DEVICE_MESSAGE,                             // Opt A, Opt B
	phys_DEVICE_INSTAL_DATE,                         // Opt A, Opt B


//	phys_COND_STATUS_DIAG,                           // Mand A, Mand B

//                TRANS1_LOAD_TO_DEVICE,
	 		

//	func1_AI_PV_SCALE_Upper_Value,       // Mand A, Mand B
//	func1_AI_PV_SCALE_Lower_Value,       // Mand A, Mand B
//	func1_AI_LIN_TYPE,                   // Mand B, Opt A
//	func1_AI_OUT_SCALE_Upper_Value,      // Mand B, Opt A
//	func1_AI_OUT_SCALE_Lower_Value,      // Mand B, Opt A
//	func1_AI_OUT_SCALE_Units_Index,      // Mand B, Opt A
//	func1_AI_OUT_SCALE_Decimal_Point,    // Mand B, Opt A
	func1_AI_HI_HI_LIM,                  // Mand A, Mand B
	func1_AI_HI_LIM,                     // Mand A, Mand B
	func1_AI_LO_LIM,                     // Mand A, Mand B
	func1_AI_LO_LO_LIM,                  // Mand A, Mand B
	func1_AI_TAG_DESC,                   // Mand A, Mand B
	func1_AI_STRATEGY,                   // Mand A, Mand B
	func1_AI_ALERT_KEY,                  // Mand A, Mand B
	func1_AI_TARGET_MODE,                // Mand A, Mand B
//	func1_AI_BATCH_Batch_ID,             // Mand A, Mand B
//	func1_AI_BATCH_Rup,                  // Mand A, Mand B
//	func1_AI_BATCH_Operation,            // Mand A, Mand B
//	func1_AI_BATCH_Phase,                // Mand A, Mand B
//	func1_AI_OUT_Value,                  // Mand A, Mand B
//	func1_AI_OUT_Status_Quality,         // Mand A, Mand B
//	func1_AI_OUT_Status_Limit,           // Mand A, Mand B
//	func1_AI_CHANNEL,                    // Mand B, Opt A
//	func1_AI_PV_FTIME,                   // Mand A, Mand B
	func1_AI_ALARM_HYS,                  // Mand A, Mand B
//	func1_AI_SIMULATE_Status_Quality,    // Mand B, Opt A
//	func1_AI_SIMULATE_Status_Limit,      // Mand B, Opt A
//	func1_AI_SIMULATE_Value,             // Mand B, Opt A
//	func1_AI_SIMULATE_Enabled,           // Mand B, Opt A
	
	trans1_tab_y_value_0,
	trans1_tab_y_value_1,
	trans1_tab_y_value_2,
	trans1_tab_y_value_3,
	trans1_tab_y_value_4,
	trans1_tab_y_value_5,
	trans1_tab_y_value_6,
	trans1_tab_y_value_7,
	trans1_tab_y_value_8   
	trans1_tab_y_value_9,
	trans1_tab_y_value_10,

	trans1_PneumaticActuator_TAB_ENTRY,
//	trans1_PneumaticActuator_TAB_X_Y_VALUE_Upper_Value,
//	trans1_PneumaticActuator_TAB_X_Y_VALUE_Lower_Value,
	trans1_PneumaticActuator_DEADBAND,
	trans1_PneumaticActuator_LIN_TYPE,
	trans1_PneumaticActuator_RATED_TRAVEL,
	trans1_PneumaticActuator_SERVO_GAIN_1,
	trans1_PneumaticActuator_SERVO_RATE_1,
	trans1_PneumaticActuator_SERVO_RESET_1,
	trans1_PneumaticActuator_SETP_CUTOFF_DEC,
	trans1_PneumaticActuator_SETP_CUTOFF_INC,
	trans1_PneumaticActuator_TRAVEL_LIMIT_LOW,
	trans1_PneumaticActuator_TRAVEL_LIMIT_UP,
//	trans1_PneumaticActuator_TOT_VALVE_TRAV_LIM,
//	trans1_PneumaticActuator_VALVE_MAINT_DATE,
	trans1_PneumaticActuator_SERVO_GAIN_2,
	trans1_PneumaticActuator_SERVO_RATE_2,
	trans1_PneumaticActuator_SERVO_RESET_2,
        trans1_PneumaticActuator_VALVE_MAN,
	trans1_PneumaticActuator_ACTUATOR_MAN,
	trans1_PneumaticActuator_VALVE_TYPE,
	trans1_PneumaticActuator_ACTUATOR_ACTION,
	trans1_PneumaticActuator_VALVE_SER_NUM,
	trans1_PneumaticActuator_ACTUATOR_SER_NUM,
		       trans1_yt_ACTING,
		       trans1_yt_ZERO,
		       trans1_yt_SPAN,
		       trans1_yt_CONTROL_MODE,
		       trans1_yt_SERVO_KF,
		       trans1_yt_ALARM_LO,
		       trans1_yt_ALARM_HI,
		       trans1_yt_DEVIATION_DEADBAND,
		       trans1_yt_DEVIATION_TIME,
		trans1_yt_PST_MODE,
		trans1_yt_PST_START_POSITION,
		trans1_yt_PST_TARGET_POSITION_1,
		trans1_yt_PST_TARGET_POSITION_2,
		trans1_yt_PST_TOLLERANCE,
		trans1_yt_PST_INTERVAL,
		trans1_yt_PST_LIMIT_TIME,
		trans1_yt_PST_LATENCY





	 
		}

}


/******************* CALIB METHODS ****************************************************************/


VARIABLE write_protect_code
{
	         HANDLING READ;
	LABEL	"Write Protected";
  TYPE ENUMERATED (1)
  {
	   /* Design Note: Leave 240-249 Undefined for future use. */
	   /* Design Note: Any enumerations in the range from 250-255
	      are 'Reserved' for a single definition if not defined. */
	   /* Design Note: Any enumeration not covered by another "Design
	      Note" is 'Undefined'. */

      { 0,   [no], [not_write_protected] },
      { 1,   [yes], [write_protected] },

      { 250, [not_used] },
      { 251, [none] },
      { 252, [unknown] },
      { 253, [special] }
  }
  CLASS LOCAL;
}
VARIABLE alarm_selection_code
{
  LABEL	"Alarm code";
	HANDLING READ;
  TYPE ENUMERATED (1)
  {
	   /* Design Note: These apply to the alarm state of the 
		  physical output of an Analog Output */
	   /* Design Note: Leave 240-249 Undefined for future use. */
	   /* Design Note: Any enumerations in the range from 250-255
	      are 'Reserved' for a single definition if not defined. */
	   /* Design Note: Any enumeration not covered by another "Design
	      Note" is 'Undefined'. */

      { 0,   [high],	  [high_help] },
      { 1,   [low],	  [low_help] },
      { 239, [hold_last_output_value], [hold_last_output_value_help] },
      { 250, [not_used] },
      { 251, [none] },
      { 252, [unknown] },
      { 253, [special] }
  }
  CLASS LOCAL;
}

/*
 * Table 3. Transfer Function Codes
 */
VARIABLE transfer_function_code
{
       HANDLING READ;
	LABEL	"Transfer Function";
	TYPE ENUMERATED (1)
  {
	   /* Design Note: Enumerations 240-249 are reserved for manufacturer
	      specific definitions. Therefore, Host applications should not
	      display meaningful information for these enumerations unless
	      the Host has the Device Description for that specific Field
	      Device. Some Host applications have used a string of the
	      character '?' for this application (e.g. Xfer fnctn:???? */
	   /* Design Note: Any enumerations in the range from 250-255
	      are 'Reserved' for a single definition if not defined. */
	   /* Design Note: Any enumeration not covered by another "Design
	      Note" is 'Undefined'. */

      { 0,   [linear],	   [linear_help] },
		 /* APPHELP "Equation y=mx+b" */
      { 1,   [square_root],[square_root_help] },
		 /* APPHELP "Equation y=sqrt(x)" */
       { 2,   [square_root_to_the_third_power_sup], [square_root_third_power_help] },
		 /* APPHELP "Equation y=sqrt(x^3)" */
       { 3,   [square_root_to_the_fifth_power_sup], [square_root_fifth_power_help] },
		 /* APPHELP "Equation y=sqrt(x^5)" */
       { 4,   [special_curve],[special_curve_help] },
       { 5,   [square],[square_help] },
		 /* APPHELP "Equation y=x^2" */
       { 231, [square_root_plus_special_curve],[square_root_plus_special_curve_help] },
		 /* APPHELP "THE HCF RECOMMENDS THAT ENUMERATION 231 NOT BE"
			    "USED IN NEW IMPLEMENTATIONS !" */
       { 232, [square_root_to_the_third_power_plus_special_curve],[square_root_third_power_plus_special_curve_help] },
		 /* APPHELP "THE HCF RECOMMENDS THAT ENUMERATION 232 NOT BE"
			    "USED IN NEW IMPLEMENTATIONS !" */
       { 233, [square_root_to_the_fifth_power_plus_special_curve],[square_root_fifth_power_plus_special_curve_help] },
		 /* APPHELP "THE HCF RECOMMENDS THAT ENUMERATION 233 NOT BE"
			    "USED IN NEW IMPLEMENTATIONS !" */
/*	 240  Note- Enumeration may be used for manufacturer specific definitions */
/*	 241  Note- Enumeration may be used for manufacturer specific definitions */
/*	 242  Note- Enumeration may be used for manufacturer specific definitions */
/*	 243  Note- Enumeration may be used for manufacturer specific definitions */
/*	 244  Note- Enumeration may be used for manufacturer specific definitions */
/*	 245  Note- Enumeration may be used for manufacturer specific definitions */
/*	 246  Note- Enumeration may be used for manufacturer specific definitions */
/*	 247  Note- Enumeration may be used for manufacturer specific definitions */
/*	 248  Note- Enumeration may be used for manufacturer specific definitions */
/*	 249  Note- Enumeration may be used for manufacturer specific definitions */
       { 250, [not_used] },
       { 251, [none] },
       { 252, [unknown] },
       { 253, [special] }
  }
  CLASS LOCAL;
}
/*METHOD method_start_table_transfer
{
	LABEL		"method_start_table_transfer";
	CLASS		INPUT;
	DEFINITION
	{
		int		n;
		int		error;
		float	y_val[11];
		float	x_val[11];
		char	text[];

		error	= 0;
		
		y_val[0]	= fvar_value(trans1_tab_y_value_0);
		y_val[1]	= fvar_value(trans1_tab_y_value_1);
		y_val[2]	= fvar_value(trans1_tab_y_value_2);
		y_val[3]	= fvar_value(trans1_tab_y_value_3);
		y_val[4]	= fvar_value(trans1_tab_y_value_4);
		y_val[5]	= fvar_value(trans1_tab_y_value_5);
		y_val[6]	= fvar_value(trans1_tab_y_value_6);
		y_val[7]	= fvar_value(trans1_tab_y_value_7);
		y_val[8]	= fvar_value(trans1_tab_y_value_8);
		y_val[9]	= fvar_value(trans1_tab_y_value_9);
		y_val[10]	= fvar_value(trans1_tab_y_value_10);



		x_val[0]	= 0; //fvar_value(trans1_tab_x_value_0);
		x_val[1]	= 10; //fvar_value(trans1_tab_x_value_1);
		x_val[2]	= 20; //fvar_value(trans1_tab_x_value_2);
		x_val[3]	= 30; //fvar_value(trans1_tab_x_value_3);
		x_val[4]	= 40; //fvar_value(trans1_tab_x_value_4);
		x_val[5]	= 50; //fvar_value(trans1_tab_x_value_5);
		x_val[6]	= 60; //fvar_value(trans1_tab_x_value_6);
		x_val[7]	= 70; //fvar_value(trans1_tab_x_value_7);
		x_val[8]	= 80; //fvar_value(trans1_tab_x_value_8);
		x_val[9]	= 90; //fvar_value(trans1_tab_x_value_9);
		x_val[10]	= 100; //fvar_value(trans1_tab_x_value_10);


					

		for (n = 0; n < 11; n++)
		{
			iassign(trans1_PneumaticActuator_TAB_ENTRY, n);
			WriteCommand(trans1_PneumaticActuator_TAB_ENTRY_write);
			fassign(trans1_PneumaticActuator_TAB_X_Y_VALUE_Upper_Value,x_val[n]); 
			fassign(trans1_PneumaticActuator_TAB_X_Y_VALUE_Lower_Value,y_val[n]);
			WriteCommand(trans1_PneumaticActuator_TAB_X_Y_VALUE_write);
		}
	}
}
*/

METHOD method_set_tab_entry	(int entry)
{
	LABEL		"method_set_tab_entry";
	CLASS		DEVICE;
	DEFINITION
	{
//		int num;
//		num = 0;//entry;
		iassign(trans1_PneumaticActuator_TAB_ENTRY, entry);
		WriteCommand(trans1_PneumaticActuator_TAB_ENTRY_write);
	}
}



/*************************************************************************************************************/

